.\" @(#)xlock.man	3.10 96/7/18; Copyright (c) 1991 - Patrick J. Naughton
.\" xlockmore updates from David A. Bagley
.TH XLOCK 1 "18 Jul 1996" "X11R6 Contrib"
.SH NAME
xlock \- Locks the local X display until a password is entered.
.sp
.IX xlock#(1) "" "\fLxlock\fP(1)"
.SH SYNOPSIS
.B xlock
[
.BI \-display " dsp"
]
[
.BI \-help
]
[
.BI \-name " resource-name"
]
[
.BI \-resources
]
[
.BI -/+remote
]
[
.BI -/+mono
]
[
.BI -/+nolock
]
[
.BI -/+allowroot
]
[
.BI -/+enablesaver
]
[
.BI -/+allowaccess
]
[
.BI -/+grabmouse
]
[
.BI -/+echokeys
]
[
.BI -/+usefirst
]
[
.BI -/+v
]
[
.BI -/+inwindow
]
[
.BI -/+inroot
]
[
.BI -/+timeelapsed
]
[
.BI -/+install
]
[
.BI \-delay " usecs"
]
[
.BI \-batchcount " num"
]
[
.BI \-cycles " num"
]
[
.BI \-saturation " value"
]
[
.BI \-nice " level"
]
[
.BI \-timeout " seconds"
]
[
.BI \-lockdelay " seconds"
]
[
.BI \-font " fontname"
]
[
.BI \-bg " color"
]
[
.BI \-fg " color"
]
[
.BI \-mode " modename"
]
[
.BI \-username " textstring"
]
[
.BI \-password " textstring"
]
[
.BI \-info " textstring"
]
[
.BI \-validate " textstring"
]
[
.BI \-invalid " textstring"
]
[
.BI \-cpasswd " crypted-password"
]
[
.BI \-geometry " geom"
]
[
.BI \-icongeometry " geom"
]
[
.BI \-program " programname"
]
[
.BI \-messagesfile " formatted-filename"
]
[
.BI \-messagefile " filename"
]
[
.BI \-message " textstring"
]
[
.BI \-mfont " mode-fontname"
]
[
.BI \-forceLogout " minutes"
]
[
.BI \-logoutButtonLabel " textstring"
]
[
.BI \-logoutButtonHelp " textstring"
]
[
.BI \-logoutFailedString " textstring"
]

.SH DESCRIPTION
.B xlock
locks the X server till the user enters their password at the keyboard.
While
.B xlock
is running,
all new server connections are refused.
The screen saver is disabled.
The mouse cursor is turned off.
The screen is blanked and a changing pattern is put on the screen.
If a key or a mouse button is pressed then the user is prompted for the
password of the user who started
.BR xlock .

If the correct password is typed, then the screen is unlocked and the X
server is restored.  When typing the password Control-U and Control-H are
active as kill and erase respectively.  To return to the locked screen,
click in the small icon version of the changing pattern.

.SH "NOTE ON ETIQUETTE"
.I Xlock
should not be used on public terminals when there is a high demand for them.

If you find a public terminal that has been locked by another user and
there are no other terminals available, and the terminal appears to have
been left idle for a while (normally more than 15 minutes), it is fair to
try to reset the session in some manner.

.SH OPTIONS
.TP 5
.BI \-display \ dsp
The
.I display
option sets the X11 display to lock.
.B xlock
locks all available screens on a given server,
and restricts you to locking only a local server such as
.BI unix:0,
.BI localhost:0,
or
.BI :0
unless you set the
.B \-remote
option.
.TP 5
.BI \-name \ resource-name
.I resource-name
is used instead of
.B XLock
when looking for resources to configure
.BR xlock .
.TP 5
.BI \-mode \ modename
As of this writing there are 45 display modes supported
(plus one more for random selection of one of the 45).
.TP 8
.B ant
Ant mode shows Chris Langton's generalized ants.
.TP 8
.B bat
Bat mode makes bouncing flying bats.
.TP 8
.B blot
Blot mode shows Rorschach's ink blot test.
.TP 8
.B bouboule
Bouboule mode shows moving stars.
.TP 8
.B bounce
Bounce mode shows bouncing footballs.
.TP 8
.B braid
Braid mode shows braids and knots.
.TP 8
.B bug
Bug mode shows bugs evolving and a garden of Eden.
.TP 8
.B clock
Clock mode shows Packard's oclock.
.TP 8
.B demon
Demon mode shows Griffeath's cellular automata.
.TP 8
.B eyes
Eyes mode shows eyes following a bouncing grelb.
.TP 8
.B flag
Flag mode shows a flying flag of your operating system.
.TP 8
.B flame
Flame mode shows weird but cool cosmic flame fractals.
.TP 8
.B forest
Forest mode shows binary trees.
.TP 8
.B galaxy
Galaxy mode makes crashing spinning galaxies.
.TP 8
.B geometry
Morphing of complete graphs.
.TP 8
.B grav
Grav mode shows orbiting planets.
.TP 8
.B helix
Helix mode shows string art.
.TP 8
.B hop
Hop mode shows the "real plane fractals" from the September 1986 issue of
Scientific American.
.TP 8
.B hyper
Hyper mode draws a spinning tesseract in 4D space.
.TP 8
.B image
Image mode shows several logos randomly appearing on the screen. 
.TP 8
.B kaleid
Kaleid mode makes a kaleidoscope.
.TP 8
.B laser
Laser mode shows spinning lasers.
.TP 8
.B life
Life mode shows Conway's game of life.
.TP 8
.B life1d
Life mode shows Wolfram's game of 1D life.
.TP 8
.B life3d
Life3d mode shows Bays' game of 3D life.
.TP 8
.B lightning
Lightning mode displays fractial lightning bolts.
.TP 8
.B lissie
Lissie mode shows lissajous worms.
.TP 8
.B marquee
Marquee mode shows messages.
.TP 8
.B maze
Maze mode shows a random maze and a depth first search solution.
.TP 8
.B mountain
Mountain mode shows a mountain range.
.TP 8
.B nose
Nose mode a man with a big nose runs around spewing out messages to
the screen.
.TP 8
.B petal
Pedal mode shows various mathematical flowers.
.TP 8
.B puzzle
Puzzle mode shows a puzzle being scrambled.
.TP 8
.B pyro
Pyro mode shows fireworks.
.TP 8
.B qix
Qix mode shows the spinning lines similar to the old video game
by the same name.
.TP 8
.B rock
Rock mode shows asteroid field with a twist.
.TP 8
.B rotor
Rotor mode shows a swirling rotorlike thing.
.TP 8
.B shape 
Shape mode makes the stippled rectangles and ellipses.
.TP 8
.B slip
Slip mode slipping blits. 
.TP 8
.B sphere
Sphere mode draws a bunch of shaded spheres.
.TP 8
.B spiral
Helixes of dots.
.TP 8
.B spline
Spline mode shows colorful moving splines, from spline fun #3.
.TP 8
.B swarm
Swarm mode shows a swarm of bees following a wasp.
.TP 8
.B swirl
Swirl mode makes animated swirling patterns.
.TP 8
.B triangle
Triangle mode shows a triangular mountain range.
.TP 8
.B wator
Wator mode makes a Water-Torus planet of fish and sharks.
.TP 8
.B wire
Wire mode makes a circuit with 2 electrons.
.TP 8
.B world
World mode makes the Earth spin.
.TP 8
.B worm
Worm mode shows wiggly worms...
.TP 8
.B blank
Blank mode shows nothing but a black screen.
.TP 8
.B random
Random mode picks a random mode from all of the above except
blank mode.

.TP 5
.BI \-delay \ usecs
The
.I delay
option sets the speed at which a mode will operate.  It simply sets the
number of microseconds to delay between batches of animations.  In
blank mode, it is important to set this to some small number of seconds,
because the keyboard and mouse are only checked after each delay, so you
cannot set the delay too high, but a delay of zero would needlessly
consume cpu checking for mouse and keyboard input in a tight loop, since
blank mode has no work to do.
.TP 5
.BI \-batchcount \ num
The
.I batchcount
option sets number of
.I things
to do per batch to
.I num .

In ant mode this refers the number of ants.

In bat mode it is the number of bats, could be less because of conflicts.

In blot mode this refers to the number of pixels rendered in the same color.

In bouboule mode it is the number of stars.

In bounce mode it is the number of balls, could be less because of conflicts.

In braid mode it is the upper bound number of strands.

In bug mode it is the number of bugs, could be less because of conflicts.

In clock mode it is the percentage of the screen, but less than 100%.

In demon mode this refers the number of colors.

In eyes mode it is the number of eyes.

In flame mode it is the number of levels to recurse (larger = more complex).

In forest mode it is the number trees that make a forest.

In galaxy mode it means the number of galaxies.

In geometry mode it is the number of vertices, random if too large.

In grav mode it is the number of planets.

In helix mode it means nothing.

In hop mode this refers to the number of pixels rendered in the same color.

In hyper mode it means nothing.

In image mode it means it is the number of logos on screen at once.

In kaleid mode it means nothing.

In laser mode it is the number lasers, random if too large.

In life mode it is the number of generations before a glider is introduced.

In life1d mode it means nothing.

In life3d mode it is the number of generations before a glider is introduced.

In lissie mode it is the number of worms.

In marquee mode it means nothing.

In maze mode it is the size of the maze, random if too large.

In mountain mode it is the number of mountains. 

In nose mode it means nothing.

In qix mode it is the number of lines rendered in the same color.

In petal mode it the greatest random number of petals.

In puzzle mode it the number of moves.

In pyro mode it is the maximum number flying rockets at one time.

In rock mode it is the number of asteroids on the screen at once.

In rotor mode it is the number of rotor thingys which whirr...

In shape mode it means nothing.

In slip mode it means nothing.

In sphere mode it means nothing.

In spiral mode it is the number of spirals, random if too large.

In spline mode it is the number of points "splined", random if too large.

In swirl mode it means the number of "knots".

In swarm mode it is the number of bees.

In triangular mode it is the number of mountains. 

In wator mode it means the breed time for the fish.

In wire mode it means the length of the circuit.

In world mode it is the number of worlds.

In worm mode it is the number of worms.

In blank mode it means nothing.

A negative
.I batchcount
allows for randomness.  The range from the minimum allowed nonnegative
.I batchcount
for a particular mode to the
ABS(
.I batchcount
) (or maximum allowed
.I batchcount
, whichever is first).
.TP 5
.BI \-cycles \ num
The
.I cycles
option sets the number of cycles until time out for ant, blot, braid,
bug, clock, demon, eyes, flag, forest, helix, hop, hyper, galaxy, kaleid,
laser, life, life1d, life3d, lissie, mountain, petal, shape, spline,
triangle, and wator, wire.  For qix, worm it is the length of the lines,
for spiral it is the length of the trail of dots.  For bouboule it is the
maximum size of a star and for rock it is the maximum size of a rock.  For
others it means nothing.
.TP 5
.BI \-saturation \ value
The
.I saturation
option sets saturation of the color ramp used to
.I value .
0 is grayscale and 1 is very rich color.  0.4 is a nice pastel.
.TP 5
.BI \-nice \ nicelevel
The
.I nice
option sets system nicelevel of the
.B xlock
process to
.I nicelevel .
.TP 5
.BI \-timeout \ seconds
The
.I timeout
option sets the number of
.I seconds
before the password screen will time out.
.TP 5
.BI \-lockdelay \ seconds
The
.I lockdelay
option sets the number of
.I seconds
before the screen needs a password to be unlocked.  Good for use with
an autolocking mechanism like xautolock(1).
.TP 5
.BI \-font \ fontname
The
.I font
option sets the font to be used on the prompt screen.
.TP 5
.BI \-fg \ color
The
.I fg
option sets the color of the text on the password screen to
.I color .
.TP 5
.BI \-bg \ color
The
.I bg
option sets the color of the background on the password screen to
.I color .
.TP 5
.BI \-username \ textstring
.I textstring
is shown in front of user name, defaults to "Name: ".
.TP 5
.BI \-password \ textstring
.I textstring
is the password prompt string, defaults to "Password: ".
.TP 5
.BI \-info \ textstring
.I textstring
is an informational message to tell the user what to do, defaults to
"Enter password to unlock; select icon to lock.".
.TP 5
.BI \-validate \ textstring
.I textstring
is a message shown while validating the password, defaults to
"Validating login..."
.TP 5
.BI \-invalid \ textstring
.I textstring
is a message shown when password is invalid, defaults to
"Invalid login."
.TP 5
.BI \-geometry \ geom
The
.I geometry
option sets
.I geom
the size and offset of the lock window (normally the entire screen).
The entire screen format is still used for entering the password.  The
purpose is to see the screen even though it is locked.  This should be
used with caution since many of the modes will fail if the windows
are far from square or are too small (size must be greater than 0x0).
This should also be used with -enablesaver to protect screen from
phosphor burn.
.TP 5
.BI \-icongeometry \ geom
The
.I icongeometry
option sets
.I geom
the size of the iconic screen (normally 64x64) seen when entering the
password.  This should be used with caution since many of the modes will
fail if the windows are far from square or are too small (size must be
greater than 0x0).  The greatest size is 256x256.  There should be some
limit so users could see who has locked the screen.  Position
information of icon is ignored.
.TP 5
.BI \-forceLogout \ minutes
The
.I forceLogout
option sets
.I minutes
to auto-logout.  This might not be enforced depending how your system is
configured.
.TP 5
.BI \-logoutButtonLabel \ textstring
.I textstring
is a message shown inside logout button when logout button is displayed.
May not be available, depending how your system is configured.
Defaults to
"Logout".
.TP 5
.BI \-logoutButtonHelp \ textstring
.I textstring
is a message shown outside logout button when logout button is
displayed.  May not be available, depending how your system is
configured.  Defaults to
"Click the \\"Logout\\" button to log out current\\n
user and make workstation available."
.TP 5
.BI \-logoutFailedString \ textstring
.I textstring
is a message shown when a logout is attempted and fails.
May not be available, depending how your system is configured.
Defaults to
"Logout attempt FAILED.\\n
Current user could not be automatically logged out."
.TP 5
.B \-resources
The
.I resources
option prints the default resource file for
.B xlock
to standard output.
.TP 5
.B -/+remote
The
.I remote
option tells
.B xlock
to not stop you from locking remote X11 servers.  This option should be
used with care and is intended mainly to lock X11 terminals which cannot
run
.B xlock
locally.  If you lock someone else's workstation, they will have to know
.B your
password to unlock it.  Using
.I +remote
overrides any resource derived values for
.I remote
and prevents
.B xlock
from being used to lock other X11 servers.  (Use `+' instead of `-' to
override resources for other options that can take the `+' modifier
similarly.)
.TP 5
.B -/+mono
The
.I mono
option causes
.B xlock
to display monochrome, (black and white) pixels rather than the default
colored ones on color displays.
.TP 5
.B +/-nolock
The
.I nolock
option causes
.B xlock
to only draw the patterns and not lock the display.
A key press or a mouse click will terminate the screen saver.
.TP 5
.B -/+allowroot
The
.I allowroot
option allows the root password to unlock the server as well as the user
who started
.BR xlock .
May not be able to turn this on and off depending on your system and how
.B xlock
was configured.
.TP 5
.B -/+enablesaver
By default
.B xlock
will disable the normal X server's screen saver since
it is in effect a replacement for it.  Since it is possible to set delay
parameters long enough to cause phosphor burn on some displays, this
option will turn back on the default screen saver which is very careful
to keep most of the screen black.
.TP 5
.B -/+allowaccess
This option is required for servers which do not allow clients to modify
the host access control list.  It is also useful if you need to run x
clients on a server which is locked for some reason...  When
.I allowaccess
is true, the X11 server is left open for clients to attach and thus
lowers the inherent security of this lock screen.  A side effect of using
this option is that if
.B xlock
is killed -KILL, the access control list is not lost.
.TP 5
.B -/+grabmouse
The
.I grabmouse
option causes
.B xlock
to grab the mouse and keyboard, this is the default.
.B xlock
can not lock the screen without this.
.TP 5
.B -/+echokeys
The
.I echokeys
option causes
.B xlock
to echo '?' characters for each key typed into the password prompt.
Some consider this a security risk, so the default is to not echo
anything. 
.TP 5
.B -/+usefirst
The
.I usefirst
option causes
.B xlock
to use the keystroke which got you to the password screen as the first
character in the password.  The default is to ignore the first key
pressed.
.TP 5
.B -/+v
Verbose mode, tells what options it is going to use.
.TP 5
.B -/+inwindow
Runs
.B xlock
in a window, so that you can iconify, move, or resize it and
still use your screen for other stuff.  When running in a window,
.B xlock
no longer locks your screen, it just looks good.
.TP 5
.B -/+inroot
Runs
.B xlock
in your root window.  Like the
.I inwindow
option it no longer locks the screen, it just looks good.
.TP 5
.B -/+timeelapsed
Allows you to find out how long a machine is locked so you can complain
to an administrator that someone is hogging a machine.
.TP 5
.B -/+install
Allows
.B xlock
to install its own colormap if
.B xlock
runs out of colors.
May not work on with some window managers (fvwm) and does not work with
the -inroot option.
.TP 5
.BI \-program \ programname
The
.I program
option sets the program to be used as the fortune generator.  Currently
used only for marquee and nose modes.
.TP 5
.BI \-messagesfile \ formatted-filename
The
.I messagesfile
option sets the file to be used as the fortune generator.  The first
entry is the number of fortunes, the next line contains the first fortune.
Fortunes begin with a "%%" on a line by itself.  Currently used only for
marquee and nose modes.  If one exists, it takes precedence over the
fortune program.
.TP 5
.BI \-messagefile \ filename
The
.I messagefile
option sets the file where the contents are the message.  Currently
used only for marquee and nose modes.  If one exists, it takes
precedence over the fortune program and messagesfile.
.TP 5
.BI \-message \ textstring
The
.I message
option sets the message.  Currently used only for marquee and nose modes.
If one exists, it takes precedence over the fortune program,
messagesfile and messagefile.
.TP 5
.BI \-mfont \ mode-fontname
The
.I mfont
option sets the font to be used in the mode.  Currently used only for
marquee and nose modes.
.sp
.SH SPECIAL MODE DEPENDENT OPTIONS
.BI \-imagefile \ filename
The
.I imagefile
option sets the ras or xpm file to be displayed with image or puzzle mode.
Raster files work with -install as well.
.TP 5
.BI \-duration \ seconds
Allows one to set a duration for a mode in
.I random.
Duration of 0 is defined as infinite.
.TP 5
.BI \-modelist \ textstring
Allows one to pass a list of files to randomly display to
.I random.
"all" will get all files but blank. "all,blank" will get all modes.
"all,-image bounce,+blank" will get all modes but image and bounce.
"bug wator" will get only bug and wator.  "random" can not be referenced.
.sp
.SH **WARNING**
.B xlock
can appear to hang if it is competing with a high-priority process for
the CPU. For example, if
.B xlock
is started after a process with 'nice -20'
(high priority),
.B xlock
will take  considerable amount of time to respond.
.sp
.SH SHADOW PASSWORDS
If the machine is using a shadow password system, then
.B xlock
may not be set up to get the real password and so must be given one
of its own. This can be either on the command line, via the
.B -cpasswd
option,
or in the file
.BR $HOME/.xlockrc ,
with the first taking precedence.  In both cases an encrypted password
is expected (see makekey(8)).  If neither is given, then
.B xlock
will prompt for a password and will use that, also storing an
encrypted version of it in
.B $HOME/.xlockrc
for future use.
.sp
.SH BUGS
"kill -KILL
.B xlock
" causes the server that was locked to be unusable, since all hosts
(including localhost) were removed from the access control list
to lock out new X clients, and since
.B xlock
could not catch SIGKILL, it terminated before restoring the access
control list.  This will leave the X server in a state where
\fI"you can no longer connect to that server,
and this operation cannot be reversed unless you reset the server."\fP
		-From the X11R4 Xlib Documentation, Chapter 7.
.br
NCD terminals do not allow xlock to remove all the hosts from the access
control list.  Therefore you will need to use the "-remote" and
"-allowaccess" switches.  If you happen to run without "-allowaccess" on an
NCD terminal,
.B xlock
will not work and you will need to reboot the terminal, or simply go into
the SETUP menus, under 'Network Parameters', and turn off TCP/IP access
control. 
.br
.SH SEE ALSO
X(1), Xlib Documentation.
.sp
.SH AUTHOR
Maintained by:
.br
 David A. Bagley      (bagleyd@hertz.njit.edu)
.br
 The latest version is currently at:
.br
 ftp.x.org in /contrib/applications/xlockmore-2.??.tar.gz
.sp
Original Author:
.br
 Patrick J. Naughton	 (naughton@eng.sun.com)
.br
 Mailstop 21-14
.br
 Sun Microsystems Laboratories, Inc.
.br
 Mountain View, CA  94043
.br
 415/336-1080
.sp
with many additional contributors.
.sp
.SH COPYRIGHT
Copyright (c) 1988-91 by Patrick J. Naughton
.br
Copyright (c) 1993-95 by David A. Bagley
.sp
Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation. 
.br
The original BSD daemon is Copyright (c) 1988 Marshall Kirk McKusick.
All Rights Reserved.
.br
Sun, HP, and SGI icons have their respective copyrights.
