 /*-  * xmag - simple magnifying glass application   *:  * $XConsortium: xmag.c,v 1.19 88/10/13 16:52:05 jim Exp $  *7  * Copyright 1988 Massachusetts Institute of Technology   *H  * Permission to use, copy, modify, and distribute this software and itsL  * documentation for any purpose and without fee is hereby granted, providedJ  * that the above copyright notice appear in all copies and that both thatC  * copyright notice and this permission notice appear in supporting K  * documentation, and that the name of M.I.T. not be used in advertising or I  * publicity pertaining to distribution of the software without specific, G  * written prior permission.  M.I.T. makes no representations about the H  * suitability of this software for any purpose.  It is provided "as is"'  * without express or implied warranty.   *(  * Author:  Jim Fulton, MIT X Consortium  */    #include <X11/Xos.h> #include <X11/Xlib.h>  #include <X11/Xutil.h> #include <X11/cursorfont.h>  #include <stdio.h>   #define DEFAULT_BORDER_SIZE 2  #define DEFAULT_CURSOR_SIZE 64 #define DEFAULT_MAGNIFICATION 5   #define DEFAULT_PIX_FONT "fixed"   int Argc;				/* copy of argc */ " char **Argv;				/* copy of argv */  9 char *ProgramName;			/* name of program being executed */ 0 Display *dpy = NULL;			/* X server being used */& int screen;				/* screen being used */. int pixmap_format;			/* XYPixmap or ZPixmap */3 Colormap cmap;				/* colormap to use for drawing */ 9 int ncolormapentries;			/* size of colormap being used */ % Window w;				/* enlargement window */ + Window root;				/* root window of screen */ 6 GC fillGC = (GC) NULL;			/* for drawing enlargement */) Bool do_grab = False;			/* grab server */ 9 char *pix_font = NULL;			/* for displaying pixel value */   . void magnify(), get_source(), repaint_image(); Bool do_magnify();     void programExit (status)      int status;  {      if (dpy) { 	XCloseDisplay (dpy);  	dpy = NULL;     }      (void) exit (status);  }    Usage () { #     static char *help_message[] = {  "    Where options include:",  "", 8 "    -display displaystring        X server to contact",E "    -geometry geomstring          size and location of enlargement", M "    -source geomstring            size and location of area to be enlarged", N "    -mag magfactor                integral amount by which area is enlarged",; "    -bw pixels                    border width in pixels", 1 "    -bd color                     border color", F "    -bg colororpixelvalue         background color or %pixel number",O "    -fn fontname                  name of font for examining enlarged pixels", N "    -z                            grab server during dynamics and XGetImage", "", E "    Options may be abbreviated to the shortest unambiguous prefix.",  "",  NULL
     }, **cpp;   D     fprintf (stderr, "\nUsage: %s [-options ...]\n\n", ProgramName);+     for (cpp = help_message; *cpp; cpp++) {   	fprintf (stderr, "%s\n", *cpp);     }      programExit (1); }      static long parse_long (s)     char *s; {      char *fmt = "%lu";     long retval = 0L;      int thesign = 1;       if (s && s[0]) {+         if (s[0] == '-') s++, thesign = -1; *         if (s[0] == '0') s++, fmt = "%lo";9         if (s[0] == 'x' || s[0] == 'X') s++, fmt = "%lx"; (         (void) sscanf (s, fmt, &retval);     }      return (thesign * retval); }      main (argc, argv) 
     int argc;      char **argv; { %     int i;				/* iterator variable */ @     char *displayname = NULL;		/* name of X server to contact */G     char *source_geometry = NULL;	/* size of square tracking pointer */ ?     char *geometry = NULL;		/* size and location of enlarged */ ?     int magnification = 0;		/* enlarged image will be m by m */ 7     char *border_color = NULL;		/* border color name */ =     char *back_color = NULL;		/* background of enlargement */ 8     int border_width = -1;		/* border width in pixels */       ProgramName = argv[0];     Argc = argc;     Argv = argv;        for (i = 1; i < argc; i++) { 	char *arg = argv[i];   : 	if (arg[0] == '-') {		/* process command line switches */ 	    switch (arg[1]) {/ 	      case 'd':			/* -display displaystring */  		if (++i >= argc) Usage (); 		displayname = argv[i]; 		continue; - 	      case 'g':			/* -geometry geomstring */  		if (++i >= argc) Usage (); 		geometry = argv[i];  		continue; + 	      case 's':			/* -source geomstring */  		if (++i >= argc) Usage (); 		source_geometry = argv[i]; 		continue; + 	      case 'm':			/* -mag magnification */  		if (++i >= argc) Usage ();! 		magnification = atoi (argv[i]);  		continue;  	      case 'b': 		switch (arg[2]) {  		  case 'w':		/* -bw pixels */   		    if (++i >= argc) Usage ();$ 		    border_width = atoi (argv[i]); 		    continue;  		  case 'd':		/* -bd color */  		    if (++i >= argc) Usage (); 		    border_color = argv[i];  		    continue; $ 		  case 'g':		/* -bg colororpixel*/  		    if (++i >= argc) Usage (); 		    back_color = argv[i];  		    continue;  		}			/* end switch */ 		Usage ();  		/* NOTREACHED */ 	      case 'z':			/* -z */  		do_grab = True;  		continue; ' 	      case 'f':			/* -font fontname */  		if (++i >= argc) Usage (); 		pix_font = argv[i];  		continue;  	      default:  		Usage ();  		/* NOTREACHED */ 	    }				/* end switch */- 	} else {			/* any command line parameters */  	    Usage (); 	    /* NOTREACHED */  	}				/* end if else */      }					/* end for */   %     dpy = XOpenDisplay (displayname);      if (!dpy) { : 	fprintf (stderr, "%s:  unable to open display \"%s\".\n",, 		 ProgramName, XDisplayName (displayname)); 	programExit (1);      }        /*G      * get defaults (would be nice to use the resource manager instead)       */   E     if (!pix_font) pix_font = XGetDefault (dpy, ProgramName, "font"); E     if (!pix_font) pix_font = XGetDefault (dpy, ProgramName, "Font");   I     if (!geometry) geometry = XGetDefault (dpy, ProgramName, "geometry"); I     if (!geometry) geometry = XGetDefault (dpy, ProgramName, "Geometry");        if (!source_geometry) A       source_geometry = XGetDefault (dpy, ProgramName, "source");      if (!source_geometry) A       source_geometry = XGetDefault (dpy, ProgramName, "Source");        if (magnification < 1) {= 	char *tmp = XGetDefault (dpy, ProgramName, "magnification"); A 	if (!tmp) tmp = XGetDefault (dpy, ProgramName, "Magnification");   % 	if (tmp) magnification = atoi (tmp);      }        if (border_width < 0) { ; 	char *tmp = XGetDefault (dpy, ProgramName, "borderWidth"); ? 	if (!tmp) tmp = XGetDefault (dpy, ProgramName, "BorderWidth");   7 	border_width = tmp ? atoi (tmp) : DEFAULT_BORDER_SIZE;      }        if (!border_color)  C       border_color = XGetDefault (dpy, ProgramName, "borderColor");      if (!border_color)  C       border_color = XGetDefault (dpy, ProgramName, "BorderColor");        if (!back_color)@       back_color = XGetDefault (dpy, ProgramName, "background");     if (!back_color)  @       back_color = XGetDefault (dpy, ProgramName, "Background");       /*      * set up globals       */   !     screen = DefaultScreen (dpy); )     cmap = DefaultColormap (dpy, screen); 2     ncolormapentries = DisplayCells (dpy, screen);$     root = RootWindow (dpy, screen);K     pixmap_format = (DisplayPlanes (dpy, screen) > 1 ? ZPixmap : XYPixmap);        /*      * do the work      */   6     magnify (geometry, source_geometry, magnification,. 	     border_color, border_width, back_color);       programExit (0); }      /*J  * Do the setup for the magnification.  Use the geometry, source_geometry,H  * and magnification to figure out how big of an area to magnify, and byG  * how much it should be enlarged according to the following relations:   *I  *         magnification = window.geometry.width / source_geometry.width  J  *         magnification = window.geometry.height / source_geometry.height  *H  * Thus, only two of the three values may be specified by the user.  TheJ  * following values are used to indicate that the default should be taken:  *7  *        Variable         blank value    default value   *1  *        magnification        0                5i5  *        window             NULL       "320x320-0-0":4  *        source               NULL          "64x64"  *K  * If a location is not specified for the source, a square centered on the yC  * pointer will be displayed that can be dragged around the screen.a  */r  ? void magnify (window_geometry, source_geometry, magnification,  ) 	 border_color, border_width, back_color)hB     char *window_geometry;		/* size and location of enlargement */;     char *source_geometry;		/* size and location of area */ 0     int magnification;			/* enlargement ratio */?     char *border_color;			/* name of color to use for border */t-     int border_width;			/* width of border */a7     char *back_color;			/* color name or pixel value */  {pI     XSizeHints source_hints, window_hints;  /* for sizes and locations */ M     int source_geom_mask, window_geom_mask;  /* for XParseGeometry results */e4     int params;				/* for which arguments present */=     unsigned long border_pixel;		/* pixel value for border */Z#     int tmp;				/* work variable */ 6     XColor cdef;			/* for parsing border color name */9     unsigned long valuemask;		/* for window attributes */;9     XSetWindowAttributes attr;		/* for creating window */r*     XGCValues gcv;			/* for creating GC */>     unsigned long back_pixel;		/* background of enlargement */  : /*    bzero ((char *) &source_hints, sizeof source_hints);;     bzero ((char *) &window_hints, sizeof window_hints); */e,     source_geom_mask = window_geom_mask = 0;  - #define SizeValues (WidthValue | HeightValue)o #define valNothing 0 #define valMagnification 1 #define valWindow 2w #define valSource 4o #define valAll 7       params = valNothing;  6     if (magnification > 0) params |= valMagnification;       if (window_geometry) {4 	window_geom_mask = XParseGeometry (window_geometry,* 					   &window_hints.x, &window_hints.y,  					   &window_hints.width, 					   &window_hints.height);' 	tmp = (window_geom_mask & SizeValues);  	if (tmp) {a 	    if (tmp == SizeValues)W 	      params |= valWindow; 	 	    elsep' 	      window_geom_mask &= ~SizeValues;a 	}     }-       if (source_geometry) {4 	source_geom_mask = XParseGeometry (source_geometry,* 					   &source_hints.x, &source_hints.y,  					   &source_hints.width, 					   &source_hints.height);' 	tmp = (source_geom_mask & SizeValues);- 	if (tmp) {  	    if (tmp == SizeValues)n 	      params |= valSource; 	 	    else ' 	      source_geom_mask &= ~SizeValues;e 	}     }        /*L      * Check to make sure that user didn't give -geometry, -source, and -mag      */n       if (params == valAll) { H 	fprintf (stderr, "%s:  magnifier size over specified, ignoring -mag\n", 		 ProgramName); 	magnification = 0;t 	params &= ~valMagnification;"     }        /*9      * Verify the input and compute the appropriate sizes       */,  <     if ((params & valMagnification) && magnification <= 0) {1 	fprintf (stderr, "%s:  bad magnification %d.\n",E 		 ProgramName, magnification);s 	programExit (1);r     } ;     if ((params & valWindow) && (window_hints.width <= 0 ||s! 				 window_hints.height <= 0)) { 2 	fprintf (stderr, "%s:  bad window size %dx%d.\n",9 		 ProgramName, window_hints.width, window_hints.height);  	programExit (1);,     }";     if ((params & valSource) && (source_hints.width <= 0 || ! 				 source_hints.height <= 0)) { 2 	fprintf (stderr, "%s:  bad source size %dx%d.\n",9 		 ProgramName, source_hints.width, source_hints.height);p 	programExit (1);      }        switch (params) {        case valMagnification:@ 	source_hints.width = source_hints.height = DEFAULT_CURSOR_SIZE; 	goto mag_and_cur;         case valWindow: ' 	magnification = DEFAULT_MAGNIFICATION;  	/* fall through */ &       case valMagnification|valWindow:9 	source_hints.width = window_hints.width / magnification; ; 	source_hints.height = window_hints.height / magnification;t 	break;l         case valNothing:@ 	source_hints.width = source_hints.height = DEFAULT_CURSOR_SIZE; 	/* fall through */        case valSource: ' 	magnification = DEFAULT_MAGNIFICATION;e 	/* fall through */i&       case valMagnification|valSource:       mag_and_cur:9 	window_hints.width = source_hints.width * magnification;;; 	window_hints.height = source_hints.height * magnification;  	break;+         case valWindow|valSource:a9 	magnification = window_hints.width / source_hints.width;t1 	tmp = window_hints.height / source_hints.height;o. 	if (tmp < magnification) magnification = tmp; 	break;g     }i       /*I      * At this point, both hints structures contain the appropriate widthnH      * and height fields.  Now we need to do the placement calculations.      */   F     if ((window_geom_mask & XValue) && (window_geom_mask & XNegative))E       window_hints.x = DisplayWidth (dpy, screen) + window_hints.x - e' 	window_hints.width - border_width * 2;   F     if ((window_geom_mask & YValue) && (window_geom_mask & YNegative))E       window_hints.y = DisplayHeight (dpy, screen) + window_hints.y -d( 	window_hints.height - border_width * 2;  F     if ((source_geom_mask & XValue) && (source_geom_mask & XNegative))E       source_hints.x = DisplayWidth (dpy, screen) + source_hints.x - _ 	source_hints.width;  F     if ((source_geom_mask & YValue) && (source_geom_mask & YNegative))E       source_hints.y = DisplayHeight (dpy, screen) + source_hints.y -a 	source_hints.height;H       /*:      * Set the flags entries so that we know what we have       */s       source_hints.flags = 0;d!     source_hints.flags |= USSize;bD     if ((source_geom_mask & XValue) && (source_geom_mask & YValue)) '       source_hints.flags |= USPosition;        window_hints.flags = 0;b!     window_hints.flags |= USSize;iD     if ((window_geom_mask & XValue) && (window_geom_mask & YValue)) '       window_hints.flags |= USPosition;)  G     if (border_color && XParseColor (dpy, cmap, border_color, &cdef) &&g" 	XAllocColor (dpy, cmap, &cdef)) { 	border_pixel = cdef.pixel;g     } else {) 	border_pixel = BlackPixel (dpy, screen);t     }   E     window_hints.width_inc = window_hints.height_inc = magnification;r%     window_hints.flags |= PResizeInc;_  *     back_pixel = BlackPixel (dpy, screen);     if (back_color) {o
 	XColor cdef;   2 	if (back_color[0] == '%') {	/* pixel specifier */ 	    char *fmt = "%lu";a' 	    register char *s = back_color + 1;p   	    if (!*s) Usage ();i 	    if (*s == '0') {n 		s++; 		fmt = "%lo"; 	    }" 	    if (*s == 'x' || *s == 'X') { 		s++; 		fmt = "%lx"; 	    }7 	    if (sscanf (s, fmt, &border_pixel) != 1) Usage ();(9 	} else if (XParseColor (dpy, cmap, back_color, &cdef) && & 		   XAllocColor (dpy, cmap, &cdef)) { 	    back_pixel = cdef.pixel;  	}     }r       /*3      * Make the enlargment window, but don't map itf      */_  '     attr.background_pixel = back_pixel;(%     attr.border_pixel = border_pixel; B     attr.event_mask = (ExposureMask|ButtonPressMask|KeyPressMask);=     attr.cursor = XCreateFontCursor (dpy, XC_top_left_arrow);eG     valuemask = (CWBackPixel | CWBorderPixel | CWEventMask | CWCursor);l  "     w = XCreateWindow (dpy, root, ) 		       window_hints.x, window_hints.y, p1 		       window_hints.width, window_hints.height,d2 		       border_width, DefaultDepth (dpy, screen),; 		       CopyFromParent, CopyFromParent, valuemask, &attr);p  E     XSetStandardProperties (dpy, w, "Magnifying Glass", "xmag", None,o" 			    Argv, Argc, &window_hints);       /*      * Make up a dummy GC       */r     gcv.function = GXcopy;     gcv.plane_mask = AllPlanes;h     gcv.fill_style = FillSolid;y+     /* repaint_image fills in foreground */i  I     fillGC = XCreateGC (dpy, w, (GCFunction | GCPlaneMask | GCFillStyle),r	 			&gcv);n       /*F      * Do the work.  If the user specified the location of the source,;      * then just that one spot, otherwise do some dynamics.o      */y  *     if (source_hints.flags & USPosition) { 	if (do_grab) {t6 	    XGrabServer (dpy);		/* ungrab is in do_magnify */ 	    XSync (dpy, 0); 	}@ 	(void) do_magnify (&source_hints, &window_hints, magnification, 			   back_pixel);     } else { 	do {  	    if (do_grab) {o2 		XGrabServer (dpy);	/* ungrab is in do_magnify */ 	    } 	    XSync (dpy, 1);  	    get_source (&source_hints);B 	} while (do_magnify (&source_hints, &window_hints, magnification, 			     back_pixel));e     }t       return;r }l   #define NITERATIONS 6eM #define NPOINTS (1 + (NITERATIONS * 2 * 4))  /* 1 move, 2 inverts, 4 sides */m   void get_source (shp)      XSizeHints *shp; {h     register int x, y;1     int width = shp->width, height = shp->height;mJ     int dw = DisplayWidth (dpy, screen), dh = DisplayHeight (dpy, screen);C     Window root_window, child_window, root_x, root_y, win_x, win_y;	,     int xoff = width / 2, yoff = height / 2;     XPoint box[NPOINTS];     int lastx, lasty;r     unsigned long mask;n     Bool done;H     static GC invGC = (GC) NULL;	/* for drawing source region outline */     static Cursor invCursor;  0     if (!invGC) {			/* make it the first time */ 	XGCValues gcv;n   	gcv.function = GXxor;' 	gcv.subwindow_mode = IncludeInferiors;o$ 	gcv.foreground = (unsigned long) 1;A 	gcv.plane_mask = (unsigned long) 1;  /* only diddle first bit */o  > 	invGC = XCreateGC (dpy, root, (GCFunction | GCSubwindowMode |. 				       GCForeground | GCPlaneMask), &gcv); 	if (!invGC) {; 	    fprintf (stderr, "%s:  unable to create invert GC.\n",  		     ProgramName); 	    programExit (1);u 	}3 	invCursor = XCreateFontCursor (dpy, XC_crosshair);t     }o    8     if (XGrabPointer (dpy, root, False, ButtonPressMask,+ 		      GrabModeAsync, GrabModeAsync, None,o1 		      invCursor, CurrentTime) != GrabSuccess) {|@ 	fprintf (stderr, "%s:  unable to grab pointer\n", ProgramName); 	programExit (1);w     }n       /*K      * Do the loop looking for a button press, drawing the image each time; N      * since other clients may be running, make sure that the xor segments all$      * get drawn at the same time.        */n   #define FAROFFSCREEN -9999  ?     for (done = False, lastx = lasty = FAROFFSCREEN; !done; ) {p 	if (XPending (dpy) != 0) {l 	    XEvent event;   	    XNextEvent (dpy, &event);   	    switch (event.type) { 	      case ButtonPress:  		root_x = event.xbutton.x_root;  		root_y = event.xbutton.y_root; 		done = True; 		break; 	      default:g@ 		fprintf (stderr, "%s:  warning unhandled event %lu = 0x%lx\n",) 			 ProgramName, event.type, event.type);g 		continue;( 	    }				/* end switch */C 	} else if (!XQueryPointer (dpy, root, &root_window, &child_window,l2 				   &root_x, &root_y, &win_x, &win_y, &mask)) {F 	    fprintf (stderr, "%s:  unable to QueryPointer on root window.\n", 		     ProgramName); 	    programExit (1);* 	}* 	if (root_x != lastx || root_y != lasty) { 	    register int i;   	    /* clip to screen */    	    x = root_x - xoff;  	    y = root_y - yoff;r 	    if (x < 0) x = 0; 	    if (y < 0) y = 0;- 	    if (x + width >= dw) x = dw - 1 - width;t/ 	    if (y + height >= dh) y = dh - 1 - height;i  " 	    /* fill in the outline box */  ' 	    for (i = 0; i < NPOINTS; i += 4) {") 		box[i].x = x; box[i].y = y;	 /* u.l. */r  		if (i == (NPOINTS - 1)) break;5 		box[i+1].x = x + width; box[i+1].y = y;  /* u.r. */w? 		box[i+2].x = box[i+1].x; box[i+2].y = y + height;  /* l.r. */s6 		box[i+3].x = x; box[i+3].y = box[i+2].y;  /* l.l. */ 	    } 	    lastx = root_x; 	    lasty = root_y; 	}  > 	XDrawLines (dpy, root, invGC, box, NPOINTS, CoordModeOrigin);     }e&     XUngrabPointer (dpy, CurrentTime);     XFlush (dpy);%       shp->x = x;a     shp->y = y;w       return;n }h  5 Bool do_magnify (shp, whp, magnification, back_pixel)s     XSizeHints *shp, *whp;     int magnification;     unsigned long back_pixel;A {_I     int x = shp->x, y = shp->y, width = shp->width, height = shp->height;=J     int dw = DisplayWidth (dpy, screen), dh = DisplayHeight (dpy, screen);     XImage *image;     Bool done, domore;       /* m:      * Don't get bits that are off the edges of the screen      */a       if (x < 0) x = 0;      if (y < 0) y = 0;c,     if (x + width >= dw) x = dw - 1 - width;.     if (y + height >= dh) y = dh - 1 - height;  7     image = XGetImage (dpy, root, x, y, width, height, a'     		       AllPlanes, pixmap_format);o       if (do_grab) { 	XUngrabServer (dpy);t 	XSync (dpy, 0);     }d       if (!image) return (False);.       /*?      * Map the window and do the work.  Space means do another;i*      * Button1 press displays pixel value.      * q, Q, or ^C mean quit.t      */w  5     domore = False;			/* ButtonPress will override */g       XMapWindow (dpy, w);!     for (done = False; !done; ) {  	XEvent event;"         XButtonEvent *buttonevent;         XColor def;  	int len,first;  	char keybuffer[10];   	XNextEvent (dpy, &event); 	switch (event.type) { 	  case Expose: > 	    repaint_image (image, &event, magnification, back_pixel); 	    break;i6 	  case ButtonPress:		/* by John Bradley, U of Penn */  2             buttonevent = (XButtonEvent *) &event;1             if (buttonevent->button != Button1) {  		domore = done = True;e 		break; 	    }             first = 1;A 	    MapPixWindow (w, (buttonevent->y/magnification < height/2)); <             while (1) {     /* loop until button released */$                 Window rootW,childW;$                 int rx,ry,x,y,lx,ly;"                 unsigned int mask;                 char str[64];a  N                 if (XQueryPointer(dpy,w,&rootW,&childW,&rx,&ry,&x,&y,&mask)) {N                     if (!(mask & Button1Mask)) break;    /* button released */                     <                     x /= magnification;  y /= magnification;   		    /* look for new pixel */9                     if ((first || x != lx || y != ly) && s3 			(x >= 0 && x < width && y >= 0 && y < height)) {b<                         def.pixel = XGetPixel (image, x, y);8 			if (def.pixel >= 0 && def.pixel < ncolormapentries) {% 			    XQueryColor (dpy, cmap, &def);( 			    sprintf (str, o: 			        "Pixel at (%d,%d):  %3ld   (%04x, %04x, %04x)",: 			        x, y, def.pixel, def.red, def.green, def.blue); 			} else {e* 			    def.red = def.green = def.blue = 0;/ 			    sprintf (str, "Pixel at (%d,%d):  %3ld",c 				     x, y, def.pixel); 			}             ,                         DrawPixWindow (str);4                         first = 0;  lx = x;  ly = y; 		    }_ 		} else
 		  break; 	    }             UnmapPixWindow (); 	    break;g   	  case KeyPress:c> 	    len = XLookupString (&event, keybuffer, sizeof keybuffer, 				 NULL, NULL);oC 	    if (len == 1 && (keybuffer[0] == 'q' || keybuffer[0] == 'Q' ||;" 			     keybuffer[0] == '\003')) {, 		domore = False;		/* q, Q, or ^C to quit */ 		done = True;2 	    } else if (len == 1 && keybuffer[0] == ' ') {) 		domore = True;		/* space to continue */x 		done = True; 	    }				/* else ignore */n 	    break;o 	}     }t     XUnmapWindow (dpy, w);       /*       * free the image and return      */i       XDestroyImage (image);     return (domore); }s  = void repaint_image (image, eventp, magnification, back_pixel)r     XImage *image;     XEvent *eventp;m     int magnification;     unsigned long back_pixel;r {)F     XExposeEvent *ev = &eventp->xexpose;  /* to get repaint section */1     int e_row, e_column;		/* expose dimensions */iF     int r_x, r_y, r_width, r_height;	/* filled rectangle dimensions */6     XGCValues gcv;			/* for doing filled rectangles */&     int row, column;			/* iterators */>     int initialx, maxrow, maxcolumn;	/* avoid recomputation */2     unsigned long pixel;		/* image pixel values */B     unsigned long prev_pixel;		/* last pixel set with XChangeGC */  -     gcv.foreground = prev_pixel = back_pixel;e0     XChangeGC (dpy, fillGC, GCForeground, &gcv);       /*=      * figure out where in the image we have to start and end*      */D  "     e_row = ev->y / magnification;%     e_column = ev->x / magnification;u(     initialx = e_column * magnification;     maxrow = e_row +E       ((ev->y + ev->height + magnification - 1) / magnification) - 1;v     maxcolumn = e_column +D       ((ev->x + ev->width + magnification - 1) / magnification) - 1;       /*      * clip to image size	      */p  @     if (maxcolumn >= image->width) maxcolumn = image->width - 1;<     if (maxrow >= image->height) maxrow = image->height - 1;       /*K      * Repaint the image; be somewhat clever by only drawing when the pixels-      * changes or when we run out of lines.  t      */e  /     r_y = e_row * magnification;	/* to start */T=     r_height = magnification;		/* always doing just 1 line */m       /*$      * iterate over scanlines (rows)      */   -     for (row = e_row; row <= maxrow; row++) {e+ 	r_x = initialx;			/* start at beginning */t. 	r_width = 0;			/* have done nothing so far */   	/* - 	 * iterate over pixels in scanline (columns)y 	 */  9 	for (column = e_column; column <= maxcolumn; column++) { , 	    pixel = XGetPixel (image, column, row);   	    /*dB 	     * If the current pixel is different from the previous pixel,A 	     * then we need to set the drawing color and do the previous A 	     * rectangle.  We can also avoid extra calls to XChangeGC by B 	     * keeping track of the last value we set (note that this mayB 	     * be different from gcv.foreground if the latter is the same@ 	     * as back_pixel).  This is most useful when magnifying the: 	     * background stipple pattern on monochrome displays. 	     */# 	    if (pixel != gcv.foreground) {f 		/*? 		 * We only need to draw the rectangle if it isn't background.a 		 */ 4 		if (gcv.foreground != back_pixel && r_width > 0) {) 		    if (gcv.foreground != prev_pixel) {f/ 			XChangeGC (dpy, fillGC, GCForeground, &gcv);, 			prev_pixel = gcv.foreground;A 		    }e% 		    XFillRectangle (dpy, w, fillGC,G% 				    r_x, r_y, r_width, r_height);  		}			/* end if */ 		r_x += r_width;; 		gcv.foreground = pixel;n 		r_width = 0; 	    }				/* end if */ 	    r_width += magnification; 	}				/* end for */  	/*n  	 * draw final rectangle on line 	 */3 	if (gcv.foreground != back_pixel && r_width > 0) { ( 	    if (gcv.foreground != prev_pixel) {. 		XChangeGC (dpy, fillGC, GCForeground, &gcv); 		prev_pixel = gcv.foreground; 	    }B 	    XFillRectangle (dpy, w, fillGC, r_x, r_y, r_width, r_height); 	}				/* end if */  6 	r_y += magnification;		/* advance to next scanline */     }					/* end for */t       XFlush (dpy);r     return;= }u     static Window pixwind = None;p$ static XFontStruct *pixfinfo = NULL;   MapPixWindow (wind, bot)     Window wind;     int bot; {)  E     /* creates a small window inside of 'wind', at the top or bottom,(G        suitable for displaying one line of text.  Also loads in a font ,@        if necessary; John Bradley, University of Pennsylvania */       Window rootW;n     int x,y;'     unsigned int w,h,bwide,depth,thigh;i  E     XGetGeometry (dpy, wind, &rootW, &x, &y, &w, &h, &bwide, &depth);        if (!pixfinfo) {, 	if (!pix_font) pix_font = DEFAULT_PIX_FONT;+ 	pixfinfo = XLoadQueryFont (dpy, pix_font);  	if (!pixfinfo) {w8 	    fprintf (stderr, "%s:  unable to load font '%s'\n", 		     ProgramName, pix_font); 	    programExit (1);  	}     }   5     thigh = pixfinfo->ascent + pixfinfo->descent + 4;o      y = (bot ? (h - thigh) : 0);       if (pixwind == None) {' 	XSetFont (dpy, fillGC, pixfinfo->fid); ; 	pixwind = XCreateSimpleWindow (dpy, wind, 0, y, w, thigh,  . 				       0, None, BlackPixel (dpy, screen));     } else {" 	XMoveWindow (dpy, pixwind, 0, y);     }l       XMapWindow (dpy, pixwind); }y     DrawPixWindow (str)T
 char *str; {g      XClearWindow (dpy, pixwind);;     XSetForeground (dpy, fillGC, WhitePixel (dpy, screen)); ?     XDrawString (dpy, pixwind, fillGC, 4, 2 + pixfinfo->ascent,m 		 str, strlen (str)); }      UnmapPixWindow() {;      XUnmapWindow (dpy, pixwind); }d                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              