 /*	 
 **  Xodometer " **  Written by Mark H. Granoff/mhg, **             Digital Equipment Corporation! **             Littleton, MA, USA  **             17 March 1993 **  K **  If you make improvements or enhancements to Xodometer, please send them 9 **  back to the author at any of the following addresses:  ** **		granoff@keptin.lkg.dec.com **		granoff@UltraNet.com **		72301.1177@CompuServe.com  **N **  Thanks to my friend and colleague Bob Harris for his suggestions and help. **  N **  This software is provided as is with no warranty of any kind, expressed orK **  implied. Neither Digital Equipment Corporation nor Mark Granoff will be 3 **  held accountable for your use of this software.  **  M **  This software is released into the public domain and may be redistributed I **  freely provided that all source module headers remain intact in their M **  entirety, and that all components of this kit are redistributed together.  **   **  Modification History **  --------------------) **  19 Mar 1993	mhg	v1.0	Initial release. < **   3 Aug 1993 mhg	v1.2	Added automatic trip reset feature.G **   5 Jan 1994 mhg	v1.3	Ported to Alpha; moved mi/km button into popup 2 **				menu; removed 'Trip' fixed label; added font **				resource. E **   6 Jan 1994 mhg	x1.4	Main window no longer grabs input focus when  **				realized. E **  21 Nov 1994	mhg	x1.4	Added saveFile resource to make location and . **				name of odometer save file customizable.9 **   6 Mar 1995 mhg	x1.5	Added automatic html generation. C **   9 Mar 1995 mhg	x1.6	Converted file to format with verion info! ) **				Changed .format resource to .units. 3 **				Improved measurement unit handling and update 2 **				accuracy. Removed unneccesary label updates.F **  19 Apr 1995 mhg	V2.0	Removed OpenVMS-specific AST code in favor of5 **				XtAppAddTimeout. (Works a lot better now, too.) B **  26 Apr 1995 mhg	X2.1-1  Fix trip reset so units is also reset.I **  27 Apr 1995 mhg	X2.1-2  Changed AutoReset timer to be its own timeout 0 **				on a relative timer based on seconds until **				midnight. K **  28 Apr 1995	mhg	X2.1-3  Added pollInterval and saveFrequency resources. K **   1 May 1995 mhg	X2.1-4	Make disk writing (data, html) deferred so as to 4 **				to allow for "continuous" display update while **				mouse is in motion. K **  27 Oct 1995 mhg	V2.1	Final cleanup for this version and public release.  */	    #define module_name XODOMETER  #define module_vers "V2.1"  ' #if defined(__alpha) || defined(__decc) & #pragma module module_name module_vers #pragma nostandard #else  /* __vax */ #module module_name module_vers  #endif /* __alpha */   #ifdef __alpha #pragma standard #endif /* __alpha */   #include <stdio.h> #include <math.h>  #include <ctype.h> #include <time.h>  #include <file.h>  #include <X11/Xlib.h>  #include <X11/Xutil.h> #include <X11/Xatom.h> #include <X11/StringDefs.h>  #include <X11/MwmUtil.h> #include <Xm/Xm.h> #include <Xm/MainW.h>  #include <Xm/Label.h>  #include <Xm/RowColumn.h>  #include <Xm/CascadeB.h> #include <Xm/PushB.h>  #include <Xm/ToggleB.h>  #include "Xodometer.bit" /* module level stuff */   typedef enum _units { ( 	      	  inch = 0, foot, mile, MAX_UNIT 	      } Units;     typedef struct conversionEntry { 	    Units fromUnit; 	    char *fromUnitTag;  	    char *fromUnitTagPlural;  	    double maxFromBeforeNext; 	    double conversionFactor;  	    char *toUnitTag;  	    char *toUnitTagPlural;  	    double maxToBeforeNext; 	    int *printPrecision;  	    }; conversionEntry;  ; static	struct conversionEntry ConversionTable[MAX_UNIT] = { P     { inch, "inch", "inches", 12.0,   2.54,     "cm",     "cm",     100.0,  3 },P     { foot, "foot", "feet",   5280.0, 0.3048,    "meter", "meters", 1000.0, 4 },R     { mile, "mile", "miles",  -1.0,   1.609344, "km",     "km",     -1.0,   5 } };  % static	char progName[] = "Xodometer"; & static	char progClass[] = "Xodometer";$ static  char progVersion[] = "v2.1"; #define MAJOR_VERSION 2  #define MINOR_VERSION 0  XtAppContext appContext; XtIntervalId updateTimerId;  XtIntervalId resetTimerId; static	Display *display;, static	Window root, *RootIDRet, *ChildIDRet; static	int WinX, WinY; static	unsigned int StateMask; static  XrmDatabase db; " static	int XCoord = 0, YCoord = 0;* static	int lastXCoord = 0, lastYCoord = 0;6 static	int pointerScreen = -1, lastPointerScreen = -1; static	int Enabled = TRUE; static	int UseMetric = FALSE;  static  int AutoReset = TRUE; 2 static  double Distance = 0.0, TripDistance = 0.0;, static	Units distanceUnit, tripDistanceUnit; static  int debug = 0; static	char *fontName;U static	char defaultFontName[] = "-adobe-helvetica-bold-r-normal--24-240-*-*-*-*-*-*";  static	char *saveFileName;
 #ifdef VMSG static	char defaultSaveFileName[] = "decw$user_defaults:xodometer.sav";  #else 6 static	char defaultSaveFileName[] = "~/xodometer.sav"; #endif static	char startDate_s[128]; # static	int cyclesSinceLastSave = 0;  static	int htmlEnable = TRUE;  static	char *htmlFileName;
 #ifdef VMSH static	char defaultHtmlFileName[] = "decw$user_defaults:xodometer.html"; #else 7 static	char defaultHtmlFileName[] = "~/xodometer.html";  #endif static	char *htmlTitle; - static	char defaultHtmlTitle[] = "My Mouse!";  static	char *htmlHeader;. static	char defaultHtmlHeader[] = "My Mouse!"; static	int pollInterval = 10;  static	int saveFrequency = 10;   typedef struct     {  	struct tm lt; 	double Odometer;      } _oldOdometerInfo;    typedef struct     {  	int majVers, minVers; 	struct tm lt; 	double Odometer;  	Units unit;     } _odometerInfo; _odometerInfo odometerInfo;   V static  Widget TopLevel, MainWindow, MainDialog, DistanceLabel, TripLabel, TripButton;R static  Widget puMenu, puMenuLabel, puMenuLabel1, puSep1, puOnOff, puAuto, puHtml,) 	puFormat, puSaveSettings, puSep, puQuit;   # static XrmOptionDescRec options[] =  	    {E 	    {"-background", ".background", XrmoptionSepArg, (caddr_t) NULL}, E 	    {"-bg",         ".background", XrmoptionSepArg, (caddr_t) NULL}, E 	    {"-display",    ".display",    XrmoptionSepArg, (caddr_t) NULL}, E 	    {"-foreground", ".foreground", XrmoptionSepArg, (caddr_t) NULL}, E 	    {"-fg",         ".foreground", XrmoptionSepArg, (caddr_t) NULL}, E 	    {"-geometry",   ".geometry",   XrmoptionSepArg, (caddr_t) NULL}, < 	    {"-iconic",	    ".iconic",	   XrmoptionNoArg, "FALSE"},; 	    {"-help",	    ".help",       XrmoptionNoArg, "FALSE"}, 8 	    {"-units",	    ".units",	   XrmoptionSepArg, "us"},= 	    {"-orientation",".orientation",XrmoptionSepArg, "left"}, 8 	    {"-state",	    ".state",	   XrmoptionSepArg, "on"},< 	    {"-autoreset",  ".autoreset",  XrmoptionSepArg,  "on"},F 	    {"-font",       ".font",       XrmoptionSepArg, defaultFontName},J 	    {"-saveFile",   ".saveFile",   XrmoptionSepArg, defaultSaveFileName},6 	    {"-html",	    ".html",	   XrmoptionSepArg, "on"},J 	    {"-htmlFile",   ".htmlFile",   XrmoptionSepArg, defaultHtmlFileName},I 	    {"-htmlTitle",   ".htmlTitle",   XrmoptionSepArg, defaultHtmlTitle}, L 	    {"-htmlHeader",   ".htmlHeader",   XrmoptionSepArg, defaultHtmlHeader},? 	    {"-pollInterval", ".pollInterval", XrmoptionSepArg, "10"}, A 	    {"-saveFrequency", ".saveFrequency", XrmoptionSepArg, "10"}, K 	    {"-debug",	    ".debug",	   XrmoptionNoArg, "FALSE"}, /* Leave last */  	    }; A static optcount = (sizeof options) / (sizeof (XrmOptionDescRec));    static char *month[12] = {     "Jan", "Feb", "Mar", "Apr",      "May", "Jun", "Jul", "Aug",      "Sep", "Oct", "Nov", "Dec" }; static char *wday[7] = {     "Sun", "Mon", "Tue", "Wed",      "Thu", "Fri", "Sat"  };   #define MAX_SCREEN 16  typedef struct     { 
 	Window root; 
 	Screen *scr;  	int height, width;  	double PixelsPerMM;     } _screenInfo;# _screenInfo screenInfo[MAX_SCREEN];  static int screenCount;    #define MAXARGS 25
 #ifdef VMS3 #define DEFAULTS "decw$user_defaults:xodometer.dat"  #else " #define DEFAULTS "~/xodometer.dat" #endif #define K_Left 1 #define K_Right 2  #define K_Top 3  #define K_Bottom 4& static int screenOrientation = K_Left;  " char *GetResource(char *, char *);' void PutStringResource(char *, char *); % void PutNumericResource(char *, int);  void Usage(char **); void CleanUp();  void QueryPointer(); void FindAllScreens(); void ReadOdometer(); void WriteOdometer();  void WriteHtml();  int CalcDistance();  void FormatDistance(); double multiplier(Units unit); void AutoResetTimer();   void OnOffCB();  void MilesKilosCB(); void QuitCB(); void SaveSettingsCB(); void puPostMenu(); void TripButtonCB(); void AutoResetCB();  void HtmlEnableCB();    $ main(unsigned int argc,char *argv[]) {      Arg args[MAXARGS];     Pixmap icon_pixmap; G     int gx, gy, gw, gh;		/* main window geometry x, y, width, height */        int n, i, status;      char geombuff[32];     char windowTitle[128];     char puMenuLabel_s[128];     char *units_p;     char *state_p;     char *orientation_p;     char *autoreset_p;     char *html_p;      char distance_s[256];      long int decor;        Font font;     XFontStruct *fontStruct;     XmFontList fontList;  )     /* Initialize the resource manager */      XrmInitialize();  &     db = XrmGetFileDatabase(DEFAULTS);  F     XrmParseCommand(&db, options, optcount, "xodometer", &argc, argv);  ,     if (ResourcePresent("debug")) debug = 1;.     if (debug) printf("Debug mode active.\n");  ,     if (ResourcePresent("help") || argc>1) { 	Usage(&argv[0]);  	CleanUp(0);	 	exit(1);      }            /* Initialize the toolkit */     TopLevel = XtAppInitialize( 2 	    &appContext,			/* App. context is returned */( 	    progClass,			/* Root class name. */% 	    options,			/* No option list. */ ) 	    optcount,			/* Number of options. */ $ 	    &argc,				/* Address of argc */ 	    argv,				/* argv */& 	    NULL,				/* Fallback resources */) 	    NULL,				/* No override resources */ . 	    0);				/* Number of override resources */  "     display = XtDisplay(TopLevel);     if (display==NULL) {  	printf("can't open display\n"); 	CleanUp(0);
 	exit(-1);     }        FindAllScreens();   ;     pollInterval = atoi(GetResource("pollInterval", "10")); :     if (debug) printf("pollInterval: %d\n", pollInterval);5     PutNumericResource("pollInterval", pollInterval);*  @     saveFileName = GetResource("saveFile", defaultSaveFileName);     if (!saveFileName)$ 	saveFileName = defaultSaveFileName;6     if (debug) printf("saveFile: %s\n", saveFileName);0     PutStringResource("saveFile", saveFileName);     =     saveFrequency = atoi(GetResource("saveFrequency", "10"));u<     if (debug) printf("saveFrequency: %d\n", saveFrequency);7     PutNumericResource("saveFrequency", saveFrequency);r  @     htmlFileName = GetResource("htmlFile", defaultHtmlFileName);     if (!htmlFileName)$ 	htmlFileName = defaultHtmlFileName;6     if (debug) printf("htmlFile: %s\n", htmlFileName);0     PutStringResource("htmlFile", htmlFileName);  ;     htmlTitle = GetResource("htmlTitle", defaultHtmlTitle);i     if (!htmlTitle)  	htmlTitle = defaultHtmlTitle;.     PutStringResource("htmlTitle", htmlTitle);  >     htmlHeader = GetResource("htmlHeader", defaultHtmlHeader);     if (!htmlHeader)  	htmlHeader = defaultHtmlHeader;0     PutStringResource("htmlHeader", htmlHeader);  4     fontName = GetResource("font", defaultFontName);(     font = XLoadFont(display, fontName);     if (font==0) {* 	printf("can't load font %s\n", fontName); 	CleanUp(0);
 	exit(-1);     }	(     PutStringResource("font", fontName);3     fontStruct = XLoadQueryFont(display, fontName);oF     fontList = XmFontListCreate(fontStruct, XmSTRING_DEFAULT_CHARSET);  6     root = RootWindow(display,DefaultScreen(display));F     icon_pixmap = XCreateBitmapFromData(display, root, xodometer_bits,( 					xodometer_width, xodometer_height);  (     units_p = GetResource("units","us");     switch (*units_p)e     { 
 	case 'u': 	case 'U':   /* U.S. */s 	    UseMetric = FALSE; break;
 	case 'm': 	case 'M':   /* metric */r 	    UseMetric = TRUE;  break;	 	default:i, 	    printf("invalid units: %s\n", units_p); 	    CleanUp(0); 	    exit(20);     }e'     PutStringResource("units",units_p);t  (     state_p = GetResource("state","on");     state_p++;     switch (*state_p)e     {n
 	case 'f': 	case 'F':   /* off */ 	    Enabled = FALSE; break;
 	case 'n': 	case 'N':   /* on */r 	    Enabled = TRUE;  break;	 	default:o 	    state_p--;e, 	    printf("invalid state: %s\n", state_p); 	    CleanUp(0); 	    exit(20);     }s     state_p--;'     PutStringResource("state",state_p);O  0     autoreset_p = GetResource("autoreset","on");     autoreset_p++;     switch (*autoreset_p)l     {m
 	case 'f': 	case 'F':   /* off */ 	    AutoReset = FALSE; break;
 	case 'n': 	case 'N':   /* on */  	    AutoReset = TRUE;  break;	 	default:d 	    autoreset_p--;i4 	    printf("invalid autoreset: %s\n", autoreset_p); 	    CleanUp(0); 	    exit(20);     }      autoreset_p--;/     PutStringResource("autoreset",autoreset_p);.  6     orientation_p = GetResource("orientation","left");     switch (*orientation_p)e     {i
 	case 'l':
 	case 'L':' 	    screenOrientation = K_Left; break;u
 	case 'r':
 	case 'R':( 	    screenOrientation = K_Right; break;
 	case 't':
 	case 'T':& 	    screenOrientation = K_Top; break;
 	case 'b':
 	case 'B':) 	    screenOrientation = K_Bottom; break;}	 	default: ? 	    printf("invalid screen orientation: %s\n", orientation_p);  	    CleanUp(0); 	    exit(20);     }r3     PutStringResource("orientation",orientation_p);v  &     html_p = GetResource("html","on");
     html_p++;T     switch (*html_p)     {B
 	case 'f': 	case 'F':   /* off */ 	    htmlEnable = FALSE; break;t
 	case 'n': 	case 'N':   /* on */i 	    htmlEnable = TRUE;  break;h	 	default:i 	    html_p--;* 	    printf("invalid html: %s\n", html_p); 	    CleanUp(0); 	    exit(20);     }0
     html_p--; &     PutStringResource("html", html_p);       ReadOdometer();.       /* Top level details */0
     n = 0;4     XtSetArg(args[n],XtNallowShellResize,TRUE); n++;6     sprintf(geombuff,"%s",GetResource("geometry",""));1     XParseGeometry(geombuff, &gx, &gy, &gw, &gh);E+     PutStringResource("geometry",geombuff);l#     XtSetArg(args[n],XmNx,gx); n++;t#     XtSetArg(args[n],XmNy,gy); n++;t'     XtSetArg(args[n],XmNwidth,gw); n++;;(     XtSetArg(args[n],XmNheight,gh); n++;6     XtSetArg(args[n],XtNiconPixmap, icon_pixmap); n++;#     if (ResourcePresent("iconic")) X     { ' 	XtSetArg(args[n],XtNiconic,TRUE); n++;e     },1     XtSetArg(args[n],XmNiconName, progName); n++;;9     sprintf(windowTitle, "%s %s", progName, progVersion);R2     XtSetArg(args[n],XmNtitle, windowTitle);  n++;X     decor = MWM_DECOR_BORDER | MWM_DECOR_RESIZEH | MWM_DECOR_TITLE | MWM_DECOR_MINIMIZE;5     XtSetArg(args[n], XmNmwmDecorations, decor); n++;tC     XtSetArg(args[n], XtNinput, FALSE); n++; /* Don't grab focus */ "     XtSetValues(TopLevel,&args,n);        /* Create the main window */
     n = 0;%     XtSetArg(args[n], XmNx, gx); n++;m%     XtSetArg(args[n], XmNy, gy); n++;c)     XtSetArg(args[n], XmNwidth, gw); n++;S*     XtSetArg(args[n], XmNheight, gh); n++;A     MainWindow = XmCreateMainWindow(TopLevel, progName, args, n);H     XtManageChild(MainWindow);  -     /* Create a dialog box to hold a label */H
     n = 0;6     XtSetArg(args[n], XmNdefaultPosition, False); n++;?     XtSetArg(args[n], XmNdialogStyle, XmDIALOG_WORK_AREA); n++;hA     MainDialog = XmCreateForm(MainWindow, "MainDialog", args, n);i     XtManageChild(MainDialog);  +     /* Create a label for odometer value */ 
     n = 0;     if (Enabled)     { H 	FormatDistance(Distance, distanceUnit, distance_s, sizeof(distance_s));] 	XtSetArg(args[n], XmNlabelString, XmStringLtoRCreate(distance_s, XmSTRING_DEFAULT_CHARSET));r     }      else[ 	XtSetArg(args[n], XmNlabelString, XmStringLtoRCreate("------", XmSTRING_DEFAULT_CHARSET));t     n++;2     XtSetArg(args[n], XmNfontList, fontList); n++;:     XtSetArg(args[n], XmNalignment, XmALIGNMENT_END); n++;3     XtSetArg(args[n], XmNrecomputeSize, True); n++;r<     XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM); n++;=     XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;}H     DistanceLabel = XmCreateLabel(MainDialog, "DistanceLabel", args, n);!     XtManageChild(DistanceLabel);"  0     /* Create a label for trip odometer value */
     n = 0;     if (Enabled)\ 	XtSetArg(args[n], XmNlabelString, XmStringLtoRCreate("0.00000", XmSTRING_DEFAULT_CHARSET));     else[ 	XtSetArg(args[n], XmNlabelString, XmStringLtoRCreate("------", XmSTRING_DEFAULT_CHARSET));r     n++;2     XtSetArg(args[n], XmNfontList, fontList); n++;:     XtSetArg(args[n], XmNalignment, XmALIGNMENT_END); n++;3     XtSetArg(args[n], XmNrecomputeSize, True); n++;">     XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;8     XtSetArg(args[n], XmNtopWidget, DistanceLabel); n++;=     XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;"@     TripLabel = XmCreateLabel(MainDialog, "TripLabel", args, n);     XtManageChild(TripLabel);A  E     /* Realize the widget heirarchy, creating and mapping windows. */t     XtRealizeWidget(TopLevel);       /* Create Popup menu */p  =     puMenu = XmCreatePopupMenu(TopLevel, "popMenu", NULL, 0); L     XtAddEventHandler(TopLevel, ButtonPressMask, False, puPostMenu, puMenu);  1     sprintf(puMenuLabel_s, "%s since", progName);a
     n = 0;@     XtSetArg(args[n], XmNalignment, XmALIGNMENT_BEGINNING); n++;h     XtSetArg(args[n], XmNlabelString, XmStringLtoRCreate(puMenuLabel_s, XmSTRING_DEFAULT_CHARSET)); n++;F     puMenuLabel = XmCreateLabelGadget(puMenu, "puMenuLabel", args, n);     XtManageChild(puMenuLabel);"  .     sprintf(puMenuLabel_s, "%s", startDate_s);
     n = 0;:     XtSetArg(args[n], XmNalignment, XmALIGNMENT_END); n++;h     XtSetArg(args[n], XmNlabelString, XmStringLtoRCreate(puMenuLabel_s, XmSTRING_DEFAULT_CHARSET)); n++;H     puMenuLabel1 = XmCreateLabelGadget(puMenu, "puMenuLabel1", args, n);      XtManageChild(puMenuLabel1);  <     XtSetArg(args[0], XmNseparatorType, XmSHADOW_ETCHED_IN);C     puSep1 = XmCreateSeparatorGadget(puMenu, "separator", args, 1);"     XtManageChild(puSep1);  
     n = 0;     if (Enabled)\ 	XtSetArg(args[n], XmNlabelString, XmStringLtoRCreate("Disable", XmSTRING_DEFAULT_CHARSET));     else[ 	XtSetArg(args[n], XmNlabelString, XmStringLtoRCreate("Enable", XmSTRING_DEFAULT_CHARSET));c     n++;F     puOnOff = XmCreatePushButtonGadget(puMenu, "pushbutton", args, n);?     XtAddCallback(puOnOff, XmNactivateCallback, OnOffCB, NULL);c     XtManageChild(puOnOff);a  5     /* Create a push button to reset Trip odometer */e
     n = 0;h     XtSetArg(args[n], XmNlabelString, XmStringCreateLtoR("Reset Trip" , XmSTRING_DEFAULT_CHARSET)); n++;8     XtSetArg(args[n], XmNaccelerator, "Alt<Key>T"); n++;g     XtSetArg(args[n], XmNacceleratorText, XmStringCreateLtoR("Alt/T" , XmSTRING_DEFAULT_CHARSET)); n++;xI     TripButton = XmCreatePushButtonGadget(puMenu, "TripButton", args, n);,G     XtAddCallback(TripButton, XmNactivateCallback, TripButtonCB, NULL);r     XtManageChild(TripButton);  $     /* Create 'Auto Reset' toggle */
     n = 0;l     XtSetArg(args[n], XmNlabelString, XmStringLtoRCreate("Auto Trip Reset", XmSTRING_DEFAULT_CHARSET)); n++;0     XtSetArg(args[n], XmNvalue, AutoReset); n++;?     XtSetArg(args[n], XmNset, (AutoReset ? True : False)); n++;IF     puAuto = XmCreateToggleButtonGadget(puMenu, "AutoReset", args, n);F     XtAddCallback(puAuto, XmNvalueChangedCallback, AutoResetCB, NULL);     XtManageChild(puAuto);  '     /* Create 'Generate HTML' toggle */i
     n = 0;j     XtSetArg(args[n], XmNlabelString, XmStringLtoRCreate("Generate HTML", XmSTRING_DEFAULT_CHARSET)); n++;1     XtSetArg(args[n], XmNvalue, htmlEnable); n++;p@     XtSetArg(args[n], XmNset, (htmlEnable ? True : False)); n++;G     puHtml = XmCreateToggleButtonGadget(puMenu, "htmlEnable", args, n);sG     XtAddCallback(puHtml, XmNvalueChangedCallback, HtmlEnableCB, NULL);r     XtManageChild(puHtml);  (     /* Create 'Metric Display' toggle */
     n = 0;k     XtSetArg(args[n], XmNlabelString, XmStringLtoRCreate("Metric Display", XmSTRING_DEFAULT_CHARSET)); n++;i0     XtSetArg(args[n], XmNvalue, UseMetric); n++;?     XtSetArg(args[n], XmNset, (UseMetric ? True : False)); n++; H     puFormat = XmCreateToggleButtonGadget(puMenu, "UseMetric", args, n);I     XtAddCallback(puFormat, XmNvalueChangedCallback, MilesKilosCB, NULL);      XtManageChild(puFormat);     
     n = 0;j     XtSetArg(args[n], XmNlabelString, XmStringLtoRCreate("Save Settings", XmSTRING_DEFAULT_CHARSET)); n++;M     puSaveSettings = XmCreatePushButtonGadget(puMenu, "pushbutton", args, n);;M     XtAddCallback(puSaveSettings, XmNactivateCallback, SaveSettingsCB, NULL);t"     XtManageChild(puSaveSettings);  <     XtSetArg(args[0], XmNseparatorType, XmSHADOW_ETCHED_IN);B     puSep = XmCreateSeparatorGadget(puMenu, "separator", args, 1);     XtManageChild(puSep);"  
     n = 0;a     XtSetArg(args[n], XmNlabelString, XmStringLtoRCreate("Quit", XmSTRING_DEFAULT_CHARSET)); n++;i8     XtSetArg(args[n], XmNaccelerator, "Alt<Key>Q"); n++;g     XtSetArg(args[n], XmNacceleratorText, XmStringCreateLtoR("Alt/Q" , XmSTRING_DEFAULT_CHARSET)); n++;mE     puQuit = XmCreatePushButtonGadget(puMenu, "pushbutton", args, n);t=     XtAddCallback(puQuit, XmNactivateCallback, QuitCB, NULL);d     XtManageChild(puQuit);     2     lastXCoord = lastYCoord = XCoord = YCoord = 0;  O     updateTimerId = XtAppAddTimeOut(appContext, pollInterval, QueryPointer, 0);t     if (AutoReset)B 	resetTimerId = XtAppAddTimeOut(appContext, 1, AutoResetTimer, 1);  &     /* Wait for something to happen */3     XtAppMainLoop(appContext);  /* Never returns */o }a ; void Usage(argv0)X
 char **argv0;i {a     int i = 0;     5     printf("\nUsage:  %s [-option ...]\n\n", *argv0);C*     printf("where -option includes:\n\n");     while (i<optcount-1)     {p% 	printf("\t%s\n", options[i].option);r 	i++;d     }b     return;d }t w /*/  * Routine to get one resource value, supplying(   * a default if it's not defined  *    */  char *GetResource(resrc, def). char *resrc, *def; {=     XrmValue value;      char *reptype;%     char fullname[64], fullclass[64];r     char *ptr;     int up;(     #     strcpy(fullname, "xodometer.");n     strcat(fullname, resrc);      strcpy(fullclass, fullname);  1     ptr = fullclass;	/* capitalize class name! */      up  = 1;     while (*ptr) {0 	if (up && islower(*ptr)) *ptr = _toupper(*ptr); 	up = *ptr++ == '.'; 	}  B     if (XrmGetResource(db, fullname, fullclass, &reptype, &value)) 	return value.addr ;       if (display) {0 	ptr = XGetDefault(display, "xodometer", resrc); 	if (ptr) return ptr;  	}       return def;S }n     /*7  * Routine to put a string resource value into databaset  */t" void PutStringResource(resrc, val) char *resrc, *val; {      XrmValue value;s     char *reptype;%     char fullname[64], fullclass[64];n     char *ptr;     int up;      #     strcpy(fullname, "xodometer.");      strcat(fullname, resrc);      strcpy(fullclass, fullname);  1     ptr = fullclass;	/* capitalize class name! */      up  = 1;     while (*ptr) {0 	if (up && islower(*ptr)) *ptr = _toupper(*ptr); 	up = *ptr++ == '.'; 	}       /* Set the new value */i     value.addr = val;c!     value.size = strlen(val) + 1;i     /* Update the database */s5     XrmPutResource(&db, fullname, XtRString, &value);r };     /*8  * Routine to put a numeric resource value into database  */ # void PutNumericResource(resrc, val)i char *resrc; int val; {f     XrmValue value;i     char *reptype;%     char fullname[64], fullclass[64];e     char *ptr;     int up;      char tmp[256];     #     strcpy(fullname, "xodometer.");      strcat(fullname, resrc);      strcpy(fullclass, fullname);  1     ptr = fullclass;	/* capitalize class name! */      up  = 1;     while (*ptr) {0 	if (up && islower(*ptr)) *ptr = _toupper(*ptr); 	up = *ptr++ == '.'; 	}       tmp[0] = '\0';     sprintf(tmp, "%d", val);     /* Set the new value */;     value.addr = tmp;0!     value.size = strlen(tmp) + 1;u     /* Update the database */d5     XrmPutResource(&db, fullname, XtRString, &value);; }      /*&  * Routine to see if resource present.  */  int ResourcePresent(resrc) char *resrc; {"     XrmValue value;m     char *reptype;%     char fullname[64], fullclass[64];(     char *ptr;     int up;t     #     strcpy(fullname, "xodometer.");g     strcat(fullname, resrc);      strcpy(fullclass, fullname);  1     ptr = fullclass;	/* capitalize class name! */e     up  = 1;     while (*ptr) {0 	if (up && islower(*ptr)) *ptr = _toupper(*ptr); 	up = *ptr++ == '.'; 	}  B     if (XrmGetResource(db, fullname, fullclass, &reptype, &value)) 	return 1 ;;       if (display) {0 	ptr = XGetDefault(display, "xodometer", resrc); 	if (ptr) return 1;w 	}  
     return 0;  }e   void FindAllScreens()M {C     int i = 0;     int Dh, DhMM, Dw, DwMM;M&     double vPixelsPerMM, hPixelsPerMM;     '     screenCount = ScreenCount(display);i_     if (debug) printf("Display has %d screen%s\n", screenCount, (screenCount == 1 ? "" : "s"));h       while (i < screenCount)      {A% 	if (debug) printf("Screen %d\n", i);A- 	screenInfo[i].root = RootWindow(display, i);[2 	screenInfo[i].scr = XScreenOfDisplay(display, i);     ? 	screenInfo[i].height = Dh = HeightOfScreen(screenInfo[i].scr);e, 	DhMM = HeightMMOfScreen(screenInfo[i].scr);= 	screenInfo[i].width = Dw = WidthOfScreen(screenInfo[i].scr); + 	DwMM = WidthMMOfScreen(screenInfo[i].scr);)   	if (debug)e 	{: 	    printf("\tHeight is %d pixels (%d mm).\n", Dh, DhMM);9 	    printf("\tWidth is %d pixels (%d mm).\n", Dw, DwMM);i 	} 	t* 	vPixelsPerMM = (double)Dh / (double)DhMM;* 	hPixelsPerMM = (double)Dw / (double)DwMM;A 	screenInfo[i].PixelsPerMM = (vPixelsPerMM + hPixelsPerMM) / 2.0;t   	if (debug)d 	{B 	    printf("\tVertical pixels/mm  are %2.5f mm\n", vPixelsPerMM);C 	    printf("\tHorizontal pixels/mm are %2.5f mm\n", hPixelsPerMM);sL 	    printf("\tAverage pixels/mm are %.2f mm\n", screenInfo[i].PixelsPerMM); 	} 	+ 	i++;      }g }g ] void QueryPointer("     XtPointer data, /* not used */     XtIntervalId *id)_ {)     if (Enabled)     {[# 	lastPointerScreen = pointerScreen;  	lastXCoord = XCoord;t 	lastYCoord = YCoord;F@ 	XQueryPointer (display, root, &RootIDRet, &ChildIDRet, &XCoord,) 		    &YCoord, &WinX, &WinY, &StateMask);( 	if (CalcDistance()) 	{ 	    refresh_window(TRUE); 	    cyclesSinceLastSave++;* 	    if (debug)o\ 		printf("Save Freq: %d  Cycles Since Last Save: %d\n", saveFrequency, cyclesSinceLastSave); 	}/ 	else if (cyclesSinceLastSave >= saveFrequency); 	{ 	    WriteOdometer();n! 	    if (htmlEnable) WriteHtml();t 	}     }   O     updateTimerId = XtAppAddTimeOut(appContext, pollInterval, QueryPointer, 0);) }+   void OnOffCB(widget,tag,reason)t     Widget widget;     char *tag;      XmAnyCallbackStruct *reason;   {+     Arg args[1];     char buf[32];h     (     if (Enabled)		/* then turn it off */     {t 	Enabled = FALSE;a  	XtRemoveTimeOut(updateTimerId); 	lastXCoord = lastYCoord = 0;M 	strcpy(buf, "Enable");      }e)     else 								   /* turn it back on */      {a 	Enabled = TRUE; 	strcpy(buf, "Disable");     }e  Y     XtSetArg(args[0], XmNlabelString, XmStringLtoRCreate(buf, XmSTRING_DEFAULT_CHARSET));o#     XtSetValues(puOnOff, &args, 1);P     refresh_window(Enabled);     if (Enabled)L 	updateTimerId = XtAppAddTimeOut(appContext, pollInterval, QueryPointer, 0);     else     {e 	WriteOdometer();o 	if (htmlEnable) WriteHtml();A     }[ }  a$ void MilesKilosCB(widget,tag,reason)     Widget widget;     char *tag;      XmAnyCallbackStruct *reason; { (     if (UseMetric)	/* switch to miles */     {  	UseMetric = FALSE;(     }      else     {g 	UseMetric = TRUE;     }u     refresh_window(Enabled); }u e$ void TripButtonCB(widget,tag,reason)     Widget widget;     char *tag;      XmAnyCallbackStruct *reason; {a     TripDistance = 0.0;m     tripDistanceUnit = inch;     refresh_window(Enabled); };   void AutoResetTimer(     XtPointer data,,     XtIntervalId *id)n { " #define SECONDS_PER_DAY (60*60*24)'     unsigned long secondsSinceMidnight;m'     unsigned long secondsUntilMidnight;S(     unsigned long uSecondsUntilMidnight;     time_t time_now;       if (!data)     {  	TripDistance = 0.0; 	tripDistanceUnit = inch;n 	refresh_window(True);     },       time(&time_now);8     secondsSinceMidnight = (time_now % SECONDS_PER_DAY);&     if ((secondsSinceMidnight == 0) ||1 	(secondsSinceMidnight > (SECONDS_PER_DAY - 10)))t     {t+ 	secondsUntilMidnight = SECONDS_PER_DAY+10;l     }u     else     {e? 	secondsUntilMidnight = SECONDS_PER_DAY - secondsSinceMidnight;*     }      8     uSecondsUntilMidnight = 1000 * secondsUntilMidnight;  Y     resetTimerId = XtAppAddTimeOut(appContext, uSecondsUntilMidnight, AutoResetTimer, 0);;     if (debug)     { O 	printf("AutoResetTimer set for %u seconds from now.\n", secondsUntilMidnight);t= 	printf("\tThat's about %d hrs %d min %d seconds from %s.\n",  		secondsUntilMidnight / 3600,% 		(secondsUntilMidnight % 3600) / 60,  		secondsUntilMidnight % 60,B 		(secondsUntilMidnight >= SECONDS_PER_DAY ? "tomorrow" : "now"));     }  }  *# void AutoResetCB(widget,tag,reason)      Widget widget;     char *tag;      XmAnyCallbackStruct *reason; {      int status;D       if (AutoReset)     {t 	AutoReset = FALSE;l 	XtRemoveTimeOut(resetTimerId);g     }]     else     {s 	AutoReset = TRUE;B 	resetTimerId = XtAppAddTimeOut(appContext, 1, AutoResetTimer, 1);     }n          if (debug)J 	printf("AutoResetCB: Auto Reset %sabled.\n", (AutoReset ? "En" : "Dis"));      }  *$ void HtmlEnableCB(widget,tag,reason)     Widget widget;     char *tag;      XmAnyCallbackStruct *reason; {a     if (htmlEnable)F     {A 	htmlEnable = FALSE;     }g     else     {t 	htmlEnable = TRUE;      }g          if (debug)F 	printf("HtmlEnableCB: HTML %sabled.\n", (htmlEnable ? "En" : "Dis"));      }h E- static void SaveSettingsCB(widget,tag,reason)m     Widget widget;     char *tag;      XmAnyCallbackStruct *reason; {      char geom[25];
     int n;     Position x, y;     Dimension w, h;[     Arg args[MAXARGS];  
     n = 0;%     XtSetArg(args[n], XmNx, &x); n++;R%     XtSetArg(args[n], XmNy, &y); n++;v)     XtSetArg(args[n], XmNwidth, &w); n++;]*     XtSetArg(args[n], XmNheight, &h); n++;$     XtGetValues(TopLevel, &args, n);-     sprintf(geom, "%dx%d+%d+%d", w, h, x, y);C(     PutStringResource("geometry", geom);       if (UseMetric)% 	PutStringResource("units","metric");      else! 	PutStringResource("units","us");g       if (Enabled)! 	PutStringResource("state","on");C     else" 	PutStringResource("state","off"); 	B     switch (screenOrientation)     { > 	case K_Left : PutStringResource("orientation","left"); break;@ 	case K_Right : PutStringResource("orientation","right"); break;< 	case K_Top : PutStringResource("orientation","top"); break;B 	case K_Bottom : PutStringResource("orientation","bottom"); break;     }h       if (AutoReset)% 	PutStringResource("autoreset","on");i     else& 	PutStringResource("autoreset","off");     (     PutStringResource("font", fontName);  0     PutStringResource("saveFile", saveFileName);       if (htmlEnable)g! 	PutStringResource("html", "on");L     else" 	PutStringResource("html", "off");0     PutStringResource("htmlFile", htmlFileName);.     PutStringResource("htmlTitle", htmlTitle);0     PutStringResource("htmlHeader", htmlHeader);     7     PutNumericResource("saveFrequency", saveFrequency);e5     PutNumericResource("pollInterval", pollInterval);i  %     XrmPutFileDatabase(db, DEFAULTS);e     return;d }e ( /*2  * Delete resource database and purge working set   */n void CleanUp(int saveOdometer) {p
     if (db) {N         XrmFreeDatabase(db);         db = NULL;     }0       if (saveOdometer)      {  	WriteOdometer();s 	if (htmlEnable) WriteHtml();      }n   }h   o void QuitCB(widget,tag,reason)     Widget widget;     char *tag;      XmAnyCallbackStruct *reason; {      CleanUp(1);n     exit(1); }* u( static void  puPostMenu(w, popup, event)     Widget         w;n     Widget         popup;r     XButtonEvent  *event;  {r     int         status;r!     if (event->button != Button3)          return;[  "     XmMenuPosition(puMenu, event);     XtManageChild (puMenu);y }l m refresh_window(int flag) {t,     static char prev_distance_s[256] = {""};(     static char prev_trip_s[256] = {""};     char distance_s[256];      char trip_s[256];{
     int n;     Arg args[10];r  
     if (flag);     { H 	FormatDistance(Distance, distanceUnit, distance_s, sizeof(distance_s));H 	FormatDistance(TripDistance, tripDistanceUnit, trip_s, sizeof(trip_s));     }s     else     {, 	strcpy (distance_s, "------");  	strcpy (trip_s, "------");      }*  1     if (strcmp(distance_s, prev_distance_s) != 0)t     {  	XFlush(display);r] 	XtSetArg(args[0], XmNlabelString, XmStringCreateLtoR(distance_s, XmSTRING_DEFAULT_CHARSET));n& 	XtSetValues(DistanceLabel, &args, 1);& 	strcpy (prev_distance_s, distance_s);     }o  )     if (strcmp(trip_s, prev_trip_s) != 0)      {f 	XFlush(display);;Y 	XtSetArg(args[0], XmNlabelString, XmStringCreateLtoR(trip_s, XmSTRING_DEFAULT_CHARSET));i" 	XtSetValues(TripLabel, &args, 1); 	strcpy (prev_trip_s, trip_s);     }  }  S double multiplier(Units unit). {r     double m = 10;       switch (unit)1     {  	case mile : m *= 10.0;s 	case foot : m *= 10.0;  	case inch : m *= 10.0; break;     } 
     return m;t }u  . #define MAX(_a,_b) ((_a) > (_b) ? (_a) : (_b)) int CalcDistance() {e     double dist, sum;;
     int X, Y; ,     double distMM, distInches, finalNewDist;(     double oldDistance, oldTripDistance;(     double newDistance, newTripDistance;)     int i = 0, j, finalScreen, increment; <     Units oldDistanceUnit, oldTripDistanceUnit, currentUnit;-     int distanceChanged, tripDistanceChanged;n     +     if (lastXCoord == 0 && lastYCoord == 0)  	return FALSE;  5     if (lastXCoord == XCoord && lastYCoord == YCoord)  	return FALSE; 	 3     /* Figure out which screen the pointer is on */;     if (screenCount > 1) 	while (i < screenCount)) 	    if (RootIDRet == screenInfo[i].root)  		break;	 	    else  		i++;       pointerScreen = i;     a     if (debug) printf("CalcDistance: screen: %d, x: %d, y: %d\n", pointerScreen, XCoord, YCoord);        /*	 K     **  Adjust XCoord or YCoord for the screen its on, relative to screen 0t     **	and screenOrientation.c     */  F     if (lastPointerScreen != -1 && pointerScreen != lastPointerScreen)     {e 	switch (screenOrientation)  	{ 	    case K_Left:* 	    case K_Top: 		finalScreen = 0;/ 		j = MAX(pointerScreen,lastPointerScreen) - 1;  		increment = -1;; 		break; 	    case K_Right: 	    case K_Bottom:a9 		finalScreen = MAX(pointerScreen,lastPointerScreen) - 1;  		j = 0; 		increment = 1; 		break; 	} 	c 	doi 	{ 	    switch (screenOrientation)0 	    { 		case K_Left: 		case K_Right: , 		    if (pointerScreen > lastPointerScreen)! 			XCoord += screenInfo[j].width;;
 		    else% 			lastXCoord += screenInfo[j].width;  		    break;
 		case K_Top:h 		case K_Bottom:, 		    if (pointerScreen > lastPointerScreen)" 			YCoord += screenInfo[j].height;
 		    else& 			lastYCoord += screenInfo[j].height; 		    break; 	    } 	    if (j != finalScreen) 		j += increment;n 	} while (j != finalScreen);S     	if (debug) printf("  Adjusted for screen ch: x: %d, y: %d\n", XCoord, YCoord);c     }r  [     if (debug) printf("In: Distance: %.5f, Trip Distance: %.5f\n", Distance, TripDistance);M  ,     /* Calculate distance in pixels first */       X = XCoord - lastXCoord;     X = X*X;          Y = YCoord - lastYCoord;     Y = Y*Y;           sum = (double)X + (double)Y;     dist = sqrt(sum);/  3     if (debug) printf("  New dist: %.5fp, ", dist);M        /* Convert to millimeters */:     distMM = dist / screenInfo[pointerScreen].PixelsPerMM;*     if (debug) printf("%.5fmm, ", distMM);       /* Convert to inches */(     distInches = distMM * 0.04; ,     if (debug) printf("%.5f\"", distInches);  X     /* Add an appropriate value to Distance, which may be in a unit other than inches */     currentUnit = inch;n     finalNewDist = distInches;&     while (currentUnit < distanceUnit)     { N 	finalNewDist = finalNewDist / ConversionTable[currentUnit].maxFromBeforeNext;` 	if (debug) printf(", %.5f %s", finalNewDist, ConversionTable[currentUnit+1].fromUnitTagPlural); 	currentUnit++;      }l     if (debug) printf("\n");6     oldDistance = Distance * multiplier(distanceUnit);     Distance += finalNewDist; #     oldDistanceUnit = distanceUnit;rB     if (ConversionTable[distanceUnit].maxFromBeforeNext != -1.0 &&= 	Distance >= ConversionTable[distanceUnit].maxFromBeforeNext)l     {eG 	Distance = Distance / ConversionTable[distanceUnit].maxFromBeforeNext;o 	distanceUnit++;     } 6     newDistance = Distance * multiplier(distanceUnit);9     distanceChanged = (distanceUnit != oldDistanceUnit ||;A 		       (unsigned int)oldDistance != (unsigned int)newDistance);)  \     /* Add an appropriate value to TripDistance, which may be in a unit other than inches */     currentUnit = inch;s     finalNewDist = distInches;*     while (currentUnit < tripDistanceUnit)     { N 	finalNewDist = finalNewDist / ConversionTable[currentUnit].maxFromBeforeNext; 	currentUnit++;i     }rB     oldTripDistance = TripDistance * multiplier(tripDistanceUnit);!     TripDistance += finalNewDist;d+     oldTripDistanceUnit = tripDistanceUnit;dF     if (ConversionTable[tripDistanceUnit].maxFromBeforeNext != -1.0 &&E 	TripDistance >= ConversionTable[tripDistanceUnit].maxFromBeforeNext)d     {iS 	TripDistance = TripDistance / ConversionTable[tripDistanceUnit].maxFromBeforeNext;  	tripDistanceUnit++;     }iB     newTripDistance = TripDistance * multiplier(tripDistanceUnit);E     tripDistanceChanged = (tripDistanceUnit != oldTripDistanceUnit || I 		       (unsigned int)oldTripDistance != (unsigned int)newTripDistance);*     \     if (debug) printf("Out: Distance: %.5f, Trip Distance: %.5f\n", Distance, TripDistance);  /     if (distanceChanged || tripDistanceChanged)t
 	return TRUE;o     else 	return FALSE; }d dG #define THERE_IS_A_NEXT (ConversionTable[unit].maxToBeforeNext != -1.0)eG void FormatDistance(double in_dist, Units unit, char *buf, int buf_siz)S {n     double out_dist = in_dist;     char *tag;     int precision;       memset(buf, 0, buf_siz);       if (UseMetric)     {o= 	out_dist = in_dist * ConversionTable[unit].conversionFactor;gI 	if (THERE_IS_A_NEXT && out_dist > ConversionTable[unit].maxToBeforeNext)  	{A 	    out_dist = out_dist / ConversionTable[unit].maxToBeforeNext;i 	    unit++; 	} 	if (out_dist == 1.0) + 	    tag = ConversionTable[unit].toUnitTag;O 	else_1 	    tag = ConversionTable[unit].toUnitTagPlural;c     }i     else     {* 	if (out_dist == 1.0) - 	    tag = ConversionTable[unit].fromUnitTag;, 	elsed3 	    tag = ConversionTable[unit].fromUnitTagPlural;      } 5     precision = ConversionTable[unit].printPrecision;,  7     sprintf (buf, "%.*f %s", precision, out_dist, tag);  }  s void ReadOdometer()  {e     int bt;n     struct tm *lt;     _oldOdometerInfo oldInfo; 
     int f;     int bytes;  5     memset (&odometerInfo, 0, sizeof(_odometerInfo));w     *     f = open (saveFileName, O_RDWR, 0600);     if (f==-1)     {i  	f = creat (saveFileName, 0600); 	if (f==-1)S 	{5 	    printf("can't create file: %s\n", saveFileName);  	    CleanUp(0);
 	    exit(0);R 	}@ 	if (debug) printf("Creating new save file %s\n", saveFileName); 	time(&bt);i 	lt = localtime (&bt);2 	memcpy (&odometerInfo.lt, lt, sizeof(struct tm));& 	odometerInfo.majVers = MAJOR_VERSION;& 	odometerInfo.minVers = MINOR_VERSION; 	odometerInfo.unit = inch;1 	write (f, &odometerInfo, sizeof(_odometerInfo));;     }h     else     {n? 	if (debug) printf("Reading existing file %s\n", saveFileName);E8 	bytes = read (f, &odometerInfo, sizeof(_odometerInfo));' 	if (bytes == sizeof(_oldOdometerInfo))t0 	{   /* Detect pre v1.6 save file; upgrade it */g 	    if (debug) printf("Converting pre v1.6 file to v%d.%d format...\n", MAJOR_VERSION, MINOR_VERSION);r 	    lseek (f, 0, 0);c2 	    read (f, &oldInfo, sizeof(_oldOdometerInfo));6 	    memset (&odometerInfo, 0, sizeof(_odometerInfo));* 	    odometerInfo.majVers = MAJOR_VERSION;* 	    odometerInfo.minVers = MINOR_VERSION;" 	    odometerInfo.lt = oldInfo.lt;. 	    odometerInfo.Odometer = oldInfo.Odometer; 	    odometerInfo.unit = mile;  L 	    if (odometerInfo.Odometer < 1.0) /*	Convert less than a mile to feet */ 	    {I 		if (debug) printf("  Converted %.5f miles to ", odometerInfo.Odometer);t" 		odometerInfo.Odometer *= 5280.0;9 		if (debug) printf(" %.5f feet", odometerInfo.Odometer);o 		odometerInfo.unit = foot;e  K 		if (odometerInfo.Odometer < 1.0) /* Convert less than a foot to inches */  		{s$ 		    odometerInfo.Odometer *= 12.0;C 		    if (debug) printf(" to %.5f inches.", odometerInfo.Odometer);, 		    odometerInfo.unit = inch;u 		}n 		if (debug) printf("\n"); 	    }   	    lseek (f, 0, 0);t5 	    write (f, &odometerInfo, sizeof(_odometerInfo));  	}" 	Distance = odometerInfo.Odometer;" 	distanceUnit = odometerInfo.unit;     }o     close (f);  6     sprintf (startDate_s, "%s %s %d 19%d %02d:%02d\n",# 	    wday[odometerInfo.lt.tm_wday],a# 	    month[odometerInfo.lt.tm_mon],  	    odometerInfo.lt.tm_mday,) 	    odometerInfo.lt.tm_year,e 	    odometerInfo.lt.tm_hour,R 	    odometerInfo.lt.tm_min);e }    void WriteOdometer() {t
     int f;  6     f = open (saveFileName, O_WRONLY | O_CREAT, 0600);     if (f==-1)     {r/ 	printf("can't open file: %s\n", saveFileName);r 	CleanUp(0);	 	exit(0);,     }t  =     if (debug) printf("Writing odometer %.5f ...", Distance);   %     odometerInfo.Odometer = Distance;n%     odometerInfo.unit = distanceUnit;p4     write (f, &odometerInfo, sizeof(_odometerInfo));     close (f);  #     if (debug) printf("  Done.\n");a          cyclesSinceLastSave = 0; }s i void WriteHtml() {t     char distance_s[256];      char trip_s[256];r
     FILE *fp;g     int bt;      struct tm *lt;     char time_s[256];o  & /*    fp = fopen (htmlFileName, "r+");
     if (!fp) i */  remove(htmlFileName);     "     fp = fopen(htmlFileName, "w");     if (!fp)     {B/ 	printf("can't open file: %s\n", htmlFileName);r 	CleanUp(0);	 	exit(0);=     }3  ,     if (debug) printf("Writing html ...\n");  K     FormatDistance(Distance, distanceUnit, distance_s, sizeof(distance_s)); K     FormatDistance(TripDistance, tripDistanceUnit, trip_s, sizeof(trip_s));]          time(&bt);     lt = localtime (&bt);i  /     sprintf (time_s, "%s %s %d 19%d %02d:%02d",f 	    wday[lt->tm_wday],D 	    month[lt->tm_mon],e 	    lt->tm_mday,i 	    lt->tm_year,  	    lt->tm_hour,p 	    lt->tm_min);n   #define FPF(s) fprintf(fp, s);     FPF("<HTML>\n");     FPF("<BODY>\n");2     fprintf(fp, "<TITLE>%s</TITLE>\n", htmlTitle);-     fprintf(fp, "<H1>%s</H1>\n", htmlHeader);      FPF("<HR>\n");J     FPF("Since its trip odometer was last reset, my mouse has traveled ");#     fprintf(fp, "%s.  \n", trip_s);XI     fprintf(fp, "Since %s it has traveled %s.", startDate_s, distance_s);;     FPF("<HR>\n");n     fprintf(fp, "This page was generated dynamically by <EM>Xodometer</EM> %s on %s.\n", progVersion, time_s);     FPF("<HR>\n");A     FPF("<EM>Xodometer</EM> is a Motif application written by "); Q     FPF("<A HREF=\"mailto:granoff@keptin.enet.dec.com\">Mark H. Granoff</A>.\n");b     FPF("</BODY>\n");h     FPF("</HTML>\n");      fclose(fp);s }c