.TH XPOSTIT 1 "2 January 1989" RIACS/X11R3
.SH NAME
xpostit \- X window system Post-it\(rg notes
.SH SYNOPSIS
.B xpostit
[
.I \-toolkitoptions ...
] [
.I \-options ...
]
.SH DESCRIPTION
.I Xpostit
provides a mechanism for manipulating on-screen Post-it\(rg notes.
All three sizes of Post-it notes may be displayed,
edited,
and saved to disk files.
In addition,
any on-screen note may be resized to any arbitrary size either when it is
created or at a later time.
This version of XPostit also has the capability to paste notes onto other
peoples workstation screens, so long as you have access to the display.
.PP
When
.I xpostit
is first invoked,
it creates a small window with a plaid background.
This is the control window for
.IR xpostit .
Additionally,
if any notes were stored in the save directory (see below),
these will be placed on the screen at their last locations.
Each Post-it note,
when created,
makes another window on the screen.
.I Xpostit
is controlled using the mouse buttons and a menu.
The Post-it notes are controlled using buttons (Command widgets).
.SH OPTIONS
.PP
.I Xpostit
accepts all of the standard X Toolkit command line options along with the
additional options listed below.
.TP 8
.BI \-bs " number"
Specifies the size of the character buffer in which to save each Post-it
note.
A note may not contain more than this number of characters,
including newlines.
The default is 1024.
.TP 8
.BI \-dir " path"
Specifies the path name of the directory in which to store saved Post-it notes.
If
.I path
begins with a `/' it is taken as-is;
if it does not begin with a `/',
the path is taken relative to the home directory.
The named directory must already exist if notes are to be saved in it.
The default is
.IR \&.postitnotes .
.TP 8
.B \-sb
Enables scroll-bars.
If specified,
a scroll bar will be attached to each Post-it note.
.TP 8
.B \-so
Enables scroll-on-overflow.
When specified,
this option tells
.I xpostit
to scroll the text of a Post-it note upward when the bottom of the window
is reached.
.TP 8
.B \-sv
Enables save-on-exit.
When specified,
this option tells
.I xpostit
to save all Post-it notes to disk files when exiting.
If not specified,
notes will only be saved to disk files when saved manually by the user.
.SH "WIDGET USAGE"
.PP
.I Xpostit
uses several widget types to construct the objects it uses.
.PP
The control window is made up of a Plaid widget called ``plaid''.
.PP
The menu is a pop-up shell called ``MainMenu'',
containing a List widget called ``menu''.
.PP
Each Post-it note you create is a pop-up shell called ``PostItNote'',
containing a Form widget called ``form''
which contains a Text widget called ``text'',
and three Command widgets called ``save'',
``erase'',
and ``destroy''.
.PP
Each Post-it note you receive is a pop-up shell called ``ReceiveNote'',
containing a Form widget called ``form''
which contains a Text widget called ``text'',
and three Command widgets called ``save'',
``erase'',
and ``destroy''.
.PP
The confirmation box is a pop-up shell called ``Confirm'',
containing a Form widget called ``form''
which contains two Command widgets called ``confirm'' and ``cancel''.
.PP
The popup menu in notes you create is a pop-up shell called NoteMenu. The popup 
menu in notes you receive is a pop-up shell called ReceiveMenu. Note that
these are children of the top-level application shell, not the notes 
themselves.
.SH "X DEFAULTS"
.PP
.I Xpostit
understands all of the core X Toolkit resource names and classes as well
as those listed below,
which are all of class
.BR XPostit .
.TP 8
.B \&.bufSize
Specifies the size of the character buffer used to store a Post-it note.
The default is 1024.
.TP 8
.B \&.noteDir
Specifies the path name of the directory in which to store saved notes.
The default is
.IR \&.postitnotes .
.TP 8
.B \&.saveNotes
Controls the state of the save-on-exit option.
The default is
.BR false .
.TP 8
.B \&.scrollBar
Controls placing scroll bars on Post-it notes.
The default is
.BR false .
.TP 8
.B \&.scrollOnOverflow
Controls whether or not a note window should be scrolled when the bottom
of the window is reached.
The default is
.BR false .

.TP 8
.B \&.sendList
Contains a predefined list of displays that notes can be sent to. This should
be a comma seperated list of display names using the standard display name
format.
There is no default for this resource

.TP 8
.B \&.receiveNotes
Controls whether or not Post-it notes can be sent to the display that 
.I xpostit
is displaying on.
The default is
.BR false .

.PP
Because of the large amount of widget nesting in
.I xpostit ,
the following constructions are recommended for setting resources on
the various widgets:
.in 8
.sp
.nf
XPostit.\fIresource\fP

XPostit.plaid*\fIresource\fP

XPostit.Confirm*\fIresource\fP
XPostit.Confirm*confirm*\fIresource\fP
XPostit.Confirm*cancel*\fIresource\fP

XPostit.plaid.MainMenu*\fIresource\fP
XPostit.NoteMenu*\fIresource\fP
XPostit.ReceiveMenu*\fIresource\fP

XPostit.PostItNote*\fIresource\fP
XPostit.ReceiveNote*\fIresource\fP
.in 0
.sp
.fi
.SH "THE CONTROL WINDOW"
.PP
.I Xpostit
allows three operations to be performed from its control window.
Pressing the left mouse button in the control window will cause all Post-it
notes on the screen to be raised to the top.
Pressing the middle mouse button in the control window raises the
.I xpostit
menu.
Pressing the right mouse button in the control window will cause all Post-it
notes on the screen to be lowered to the bottom.
.SH "THE MENU"
.PP
The
.I xpostit
menu provides the following selections:
.TP 8
.B "Create 1.5x2 Note"
Create a new Post-it note,
1.5 inches tall by 2 inches wide.
The window will normally need to be positioned using the window manager.
.TP 8
.B "Create 3x3 Note"
Create a new Post-it note,
3 inches square.
.TP 8
.B "Create 3x5 Note"
Create a new Post-it note,
3 inches tall by 5 inches wide.
.TP 8
.B "Raise All Notes"
Raise all Post-it notes to the top.
This is equivalent to pressing the left mouse button in the control window.
.TP 8
.B "Lower All Notes"
Lower all Post-it notes to the bottom.
This is equivalent to pressing the right mouse button in the control window.
.TP 8
.B "Save All Notes"
Save all Post-it notes to disk files in the save directory.
.TP 8
.B Exit
Exit
.I xpostit .
If the
.B \-sv
command line option was given,
or the
.B saveNotes
resource is
.B true ,
all Post-it notes will be saved to disk first.
.PP
To select an item from the menu,
move the mouse cursor to that item and press the left mouse button.
If the mouse cursor exits the menu window,
the menu will be lowered automatically.
.SH "THE POST-IT NOTE"
.PP
Each Post-it note is made up of two parts (plus an optional scroll bar):
a text window where the text of the note is stored,
and a popup menu.
.PP
To enter text into a Post-it note,
simply move the mouse cursor into the text window and start typing.
Since the text window is actually a Text widget,
all the Text widget translations are accepted.
Essentially,
this means you can use most of the \s-1EMACS\s0 control keys in the window.
Additionally,
the various mouse buttons used for manipulating the selections and cut
buffer are understood.
.PP
Pressing the middle mouse button in the note window raises the
note popup menu.
This menu has the following options

.TP 8
.B "Save"
Save the Post-it note.
The note will be saved as the file ``note\fIn\fP'' in your save directory,
where
.I n
is some sequence number.
.BR \s-1NOTE\s0 :
it is important to remember that until you have pressed the ``save'' button,
the data stored in the Post-it note is not saved on disk and can be lost if
the system goes down or
.I xpostit
exits.
.PP

.TP 8
.B "Erase"
Clear the contents of the Post-it note
This will bring up a confirmation window,
which has two buttons labeled ``confirm'' and ``cancel''.
If you press the ``confirm'' button,
the text will be erased.
If you press the ``cancel'' button,
the operation is canceled,
and nothing will happen.
.BR \s-1NOTE\s0 :
erasing the text in the window does not affect any contents of the note
you have saved on disk unless you select the ``save'' menu option again.

.TP 8
.B "Delete"
Delete to Post-it note
This will bring up a confirmation window as described above.
If you confirm the operation,
the Post-it note will disappear from the screen and the disk file it was
saved in will be deleted.

.TP 8
.B "Send"
Send the Post-it note to another display. 
This will bring up a send dialogue box, using which you select the display
to send the Post-it note to.

.SH "SEE ALSO"
X(1)
.SH BUGS
.PP
The sizes of the Post-it notes are only as acurrate as the display
dimension and resolution returned by the server.
On the Sun server and possibly others,
this means they aren't all that accurate.
.PP
Without a color display for canary yellow notes and red plaid,
the aesthetic value of
.I xpostit
cannot be fully appreciated.
.SH AUTHOR
David A. Curry, Research Institute for Advanced Computer Science
.sp
``Post-it'' and the plaid design are registered trademarks of 3M.
