 /*  - 	YADMAN - Yet Another Damn MANdelbrot program    	Release Date: 9 April 1989    	Author: Ken 'Dirk' Berkun   	Version: 1.0    */   /*F     ------------------------------------------------------------------5     Copyright (c) 1989 Digital Equipment Corporation.      H     Permission to use, copy, modify and distribute this software for anyK     purpose and without fee is hereby granted, provided the above copyright K     notice and this permission notice are retained, and the name of Digital A     Equipment Corporation not be used in advertising or publicity K     pertaining to this software without specific, written prior permission. J     This software is provided "as is" without express or implied warranty.          Author: Ken Berkun  L     ------------------------------------------------------------------------ */  O /*****************************************************************************/  /*									     */  ! /*	ACKNOWLEDGEMENTS:						     */  /*									     */  % /*     	Many thanks to:							     */  /*            								     */ ? /* 		Ander Samuelsson for providing the skeleton code  	     */ 0 /*		Burns Fisher for the color code			  	     */> /*		DECburger without which this would not be possible	     */9 /*		Xuidemo from which I stole all the help code		     */ J /*	        The many many DEC employees who patiently answered my        */* /*		questions in the notesfiles				     */C /*		The Government of Malaysia for taking so long to process an  */ C /*		export license, so that I had time to use a PMAX to develop  */  /*		this on.					  	     */  /*									     */O /*****************************************************************************/    /*   Contact Information:   	Ken Berkun  	hgovc::kenberkun  	Ken Berkun @HGO# 	kenberkun%hgovc.dec@decwrl.dec.com     	Digital Equipment Far East Ltd. 	20/F Fleethouse 	38 Gloucester Rd. 	Wanchai Hong Kong 	5-861-4344  */   #include <stdio.h> #include <math.h>  #include <signal.h>   
 #ifdef VMS) #include <decw$include/DECwDwtApplProg.h>  #include <decw$cursor.h>  #include <decw$include/Vendor.h>! #define	 CURSORFONT "decw$cursor"  #else  #include <DECwDwtWidgetProg.h> #include <DECwDwtApplProg.h> #include <decwcursor.h>  #include <Vendor.h>   #define	 CURSORFONT "decwcursor" #endif   #define	    MAX_WIDGETS			100    #define	    k_MainWindow	    	0  #define	    k_MenuBar	 	   	1  #define	    k_FileDown	    		2 #define	    k_MenuWidget    		3  #define	    k_OpenButton    		4  #define	    k_ExitButton    		5  #define	    k_FileBox	    		6  #define	    k_workwidget    		7  #define     k_SaveButton    		8 ( #define     k_NewButton                9) #define     k_xdim_label               10 ) #define     k_ydim_label               11 ) #define     k_length_label             12 ) #define     k_pixels_label             13 ) #define     k_iterations_label         14 ) #define     k_xdim                     15 ) #define     k_ydim                     16  #define	    k_length		       17 ) #define	    k_pixels                   18 - #define     k_iterations               19     $ #define	    k_DataEntryBox	       20  #define	    k_ok_data		       21" #define     k_reset_data	       22) #define     k_cancel_data              23 " #define	    k_CommandsDown	    	24  #define	    k_CommandsWidget		25# #define     k_LaunchButton	     	26  #define	    k_ResizeButton		27 #define	    k_SaveAsButton		28 #define     k_CautionBox		32 #define		k_ColorBox		36  #define		k_apply_color		37 #define		k_reset_color		38 #define		k_dismiss_color		39 #define		k_red_mult_label	40 #define		k_green_mult_label	41 #define		k_blue_mult_label	42  #define		k_red_mult		43  #define		k_green_mult		44  #define		k_blue_mult		45 #define		color_box_label		46 #define		k_color_button_box	47 #define		k_OptionsDown		48 #define		k_OptionsWidget		49 #define		k_ColorsButton		50  #define		k_VerticalScroll	51 #define		k_HorizontalScroll	52 #define		k_MouseSizeButton	53  #define		k_AnimateInProgress	54  #define		k_LaunchInProgress	55 #define		k_AnimateButton		56 #define		k_BrainFadeButton	57  #define		k_launch_data		58 #define		k_shift			59  #define		k_mult			60 #define		k_effects_label		61 #define		k_progress_box		62  #define		k_red_up		63  #define		k_red_down		64  #define		k_green_up		65  #define		k_green_down		66  #define		k_blue_up		67 #define		k_blue_down		68 #define		k_inc_label		69 #define		k_1			70  #define		k_10			71 #define		k_HelpBox		72 #define		k_help_entry		73  #define		k_HelpDown		74  #define		k_HelpWidget		75  #define		k_HelpButton		76      #define		DEF_ACORNER		-2 #define		DEF_BCORNER		-2 #define		DEF_SIDE		4* #define		DEF_PIC			800       /* was 400 */ #define		DEF_IT			100  #define		MAX_PIXELS		256 #define		DEF_RED_MULT		1 #define		DEF_GREEN_MULT		2 #define		DEF_BLUE_MULT		4	 #define		INC_1			1 #define		INC_10			10 #define		MAX_SCROLL		100 #define		BAR_SIZE		17  #define		PROGRESS_SX		10	  #define		PROGRESS_SY		10	  #define		PROGRESS_WIDTH		100 #define		PROGRESS_LINE		16	  #define		X_MARGIN		20	 #define		Y_MARGIN		20		  #define		MAX_HEIGHT		864 #define		MAX_WIDTH		1024   /* bit maps for the icons */   #define iconify_width 16 #define iconify_height 16  static char iconify_bits[] = {J    0x00, 0x01, 0xe0, 0x0f, 0xf8, 0x3f, 0x1c, 0x7f, 0xc4, 0x7f, 0xe2, 0xf9,J    0xe8, 0xf3, 0xd2, 0xf3, 0xff, 0xe3, 0xd2, 0xf3, 0xe8, 0xf3, 0xe2, 0xf9,3    0xc4, 0x7f, 0x1c, 0x7f, 0xf8, 0x3f, 0xe0, 0x0f};    #define icon_width 16  #define icon_height 16 static char icon_bits[] = { J    0x00, 0x01, 0xe0, 0x0f, 0xf8, 0x3f, 0x1c, 0x7f, 0xc4, 0x7f, 0xe2, 0xf9,J    0xe8, 0xf3, 0xd2, 0xf3, 0xff, 0xe3, 0xd2, 0xf3, 0xe8, 0xf3, 0xe2, 0xf9,3    0xc4, 0x7f, 0x1c, 0x7f, 0xf8, 0x3f, 0xe0, 0x0f};   , char * window_title = "YadMan - Mandelbrot";= int  x_pos = 0, y_pos = 0;      /* opening window position */  int demo_mode = 0;  ? Widget	toplevel, mainwidget, workwidget, WidgetID[MAX_WIDGETS];   ( char	*UID_database[] = { "yadman.uid" }; DRMHierarchy	Hierarchy;  DRMType	*dummy;    static void     prefetch (); static void	error ();  static void	WidgetIDproc ();  static void     Activateproc (); static void     newproc ();  static void	openproc (); static void     saveproc (); static void     saveasproc (); static void	exitproc (); static void	launchproc (); static void	animateproc ();  static void	brainfadeproc ();  static void	colorsproc (); static void	resizeproc (); static void	VertScrollproc();  static void	HorScrollproc(); static void 	FileBoxproc ();% static void     CancelFileBoxproc ();  static void	CautionBoxproc (); static void	ColorBoxproc (); static void	MouseSizeproc (); $ static void     CancelAnimateproc();$ static void     CancelLaunchproc (); static void	ColorIconproc(); static void	Effectsproc(); static void	Incproc(); static void 	Helpproc(); static void 	EndHelpproc();    static void	myreadheaderproc();  static void	mzoom(); static void 	ReInit(); static void	dispmand();  static void     MyExpoproc();  static void	makeimage(); static void 	makeroom(); static void 	readmand();! static void     MyWindowResize(); % static void     RetrieveDataValues(); " static void     ResetDataValues();& static void     RetrieveColorValues();# static void     ResetColorValues();  static void	DoFileInput(); static void     MyCloseFile(); static void     MyOpenFile();  static void     MySaveFile();  static void     ShouldISave();  static void     SetUpColorMap(); static void	LoadColorMap(); ! static void     UpdateColorMap();  static void	GetWindowSize();" static void     ResetScrollBars(); static void	MyVertScroll();  static void	MyHorScroll(); static void	InitRubberBox(); static void	ConvertCoords(); static void	DisplayMouseData();  static void 	Animate();  static void	Launcher();  static void	CreateIcon();  static void	GetLocation();  $ static	XtEventHandler Resizedproc();) static  XtEventHandler ButtonPressproc();   . /* Declarations for colormaps, visuals, etc */    , static	XVisualInfo 	*pVisualInfo,vInfoDummy; static	int		nVis;  static	int		updateColor; static	int		pixel; static 	int		colorCount = 250; static  XColor		*colors; static  int		doprimary = 7;   static  int		pixels[MAX_PIXELS]; static  Colormap	map;* static  XtAppContext 	Context; static  XEvent		work_event;-  , /* structure for each mandelbrot instance */   struct instance  	{ 	char	filename[50];s 	FILE	*fip;f 	int 	x; 	int	y;i
 	double	real;a 	double	imaginary;
 	double	side;h	 	int	pic;e 	int	it; 	XImage	*image;i 	int	exists; 	};d  J /* the following variables are temporary holding areas used when gathering"    data from the data entry box */  2 static double temp_real,temp_imaginary, temp_side; static int temp_pic, temp_it;m   Arg argl[5]; static 	Font	current_font; static  Cursor	wait_cursor;d2 static  XColor  current_fc,current_bc,current_dmy; static  int	status;-   /* file status flags */-  I static  char    new_image = FALSE;      /* an image has been generated */*E static  char	cancel_operation = FALSE; /* cancel current operation */:I static  char    old_file[50];	    /* hold old file name in case needed */ D static  char	save_as = FALSE;    /* TRUE during save_as operation */C static  char	dirty = FALSE;	    /* you have made changes to data */ ( static  char    insaveascaution = FALSE; static  char 	temp_file[50];7 static  char  	exit_flag	= FALSE; /* in exit process */*  4 /* display and scroll related flags and variables */  K static 	char	auto_resize = FALSE; /* automatically resize window if true */e5 static	int	window_width;	     /* work window width */ 8 static  int	window_height;	     /* work window height */ static  int	y_step;s static  int	y_scroll = 0;	 static 	int	y_old_scroll = 0;* static	int	upper_image_from; static	int	lower_image_from; static	int	x_step; static  int	x_scroll = 0;  static  int	x_old_scroll = 0;u static  int	left_image_from; static  int	right_image_from;pH static  char	kill_animation = FALSE; /* set when cancelling animation */B static  char	kill_launch = FALSE; /* set when cancelling launch */D static  float	total;	/* percent of completion of image generation */  # static XGCValues progressGC_values;e static GC	 progressGC;  , /* rubber box related flags and variables */  ! static XGCValues rubberGC_values;e static GC	 rubberGC; static char	first_box = TRUE;u  " /* color multiplication factors */  $ static  int red_mult = DEF_RED_MULT;( static  int green_mult = DEF_GREEN_MULT;& static  int blue_mult = DEF_BLUE_MULT;( static  int old_red_mult = DEF_RED_MULT;, static  int old_green_mult = DEF_GREEN_MULT;* static  int old_blue_mult = DEF_BLUE_MULT;  2 static  int effect = 0; /* special effects flag */6 static  int inc = INC_1; /* size of color increment */   struct 	instance	current;   * static Pixmap icon_pixmap, iconify_pixmap;  A char *hptr; 	/* pointer to holding area for creating the image */b  M char first = TRUE;  /* flag to indicate that the first image has been made */r   struct mycallbackinfo  	{
 	int		reason;  	XExposeEvent	*event;  	Window		wregion;  	};    unsigned int main( argc, argv)     unsigned int   argc;     char    *argv[]; { 
     int i;&     static DRMCount	callback_num = 27;3     static DRMRegisterArg  callback_namevec[] = {   # 			{"exitproc" ,(caddr_t)exitproc},_  			{"newproc",(caddr_t)newproc},# 			{"openproc" ,(caddr_t)openproc},n# 			{"saveproc" ,(caddr_t)saveproc},	& 			{"saveasproc",(caddr_t)saveasproc},& 			{"launchproc",(caddr_t)launchproc},( 			{"animateproc",(caddr_t)animateproc},, 			{"brainfadeproc",(caddr_t)brainfadeproc},& 			{"colorsproc",(caddr_t)colorsproc},& 			{"resizeproc",(caddr_t)resizeproc},. 			{"VertScrollproc",(caddr_t)VertScrollproc},, 			{"HorScrollproc",(caddr_t)HorScrollproc},, 			{"WidgetIDproc", (caddr_t)WidgetIDproc}, + 			{"Activateproc", (caddr_t)Activateproc},_) 			{"FileBoxproc", (caddr_t)FileBoxproc},f5 			{"CancelFileBoxproc", (caddr_t)CancelFileBoxproc}, / 			{"CautionBoxproc", (caddr_t)CautionBoxproc},t+ 			{"ColorBoxproc", (caddr_t)ColorBoxproc},n- 			{"MouseSizeproc", (caddr_t)MouseSizeproc},u5 			{"CancelAnimateproc", (caddr_t)CancelAnimateproc},L3 			{"CancelLaunchproc", (caddr_t)CancelLaunchproc},f- 			{"ColorIconproc", (caddr_t)ColorIconproc},a) 			{"Effectsproc", (caddr_t)Effectsproc},m! 			{"Incproc", (caddr_t)Incproc},	# 			{"Helpproc", (caddr_t)Helpproc},f) 			{"EndHelpproc", (caddr_t)EndHelpproc}, & 			{"MyExpoproc", (caddr_t)MyExpoproc} 					 };  $         for (i = 1; i < argc; i++) {-             if (strcmp(argv[i], "-x") == 0) {n0                 if (++i >= argc) usage(argv[0]);&                 x_pos = atoi(argv[i]);                 } -             if (strcmp(argv[i], "-y") == 0) {t0                 if (++i >= argc) usage(argv[0]);&                 y_pos = atoi(argv[i]);                 }00             if (strcmp(argv[i], "-title") == 0){0                 if (++i >= argc) usage(argv[0]);'                 window_title = argv[i];U                 } 3              if (argv[i][0] == '-') usage(argv[0]);		         }n4                                                            DwtInitializeDRM();	  &     toplevel = XtInitialize(	"Yadman", 				"TopLevel",		 				NULL,2 				0,
 				&argc, 				argv );f  0     XtSetArg(argl[0], XtNallowShellResize,TRUE);/     XtSetArg(argl[1], DwtNtitle, window_title);t$     XtSetArg(argl[2], DwtNx, x_pos);(     XtSetArg(argl[3], DwtNy, y_pos);    !     XtSetValues(toplevel,argl,4);, 	c       if ( DwtOpenHierarchy(	1,f 				UID_database,,	 				NULL,,  				&Hierarchy ) != DRMSuccess )% 				error( "Can't open hierarchy!" );e  =     DwtRegisterDRMNames(    callback_namevec, callback_num );t    #     if ( DwtFetchWidget(	Hierarchy,0 				"MainWindow",3
 				toplevel,0 				&mainwidget, 				&dummy ) != DRMSuccess )( 				error( "Can't fetch main window!" );        XtManageChild ( mainwidget);     XtRealizeWidget( toplevel);r   	/* Set up the color map */d       SetUpColorMap();     LoadColorMap(&colorCount); 	 A     prefetch();  	/* get all the widgets ahead of time for snappyr 			   response */A  :     /* load the wait cursor and have it ready as needed */  @     current_font = XLoadFont(XtDisplay(mainwidget), CURSORFONT);  6     status = XAllocNamedColor(  XtDisplay(mainwidget),. 				XDefaultColormap(XtDisplay(mainwidget),0), 				"White", 				&current_bc, 				&current_dmy);  6     status = XAllocNamedColor(  XtDisplay(mainwidget),. 				XDefaultColormap(XtDisplay(mainwidget),0), 				"Black", 				&current_fc, 				&current_dmy);  ;     wait_cursor = XCreateGlyphCursor(XtDisplay(mainwidget),; 				     current_font, 				     current_font, 				     decw$c_wait_cursor, 				     decw$c_wait_cursor+1, 				     &current_fc,  				     &current_bc);   	;$ 	/* initialize current to default */   	current.exists = 0; 	current.real = DEF_ACORNER;! 	current.imaginary = DEF_BCORNER;n 	current.side	 = DEF_SIDE; 	current.pic	 = DEF_PIC; 	current.it	 = DEF_IT; 	current.image   = NULL;  9         XtSetSensitive(WidgetID[k_VerticalScroll],FALSE);y4 	XtSetSensitive(WidgetID[k_HorizontalScroll],FALSE); 	I= 	/* desensitize the save button until you have a file name */   ' 	XtSetArg(argl[0],DwtNsensitive,FALSE);k, 	XtSetValues(WidgetID[k_SaveButton],argl,1);  ' 	/* set up the graphics context for thee5 	   progress indicator in the launch in progress box.; 	*/t  % 	progressGC_values.function = GXcopy;c  , 	progressGC = XCreateGC(XtDisplay(toplevel), 				XtWindow(toplevel),  				GCFunction,  				&progressGC_values);  < 	XSetLineAttributes(XtDisplay(WidgetID[k_LaunchInProgress]), 			   progressGC,  			   PROGRESS_LINE, 			   NULL,NULL,NULL);  A 	/* add an event handler to let me know when the user has resized 
 		the window   	*/S  : 	XtAddEventHandler(mainwidget, StructureNotifyMask, FALSE, 				Resizedproc, NULL);t    	/* initialize the rubber box */   	InitRubberBox();i 	a@ 	/* Get the application context for use with work in progress */  2 	Context = XtWidgetToApplicationContext(toplevel);    	/* create the icons */            	CreateIcon();         resizeproc();s          XtAppMainLoop (Context);   }p   /* **++ **  FUNCTIONAL DESCRIPTION:o **E **	Prefetch all the widgets activated by the menu items, so that theyt **	will respond quickly	 ** **-- */   static void prefetch ()c   {;( if (DwtFetchWidget(Hierarchy, "FileBox",7 	toplevel, &WidgetID[k_FileBox], &dummy) != DRMSuccess)t?                     error("can't fetch file selection widget");e  - if (DwtFetchWidget(Hierarchy, "DataEntryBox",c< 	toplevel, &WidgetID[k_DataEntryBox], &dummy) != DRMSuccess)) 		   error("Can't fetch data entry box");l  + if (DwtFetchWidget(Hierarchy, "CautionBox",i: 	toplevel, &WidgetID[k_CautionBox], &dummy) != DRMSuccess)& 		   error("Can't fetch caution box");  ) if (DwtFetchWidget(Hierarchy, "ColorBox",d8 	toplevel, &WidgetID[k_ColorBox], &dummy) != DRMSuccess)$ 		   error("Can't fetch color box");  1 if (DwtFetchWidget(Hierarchy, "LaunchInProgress", @ 	toplevel, &WidgetID[k_LaunchInProgress], &dummy) != DRMSuccess)1 		   error("Can't fetch launch in progress box");   2 if (DwtFetchWidget(Hierarchy, "AnimateInProgress",A 	toplevel, &WidgetID[k_AnimateInProgress], &dummy) != DRMSuccess)e2 		   error("Can't fetch animate in progress box");  , if (DwtFetchWidget(Hierarchy, "ProgressBox",9 	WidgetID[k_LaunchInProgress], &WidgetID[k_progress_box],t 							 &dummy) != DRMSuccess)' 		   error("Can't fetch Progress box");c }h   /* **++ **  FUNCTIONAL DESCRIPTION:h **- **	This is just an error reporting procedure.E ** **-- */    static void error(error_string ) char *error_string;i {e#     printf( "%s\n", error_string );L	 	exit(1);m }c       /* **++ **  FUNCTIONAL DESCRIPTION:n **) **	Callback routine for an exposure eventcB **	Determine which window was exposed and redraw that part of the  **	image that was destroyed. ** ** **-- */    ' static void MyExpoproc(w,tag,expoevent);
 Widget *w; caddr_t tag;! struct mycallbackinfo *expoevent;n   {c% int tempx,tempy,tempwidth,tempheight;0    # 	if (current.image == NULL) return; ! 	if (current.exists == 0) return;r   	tempx = expoevent->event->x;h 	tempy = expoevent->event->y;t&  	tempwidth = expoevent->event->width;' 	tempheight = expoevent->event->height;a   	 B 	/* arbitrarilty if you resize the window the scroll bar goes backA 	   to the beginning and the image is redisplayed from upper leftl 	   hand corner. 	*/   ! 	if (current.pic > window_height)t 		{G2 		XtSetSensitive(WidgetID[k_VerticalScroll],TRUE); 		}m 	elsec 		{ A                 XtSetSensitive(WidgetID[k_VerticalScroll],FALSE);e 		}t    	if (current.pic > window_width) 		{ 4 		XtSetSensitive(WidgetID[k_HorizontalScroll],TRUE); 		}  	else  		{l5 		XtSetSensitive(WidgetID[k_HorizontalScroll],FALSE);l 		}E  / 		XPutImage(	XtDisplay(WidgetID[k_workwidget]),e% 				XtWindow(WidgetID[k_workwidget]),;3 				DefaultGC(XtDisplay(WidgetID[k_workwidget]),0),r 				current.image,
 				tempx,
 				tempy,
 				tempx,
 				tempy, 				tempwidth, 				tempheight); }i   /* **++ **  FUNCTIONAL DESCRIPTION:* **E **	Eventhandler for configure event - i.e. user has resize the windowc ** ** **-- */  0 static XtEventHandler Resizedproc(w, tag, event)  	 Widget w;i
 char *tag; XConfigureEvent *event;n   {t$ 	if (event->type == ConfigureNotify) 		{  		ResetScrollBars(); 		}l         return;  }t /* **++ **  FUNCTIONAL DESCRIPTION:  **) **	This is the exitproc callback routine.	 **4 **       test for cleanliness then exit the program. **-- */   static void	exitproc( )s {p 	if (new_image)a 		{" 		exit_flag = TRUE;, 		ShouldISave(); 		if (!exit_flag)return; 		}i 	elsec
 		exit(1); 	a }r     /* **++ **  FUNCTIONAL DESCRIPTION:e ** **C **  	saveasproc asks for a file name with the file selection widgeti: **      and saves your current work, with or without data.0 **	If a file is already open it closes it first. ** ** **-- */   static void saveasproc ()t   {p? 	/* set the save_as flag true so that the filebox routine knowso0 	   that we are doing a save as not just a save. 	*/o   	save_as = TRUE;  ; 	/* and change the title so the user knows what going on */d  2 	XtSetArg(argl[0],DwtNtitle,"FileBox_save_title");   	DwtFetchSetValues(n 		Hierarchy, 		WidgetID[k_FileBox], 		argl,  		1);n  $ 	XtManageChild(WidgetID[k_FileBox]);   }        /* **++ **  FUNCTIONAL DESCRIPTION:a **( **	This is the newproc callback routine. ** **-- */   static void	newproc( )   {p) 	XtManageChild(WidgetID[k_DataEntryBox]);c }(   /* **++ **  FUNCTIONAL DESCRIPTION:  **) **	This is the openproc callback routine.i ** **-- */   static void	openproc( )t {p$ 	XtManageChild(WidgetID[k_FileBox]); 	  }(     /* **++ **  FUNCTIONAL DESCRIPTION:  **< **	saveproc callback routine. saves a file when you have the( **	file name, else calls the saveasproc. ** ** **-- */   static void saveproc ()  {  	if (dirty)i7 		saveasproc(); /* give a chance to change file name */g 	else- 		MySaveFile();  }    /* **++ **  FUNCTIONAL DESCRIPTION:; **= **	launchproc - causes the mandelbrot to actually be computed 5 ** 	for the values in current. Does not write a file.  ** **-- */  & static void launchproc(w, tag, reason) 	Widget	*w;I
 	int	*tag; 	unsigned long reason; {i  K     int widget_num = *tag;              /* Convert tag to widget number. */) 	  	switch (widget_num) 		{a   		case k_LaunchButton:/ 			XtManageChild(WidgetID[k_LaunchInProgress]); + 			XtManageChild(WidgetID[k_progress_box]);A 			Launcher();	 			break;    		case k_launch_data:v 			current.exists = 0; 			RetrieveDataValues(); 			dirty = TRUE;/ 			XtManageChild(WidgetID[k_LaunchInProgress]); + 			XtManageChild(WidgetID[k_progress_box]);  			Launcher();	 			break;l 		
 		default: 			printf("uh oh\n"); 	 			break;c 		}e }H   /* **++ **  FUNCTIONAL DESCRIPTION:v **- **	Launcher - where the actual work gets done) ** ** **-- */   static void Launcher()   {   G 	XDefineCursor(XtDisplay(mainwidget),XtWindow(mainwidget),wait_cursor);p 	makeroom();	 	mzoom();    	if (kill_launch)  		{o> 		XUndefineCursor(XtDisplay(mainwidget),XtWindow(mainwidget));* 		kill_launch = FALSE; /* for next time */0 		if (XtIsManaged(WidgetID[k_LaunchInProgress]))1 			XtUnmanageChild(WidgetID[k_LaunchInProgress]);D	 		return;w 		})  
 	makeimage();  	MyWindowResize(); 	dispmand();  / 	if (XtIsManaged(WidgetID[k_LaunchInProgress]))y0 		XtUnmanageChild(WidgetID[k_LaunchInProgress]);= 	XUndefineCursor(XtDisplay(mainwidget),XtWindow(mainwidget));( }n   /* **++ **  FUNCTIONAL DESCRIPTION:m ** **	Color animation ** ** ** **-- */   static void animateproc ()   {r 	GetLocation();h. 	XtManageChild(WidgetID[k_AnimateInProgress]); 	Animate(&colorCount,FALSE);   }	   /* **++ **  FUNCTIONAL DESCRIPTION:_ ** **	Brainfade mode - pretty ** ** ** **-- */   static void brainfadeproc ()   {t 	GetLocation(); . 	XtManageChild(WidgetID[k_AnimateInProgress]); 	Animate(&colorCount,TRUE);B }N   /* **++ **  FUNCTIONAL DESCRIPTION:t **> **	colorsproc callback routine handles the colors menu options ** ** **-- */   static void colorsproc() {l  % 	XtManageChild(WidgetID[k_ColorBox]);r   }a   /* **++ **  FUNCTIONAL DESCRIPTION:  **A **	resizeproc simply switches the autoresize flag and changes thes4 **	push button in the Options menu to no auto resize ** ** **-- */   static void resizeproc() {e     	if (auto_resize)r 		{h  1 		XtSetArg(argl[0],DwtNlabel,"AutoResize_label");s   		DwtFetchSetValues(
 			Hierarchy,C 			WidgetID[k_ResizeButton], 			argl, 			1); 		auto_resize = FALSE; 		}	 	elses 		{a3 		XtSetArg(argl[0],DwtNlabel,"NoAutoResize_label");u   		DwtFetchSetValues(
 			Hierarchy,	 			WidgetID[k_ResizeButton], 			argl, 			1);   		auto_resize = TRUE;  		MyWindowResize();u 		}a 			i }  		   /* **++ **  FUNCTIONAL DESCRIPTION:m **@ **	VertScrollproc handles the input from the vertical scroll bar ** ** **-- */  * static void VertScrollproc(w, tag, scroll)
     Widget w;o
     int *tag;s'     DwtScrollBarCallbackStruct *scroll;X {d   	MyVertScroll(&scroll->value); }    /* **++ **  FUNCTIONAL DESCRIPTION:t **A **	HorScrollproc handles the input from the Horizontal scroll barp ** ** **-- */  ) static void HorScrollproc(w, tag, scroll) 
     Widget w;i
     int *tag;n'     DwtScrollBarCallbackStruct *scroll;u {l   	MyHorScroll(&scroll->value);r }t   /* **++ **  FUNCTIONAL DESCRIPTION:y **- **	This is the WidgetIDproc callback routine.m **I **      Registers the widget ID's in an array when the widget is created.t ** **-- */  ( static void WidgetIDproc(w, tag, reason)
     Widget w;t
     int *tag;o     unsigned long *reason; {      int widget_num = *tag;       WidgetID[widget_num] = w;H }a   /* **++ **  FUNCTIONAL DESCRIPTION:D **> **	Activate procedure handles the pushbuttons in the work area **	menu of the New data box. ** **-- */  ( static void Activateproc(w, tag, reason) 	Widget	*w;=
 	int	*tag; 	unsigned long reason; {o  K     int widget_num = *tag;              /* Convert tag to widget number. */i   	switch (widget_num) 		{d   		case k_ok_data:  			current.exists = 0; 			RetrieveDataValues(); 			dirty = TRUE;	 			break;c   		case k_reset_data: 			ResetDataValues();k	 			break;r 	e 		case k_cancel_data:e- 			XtUnmanageChild(WidgetID[k_DataEntryBox]);s	 			break;   
 		default: 			printf("uh oh\n");s	 			break;d   		}_   }h   /* **++ **  FUNCTIONAL DESCRIPTION:  **> **	CautionBox procedure handles the input from the do you want! **	to save your file caution box.L ** ** **-- */  * static void CautionBoxproc(w, tag, reason)   	Widget	*w;/
 	int	*tag; 	unsigned long *reason;  {r  K     int widget_num = *tag;              /* Convert tag to widget number. */    	cancel_operation = FALSE;   	switch (*reason)l 		{    		case DwtCRYes:+ 			XtUnmanageChild(WidgetID[k_CautionBox]);o" 			/* restore the old file name */& 			strcpy(temp_file,current.filename);% 			strcpy(current.filename,old_file);e 			insaveascaution = TRUE; 			saveasproc();	 			break;f   		case DwtCRNo:c+ 			XtUnmanageChild(WidgetID[k_CautionBox]);  			if (exit_flag) exit();  			DoFileInput();e	 			break;= 	  		case DwtCRCancel:e 			cancel_operation = TRUE;=+ 			XtUnmanageChild(WidgetID[k_CautionBox]);n 			if (exit_flag)t 				{h 				exit_flag = FALSE; 				return;  				}  			DoFileInput();i	 			break;o  
 		default: 			printf("uh oh\n");e	 			break;a   		}i }e   /* **++ **  FUNCTIONAL DESCRIPTION:d **: **	ColorBoxproc callback handles the input from the colors
 **	dialog boxd ** ** **-- */  ( static void ColorBoxproc(w, tag, reason) 	Widget	*w;n
 	int	*tag; 	unsigned long *reason;S {e  K     int widget_num = *tag;              /* Convert tag to widget number. */o   	switch (widget_num) 		{    		case k_apply_color:i 			RetrieveColorValues();c 			UpdateColorMap(&colorCount);g	 			break;y   		case k_reset_color:e 			ResetColorValues();	 			break;t 	; 		case k_dismiss_color:( 			old_red_mult = red_mult;  			old_green_mult = green_mult;	 			old_blue_mult = blue_mult;,) 			XtUnmanageChild(WidgetID[k_ColorBox]);*	 			break;   
 		default: 			printf("uh oh\n");t	 			break;    		}r   }n   /* **++ **  FUNCTIONAL DESCRIPTION:  ** **A **	MouseSizeproc - user is selecting an image area with the mousew ** ** ** **-- */   static void	MouseSizeproc( )   {> XtInputMask eventtype;  Q         XtAddEventHandler(WidgetID[k_workwidget], ButtonPressMask, FALSE,        S 				ButtonPressproc, NULL);e   }p   /* **++ **  FUNCTIONAL DESCRIPTION:  **1 **	This is the Activate FileBox callback routine.t **8 **	It processes the input from the File Selection Widget ** **-- */  % static void FileBoxproc(w, tag, list)	
     Widget w;x
     int *tag; #     DwtListBoxCallbackStruct *list;I   {  	  DwtRendMask	rend;   DwtCompStringContext 	dwContext;
 char 		*text;e unsigned long	charset;
 int 		dir; unsigned long	lang;d   	 8 	/* save the previous file name in case you need to save 	   the current contents 	*/r  # 	strcpy(old_file,current.filename);t  3 	/* Now read the value of the file name selected */   4 	/* extract the filename from the compound string */  + 	DwtInitGetSegment(&dwContext, list->item);s- 	DwtGetNextSegment(&dwContext,&text,&charset,l 					&dir,&lang,&rend);  	D     	strcpy(current.filename,text);i
 	XFree(text);x  & 	/* And, unmanage the selection box */  & 	XtUnmanageChild(WidgetID[k_FileBox]);  9 	/* resensitize the Save button if file name not blank */b  # 	if (strlen(current.filename) == 0)i 		{p2 		/* received no file name don't do nothing but go 		   back to main routineU 		*/ 		printf("null name\n");	 		return;o 		}o  & 	XtSetArg(argl[0],DwtNsensitive,TRUE);, 	XtSetValues(WidgetID[k_SaveButton],argl,1);  % 	XDefineCursor(XtDisplay(mainwidget),*+ 			      XtWindow(mainwidget),wait_cursor);a   	XFlush(XtDisplay(toplevel));  	 
 	if (save_as)l! 		{	/* handle the save as case */  		MySaveFile();  	t. 		/* now reset the title and reset the flag */  3 		XtSetArg(argl[0],DwtNtitle,"FileBox_read_title");s   		DwtFetchSetValues(
 			Hierarchy,* 			WidgetID[k_FileBox],; 			argl, 			1);  ( 		XUndefineCursor(XtDisplay(mainwidget), 				XtWindow(mainwidget));   		save_as = FALSE; 		if (exit_flag) exit(1);  		if (insaveascaution) 			{& 			strcpy(current.filename,temp_file); 			DoFileInput();; 			insaveascaution = FALSE;* 			} 		}  	else*% 		{  	/* handle the read file case */   B 		/* if you've generated a new picture and haven't saved it, offer2 	   	the option to do so before opening a newfile  		*/ 		 		if (new_image) 			{ 			ShouldISave();  		 			XFlush(XtDisplay(toplevel));t) 			XtManageChild(WidgetID[k_CautionBox]);d 			} 		else 			{ 			DoFileInput();[ 			} 		}r 		 })   /* **++ **  FUNCTIONAL DESCRIPTION:b **: **	DoFileInput handles all the work of actually reading in **	the data, displaying, etc.H ** **	* ** **-- */   static void DoFileInput()u   {  		if (cancel_operation)e 			{% 			strcpy(current.filename,old_file);n) 			XUndefineCursor(XtDisplay(mainwidget),i 					XtWindow(mainwidget));,
 			return; 			}   	MyOpenFile();    & 	/* now read the header of the file */   	myreadheaderproc();  . 	/* update the values in the data entry box */   	ResetDataValues();   ( 	/* mallocate some space for the data */    B 	/* check and see whether the contents have been generated yet */      	if (current.exists == 1)R 		{(
 		makeroom();;. 		readmand();  /* read the rest of the file */ 		MyCloseFile();- 		makeimage(); /* put it into image format */e- 		MyWindowResize(); /* set the window size */t( 		dispmand();  /* and then display it */> 		XUndefineCursor(XtDisplay(mainwidget),XtWindow(mainwidget));
 		return;  		}  		  . 	/* if nothing there then blank the display */  1 	XClearWindow(	XtDisplay(WidgetID[k_workwidget]), % 			XtWindow(WidgetID[k_workwidget]));I 	MyCloseFile();n  = 	XUndefineCursor(XtDisplay(mainwidget),XtWindow(mainwidget));p }      /* **++ **  FUNCTIONAL DESCRIPTION:W **. **	This is the CancelFileBox callback routine. **A **	It handles the case where the user presses the -cancel- buttono ** **-- */   static void CancelFileBoxproc()s   { & 	XtUnmanageChild(WidgetID[k_FileBox]);  
 	if (save_as)C 		{	 		/* handle the save as case */*  . 		/* now reset the title and reset the flag */  3 		XtSetArg(argl[0],DwtNtitle,"FileBox_read_title");h   		DwtFetchSetValues(
 			Hierarchy,t 			WidgetID[k_FileBox],  			argl, 			1);  ( 		XUndefineCursor(XtDisplay(mainwidget), 				XtWindow(mainwidget));   		save_as = FALSE; 		}b   }s   /* **++ **  FUNCTIONAL DESCRIPTION:  **> **	This proc. reads the header of a mandelbrot file, passed in **	the structure current.t ** ** **-- */   static void myreadheaderproc()   {F    ) fscanf(current.fip,"%d",&current.exists);e' fscanf(current.fip,"%E",&current.real);r, fscanf(current.fip,"%E",&current.imaginary);' fscanf(current.fip,"%E",&current.side);S& fscanf(current.fip,"%d",&current.pic);% fscanf(current.fip,"%d",&current.it);r   }          /* **++ **  FUNCTIONAL DESCRIPTION:a **> **  	Allocate enough memory to fit the image.  First time thru! **	malloc it, after that realloc.l ** ** **-- */   static void makeroom()   {L int mysize;t  0 	mysize = current.pic*current.pic*sizeof(*hptr);   	if (first)  		{ " 		hptr = (char *)XtMalloc(mysize); 		if (hptr == 0)& 			 error("Can't Allocate Memory.\n"); 		first = FALSE;	 		return;u 		};' 	hptr = (char *)XtRealloc(hptr,mysize);) 	if (hptr == 0)+& 		error("Can't Reallocate Memory.\n");   }s       static void mzoom()r /* **++ **  FUNCTIONAL DESCRIPTION:g **A **	Routine to actual generate the Mandelbrot set.  At the end of c) **	the generation it is written to a fileg ** ** **-- */   { % int n,m,count,mcount,scount,numbytes; # double az,bz,azs,bzs,act,gap,ac,bc;d XtInputMask eventtype; static int mycount;L  * 	gap = current.side / (double)current.pic;  8 	while (eventtype = XtAppPending(Context) == XtIMXEvent) 		{.,                 XFlush(XtDisplay(toplevel));9 		if ( XtAppPeekEvent(Context,&work_event) == XtIMXEvent)o 			{) 			XtAppProcessEvent(Context,XtIMXEvent);  			} 		}t  9 	/* put up the status display in the WIP box.  First drawa> 	   the decorations then when appropriate update the progress. 	*/d  . 	total = 0; /* reset the percentage counter */     mycount = 0;  ! for (m = 0; m < current.pic; m++)_ 	{5 	/* once every outer loop, give a chance to cancel */b   	if (kill_launch)  		{i 		ReInit();)	 		return;k 		}   " 	for (n = 0; n < current.pic; n++) 		{R& 		ac = current.real + ((double)n*gap);+ 		bc = current.imaginary + ((double)m*gap);a	 		az = 0;e	 		bz = 0;x 		count = 0; 		azs = az * az; 		bzs = bz * bz;  : 	/* every hundred times peek ahead - there's a performance7 	   hit for this, but it let's you see what's going on.* 	*/e   	if ( (n % 100) == 0)* 		{ 9 		while (eventtype = XtAppPending(Context) == XtIMXEvent)	 			{4                         XFlush(XtDisplay(toplevel));: 			if ( XtAppPeekEvent(Context,&work_event) == XtIMXEvent) 				{i* 				XtAppProcessEvent(Context,XtIMXEvent); 				}	 			} 		}u  . 		while (count++ < current.it && azs+bzs <= 4) 			{ 			act = az; 			az = azs - bzs + ac;a 			bz = (2.*act * bz) + bc;g 			azs = az * az;l 			bzs = bz * bz;k 			} 		$ 		*(hptr+(mycount++)) = (char)count;   		}  /* end of n loop */    	/* update the status display */  > 	total = total + ((float)PROGRESS_WIDTH / (float)current.pic);  2 	XDrawLine ( 	XtDisplay(WidgetID[k_progress_box]),& 			XtWindow(WidgetID[k_progress_box]), 			progressGC, 			PROGRESS_SX,R 			PROGRESS_SY,C 			PROGRESS_SX+(int)total, 			PROGRESS_SY);   	}  /* end of m loop */* 	* 	current.exists = 1;   	new_image = TRUE;  / 	if (XtIsManaged(WidgetID[k_LaunchInProgress]))g0 		XtUnmanageChild(WidgetID[k_LaunchInProgress]); }    /* **++ **  FUNCTIONAL DESCRIPTION:  **9 **	Re-init - set up the program variables indicating thati= **	you have no image, but you might still have a filename andy **	some parameters.l ** ** **-- */   static void ReInit() { 9         XtSetSensitive(WidgetID[k_VerticalScroll],FALSE);o4 	XtSetSensitive(WidgetID[k_HorizontalScroll],FALSE); 	first = TRUE;   	current.exists = 0; 	XtFree(hptr); 	k1 	XClearWindow(	XtDisplay(WidgetID[k_workwidget]), % 			XtWindow(WidgetID[k_workwidget]));N1 	XtSetSensitive(WidgetID[k_AnimateButton],FALSE);s3 	XtSetSensitive(WidgetID[k_BrainFadeButton],FALSE);  	- }/       /* **++ **  FUNCTIONAL DESCRIPTION:u **: **	Read the remaining contents of an image file, into the  **	holding area. ** ** **-- */   static void readmand()   {e   int m,numbytes;      	if (numbytes = fread(hptr 		,current.pic*sizeof(*hptr)$ 		,current.pic,current.fip) != EOF);     }h   /* **++ **  FUNCTIONAL DESCRIPTION:* **< **	Take the contents of the holdingarea and place it into an= **	image structure.  This is the first time after an image is ? **	is generated, and then each time an image is read from disk.* ** ** **-- */   static void makeimage()n   {d 	if (current.image != NULL)t 		{e" 		/* destroy the previous image */5 		/* don't worry about the image data, that's handlede 		   elsewhere.) 		*/ 		XFree(current.image);  		}i    	current.image = XCreateImage( 	% 			XtDisplay(WidgetID[k_workwidget]),/6 			DefaultVisual(XtDisplay(WidgetID[k_workwidget]),0),5 			DefaultDepth(XtDisplay(WidgetID[k_workwidget]),0),n 			ZPixmap,D 			0,s 			hptr, 			current.pic,) 			current.pic,x 			8,  			0); }g   /* **++ **  FUNCTIONAL DESCRIPTION:d **> **	Display the Current Instance Mandelbrot image on the screen: **	Assume all the proper windows are made, but not managed ** ** **-- */   static void dispmand() {   = 	/* first clear the window in case the new display is smaller;    	   than the old one. 	*/(  1 	XClearWindow(	XtDisplay(WidgetID[k_workwidget]),_% 			XtWindow(WidgetID[k_workwidget]));X  * 	/* now write the image into the window */  . 	XPutImage(	XtDisplay(WidgetID[k_workwidget]),$ 			XtWindow(WidgetID[k_workwidget]),2 			DefaultGC(XtDisplay(WidgetID[k_workwidget]),0), 			current.image,e 			0,s 			0,f 			0,  			0,e! 			MIN(current.pic,window_width),d# 			MIN(current.pic,window_height));	 	eA 	/* Sensitize the mouse button, because there is now something toC 	   select from. 	*/g  & 	XtSetArg(argl[0],DwtNsensitive,TRUE);1 	XtSetValues(WidgetID[k_MouseSizeButton],argl,1);a* 	/* and sensitize the animation buttons */  7         XtSetSensitive(WidgetID[k_AnimateButton],TRUE);L9         XtSetSensitive(WidgetID[k_BrainFadeButton],TRUE);e   	/* reset the scroll bars */   	ResetScrollBars ();   }v     /* **++ **  FUNCTIONAL DESCRIPTION:r **D **	Resize the mainwindow and workwindow to display the entire image.< **	This is the default, then the user can resize from there. ** ** **-- */   static void MyWindowResize() {p 	)2 	GetWindowSize(); /* for the first time through */ 	if (auto_resize)* 		{l* 		XtSetArg(argl[0],DwtNwidth,current.pic);+ 		XtSetArg(argl[1],DwtNheight,current.pic);*- 		XtSetValues(WidgetID[k_workwidget],argl,2);  		GetWindowSize ();e 		}n   }	     /* **++ **  FUNCTIONAL DESCRIPTION:  **- **	Retrieve the data from the data entry box.W ** ** **-- */    static void RetrieveDataValues()   {    char *input_text;a  2 	input_text = DwtSTextGetString(WidgetID[k_xdim]); 	current.real = 0;) 	sscanf(input_text, "%E", &current.real); 2 	input_text = DwtSTextGetString(WidgetID[k_ydim]); 	current.imaginary = 0; . 	sscanf(input_text, "%E", &current.imaginary);4 	input_text = DwtSTextGetString(WidgetID[k_length]); 	current.side = 0;) 	sscanf(input_text, "%E", &current.side);m4 	input_text = DwtSTextGetString(WidgetID[k_pixels]); 	current.pic = 0;n( 	sscanf(input_text, "%d", &current.pic);8 	input_text = DwtSTextGetString(WidgetID[k_iterations]); 	current.it = 0;' 	sscanf(input_text, "%d", &current.it);t   }t     /* **++ **  FUNCTIONAL DESCRIPTION:X ** **" **	Reset the data entry box values ** **-- */   static void ResetDataValues()n   {X) 	/* reset back to the current instance */o   char temptext[20];    % 	sprintf(temptext,"%G",current.real); . 	DwtSTextSetString(WidgetID[k_xdim],temptext);* 	sprintf(temptext,"%G",current.imaginary);. 	DwtSTextSetString(WidgetID[k_ydim],temptext);% 	sprintf(temptext,"%G",current.side); 0 	DwtSTextSetString(WidgetID[k_length],temptext);$ 	sprintf(temptext,"%d",current.pic);0 	DwtSTextSetString(WidgetID[k_pixels],temptext);# 	sprintf(temptext,"%d",current.it);t4 	DwtSTextSetString(WidgetID[k_iterations],temptext); 	e }c     /* **++ **  FUNCTIONAL DESCRIPTION:	 **( **	Retrieve the data from the color box. ** ** **-- */  ! static void RetrieveColorValues()	   {    char *input_text;U  6 	input_text = DwtSTextGetString(WidgetID[k_red_mult]);% 	sscanf(input_text, "%d", &red_mult);e8 	input_text = DwtSTextGetString(WidgetID[k_green_mult]);' 	sscanf(input_text, "%d", &green_mult);f7 	input_text = DwtSTextGetString(WidgetID[k_blue_mult]);e& 	sscanf(input_text, "%d", &blue_mult);   }i     /* **++ **  FUNCTIONAL DESCRIPTION:t ** **$ **	Reset the values in the color box ** ** **-- */   static void ResetColorValues()   { ) 	/* reset back to the current instance */    char temptext[20];    % 	sprintf(temptext,"%d",old_red_mult);*2 	DwtSTextSetString(WidgetID[k_red_mult],temptext);' 	sprintf(temptext,"%d",old_green_mult);e4 	DwtSTextSetString(WidgetID[k_green_mult],temptext);& 	sprintf(temptext,"%d",old_blue_mult);3 	DwtSTextSetString(WidgetID[k_blue_mult],temptext);t }l    !                                  	 /* **++ **  FUNCTIONAL DESCRIPTION:o ** ** **	MyOpenFile Opens a file.  r ** ** **-- */   static void MyOpenFile()   {t
 	if ((int)6 	(current.fip = fopen(current.filename,"r+")) == NULL) 		{t/ 		/* open a new file if old file isn't there */  		if ((int)g 			(current.fip = * 				fopen(current.filename,"w+")) == NULL),         				printf("Can't open file, %s\n",	 						current.filename); 		}n 	new_image = FALSE;t 	dirty = FALSE;L   }g     /* **++ **  FUNCTIONAL DESCRIPTION:  ** **) **	MyCloseFile closes an existing file.  v ** ** **-- */   static void MyCloseFile ()   {) 	fclose(current.fip);n }o     /* **++ **  FUNCTIONAL DESCRIPTION:	 **F **	This is the actual file save routine.  Assume that if you've gottenF **      here you have an open file, but the data is no good.  So reset? **	to the beginning of the file and save what you have.  Eitherp: **	the parameters or the parameters and data if it exists. **	The file is not closed here.e ** ** **-- */   static void	MySaveFile( )i {k
 int numbytes;	 	   	e 	MyOpenFile();  , 	fprintf(current.fip,"%d\n",current.exists);* 	fprintf(current.fip,"%G\n",current.real);/ 	fprintf(current.fip,"%G\n",current.imaginary); * 	fprintf(current.fip,"%G\n",current.side);) 	fprintf(current.fip,"%d\n",current.pic);u( 	fprintf(current.fip,"%d\n",current.it);   	fflush(current.fip);u   	if (current.exists == 1)n 		numbytes = fwrite(hptr,1 				current.pic*sizeof(*hptr), 				current.pic,current.fip);  	new_image = FALSE;  	dirty = FALSE;  	MyCloseFile();l }t   /* **++ **  FUNCTIONAL DESCRIPTION:t ** **B **	ShouldISave asks the eternal question: do you want to save your. **	old data before messing with the new stuff? ** ** **-- */   static void ShouldISave()  	a {  	 ' 	XtManageChild(WidgetID[k_CautionBox]);g   }a   /* **++ **  FUNCTIONAL DESCRIPTION:  ** **% **	SetUpColorMap creates the colormap  ** ** **-- */   static void SetUpColorMap ()   {/   	/* Set up the colormap */   	vInfoDummy.visualid = e4 			(DefaultVisual(XtDisplay(toplevel),0))->visualid; 	pVisualInfo = n& 			XGetVisualInfo(XtDisplay(toplevel),# 			VisualIDMask,&vInfoDummy,&nVis);_( 	pixel = WhitePixel(XtDisplay(toplevel),* 			   DefaultScreen(XtDisplay(toplevel))); 	updateColor = 0;   ) 	if (pVisualInfo->class != PseudoColor &&e) 	    pVisualInfo->class != DirectColor &&l% 	    pVisualInfo->class != GrayScale)  	    {  + 		error("Unable to use this visual class");-
 		exit(0); 	    }  - 	if (colorCount > pVisualInfo->colormap_size) / 	    colorCount = pVisualInfo->colormap_size-2;  	a, 	map = XDefaultColormap(XtDisplay(toplevel),( 				DefaultScreen(XtDisplay(toplevel)));  @ 	XSetWindowColormap(XtDisplay(toplevel),XtWindow(toplevel),map); 	]! 	/* Set up a graphics context: */t  9 	colors = (XColor *)XtMalloc(sizeof(*colors)*colorCount);d 	I }_   /* **++ **  FUNCTIONAL DESCRIPTION:r ** **/ **	And then load some colors into the color mapA ** ** **-- */     static void LoadColorMap(count)S   int *count;  {        unsigned int i,j,fullcount;N     double h,r,g,b;e     int rx,gx,bx;      int dummy;  . 	while (!XAllocColorCells(XtDisplay(toplevel),1 				map,0,&dummy,0,pixels,*count) && *count >= 1)  	    { 	    (*count)--; 	    } 	if (*count < 1) 	    {/ 	    error("Could not allocate enough colors"); 
 	    exit(0);I 	    }  C 	/* This loop find out if we are using WhitePixel and BlackPixel */t   	fullcount = *count;  " 	for (j=0,i=0; i < fullcount; i++) 	    {3 	    if (pixels[i]==BlackPixel(XtDisplay(toplevel),f+ 				DefaultScreen(XtDisplay(toplevel))) || a- 			pixels[i]==WhitePixel(XtDisplay(toplevel), ( 				DefaultScreen(XtDisplay(toplevel)))) 		{d+ 		if (XAllocColorCells(XtDisplay(toplevel),e" 					map,0,&dummy,0,&pixels[i],1))4 		    i--; /*Got a replacement value; try it again*/ 		else5 		    (*count)--; /*No replacement; forget this one*/X 		}l	 	    else[ 		{k  		colors[j++].pixel = pixels[i]; 		}( 	    }   	if (*count < 1) 	    {/ 	    error("Could not allocate enough colors");r
 	    exit(0);8 	    }  %     /*This loop fills in the colors*/P         for (i=0; i<*count ; i++)I 	{ 	colors[i].flags=7;o 	colors[i].red = 0;m 	colors[i].green = 0;s 	colors[i].blue = 0; 	}8     XStoreColors(XtDisplay(toplevel),map,colors,*count);       UpdateColorMap(count); }n      /* **++ **  FUNCTIONAL DESCRIPTION:n ** **= **	UpdateColorMap - actually sticks new values into color mapn ** ** ** **-- */    ! static void UpdateColorMap(count)o   int *count;    {u   int i;       for (i=0; i<*count ; i++)  	{ 	if (effect) 		{w 		colors[i].flags=doprimary;6 		colors[i].red = ((i*256)/(*count)) * 256 * red_mult;9 		colors[i].green = ((i*256)/(*count))* 256 * green_mult;i6 		colors[i].blue = ((i*256)/(*count))*256 * blue_mult; 		}z 	elseo 		{u 		colors[i].flags=doprimary;7 		colors[i].red = ((i*256)/(*count)) * 256 << red_mult;w: 		colors[i].green = ((i*256)/(*count))* 256 << green_mult;7 		colors[i].blue = ((i*256)/(*count))*256 << blue_mult;  		}  	}  8     XStoreColors(XtDisplay(toplevel),map,colors,*count);   }i     /* **++ **  FUNCTIONAL DESCRIPTION:  **; **	ColorIconproc handles the icon push buttons in the color* **	options dialog box. ** ** **-- */  + static void ColorIconproc ( w, tag, reason)l 	Widget	*w; 
 	int	*tag; 	unsigned long reason; {e  G int widget_num = *tag;              /* Convert tag to widget number. */e char temptext[20];   	switch (widget_num) 		{m 		case k_red_up: 			red_mult = red_mult + inc;g# 			sprintf(temptext,"%d",red_mult);t4 			DwtSTextSetString(WidgetID[k_red_mult],temptext);	 			break;k 		 		case k_red_down: 			red_mult = red_mult - inc;	# 			sprintf(temptext,"%d",red_mult);P4 			DwtSTextSetString(WidgetID[k_red_mult],temptext);	 			break;*   		case k_green_up:! 			green_mult = green_mult + inc;h% 			sprintf(temptext,"%d",green_mult);e6 			DwtSTextSetString(WidgetID[k_green_mult],temptext);	 			break;e 		 		case k_green_down:! 			green_mult = green_mult - inc;i% 			sprintf(temptext,"%d",green_mult);06 			DwtSTextSetString(WidgetID[k_green_mult],temptext);	 			break;w   		case k_blue_up:t 			blue_mult = blue_mult + inc;;$ 			sprintf(temptext,"%d",blue_mult);5 			DwtSTextSetString(WidgetID[k_blue_mult],temptext);l	 			break;e 		 		case k_blue_down:u 			blue_mult = blue_mult - inc;p$ 			sprintf(temptext,"%d",blue_mult);5 			DwtSTextSetString(WidgetID[k_blue_mult],temptext);%	 			break;t 		
 		default: 			printf("uh oh\n");N	 			break;I 		}  		UpdateColorMap(&colorCount);   }a   /* **++ **  FUNCTIONAL DESCRIPTION:t ** **> **	Effectsproc - sets the global flag effect to 0 if the users< **	chooses the multiply effect and 1 if the user chooses the **	shift effect. ** ** ** **-- */  ) static void Effectsproc ( w, tag, reason)  	Widget	*w;t
 	int	*tag; 	unsigned long reason; {n  K     int widget_num = *tag;              /* Convert tag to widget number. */t   	switch (widget_num) 		{r 		case k_mult: 			effect = 0;	 			break;i 		case k_shift:  			effect = 1;	 			break;e
 		default: 			error("uh oh"); 		}[   	UpdateColorMap(&colorCount);  }    /* **++ **  FUNCTIONAL DESCRIPTION:* ** **6 **	Incproc - determine the size of the color increment ** ** **-- */  % static void Incproc ( w, tag, reason)t 	Widget	*w;t
 	int	*tag; 	unsigned long reason; {m  K     int widget_num = *tag;              /* Convert tag to widget number. */(   	switch (widget_num) 		{c 		case k_1:t 			inc = INC_10;	 			break;t 		case k_10: 			inc = INC_1;t	 			break;u
 		default: 			error("uh oh"); 		}u }u   /* **++ **  FUNCTIONAL DESCRIPTION:D ** **5 **	GetWindowSize returns the X and Y window size into  **	window_width, window_height.C0 **	It also sets some values for the scroll bars. ** ** ** **-- */   static void GetWindowSize()t   {%? static 	int y_dist, x_dist; 	/* temp variables for scrolling */e  + 	XtSetArg(argl[0],DwtNwidth,&window_width); - 	XtSetArg(argl[1],DwtNheight,&window_height);e, 	XtGetValues(WidgetID[k_workwidget],argl,2); 	t5 	/* take into account the width of the scroll bars */    	window_height = window_height;	 	window_width = window_width;R  @ 	/* Compute the number of pixels per step for the scroll bars */  & 	y_dist = current.pic - window_height;1 	y_step = MAX(1,(int) y_dist / MAX_SCROLL);      =   	upper_image_from = 0;" 	lower_image_from = window_height;  % 	x_dist = current.pic - window_width;o1 	x_step = MAX(1,(int) x_dist / MAX_SCROLL);      r   	left_image_from = 0;\! 	right_image_from = window_width;n 	n }i   /* **++ **  FUNCTIONAL DESCRIPTION:  ** **= **	ResetScrollBars resets the sliders to the top and left and  **	sets the values to 0  ** ** ** **-- */   static void ResetScrollBars()s   {r static int shown;    	GetWindowSize();N 	D 	/* vertical scroll bar */   	y_scroll = 0; 	y_old_scroll = 0; 	upper_image_from = 0;" 	lower_image_from = window_height;  < 	shown = (int) ((float)MAX_SCROLL * ((float)window_height /  					(float)current.pic));  2 	DwtScrollBarSetSlider(WidgetID[k_VerticalScroll], 			0,e	 			shown,T- 			1,10,TRUE); /* rather arbitrary numbers */    	/* horizontal scroll bar */   	x_scroll = 0; 	x_old_scroll = 0; 	left_image_from = 0;f! 	right_image_from = window_width;f    ; 	shown = (int) ((float)MAX_SCROLL * ((float)window_width / u 					(float)current.pic));  4 	DwtScrollBarSetSlider(WidgetID[k_HorizontalScroll], 			0,,	 			shown,)- 			1,10,TRUE); /* rather arbitrary numbers */    }s     /* **++ **  FUNCTIONAL DESCRIPTION:1 ** **+ **	MyVertScroll - perform a vertical scrollf ** ** ** **-- */  ! static void MyVertScroll(y_value)E
 int *y_value;L {  static int y_delta;t) static int area_height,area_from,area_to; , static int image_height,image_from,image_to;  ' 	/* first compute the distance moved */e     	y_old_scroll = y_scroll;? 	y_scroll = *y_value * y_step;# 	y_delta = y_scroll - y_old_scroll;g  7 	/* next the area of good data on the screen to copy */C   	if (y_delta > 0)  		{*( 		area_height = window_height - y_delta; 		area_from = y_delta; 		area_to = 0; 		}  	else/ 		{/( 		area_height = window_height + y_delta; 		area_from = 0; 		area_to = -y_delta;o 		}l  )A 	/* finally the new area that must be brought in and displayed */l   	if (y_delta > 0)v 		{u 		image_height = y_delta;e  		image_from = lower_image_from;0 		lower_image_from = lower_image_from + y_delta;% 		if (lower_image_from > current.pic)e" 			lower_image_from = current.pic;0 		upper_image_from = upper_image_from + y_delta;& 		if (upper_image_from > current.pic) " 			upper_image_from = current.pic;% 		image_to = window_height - y_delta;I 		}	 	else_ 		{  		image_height = -y_delta;0 		lower_image_from = lower_image_from + y_delta;0 		upper_image_from = upper_image_from + y_delta;  		image_from = upper_image_from; 		image_to = 0;l 		},  . 	XCopyArea(	XtDisplay(WidgetID[k_workwidget]),$ 			XtWindow(WidgetID[k_workwidget]),$ 			XtWindow(WidgetID[k_workwidget]),2 			DefaultGC(XtDisplay(WidgetID[k_workwidget]),0), 			0, 
 			area_from,d 			current.pic,  			area_height,* 			0,* 			area_to);   	XFlush(XtDisplay(toplevel));   . 	XPutImage(	XtDisplay(WidgetID[k_workwidget]),$ 			XtWindow(WidgetID[k_workwidget]),2 			DefaultGC(XtDisplay(WidgetID[k_workwidget]),0), 			current.image,, 			left_image_from,p 			image_from, 			0,  			image_to, 			current.pic,; 			image_height);n }    /* **++ **  FUNCTIONAL DESCRIPTION:e ** **- **	MyHorzScroll - perform a Horizontal scrolll ** ** ** **-- */    static void MyHorScroll(x_value)
 int *x_value;= {o static int x_delta;;( static int area_width,area_from,area_to;+ static int image_width,image_from,image_to;	  ' 	/* first compute the distance moved */	   	x_old_scroll = x_scroll;l 	x_scroll = *x_value * x_step;# 	x_delta = x_scroll - x_old_scroll;(  7 	/* next the area of good data on the screen to copy */,   	if (x_delta > 0)  		{/& 		area_width = window_width - x_delta; 		area_from = x_delta; 		area_to = 0; 		}  	elset 		{n& 		area_width = window_width + x_delta; 		area_from = 0; 		area_to = -x_delta;i 		}o   A 	/* finally the new area that must be brought in and displayed */    	if (x_delta > 0)  		{* 		image_width = x_delta;  		image_from = right_image_from;0 		right_image_from = right_image_from + x_delta;% 		if (right_image_from > current.pic)[" 			right_image_from = current.pic;. 		left_image_from = left_image_from + x_delta;% 		if (left_image_from > current.pic) +! 			left_image_from = current.pic; $ 		image_to = window_width - x_delta; 		}	 	elsei 		{o 		image_width = -x_delta; 0 		right_image_from = right_image_from + x_delta;. 		left_image_from = left_image_from + x_delta; 		image_from = left_image_from;w 		image_to = 0;g 		}r  . 	XCopyArea(	XtDisplay(WidgetID[k_workwidget]),$ 			XtWindow(WidgetID[k_workwidget]),$ 			XtWindow(WidgetID[k_workwidget]),2 			DefaultGC(XtDisplay(WidgetID[k_workwidget]),0),
 			area_from,  			0,	 			area_width, 			current.pic,o 			area_to,( 			0);   	XFlush(XtDisplay(toplevel));o  . 	XPutImage(	XtDisplay(WidgetID[k_workwidget]),$ 			XtWindow(WidgetID[k_workwidget]),2 			DefaultGC(XtDisplay(WidgetID[k_workwidget]),0), 			current.image,e 			image_from, 			upper_image_from, 			image_to, 			0,D 			image_width,  			current.pic); }l     /* **++ **  FUNCTIONAL DESCRIPTION:o ** **D **	ButtonPressproc an event handler called whenever the user presses **	a mouse button  ** ** ** **-- */    ; static XtEventHandler ButtonPressproc ( widget, tag, event)e   Widget widget;
 char *tag; XButtonEvent *event;   {c  = Window root_win, child_win;   /* returns for query pointer */i int root_x, root_y;t/ int my_x, my_y;	/* the numbers I really want */IB unsigned int my_buttons; /* status of the buttons at query time */  / int org_x, org_y; 	/* starting origin of box */r  9 int from_x, from_y, box_size; /* used to actually draw */t  < int old_x, old_y, old_size;   /* for erasing previous box */  L double real_out, imaginary_out; /* converted coordinates in complex plane */' double side_out;		/* converted width */    XtInputMask	eventtype;   	org_x = event->x; 	org_y = event->y; 	m 	old_size = 0;  @ 	    /* raise the window to get the dialog box out of the way */  4 	    XRaiseWindow(XtDisplay(WidgetID[k_workwidget]),& 			 XtWindow(WidgetID[k_workwidget]));                 do               {[  >               XQueryPointer(XtDisplay(WidgetID[k_workwidget]),& 				XtWindow(WidgetID[k_workwidget]),  				&root_win, &child_win,$                 		&root_x, &root_y,  				&my_x, &my_y, &my_buttons);	  % 	      if (my_buttons & Button3Mask) b 			{ 			if (!first_box) 				XDrawRectangle( 6                   		XtDisplay(WidgetID[k_workwidget]),5                   		XtWindow(WidgetID[k_workwidget]),u                   		rubberGC,f!                   		old_x, old_y, (                   		old_size, old_size);  < 		            /* remove the event handler, not needed now */  4 			    XtRemoveEventHandler(WidgetID[k_workwidget],  							ButtonPressMask, FALSE, 							ButtonPressproc, NULL); 			    return; 			}   	      m6 		/* rectangle only takes positive numbers, also force 		   to be square. 		*/   	box_size = : 		(int)sqrt((double)abs(((my_x - org_x) * (my_x-org_x)) + ( 				((my_y - org_y) * (my_y - org_y))));   		if (my_x > org_x)r 			{ 			from_x = org_x; 			} 		else 			{ 			from_x = org_x - box_size;  			}   		if (my_y > org_y)w 			from_y = org_y; 		else 			from_y = org_y - box_size;t   	    if ( box_size != old_size)t 		{t 		if (first_box) 			{ 			XDrawRectangle(& 				XtDisplay(WidgetID[k_workwidget]),% 				XtWindow(WidgetID[k_workwidget]),1
 				rubberGC,  				from_x, from_y," 				box_size, box_size); 			first_box = FALSE;S 			old_x = from_x; 			old_y = from_y; 			old_size = box_size;	 			} 		else 			{, 			/* erase the old box then draw new one */    	                XDrawRectangle(B                                 XtDisplay(WidgetID[k_workwidget]),A                                 XtWindow(WidgetID[k_workwidget]),0)                                 rubberGC,l-                                 old_x, old_y,W4                                 old_size, old_size); 	 (                          XDrawRectangle(B                                 XtDisplay(WidgetID[k_workwidget]),A                                 XtWindow(WidgetID[k_workwidget]),s)                                 rubberGC, /                                 from_x, from_y,r4                                 box_size, box_size); 			} 		old_x = from_x;  		old_y = from_y;s 		old_size = box_size;	/ 		}S               } .              while (my_buttons & Button1Mask);  : 	/* when you're all done set first_box true so it's set up 	   for the next time thru 	*/    	first_box = TRUE;  5 	/* and one final one to turn off the previous one */-   	XDrawRectangle(4                   XtDisplay(WidgetID[k_workwidget]),3                   XtWindow(WidgetID[k_workwidget]),r                   rubberGC,                    old_x, old_y,a&                   old_size, old_size);  / 	/* remove the event handler, not needed now */	  E 	XtRemoveEventHandler(WidgetID[k_workwidget], ButtonPressMask, FALSE,o 				ButtonPressproc, NULL);1  D 	/* convert the selected area to coordinates in the complex plane */  0 	ConvertCoords(from_x,from_y,box_size,&real_out, 					&imaginary_out,&side_out);   - 	/* and display them in the data entry box */R  3 	DisplayMouseData(real_out,imaginary_out,side_out);)   }         /* **++ **  FUNCTIONAL DESCRIPTION:o ** *** **	Initialize variables for the rubber box ** ** ** **-- */   static void InitRubberBox()N     {R% 	rubberGC_values.function = GXinvert;f/ 	rubberGC_values.foreground = current_fc.pixel;t/ 	rubberGC_values.background = current_bc.pixel;   2         rubberGC = XtGetGC(WidgetID[k_workwidget],6           		GCForeground | GCBackground | GCFunction,  			&rubberGC_values);t   	first_box = TRUE; }    /* **++ **  FUNCTIONAL DESCRIPTION:  ** **: **	Convert the input parameters from screen coordinates to# **	coordinates in the complex planen ** ** ** **-- */  A static void ConvertCoords(in_x,in_y,in_width,real,imaginary,side)f   int in_x, in_y, in_width;;    double *real, *imaginary, *side; {i7 	/* first take into account any scrolling that may haved 	   taken place. 	*/i   	in_x = in_x + left_image_from;u  	in_y = in_y + upper_image_from;   	*real = current.real +  			(double)((current.side /  				(double) current.pic) *  							(double) in_x);  ! 	*imaginary = current.imaginary +_ 			((current.side /  				(double) current.pic) *  							(double) in_y);  . 	*side = (current.side * (double) in_width) /  				(double) current.pic;	   }a     /* **++ **  FUNCTIONAL DESCRIPTION:_ ** **D ** 	Display the mouse data, but don't change the actuals, wait until **	users hits the OK button. ** ** ** **-- */  3 static void DisplayMouseData(real, imaginary, side)p   double real, imaginary, side;    {  char temptext[20];     	sprintf(temptext,"%G",real);W. 	DwtSTextSetString(WidgetID[k_xdim],temptext);" 	sprintf(temptext,"%G",imaginary);. 	DwtSTextSetString(WidgetID[k_ydim],temptext); 	sprintf(temptext,"%G",side); 0 	DwtSTextSetString(WidgetID[k_length],temptext);   }p /* **++ **  FUNCTIONAL DESCRIPTION:a **  **	Animate - flicker them colors ** ** ** **-- */     static void Animate(count,fade)[  5 char fade; /* if true then go into brain fade mode */m int *count;f {,   unsigned int tempcolor;c int i,j;  I   	XDefineCursor(XtDisplay(mainwidget),XtWindow(mainwidget),wait_cursor);   = 	/* if brain fade mode then just cycle once for the number of ! 	   colors, else animate forever.u 	*/n  ( 	for (j=0; fade ? j < *count : TRUE;j++) 	{!     	tempcolor = colors[0].pixel;t$     	for (i=0; i<((*count-1)) ; i++) 		{ .        		 colors[i].pixel = colors[i+1].pixel; 		}s   		if (fade)l& 			colors[(*count)].pixel = tempcolor; 		else( 			colors[(*count-1)].pixel = tempcolor;  5 	XStoreColors(XtDisplay(toplevel),map,colors,*count);a   	if (XtAppPending(Context))n 		{i9 		if ( XtAppPeekEvent(Context,&work_event) == XtIMXEvent)  			{) 			XtAppProcessEvent(Context,XtIMXEvent);e 			} 		}a   	if (kill_animation) break;a 	} 	o 	    /* reset for next time */   	    kill_animation = FALSE;  )        	    /* and restore to original */_   	    for (i=0; i<*count ; i++) 		{i 		colors[i].pixel = pixels[i]; 		colors[i].flags=7; 		colors[i].red = 0; 		colors[i].green = 0; 		colors[i].blue = 0;  		}n   	UpdateColorMap(count);   4 	/* if brain faded away then unmanage the wip box */  0 	if (XtIsManaged(WidgetID[k_AnimateInProgress]))1 		XtUnmanageChild(WidgetID[k_AnimateInProgress]);o   	XFlush(XtDisplay(toplevel));i  = 	XUndefineCursor(XtDisplay(mainwidget),XtWindow(mainwidget));  }t     /* **++ **  FUNCTIONAL DESCRIPTION:_ ** **	mC **	Cancel Launchproc - cancel the mandelbrot generation in progressd ** ** ** **-- */   static void CancelLaunchproc() {i 	kill_launch = TRUE;/ 	XtUnmanageChild(WidgetID[k_LaunchInProgress]);0 }      /* **++ **  FUNCTIONAL DESCRIPTION:c **8 **	cancelanimateproc - cancel the animation and continue ** ** ** **-- */   static void CancelAnimateproc()    {W 	kill_animation = TRUE;e0 	XtUnmanageChild(WidgetID[k_AnimateInProgress]); }0   /* **++ **  FUNCTIONAL DESCRIPTION:	 ** **@ **	Create Icon - create a pixmap for the icon and create the ico ** ** **-- */   static void CreateIcon()   {     9 	icon_pixmap = XCreateBitmapFromData(XtDisplay(toplevel),  			      XtWindow(toplevel), 			      icon_bits,  			      icon_width, 			      icon_height);  < 	iconify_pixmap = XCreateBitmapFromData(XtDisplay(toplevel), 			      XtWindow(toplevel), 			      iconify_bits, 			      iconify_width,* 			      iconify_height);n  3 	XtSetArg(argl[0],XtNiconifyPixmap,iconify_pixmap);d- 	XtSetArg(argl[1],XtNiconPixmap,icon_pixmap);e 	XtSetValues(toplevel,argl,2);   }t   /* **++ **  FUNCTIONAL DESCRIPTION:r **? **	GetLocation - figures out the current size of the window and_7 **	computes where the work in progress boxes should go., ** ** ** **-- */   static void GetLocation()    { + static int caution_x, caution_y, caution_w;  static int wind_x, wind_y;  < 	/* place animate in progress box at upper right hand screen= 	   just outside of the main window if room, else just inside  	   main window. 	*/i  ' 	/* get the width of the caution box */w  ( 	XtSetArg(argl[0],DwtNwidth,&caution_w);3 	XtGetValues(WidgetID[k_AnimateInProgress],argl,1);t 	p* 	/* get the location of the main window */  ! 	XtSetArg(argl[0],DwtNx,&wind_x);i! 	XtSetArg(argl[1],DwtNy,&wind_y);r 	XtGetValues(toplevel,argl,2);  . 	caution_x = window_width + wind_x + X_MARGIN;  ' 	if (caution_x + caution_w > MAX_WIDTH)D 			caution_x = MAX_WIDTH   					- caution_w - X_MARGIN;  < 	caution_y =  (wind_y + Y_MARGIN) > MAX_HEIGHT ? Y_MARGIN :  							wind_y + Y_MARGIN;u    # 	XtSetArg(argl[0],DwtNx,caution_x);y# 	XtSetArg(argl[1],DwtNy,caution_y);_3 	XtSetValues(WidgetID[k_AnimateInProgress],argl,2);n }n   /* **++ **  FUNCTIONAL DESCRIPTION:e ** **	Helpproc - handle help	 ** ** ** **-- */  ) static void Helpproc(widget, tag, reason)r     	Widget widget;      	int *tag;$     	DwtAnyCallbackStruct *  reason; {e9     DwtCompString       firstTopic = (DwtCompString) tag;u     DRMType *           class;     int                 status;       Arg                 args[1];       /*D      If this is the first time that the user has selected help, then5      fetch the help widget from the widget hierarchy.;     */  .     if (WidgetID[k_HelpBox] == (Widget) NULL)    		{ 1         	if (DwtFetchWidget(Hierarchy, "HelpBox",eH                                 toplevel, &WidgetID[k_HelpBox], &dummy)  			!= DRMSuccess)	$ 			error("can't fetch help widget");
         	}    2     XtSetArg(args[0], DwtNfirstTopic, firstTopic);.     XtSetValues(WidgetID[k_HelpBox], args, 1);  '     XtManageChild(WidgetID[k_HelpBox]);n }a   /* **++ **  FUNCTIONAL DESCRIPTION:t **( **	End help proc - unmanage the help box ** ** ** **-- */   static void EndHelpproc()    { & 	XtUnmanageChild(WidgetID[k_HelpBox]); }    /* **++ **  FUNCTIONAL DESCRIPTION:  ** **      Command line usage ** ** ** **-- */              usage (program)e     char *program; {      fprintf(stderr,"\n");t7     fprintf(stderr,"Usage: %s [ options ] \n",program);D     fprintf(stderr,"\n"); ?     fprintf(stderr,"     Where options are one or more of:\n");      fprintf(stderr,"\n");bT     fprintf(stderr,"     [-x #] [-y #]                  x and y window position\n");S     fprintf(stderr,"     [-title WindowTitle]           Title of YADMAN window\n");b     fprintf(stderr,"\n");      exit(1); }    /* End of Yadman.c */t       