 /*  *  Program:	MX_DIGEST.C  *  *  Author:	Hunter Goatley  *		goathunter@WKUVX1.BITNET  *  *  Date:	October 7, 1992   *
  *  Abstract:   *=  *	This program is used by the MX SITE delivery to create raw D  *	mail files that are to be processed by MX_MAKE_DIGEST to create a=  *	mailing list digest.  All it does it append the input file @  *	to a file like "list-DIGEST.INPUT".  Note that it was written8  *	using the C I/O functions so that the file is created<  *	Stream_LF because DIGEST ueses ftell() and fseek() on it.  *  *  Modified by:  **  *	V1.0		Hunter Goatley		 7-OCT-1992 10:41  *		Genesis.  *  */  #include <stdio.h> #include <descrip.h> #include <ssdef.h> #include <libdef.h>  #include <rmsdef.h>  #include <rms.h> #include <string.h>    #include "mx_digest.h"   #define MAXLINE 512  #define RCPTBUFLEN  7 /* Define some macros to make things a little easier */   ? #define tracemsg(msg) if (trace) printf("MX_DIGEST: %s\n",msg); Q #define traceerr(msg) if (trace) printf("MX_DIGEST: Error status %%X%08x\n",msg);    /* EXTERNAL ROUTINE */ #ifdef __GNUC__ H char *strchr(const char *s, int character);	/* Not in GNU C strings.h */ #endif   /* FORWARD ROUTINE */ @ int log_accounting(char *digest, char *from, int digest_status);7 int add_to_digest (FILE *fp, char *digest, char *from);    int vms_status; 
 int trace;1 static $DESCRIPTOR(lnm_table,"LNM$SYSTEM_TABLE");     ! int main (int argc, char *argv[])  {    FILE *ifp;   FILE *rfp;   char rcptbuf[MAXLINE];4   static $DESCRIPTOR(MX_SITE_DEBUG,"MX_SITE_DEBUG");>   char *digest_name;			/* Pointer to folder name in rcptbuf */2   char *atsign;				/* Pointer to "@" in rcptbuf */    int  x;				/* Work variable */     /*L    *  Make sure the right number of arguments was given on the command line.    */    if (--argc != 3) {D 	printf ("Usage: mx_digest <filename> <recipient-file> <sender>\n"); 	return(LIB$_WRONUMARG);   }   ,   /*  See if we should trace our progress */?   trace = SYS$TRNLNM( 0, &lnm_table, &MX_SITE_DEBUG, 0, 0) & 1;   '   tracemsg("Opening message file...."); .   if ((ifp = fopen(argv[1], "r")) == NULL) {  2 	printf("Error opening input file %s\n", argv[1]); 	return(SS$_ABORT);    }   *   tracemsg("Opening recipients file....");.   if ((rfp = fopen(argv[2], "r")) == NULL) {  7 	printf("Error opening recipients file %s\n", argv[2]);  	perror("open rcpt");  	return(SS$_ABORT);    }      if (trace)9 	printf("MX_DIGEST: Using sender address %s\n", argv[3]);      /*F     Read through all the recipients, writing the message to all DIGEST>     files (identified by checking for @DIGEST in the address).   */0   while (fgets(rcptbuf, MAXLINE, rfp) != NULL) {2      tracemsg("Looking for DIGEST recipient....");;      digest_name = rcptbuf;			/* Point to receipt buffer */ ?      if (digest_name[0] == '<'){		/* If line begins with "<" */ 0 	++digest_name;				/*  bump over it and check */4 	atsign = strchr(rcptbuf,'@');		/*  for a "@"		   */1 	if (atsign != NULL)			/* If "@" was found,	   */ ? 	  if (strncmp(atsign,"@DIGEST",7)==0){	/* Is it @DIGEST?	   */ = 	    x = atsign - digest_name;		/* Length of folder name   */ : 	    digest_name[x] = '\0';		/* Terminate folder name   */ 	    if (trace) 9 		printf("MX_DIGEST: Found DIGEST list \042%s\042....\n",  			digest_name);3 	    tracemsg("Adding message to DIGEST file...."); ; 	    vms_status = add_to_digest(ifp, digest_name, argv[3]); 6 	    log_accounting(digest_name, argv[3], vms_status);7 	    rewind(ifp);	/* Rewind the file for next folder */ ! 	  }	/* if (strncmp(atsign.... */ !       }		/* if (digest_name[0] */    }		/* while (fgets... */       tracemsg("All done!");*   fclose(ifp);		/* Close the input file */)   fclose(rfp);		/* Close the rcpt file */   *   return(SS$_NORMAL);		/* Return to VMS */ }     6 int add_to_digest (FILE *fp, char *digest, char *from) { 
    FILE *ofp;     char ofile[80];    char s[MAXLINE];   '    sprintf(ofile, LISTINPUT_F, digest); 
    if (trace) E 	printf("MX_DIGEST: Opening digest file %s for append....\n", ofile); +    if ((ofp = fopen(ofile, "a")) == NULL) { < 	printf("MX_DIGEST: Error opening output file %s\n", ofile); 	perror("MX_DIGEST: open");  	return(SS$_ABORT);     }  1    /*  Print the message separator to the file */   -    tracemsg("Writing message separator...."); -    fprintf(ofp, "From-MX-SITE---%s\n", from);   G    /*  Now just read records from the input file and append them to the        output file.    */   4    tracemsg("Appending message to digest file....");(    while (fgets(s, MAXLINE, fp) != NULL) 	fputs(s, ofp);   -    fclose(ofp);			/* Close the output file */   
    return(1);  }        /*  *  *  Function:	log_accounting  *  *  Functional description:   *@  *	This routine will write an accounting record for the message.  *  *  Inputs:   *E  *	folder	- Address of a string descriptor for the name of the folder @  *	from	- Address of a string descriptor for the "From:" address@  *	status	- Address of longword containing the DIGEST error code  *  *  Outputs:  *  *	None.  *  *  Returns:  *!  *	unsigned long int - RMS status   *  */  int ; log_accounting(char *digest, char *from, int digest_status)  {      struct FAB accfab;     struct RAB accrab;>     static $DESCRIPTOR(MX_DIGEST_ACCNTNG,"MX_DIGEST_ACCNTNG");     static $DESCRIPTOR(faostr,H 	"!%D MX_DIGEST: DIGEST=\042!AZ\042, ORIGIN=\042!AZ\042, STATUS=%X!XL");     char outbufbuf[256];H     struct dsc$descriptor_s outbuf = {256, DSC$K_DTYPE_T, DSC$K_CLASS_S, 		 outbufbuf};       int status; .     static char digestacc[] = "MX_DIGEST_ACC";4     static char digestaccdef[] = "MX_SITE_DIR:.DAT";  B     status = SYS$TRNLNM( 0, &lnm_table, &MX_DIGEST_ACCNTNG, 0, 0);     if (!(status & 1)) 	return(SS$_NORMAL);  E     tracemsg("Writing accounting information to accounting log....");      accfab = cc$rms_fab;     accrab = cc$rms_rab;C     accfab.fab$b_fns = strlen(digestacc);	/* Set filename length */ =     accfab.fab$l_fna = digestacc;		/* Set filename address */ F     accfab.fab$b_dns = strlen(digestaccdef);	/* Set filename length */@     accfab.fab$l_dna = digestaccdef;		/* Set filename address */8     accfab.fab$b_fac = FAB$M_PUT;		/* PUT access only */>     accfab.fab$b_shr = FAB$M_SHRGET+FAB$M_SHRPUT+FAB$M_SHRUPD;@     accfab.fab$b_rfm = FAB$C_VAR;		/* Variable length records */9     accfab.fab$b_rat = FAB$M_CR;		/* Normal "text" rat */ <     accrab.rab$l_fab = &accfab;			/* Let RAB point to FAB */?     accrab.rab$b_rac = RAB$C_SEQ;		/* Sequential file access */   <     status = SYS$OPEN (&accfab);		/* Try to open the file */%     if (status & 1)				/* Success? */ 0 	accrab.rab$l_rop = RAB$M_EOF;		/* Set to EOF */+     else					/* Couldn't open, so create */ 4 	status = SYS$CREATE (&accfab);		/* ... a new one */1     if (status & 1){				/* If either was OK... */ 7 	status = SYS$CONNECT (&accrab);		/* Connect the RAB */ 6 	if (status == RMS$_EOF)			/* RMS$_EOF status is OK */4 	   status = RMS$_NORMAL;		/* Change it to NORMAL */2 	if (!(status & 1)){			/* If any error occurred *// 	   tracemsg("Unable to open accounting file");  	   traceerr(status); / 	   SYS$CLOSE (&accfab);			/* Close the file */ 0 	   return(status);			/* And return the error */ 	}     }      else 	return(status);  G     SYS$FAO(&faostr, &outbuf, &outbuf, 0, digest, from, digest_status); +     accrab.rab$w_rsz = outbuf.dsc$w_length; ,     accrab.rab$l_rbf = outbuf.dsc$a_pointer;     SYS$PUT (&accrab);     SYS$CLOSE (&accfab); } 