#ifndef	_NNTP_H_
#define	_NNTP_H_

/*
 *       Copyright (c) 1996-98 Ruslan R. Laishev (@RRL)
 */

/* Revision:
 *	TSV	- TSV@horse.rgti.spb.su"  "Sergey V. Tikhonov"
 *	TSV	15.07.97	-	add MULTINET declaration
 */

#include        <pthread.h>

#if	__VMS_VER > 70100000
	#define	$PTHREAD_CREATE(a,b,c,d)	pthread_create(a,b,c,d)
	#define	$PTHREAD_MUTEX_INIT(a)		pthread_mutex_init(a,0)
#else
	#define	$PTHREAD_CREATE(a,b,c,d)	pthread_create(a,pthread_attr_default,c,(pthread_addr_t) d)
	#define	$PTHREAD_MUTEX_INIT(a)		pthread_mutex_init(a,pthread_mutexattr_default)
typedef	unsigned short	ushort;
typedef	unsigned long	ulong;
typedef	unsigned char	uchar;
#endif

#include        <stdio.h>
#include        <stdlib.h>
#include        <time.h>
#include        <string.h>
#include	<time.h>
#include	<signal.h>
#include	<ctype.h>
#include	<errno.h>
#include	<rms.h>
#include	<xabkeydef.h>
#include	<starlet.h>
#include	<descrip.h>
#include	<ssdef.h>
#include	<stsdef.h>
#include	<lib$routines.h>
#include	<str$routines.h>
#include	<strdef.h>
#include	"global.h"
#include	"md5.h"

#ifdef __DECC
#include	<builtins.h>
#else
#pragma		builtins
#endif

#define INIT_SDESC(dsc, len, ptr) {(dsc).dsc$b_dtype = DSC$K_DTYPE_T;\
        (dsc).dsc$b_class = DSC$K_CLASS_S; (dsc).dsc$w_length = (len);\
        (dsc).dsc$a_pointer = (ptr);}

#define SET_SDESC(dsc, len, ptr) {(dsc).dsc$w_length = (len);\
        (dsc).dsc$a_pointer = (ptr);}

#define INIT_DDESC(dsc, len, ptr) {(dsc).dsc$b_dtype = DSC$K_DTYPE_T;\
        (dsc).dsc$b_class = DSC$K_CLASS_D;(dsc).dsc$w_length = (len);\
        (dsc).dsc$a_pointer = (ptr);}

#define	ASCIC(a)	a,sizeof(a)-1
/*
 *
 */
extern	char    *ID$IDcpy;
extern	char    *ID$IDsrv;
extern	char    *ID$IDver;
/*
 *
 */
#define	NNTP_TCPPORT	119
#define	NNTP_EOL	"\r\n"
#define	NNTP_EOM	"\r\n.\r\n"
#define	NNTP_EOT	".\r\n"
#define	NNTP_OK		".\r\n"

#define	NNTPMAXWORKER	128

#pragma	__member_alignment	__save
#pragma	__nomember_alignment 
/*
 *      Structure of nntp$msg.db
 */
#define MSG$_MRS	32224
#define MSGGRP$_LEN	96+12
#define MSGGRP$_REF	0

#define MSGID$_LEN	96
#define MSGID$_REF	1


typedef struct  {
		ushort	_w_gidlen;
	#define MSGGRP$_POS	sizeof(ushort)
		char	_t_gid[MSGGRP$_LEN];

		ushort	_w_midlen;
	#define MSGID$_POS	(MSGGRP$_LEN+2*sizeof(ushort))
		char	_t_mid[MSGID$_LEN];

                time_t	_l_date;
	#define	MSGMAXSZ	(MSG$_MRS-2*sizeof(ushort)-MSGGRP$_LEN-MSGID$_LEN-sizeof(time_t))
	#define MSGBODY$_POS	(2*sizeof(ushort)+MSGGRP$_LEN+MSGID$_LEN+sizeof(time_t))
		char	_t_body[MSGMAXSZ];
		} msgrec_t;


/*
 *      Structure of nntp$grp.db
 */

typedef struct  {					
		ulong	_l_first;	/* # of first available message		*/
		ulong	_l_last;	/* # of last available message		*/
		char	_c_postflag;	/* 'form of posting' flag		*/
		char	_c_suckflag;	/* 'group cached' flag			*/
                time_t	_l_datecr;	/* date of news group creation		*/
                time_t	_l_dateup;	/* date of last update			*/

	#define GRPNAME$_LEN	96  
		uchar	_b_len;		/* News group name length		*/
					/* News group name			*/ 
                char	_t_name [GRPNAME$_LEN];

	#define	_ac_grp	_b_len
                } grprec_t;


#define GRPNAME$_MRS	sizeof(grprec_t)
#define GRPNAME$_POS	(2*sizeof(long) + 3*sizeof(char) + 2*sizeof(time_t))
#define GRPNAME$_REF	0
/*
 *      Structure of nntp$suck.db and nntp$feed.db
 */
#define	FEED$NAME	0
#define	FEED$USER	1
#define	FEED$PASS	2
#define	FEED$GROUPS	3
#define	FEED$POSTING	4
#define	FEED$TCPPORT	5
#define	FEED$EXCLUDE	6
#define	FEED$ARGS	7

#define	SUCK$NAME	0
#define	SUCK$USER	1
#define	SUCK$PASS	2
#define	SUCK$GROUPS	3
#define	SUCK$TCPPORT	4
#define	SUCK$ARGS	5


typedef struct  {
		ulong	_l_last;	/* Index of last geted or feeded message*/

	#define	FEED$TYPE	'>'	/* Type of record: feed or suck		*/
	#define	SUCK$TYPE	'<'
					
	#define FEEDSUCK$_LEN	16	/* MDhash(IP name + group name)		*/
                char    _t_hash	[FEEDSUCK$_LEN];
                } fsrec_t;

#define FEEDSUCK$_MRS	sizeof(fsrec_t)
#define FEEDSUCK$_POS	sizeof(long)
#define FEEDSUCK$_REF	0


#pragma	__member_alignment	__restore

/*
 *
 */
					/* "Type" code's for Wctx.type		*/
enum	{T_Null,T_Suck,T_Feed,T_Clnt,T_Expr};  		
enum	{A_Read = 0x1,A_Post = 0x2,A_Ihav = 0x4};


typedef struct	{
		char		_b_type;/* Type of worker: suck,feed,client	*/
                pthread_mutex_t _l_mutex;/* Mutual exclusion lock flag		*/
		pthread_t	_l_tid;	/* Thread identificator			*/
		char		_b_indx;
		void	       *_a_chan;/* TCP I/O socket			*/
		int		_d_tmo[2];/* VMS quadword binary time		*/

		struct	RAB	_s_grprab;
		struct	RAB	_s_msgrab;
		struct	RAB	_s_feedsuckrab;
		msgrec_t	mrec;
		grprec_t	grec;	/* Current News Group			*/ 

		ulong		_l_msgnum;/* Current Message number		*/
		char		_b_msgnumf;

		ushort	        _w_ipadrlen;
		char	       *_a_ipadr;/* IP address of remote client		*/

		ushort	        _w_ipnamelen;
		char	       *_a_ipname;/* IP name of  remote client		*/

	#define	BUFPSZ	1024
		char		_t_buf [BUFPSZ];/* Work buffer for worker	*/
                } wctx_t;


#define	FIELDSEP	'|'

typedef	struct	{
	struct	dsc$descriptor
			 _s_localhost,
			 _s_localpath,
			 _s_localtz,
			 _s_localmgr,
			 _s_smtprelay,

			 _s_grpme_list,

			 _s_mod_list,
			 _s_modgrp_list,

			 _s_suck_list,
			 _s_feed_list,
			 _s_clnt_list;

		ushort	 _w_localport,
			 _w_msgpurgeday,
			 _w_msgold;

		ushort	 _w_suck_tmo,
			 _w_feed_tmo,
			 _w_clnt_tmo;

		ushort	 _w_grpday;

		ushort	 _w_loglevel,
			 _w_logtype;

		ushort	 _w_suck_delta,
			 _w_feed_delta;
		} nntpconf_t;

#ifndef	nntp_conf
		nntpconf_t	nntp_conf;
#else
external        nntpconf_t	nntp_conf;
#endif

struct	FSArg	{
		ushort	_w_len;
		char	*_a_arg;
		};

int	 nntp_cmd_exec		(wctx_t *);
int	 nntp_getarticle	(wctx_t *,ushort,ushort *,ushort *);
int      nntp_help		(wctx_t *,ushort);
int      nntp_mode		(wctx_t *,ushort);
int      nntp_quit		(wctx_t *,ushort);    
int	 nntp_article		(wctx_t *,ushort);    
int	 nntp_head		(wctx_t *,ushort);    
int	 nntp_body		(wctx_t *,ushort);    
int	 nntp_post		(wctx_t *,ushort);   
int	 nntp_list		(wctx_t *,ushort);   
int	 nntp_listfmt		(wctx_t *,ushort);   
int	 nntp_ihave		(wctx_t *,ushort);   
int	 nntp_group		(wctx_t *,ushort);   
int	 nntp_newgroups		(wctx_t *,ushort);   
int	 nntp_slave		(wctx_t *,ushort);   
int	 nntp_stat		(wctx_t *,ushort);   
int	 nntp_xover		(wctx_t *,ushort);   
int	 nntp_last		(wctx_t *,ushort);   
int	 nntp_next		(wctx_t *,ushort);   
int	 nntp_newnews		(wctx_t *,ushort);   

int      msg_to_db		(wctx_t *,ushort);
int      msg_hdr_valid		(wctx_t *,ushort *);
int	 smtp_send		(wctx_t *,struct FSArg *,char *,ushort,char *,ushort,char *,ushort);

int	 nntp_conf_get		(void);
void	 nntp_conf_out		(void);

void	 nntp_client		(wctx_t *,ushort);
int    	 nntp_suck		(wctx_t *,struct FSArg *);
int	 nntp_feed		(wctx_t *,struct FSArg *);


void	 MDString		(char,char *,ushort,char *,ushort,char *);
void	 MDbin2hex		(char *,char *);

time_t	 cvt_rfc_to_vms		(char *,int);
time_t   cvt_nntp_to_vms	(char *);
void	 cvt_vms_to_nntp	(time_t,char *,ushort *);
char	*cvt_vms_to_rfc		(time_t,char *,char *);
char	*strnlwr		(char *,int);
int	 strstrip		(char *,int,char *,int);
char	*strtok_val		(char *,char *,char *,char *,int);
int	 strelem		(struct dsc$descriptor *,char,ushort,char **);
int	 strmatch		(char *,ushort,char *,ushort);	 
void	 strinsert		(char *,ushort,char *,ushort);

#define	 min(x,y)	((x > y)?y:x)
#define	 max(x,y)	((x < y)?y:x)
/*
 *
 */
#define  LOGI	0
#define  LOGF	1
#define  LOGS	2
#define  LOGE	3
#define  LOGW	4
#define  LOGD	5

extern	char	*lvl_msg[];

char	*nntp_log_time		(char *,int);
void	 NNTP_LOG		(int ,const char *, ...);
void	 NNTP_LOGT		(wctx_t *,int ,const char *, ...);
/*
 *
 */
int	 net_read_line		(void *,char *,ushort *,int *);
int	 net_send_line		(void *,char *,ushort);
int	 net_read_mline		(void *,char *,ushort *,int *);
int	 net_send_mline		(void *,char *,ushort); 
void	 net_close		(void *);
int	 net_connect_out	(void *,char *,ushort,ushort);
int	 net_connect_inc	(void *,ushort,char *,ushort *,char *,ushort *);
int	 net_send_cmd		(void *,char *,ushort,char *,ushort *,ushort *,int *);
/*
 *
 */
#define	 BIGNUM			((unsigned long) 0x7fffffff)


int	 MsgDBopen		(void);
int	 MsgDBopen_stream	(struct RAB *);

int      MsgDBfind_byId		(struct RAB *,char *,ushort);
int	 MsgDBget_byId		(struct RAB *,char *,ushort,
					msgrec_t *,ushort *);
int	 MsgDBget_byNum		(struct RAB *,grprec_t *,ulong,
					msgrec_t *,ushort *);
int	 MsgDBget_byRange	(struct RAB *,
				 grprec_t *,ulong,ulong,msgrec_t *,ushort *,
				 char *,ushort *);
int	 MsgDBdel_byNum		(struct RAB *,grprec_t *,ulong,msgrec_t *);

int	 GrpDBopen		(void);
int	 GrpDBopen_stream	(struct RAB *);
int	 GrpDBget		(struct RAB *,grprec_t *,int,int,int);
int      GrpDBput		(struct RAB *,grprec_t *);
int	 GrpDBfree		(struct RAB *);

int	 DBclose_stream		(struct RAB *);
int	 DBclose		(void);
int	 DBopen			(void);
int	 DBins			(struct RAB *,
				 struct RAB *,grprec_t *,time_t,msgrec_t *,
				 ushort);

int	 FeedSuckDBopen		(void);
int	 FeedSuckDBopen_stream	(struct RAB *);
int	 FeedSuckDBget		(struct RAB *,fsrec_t *);
int	 FeedSuckDBput		(struct RAB *,fsrec_t *);

int	 Feed_bymail		(wctx_t *,int,char *);

int	 NNTP_InitBosses	(void);
void	*NNTP_ClientBoss	(void *);
void	*NNTP_SuckBoss		(void *);
void	*NNTP_FeedBoss		(void *);
void	 NNTP_ExpireBoss	(void);
void	*NNTP_WorkerInit	(int,void *,char *,int,char *,int);
void	 NNTP_WorkerKill	(wctx_t *);
int	 pthread_sleep		(int);
int	 nntp_expire		(wctx_t *);


int	 chk_IP_prot		(char *,int,char *,int);

#endif	/* _NNTP_H_ */
