/*
        Copyright (c) 1996, Ruslan R. Laishev (@RRL)
*/

#include        "nntp.h"

struct	param_t	{
		char	*name;
		int	 type;
		char	*ptr;
		int	 flg;
		} param_tbl [] = {
		{"LocalHost",		0,(char *)&nntp_conf._s_localhost,1},
		{"LocalPath",		0,(char *)&nntp_conf._s_localpath,1},
		{"LocalTZ",		0,(char *)&nntp_conf._s_localtz,1},
		{"LocalPort",		1,(char *)&nntp_conf._w_localport},
		{"LocalMgr",		0,(char *)&nntp_conf._s_localmgr},
		{"SMTPRelay",		0,(char *)&nntp_conf._s_smtprelay,1},
		{"MsgPurgeDay",		1,(char *)&nntp_conf._w_msgpurgeday},
		{"MsgOld",		1,(char *)&nntp_conf._w_msgold},
		{"SuckTimeOut",		1,(char *)&nntp_conf._w_suck_tmo},
		{"FeedTimeOut",		1,(char *)&nntp_conf._w_feed_tmo},
		{"ClientTimeOut",	1,(char *)&nntp_conf._w_clnt_tmo},
		{"GrpME",		0,(char *)&nntp_conf._s_grpme_list,1},
		{"GrpDay",		1,(char *)&nntp_conf._w_grpday},
		{"Suck",		0,(char *)&nntp_conf._s_suck_list,1},
		{"Feed",		0,(char *)&nntp_conf._s_feed_list,1},
		{"Client",		0,(char *)&nntp_conf._s_clnt_list,1},
		{"LogLevel",		1,(char *)&nntp_conf._w_loglevel},
		{"LogType",		1,(char *)&nntp_conf._w_logtype},
		{"SuckInterval",	1,(char *)&nntp_conf._w_suck_delta,1},
		{"FeedInterval",	1,(char *)&nntp_conf._w_feed_delta,1},
		{"Moderator",		0,(char *)&nntp_conf._s_mod_list,1},
		{NULL,			0,NULL}
				};



int	nntp_conf_get	(void)
{
int	 status;
char	 buf0[ 512 ];
char	 buf1[ 512  ];
char	 buf2[ 512  ];
char	 CONF_FILE[]= "nntp$cnf";
struct FAB	fab;
struct RAB	rab;
int	 i,len0,len1,len2;
long	*ptr0;
char	*ptr1,*ptr2;
struct	dsc$descriptor	*dsc_p,dsc_t0,dsc_t1;
$DESCRIPTOR(dsc_sep0,"|");
$DESCRIPTOR(dsc_sep1,":");
$DESCRIPTOR(dsc_sep2,",");

	/*
	**
	*/

        memset(&nntp_conf,0,sizeof(nntp_conf));

	/*
	**
	*/

	fab = cc$rms_fab;
	fab.fab$b_fac = FAB$M_GET;
	fab.fab$l_fna = CONF_FILE;
	fab.fab$b_fns = sizeof(CONF_FILE)-1;
	fab.fab$b_rat = FAB$M_CR;
	fab.fab$b_rfm = FAB$C_STMLF;

	rab = cc$rms_rab;
	rab.rab$l_fab = &fab;

	status = sys$open (&fab);
	if (!$VMS_STATUS_SUCCESS(status))
		return	status;

	status = sys$connect (&rab);
	if (!$VMS_STATUS_SUCCESS(status))
		return	status;

	/*
	**
	*/

        rab.rab$l_ubf = buf0;
        rab.rab$w_usz = sizeof(buf0)-1;

	while( 1 & (status = sys$get(&rab)) )
		{
		buf0[rab.rab$w_rsz] = '\0';

		if ( (2 != sscanf(buf0,"%s %[^#\r\n]",&buf1,&buf2)) || (buf1[0] == '#') )
			continue;

		for ( i = 0; param_tbl[i].name != NULL; i++ )
			{
			INIT_SDESC(dsc_t0,strlen(buf1),buf1);
			INIT_SDESC(dsc_t1,strlen(param_tbl[i].name),param_tbl[i].name);
			if ( str$case_blind_compare (&dsc_t0,&dsc_t1) )
				continue;

			/*
			** If it's digital parameter...
			*/

			if ( param_tbl[i].type )
				{
				*((ushort *)param_tbl[i].ptr) = atoi(buf2);
				break;
				}

			/*
			** If it's string parameter...
			*/
                        len1 = strlen(buf2);
			len1 = strstrip(buf2,len1," \t\r\n",4);

			dsc_p =  (struct dsc$descriptor *)param_tbl[i].ptr;

			if ( dsc_p->dsc$w_length  )
				{
				INIT_DDESC(dsc_t0,len1,buf2);
				status = str$concat(dsc_p,dsc_p,&dsc_sep0,&dsc_t0);
				if (!$VMS_STATUS_SUCCESS(status))
					return	status;
				break;
				}

			INIT_DDESC(*dsc_p,0,0);
			INIT_SDESC(dsc_t0,len1,buf2);
			status = str$copy_dx(dsc_p,&dsc_t0);
			if (!$VMS_STATUS_SUCCESS(status))
				return	status;

			break;
			}
		}		
        if ( status != RMS$_EOF )
		return	status;

	/*
	 * Check and validate
	 */	

	if ( (!nntp_conf._s_localhost.dsc$w_length) || 
			(!nntp_conf._s_localtz.dsc$w_length) )
		return	SS$_INSFARG;

	nntp_conf._w_localport	= nntp_conf._w_localport?nntp_conf._w_localport:119;

	if ( (0 > nntp_conf._w_loglevel) || (5 < nntp_conf._w_loglevel) )
		nntp_conf._w_loglevel = 5;

        nntp_conf._w_suck_delta	= max (nntp_conf._w_suck_delta,5);
        nntp_conf._w_feed_delta	= max (nntp_conf._w_feed_delta,5);


	/*
	** Extract list of moderated group (or mask )
	*/

	if ( nntp_conf._s_mod_list.dsc$w_length )
		{
		INIT_DDESC(nntp_conf._s_modgrp_list,0,0);
		for (i = 0;
			dsc_t1.dsc$w_length = strelem(&nntp_conf._s_mod_list,'|',i,
					&dsc_t1.dsc$a_pointer);
				i++)
			{
			dsc_t0.dsc$w_length = strelem(&dsc_t1,':',0,&dsc_t0.dsc$a_pointer);

			if ( !nntp_conf._s_modgrp_list.dsc$w_length )
				status = str$copy_dx(&nntp_conf._s_modgrp_list,&dsc_t0);
			else	status = str$concat(&nntp_conf._s_modgrp_list,&nntp_conf._s_modgrp_list
						,&dsc_sep2,&dsc_t0);

			if (!$VMS_STATUS_SUCCESS(status))
				return	status;
			}
		}

	if ( (!nntp_conf._s_smtprelay.dsc$w_length) || 
			(!nntp_conf._s_mod_list.dsc$w_length) )
		return	SS$_INSFARG;

	str$upcase(&nntp_conf._s_clnt_list,&nntp_conf._s_clnt_list);
	/*
	**
	*/

	status = sys$disconnect(&rab);
	if (!$VMS_STATUS_SUCCESS(status))
		return	status;

	return	sys$close(&fab);
}


void	nntp_conf_out	(void)
{
#define	_$_fmt_$_(a)	a.dsc$w_length,a.dsc$a_pointer

        NNTP_LOG(LOGI,"LocalHost.............%.*s",_$_fmt_$_(nntp_conf._s_localhost));
        NNTP_LOG(LOGI,"LocalPath.............%.*s",_$_fmt_$_(nntp_conf._s_localpath));
        NNTP_LOG(LOGI,"LocalTZ...............%.*s",_$_fmt_$_(nntp_conf._s_localtz));
        NNTP_LOG(LOGI,"LocalPort.............%d",nntp_conf._w_localport);
        NNTP_LOG(LOGI,"LocalMgr..............%.*s",_$_fmt_$_(nntp_conf._s_localmgr));
        NNTP_LOG(LOGI,"SMTPRelay.............%.*s",_$_fmt_$_(nntp_conf._s_smtprelay));

        NNTP_LOG(LOGI,"MsgPurgeDay (day).....%d",nntp_conf._w_msgpurgeday);
        NNTP_LOG(LOGI,"MsgOld (days).........%d",nntp_conf._w_msgold);

        NNTP_LOG(LOGI,"SuckTimeOut (min).....%d",nntp_conf._w_suck_tmo);
        NNTP_LOG(LOGI,"FeedTimeOut (min).....%d",nntp_conf._w_feed_tmo);
        NNTP_LOG(LOGI,"ClientTimeOut (min)...%d",nntp_conf._w_clnt_tmo);

        NNTP_LOG(LOGI,"GrpME.................%.*s",_$_fmt_$_(nntp_conf._s_grpme_list));
        NNTP_LOG(LOGI,"GrpDay (day)..........%d",nntp_conf._w_grpday);

        NNTP_LOG(LOGI,"Suck..................%.*s",_$_fmt_$_(nntp_conf._s_suck_list));
        NNTP_LOG(LOGI,"Feed..................%.*s",_$_fmt_$_(nntp_conf._s_feed_list));
        NNTP_LOG(LOGI,"Client................%.*s",_$_fmt_$_(nntp_conf._s_clnt_list));

        NNTP_LOG(LOGI,"LogLevel..............%d",nntp_conf._w_loglevel);
        NNTP_LOG(LOGI,"LogType...............%d",nntp_conf._w_logtype);

        NNTP_LOG(LOGI,"Suck Interval (min)...%d",nntp_conf._w_suck_delta);
        NNTP_LOG(LOGI,"Feed Interval (min)...%d",nntp_conf._w_feed_delta);

        NNTP_LOG(LOGI,"Moderator.............%.*s",_$_fmt_$_(nntp_conf._s_mod_list));
        NNTP_LOG(LOGI,"GrpMod................%.*s",_$_fmt_$_(nntp_conf._s_modgrp_list));
}
