/*
        Copyright (c) 1996-98 Ruslan R. Laishev (@RRL)
*/

#include        "nntp.h"

int	nntp_expire_group(wctx_t *,time_t);
/*
 *--------------------------------------------------------------------------------
 */
int	nntp_expire	(	wctx_t	*Wctxp
			)
{
long		 status;
int		 rewindf = 0,updflag;
time_t		 gt,mt,t;

	NNTP_LOGT(Wctxp,LOGI,
		"DateCr       |DateUp       |First msg#|  Last msg#|P|S|Group Name....");

	time(&t);
	gt = t - (nntp_conf._w_grpday*24*60*60);
	mt = t - (nntp_conf._w_msgpurgeday*24*60*60);

	while ( 1 &(status=GrpDBget(&Wctxp->_s_grprab,&Wctxp->grec,0,rewindf++,1)) )
		{
		updflag = 0;
		/*
		 * If group is not empty - purge messages
		 */
		if ( Wctxp->grec._l_first || Wctxp->grec._l_last )
			{
			/*
			** Lock group for changes
			*/
			status =GrpDBget(&Wctxp->_s_grprab,&Wctxp->grec,1,0,0);
			if (!$VMS_STATUS_SUCCESS(status))
		                {
				NNTP_LOGT(Wctxp,LOGE,"GrpDBget('%.*s'),(status = %d)",
						Wctxp->grec._b_len,Wctxp->grec._t_name);
				continue;
				}
			updflag = nntp_expire_group (Wctxp,mt);
			}
		/*
		 * If group is expiried  - clear suck flag 
		 */
		if ( Wctxp->grec._c_suckflag && (gt > (max(Wctxp->grec._l_dateup,Wctxp->grec._l_datecr))) )
			{
                	NNTP_LOGT(Wctxp,LOGI,"%.*s is switched to passive",
					Wctxp->grec._b_len,Wctxp->grec._t_name);
			Wctxp->grec._c_suckflag = 0;
			updflag = 1;
			}
		/*
		 *
		 */
		if ( updflag )
			{
			status = GrpDBput(&Wctxp->_s_grprab,&Wctxp->grec);
			if ( !$VMS_STATUS_SUCCESS(status) )
				NNTP_LOGT(Wctxp,LOGF,"Update GrpDB,(status = %d).",status);
			}
		else	GrpDBfree(&Wctxp->_s_grprab);
		}


	if ( status == RMS$_EOF )
		status = SS$_NORMAL;

	return	status;
}
/*
 *--------------------------------------------------------------------------------
 */
int	nntp_expire_group	(
				wctx_t		*Wctxp,
				time_t		 ct
				)
{
long	status;
ulong	Purged = 0,Skiped = 0;
ushort	sz,sz0,sz1;
char	buf0[32],buf1[32];

	/*
	**
	*/
        cvt_vms_to_nntp(Wctxp->grec._l_datecr,buf0,&sz0);
        cvt_vms_to_nntp(Wctxp->grec._l_dateup,buf1,&sz1);
	NNTP_LOGT(Wctxp,LOGI,"%.*s|%.*s%11lu|%11lu|%c|%c|%.*s",
					sz0,buf0,sz1,buf1,
					Wctxp->grec._l_first,Wctxp->grec._l_last,
                                        Wctxp->grec._c_postflag?'y':' ',
                                        Wctxp->grec._c_suckflag?'y':' ',
					Wctxp->grec._b_len,Wctxp->grec._t_name);

	/*
	**
	*/
	for (;Wctxp->grec._l_first < Wctxp->grec._l_last;Wctxp->grec._l_first++)
		{
		/*
		** Get article and check date field
		*/
		status = MsgDBget_byNum (&Wctxp->_s_msgrab,&Wctxp->grec,
					Wctxp->grec._l_first,
					&Wctxp->mrec,&sz);
		if ( status == RMS$_RNF )
			{
			Skiped++;
			continue;
			}
		if ( !$VMS_STATUS_SUCCESS(status) )
			{
	                NNTP_LOGT(Wctxp,LOGE,"'%.*s', ARTICLE #%u-Can't be retrived,(status = %d)",
				Wctxp->grec._b_len,Wctxp->grec._t_name,Wctxp->grec._l_first,status);
			Skiped++;
			continue;
			}

		if ( Wctxp->mrec._l_date > ct )
			break;

		status = MsgDBdel_byNum (&Wctxp->_s_msgrab,&Wctxp->grec,
					Wctxp->grec._l_first,
					&Wctxp->mrec);
		if ( !$VMS_STATUS_SUCCESS(status) )
			{
                	NNTP_LOGT(Wctxp,LOGF,"Can't delete '%.*s', ARTICLE #%u %.*s,(status = %d)",
					Wctxp->grec._b_len,Wctxp->grec._t_name,
					Wctxp->grec._l_first,
					Wctxp->mrec._w_midlen,Wctxp->mrec._t_mid,status);
			break;
			}
		Purged++;
		}

	/*
	**
	*/
        cvt_vms_to_nntp(Wctxp->grec._l_datecr,buf0,&sz0);
        cvt_vms_to_nntp(Wctxp->grec._l_dateup,buf1,&sz1);
	NNTP_LOGT(Wctxp,LOGI,"%.*s|%.*s%11lu|%11lu|%c|%c|%.*s",
					sz0,buf0,sz1,buf1,
					Wctxp->grec._l_first,Wctxp->grec._l_last,
                                        Wctxp->grec._c_postflag?'y':' ',
                                        Wctxp->grec._c_suckflag?'y':' ',
					Wctxp->grec._b_len,Wctxp->grec._t_name);

	return (Purged + Skiped);
}
