/*
        Copyright (c) 1996, Ruslan R. Laishev (@RRL)
*/

#include	<time.h>
#include	<libdef.h>
#include	<stdarg.h>
#include	<stdlib.h>

#include        "nntp.h"


char    *lvl_msg[]  ={	"%NNTP-I-",
			"%NNTP-F-",
			"%NNTP-S-",
			"%NNTP-E-",
			"%NNTP-W-",
			"%NNTP-D-"
			};

/*
 *--------------------------------------------------------------------------------
 */
char	*nntp_log_time	(
			char	*buf,
			int	 size
			)
{
struct dsc$descriptor   dsc_dt;

	INIT_SDESC (dsc_dt,size,buf);
	lib$date_time (&dsc_dt);
	*(buf+20) = 0;
	return buf;
}

/*
 *--------------------------------------------------------------------------------
 */
void	NNTP_LOG	(
			int		 lvl,
			const char	*format, ...)
{
va_list  ap;
char     buf [2048];


	if ( lvl > nntp_conf._w_loglevel )
		return;

        va_start (ap, format);
	fprintf(stdout,"\n%s,%s",nntp_log_time (buf,sizeof(buf)),lvl_msg[lvl]);
        vsprintf(buf, format, ap);
        fputs(buf,stdout);
        va_end(ap);
	fflush(stdout);
}
/*
 *--------------------------------------------------------------------------------
 */
void	NNTP_LOGT	(
			wctx_t 		*Wctxp,
			int		 lvl,
			const char	*format, ...)
{
va_list  ap;
char     buf [1024];
char	*type[] =  {"Null","Suck","Feed","Clnt","Expr"};

	if ( lvl > nntp_conf._w_loglevel )
		return;

	if ( (Wctxp->_b_type != nntp_conf._w_logtype) && nntp_conf._w_logtype )
		return;

        va_start (ap, format);
	fprintf(stdout,"\n%s,%s[%s(%03d)]",
			nntp_log_time (buf,sizeof(buf)), lvl_msg[lvl],
			type[Wctxp->_b_type], Wctxp->_b_indx);
        vsprintf(buf, format, ap);
        fprintf(stdout,buf);
        va_end(ap);
	fflush(stdout);
}
