/*	
	Copyright (c) 1996-98 Ruslan R. Laishev (@RRL)
*/

#include	"nntp.h"

char	*ID$IDcpy = "Copyright (c) 1996-98,Ruslan R. Laishev (@RRL).";
char	*ID$IDsrv = "DNNTP/OVMS v 1.09";
char	*ID$IDver = "DECThreads NNTP Server for OpenVMS Ver. 1.09, OpenVMS/"\
			VMS_VERSION;

/*
 *--------------------------------------------------------------------------------
 */
void	main	(void)
{
long		status;
pthread_t	th0,th1,th2;
$DESCRIPTOR(tomorrow_dsc,"TOMORROW");
int	tomorrow_bin[2],
	delta_bin[2],
	current_bin[2];
ushort	num_tm [7];

	NNTP_LOG(LOGI,ID$IDcpy);
        NNTP_LOG(LOGI,ID$IDver);
	/*
	 *
	 */
        NNTP_LOG(LOGI,"Get configuration information.");
	status = nntp_conf_get();
	if (!$VMS_STATUS_SUCCESS(status))
		sys$exit(status);
	nntp_conf_out();
	/*
	 *
	 */
        NNTP_LOG(LOGI,"Opening News Messages DataBase");
	status = MsgDBopen();
        if ( !(1 & status) )
		sys$exit(status);

        NNTP_LOG(LOGI,"Opening NewsGroups DataBase");
	status = GrpDBopen();
        if ( !(1 & status) )
		sys$exit(status);

        NNTP_LOG(LOGI,"Opening Feed and Suck DataBase");
	status = FeedSuckDBopen();
        if ( !(1 & status) )
		sys$exit(status);

	/*
	 *
	 */
	NNTP_InitBosses ();

	/*
	 *
	 */

	
        if ( 0 > $PTHREAD_CREATE(&th0,0,NNTP_ClientBoss,0) )
                {
	        NNTP_LOG(LOGF,"Create Client Boss thread-%s.",
			strerror(errno));
                }
        NNTP_LOG(LOGI,"Create Client Boss thread-Ok (Tid:0%xh).",th0);

	/*
	 *
	 */

        if (0 > $PTHREAD_CREATE(&th1,0,NNTP_SuckBoss,0) )
                {
	        NNTP_LOG(LOGF,"Create Suck Boss thread-%s.",
			strerror(errno));
                }
        NNTP_LOG(LOGI,"Create Suck Boss thread-Ok (Tid:0%xh).",th1);
	/*
	 *
	 */	
        if ( 0 > $PTHREAD_CREATE(&th2,0,NNTP_FeedBoss,0) )
                {
	        NNTP_LOG(LOGF,"Create Feed Boss thread-%s.",
			strerror(errno));
                }
        NNTP_LOG(LOGI,"Create Feed Boss thread-Ok (Tid:0%xh).",th2);
	/*
	 *
	 */

	while(1)
		{
		NNTP_LOG(LOGI,"Scheduling of database purging thread at midnight.");

		/*
		** Compute wait period of next expiration
		*/
		status = lib$convert_date_string(&tomorrow_dsc,tomorrow_bin);
        	if (!$VMS_STATUS_SUCCESS(status))
			sys$exit(status);

		status = sys$gettim (current_bin);
        	if (!$VMS_STATUS_SUCCESS(status))
			sys$exit(status);

		status = lib$sub_times (tomorrow_bin,current_bin,delta_bin);
		if (!$VMS_STATUS_SUCCESS(status))
			sys$exit(status);


		status = sys$numtim (num_tm,delta_bin);
		if (!$VMS_STATUS_SUCCESS(status))
			sys$exit(status);

		delta_bin[0]  = num_tm[3];	delta_bin[0] *= (60*60);
		delta_bin[0] += (1+num_tm[4])*60;
		delta_bin[0] += num_tm[5];
		delta_bin[1]  = 0;
		
		/*
		**
		*/
		pthread_delay_np((struct timespec *) delta_bin);

		/*
		pthread_sleep (delta_bin[0]);
		*/

		NNTP_LOG(LOGI,"Start of database purging thread.");
		NNTP_ExpireBoss();
		}

        DBclose();
        NNTP_LOG(LOGI,"%s-End.",ID$IDver);
}
