/*
	@RRL (c),Jun-1997-1998
*/
#include	<stdio.h>
#include	<lib$routines.h>
#include	<descrip.h>
#include	<rms.h>
#include	<ssdef.h>
#include	<climsgdef.h>
#include	<cli$routines.h>
#include	<lbr$routines.h>
#include	<hlpdef.h>

#include	"nntp.h"

extern	void	*NNTPCP_CLD;

int	getYesNo	(void);
void	out_info	(char *,uchar);

#define	$DESC(string) { sizeof( string ) - 1, DSC$K_DTYPE_T, DSC$K_CLASS_S, string }

static struct dsc$descriptor cmd[] =	{
		$DESC("SET"),
		$DESC("SHOW"),
		$DESC("HELP"),
		$DESC("ADD"),
		$DESC("DELETE")		};

static struct dsc$descriptor par_dsc = $DESC("GROUP");

$DESCRIPTOR(q_suck,"SUCK");
$DESCRIPTOR(q_post,"POST");
$DESCRIPTOR(q_conf,"CONFIRM");
$DESCRIPTOR(q_log,"LOGGING");
$DESCRIPTOR(wild,"*%");
$DESCRIPTOR(welcome,"\n\t\tNNTP Server Control Program,(c)@RRL\n");
$DESCRIPTOR(prompt,"NNTP-CP>");

char	grp_buf [ 1024 ];
char	tmp_buf [ 1024 ];
struct	dsc$descriptor	grp_dsc = $DESC(grp_buf),
			junk    = $DESC(tmp_buf);


struct	RAB	mrab,grab,fsrab;
grprec_t        grec;

ushort		len;
long	 	suck,post,suck_f,post_f,conf,log_sw,rewindf;
int		changes;
int		n;
time_t		t;


/*
 *--------------------------------------------------------------------------------
 */
void	NNTPCP_CMD_EXIT		(void)
{
	DBclose();
	sys$exit(SS$_NORMAL);
}
/*
 *--------------------------------------------------------------------------------
 */
int	NNTPCP_CMD_SET		(void)
{
long	 	 status;

	if ( CLI$_PRESENT != cli$present (&q_conf) )
		conf = 0;
	else	conf = 1;

	if ( CLI$_PRESENT != cli$present (&q_log) )
		log_sw = 0;
	else	log_sw = 1;

	/*
	**
	*/
	if ( CLI$_PRESENT == cli$present (&q_suck) )
		{
		status = cli$get_value(&q_suck,&junk,&len);
		if (! (status & 1))
			return status;
		suck	= 1;
		suck_f	= (tmp_buf[0] == 'Y'?1:0);
		}	
	if ( CLI$_PRESENT == cli$present (&q_post) )
		{
		status = cli$get_value(&q_post,&junk,&len);
		if (! (status & 1))
			return status;
		post	= 1;
		post_f	= tolower (tmp_buf[0]);
		}	
	status = cli$get_value(&par_dsc,&grp_dsc,&grp_dsc.dsc$w_length);
	if ( !(1 & status) )
		return status;

	/*
	**
	*/
	printf("\nSet for '%.*s'",grp_dsc.dsc$w_length,grp_dsc.dsc$a_pointer);
	printf("\nDateCr       |DateUp       |First msg#|  Last msg#|P|S|Group Name....");

	/*
	** Check for wildcard and if not, make up for one group only
	*/
	if ( !str$find_first_in_set (&grp_dsc,&wild) )
		{                            
		if ( conf && (0 >= getYesNo ()))
				return	SS$_ABORT;

		memcpy (grec._t_name,grp_dsc.dsc$a_pointer,grp_dsc.dsc$w_length);
		grec._b_len = grp_dsc.dsc$w_length;

		status = GrpDBget(&grab,&grec,0,1,0);
		if ( status == RMS$_RNF )
			return	SS$_NORMAL;
		if ( !(1 & status) )
			return	status;

		if ( log_sw )	out_info(grp_dsc.dsc$a_pointer,grp_dsc.dsc$w_length);

		if ( suck && (grec._c_suckflag != suck_f) )
			{grec._c_suckflag = suck_f;	changes = 1;}
		if ( post && (grec._c_postflag != post_f) )
			{grec._c_postflag = post_f;	changes = 1;}

		if ( log_sw )	out_info(grp_dsc.dsc$a_pointer,grp_dsc.dsc$w_length);

		if ( suck )
			{time(&grec._l_dateup);	grec._c_suckflag = suck_f;}
		if ( post )	
			grec._c_postflag = post_f;

		status = GrpDBput(&grab,&grec);
		if (log_sw) printf("\nchanges completed");

		return	status;
		}

	while ( 1 & (status = GrpDBget(&grab,&grec,0,rewindf++,1)) )
		{
		if ( !strmatch (grp_dsc.dsc$a_pointer,grp_dsc.dsc$w_length,
					grec._t_name,grec._b_len) )
			continue;
		if ( suck && (grec._c_suckflag != suck_f) )
			{grec._c_suckflag = suck_f;	changes = 1;}
		if ( post && (grec._c_postflag != post_f) )
			{grec._c_postflag = post_f;	changes = 1;}
		if ( suck )
			{time(&grec._l_dateup);	grec._c_suckflag = suck_f;}
		if ( post )	
			grec._c_postflag = post_f;

		if ( !changes )
			continue;

		if ( conf )
			{
			status = getYesNo ();
			if ( status < 0 )	break;
			if ( !status)		continue;
			}	 

		status = GrpDBget(&grab,&grec,0,rewindf++,0);
		if ( !(1 & status) )
			break;

		if ( suck )
			{time(&grec._l_dateup);	grec._c_suckflag = suck_f;}
		if ( post )	
			grec._c_postflag = post_f;
		if ( log_sw )	out_info(grec._t_name,grec._b_len);
		status = GrpDBput(&grab,&grec);
		if ( !(1 & status) )
			break;
		n++;
		}

	if ( status == RMS$_EOF )
		status = SS$_NORMAL;
	if (log_sw) printf("\n%d changes is completed",n);
	return	status;
}
/*
 *--------------------------------------------------------------------------------
 */
int	NNTPCP_CMD_SHOW		(void)
{
long	 status;

	status = cli$get_value(&par_dsc,&grp_dsc,&grp_dsc.dsc$w_length);
	if (! (status & 1))
		return status;

	if ( CLI$_PRESENT == cli$present (&q_suck) )
		suck = 1;
	
	printf("\nShow information for '%.*s'",grp_dsc.dsc$w_length,grp_dsc.dsc$a_pointer);
	printf("\nDateCr       |DateUp       |First msg#|  Last msg#|P|S|Group Name....");

	if ( !str$find_first_in_set (&grp_dsc,&wild) )
		{                            
		memcpy (grec._t_name,grp_dsc.dsc$a_pointer,grp_dsc.dsc$w_length);
		grec._b_len = grp_dsc.dsc$w_length;

		status = GrpDBget(&grab,&grec,0,1,0);
		if ( !(1 & status) )
			return	SS$_NORMAL;

		out_info(grec._t_name,grec._b_len);

		return	SS$_NORMAL;
		}

	while ( 1 & (status = GrpDBget(&grab,&grec,0,rewindf++,1)) )
		{
		if ( strmatch (grp_dsc.dsc$a_pointer,grp_dsc.dsc$w_length,
					grec._t_name,grec._b_len) ) 
			{
			if ( suck && (!grec._c_suckflag) )
				continue;

			out_info(grec._t_name,grec._b_len);
			}
		}
	if ( status == RMS$_EOF )
		status = SS$_NORMAL;

	return	status;
}
/*
 *--------------------------------------------------------------------------------
 */
int	NNTPCP_CMD_HELP	(void)
{
$DESCRIPTOR(hlp_lib_dsc,"nntpcp.hlb");
long	hlp_flg = HLP$M_PROMPT | HLP$M_HELP;
	
	return ( lbr$output_help(lib$put_output,
				0,0,&hlp_lib_dsc,&hlp_flg,
				lib$get_input));
}
/*
 *--------------------------------------------------------------------------------
 */
int	NNTPCP_CMD_DELETE	(void)
{
	return	SS$_NORMAL;
}
int	getYesNo	(void)
{
long	status;
$DESCRIPTOR(dsc_buf,"\r\nConfirm by press [Y/N]:");
$DESCRIPTOR(dsc_yn, " ");
long	len;
	
	status = lib$get_input(&dsc_buf,&dsc_yn,&len);
	if (! (status & 1))
		lib$signal(status);

	return ( ((*dsc_buf.dsc$a_pointer == 'y') 
		|| (*dsc_buf.dsc$a_pointer == 'Y'))?1:0);
}
/*
 *--------------------------------------------------------------------------------
 */
int	NNTPCP_CMD_ADD		(void)
{
long	status;

	if ( CLI$_PRESENT != cli$present (&q_conf) )
		conf = 0;
	else	conf = 1;

	if ( CLI$_PRESENT != cli$present (&q_log) )
		log_sw = 0;
	else	log_sw = 1;

	/*
	**
	*/
	if ( CLI$_PRESENT == cli$present (&q_suck) )
		{
		status = cli$get_value(&q_suck,&junk,&len);
		if (! (status & 1))
			return status;
		suck	= 1;
		suck_f	= (tmp_buf[0] == 'N'?0:1);
		}	
	/*
	**
	*/
	if ( CLI$_PRESENT == cli$present (&q_post) )
		{
		status = cli$get_value(&q_post,&junk,&len);
		if (! (status & 1))
			return status;
		post	= 1;
		post_f	= tolower (tmp_buf[0]);
		}	

	status = cli$get_value(&par_dsc,&grp_dsc,&grp_dsc.dsc$w_length);
	if ( !(1 & status) )
		return status;

	/*
	**
	*/
	memcpy (grec._t_name,grp_dsc.dsc$a_pointer,grp_dsc.dsc$w_length);
	grec._b_len = grp_dsc.dsc$w_length;

	status = GrpDBget(&grab,&grec,0,1,0);
	if ( 1 & status )
		return	SS$_NORMAL;

	time(&grec._l_dateup);	
	time(&grec._l_datecr);	
	grec._c_suckflag = suck_f;	grec._c_postflag = post_f;
	grec._l_first = grec._l_last = 0;

	if ( log_sw )
		{
		printf("\nDateCr       |DateUp       |First msg#|  Last msg#|P|S|Group Name....");
		out_info(grec._t_name,grec._b_len);
		}

	if ( conf && (0 >= getYesNo ()))
		return	SS$_ABORT;

	return	GrpDBput(&grab,&grec);
}
/*
 *--------------------------------------------------------------------------------
 */
void	out_info	(char	*grp,uchar len)
{
char	buf [32];
ushort	sz;

	cvt_vms_to_nntp(grec._l_datecr,buf,&sz);	printf("\n%.*s",sz,buf);
	cvt_vms_to_nntp(grec._l_dateup,buf,&sz);	printf(" %.*s",sz,buf);

	printf("%11lu|%11lu|%c|%c|%.*s",grec._l_first,grec._l_last,
                                        grec._c_postflag?'y':' ',
					grec._c_suckflag?'y':' ',len,grp);
}
/*
 *--------------------------------------------------------------------------------
 */
void	main	(int argc, char *argv[])
{
long	status;

	/*
	**
	*/

	status = lib$put_output (&welcome);
	if (! (status & 1))
		lib$signal(status);

	/*
	**
	*/
        status = MsgDBopen();
	if (! (status & 1))
		lib$signal(status);
        status = GrpDBopen();
	if (! (status & 1))
		lib$signal(status);
        status = FeedSuckDBopen();
	if (! (status & 1))
		lib$signal(status);

	status = MsgDBopen_stream (&mrab);
	if ( !(1 & status) )
		lib$signal(status);

	status = GrpDBopen_stream (&grab);
	if ( !(1 & status) )
		lib$signal(status);

	/*
	**
	*/
	while ( RMS$_EOF != 
		( status=cli$dcl_parse (0,&NNTPCP_CLD,lib$get_input,lib$get_input,&prompt)) )
		{
		INIT_SDESC(grp_dsc,sizeof(grp_buf),grp_buf);
		changes	= len =rewindf = suck = post = suck_f = post_f = n = 0;
		conf	= log_sw = 1;

		if ( status !=  CLI$_NORMAL )
			continue;

		status = cli$dispatch();

		if ( !(status & 1) )
			{
			lib$signal(status);
			break;
			}
		printf("\n");
		}

	NNTPCP_CMD_EXIT ();
}
