O /****************************************************************************** O  *                                                                            * O  * LISTSERV V2 - Standalone incoming mail interface (VMS)                     * O  *                                                                            * O  *         Copyright L-Soft international 1994 - All rights reserved          * O  *                                                                            * O  * Syntax: LSV_MAILIN :== $dir:LSV_MAILIN                                     * O  *         LSV_MAILIN to_userid fileid [from_address [LISTSERV_userid]]       * O  *                                                                            * O  * The first parameter is the userid of the (local) address to which the      * O  * message was addressed (LISTSERV, owner-xxx, xxx-request, or the name of a  * O  * local list). The second parameter is the name of a file containing the     * O  * message (RFC822 headers, blank line, message text). The third parameter is * O  * the RFC822 address of the RFC821 message originator (MAIL FROM:), without  * O  * angle brackets. The status code indicates whether the message was enqueued * O  * successfully for processing by LISTSERV (the file is not erased even on    * O  * successful completion).                                                    * O  *                                                                            * O  * The fourth parameter is to be used only when multiple copies of LISTSERV   * O  * must coexist on the same cluster (typically, for development/debugging     * O  * purposes). This parameter indicates the RFC822 username of the LISTSERV    * O  * instance to which you want to direct the incoming file. This must match    * O  * the "USERID" configuration logical of one of the LISTSERV processes on     * O  * your cluster. This alternate name is used when forming the names of the    * O  * spool directory and "wakeup" lock. For instance, if the fourth parameter   * O  * is LISTSERV2, the message will be deposited in LISTSERV2_SPOOL_DIR.        * O  *                                                                            * O  * This program must be called after the LISTSERV systemwide logicals have    * O  * been defined, or an error will occur. Write access to LISTSERV_SPOOL_DIR   * O  * is required, along with SYSLCK privileges to $ENQ on the main LISTSERV     * O  * wake lock.                                                                 * O  *                                                                            * P  ******************************************************************************/   #include <ctype.h> #include <rms.h> #include <string.h>  #include <stdio.h> #include <ssdef.h> #include <jpidef.h>  #include <lckdef.h>    typedef short int16; typedef unsigned char uchar;  ' #define TRANSLATE(addr, len)	do {					\  					register uchar			\  						*r = (uchar*)(addr);	\ 					register int l = len;		\ ( 					for (; l--; *r = L$TA2E[*r], r++);\ 				} while(0) #define SET_FDAL(D,a,l)	do {\  				(D)->pointer = (a);\ 				(D)->length = (l);\ & 				(D)->type = 14;		/* Characters */\( 				(D)->class = 1;		/* Fixed length */\
 			} while(0)   ! static unsigned char L$TA2E[] = { P 0x00,0x01,0x02,0x03,0x37,0x2D,0x2E,0x2F,0x16,0x05,0x25,0x0B,0x0C,0x0D,0x0E,0x0F,P 0x10,0x11,0x12,0x13,0x3C,0x3D,0x32,0x26,0x18,0x19,0x3F,0x27,0x1C,0x1D,0x1E,0x1F,P 0x40,0x5A,0x7F,0x7B,0x5B,0x6C,0x50,0x7D,0x4D,0x5D,0x5C,0x4E,0x6B,0x60,0x4B,0x61,P 0xF0,0xF1,0xF2,0xF3,0xF4,0xF5,0xF6,0xF7,0xF8,0xF9,0x7A,0x5E,0x4C,0x7E,0x6E,0x6F,P 0x7C,0xC1,0xC2,0xC3,0xC4,0xC5,0xC6,0xC7,0xC8,0xC9,0xD1,0xD2,0xD3,0xD4,0xD5,0xD6,P 0xD7,0xD8,0xD9,0xE2,0xE3,0xE4,0xE5,0xE6,0xE7,0xE8,0xE9,0xAD,0xE0,0xBD,0x5F,0x6D,P 0x79,0x81,0x82,0x83,0x84,0x85,0x86,0x87,0x88,0x89,0x91,0x92,0x93,0x94,0x95,0x96,P 0x97,0x98,0x99,0xA2,0xA3,0xA4,0xA5,0xA6,0xA7,0xA8,0xA9,0xC0,0x4F,0xD0,0xA1,0x07,P 0x20,0x21,0x22,0x23,0x24,0x2A,0x06,0x17,0x28,0x29,0x15,0x2B,0x2C,0x09,0x0A,0x1B,P 0x30,0x31,0x1A,0x33,0x34,0x35,0x36,0x08,0x38,0x39,0x3A,0x3B,0x04,0x14,0x3E,0xE1,P 0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x51,0x52,0x53,0x54,0x55,0x56,0x57,P 0x58,0x59,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x70,0x71,0x72,0x73,0x74,0x75,P 0x76,0x77,0x78,0x80,0x8A,0x8B,0x8C,0x8D,0x8E,0x8F,0x90,0x9A,0x9B,0x9C,0x9D,0x9E,P 0x9F,0xA0,0xAA,0xAB,0xAC,0xBB,0xAE,0xAF,0xB0,0xB1,0xB2,0xB3,0xB4,0xB5,0xB6,0xB7,P 0xB8,0xB9,0xBA,0x4A,0xBC,0xFC,0xBE,0xBF,0xCA,0xCB,0xCC,0xCD,0xCE,0xCF,0xDA,0xDB,O 0xDC,0xDD,0xDE,0xDF,0xEA,0xEB,0xEC,0xED,0xEE,0xEF,0xFA,0xFB,0x6A,0xFD,0xFE,0xFF  };   typedef struct { 	struct FAB fab; 	struct RAB rab; 	char fileid[256]; } VFILE;   struct VMS_descriptor {  	int16 length; 	char type;  	char class; 	char *pointer;  };   struct VMS_LKSB {  	int16 reserved, status; 	int ID; };  2 static void error(char *msg, char *fileid, int rc) {  	int sys$getmsg(), exit(); 	char buf[256];  	struct VMS_descriptor buffer; 	int16 msglen;   	buffer.pointer = buf;! 	buffer.length = sizeof(buf) - 1; # 	buffer.type = 14;	/* Characters */ % 	buffer.class = 1;	/* Fixed length */   ) 	sys$getmsg(rc, &msglen, &buffer, 15, 0);  	buf[msglen] = '\0';  7 	printf("Error %s file '%s':\n%s\n", msg, fileid, buf); 
 	exit(rc); }   5 static void vopen(VFILE *f, char *fileid, int create)  { - 	int sys$open(), sys$create(), sys$connect();  	int rc;   	f->fab = cc$rms_fab;  	f->fab.fab$l_fna = fileid; # 	f->fab.fab$b_fns = strlen(fileid);    	if (create) { 		f->fab.fab$b_fac = FAB$M_PUT;  		f->fab.fab$l_fop = 0;  		f->fab.fab$b_rat = FAB$M_CR; 		f->fab.fab$b_rfm = FAB$C_VAR;  		rc = sys$create(&f->fab);  	} 	else {  		f->fab.fab$b_fac = FAB$M_GET;  		rc = sys$open(&f->fab);  	} 	if (!(rc & 1))  		error("opening", fileid, rc);    	f->rab = cc$rms_rab;  	f->rab.rab$l_fab = &f->fab; 	f->rab.rab$b_rac = RAB$C_SEQ; 	rc = sys$connect(&f->rab);  	if (!(rc & 1)) + 		error("from SYS$CONNECT on", fileid, rc);  	strcpy(f->fileid, fileid);  }   0 static void put(VFILE *f, char *data, int trans) {  	int sys$put();  	int rc;   	f->rab.rab$l_rbf = data; ! 	f->rab.rab$w_rsz = strlen(data);  	if (trans) $ 		TRANSLATE(data, f->rab.rab$w_rsz); 	rc = sys$put(&f->rab);  	if (!(rc & 1)) % 		error("writing to", f->fileid, rc);  }   6 static void make_temp_fileid(char *buf, char *lsvname) { ! 	int sys$getjpiw(), sys$gettim();  	int list[4], time[2], pid;     	list[0] = 4 + (JPI$_PID << 16); 	list[1] = (int)&pid; 
 	list[2] = 0; 
 	list[3] = 0; % 	sys$getjpiw(0, 0, 0, list, 0, 0, 0);  	sys$gettim(time);- 	sprintf(buf, "%s_SPOOL_DIR:M%X_%08X_%X.TMP", ' 		     lsvname, time[1], time[0], pid);  }   J int lsv_mailin(char *to_userid, char *fileid, char *fromid, char *lsvname) { A 	int sys$get(), sys$put(), sys$close(), sys$rename(), sys$enqw(),  	    sys$deq(); + 	char tfileid[256], touid[256], buf[65535];  	VFILE fi, fo;
 	char *r, *w;  	int l, xam, rc, skip; 	struct VMS_descriptor d;  	struct VMS_LKSB lksb;  , 	/* Use "LISTSERV" as default for lsvname */ 	if (!lsvname || !*lsvname)  		lsvname = "LISTSERV";   5 	/* Copy target userid and translate to upper case */ 6 	for (r = to_userid, w = touid, l = sizeof(touid) - 1;& 	     l-- && (*w++ = toupper(*r++)););
 	*--w = '\0';   E 	/* See if it is an administrative (owner-xxx/xxx-request) message */ & 	xam = !strncmp(touid, "OWNER-", 6) ||( 	      !strncmp(w - 8, "-REQUEST", 8) ||% 	      !strncmp(w - 7, "-SERVER", 7);   $ 	/* Open input file and temp file */ 	vopen(&fi, fileid, 0); $ 	make_temp_fileid(tfileid, lsvname); 	vopen(&fo, tfileid, 1);  " 	/* Format and write the header */1 	sprintf(buf, "1 M %s %s *MAILER* INCOMING MAIL", 
 		     touid, 6 		     (xam || !strcmp(touid, lsvname)) ? "STANDARD" : 							"$NOJOB$"); 	put(&fo, buf, 0); 	put(&fo, "", 0);   : 	/* For administrative messages, generate X-ADMMAIL JCL */ 	if (xam) {   		strcpy(buf, "// JOB Echo=No"); 		put(&fo, buf, 1); 1 		sprintf(buf, "X-ADMMAIL %s %s", touid, fromid);  		put(&fo, buf, 1); ! 		strcpy(buf, "//DATA DD *,EOF");  		put(&fo, buf, 1);  	}  D 	/* Copy the input file. Depending on the way the LISTSERV interfaceE 	   has been implemented, there may be a number of unwanted "Resent-" C 	   tags prepended to the actual message. This would usually happen E 	   when the interface is implemented with a VMSMAIL SET FORWARD to a D 	   special RFC822 host routed via a local exit. The simplest way toD 	   get rid of these tags without affecting any actual "Resent-" tagC 	   in the message is to skip anything before the first "Received:" B 	   line. All compliant mailers would insert a "Received:" line onD 	   top of the message, in principle before they pass the message to% 	   VMSMAIL for further processing */  	for (skip = 1;;) {  		fi.rab.rab$l_ubf = buf; ! 		fi.rab.rab$w_usz = sizeof(buf);  		rc = sys$get(&fi.rab); 		if (!(rc & 1)) { 			if (rc == RMS$_EOF)
 				break;# 			error("reading", fi.fileid, rc);  		}   
 		if (skip) { * 			if ((buf[0] == 'R' || buf[0] == 'r') &&* 			    (buf[1] == 'E' || buf[1] == 'e') &&* 			    (buf[2] == 'C' || buf[2] == 'c') &&* 			    (buf[3] == 'E' || buf[3] == 'e') &&* 			    (buf[4] == 'I' || buf[4] == 'i') &&* 			    (buf[5] == 'V' || buf[5] == 'v') &&* 			    (buf[6] == 'E' || buf[6] == 'e') &&* 			    (buf[7] == 'D' || buf[7] == 'd') && 			     buf[8] == ':')
 				skip = 0;  			else 
 				continue;  		}   # 		TRANSLATE(buf, fi.rab.rab$w_rsz);  		fo.rab.rab$l_rbf = buf; & 		fo.rab.rab$w_rsz = fi.rab.rab$w_rsz; 		rc = sys$put(&fo.rab); 		if (!(rc & 1))& 			error("writing to", fo.fileid, rc); 	} 	sys$close(&fi.fab);  # 	/* Close and rename output file */   	if (!(rc = sys$close(&fo.fab)))" 		error("closing", fo.fileid, rc); 	strcpy(buf, tfileid); 	w = buf + strlen(buf) - 3;  	*w++ = 'J'; 	*w++ = 'O'; 	*w++ = 'B'; 	fi.fab.fab$l_fna = buf;  	fi.fab.fab$b_fns = strlen(buf);0 	if (!(rc = sys$rename(&fo.fab, 0, 0, &fi.fab)))# 		error("renaming", fo.fileid, rc);   ( 	/* Wake up the main LISTSERV process */ 	strcpy(buf, lsvname); 	strcat(buf, "_WAKE_LKSB");   	SET_FDAL(&d, buf, strlen(buf));/ 	sys$enqw(0, LCK$K_EXMODE, &lksb, LCK$M_SYSTEM,  		    &d, 0, 0, 0, 0, 0, 0); 	sys$deq(lksb.ID, 0, 0, 0);    	/* All done */  	return(1);  }    #ifndef NO_MAIN  int main(int argc, char **argv)  {      /* Check arguments */      if (argc < 2) {  	    printf("\H Syntax: LSV_MAILIN to_userid fileid [from_userid [LISTSERV_userid]]\n"); 	    return(0);      }   B     return(lsv_mailin(argv[1], argv[2], (argc < 3) ? "" : argv[3],! 					(argc < 4) ? "" : argv[4]));  }  #endif