 /* ** MAIL_REWRITE.C  **F ** Formerly known as ADD_TRANSFORM.C from ANU-NEWS. For the DECUS UUCPE ** mailer, we need some form of address rewriting. This code provided < ** a good baseline, which was then beaten into what we need. **F ** No attempts have been made to mark the changes. This is effectivelyH ** new code, don't even think about trying to get it fit back into NEWS. **2 ** Tom Allebrandi	Advanced Computer Consulting,Inc ** ta2@acci.com  */     /**++ 
 **  FACILITY:  ** **      NEWSINCLUDE  **
 **  ABSTRACT:  **# **      Common NEWS include modules  ** **  AUTHOR:  ** **      Geoff Huston ** **  COPYRIGHT: ** **      Copyright  1988 ** **  MODIFICATION HISTORY:  **# **      V5.5     7-Oct-1988     GIH # **      V5.6    11-Nov-1988     GIH $ **          No changes made for V5.6 ** **-- **/   9                                 /* VMS INCLUDE MODULES */  #include	<ctype.h> #include	<stdio.h>     /* **++
 **  FACILITY:  ** **      ADD_TRANSFORM  **
 **  ABSTRACT:  **F **      This module converts patterns representing mail addresses fromC **	one form to another. This normally takes the form of recognizing @ **	local addresses, and using the local username as the address,D **	recognising addresses which map to users on the local DECnet, andE **	using a DECnet-format address, and sending all other address types  **	to a mail gateway.  **J **      This code has been set up to read an address configuration file atF **      startup, and apply the configuration rules to the addresses to; **      produce a useful address for the DECUS UUCP system.  ** **      You must: K **          - create a local configuration file (uucp_config:rewrite.rules) M **            and use that file to set up local address configuration rules .  **0 **            The file has the following format:G **              # (in column 1) is a comment line - the line is ignored  **		[rule set]- **              internet_address rebuild_rule - **              internet_address rebuild_rule - **              internet_address rebuild_rule  **H **	      The [rule set] indicator shows which of four sets the following8 **	      rules belong to. The indicators must be one of: ** **		[INBOUND-TO] **		[INBOUND-FROM] **		[OUTBOUND-TO]  **		[OUTBOUND-FROM]  **C **	      Case is sensitive. Rules preceeded by an unrecognized rule # **	      set indicator are ignored.  **L **            The internet address field must start in column 1 and must notN **            contain space characters. The '*' character may be used to forceO **            a wildcard match with the address being tested. The '?' character + **            matches any single character.  **M **            The rebuild rule must be separated from the internet address by L **            at least one space character. The '\' character is used as theD **            escape character: normally it is used to specify matchJ **            subsitiutions - the '\' character itself is specified by the **            sequence '\\'. ** **            e.g.: 5 **              # this is an example address cnf file $ **              *@*.anu.* \002::\001$ **              *@*.anu   \002::\0015 **              *@*       "gateway::in%""\001@\002""" $ **              *::*      \001::\002 **              *         \001 **L **            The rules are applied in order until a succesful match is madeO **            with an internet address form - then the matching rebuild rule is N **            selected to transform that address into a form acceptable to VMS **            MAIL.  **O **            Control characters in the rebuild pattern of the first successful F **            address match correspond to substitution of the originalM **            substring which matched at the corresponding wildcard position.  **            eg: * **                  pattern = "*@fred.*!*"6 **                  rebuild = "\002-\003|BB\001|\002'" **4 **                  input   = user@fred.example!last4 **                            ----      ------- ----1 **                            1         2       3  **               gives: : **                  output  = example-last|BBuser|example'9 **                            ------- ----   ---- ------- 3 **                            2       3      1    2  ** **  AUTHORS: ** **      Geoff Huston **	Tom Allebrandi  ** **  COPYRIGHT: ** **      Copyright  1988 ** **  MODIFICATION HISTORY:  **# **      V5.5     7-Oct-1988     GIH J **          Change parsing of news_address.cnf to allow tabs as seperators# **      V5.6    11-Nov-1988     GIH H **          Change default PMDF rule set to leave in%* and psi%* address **          formats unaltered. **#####  **	V1.0	 4-May-1989	TA2	 **	    Modified for DECUS UUCP **-- **/   -                         /* Local Variables */   O static int sm[20],      /* markers used in wild card match and substitution. */ O            em[20];      /* sm is an array of start positions, em is an array */ O                         /* of end position of the wildcard match points      */     P static char retadd[2048];    /* the return address is built in this variable  */  O static struct {         /* the structure which holds the address patterns    */ M     char *inputP,     /* and the corresponding rewrite rules               */           *outputP;     int  class;      } *addrs = 0;    /*  * Classes of rules   */  #define	INBOUND_TO	 1  #define	INBOUND_FROM	 2  #define	OUTBOUND_TO	 3 #define	OUTBOUND_FROM	 4D #define	IGNORED		99	/* Something that will never match the others */     " static	struct	selector_map_entry {
 	char	*nameP;  	int	class;  	} selector_mapA[] =" 		{{"[INBOUND-TO]",   INBOUND_TO},$ 		 {"[INBOUND-FROM]", INBOUND_FROM},# 		 {"[OUTBOUND-TO]",  OUTBOUND_TO}, & 		 {"[OUTBOUND-FROM]",OUTBOUND_FROM}};O #define	NUM_SELECTORS (sizeof(selector_mapA)/sizeof(struct selector_map_entry))      /*  *++  *  Description:I  *      Read the local address configuration file into a memory structure   *  *  Parameters:   *      None  *  *  Side effects: L  *      Sufficient memory for the config rules is allocated from free memory  *  *  Exceptions:   *      None  *  *  Result: >  *      Struct pointer addrs points to loaded address rule set  *--  */    init_transform() {      FILE *fpr;     char inline[256],           result[256],           *c;     int size = 0,          malloc_size = 0,     	t,  	current_class = IGNORED;   ;     fpr = fopen("MX_UUCP_DIR:UUCP_MAIL_REWRITE.RULES","r"); >     if (!fpr) fpr = fopen ("UUCP_CFG:MAIL_REWRITE.RULES","r");  4     if (fpr) {    /* Check if file is accessible  */         char *c1,               *c2;   N         while (fgets(inline,256,fpr)) {     /* read file line-by-line       */N             if (*inline == '#') continue;   /* skip comment lines           */  P             if (c = strchr(inline,'\n')) *c = '\0'; /* strip trailing lf char */   	    /*   	     * Test for class selection 	     */A 	    if ((inline[0] == '[') && (inline[strlen(inline)-1] == ']'))  		{ / 		current_class = IGNORED;	/* Assume failure */  		for (t=0;t<NUM_SELECTORS;t++)  			{2 			if (strcmp(inline,selector_mapA[t].nameP) == 0) 				{ + 				current_class = selector_mapA[t].class; 
 				break; 				}  			} 		continue;  		}   P                       /* divide into two parts using white chars as separator */             c = inline; %             while (!isspace(*c)) c++; ,             while (isspace(*c)) *c++ = '\0';  O             c1 = c;     /* pick out '\...' substrings and convert to numeric */              c2 = result;             while (*c1) { /                 if (*c1 != '\\') *c2++ = *c1++;                  else {                     c1++; Z                     if (isdigit(*c1)) { /* found '\nnn' substring - convert using octal */%                         char *s = c1, !                              sav;                           int tmp;  0                         while (isdigit(*s)) s++;!                         sav = *s; "                         *s = '\0';C                         if (sscanf(c1,"%o",&tmp) == 1) *c2++ = tmp; !                         *s = sav;                          c1 = s;                          } R                     else *c2++ = *c1++;  /* else simply use next char literally */                     }                  }              *c2 = '\0';              c = result;   )                 /* now add to rule set */ S             if (!malloc_size) addrs = malloc((malloc_size = 5)  * (sizeof *addrs)); f             else if (size >= malloc_size) addrs = realloc(addrs,(malloc_size += 5) * (sizeof *addrs));M             strcpy((addrs[size].inputP = malloc(strlen(inline) + 1)),inline); D             strcpy((addrs[size].outputP = malloc(strlen(c) + 1)),c);' 	    addrs[size].class = current_class;              ++size; 
             }   .             /* add emtpy (terminating) rule */         *inline = '\0';          c = inline; O         if (!malloc_size) addrs = malloc((malloc_size = 5)  * (sizeof *addrs)); b         else if (size >= malloc_size) addrs = realloc(addrs,(malloc_size += 1) * (sizeof *addrs));I         strcpy((addrs[size].inputP = malloc(strlen(inline) + 1)),inline); @         strcpy((addrs[size].outputP = malloc(strlen(c) + 1)),c);$         addrs[size].class = IGNORED;         fclose(fpr);	         }   ( 	/* No configuration file - no rules! */     else addrs = 0;    }    /*
  *  transform   *H  *  Build the equivalence string using the rebuilding rule correspondingB  *  to the successfully matched pattern. sm and em now contain the6  *  wildcard match points in the original input string  */   ! static char *transform(locname,i)      char *locname;
     int i; {      int j = 0,
         k,         r = 0;     char lc;  &     while (lc = addrs[i].outputP[j]) {         if (lc < 20) {6             for (k = sm[lc - 1]; k <= em[lc - 1]; ++k))                 retadd[r++] = locname[k]; 
             } /         else retadd[r++] = addrs[i].outputP[j];          j++;	         }      retadd[r] = '\0';      return(retadd);  }    /*	  *  match   *?  *  Recursive match procedure which performs wildcard matching.   */    static match(l,p,i,li)     char *l,          *p;
     int i,         li;  {      if (!*l) {         if (!*p) return(1);          else if (*p == '*') {              sm[i] = 0;             em[i] = -1; (             return(match(l,p+1,i+1,li));
             }          else return(0); 	         }      if (*p == '*') {         sm[i] = li;          em[i] = li - 1; &         while (!match(l,p+1,i+1,li)) {             l++;             li++;              em[i] = li - 1;              if (!*l) {'                 if (!*(p+1)) return(1);                  else return(0);                  } 
             }          return(1);	         } 1     if (*p == '?') return(match(l+1,p+1,i,li+1)); B     return((tolower(*l) == tolower(*p)) && match(l+1,p+1,i,li+1)); }    /*  *  add_transform   *?  *  Entry point. Returns the VMS Mail equivalent address of the   *  supplied inputP address.  */    char *add_transform(s,c)     char *s;
     int c; {      char locname[2048],           *p;     int i = 0;       if (p = strchr(s,'<')) {         strcpy(locname,++p);/         if (p = strchr(locname,'>')) *p = '\0'; 0         if (p = strchr(locname,'\n')) *p = '\0';	         } 
     else {:                                 /* strip leading blanks */         while (*s == ' ') s++;         strcpy(locname,s);  J                                 /* strip trailing fields (this should be a?                                    personal name if present) */ /         if (p = strchr(locname,' ')) *p = '\0'; /         if (p = strchr(locname,'(')) *p = '\0'; 	         }   '             /* convert to lower case */      p = locname;)     while (*p) { *p = tolower(*p); p++; }   8         /* no transform rules loaded - return address */     if (!addrs) return(s);  4         /* find a match, and return the transform */      while (*(addrs[i].inputP)) {J         if ((addrs[i].class == c) && (match(locname,addrs[i].inputP,0,0))))             return(transform(locname,i));          i++;	         }        return(s); } 