 #module BannerPE "V2.1"    /* **++
 **  FACILITY:  **% **      The DECwindows Banner program  **
 **  ABSTRACT:  **C **      This module contains all the code, to run the Lavc monitor.  ** **  AUTHORS: ** **      JIM SAUNDERS ** **% **  CREATION DATE:     20th June 1988  ** **  MODIFICATION HISTORY:  **C **      V02-1   LPL0001        Lee Leahy                14 Oct 1991 G **              Changed the display to show LAN adapter utilization and K **              errors, and display virtual circuit utilization and errors. 8 **              The PE counters are no longer displayed. **' **              LAN Adapter Utilization J **                  Error count - The number of transmit errors using thisJ **                      LAN adapter.  Highlighted if error rate exceeds a ) **                      threashold value. H **                  Adapter name - LAN adapter name.  Highlighted if theA **                      LAN adapter is unavailable for NISCA use. G **                  % of LAN - NISCA protocol utilization (transmit and D **                      receive) of this LAN adapter as a percentage5 **                      of the maximum LAN bandwidth. I **                  Adapter utilization graph - Transmit utilization as a L **                      percentage of the total NISCA traffic for this node.L **                      Receive utilization (highlighted) as a percentage ofK **                      the total NISCA traffic for this node.  Combination I **                      for all adapters will be less than 100% since the F **                      local loopback adapter (BUS) is not displayed. **+ **              Virtual Circuit Utilization N **                  Retransmit error count - Number of messages retransmitted M **                      to this remote node.  This error count is highlighted M **                      if the combined (retransmit + re-receive) error rate  3 **                      exceeds a threashold value. N **                  Re-receive error count - Number of messages received againO **                      from this remote node.  This error count is highlighted M **                      if the combined (retransmit + re-receive) error rate  3 **                      exceeds a threashold value. C **                  SCS node name - Node name of the remote system. G **                  % of LAN - NISCA protocol utilization (transmit and H **                      receive) of this virtual circuit as a percentageG **                      of the maximum LAN bandwidth available to this  C **                      node (total bandwidth of all LAN adapters). M **                  Virtual circuit traffic graph - Transmit utilization as a L **                      percentage of the total NISCA traffic for this node.L **                      Receive utilization (highlighted) as a percentage ofK **                      the total NISCA traffic for this node.  Combination N **                      for all nodes will be less than 100% since total NISCAB **                      traffic includes channel control messages. **6 **      V02-0   TEC200         T Coughlan		23-Aug-1991E **              Update the PE counters to match the current driver.   C **              (Modifications to file obtained from: BANNER003.A.)  ** **/      /* ** **  INCLUDE FILES  ** **/    #include <stdio.h> #include <syidef.h> + #include <decw$include/DECwDwtWidgetProg.h>  #include "Banner"  #include "BANNER_PE" #include "PEM_DEF" #include "LANUDEF"   /* ** **  MACRO DEFINITIONS  ** **/    #define SS$_NORMAL 1   typedef struct _vms_item_list {  	short	 buffer_length; 	short	 item_code; 	void	*buffer; 	int	*returned_buffer_length;  	} VMS_ItemList;   /*"  * now our runtime data structures  */    extern	 Bnr$_Blk    Bnr; extern   pem$_Blk    pem;  extern   pes$_Blk    pes;  extern	 GC	     BannerGC;  extern	 XGCValues   GcValues;     globalref   pes$_Blk    new_pes;  = globaldef struct PE_BUS	    BUS_ARRAY [ PE_BUS$C_BUS_COUNT ]; 9 globaldef struct PE_VC	    VC_ARRAY [ PE_VC$C_VC_COUNT ];     extern void BannerSignalError();   static int tw; static int w2w;  static int w5w;  static int w8w;  static int bus_error_width;  static int bus_name_width; static int bus_percent_width; G static int bus_graph_0_width, bus_graph_100_width, bus_graph_min_width;  static int vc_rexmt_width; static int vc_rercv_width; static int vc_name_width;  static int vc_percent_width;D static int vc_graph_0_width, vc_graph_100_width, vc_graph_min_width; static int tx_width, rx_width;   static int vc_error_rate = 0;   - static int pe_update_count, pe_update_number;  static int pe_init = 0;    /* **++ **  FUNCTIONAL DESCRIPTION:  ** **	BannerPESetup ()  **L **      This is the setup routine for the Banner monitor, it initialises all: **	the data structurtes for the monitor section of Banner. ** **  FORMAL PARAMETERS: ** **      none ** **  IMPLICIT INPUTS: ** **      none ** **  IMPLICIT OUTPUTS:  ** **      none ** **  COMPLETION CODES:  ** **      none ** **  SIDE EFFECTS:  ** **      none ** **-- **/  void	  BannerPESetup()  {  int nmsize;  /*    * setup standard text widths   */ =     tw = XTextWidth(Bnr.font_ptr, "NewPathNoticeDlvrd ", 19); ,     w2w = XTextWidth(Bnr.font_ptr, "88", 2);/     w5w = XTextWidth(Bnr.font_ptr, "88888", 5); 2     w8w = XTextWidth(Bnr.font_ptr, "88888888", 8);  ?     bus_error_width = XTextWidth ( Bnr.font_ptr, "888888", 6 ); %     vc_rexmt_width = bus_error_width; %     vc_rercv_width = bus_error_width; <     bus_name_width = XTextWidth ( Bnr.font_ptr, "Name", 4 );?     vc_name_width = XTextWidth ( Bnr.font_ptr, "SCS Node", 8 ); C     bus_percent_width = XTextWidth ( Bnr.font_ptr, "% of LAN", 8 ); )     vc_percent_width = bus_percent_width; <     bus_graph_0_width = XTextWidth ( Bnr.font_ptr, "0", 1 );)     vc_graph_0_width = bus_graph_0_width; @     bus_graph_100_width = XTextWidth ( Bnr.font_ptr, "100", 3 );-     vc_graph_100_width = bus_graph_100_width; 4     tx_width = XTextWidth ( Bnr.font_ptr, "Tx", 2 );4     rx_width = XTextWidth ( Bnr.font_ptr, "Rx", 2 );^     bus_graph_min_width = bus_graph_0_width + tx_width + w2w + rx_width + bus_graph_100_width;-     vc_graph_min_width = bus_graph_min_width;        pe_update_count = 1;     if (Bnr.pe_update == 0) # 	pe_update_number = Bnr.cpu_update;      else" 	pe_update_number = Bnr.pe_update;       pe_init = 1; }    /* **++ **  FUNCTIONAL DESCRIPTION:  ** **	BannerPERefresh ()  **H **      This routine rewrites all the static information display by the  **	Monitor section of Banner.  ** **  FORMAL PARAMETERS: ** ** **  IMPLICIT INPUTS: ** ** **  IMPLICIT OUTPUTS:  ** **      none ** **  COMPLETION CODES:  ** **      none ** **  SIDE EFFECTS:  ** **      none ** **-- **/  void	  BannerPERefresh()  { %     int lx_pos, rx_pos, x_pos, y_pos; '     char string[] = "                ";        if (!pe_init)  	BannerPESetup ();   /*       x_pos = Bnr.font_height/2;     y_pos = Bnr.font_height;  $     rx_pos = tw + Bnr.font_height/2;.     lx_pos = rx_pos + w5w + Bnr.font_height/2;   	{E 	BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget), # 	    x_pos, y_pos, "PathCount", 1,  	 	    tw);  	if (pem.vc_cnt != 0)  	    {. 	    sprintf (string, "%d", pem.vc_cnt_rate);  	    if (pem.vc_cnt_rate != 0)F 		BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		    rx_pos, y_pos, string, 3,  		    w5w); ) 	    sprintf (string, "%d", pem.vc_cnt);  I 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, string, 3,  		    w8w);  	    } 	else  	    {I 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		rx_pos, y_pos, " ", 3,   		w5w); I 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, "0", 3,   		w8w);  	    }! 	y_pos = y_pos + Bnr.font_height;  	}   	{E 	BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget), ' 	    x_pos, y_pos, "NewPathFormed", 1,  	 	    tw);  	if (pem.ret_id_attempts != 0) 	    {7 	    sprintf (string, "%d", pem.ret_id_attempts_rate);  ' 	    if (pem.ret_id_attempts_rate != 0) F 		BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		    rx_pos, y_pos, string, 3,  		    w5w); 2 	    sprintf (string, "%d", pem.ret_id_attempts); I 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, string, 3,  		    w8w);  	    } 	else  	    {I 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		rx_pos, y_pos, " ", 3,   		w5w); I 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, "0", 3,   		w8w);  	    }! 	y_pos = y_pos + Bnr.font_height;  	}   	{E 	BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget), , 	    x_pos, y_pos, "NewPathNoticeDlvrd", 1, 	 	    tw);  	if (pem.ret_ids_sent != 0)  	    {4 	    sprintf (string, "%d", pem.ret_ids_sent_rate); $ 	    if (pem.ret_ids_sent_rate != 0)F 		BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		    rx_pos, y_pos, string, 3,  		    w5w); / 	    sprintf (string, "%d", pem.ret_ids_sent);  I 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, string, 3,  		    w8w);  	    } 	else  	    {I 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		rx_pos, y_pos, " ", 3,   		w5w); I 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, "0", 3,   		w8w);  	    }! 	y_pos = y_pos + Bnr.font_height;  	}   	{E 	BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget), $ 	    x_pos, y_pos, "KbytesSent", 1, 	 	    tw);  	if (pem.xmt_bytes != 0) 	    {1 	    sprintf (string, "%d", pem.xmt_bytes_rate);  ! 	    if (pem.xmt_bytes_rate != 0) F 		BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		    rx_pos, y_pos, string, 3,  		    w5w); , 	    sprintf (string, "%d", pem.xmt_bytes); I 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, string, 3,  		    w8w);  	    } 	else* 	    {I 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),* 		rx_pos, y_pos, " ", 3, a 		w5w);dI 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),* 		lx_pos, y_pos, "0", 3,   		w8w);e 	    }! 	y_pos = y_pos + Bnr.font_height;  	}   	{E 	BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget), " 	    x_pos, y_pos, "PktsSent", 1, 	 	    tw);l 	if (pem.xmt_msg != 0) 	    {/ 	    sprintf (string, "%d", pem.xmt_msg_rate);   	    if (pem.xmt_msg_rate != 0)cF 		BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		    rx_pos, y_pos, string, 3,  		    w5w);u* 	    sprintf (string, "%d", pem.xmt_msg); I 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, string, 3,  		    w8w);  	    } 	elsep 	    {I 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),e 		rx_pos, y_pos, " ", 3, u 		w5w); I 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, "0", 3, o 		w8w);N 	    }! 	y_pos = y_pos + Bnr.font_height;  	}   	{E 	BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),p* 	    x_pos + w2w, y_pos, "DGpktsSent", 1, 	 	    tw);  	if (pem.xmt_unseq != 0) 	    {1 	    sprintf (string, "%d", pem.xmt_unseq_rate);  ! 	    if (pem.xmt_unseq_rate != 0)eF 		BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		    rx_pos, y_pos, string, 3,  		    w5w); , 	    sprintf (string, "%d", pem.xmt_unseq); I 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),* 		lx_pos, y_pos, string, 3,  		    w8w);  	    } 	else  	    {I 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		rx_pos, y_pos, " ", 3, h 		w5w);cI 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, "0", 3, * 		w8w);  	    }! 	y_pos = y_pos + Bnr.font_height;* 	}   	{E 	BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget), * 	    x_pos + w2w, y_pos, "VCpktsSent", 1, 	 	    tw);c 	if (pem.xmt_seq != 0) 	    {/ 	    sprintf (string, "%d", pem.xmt_seq_rate); c 	    if (pem.xmt_seq_rate != 0) F 		BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		    rx_pos, y_pos, string, 3,  		    w5w); * 	    sprintf (string, "%d", pem.xmt_seq); I 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),t 		lx_pos, y_pos, string, 3,  		    w8w);f 	    } 	elseN 	    {I 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),l 		rx_pos, y_pos, " ", 3,   		w5w); I 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, "0", 3, o 		w8w);  	    }! 	y_pos = y_pos + Bnr.font_height;  	}   	{E 	BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget), , 	    x_pos + w2w, y_pos, "LoneACKsSent", 1, 	 	    tw);  	if (pem.xmt_ack != 0) 	    {/ 	    sprintf (string, "%d", pem.xmt_ack_rate);   	    if (pem.xmt_ack_rate != 0)sF 		BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		    rx_pos, y_pos, string, 3,  		    w5w);o* 	    sprintf (string, "%d", pem.xmt_ack); I 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, string, 3,  		    w8w);  	    } 	else. 	    {I 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),a 		rx_pos, y_pos, " ", 3, " 		w5w);eI 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, "0", 3, y 		w8w);u 	    }! 	y_pos = y_pos + Bnr.font_height;; 	}   	{E 	BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),L+ 	    x_pos + w2w, y_pos, "Retransmits", 1, s	 	    tw);x 	if (pem.xmt_rexmt != 0) 	    {1 	    sprintf (string, "%d", pem.xmt_rexmt_rate); n! 	    if (pem.xmt_rexmt_rate != 0)lF 		BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		    rx_pos, y_pos, string, 3,  		    w5w); , 	    sprintf (string, "%d", pem.xmt_rexmt); I 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),i 		lx_pos, y_pos, string, 3,  		    w8w);  	    } 	elses 	    {I 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),i 		rx_pos, y_pos, " ", 3, r 		w5w);iI 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),_ 		lx_pos, y_pos, "0", 3, w 		w8w);t 	    }! 	y_pos = y_pos + Bnr.font_height;r 	}   	{E 	BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),t+ 	    x_pos, y_pos, "KbytesRcvd,VCopen", 1, c	 	    tw);a 	if (pem.rcv_bytes != 0) 	    {1 	    sprintf (string, "%d", pem.rcv_bytes_rate); D! 	    if (pem.rcv_bytes_rate != 0)(F 		BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		    rx_pos, y_pos, string, 3,  		    w5w);o, 	    sprintf (string, "%d", pem.rcv_bytes); I 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),* 		lx_pos, y_pos, string, 3,  		    w8w);  	    } 	elseC 	    {I 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		rx_pos, y_pos, " ", 3,   		w5w);iI 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),o 		lx_pos, y_pos, "0", 3,   		w8w);  	    }! 	y_pos = y_pos + Bnr.font_height;; 	}   	{E 	BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),_) 	    x_pos, y_pos, "PktsRcvd,VCopen", 1,  	 	    tw);h 	if (pem.rcv_msg != 0) 	    {/ 	    sprintf (string, "%d", pem.rcv_msg_rate); r 	    if (pem.rcv_msg_rate != 0) F 		BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		    rx_pos, y_pos, string, 3,  		    w5w);8* 	    sprintf (string, "%d", pem.rcv_msg); I 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, string, 3,  		    w8w);n 	    } 	else; 	    {I 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),( 		rx_pos, y_pos, " ", 3,   		w5w);aI 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),p 		lx_pos, y_pos, "0", 3, h 		w8w);i 	    }! 	y_pos = y_pos + Bnr.font_height;p 	}   	{E 	BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),;$ 	    x_pos, y_pos, "DGpktsRcvd", 1, 	 	    tw);  	if (pem.rcv_unseq != 0) 	    {1 	    sprintf (string, "%d", pem.rcv_unseq_rate); _! 	    if (pem.rcv_unseq_rate != 0)eF 		BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		    rx_pos, y_pos, string, 3,  		    w5w); , 	    sprintf (string, "%d", pem.rcv_unseq); I 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),P 		lx_pos, y_pos, string, 3,  		    w8w);* 	    } 	elseC 	    {I 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),* 		rx_pos, y_pos, " ", 3,   		w5w);*I 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),, 		lx_pos, y_pos, "0", 3,   		w8w);  	    }! 	y_pos = y_pos + Bnr.font_height;P 	}   	{E 	BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget), + 	    x_pos, y_pos, "VCpktsRcvdInOrder", 1, x	 	    tw);o 	if (pem.rcv_seq != 0) 	    {/ 	    sprintf (string, "%d", pem.rcv_seq_rate); t 	    if (pem.rcv_seq_rate != 0)pF 		BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		    rx_pos, y_pos, string, 3,  		    w5w); * 	    sprintf (string, "%d", pem.rcv_seq); I 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, string, 3,  		    w8w);n 	    } 	else" 	    {I 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),w 		rx_pos, y_pos, " ", 3, s 		w5w); I 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),. 		lx_pos, y_pos, "0", 3, e 		w8w);  	    }! 	y_pos = y_pos + Bnr.font_height;  	}   	{E 	BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget), ) 	    x_pos, y_pos, "VCpktsRcvdEarly", 1, =	 	    tw);r 	if (pem.rcv_cache != 0) 	    {1 	    sprintf (string, "%d", pem.rcv_cache_rate); e! 	    if (pem.rcv_cache_rate != 0)PF 		BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		    rx_pos, y_pos, string, 3,  		    w5w);a, 	    sprintf (string, "%d", pem.rcv_cache); I 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, string, 3,  		    w8w);) 	    } 	elsef 	    {I 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),e 		rx_pos, y_pos, " ", 3, ) 		w5w);pI 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),i 		lx_pos, y_pos, "0", 3, d 		w8w);i 	    }! 	y_pos = y_pos + Bnr.font_height;" 	}   	{E 	BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),e( 	    x_pos, y_pos, "DuplicatesRcvd", 1, 	 	    tw);  	if (pem.rcv_rercv != 0) 	    {1 	    sprintf (string, "%d", pem.rcv_rercv_rate); w! 	    if (pem.rcv_rercv_rate != 0) F 		BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		    rx_pos, y_pos, string, 3,  		    w5w);%, 	    sprintf (string, "%d", pem.rcv_rercv); I 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, string, 3,  		    w8w);n 	    } 	else5 	    {I 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),p 		rx_pos, y_pos, " ", 3, w 		w5w);wI 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),{ 		lx_pos, y_pos, "0", 3, i 		w8w);. 	    }! 	y_pos = y_pos + Bnr.font_height;x 	}   	{E 	BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget), & 	    x_pos, y_pos, "LoneACKsRcvd", 1, 	 	    tw);, 	if (pem.rcv_ack != 0) 	    {/ 	    sprintf (string, "%d", pem.rcv_ack_rate); e 	    if (pem.rcv_ack_rate != 0)iF 		BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		    rx_pos, y_pos, string, 3,  		    w5w);f* 	    sprintf (string, "%d", pem.rcv_ack); I 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),, 		lx_pos, y_pos, string, 3,  		    w8w);_ 	    } 	else  	    {I 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),( 		rx_pos, y_pos, " ", 3, t 		w5w);nI 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, "0", 3, t 		w8w);a 	    }! 	y_pos = y_pos + Bnr.font_height;* 	}   	{E 	BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),d' 	    x_pos, y_pos, "VCbuf>ChanBuf", 1, s	 	    tw);" 	if (pem.topology_change != 0) 	    {7 	    sprintf (string, "%d", pem.topology_change_rate); a' 	    if (pem.topology_change_rate != 0))F 		BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		    rx_pos, y_pos, string, 3,  		    w5w);_2 	    sprintf (string, "%d", pem.topology_change); I 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),x 		lx_pos, y_pos, string, 3,  		    w8w);  	    } 	elseg 	    {I 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),n 		rx_pos, y_pos, " ", 3, _ 		w5w);nI 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),a 		lx_pos, y_pos, "0", 3, ( 		w8w);d 	    }! 	y_pos = y_pos + Bnr.font_height;  	}   	{E 	BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),x) 	    x_pos, y_pos, "NoNpageDynForTx", 1, y	 	    tw);s 	if (pem.npagedyn_low != 0){ 	    {4 	    sprintf (string, "%d", pem.npagedyn_low_rate); $ 	    if (pem.npagedyn_low_rate != 0)F 		BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		    rx_pos, y_pos, string, 3,  		    w5w); / 	    sprintf (string, "%d", pem.npagedyn_low);  I 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),s 		lx_pos, y_pos, string, 3,  		    w8w);i 	    } 	elsem 	    {I 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),) 		rx_pos, y_pos, " ", 3, , 		w5w); I 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),d 		lx_pos, y_pos, "0", 3, e 		w8w);x 	    }! 	y_pos = y_pos + Bnr.font_height;e 	}   	{E 	BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),,% 	    x_pos, y_pos, "NoChanForTX", 1, y	 	    tw);f 	if (pem.xmt_noxch != 0) 	    {1 	    sprintf (string, "%d", pem.xmt_noxch_rate); w! 	    if (pem.xmt_noxch_rate != 0)"F 		BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		    rx_pos, y_pos, string, 3,  		    w5w); , 	    sprintf (string, "%d", pem.xmt_noxch); I 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),r 		lx_pos, y_pos, string, 3,  		    w8w);g 	    } 	else_ 	    {I 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		rx_pos, y_pos, " ", 3,   		w5w);8I 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),) 		lx_pos, y_pos, "0", 3, l 		w8w);s 	    }! 	y_pos = y_pos + Bnr.font_height;i 	}   	{E 	BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),", 	    x_pos, y_pos, "TXstall,FullWindow", 1, 	 	    tw);t 	if (pem.tr_pipe_quota != 0) 	    {5 	    sprintf (string, "%d", pem.tr_pipe_quota_rate); p% 	    if (pem.tr_pipe_quota_rate != 0) F 		BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		    rx_pos, y_pos, string, 3,  		    w5w);=0 	    sprintf (string, "%d", pem.tr_pipe_quota); I 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, string, 3,  		    w8w);  	    } 	elsee 	    {I 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),, 		rx_pos, y_pos, " ", 3,   		w5w); I 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),e 		lx_pos, y_pos, "0", 3,   		w8w);5 	    }! 	y_pos = y_pos + Bnr.font_height;e 	}   	{E 	BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),}( 	    x_pos, y_pos, "ShortTRpktRcvd", 1, 	 	    tw);e 	if (pem.rcv_tr_short != 0)w 	    {4 	    sprintf (string, "%d", pem.rcv_tr_short_rate); $ 	    if (pem.rcv_tr_short_rate != 0)F 		BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		    rx_pos, y_pos, string, 3,  		    w5w);a/ 	    sprintf (string, "%d", pem.rcv_tr_short);  I 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),n 		lx_pos, y_pos, string, 3,  		    w8w);n 	    } 	elset 	    {I 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),	 		rx_pos, y_pos, " ", 3,   		w5w); I 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),	 		lx_pos, y_pos, "0", 3, 	 		w8w);  	    }! 	y_pos = y_pos + Bnr.font_height;) 	}   	{E 	BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),s) 	    x_pos, y_pos, "IllegalACKsRcvd", 1, n	 	    tw);t 	if (pem.rcv_ill_ack != 0) 	    {3 	    sprintf (string, "%d", pem.rcv_ill_ack_rate); o# 	    if (pem.rcv_ill_ack_rate != 0)bF 		BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		    rx_pos, y_pos, string, 3,  		    w5w);t. 	    sprintf (string, "%d", pem.rcv_ill_ack); I 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),t 		lx_pos, y_pos, string, 3,  		    w8w);i 	    } 	elsea 	    {I 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),8 		rx_pos, y_pos, " ", 3, { 		w5w);nI 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),s 		lx_pos, y_pos, "0", 3, i 		w8w);n 	    }! 	y_pos = y_pos + Bnr.font_height;i 	}   	{E 	BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),p+ 	    x_pos, y_pos, "DscrdVCpkt,VCclsd", 1, e	 	    tw);p 	if (pem.rcv_ill_seq != 0) 	    {3 	    sprintf (string, "%d", pem.rcv_ill_seq_rate);  # 	    if (pem.rcv_ill_seq_rate != 0) F 		BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		    rx_pos, y_pos, string, 3,  		    w5w);y. 	    sprintf (string, "%d", pem.rcv_ill_seq); I 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),. 		lx_pos, y_pos, string, 3,  		    w8w);( 	    } 	else  	    {I 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),s 		rx_pos, y_pos, " ", 3, e 		w5w);iI 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, "0", 3, e 		w8w);i 	    }! 	y_pos = y_pos + Bnr.font_height;e 	}   	{E 	BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),g) 	    x_pos, y_pos, "RcvdBadTRchkSum", 1, (	 	    tw);e 	if (pem.rcv_bad_cksum != 0) 	    {5 	    sprintf (string, "%d", pem.rcv_bad_cksum_rate); v% 	    if (pem.rcv_bad_cksum_rate != 0)iF 		BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		    rx_pos, y_pos, string, 3,  		    w5w);n0 	    sprintf (string, "%d", pem.rcv_bad_cksum); I 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),e 		lx_pos, y_pos, string, 3,  		    w8w);d 	    } 	elsee 	    {I 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),e 		rx_pos, y_pos, " ", 3, e 		w5w); I 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),e 		lx_pos, y_pos, "0", 3, e 		w8w);  	    }! 	y_pos = y_pos + Bnr.font_height;, 	}   	{E 	BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),e) 	    x_pos, y_pos, "RetriesExceeded", 1, d	 	    tw);w 	if (pem.xmt_seq_tmo != 0) 	    {3 	    sprintf (string, "%d", pem.xmt_seq_tmo_rate); )# 	    if (pem.xmt_seq_tmo_rate != 0) F 		BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		    rx_pos, y_pos, string, 3,  		    w5w);i. 	    sprintf (string, "%d", pem.xmt_seq_tmo); I 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),t 		lx_pos, y_pos, string, 3,  		    w8w);d 	    } 	elses 	    {I 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),t 		rx_pos, y_pos, " ", 3, i 		w5w);.I 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),t 		lx_pos, y_pos, "0", 3, i 		w8w);. 	    }! 	y_pos = y_pos + Bnr.font_height;	 	}   	{E 	BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),t& 	    x_pos, y_pos, "FreeQueEmpty", 1, 	 	    tw);  	if (pem.fq_empty != 0)s 	    {0 	    sprintf (string, "%d", pem.fq_empty_rate);   	    if (pem.fq_empty_rate != 0)F 		BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		    rx_pos, y_pos, string, 3,  		    w5w);p+ 	    sprintf (string, "%d", pem.fq_empty);  I 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),e 		lx_pos, y_pos, string, 3,  		    w8w);n 	    } 	else  	    {I 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),e 		rx_pos, y_pos, " ", 3, e 		w5w);dI 	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),e 		lx_pos, y_pos, "0", 3, e 		w8w);d 	    }! 	y_pos = y_pos + Bnr.font_height;  	}    */)   }  } /* **++ **  FUNCTIONAL DESCRIPTION:} ** **	BannerPE () **8 **      This routine runs the Monitor display of banner. ** **  FORMAL PARAMETERS: ** **      none ** **  IMPLICIT INPUTS: ** **      none ** **  IMPLICIT OUTPUTS:. ** **      none ** **  COMPLETION CODES:t ** **      none ** **  SIDE EFFECTS:r ** **      none ** **-- **/g void		
 BannerPE() {o*     int rate, newkb, x_pos, y_pos, lx_pos;#     int width, x, y, x1, y1, y_max;BU     int bus_error_pos, bus_name_pos, bus_percent_pos, bus_graph_pos, bus_graph_width;s^     int vc_rexmt_pos, vc_rercv_pos, vc_name_pos, vc_percent_pos, vc_graph_pos, vc_graph_width;     int vcs_displayed;'     char string[] = "                ";w     int status, iocnt, len;      long int bus_index;d     long int vc_index;     struct PE_BUS *bus;      struct PE_VC *vc;s*     unsigned long int total_lan_bandwidth;&     unsigned long int lan_utilization;/     struct PE_VC *vc_display_array [ 100 + 1 ];o     long int hash_index;       if (!pe_init)! 	BannerPERefresh ();       pe_update_count --;_     if (pe_update_count > 0) 	return; 	0'     pe_update_count = pe_update_number;i        status = REMOTE_PE_COUNT ();     if (status != 1) 	{6 	printf("\nPE access routine returned bad status.\n");. 	printf("PE Monitor was built for VMS 5.5\n");/ 	printf("No PE statistics can be displayed\n");o 	Bnr.Param_Bits.pe_window = 0;	  	return; 	}   /*7  * For each BUS, update the statistics for the display.(  */e       lan_utilization = 0;F     for ( bus_index = 0; bus_index < PE_BUS$C_BUS_COUNT; bus_index++ )       {n  (         bus = & BUS_ARRAY [ bus_index ];.         if ( bus -> PE_BUS$T_NAME [ 0 ] != 0 )           {{  . 			/*  Highlight the BUS if it is offline.  */  ?             if (( bus -> PE_BUS$L_FLAGS & BUS$M_ONLINE ) == 0 ) 0               bus -> PE_BUS$L_HIGHLIGHT_BUS = 1;             else0               bus -> PE_BUS$L_HIGHLIGHT_BUS = 0;  ' 			/*  Compute the BUS utilization.  */t  0             if ( bus -> PE_BUS$L_XMT_LAST != 0 )               {pc                 bus -> PE_BUS$L_XMT_PERCENT = bus -> PE_BUS$L_XMT_BYTES - bus -> PE_BUS$L_XMT_LAST;WE                 bus -> PE_BUS$L_XMT_LAST = bus -> PE_BUS$L_XMT_BYTES;sc                 bus -> PE_BUS$L_RCV_PERCENT = bus -> PE_BUS$L_RCV_BYTES - bus -> PE_BUS$L_RCV_LAST;dE                 bus -> PE_BUS$L_RCV_LAST = bus -> PE_BUS$L_RCV_BYTES;   ' 			/*  Compute the LAN utilization.  */e  @                 if (( bus -> PE_BUS$L_FLAGS & BUS$M_LDL ) == 0 )p                   lan_utilization = lan_utilization + bus -> PE_BUS$L_XMT_PERCENT + bus -> PE_BUS$L_RCV_PERCENT;                 }x             else               {yE                 bus -> PE_BUS$L_XMT_LAST = bus -> PE_BUS$L_XMT_BYTES;g0                 bus -> PE_BUS$L_XMT_PERCENT = 0;E                 bus -> PE_BUS$L_RCV_LAST = bus -> PE_BUS$L_RCV_BYTES;n0                 bus -> PE_BUS$L_RCV_PERCENT = 0;               }   0             bus -> PE_BUS$L_LAN_UTILIZATION = 0;  J 			/*  Highlight the error count if the error rate exceeds 1 per hour.  */  R             bus -> PE_BUS$L_HIGHLIGHT_ERRORS = bus -> PE_BUS$L_HIGHLIGHT_ERRORS + u               ((( bus -> PE_BUS$L_XMT_ERRORS - bus  -> PE_BUS$L_XMT_ERRORS_LAST ) * 60. * 60. ) / pe_update_number );iJ             bus  -> PE_BUS$L_XMT_ERRORS_LAST = bus -> PE_BUS$L_XMT_ERRORS;             }        }s  . 		/*  Compute the utilization of each BUS.  */       total_lan_bandwidth = 0;     if ( lan_utilization != 0 ) H       for ( bus_index = 0; bus_index < PE_BUS$C_BUS_COUNT; bus_index++ )	         {   *           bus = & BUS_ARRAY [ bus_index ];0           if ( bus -> PE_BUS$T_NAME [ 0 ] != 0 )
             {y  D 			/*  LAN segment utilization associated with this LAN adapter.  */  o               bus -> PE_BUS$L_LAN_UTILIZATION = (( bus -> PE_BUS$L_XMT_PERCENT + bus -> PE_BUS$L_RCV_PERCENT ) t/                 * 8 * 100 ) / pe_update_number;,; 	      if ( bus -> PE_BUS$L_LAN_TYPE == VCIB$K_DLL_CSMACD )e                 {ed                   bus -> PE_BUS$L_LAN_UTILIZATION = ( bus -> PE_BUS$L_LAN_UTILIZATION / 10000000. );G                   total_lan_bandwidth = total_lan_bandwidth + 10000000;,                 }}               elseB                 if ( bus -> PE_BUS$L_LAN_TYPE == VCIB$K_DLL_FDDI )                   {wg                     bus -> PE_BUS$L_LAN_UTILIZATION = ( bus -> PE_BUS$L_LAN_UTILIZATION / 100000000. ); J                     total_lan_bandwidth = total_lan_bandwidth + 100000000;                   }	  3 			/*  Node load supported by this transmitter.  */r  e               bus -> PE_BUS$L_XMT_PERCENT = ( 100. * bus -> PE_BUS$L_XMT_PERCENT ) / lan_utilization;t  0 			/*  Node load supported by this receiver.  */  e               bus -> PE_BUS$L_RCV_PERCENT = ( 100. * bus -> PE_BUS$L_RCV_PERCENT ) / lan_utilization;n  
             }i	         }e   /*+  * Clear the Virtual Circuit display array.o  */"  5     for ( vc_index = 0; vc_index <= 100; vc_index++ )w(       vc_display_array [ vc_index ] = 0;   /*!  * Update the error rate counter.y  */=       if ( --vc_error_rate < 0 )9       vc_error_rate = ( 60 * 60 / pe_update_number ) - 1;n   /*6  * For each VC, update the statistics for the display.  */e  F     for ( vc_index = PE_VC$C_VC_COUNT - 1; vc_index >= 0; vc_index-- )       {t%         vc = & VC_ARRAY [ vc_index ];e0         if ( vc -> PE_VC$T_NODENAME [ 0 ] != 0 )           {B  , 			/*  Highlight the VC if it is closed.  */  :             if (( vc -> PE_VC$L_FLAGS & VC$M_OPEN ) == 0 )               {i/                 vc -> PE_VC$L_HIGHLIGHT_VC = 1;e5                 if ( vc -> PE_VC$L_CLOSED_COUNT > 0 ) N                   vc -> PE_VC$L_CLOSED_COUNT = vc -> PE_VC$L_CLOSED_COUNT - 1;               }	             else               {)/                 vc -> PE_VC$L_HIGHLIGHT_VC = 0;)  3 			/*  Display closed VCs for up to 10 minutes.  */	  H                 vc -> PE_VC$L_CLOSED_COUNT = 60 * 10 / pe_update_number;               }(  & 			/*  Compute the VC utilization.  */  .             if ( vc -> PE_VC$L_XMT_LAST != 0 )               {r]                 vc -> PE_VC$L_XMT_PERCENT = vc -> PE_VC$L_XMT_BYTES - vc -> PE_VC$L_XMT_LAST;vA                 vc -> PE_VC$L_XMT_LAST = vc -> PE_VC$L_XMT_BYTES;X]                 vc -> PE_VC$L_RCV_PERCENT = vc -> PE_VC$L_RCV_BYTES - vc -> PE_VC$L_RCV_LAST; A                 vc -> PE_VC$L_RCV_LAST = vc -> PE_VC$L_RCV_BYTES;d  ' 			/*  Compute the LAN utilization.  */   n                 vc -> PE_VC$L_LAN_UTILIZATION = (( vc -> PE_VC$L_XMT_PERCENT + vc -> PE_VC$L_RCV_PERCENT ) * 8C                   * 100 / total_lan_bandwidth ) / pe_update_number;W^                 vc -> PE_VC$L_XMT_PERCENT = 100 * vc -> PE_VC$L_XMT_PERCENT / lan_utilization;^                 vc -> PE_VC$L_RCV_PERCENT = 100 * vc -> PE_VC$L_RCV_PERCENT / lan_utilization;  " 			/*  Update the error rates.  */  P                 if (( vc_error_rate == 0 ) && ( vc -> PE_VC$L_REXMT_RATE != 0 ))J                   vc -> PE_VC$L_REXMT_RATE = vc -> PE_VC$L_REXMT_RATE - 1;P                 if (( vc_error_rate == 0 ) && ( vc -> PE_VC$L_RERCV_RATE != 0 ))J                   vc -> PE_VC$L_RERCV_RATE = vc -> PE_VC$L_RERCV_RATE - 1;  - 			/*  Compute the retransmit error rate.  */e  _                 vc -> PE_VC$L_REXMT_LAST = vc -> PE_VC$L_REXMT_MSGS - vc -> PE_VC$L_REXMT_LAST;)4                 if ( vc -> PE_VC$L_PIPE_QUOTA == 0 )a                   vc -> PE_VC$L_REXMT_RATE = vc -> PE_VC$L_REXMT_RATE + vc -> PE_VC$L_REXMT_LAST;W                 else                   vc -> PE_VC$L_REXMT_RATE = vc -> PE_VC$L_REXMT_RATE + ( vc -> PE_VC$L_REXMT_LAST / vc -> PE_VC$L_PIPE_QUOTA );D                 vc -> PE_VC$L_REXMT_LAST = vc -> PE_VC$L_REXMT_MSGS;  - 			/*  Compute the re-receive error rate.  */   _                 vc -> PE_VC$L_RERCV_LAST = vc -> PE_VC$L_RERCV_MSGS - vc -> PE_VC$L_RERCV_LAST;e4                 if ( vc -> PE_VC$L_PIPE_QUOTA == 0 )a                   vc -> PE_VC$L_RERCV_RATE = vc -> PE_VC$L_RERCV_RATE + vc -> PE_VC$L_RERCV_LAST;	                 else                   vc -> PE_VC$L_RERCV_RATE = vc -> PE_VC$L_RERCV_RATE + ( vc -> PE_VC$L_RERCV_LAST / vc -> PE_VC$L_PIPE_QUOTA );6 		vc -> PE_VC$L_RERCV_LAST = vc -> PE_VC$L_RERCV_MSGS;  % 			/*  Compute the VC hash index.  */e  >                 if (( vc -> PE_VC$L_FLAGS & VC$M_OPEN ) != 0 )U                   hash_index = vc -> PE_VC$L_XMT_PERCENT + vc -> PE_VC$L_RCV_PERCENT;s                 else>                   hash_index = vc -> PE_VC$L_CLOSED_COUNT / 6;'                 if ( hash_index > 100 ) #                   hash_index = 100;s  V 			/*  Highlight the error rates if they exceed the error threshold of 2 per hour.  */  2                 vc -> PE_VC$L_HIGHLIGHT_REXMT = 0;2                 vc -> PE_VC$L_HIGHLIGHT_RERCV = 0;Q                 if (( vc -> PE_VC$L_REXMT_RATE + vc -> PE_VC$L_RERCV_RATE ) > 2 )                    {r%                     hash_index = 100; 8                     if ( vc -> PE_VC$L_REXMT_RATE != 0 )8                       vc -> PE_VC$L_HIGHLIGHT_REXMT = 1;8                     if ( vc -> PE_VC$L_RERCV_RATE != 0 )8                       vc -> PE_VC$L_HIGHLIGHT_RERCV = 1;                   })  = 			/*  Place this virtual circuit into the display array.  */.  P                 vc -> PE_VC$A_VC_DISPLAY_LINK = vc_display_array [ hash_index ];5                 vc_display_array [ hash_index ] = vc;e                 }(             else               {,.                 vc -> PE_VC$L_XMT_PERCENT = 0;A                 vc -> PE_VC$L_XMT_LAST = vc -> PE_VC$L_XMT_BYTES; .                 vc -> PE_VC$L_RCV_PERCENT = 0;A                 vc -> PE_VC$L_RCV_LAST = vc -> PE_VC$L_RCV_BYTES;x2                 vc -> PE_VC$L_LAN_UTILIZATION = 0;-                 vc -> PE_VC$L_REXMT_RATE = 0;iD                 vc -> PE_VC$L_REXMT_LAST = vc -> PE_VC$L_REXMT_MSGS;$ 		vc -> PE_VC$L_HIGHLIGHT_REXMT = 0;-                 vc -> PE_VC$L_RERCV_RATE = 0;i6 		vc -> PE_VC$L_RERCV_LAST = vc -> PE_VC$L_RERCV_MSGS;$ 		vc -> PE_VC$L_HIGHLIGHT_RERCV = 0;  O 			    /*  This will display closed virtual circuits for up to two minutes.  */o  G                 vc -> PE_VC$L_CLOSED_COUNT = 60 * 2 / pe_update_number;*               }            }C       }S   /*&  * Display the BUS utilization header.  */u        x_pos = Bnr.font_height / 2;     x = x_pos;     y = Bnr.font_height;  M     XSetForeground ( XtDisplay ( Bnr.pe_widget ), BannerGC, Bnr.foreground ); N     BannerWriteText ( XtDisplay ( Bnr.pe_widget ), XtWindow ( Bnr.pe_widget ),9       x, y, "LAN Adapter Utilization", 2, Bnr.pe_width );)       y = y + Bnr.font_height;     bus_error_pos = x;N     BannerWriteText ( XtDisplay ( Bnr.pe_widget ), XtWindow ( Bnr.pe_widget ),7       bus_error_pos, y, "Errors", 2, bus_error_width );p  "     x = x + bus_error_width + w2w;     bus_name_pos = x;vN     BannerWriteText ( XtDisplay ( Bnr.pe_widget ), XtWindow ( Bnr.pe_widget ),3       bus_name_pos, y, "Name", 1, bus_name_width );x  !     x = x + bus_name_width + w2w;t     bus_percent_pos = x;N     BannerWriteText ( XtDisplay ( Bnr.pe_widget ), XtWindow ( Bnr.pe_widget ),=       bus_percent_pos, y, "% of LAN", 1, bus_percent_width );]  $     x = x + bus_percent_width + w2w;     bus_graph_pos = x;     bus_graph_width = 0;A     if (( bus_graph_pos + bus_graph_min_width ) <= Bnr.pe_width )t       { +         bus_graph_width = Bnr.pe_width - x;CR         BannerWriteText ( XtDisplay ( Bnr.pe_widget ), XtWindow ( Bnr.pe_widget ),8           bus_graph_pos, y, "0", 1, bus_graph_0_width );"         x = x + bus_graph_0_width;O         x1 = ( bus_graph_width - bus_graph_0_width - bus_graph_100_width ) / 2;,R         BannerWriteText ( XtDisplay ( Bnr.pe_widget ), XtWindow ( Bnr.pe_widget ),           x, y, "Tx", 2, x1 );         x = x + x1;iL         XSetForeground ( XtDisplay ( Bnr.pe_widget ), BannerGC, Bnr.hwmrk );R         BannerWriteText ( XtDisplay ( Bnr.pe_widget ), XtWindow ( Bnr.pe_widget ),           x, y, "Rx", 2, x1 );Q         XSetForeground ( XtDisplay ( Bnr.pe_widget ), BannerGC, Bnr.foreground );H/         x = Bnr.pe_width - bus_graph_100_width;uR         BannerWriteText ( XtDisplay ( Bnr.pe_widget ), XtWindow ( Bnr.pe_widget ),0           x, y, "100", 1, bus_graph_100_width );       }    /*  * Display the BUS utilization._  */N       y = y + Bnr.font_height;H     for ( bus_index = 0; bus_index < PE_BUS$C_DISPLAY_BUS; bus_index++ )       {S(         bus = & BUS_ARRAY [ bus_index ];a         if (( bus -> PE_BUS$T_NAME [ 0 ] != 0 ) && (( bus -> PE_BUS$L_FLAGS & BUS$M_LDL ) == 0 ))P           {A  ( 				/*  Display the BUS error count.  */  A             sprintf ( string, "%d", bus -> PE_BUS$L_XMT_ERRORS );U8             if ( bus -> PE_BUS$L_HIGHLIGHT_ERRORS != 0 )R               XSetForeground ( XtDisplay ( Bnr.pe_widget ), BannerGC, Bnr.hwmrk );V             BannerWriteText ( XtDisplay ( Bnr.pe_widget ), XtWindow ( Bnr.pe_widget ),=               bus_error_pos, y, string, 3, bus_error_width ); 8             if ( bus -> PE_BUS$L_HIGHLIGHT_ERRORS != 0 )W               XSetForeground ( XtDisplay ( Bnr.pe_widget ), BannerGC, Bnr.foreground );   ! 				/*  Display the BUS name.  */u  5             if ( bus -> PE_BUS$L_HIGHLIGHT_BUS != 0 )eR               XSetForeground ( XtDisplay ( Bnr.pe_widget ), BannerGC, Bnr.hwmrk );V             BannerWriteText ( XtDisplay ( Bnr.pe_widget ), XtWindow ( Bnr.pe_widget ),P               bus_name_pos, y, &bus -> PE_BUS$T_NAME [ 1 ], 1, bus_name_width );5             if ( bus -> PE_BUS$L_HIGHLIGHT_BUS != 0 )bW               XSetForeground ( XtDisplay ( Bnr.pe_widget ), BannerGC, Bnr.foreground );e  ( 				/*  Display the LAN utilization.  */  F             sprintf ( string, "%d", bus -> PE_BUS$L_LAN_UTILIZATION );V             BannerWriteText ( XtDisplay ( Bnr.pe_widget ), XtWindow ( Bnr.pe_widget ),A               bus_percent_pos, y, string, 3, bus_percent_width );   - 				/*  Display the transmit utilization.  */i  &             if ( bus_graph_width > 0 )               {A]                 x1 = bus_graph_pos + ( bus_graph_width * bus -> PE_BUS$L_XMT_PERCENT / 100 ); (                 if ( x1 > Bnr.pe_width )$                   x1 = Bnr.pe_width;-                 y1 = y - Bnr.font_height + 3; 0                 if (( x1 - bus_graph_pos ) > 0 )                   XFillRectangle ( XtDisplay ( Bnr.pe_widget ), XtWindow ( Bnr.pe_widget ), BannerGC, bus_graph_pos, y1, x1, y );   , 				/*  Display the receive utilization.  */                   x = x1;IQ                 x1 = x + ( bus_graph_width * bus -> PE_BUS$L_RCV_PERCENT / 100 );Z(                 if ( x1 > Bnr.pe_width )$                   x1 = Bnr.pe_width;$                 if (( x1 - x ) > 0 )                   { X                     XSetForeground ( XtDisplay ( Bnr.pe_widget ), BannerGC, Bnr.hwmrk );w                     XFillRectangle ( XtDisplay ( Bnr.pe_widget ), XtWindow ( Bnr.pe_widget ), BannerGC, x, y1, x1, y );                    }   ' 				/*  Clear the rest of the line.  */                    x = x1;V"                 x1 = Bnr.pe_width;%                 if (( x1 - x ) >= 0 )r                   {d]                     XSetForeground ( XtDisplay ( Bnr.pe_widget ), BannerGC, Bnr.background );yw                     XFillRectangle ( XtDisplay ( Bnr.pe_widget ), XtWindow ( Bnr.pe_widget ), BannerGC, x, y1, x1, y );r                   }eY                 XSetForeground ( XtDisplay ( Bnr.pe_widget ), BannerGC, Bnr.foreground );                }d   				/*  Set the next line.  */               x = x_pos;$             y = y + Bnr.font_height;             }        }>  < 			/*  Clear the line after the BUS utilization display.  */       y1 = y - Bnr.font_height; M     XSetForeground ( XtDisplay ( Bnr.pe_widget ), BannerGC, Bnr.background ); q     XFillRectangle ( XtDisplay ( Bnr.pe_widget ), XtWindow ( Bnr.pe_widget ), BannerGC, 0, y1, Bnr.pe_width, y ); M     XSetForeground ( XtDisplay ( Bnr.pe_widget ), BannerGC, Bnr.foreground );    /*2  * Display the Virtual Circuit utilization header.  */E       x = x_pos;     y = y + Bnr.font_height;M     XSetForeground ( XtDisplay ( Bnr.pe_widget ), BannerGC, Bnr.foreground );=N     BannerWriteText ( XtDisplay ( Bnr.pe_widget ), XtWindow ( Bnr.pe_widget ),=       x, y, "Virtual Circuit Utilization", 2, Bnr.pe_width );        y = y + Bnr.font_height;     vc_rexmt_pos = x; N     BannerWriteText ( XtDisplay ( Bnr.pe_widget ), XtWindow ( Bnr.pe_widget ),4       vc_rexmt_pos, y, "ReXmt", 2, vc_rexmt_width );  !     x = x + vc_rexmt_width + w2w;      vc_rercv_pos = x;-N     BannerWriteText ( XtDisplay ( Bnr.pe_widget ), XtWindow ( Bnr.pe_widget ),4       vc_rercv_pos, y, "ReRcv", 2, vc_rercv_width );  !     x = x + vc_rercv_width + w2w;T     vc_name_pos = x;N     BannerWriteText ( XtDisplay ( Bnr.pe_widget ), XtWindow ( Bnr.pe_widget ),5       vc_name_pos, y, "SCS Node", 1, vc_name_width );         x = x + vc_name_width + w2w;     vc_percent_pos = x;NN     BannerWriteText ( XtDisplay ( Bnr.pe_widget ), XtWindow ( Bnr.pe_widget ),;       vc_percent_pos, y, "% of LAN", 1, vc_percent_width );o  #     x = x + vc_percent_width + w2w;c     vc_graph_pos = x;      vc_graph_width = 0;!?     if (( vc_graph_pos + vc_graph_min_width ) <= Bnr.pe_width )L       {T*         vc_graph_width = Bnr.pe_width - x;R         BannerWriteText ( XtDisplay ( Bnr.pe_widget ), XtWindow ( Bnr.pe_widget ),6           vc_graph_pos, y, "0", 1, vc_graph_0_width );!         x = x + vc_graph_0_width; L         x1 = ( vc_graph_width - vc_graph_0_width - vc_graph_100_width ) / 2;R         BannerWriteText ( XtDisplay ( Bnr.pe_widget ), XtWindow ( Bnr.pe_widget ),           x, y, "Tx", 2, x1 );         x = x + x1;RL         XSetForeground ( XtDisplay ( Bnr.pe_widget ), BannerGC, Bnr.hwmrk );R         BannerWriteText ( XtDisplay ( Bnr.pe_widget ), XtWindow ( Bnr.pe_widget ),           x, y, "Rx", 2, x1 );Q         XSetForeground ( XtDisplay ( Bnr.pe_widget ), BannerGC, Bnr.foreground );r.         x = Bnr.pe_width - vc_graph_100_width;R         BannerWriteText ( XtDisplay ( Bnr.pe_widget ), XtWindow ( Bnr.pe_widget ),/           x, y, "100", 1, vc_graph_100_width );        }    /*+  * Display the Virtual Circuit utilization.R  */T       y = y + Bnr.font_height;9     y_max = y + ( Bnr.font_height * PE_VC$C_DISPLAY_VC );_     vcs_displayed = 0;4     for ( vc_index = 100; vc_index > 0; vc_index-- )       { 1         if ( vcs_displayed < PE_VC$C_DISPLAY_VC )V           {//             vc = vc_display_array [ vc_index ];              while ( vc != 0 )                {)9                 if ( vcs_displayed < PE_VC$C_DISPLAY_VC )+                   {R6                     vcs_displayed = vcs_displayed + 1;  / 				/*  Display the retransmit error count.  */   G                     sprintf ( string, "%d", vc -> PE_VC$L_REXMT_MSGS );H=                     if ( vc -> PE_VC$L_HIGHLIGHT_REXMT != 0 )2Z                       XSetForeground ( XtDisplay ( Bnr.pe_widget ), BannerGC, Bnr.hwmrk );^                     BannerWriteText ( XtDisplay ( Bnr.pe_widget ), XtWindow ( Bnr.pe_widget ),C                       vc_rexmt_pos, y, string, 3, vc_rexmt_width );x=                     if ( vc -> PE_VC$L_HIGHLIGHT_REXMT != 0 )0_                       XSetForeground ( XtDisplay ( Bnr.pe_widget ), BannerGC, Bnr.foreground );C  / 				/*  Display the re-receive error count.  */E  G                     sprintf ( string, "%d", vc -> PE_VC$L_RERCV_MSGS );a=                     if ( vc -> PE_VC$L_HIGHLIGHT_RERCV != 0 ) Z                       XSetForeground ( XtDisplay ( Bnr.pe_widget ), BannerGC, Bnr.hwmrk );^                     BannerWriteText ( XtDisplay ( Bnr.pe_widget ), XtWindow ( Bnr.pe_widget ),C                       vc_rercv_pos, y, string, 3, vc_rercv_width );T=                     if ( vc -> PE_VC$L_HIGHLIGHT_RERCV != 0 )__                       XSetForeground ( XtDisplay ( Bnr.pe_widget ), BannerGC, Bnr.foreground );   & 				/*  Display the SCS node name.  */  :                     if ( vc -> PE_VC$L_HIGHLIGHT_VC != 0 )Z                       XSetForeground ( XtDisplay ( Bnr.pe_widget ), BannerGC, Bnr.hwmrk );^                     BannerWriteText ( XtDisplay ( Bnr.pe_widget ), XtWindow ( Bnr.pe_widget ),X                       vc_name_pos, y, &vc -> PE_VC$T_NODENAME [ 1 ], 1, vc_name_width );:                     if ( vc -> PE_VC$L_HIGHLIGHT_VC != 0 )_                       XSetForeground ( XtDisplay ( Bnr.pe_widget ), BannerGC, Bnr.foreground );*  ( 				/*  Display the LAN utilization.  */  L                     sprintf ( string, "%d", vc -> PE_VC$L_LAN_UTILIZATION );^                     BannerWriteText ( XtDisplay ( Bnr.pe_widget ), XtWindow ( Bnr.pe_widget ),G                       vc_percent_pos, y, string, 3, vc_percent_width );   - 				/*  Display the transmit utilization.  */)  -                     if ( vc_graph_width > 0 )_                       {Ta                         x1 = vc_graph_pos + ( vc_graph_width * vc -> PE_VC$L_XMT_PERCENT / 100 );,0                         if ( x1 > Bnr.pe_width ),                           x1 = Bnr.pe_width;5                         y1 = y - Bnr.font_height + 3;e7                         if (( x1 - vc_graph_pos ) > 0 )d                           XFillRectangle ( XtDisplay ( Bnr.pe_widget ), XtWindow ( Bnr.pe_widget ), BannerGC, vc_graph_pos, y1, x1, y );  , 				/*  Display the receive utilization.  */                           x = x1; V                         x1 = x + ( vc_graph_width * vc -> PE_VC$L_RCV_PERCENT / 100 );0                         if ( x1 > Bnr.pe_width ),                           x1 = Bnr.pe_width;,                         if (( x1 - x ) > 0 )                           { `                             XSetForeground ( XtDisplay ( Bnr.pe_widget ), BannerGC, Bnr.hwmrk );                             XFillRectangle ( XtDisplay ( Bnr.pe_widget ), XtWindow ( Bnr.pe_widget ), BannerGC, x, y1, x1, y );T                           }e  ' 				/*  Clear the rest of the line.  */                            x = x1; *                         x1 = Bnr.pe_width;-                         if (( x1 - x ) >= 0 )                            { e                             XSetForeground ( XtDisplay ( Bnr.pe_widget ), BannerGC, Bnr.background );(                             XFillRectangle ( XtDisplay ( Bnr.pe_widget ), XtWindow ( Bnr.pe_widget ), BannerGC, x, y1, x1, y );T                           }ea                         XSetForeground ( XtDisplay ( Bnr.pe_widget ), BannerGC, Bnr.foreground );                        }a   				/*  Set the next line.  */                       x = x_pos;,                     y = y + Bnr.font_height;                     }   * 			/*  Locate the next VC for display.  */  3                 vc = vc -> PE_VC$A_VC_DISPLAY_LINK;$                 }            }        }A  E 			/*  Clear the rest of the virtual circuit utilization display.  */i       if ( y < y_max )       {O!         y1 = y - Bnr.font_height;BQ         XSetForeground ( XtDisplay ( Bnr.pe_widget ), BannerGC, Bnr.background );gy         XFillRectangle ( XtDisplay ( Bnr.pe_widget ), XtWindow ( Bnr.pe_widget ), BannerGC, 0, y1, Bnr.pe_width, y_max ); Q         XSetForeground ( XtDisplay ( Bnr.pe_widget ), BannerGC, Bnr.foreground );E       }G   /*  * First Lock's   */    /*  )     x_pos = tw + ( Bnr.font_height / 2 ); 3     lx_pos = x_pos + w5w + ( Bnr.font_height / 2 );U      y_pos = y + Bnr.font_height;   	{$ 	rate = new_pes.vc_cnt - pes.vc_cnt; 	if (rate != pem.vc_cnt_rate)l 	    { 	    pem.vc_cnt_rate = rate;# 	    sprintf (string, "%d", rate);   	    if (rate == 0)d- 		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget),  		    x_pos, y_pos, "     ", 3,  		    w5w);  	    else 	    B- 		BannerWriteText (XtDisplay(Bnr.pe_widget), o 		    XtWindow(Bnr.pe_widget), 		    x_pos, y_pos, string, 3, ) 		    w5w);  	    }" 	if (new_pes.vc_cnt != pem.vc_cnt) 	    {! 	    pem.vc_cnt = new_pes.vc_cnt;_( 	    sprintf (string, "%d", pem.vc_cnt);0 	    BannerWriteText (XtDisplay(Bnr.pe_widget),  		XtWindow(Bnr.pe_widget), 		lx_pos, y_pos, string, 3,  		w8w);r 	    }! 	y_pos = y_pos + Bnr.font_height;m 	} 	{6 	rate = new_pes.ret_id_attempts - pes.ret_id_attempts;& 	if (rate != pem.ret_id_attempts_rate) 	    {% 	    pem.ret_id_attempts_rate = rate;S# 	    sprintf (string, "%d", rate);   	    if (rate == 0)w- 		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget),  		    x_pos, y_pos, "     ", 3,  		    w5w);a 	    else 	     - 		BannerWriteText (XtDisplay(Bnr.pe_widget), r 		    XtWindow(Bnr.pe_widget), 		    x_pos, y_pos, string, 3, , 		    w5w);  	    }4 	if (new_pes.ret_id_attempts != pem.ret_id_attempts) 	    {3 	    pem.ret_id_attempts = new_pes.ret_id_attempts;b1 	    sprintf (string, "%d", pem.ret_id_attempts); 0 	    BannerWriteText (XtDisplay(Bnr.pe_widget),  		XtWindow(Bnr.pe_widget), 		lx_pos, y_pos, string, 3,  		w8w);  	    }! 	y_pos = y_pos + Bnr.font_height;( 	} 	{0 	rate = new_pes.ret_ids_sent - pes.ret_ids_sent;# 	if (rate != pem.ret_ids_sent_rate)s 	    {" 	    pem.ret_ids_sent_rate = rate;# 	    sprintf (string, "%d", rate);   	    if (rate == 0) - 		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget),  		    x_pos, y_pos, "     ", 3,  		    w5w);  	    else 	     - 		BannerWriteText (XtDisplay(Bnr.pe_widget), o 		    XtWindow(Bnr.pe_widget), 		    x_pos, y_pos, string, 3, ) 		    w5w);  	    }. 	if (new_pes.ret_ids_sent != pem.ret_ids_sent) 	    {- 	    pem.ret_ids_sent = new_pes.ret_ids_sent; . 	    sprintf (string, "%d", pem.ret_ids_sent);0 	    BannerWriteText (XtDisplay(Bnr.pe_widget),  		XtWindow(Bnr.pe_widget), 		lx_pos, y_pos, string, 3,  		w8w);  	    }! 	y_pos = y_pos + Bnr.font_height;  	} 	{, 	rate = new_pes.xmt_bytes/4 - pem.xmt_bytes;  	if (rate != pem.xmt_bytes_rate) 	    { 	    pem.xmt_bytes_rate = rate;f# 	    sprintf (string, "%d", rate); D 	    if (rate == 0)t- 		BannerWriteText (XtDisplay(Bnr.pe_widget), a 		    XtWindow(Bnr.pe_widget),  		    x_pos, y_pos, "     ", 3,  		    w5w);, 	    else 	    )- 		BannerWriteText (XtDisplay(Bnr.pe_widget), g 		    XtWindow(Bnr.pe_widget), 		    x_pos, y_pos, string, 3, C 		    w5w);a 	    }* 	if (new_pes.xmt_bytes/4 != pem.xmt_bytes) 	    {) 	    pem.xmt_bytes = new_pes.xmt_bytes/4;r+ 	    sprintf (string, "%d", pem.xmt_bytes); 0 	    BannerWriteText (XtDisplay(Bnr.pe_widget),  		XtWindow(Bnr.pe_widget), 		lx_pos, y_pos, string, 3,  		w8w);n 	    }! 	y_pos = y_pos + Bnr.font_height;o 	} 	{& 	rate = new_pes.xmt_msg - pes.xmt_msg; 	if (rate != pem.xmt_msg_rate) 	    { 	    pem.xmt_msg_rate = rate; # 	    sprintf (string, "%d", rate); m 	    if (rate == 0) - 		BannerWriteText (XtDisplay(Bnr.pe_widget), x 		    XtWindow(Bnr.pe_widget),  		    x_pos, y_pos, "     ", 3,  		    w5w);  	    else 	    v- 		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget), 		    x_pos, y_pos, string, 3, t 		    w5w);p 	    }$ 	if (new_pes.xmt_msg != pem.xmt_msg) 	    {# 	    pem.xmt_msg = new_pes.xmt_msg;_) 	    sprintf (string, "%d", pem.xmt_msg); 0 	    BannerWriteText (XtDisplay(Bnr.pe_widget),  		XtWindow(Bnr.pe_widget), 		lx_pos, y_pos, string, 3,  		w8w);  	    }! 	y_pos = y_pos + Bnr.font_height;e 	} 	{* 	rate = new_pes.xmt_unseq - pes.xmt_unseq;  	if (rate != pem.xmt_unseq_rate) 	    { 	    pem.xmt_unseq_rate = rate;+# 	    sprintf (string, "%d", rate);   	    if (rate == 0) - 		BannerWriteText (XtDisplay(Bnr.pe_widget), n 		    XtWindow(Bnr.pe_widget),  		    x_pos, y_pos, "     ", 3,  		    w5w);  	    else 	    ,- 		BannerWriteText (XtDisplay(Bnr.pe_widget), c 		    XtWindow(Bnr.pe_widget), 		    x_pos, y_pos, string, 3, h 		    w5w);0 	    }( 	if (new_pes.xmt_unseq != pem.xmt_unseq) 	    {' 	    pem.xmt_unseq = new_pes.xmt_unseq; + 	    sprintf (string, "%d", pem.xmt_unseq); 0 	    BannerWriteText (XtDisplay(Bnr.pe_widget),  		XtWindow(Bnr.pe_widget), 		lx_pos, y_pos, string, 3,  		w8w);p 	    }! 	y_pos = y_pos + Bnr.font_height;d 	} 	{& 	rate = new_pes.xmt_seq - pes.xmt_seq; 	if (rate != pem.xmt_seq_rate) 	    { 	    pem.xmt_seq_rate = rate;)# 	    sprintf (string, "%d", rate); p 	    if (rate == 0) - 		BannerWriteText (XtDisplay(Bnr.pe_widget), X 		    XtWindow(Bnr.pe_widget),  		    x_pos, y_pos, "     ", 3,  		    w5w);  	    else 	    D- 		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget), 		    x_pos, y_pos, string, 3,   		    w5w);P 	    }$ 	if (new_pes.xmt_seq != pem.xmt_seq) 	    {# 	    pem.xmt_seq = new_pes.xmt_seq; ) 	    sprintf (string, "%d", pem.xmt_seq);C0 	    BannerWriteText (XtDisplay(Bnr.pe_widget),  		XtWindow(Bnr.pe_widget), 		lx_pos, y_pos, string, 3,  		w8w);  	    }! 	y_pos = y_pos + Bnr.font_height;y 	} 	{& 	rate = new_pes.xmt_ack - pes.xmt_ack; 	if (rate != pem.xmt_ack_rate) 	    { 	    pem.xmt_ack_rate = rate;p# 	    sprintf (string, "%d", rate);   	    if (rate == 0) - 		BannerWriteText (XtDisplay(Bnr.pe_widget), S 		    XtWindow(Bnr.pe_widget),  		    x_pos, y_pos, "     ", 3,  		    w5w);  	    else 	    o- 		BannerWriteText (XtDisplay(Bnr.pe_widget), C 		    XtWindow(Bnr.pe_widget), 		    x_pos, y_pos, string, 3,   		    w5w);  	    }$ 	if (new_pes.xmt_ack != pem.xmt_ack) 	    {# 	    pem.xmt_ack = new_pes.xmt_ack;w) 	    sprintf (string, "%d", pem.xmt_ack);_0 	    BannerWriteText (XtDisplay(Bnr.pe_widget),  		XtWindow(Bnr.pe_widget), 		lx_pos, y_pos, string, 3,  		w8w);r 	    }! 	y_pos = y_pos + Bnr.font_height;e 	} 	{* 	rate = new_pes.xmt_rexmt - pes.xmt_rexmt;  	if (rate != pem.xmt_rexmt_rate) 	    { 	    pem.xmt_rexmt_rate = rate;_# 	    sprintf (string, "%d", rate);   	    if (rate == 0)e- 		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget),  		    x_pos, y_pos, "     ", 3,  		    w5w);, 	    else 	    e- 		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget), 		    x_pos, y_pos, string, 3, P 		    w5w);G 	    }( 	if (new_pes.xmt_rexmt != pem.xmt_rexmt) 	    {' 	    pem.xmt_rexmt = new_pes.xmt_rexmt;.+ 	    sprintf (string, "%d", pem.xmt_rexmt);e0 	    BannerWriteText (XtDisplay(Bnr.pe_widget),  		XtWindow(Bnr.pe_widget), 		lx_pos, y_pos, string, 3,  		w8w);s 	    }! 	y_pos = y_pos + Bnr.font_height;  	} 	{, 	rate = new_pes.rcv_bytes/4 - pem.rcv_bytes;  	if (rate != pem.rcv_bytes_rate) 	    { 	    pem.rcv_bytes_rate = rate;_# 	    sprintf (string, "%d", rate); , 	    if (rate == 0) - 		BannerWriteText (XtDisplay(Bnr.pe_widget), T 		    XtWindow(Bnr.pe_widget),  		    x_pos, y_pos, "     ", 3,  		    w5w);  	    else 	    e- 		BannerWriteText (XtDisplay(Bnr.pe_widget), o 		    XtWindow(Bnr.pe_widget), 		    x_pos, y_pos, string, 3, $ 		    w5w);T 	    }* 	if (new_pes.rcv_bytes/4 != pem.rcv_bytes) 	    {) 	    pem.rcv_bytes = new_pes.rcv_bytes/4; + 	    sprintf (string, "%d", pem.rcv_bytes);n0 	    BannerWriteText (XtDisplay(Bnr.pe_widget),  		XtWindow(Bnr.pe_widget), 		lx_pos, y_pos, string, 3,  		w8w);t 	    }! 	y_pos = y_pos + Bnr.font_height;  	} 	{& 	rate = new_pes.rcv_msg - pes.rcv_msg; 	if (rate != pem.rcv_msg_rate) 	    { 	    pem.rcv_msg_rate = rate;(# 	    sprintf (string, "%d", rate);   	    if (rate == 0)_- 		BannerWriteText (XtDisplay(Bnr.pe_widget), n 		    XtWindow(Bnr.pe_widget),  		    x_pos, y_pos, "     ", 3,  		    w5w);  	    else 	     - 		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget), 		    x_pos, y_pos, string, 3,   		    w5w);p 	    }$ 	if (new_pes.rcv_msg != pem.rcv_msg) 	    {# 	    pem.rcv_msg = new_pes.rcv_msg; ) 	    sprintf (string, "%d", pem.rcv_msg);_0 	    BannerWriteText (XtDisplay(Bnr.pe_widget),  		XtWindow(Bnr.pe_widget), 		lx_pos, y_pos, string, 3,  		w8w);  	    }! 	y_pos = y_pos + Bnr.font_height;) 	} 	{* 	rate = new_pes.rcv_unseq - pes.rcv_unseq;  	if (rate != pem.rcv_unseq_rate) 	    { 	    pem.rcv_unseq_rate = rate;;# 	    sprintf (string, "%d", rate); c 	    if (rate == 0)B- 		BannerWriteText (XtDisplay(Bnr.pe_widget), n 		    XtWindow(Bnr.pe_widget),  		    x_pos, y_pos, "     ", 3,  		    w5w);o 	    else 	     - 		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget), 		    x_pos, y_pos, string, 3, - 		    w5w);  	    }( 	if (new_pes.rcv_unseq != pem.rcv_unseq) 	    {' 	    pem.rcv_unseq = new_pes.rcv_unseq;t+ 	    sprintf (string, "%d", pem.rcv_unseq); 0 	    BannerWriteText (XtDisplay(Bnr.pe_widget),  		XtWindow(Bnr.pe_widget), 		lx_pos, y_pos, string, 3,  		w8w);  	    }! 	y_pos = y_pos + Bnr.font_height;  	} 	{& 	rate = new_pes.rcv_seq - pes.rcv_seq; 	if (rate != pem.rcv_seq_rate) 	    { 	    pem.rcv_seq_rate = rate;*# 	    sprintf (string, "%d", rate);   	    if (rate == 0) - 		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget),  		    x_pos, y_pos, "     ", 3,  		    w5w);  	    else 	    P- 		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget), 		    x_pos, y_pos, string, 3, u 		    w5w);n 	    }$ 	if (new_pes.rcv_seq != pem.rcv_seq) 	    {# 	    pem.rcv_seq = new_pes.rcv_seq; ) 	    sprintf (string, "%d", pem.rcv_seq);t0 	    BannerWriteText (XtDisplay(Bnr.pe_widget),  		XtWindow(Bnr.pe_widget), 		lx_pos, y_pos, string, 3,  		w8w);a 	    }! 	y_pos = y_pos + Bnr.font_height;  	} 	{* 	rate = new_pes.rcv_cache - pes.rcv_cache;  	if (rate != pem.rcv_cache_rate) 	    { 	    pem.rcv_cache_rate = rate; # 	    sprintf (string, "%d", rate); 2 	    if (rate == 0)p- 		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget),  		    x_pos, y_pos, "     ", 3,  		    w5w);= 	    else 	    l- 		BannerWriteText (XtDisplay(Bnr.pe_widget), r 		    XtWindow(Bnr.pe_widget), 		    x_pos, y_pos, string, 3, T 		    w5w);y 	    }( 	if (new_pes.rcv_cache != pem.rcv_cache) 	    {' 	    pem.rcv_cache = new_pes.rcv_cache; + 	    sprintf (string, "%d", pem.rcv_cache);y0 	    BannerWriteText (XtDisplay(Bnr.pe_widget),  		XtWindow(Bnr.pe_widget), 		lx_pos, y_pos, string, 3,  		w8w);p 	    }! 	y_pos = y_pos + Bnr.font_height;v 	} 	{* 	rate = new_pes.rcv_rercv - pes.rcv_rercv;  	if (rate != pem.rcv_rercv_rate) 	    { 	    pem.rcv_rercv_rate = rate;w# 	    sprintf (string, "%d", rate); r 	    if (rate == 0) - 		BannerWriteText (XtDisplay(Bnr.pe_widget), { 		    XtWindow(Bnr.pe_widget),  		    x_pos, y_pos, "     ", 3,  		    w5w);i 	    else 	     - 		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget), 		    x_pos, y_pos, string, 3, n 		    w5w);X 	    }( 	if (new_pes.rcv_rercv != pem.rcv_rercv) 	    {' 	    pem.rcv_rercv = new_pes.rcv_rercv; + 	    sprintf (string, "%d", pem.rcv_rercv);X0 	    BannerWriteText (XtDisplay(Bnr.pe_widget),  		XtWindow(Bnr.pe_widget), 		lx_pos, y_pos, string, 3,  		w8w);i 	    }! 	y_pos = y_pos + Bnr.font_height;t 	} 	{& 	rate = new_pes.rcv_ack - pes.rcv_ack; 	if (rate != pem.rcv_ack_rate) 	    { 	    pem.rcv_ack_rate = rate; # 	    sprintf (string, "%d", rate); . 	    if (rate == 0)d- 		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget),  		    x_pos, y_pos, "     ", 3,  		    w5w);. 	    else 	    s- 		BannerWriteText (XtDisplay(Bnr.pe_widget), a 		    XtWindow(Bnr.pe_widget), 		    x_pos, y_pos, string, 3, t 		    w5w);a 	    }$ 	if (new_pes.rcv_ack != pem.rcv_ack) 	    {# 	    pem.rcv_ack = new_pes.rcv_ack;w) 	    sprintf (string, "%d", pem.rcv_ack); 0 	    BannerWriteText (XtDisplay(Bnr.pe_widget),  		XtWindow(Bnr.pe_widget), 		lx_pos, y_pos, string, 3,  		w8w);, 	    }! 	y_pos = y_pos + Bnr.font_height;5 	} 	{6 	rate = new_pes.topology_change - pes.topology_change;& 	if (rate != pem.topology_change_rate) 	    {% 	    pem.topology_change_rate = rate;e# 	    sprintf (string, "%d", rate); t 	    if (rate == 0))- 		BannerWriteText (XtDisplay(Bnr.pe_widget), , 		    XtWindow(Bnr.pe_widget),  		    x_pos, y_pos, "     ", 3,  		    w5w);t 	    else 	    y- 		BannerWriteText (XtDisplay(Bnr.pe_widget), t 		    XtWindow(Bnr.pe_widget), 		    x_pos, y_pos, string, 3, ( 		    w5w);  	    }4 	if (new_pes.topology_change != pem.topology_change) 	    {3 	    pem.topology_change = new_pes.topology_change;,1 	    sprintf (string, "%d", pem.topology_change);)0 	    BannerWriteText (XtDisplay(Bnr.pe_widget),  		XtWindow(Bnr.pe_widget), 		lx_pos, y_pos, string, 3,  		w8w);	 	    }! 	y_pos = y_pos + Bnr.font_height;4 	} 	{0 	rate = new_pes.npagedyn_low - pes.npagedyn_low;# 	if (rate != pem.npagedyn_low_rate)% 	    {" 	    pem.npagedyn_low_rate = rate;# 	    sprintf (string, "%d", rate); w 	    if (rate == 0)x- 		BannerWriteText (XtDisplay(Bnr.pe_widget), p 		    XtWindow(Bnr.pe_widget),  		    x_pos, y_pos, "     ", 3,  		    w5w);  	    else 	    x- 		BannerWriteText (XtDisplay(Bnr.pe_widget), a 		    XtWindow(Bnr.pe_widget), 		    x_pos, y_pos, string, 3,   		    w5w);T 	    }. 	if (new_pes.npagedyn_low != pem.npagedyn_low) 	    {- 	    pem.npagedyn_low = new_pes.npagedyn_low; . 	    sprintf (string, "%d", pem.npagedyn_low);0 	    BannerWriteText (XtDisplay(Bnr.pe_widget),  		XtWindow(Bnr.pe_widget), 		lx_pos, y_pos, string, 3,  		w8w);p 	    }! 	y_pos = y_pos + Bnr.font_height;m 	} 	{* 	rate = new_pes.xmt_noxch - pes.xmt_noxch;  	if (rate != pem.xmt_noxch_rate) 	    { 	    pem.xmt_noxch_rate = rate;t# 	    sprintf (string, "%d", rate); o 	    if (rate == 0))- 		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget),  		    x_pos, y_pos, "     ", 3,  		    w5w);r 	    else 	     - 		BannerWriteText (XtDisplay(Bnr.pe_widget), i 		    XtWindow(Bnr.pe_widget), 		    x_pos, y_pos, string, 3, s 		    w5w);i 	    }( 	if (new_pes.xmt_noxch != pem.xmt_noxch) 	    {' 	    pem.xmt_noxch = new_pes.xmt_noxch; + 	    sprintf (string, "%d", pem.xmt_noxch);i0 	    BannerWriteText (XtDisplay(Bnr.pe_widget),  		XtWindow(Bnr.pe_widget), 		lx_pos, y_pos, string, 3,  		w8w);s 	    }! 	y_pos = y_pos + Bnr.font_height;u 	} 	{2 	rate = new_pes.tr_pipe_quota - pes.tr_pipe_quota;$ 	if (rate != pem.tr_pipe_quota_rate) 	    {# 	    pem.tr_pipe_quota_rate = rate;i# 	    sprintf (string, "%d", rate);   	    if (rate == 0)p- 		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget),  		    x_pos, y_pos, "     ", 3,  		    w5w);m 	    else 	    a- 		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget), 		    x_pos, y_pos, string, 3,   		    w5w);w 	    }0 	if (new_pes.tr_pipe_quota != pem.tr_pipe_quota) 	    {/ 	    pem.tr_pipe_quota = new_pes.tr_pipe_quota;r/ 	    sprintf (string, "%d", pem.tr_pipe_quota);	0 	    BannerWriteText (XtDisplay(Bnr.pe_widget),  		XtWindow(Bnr.pe_widget), 		lx_pos, y_pos, string, 3,  		w8w);= 	    }! 	y_pos = y_pos + Bnr.font_height;% 	} 	{0 	rate = new_pes.rcv_tr_short - pes.rcv_tr_short;# 	if (rate != pem.rcv_tr_short_rate), 	    {" 	    pem.rcv_tr_short_rate = rate;# 	    sprintf (string, "%d", rate); t 	    if (rate == 0)e- 		BannerWriteText (XtDisplay(Bnr.pe_widget), x 		    XtWindow(Bnr.pe_widget),  		    x_pos, y_pos, "     ", 3,  		    w5w);" 	    else 	    i- 		BannerWriteText (XtDisplay(Bnr.pe_widget), r 		    XtWindow(Bnr.pe_widget), 		    x_pos, y_pos, string, 3, s 		    w5w);  	    }. 	if (new_pes.rcv_tr_short != pem.rcv_tr_short) 	    {- 	    pem.rcv_tr_short = new_pes.rcv_tr_short;,. 	    sprintf (string, "%d", pem.rcv_tr_short);0 	    BannerWriteText (XtDisplay(Bnr.pe_widget),  		XtWindow(Bnr.pe_widget), 		lx_pos, y_pos, string, 3,  		w8w);% 	    }! 	y_pos = y_pos + Bnr.font_height;t 	} 	{. 	rate = new_pes.rcv_ill_ack - pes.rcv_ill_ack;" 	if (rate != pem.rcv_ill_ack_rate) 	    {! 	    pem.rcv_ill_ack_rate = rate;e# 	    sprintf (string, "%d", rate);   	    if (rate == 0)r- 		BannerWriteText (XtDisplay(Bnr.pe_widget), t 		    XtWindow(Bnr.pe_widget),  		    x_pos, y_pos, "     ", 3,  		    w5w);e 	    else 	    x- 		BannerWriteText (XtDisplay(Bnr.pe_widget), B 		    XtWindow(Bnr.pe_widget), 		    x_pos, y_pos, string, 3,   		    w5w);e 	    }, 	if (new_pes.rcv_ill_ack != pem.rcv_ill_ack) 	    {+ 	    pem.rcv_ill_ack = new_pes.rcv_ill_ack;g- 	    sprintf (string, "%d", pem.rcv_ill_ack);r0 	    BannerWriteText (XtDisplay(Bnr.pe_widget),  		XtWindow(Bnr.pe_widget), 		lx_pos, y_pos, string, 3,  		w8w);e 	    }! 	y_pos = y_pos + Bnr.font_height;d 	} 	{. 	rate = new_pes.rcv_ill_seq - pes.rcv_ill_seq;" 	if (rate != pem.rcv_ill_seq_rate) 	    {! 	    pem.rcv_ill_seq_rate = rate; # 	    sprintf (string, "%d", rate);   	    if (rate == 0)b- 		BannerWriteText (XtDisplay(Bnr.pe_widget), a 		    XtWindow(Bnr.pe_widget),  		    x_pos, y_pos, "     ", 3,  		    w5w);T 	    else 	    r- 		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget), 		    x_pos, y_pos, string, 3,   		    w5w);T 	    }, 	if (new_pes.rcv_ill_seq != pem.rcv_ill_seq) 	    {+ 	    pem.rcv_ill_seq = new_pes.rcv_ill_seq;5- 	    sprintf (string, "%d", pem.rcv_ill_seq);c0 	    BannerWriteText (XtDisplay(Bnr.pe_widget),  		XtWindow(Bnr.pe_widget), 		lx_pos, y_pos, string, 3,  		w8w);e 	    }! 	y_pos = y_pos + Bnr.font_height;t 	} 	{2 	rate = new_pes.rcv_bad_cksum - pes.rcv_bad_cksum;$ 	if (rate != pem.rcv_bad_cksum_rate) 	    {# 	    pem.rcv_bad_cksum_rate = rate;e# 	    sprintf (string, "%d", rate); r 	    if (rate == 0)m- 		BannerWriteText (XtDisplay(Bnr.pe_widget), % 		    XtWindow(Bnr.pe_widget),  		    x_pos, y_pos, "     ", 3,  		    w5w);, 	    else 	    w- 		BannerWriteText (XtDisplay(Bnr.pe_widget), 3 		    XtWindow(Bnr.pe_widget), 		    x_pos, y_pos, string, 3, B 		    w5w);, 	    }0 	if (new_pes.rcv_bad_cksum != pem.rcv_bad_cksum) 	    {/ 	    pem.rcv_bad_cksum = new_pes.rcv_bad_cksum; / 	    sprintf (string, "%d", pem.rcv_bad_cksum);r0 	    BannerWriteText (XtDisplay(Bnr.pe_widget),  		XtWindow(Bnr.pe_widget), 		lx_pos, y_pos, string, 3,  		w8w);r 	    }! 	y_pos = y_pos + Bnr.font_height;  	} 	{. 	rate = new_pes.xmt_seq_tmo - pes.xmt_seq_tmo;" 	if (rate != pem.xmt_seq_tmo_rate) 	    {! 	    pem.xmt_seq_tmo_rate = rate;t# 	    sprintf (string, "%d", rate);   	    if (rate == 0)(- 		BannerWriteText (XtDisplay(Bnr.pe_widget), 	 		    XtWindow(Bnr.pe_widget),  		    x_pos, y_pos, "     ", 3,  		    w5w);	 	    else 	     - 		BannerWriteText (XtDisplay(Bnr.pe_widget), 	 		    XtWindow(Bnr.pe_widget), 		    x_pos, y_pos, string, 3, p 		    w5w);	 	    }, 	if (new_pes.xmt_seq_tmo != pem.xmt_seq_tmo) 	    {+ 	    pem.xmt_seq_tmo = new_pes.xmt_seq_tmo; - 	    sprintf (string, "%d", pem.xmt_seq_tmo);n0 	    BannerWriteText (XtDisplay(Bnr.pe_widget),  		XtWindow(Bnr.pe_widget), 		lx_pos, y_pos, string, 3,  		w8w);x 	    }! 	y_pos = y_pos + Bnr.font_height;  	} 	{ 	rate = (new_pes.tr_dfq_empty +{ 	        new_pes.tr_mfq_empty +c 	        new_pes.cc_dfq_empty +r  	        new_pes.cc_mfq_empty) - 	       (pes.tr_dfq_empty +i 	        pes.tr_mfq_empty +r 	        pes.cc_dfq_empty +  	        pes.cc_mfq_empty);  	if (rate != pem.fq_empty_rate)	 	    { 	    pem.fq_empty_rate = rate;# 	    sprintf (string, "%d", rate); T 	    if (rate == 0)_- 		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget),  		    x_pos, y_pos, "     ", 3,  		    w5w);. 	    else 	     - 		BannerWriteText (XtDisplay(Bnr.pe_widget), n 		    XtWindow(Bnr.pe_widget), 		    x_pos, y_pos, string, 3, ( 		    w5w);) 	    } 	if ((new_pes.tr_dfq_empty + 	    new_pes.tr_mfq_empty +) 	    new_pes.cc_dfq_empty +B+ 	    new_pes.cc_mfq_empty) != pem.fq_empty)_ 	    {* 	    pem.fq_empty = new_pes.tr_dfq_empty +  	    		   new_pes.tr_mfq_empty +* 	                   new_pes.cc_dfq_empty +) 	                   new_pes.cc_mfq_empty;T* 	    sprintf (string, "%d", pem.fq_empty);0 	    BannerWriteText (XtDisplay(Bnr.pe_widget),  		XtWindow(Bnr.pe_widget), 		lx_pos, y_pos, string, 3,  		w8w);B 	    }! 	y_pos = y_pos + Bnr.font_height;g 	}  *       memcpy(&pes, &new_pes, sizeof(pes));    */    }i