 #module BannerSound "V1.0"   /* **++ **  FACILITY:    **  N **  This module contains all the interface support for Sound generation withinL **  the DECwindows Banner program. Sound Support is currently used for stateL **  excepts, such as processes going into MWAIT, and varous system resources **  reaching critical levels.  ** **  MODULE DESCRIPTION:  ** **      As Above ** **  AUTHORS: ** **      Jim Saunders **& **  CREATION DATE:  28th December 1990 ** **  DESIGN ISSUES: ** **      None ** ** **  MODIFICATION HISTORY:  ** **       **	Initial Version **-- */ #include "stdio.h" #include "lnmdef.h"  #include <Mrm/MrmAppl.h> #include <Xt/vendor.h> #include <Xm/Shell.h>    #include "Banner"      void BannerSoundInitialize (); void BannerSoundSelect (); void BannerSoundCallback ();  void BannerSoundInitCallback (); void BannerSound (); void BannerSetSound ();  static void BuildSoundMenus ();  static void WidgetToSound ();  /* ** **  MACRO DEFINITIONS  ** */  ' extern	 int	     BannerInitialPriority;  extern	 Bnr$_Blk    Bnr; extern	 Clk$_Blk    Clk; extern	 Mon$_Blk    Mon; extern	 GC	     BannerGC;   extern	 XEvent	     BannerEvent;   	 Son$_Blk    Son; 	 Son$_Blk    NewSon;    static	 Sound$_Item  Test;( static	 Sound$_Item  *TestSound = &Test;  ( #define BANNER_SOUND_MENU_CREATE    1001  ! #define BANNER_SOUND_OK_BUTTON		1 $ #define BANNER_SOUND_CANCEL_BUTTON	2 #define BANNER_SOUND_VOLUME		3 #define BANNER_SOUND_TIME		4 #define BANNER_SOUND_MWAIT		5 " #define BANNER_SOUND_MWAIT_PUSH		6$ #define BANNER_SOUND_NEW_PROCESSES	7) #define BANNER_SOUND_NEW_PROCESSES_PUSH 8   #define BANNER_LESS_PROCESSES		9% #define BANNER_LESS_PROCESSES_PUSH	10  #define BANNER_SOUND_DISK_1		11 # #define BANNER_SOUND_DISK_1_PUSH	12  #define BANNER_SOUND_DISK_2		13 # #define BANNER_SOUND_DISK_2_PUSH	14  #define BANNER_SOUND_DISK_3		15 # #define BANNER_SOUND_DISK_3_PUSH	16  #define BANNER_SOUND_MEMORY		17 # #define BANNER_SOUND_MEMORY_PUSH	18 " #define BANNER_SOUND_PAGE_FILE		19& #define BANNER_SOUND_PAGE_FILE_PUSH	20# #define BANNER_SOUND_PENDING_IOS	21 ( #define BANNER_SOUND_PENDING_IOS_PUSH	22  " #define BANNER_SOUND_MAXWIDGETS 23  2 static int  SoundWidgets[BANNER_SOUND_MAXWIDGETS];$ static int  *AvailableSounds = NULL;) static int  *AvailableSoundsSpecs = NULL; ! static int  BannerSoundAvailable;    /* **++ **  FUNCTIONAL DESCRIPTION:  **  **      BannerSoundInitialize () **A **	Performs all once only initialization for the sound subsystem.  ** **  FORMAL PARAMETERS: ** **      None ** **  RETURN VALUE:  ** **      None ** **  SIDE EFFECTS:  ** **      None ** **  DESIGN:  ** **      {@description or none@}  ** ** **-- */ void BannerSoundInitialize ()  {  /*)  * Get a list of all the sounds available   */ #     memset (&Son, 0, sizeof (Son)); )     memset (&NewSon, 0, sizeof (NewSon));   0     AvailableSounds = XtMalloc (20*sizeof(int));5     AvailableSoundsSpecs = XtMalloc (20*sizeof(int)); '     AvailableSounds[0] = "Mwait Sound"; #     AvailableSoundsSpecs[0] = NULL;      Test.On = 1;*     Test.DisplayName = AvailableSounds[0];)     Test.Sound = AvailableSoundsSpecs[0]; /     AvailableSounds[1] = "New Processes Sound"; #     AvailableSoundsSpecs[1] = NULL; 0     AvailableSounds[2] = "Less Processes Sound";#     AvailableSoundsSpecs[2] = NULL; '     AvailableSounds[3] = "Disk1 Sound"; #     AvailableSoundsSpecs[3] = NULL; '     AvailableSounds[4] = "Disk2 Sound"; #     AvailableSoundsSpecs[4] = NULL; '     AvailableSounds[5] = "Disk3 Sound"; #     AvailableSoundsSpecs[5] = NULL; (     AvailableSounds[6] = "Memory Sound";#     AvailableSoundsSpecs[6] = NULL; -     AvailableSounds[7] = "Penidnhg IO Sound"; #     AvailableSoundsSpecs[7] = NULL; *     AvailableSounds[8] = "PageFile Sound";#     AvailableSoundsSpecs[8] = NULL;      AvailableSounds[9] = NULL;#     AvailableSoundsSpecs[9] = NULL;  /*0  * Find out if sound can be used on this machine  */      BannerSoundAvailable = 0;  }    /* **++ **  FUNCTIONAL DESCRIPTION:  **& **      BannerSoundSelect (savewidget) **B **	This routine creates, and initializes the dialog box for sound I **  selection. The dialog box allows the user select specific sounds for  D **  specific functions, and establish which sounds should be active. ** **  FORMAL PARAMETERS: ** **      None ** **  RETURN VALUE:  ** **      None ** **  SIDE EFFECTS:  ** **      None ** **  DESIGN:  ** **      {@description or none@}  ** ** **-- */# void BannerSoundSelect (savewidget)  Widget savewidget; {  int class, width, height;  	      if (Bnr.sound_widget != 0) 	{$ 	XtDestroyWidget (Bnr.sound_widget); /*!  * Now syncronize with the Server   */ " 	XSync (XtDisplay (Bnr.dp_id), 0); 	Bnr.sound_widget=0; 	}        MrmFetchWidget (Bnr.drm_prt, 	"BANNER_SOUND_OPTIONS", 	savewidget, 	&Bnr.sound_widget, 	 	&class);   %     XtManageChild (Bnr.sound_widget); +     XtRealizeWidget (Bnr.sound_widget);      }    /* **++ **  FUNCTIONAL DESCRIPTION:  **) **      BannerSoundCallback (widget, tag)  **J **  The callback routine for the varous functions for the sound interface. ** **  FORMAL PARAMETERS: ** **      As Above ** **  RETURN VALUE:  ** **      None ** **  SIDE EFFECTS:  ** **      None ** **  DESIGN:  ** **      {@description or none@}  ** ** **-- */& void BannerSoundCallback (widget, tag) Widget widget;	 int *tag;  {  Arg		al[10];       switch (*tag)      {       case BANNER_SOUND_OK_BUTTON: 	{% 	memcpy (&Son, &NewSon, sizeof(Son));  	TestSound = &Test;  	break;  	}%     case BANNER_SOUND_CANCEL_BUTTON :  	{% 	memcpy (&NewSon, &Son, sizeof(Son));  	break;  	}     case BANNER_SOUND_VOLUME : 	{, 	XtSetArg (al[0], XmNvalue, &NewSon.Volume); 	XtGetValues (widget, al, 1); 5 	BannerSound (TestSound, NewSon.Volume, NewSon.Time);  	break;  	}     case BANNER_SOUND_TIME : 	{* 	XtSetArg (al[0], XmNvalue, &NewSon.Time); 	XtGetValues (widget, al, 1); 5 	BannerSound (TestSound, NewSon.Volume, NewSon.Time);  	break;  	}     case BANNER_SOUND_MWAIT :  	{' 	WidgetToSound (widget, &NewSon.Mwait); 9 	BannerSound (&NewSon.Mwait, NewSon.Volume, NewSon.Time);  	TestSound = &NewSon.Mwait;  	break;  	}%     case BANNER_SOUND_NEW_PROCESSES :  	{. 	WidgetToSound (widget, &NewSon.NewProcesses);@ 	BannerSound (&NewSon.NewProcesses, NewSon.Volume, NewSon.Time);# 	TestSound = &NewSon.NewProcesses;	  	break;  	}      case BANNER_LESS_PROCESSES : 	{/ 	WidgetToSound (widget, &NewSon.LessProcesses); A 	BannerSound (&NewSon.LessProcesses, NewSon.Volume, NewSon.Time); # 	TestSound = &NewSon.LessProcesses;          break;	         }      case BANNER_SOUND_DISK_1 : 	{' 	WidgetToSound (widget, &NewSon.Disk1); 9 	BannerSound (&NewSon.Disk1, NewSon.Volume, NewSon.Time);  	TestSound = &NewSon.Disk1;          break;	         }      case BANNER_SOUND_DISK_2 : 	{' 	WidgetToSound (widget, &NewSon.Disk2); 9 	BannerSound (&NewSon.Disk2, NewSon.Volume, NewSon.Time);  	TestSound = &NewSon.Disk2;          break;	         }      case BANNER_SOUND_DISK_3 : 	{' 	WidgetToSound (widget, &NewSon.Disk3); 9 	BannerSound (&NewSon.Disk3, NewSon.Volume, NewSon.Time);  	TestSound = &NewSon.Disk3;          break;	         }      case BANNER_SOUND_MEMORY : 	{( 	WidgetToSound (widget, &NewSon.Memory);: 	BannerSound (&NewSon.Memory, NewSon.Volume, NewSon.Time); 	TestSound = &NewSon.Memory; 	break;  	}!     case BANNER_SOUND_PAGE_FILE :  	{* 	WidgetToSound (widget, &NewSon.PageFile);< 	BannerSound (&NewSon.PageFile, NewSon.Volume, NewSon.Time); 	TestSound = &NewSon.PageFile; 	break;  	}#     case BANNER_SOUND_PENDING_IOS :  	{+ 	WidgetToSound (widget, &NewSon.PendingIO); = 	BannerSound (&NewSon.PendingIO, NewSon.Volume, NewSon.Time);  	TestSound = &NewSon.PendingIO;  	break;  	}     }  }    /* **++ **  FUNCTIONAL DESCRIPTION:  **- **      BannerSoundInitCallback (widget, tag)  **J **  The callback routine for the varous functions for the sound interface. ** **  FORMAL PARAMETERS: ** **      As Above ** **  RETURN VALUE:  ** **      None ** **  SIDE EFFECTS:  ** **      None ** **  DESIGN:  ** **      {@description or none@}  ** ** **-- */* void BannerSoundInitCallback (widget, tag) Widget widget;	 int *tag;  {  Arg		al[10];       switch (*tag)      { "     case BANNER_SOUND_MENU_CREATE: 	{ /*F  * Set the menu sensitivity according to if sound is supported or not   * on this machine  */  	BannerSetArg(widget,  	    XmNsensitive, 	    BannerSoundAvailable);  	break;  	}      case BANNER_SOUND_OK_BUTTON: 	{/ 	SoundWidgets[BANNER_SOUND_OK_BUTTON] = widget; % 	memcpy (&NewSon, &Son, sizeof(Son));  	break;  	}%     case BANNER_SOUND_CANCEL_BUTTON :  	{3 	SoundWidgets[BANNER_SOUND_CANCEL_BUTTON] = widget;  	break;  	}     case BANNER_SOUND_VOLUME : 	{, 	SoundWidgets[BANNER_SOUND_VOLUME] = widget;+ 	XtSetArg (al[0], XmNvalue, NewSon.Volume);  	XtSetValues (widget, al, 1);  	break;  	}     case BANNER_SOUND_TIME : 	{* 	SoundWidgets[BANNER_SOUND_TIME] = widget;) 	XtSetArg (al[0], XmNvalue, NewSon.Time);  	XtSetValues (widget, al, 1);  	break;  	}"     case BANNER_SOUND_MWAIT_PUSH : 	{0 	SoundWidgets[BANNER_SOUND_MWAIT_PUSH] = widget; 	break;  	}     case BANNER_SOUND_MWAIT :  	{+ 	SoundWidgets[BANNER_SOUND_MWAIT] = widget;  	BuildSoundMenus (widget, , 	    SoundWidgets[BANNER_SOUND_MWAIT_PUSH],  	    BANNER_SOUND_MWAIT, 	    &NewSon.Mwait);( 	if (Bnr.Param_Bits.process_window == 0), 	    BannerSetArg (widget, XmNsensitive, 0); 	break;  	}*     case BANNER_SOUND_NEW_PROCESSES_PUSH : 	{8 	SoundWidgets[BANNER_SOUND_NEW_PROCESSES_PUSH] = widget; 	break;  	}%     case BANNER_SOUND_NEW_PROCESSES :  	{3 	SoundWidgets[BANNER_SOUND_NEW_PROCESSES] = widget;  	BuildSoundMenus (widget, 3 	    SoundWidgets[BANNER_SOUND_NEW_PROCESSES_PUSH],   	    BANNER_SOUND_NEW_PROCESSES, 	    &NewSon.NewProcesses); ( 	if (Bnr.Param_Bits.process_window == 0), 	    BannerSetArg (widget, XmNsensitive, 0); 	break;  	}%     case BANNER_LESS_PROCESSES_PUSH :  	{3 	SoundWidgets[BANNER_LESS_PROCESSES_PUSH] = widget;  	break;  	}      case BANNER_LESS_PROCESSES : 	{. 	SoundWidgets[BANNER_LESS_PROCESSES] = widget; 	BuildSoundMenus (widget, . 	    SoundWidgets[BANNER_LESS_PROCESSES_PUSH], 	    BANNER_LESS_PROCESSES,* 	    &NewSon.LessProcesses);( 	if (Bnr.Param_Bits.process_window == 0), 	    BannerSetArg (widget, XmNsensitive, 0); 	break;d 	}#     case BANNER_SOUND_DISK_1_PUSH :i 	{1 	SoundWidgets[BANNER_SOUND_DISK_1_PUSH] = widget;  	break;e 	}     case BANNER_SOUND_DISK_1 : 	{, 	SoundWidgets[BANNER_SOUND_DISK_1] = widget; 	BuildSoundMenus (widget, , 	    SoundWidgets[BANNER_SOUND_DISK_1_PUSH], 	    BANNER_SOUND_DISK_1,i 	    &NewSon.Disk1);  	if (!Bnr.Param_Bits.sys_window) 	    BannerSetArg(widget,  		XmNsensitive,< 		0);o 	break;c 	}#     case BANNER_SOUND_DISK_2_PUSH :  	{1 	SoundWidgets[BANNER_SOUND_DISK_2_PUSH] = widget;e 	break;o 	}     case BANNER_SOUND_DISK_2 : 	{, 	SoundWidgets[BANNER_SOUND_DISK_2] = widget; 	BuildSoundMenus (widget,t, 	    SoundWidgets[BANNER_SOUND_DISK_2_PUSH], 	    BANNER_SOUND_DISK_2,  	    &NewSon.Disk2);  	if (!Bnr.Param_Bits.sys_window) 	    BannerSetArg(widget,  		XmNsensitive,e 		0);$ 	break;l 	}#     case BANNER_SOUND_DISK_3_PUSH :  	{1 	SoundWidgets[BANNER_SOUND_DISK_3_PUSH] = widget;o 	break;  	}     case BANNER_SOUND_DISK_3 : 	{, 	SoundWidgets[BANNER_SOUND_DISK_3] = widget; 	BuildSoundMenus (widget,A, 	    SoundWidgets[BANNER_SOUND_DISK_3_PUSH], 	    BANNER_SOUND_DISK_3,f 	    &NewSon.Disk3);! 	if ( !Bnr.Param_Bits.sys_window)L 	    BannerSetArg(widget,  		XmNsensitive,  		0);S 	break;T 	}#     case BANNER_SOUND_MEMORY_PUSH :  	{1 	SoundWidgets[BANNER_SOUND_MEMORY_PUSH] = widget;U 	break;O 	}     case BANNER_SOUND_MEMORY : 	{, 	SoundWidgets[BANNER_SOUND_MEMORY] = widget; 	BuildSoundMenus (widget,S, 	    SoundWidgets[BANNER_SOUND_MEMORY_PUSH], 	    BANNER_SOUND_MEMORY,_ 	    &NewSon.Memory);S! 	if ( !Bnr.Param_Bits.sys_window)R 	    BannerSetArg(widget,  		XmNsensitive,_ 		0);1 	break;n 	}&     case BANNER_SOUND_PAGE_FILE_PUSH : 	{4 	SoundWidgets[BANNER_SOUND_PAGE_FILE_PUSH] = widget; 	break;A 	}!     case BANNER_SOUND_PAGE_FILE :A 	{/ 	SoundWidgets[BANNER_SOUND_PAGE_FILE] = widget;I 	BuildSoundMenus (widget,A/ 	    SoundWidgets[BANNER_SOUND_PAGE_FILE_PUSH],e 	    BANNER_SOUND_PAGE_FILE, 	    &NewSon.PageFile);n! 	if ( !Bnr.Param_Bits.sys_window)o 	    BannerSetArg(widget,  		XmNsensitive,a 		0);  	break;  	}(     case BANNER_SOUND_PENDING_IOS_PUSH : 	{6 	SoundWidgets[BANNER_SOUND_PENDING_IOS_PUSH] = widget; 	break;i 	}#     case BANNER_SOUND_PENDING_IOS :M 	{1 	SoundWidgets[BANNER_SOUND_PENDING_IOS] = widget;  	BuildSoundMenus (widget, 1 	    SoundWidgets[BANNER_SOUND_PENDING_IOS_PUSH],  	    BANNER_SOUND_PENDING_IOS, 	    &NewSon.PendingIO);! 	if ( !Bnr.Param_Bits.sys_window)* 	    BannerSetArg(widget,  		XmNsensitive,  		0);  	break;( 	}     }z }    ) /* **++ **  FUNCTIONAL DESCRIPTION:S *** **      WidgetToSound (widget, soundblock) **E **  This routine maps the the name of the current pushbutton, into a i **  sound block. ** **  FORMAL PARAMETERS: ** **      {@subtags@}  ** **  RETURN VALUE:e ** **      {@description or none@}  ** **  SIDE EFFECTS:b ** **      {@description or none@}d ** **  DESIGN:s ** **      {@description or none@}s ** **  [@logical properties@]...] **! **  [@optional function tags@]...l ** **-- */. static void WidgetToSound (widget, soundblock) Widget widget; Sound$_Item *soundblock; {  Arg		al[10]; char *name;k  *     XtSetArg (al[0], XmNuserData, &name);       XtGetValues (widget, al, 1);&     BannerSetSound (soundblock, name); }U     /* **++ **  FUNCTIONAL DESCRIPTION:; **. **      BannerSetSound (soundblock, soundname) **@ **  This routine maps a sound name, into a specific sound block. ** **  FORMAL PARAMETERS: ** **      {@subtags@}v ** **  RETURN VALUE:  ** **      {@description or none@}; ** **  SIDE EFFECTS:e ** **      {@description or none@}u ** **  DESIGN:  ** **      {@description or none@}a ** **  [@logical properties@]...  **! **  [@optional function tags@]...a ** **-- */+ void BannerSetSound (soundblock, soundname)a Sound$_Item *soundblock; char	    *soundname; {t       soundblock->On = 0;t#     soundblock->DisplayName = NULL;      soundblock->Sound = NULL;a       if (soundname != NULL) 	{ 	int i;*   	i = 0;R> 	while (AvailableSounds != NULL && AvailableSounds[i] != NULL) 	    {5 	    if (strcmp (soundname, AvailableSounds[i]) == 0)  		{  		soundblock->On = 1;r/ 		soundblock->DisplayName = AvailableSounds[i];t0 		soundblock->Sound = AvailableSoundsSpecs[i];		 		}h	 	    i++;  	    } 	} }.   _ /* **++ **  FUNCTIONAL DESCRIPTION:. **B **      BuildSoundMenus	(widget, pushbutton, menucode, soundblock) **( **	Build the dynamic sound otpion menu's ** **  FORMAL PARAMETERS: ** **      {@subtags@}U ** **  RETURN VALUE:e ** **      {@description or none@}  ** **  SIDE EFFECTS:r ** **      {@description or none@}  ** **  DESIGN:) ** **      {@description or none@}N ** **  [@logical properties@]...r **! **  [@optional function tags@]...h ** **-- */D static void BuildSoundMenus (menu, PushButton, menucode, soundblock) CompositeWidget	menu;  Widget	PushButton;
 int	menucode;  Sound$_Item	*soundblock; {E int		i, ac;*
 int		*tag; Arg		al[10]; Widget		Push, MenuHistory; WidgetList	childlist;*" XtCallbackRec	activatecallback[2]; /*2  * Setup this push button as the 'No sound' button  */        ac = 0;tC     XtSetArg (al[ac], XmNlabelString, XmStringCreate ("Sound Off", e" 	XmSTRING_DEFAULT_CHARSET)); ac++;/     XtSetArg (al[ac], XmNuserData, NULL); ac++;L7     activatecallback[0].callback = BannerSoundCallback;b!     tag = XtMalloc (sizeof(int));O     *tag = menucode;&     activatecallback[0].closure = tag;(     activatecallback[1].callback = NULL;$     activatecallback[1].closure = 0;C     XtSetArg (al[ac], XmNactivateCallback, activatecallback); ac++; %     XtSetValues (PushButton, al, ac);(     MenuHistory = PushButton;( /*C  * Now add the addition buttons, necessary for the different soundsO  */W
     i = 0;A     while (AvailableSounds != NULL && AvailableSounds[i] != NULL)i 	{ 	/*. 	 * Create a push button 	 */ 	ac = 0;G 	XtSetArg (al[ac], XmNlabelString, XmStringCreate (AvailableSounds[i], d& 	    XmSTRING_DEFAULT_CHARSET)); ac++;: 	XtSetArg (al[ac], XmNuserData, AvailableSounds[i]); ac++;4 	activatecallback[0].callback = BannerSoundCallback; 	tag = XtMalloc (sizeof(int)); 	*tag = menucode;e# 	activatecallback[0].closure = tag;e% 	activatecallback[1].callback = NULL;e! 	activatecallback[1].closure = 0;T@ 	XtSetArg (al[ac], XmNactivateCallback, activatecallback); ac++;2 	Push = XmCreatePushButton (XtParent(PushButton),   	    "SoundPushbutton", al, ac); 	XtManageChild (Push);' 	if (soundblock->DisplayName != NULL &&e? 	    strcmp (soundblock->DisplayName, AvailableSounds[i]) == 0)I 	    MenuHistory = Push;   	i++;  	}   /*:  * Set the menu History to show the current selected sound  */      ac = 0;=&     XtSetArg (al[ac], XmNmenuHistory,  	MenuHistory); ac++;       XtSetValues (menu, al, ac);( }g   /* **++ **  FUNCTIONAL DESCRIPTION:. **- **      BannerSound (SoundCode, Volume, Time)& **C **	This routine generates the actual sound, according to a specific:I **  sound code. The sound code is used as an index into the active sound yE **  tables, and if the specified sound is available, it is generated.  ** **  FORMAL PARAMETERS: ** **      As Above ** **  RETURN VALUE:o ** **      None ** **  SIDE EFFECTS:i ** **      None ** **  DESIGN:T ** **      {@description or none@}  ** ** **-- */+ void BannerSound (SoundCode, Volume, Lenth)( Sound$_Item	*SoundCode;) int		Volume; int		Lenth;e {n if (SoundCode->On)N     printf ("Sounding '%s', Time - %d, Volume - %d\n", SoundCode->DisplayName, 	    Lenth, Volume); } 