  #module BannerCpu "V1.0"      /*   **++   **  FACILITY:  ** &  **      The DECwindows Banner program  **   **  ABSTRACT:  ** E  **      This module contains all the code, to run the CPU histogram.   ** 
  **  AUTHORS:   **   **      JIM SAUNDERS   **   ** &  **  CREATION DATE:     20th June 1988  **   **  MODIFICATION HISTORY:  **--   **/        /*   **   **  INCLUDE FILES  **   **/    *7D   #include <stdio.h>   #include <jpidef.h>  #include <syidef.h>,  #include <decw$include/DECwDwtWidgetProg.h> *7E  *7I      #include "stdio.h"   #include "jpidef.h"  #include "syidef.h"  #include "MrmAppl.h"     *7E   #include "Banner"        /*   **   **  MACRO DEFINITIONS  **   **/     #define SS$_NORMAL 1          typedef struct _vms_item_list {  	short	 buffer_length;   	short	 item_code;   	void	*buffer;   	int	*returned_buffer_length;  	} VMS_ItemList;         /* #   * now our runtime data structures    */     extern	 Bnr$_Blk    Bnr;   extern	 Clk$_Blk    Clk;   extern	 GC	     BannerGC;  extern	 XGCValues   GcValues;    *9I  *10D,  extern   char	     *BannerVmsDisplayName[]; *10E *10I*  extern   char	     *BannerVmsDisplayName; *10E *9E (  extern   char	     BannerVmsNodeName[];'  extern   char	     BannerVmsVersion[];     *8I     *8E !  extern void BannerSignalError();      void BannerCpu ();   void BannerCpuRefresh ();  void BannerCpuSetup ();        static int cpu_init = 0;   static int cpu_update;      static int last_time[2];   static int curr_time[2];   static int quadtime[2];  static int update_count;   static int min_tick;   static int p_size;    !  static XPoint cpu_hist[4][1004];      static int min_height = 100;   static int height[4];   D  static int bar_wid, widel, tickl_x, tach_x, bar_x, bar_x1, tach_x1,<  	    tickr_x, wider, bar_height, seg_height, low_y, high_y;     static int cpu_modes = 0;   "  static float interrupt_mode = 0;   static float kernel_mode = 0;    static float exec_mode = 0;    static float super_mode = 0;   static float user_mode = 0;  %  static float compatibility_mode = 0;    static float spinlock_mode = 0;  static float null_mode = 0;-  static float null_cpumode[4] = {0, 0, 0, 0};   static float last_total = 0; .  static float last_cputotal[4] = {0, 0, 0, 0};     static int k_start;  static int e_start;  static int i_start;  static int s_start;  static int u_start;  static int n_start;     typedef struct _cpudata {  char fill_1[632];  int cpu$l_kernel;  int cpu$l_executive;   int cpu$l_super;   int cpu$l_user;  int cpu$l_interrupt;   int cpu$l_compatibility;   int cpu$l_spinlock;  int cpu$l_nullcpu;   } cpu$data;       H  globalref cpu$data *SMP$GL_CPU_DATA[];	    /* CPU data pointer array */<  globalref int SMP$GL_ACTIVE_CPUS;	    /* Active cpu mask */    *3D !  static int BannerActiveCpuCount; %  static int BannerLastActiveCpuCount;  *3E  *3I %  static int BannerActiveCpuCount = 1; )  static int BannerLastActiveCpuCount = 1;  *3E        /*   **++   **  FUNCTIONAL DESCRIPTION:  **   **	BannerCpuSetup ()   ** O  **      This routine is the setup routine for the CPu histogram. It initalises G  **	all the data structures, and then calls the refresh routine, to get #  **	all the sdtatic info displayed.   **   **  FORMAL PARAMETERS:   ** 
  **      none   **   **  IMPLICIT INPUTS:   ** 
  **      none   **   **  IMPLICIT OUTPUTS:  ** 
  **      none   **   **  COMPLETION CODES:  ** 
  **      none   **   **  SIDE EFFECTS:  ** 
  **      none   **   **--   **/  void	  BannerCpuSetup()   {      int ticks, i, j;       int status, inc, delta;      short len;         /* #   * first initialise our structures    */#      update_count = Bnr.cpu_update;              if (Bnr.cpu_width > 160 &&    	Bnr.Param_Bits.modes_window &&'  	Bnr.cpu_height > 5 * Bnr.font_height)   	{   	cpu_modes = 1;;  	Bnr.cpu_count = Bnr.cpu_width - (11*Bnr.font_width) - 20;      	interrupt_mode = 0;   	kernel_mode = 0;  	exec_mode = 0;  	user_mode = 0;  	super_mode = 0;   	compatibility_mode = 0;   	spinlock_mode = 0;  	null_mode = 0;7  	null_cpumode[0] = null_cpumode[1] = null_cpumode[2] =   	    null_cpumode[3] = 0;     	j = 0;2  	BannerLastActiveCpuCount = BannerActiveCpuCount;  	BannerActiveCpuCount = 0; +  	for (i=1;  i<=SMP$GL_ACTIVE_CPUS;  i=i*2)   	    { '  	    if ((i & SMP$GL_ACTIVE_CPUS) > 0)   		{  		BannerActiveCpuCount++;@  		kernel_mode = kernel_mode + SMP$GL_CPU_DATA[j]->cpu$l_kernel;+  		last_cputotal[BannerActiveCpuCount-1] =  /  		    last_cputotal[BannerActiveCpuCount-1] +  (  		    SMP$GL_CPU_DATA[j]->cpu$l_kernel;?  		exec_mode = exec_mode + SMP$GL_CPU_DATA[j]->cpu$l_executive; +  		last_cputotal[BannerActiveCpuCount-1] =  /  		    last_cputotal[BannerActiveCpuCount-1] +  +  		    SMP$GL_CPU_DATA[j]->cpu$l_executive; ;  		user_mode =  user_mode + SMP$GL_CPU_DATA[j]->cpu$l_user; ,  		last_cputotal[BannerActiveCpuCount-1] =  /  		    last_cputotal[BannerActiveCpuCount-1] +  &  		    SMP$GL_CPU_DATA[j]->cpu$l_user;=  		super_mode = super_mode + SMP$GL_CPU_DATA[j]->cpu$l_super; +  		last_cputotal[BannerActiveCpuCount-1] =  /  		    last_cputotal[BannerActiveCpuCount-1] +  '  		    SMP$GL_CPU_DATA[j]->cpu$l_super; U  		compatibility_mode = compatibility_mode + SMP$GL_CPU_DATA[j]->cpu$l_compatibility; +  		last_cputotal[BannerActiveCpuCount-1] =  /  		    last_cputotal[BannerActiveCpuCount-1] +  /  		    SMP$GL_CPU_DATA[j]->cpu$l_compatibility; F  		spinlock_mode = spinlock_mode + SMP$GL_CPU_DATA[j]->cpu$l_spinlock;+  		last_cputotal[BannerActiveCpuCount-1] =  /  		    last_cputotal[BannerActiveCpuCount-1] +  *  		    SMP$GL_CPU_DATA[j]->cpu$l_spinlock;=  		null_mode = null_mode + SMP$GL_CPU_DATA[j]->cpu$l_nullcpu; *  		null_cpumode[BannerActiveCpuCount-1] = )  		    SMP$GL_CPU_DATA[j]->cpu$l_nullcpu; +  		last_cputotal[BannerActiveCpuCount-1] =  /  		    last_cputotal[BannerActiveCpuCount-1] +  )  		    SMP$GL_CPU_DATA[j]->cpu$l_nullcpu;   /* C   * Interrupt time should include NULL time, so subtract NULL time  -   * from Interrupt time, if that is the case.    */-  		if (SMP$GL_CPU_DATA[j]->cpu$l_interrupt >= )  		    SMP$GL_CPU_DATA[j]->cpu$l_nullcpu)   		    {)  		    interrupt_mode = interrupt_mode +  )  			SMP$GL_CPU_DATA[j]->cpu$l_interrupt - &  			SMP$GL_CPU_DATA[j]->cpu$l_nullcpu;/  		    last_cputotal[BannerActiveCpuCount-1] =  ,  			last_cputotal[BannerActiveCpuCount-1] + )  			SMP$GL_CPU_DATA[j]->cpu$l_interrupt - &  			SMP$GL_CPU_DATA[j]->cpu$l_nullcpu;  		    }  		else   		    {)  		    interrupt_mode = interrupt_mode +  (  			SMP$GL_CPU_DATA[j]->cpu$l_interrupt;/  		    last_cputotal[BannerActiveCpuCount-1] =  ,  			last_cputotal[BannerActiveCpuCount-1] + (  			SMP$GL_CPU_DATA[j]->cpu$l_interrupt;  		    }  		}
  	    j++;  	    } E  	last_total = interrupt_mode + kernel_mode + exec_mode + user_mode + B  	    super_mode + compatibility_mode + spinlock_mode + null_mode;  	} 	      else   	{   	cpu_modes = 0;&  	Bnr.cpu_count = Bnr.cpu_width - 20;   	}             if (BannerActiveCpuCount>4)  	BannerActiveCpuCount = 4;          if (Bnr.cpu_count > 1000)  	Bnr.cpu_count = 1000;           p_size = Bnr.cpu_count + 4;     /* *   * Now initialise our current time marks.   */;      if ( (status = SYS$GETTIM (&curr_time)) != SS$_NORMAL) E  	BannerSignalError ("Failed to get the time for SYS$GETTIM service",   	    status);           !      last_time[0] = curr_time[0]; !      last_time[1] = curr_time[1];          min_tick = 4000000;     /* H   * Now initialise all the variables to redisplay the static infor with.   */     /* '   * If we want just a single histogram     */$  	if (Bnr.Param_Bits.cpu_multi_hist)D  	    seg_height = bar_height = Bnr.cpu_height/BannerActiveCpuCount;  	else/  	    seg_height = bar_height = Bnr.cpu_height;          inc = 10;   *      while (seg_height/inc < 1 && inc > 1)  	inc = inc/2;         delta = seg_height/inc;      bar_height = inc * delta;         bar_wid = Bnr.cpu_count;       widel = 2;       tickl_x = widel + 2;       tach_x = tickl_x + 3;      bar_x = tach_x + 2;      bar_x1 = bar_x + bar_wid;      tach_x1 = bar_x1 + 2;      tickr_x = tach_x1 + 3;       wider = tickr_x + 2;   /*    * Now initialise our memory    */,      for (j=0; j <BannerActiveCpuCount; j++)  	{ *  	for (i=2;  i <= Bnr.cpu_count + 2;  i++)  	    {    	    cpu_hist[j][i].x = bar_x1;5  	    cpu_hist[j][i].y = seg_height * j + bar_height;   	    }   	}       cpu_update = 1;          cpu_init = 1;  }    /*   **++   **  FUNCTIONAL DESCRIPTION:  **  *8D   **	BannerCpurefresh (); *8E  *8I   **	BannerCpuRefresh (); *8E   ** D  **      This routine repaints all the constant infor on the screen.  **   **  FORMAL PARAMETERS:   **   **      display
  **	window  **   **  IMPLICIT INPUTS:   ** 
  **      none   **   **  IMPLICIT OUTPUTS:  ** 
  **      none   **   **  COMPLETION CODES:  ** 
  **      none   **   **  SIDE EFFECTS:  ** 
  **      none   **   **--   **/  void	  BannerCpuRefresh()   {"      int height, delta, i, j, inc;     /* )   * If we are not initialised then do it.    */         if (! cpu_init)  	BannerCpuSetup ();         inc = 10;   *      while (seg_height/inc < 1 && inc > 1)  	inc = inc/2;         delta = seg_height/inc;      bar_height = inc * delta;  /* 1   * Now draw the ticks on the side of the window.    */   -      for (j=0; j < BannerActiveCpuCount; j++)   	{   /* &   * If we want just a single histogram   */$  	if (Bnr.Param_Bits.cpu_multi_hist)8  	    height = (BannerActiveCpuCount-j-1) * seg_height;   	else  	    height = 0;   	for (i=0;  i <= inc;  i++)  	    { H  	    XDrawLine (XtDisplay (Bnr.cpu_widget), XtWindow (Bnr.cpu_widget), -  		BannerGC, tickr_x, height, wider, height);    '  	    if (i == 0 || i == 5 || i == inc) E  		XDrawLine (XtDisplay (Bnr.cpu_widget), XtWindow (Bnr.cpu_widget),  1  		    BannerGC, tach_x1, height, wider, height);    H  	    XDrawLine (XtDisplay (Bnr.cpu_widget), XtWindow (Bnr.cpu_widget), -  		BannerGC, widel, height, tickl_x, height);    '  	    if (i == 0 || i == 5 || i == inc)nE  		XDrawLine (XtDisplay (Bnr.cpu_widget), XtWindow (Bnr.cpu_widget), C0  		    BannerGC, widel, height, tach_x, height);  *  	    height = delta + height;  	    }   r  /*e5   * If we want just a single histogram then exit at 0J   */%  	if (!Bnr.Param_Bits.cpu_multi_hist)   	    break;  	}   /* 7   * Now repaint the area we had filled in the histogram*   */      U-      for (j=0; j < BannerActiveCpuCount; j++)o      {  	cpu_hist[j][0].x = bar_x; $  	cpu_hist[j][0].y = seg_height * j;  	cpu_hist[j][1].x = bar_x; 1  	cpu_hist[j][1].y = seg_height * j + bar_height;#,  	cpu_hist[j][Bnr.cpu_count + 2].x = bar_x1;A  	cpu_hist[j][Bnr.cpu_count + 2].y = seg_height * j + bar_height;O,  	cpu_hist[j][Bnr.cpu_count + 3].x = bar_x1;4  	cpu_hist[j][Bnr.cpu_count + 3].y = seg_height * j;  e6  	XSetBackground (XtDisplay(Bnr.cpu_widget), BannerGC,  	    Bnr.foreground);6  	XSetForeground (XtDisplay(Bnr.cpu_widget), BannerGC,  	    Bnr.background);  eD  	XFillPolygon (XtDisplay(Bnr.cpu_widget), XtWindow(Bnr.cpu_widget),C  	    BannerGC, &cpu_hist[j][0], p_size, Complex, CoordModeOrigin);   	6  	XSetForeground (XtDisplay(Bnr.cpu_widget), BannerGC,  	    Bnr.foreground);6  	XSetBackground (XtDisplay(Bnr.cpu_widget), BannerGC,  	    Bnr.background);  a  r  	cpu_hist[j][0].x = bar_x; 1  	cpu_hist[j][0].y = seg_height * j + bar_height;   	cpu_hist[j][1].x = bar_x;p1  	cpu_hist[j][1].y = seg_height * j + bar_height;a,  	cpu_hist[j][Bnr.cpu_count + 2].x = bar_x1;A  	cpu_hist[j][Bnr.cpu_count + 2].y = seg_height * j + bar_height;a,  	cpu_hist[j][Bnr.cpu_count + 3].x = bar_x1;A  	cpu_hist[j][Bnr.cpu_count + 3].y = seg_height * j + bar_height;t  uD  	XFillPolygon (XtDisplay(Bnr.cpu_widget), XtWindow(Bnr.cpu_widget),C  	    BannerGC, &cpu_hist[j][0], p_size, Complex, CoordModeOrigin);1  a  /*,5   * If we want just a single histogram then exit at 0h   */%  	if (!Bnr.Param_Bits.cpu_multi_hist)s  	    break;  r      }  0      if (cpu_modes)n  	{d  	int x, y;a    *9D G  	BannerWriteText (XtDisplay(Bnr.cpu_widget), XtWindow(Bnr.cpu_widget), A  	    Bnr.cpu_count + 20, Bnr.font_height, BannerVmsNodeName, 2, o3  	    XTextWidth(Bnr.font_ptr, "XXXXXXXXXXX", 11));l *9Eu *9Iu#  	if (BannerVmsDisplayName == NULL)a  	    {tK  	    BannerWriteText (XtDisplay(Bnr.cpu_widget), XtWindow(Bnr.cpu_widget),t>  		Bnr.cpu_count + 20, Bnr.font_height, BannerVmsNodeName, 2, 0  		XTextWidth(Bnr.font_ptr, "XXXXXXXXXXX", 11)); *9E   p *9DsG  	BannerWriteText (XtDisplay(Bnr.cpu_widget), XtWindow(Bnr.cpu_widget),uB  	    Bnr.cpu_count + 20, 2*Bnr.font_height, BannerVmsVersion, 2, 3  	    XTextWidth(Bnr.font_ptr, "XXXXXXXXXXX", 11));i *9Eu *9IlK  	    BannerWriteText (XtDisplay(Bnr.cpu_widget), XtWindow(Bnr.cpu_widget),C?  		Bnr.cpu_count + 20, 2*Bnr.font_height, BannerVmsVersion, 2, /0  		XTextWidth(Bnr.font_ptr, "XXXXXXXXXXX", 11));  	    }C  	else  	    {nK  	    BannerWriteText (XtDisplay(Bnr.cpu_widget), XtWindow(Bnr.cpu_widget),1A  		Bnr.cpu_count + 20, Bnr.font_height, BannerVmsDisplayName, 2,  0  		XTextWidth(Bnr.font_ptr, "XXXXXXXXXXX", 11));  	    }t *9E   *G  	n_start = x = Bnr.cpu_count + 20 + Bnr.font_width + Bnr.font_width/4;i  	y = Bnr.cpu_height - 1;aG  	BannerWriteText (XtDisplay(Bnr.cpu_widget), XtWindow(Bnr.cpu_widget),a  	    x, y, "N", 2, (  	    XTextWidth(Bnr.font_ptr, "N", 1));8  	u_start = x = x + Bnr.font_width + Bnr.font_width / 2;G  	BannerWriteText (XtDisplay(Bnr.cpu_widget), XtWindow(Bnr.cpu_widget),L  	    x, y, "U", 2, (  	    XTextWidth(Bnr.font_ptr, "U", 1));8  	s_start = x = x + Bnr.font_width + Bnr.font_width / 2;G  	BannerWriteText (XtDisplay(Bnr.cpu_widget), XtWindow(Bnr.cpu_widget),s  	    x, y, "S", 2, (  	    XTextWidth(Bnr.font_ptr, "S", 1));8  	e_start = x = x + Bnr.font_width + Bnr.font_width / 2;G  	BannerWriteText (XtDisplay(Bnr.cpu_widget), XtWindow(Bnr.cpu_widget),e  	    x, y, "E", 2, (  	    XTextWidth(Bnr.font_ptr, "E", 1));8  	k_start = x = x + Bnr.font_width + Bnr.font_width / 2;G  	BannerWriteText (XtDisplay(Bnr.cpu_widget), XtWindow(Bnr.cpu_widget),   	    x, y, "K", 2, (  	    XTextWidth(Bnr.font_ptr, "K", 1));8  	i_start = x = x + Bnr.font_width + Bnr.font_width / 2;G  	BannerWriteText (XtDisplay(Bnr.cpu_widget), XtWindow(Bnr.cpu_widget),a  	    x, y, "I", 2, (  	    XTextWidth(Bnr.font_ptr, "X", 1));  u'  	y = Bnr.cpu_height - Bnr.font_height;P     	for (i=0;  i <= 5;  i++)  	    {PH  	    XDrawLine (XtDisplay (Bnr.cpu_widget), XtWindow (Bnr.cpu_widget), (  		BannerGC, Bnr.cpu_count + 20 + 2, y, /  		Bnr.cpu_count + 20 + Bnr.font_width - 2, y);=   H  	    XDrawLine (XtDisplay (Bnr.cpu_widget), XtWindow (Bnr.cpu_widget), 4  		BannerGC, Bnr.cpu_width - Bnr.font_width + 2, y,   		Bnr.cpu_width - 2, y);   	5  	    y = y - (Bnr.cpu_height - 3*Bnr.font_height)/5;_  	    }B  	}A  }    /*-  **++   **  FUNCTIONAL DESCRIPTION:  **e *5Ie  **      BannerDrawCpuHist ()   **LC  **  This routine draws a CPU histogram line for the modes display.=  **	  **  FORMAL PARAMETERS:A  **C  **      See above  **P  **  IMPLICIT INPUTS:u  ** 
  **      none   **_  **  IMPLICIT OUTPUTS:  **u
  **      nonel  **p  **  FUNCTION VALUE:  **-
  **      nonel  **p  **  SIDE EFFECTS:  **n
  **      none   **G  **--A  **/A  void	BannerDrawCpuHist(display, window, gc, x, y, width, height,_"  	    max_height, fill, highlight)  {      int hwmrk;e  t0      hwmrk = (max_height*Bnr.sys_highlight)/100;  C'      XSetFillStyle (display, gc, fill);-  u%      if (highlight && height > hwmrk)s  	{c*  	XSetForeground (display, gc, Bnr.hwmrk);"  	XFillRectangle (display, window,)  		    gc, x, y, width, height - hwmrk); v/  	XSetForeground (display, gc, Bnr.foreground);l"  	XFillRectangle (display, window,3  		    gc, x, y + (height - hwmrk), width, hwmrk); d  	}n	      elseC"  	XFillRectangle (display, window,!  		    gc, x, y, width, height); l  n,      XSetFillStyle (display, gc, FillSolid);  n!      XSetBackground (display, gc,P  	Bnr.foreground);!      XSetForeground (display, gc,i  	Bnr.background);  t%      XFillRectangle (display, window,I  		    gc, x,   		    (Bnr.font_height * 2),   		    Bnr.font_width, u4  		    Bnr.cpu_height - 3*Bnr.font_height - height);  u!      XSetForeground (display, gc,   	Bnr.foreground);!      XSetBackground (display, gc,e  	Bnr.background);  }    /*>  **++u  **  FUNCTIONAL DESCRIPTION:  **A *5EC  **	BannerCpu ()  **tB  **      Thsi routine handles the drawing of the banner histogram.  **r  **  FORMAL PARAMETERS:T  **>
  **      none   **   **  IMPLICIT INPUTS:   ** 
  **      none   **e  **  IMPLICIT OUTPUTS:  **U
  **      none_  **r  **  COMPLETION CODES:  **n
  **      nonen  **=  **  SIDE EFFECTS:  **n
  **      nonet  **   **--M  **/  void	  BannerCpu()  {=      int ticks, i, j, cpu, modes_height, number_cpus, status;u      short len;m3      float total_time, total_cputime[4], cpu_ticks;m0      int mode_size, null_size, null_cpusize[4];	N      float total_user, total_kernel, total_interrupt, total_super, total_exec,&  	total_null, total_cpunull[4], ftemp;   !      float realtime, fbar_height;   i  /*r   * Check we are initialised   */  0      if (! cpu_init)  	BannerCpuRefresh ();  /      cpu_update --;e      if (cpu_update > 0)	  	return;i!      cpu_update = Bnr.cpu_update;e  /* *   * Now initialise our current time marks.   */;      if ( (status = SYS$GETTIM (&curr_time)) != SS$_NORMAL) E  	BannerSignalError ("Failed to get the time for SYS$GETTIM service",]  	    status);  c          /* 8   * Now compuet opur CPU time versa percent of real time   */  c      lib$subx (/  	&curr_time,   	&last_time, 
  	&quadtime, r	  	NULL );   f      lib$ediv (c  	&100000, )
  	&quadtime, g  	&quadtime[0],   	&quadtime[1]);  A  v  /*o3   * check we have not been called twice in 1 second_   */         if (quadtime[0] < 64)	  	return;_  g  i  <  /* ,   * calculate time in each mode for each CPU   */      total_time = 0;      total_null = 0;      total_user = 0;      total_kernel = 0;      total_super = 0;l      total_exec = 0;      total_interrupt = 0;t  _>      total_cputime[0] = total_cputime[1] = total_cputime[2] =   	total_cputime[3] = 0; >      total_cpunull[0] = total_cpunull[1] = total_cpunull[2] =   	total_cpunull[3] = 0; O      null_cpusize[0] = null_cpusize[1] = null_cpusize[2] = null_cpusize[3] = 0;+7      height[0] = height[1] = height[2] = height[3] = 0;_      j = 0;=5      BannerLastActiveCpuCount = BannerActiveCpuCount;u      BannerActiveCpuCount = 0;.      for (i=1;  i<=SMP$GL_ACTIVE_CPUS;  i=i*2)  	{O#  	if ((i & SMP$GL_ACTIVE_CPUS) > 0)(  	    {   	    BannerActiveCpuCount++; A  	    total_time = total_time + SMP$GL_CPU_DATA[j]->cpu$l_kernel;n.  	    total_cputime[BannerActiveCpuCount-1] = +  		total_cputime[BannerActiveCpuCount-1] + I$  		SMP$GL_CPU_DATA[j]->cpu$l_kernel;E  	    total_kernel = total_kernel + SMP$GL_CPU_DATA[j]->cpu$l_kernel;TD  	    total_time = total_time + SMP$GL_CPU_DATA[j]->cpu$l_executive;-  	    total_cputime[BannerActiveCpuCount-1] =C+  		total_cputime[BannerActiveCpuCount-1] + j'  		SMP$GL_CPU_DATA[j]->cpu$l_executive;aD  	    total_exec = total_exec + SMP$GL_CPU_DATA[j]->cpu$l_executive;?  	    total_time = total_time + SMP$GL_CPU_DATA[j]->cpu$l_user; .  	    total_cputime[BannerActiveCpuCount-1] = +  		total_cputime[BannerActiveCpuCount-1] +  "  		SMP$GL_CPU_DATA[j]->cpu$l_user;?  	    total_user = total_user + SMP$GL_CPU_DATA[j]->cpu$l_user;;@  	    total_time = total_time + SMP$GL_CPU_DATA[j]->cpu$l_super;.  	    total_cputime[BannerActiveCpuCount-1] = +  		total_cputime[BannerActiveCpuCount-1] +  #  		SMP$GL_CPU_DATA[j]->cpu$l_super;iB  	    total_super = total_super + SMP$GL_CPU_DATA[j]->cpu$l_super;H  	    total_time = total_time + SMP$GL_CPU_DATA[j]->cpu$l_compatibility;.  	    total_cputime[BannerActiveCpuCount-1] = +  		total_cputime[BannerActiveCpuCount-1] + d+  		SMP$GL_CPU_DATA[j]->cpu$l_compatibility;nC  	    total_time = total_time + SMP$GL_CPU_DATA[j]->cpu$l_spinlock;l.  	    total_cputime[BannerActiveCpuCount-1] = +  		total_cputime[BannerActiveCpuCount-1] + )&  		SMP$GL_CPU_DATA[j]->cpu$l_spinlock;B  	    total_time = total_time + SMP$GL_CPU_DATA[j]->cpu$l_nullcpu;.  	    total_cputime[BannerActiveCpuCount-1] = +  		total_cputime[BannerActiveCpuCount-1] + i%  		SMP$GL_CPU_DATA[j]->cpu$l_nullcpu;tB  	    total_null = total_null + SMP$GL_CPU_DATA[j]->cpu$l_nullcpu;.  	    total_cpunull[BannerActiveCpuCount-1] = %  		SMP$GL_CPU_DATA[j]->cpu$l_nullcpu;   /*iC   * Interrupt time should include NULL time, so subtract NULL time o-   * from Interrupt time, if that is the case.i   */-  		if (SMP$GL_CPU_DATA[j]->cpu$l_interrupt >=r)  		    SMP$GL_CPU_DATA[j]->cpu$l_nullcpu)   		    {+  		    total_interrupt = total_interrupt + x)  			SMP$GL_CPU_DATA[j]->cpu$l_interrupt -g&  			SMP$GL_CPU_DATA[j]->cpu$l_nullcpu;!  		    total_time = total_time + 	)  			SMP$GL_CPU_DATA[j]->cpu$l_interrupt -h&  			SMP$GL_CPU_DATA[j]->cpu$l_nullcpu;/  		    total_cputime[BannerActiveCpuCount-1] = ;,  			total_cputime[BannerActiveCpuCount-1] + )  			SMP$GL_CPU_DATA[j]->cpu$l_interrupt -F&  			SMP$GL_CPU_DATA[j]->cpu$l_nullcpu;  		    }  		elseg  		    {+  		    total_interrupt = total_interrupt +  (  			SMP$GL_CPU_DATA[j]->cpu$l_interrupt;!  		    total_time = total_time + ,(  			SMP$GL_CPU_DATA[j]->cpu$l_interrupt;/  		    total_cputime[BannerActiveCpuCount-1] = .,  			total_cputime[BannerActiveCpuCount-1] + (  			SMP$GL_CPU_DATA[j]->cpu$l_interrupt;  		    }  	    }p  	j++;  	}x  b  x       if (BannerActiveCpuCount>4)  	BannerActiveCpuCount = 4;i  j:      if (BannerLastActiveCpuCount != BannerActiveCpuCount)  	{]E  	XClearWindow (XtDisplay(Bnr.cpu_widget), XtWindow(Bnr.cpu_widget));=  	BannerCpuSetup();j  	BannerCpuRefresh();		  	return;   	}   /*e&  * subtract the count we got last time  */_      ftemp = total_time;*      total_time = total_time - last_total;  z      if (total_time == 0))	  	return;,     f  /*a(   * make sure we cant get a devide by 0!   */(      null_size = total_null - null_mode;      if (null_size < 1)   	null_size = 1;  s      fbar_height = bar_height;'      if (Bnr.Param_Bits.cpu_multi_hist)d*  	for (i=0;  i<BannerActiveCpuCount;  i++)  	    {   	    float null_size, ftemp;s  	    ftemp = total_cputime[i];B=  	    total_cputime[i] = total_cputime[i] - last_cputotal[i];D  	    if (total_cputime[i] < 1)	  		total_cputime[i] = 1;5  	    null_size = total_cpunull[i] - null_cpumode[i];r  	    if (null_size < 1)  		null_size = 1;d*  	    null_cpumode[i] =  total_cpunull[i];  	    last_cputotal[i] = ftemp;   	    if (total_cputime[i] > 0)c  		height[i] = fbar_height / d&  		    (total_cputime[i]/(null_size));  	    if (height[i] < 0)  		height[i] = 0;x  	    }r  	else  	    {X9  	    height[0] = fbar_height / (total_time/(null_size));y  	    }w6      fbar_height = Bnr.cpu_height - 3*Bnr.font_height;;      modes_height = fbar_height / (total_time/(null_size));n%      if (modes_height >= fbar_height) !  	modes_height = fbar_height - 1;r      if (modes_height < 0)  	modes_height = 0;c  w  /*)1   * Now update the modes display if we have open.m   */      if (cpu_modes)t  	{(  /*o   * first null time,   */  	 *5DtJ  	XSetFillStyle (XtDisplay(Bnr.cpu_widget), BannerGC, FillOpaqueStippled);G  	XFillRectangle (XtDisplay(Bnr.cpu_widget), XtWindow (Bnr.cpu_widget),u  	    BannerGC, n_start, w4  		Bnr.cpu_height - Bnr.font_height - modes_height,  *5Et *5I"J  	BannerDrawCpuHist (XtDisplay(Bnr.cpu_widget), XtWindow (Bnr.cpu_widget),  		    BannerGC, B  		    n_start, 8  		    Bnr.cpu_height - Bnr.font_height - modes_height,  *5Eh  		    Bnr.font_width,   *5Dt  		    modes_height);w *5E+ *5If  		    modes_height, r*  		    Bnr.cpu_height - 3*Bnr.font_height,  		    FillOpaqueStippled,
  		    0);    *5E   x  	null_size = modes_height;;  	 *5DrA  	XSetFillStyle (XtDisplay(Bnr.cpu_widget), BannerGC, FillSolid);   D6  	XSetBackground (XtDisplay(Bnr.cpu_widget), BannerGC,  	    Bnr.foreground);6  	XSetForeground (XtDisplay(Bnr.cpu_widget), BannerGC,  	    Bnr.background);  iG  	XFillRectangle (XtDisplay(Bnr.cpu_widget), XtWindow (Bnr.cpu_widget),w  	    BannerGC, n_start, 2  		(Bnr.font_height * 2),   		Bnr.font_width, _6  		Bnr.cpu_height - 3*Bnr.font_height - modes_height);  n  	6  	XSetForeground (XtDisplay(Bnr.cpu_widget), BannerGC,  	    Bnr.foreground);6  	XSetBackground (XtDisplay(Bnr.cpu_widget), BannerGC,  	    Bnr.background); *5Ee *5IP  	  	  	 *5E   /* G   * User mode time time, for the time being the invers of our CPU time.    */  	cpu_ticks = 0;!  	if (total_user - user_mode > 0) 6  	    cpu_ticks = total_time/(total_user - user_mode);  	mode_size = 0;  	if (cpu_ticks > 0)(  	    mode_size = fbar_height/cpu_ticks;  ,  	modes_height = mode_size;t"  	if (modes_height >= fbar_height)%  	    modes_height = fbar_height - 1;   n *5Dt  iG  	XFillRectangle (XtDisplay(Bnr.cpu_widget), XtWindow (Bnr.cpu_widget),O  	    BannerGC, u_start, n4  		Bnr.cpu_height - Bnr.font_height - modes_height,   		    Bnr.font_width, m  		    modes_height);*  F6  	XSetBackground (XtDisplay(Bnr.cpu_widget), BannerGC,  	    Bnr.foreground);6  	XSetForeground (XtDisplay(Bnr.cpu_widget), BannerGC,  	    Bnr.background);  NG  	XFillRectangle (XtDisplay(Bnr.cpu_widget), XtWindow (Bnr.cpu_widget),  *5En *5I*J  	BannerDrawCpuHist (XtDisplay(Bnr.cpu_widget), XtWindow (Bnr.cpu_widget), *5Et  	    BannerGC, u_start,   *5Di  		(Bnr.font_height * 2),   		Bnr.font_width, _6  		Bnr.cpu_height - 3*Bnr.font_height - modes_height); *5Ea *5I,4  		Bnr.cpu_height - Bnr.font_height - modes_height,   		    Bnr.font_width, i  		    modes_height,*  		    Bnr.cpu_height - 3*Bnr.font_height,  		    FillSolid,e
  		    1); *5E   S *5De  	6  	XSetForeground (XtDisplay(Bnr.cpu_widget), BannerGC,  	    Bnr.foreground);6  	XSetBackground (XtDisplay(Bnr.cpu_widget), BannerGC,  	    Bnr.background); *5Ep  /*wH   * Super mode time time, for the time being the invers of our CPU time.   */  	cpu_ticks = 0;#  	if (total_super - super_mode > 0)	8  	    cpu_ticks = total_time/(total_super - super_mode);  	mode_size = 0;  	if (cpu_ticks > 0)(  	    mode_size = fbar_height/cpu_ticks;  n  	modes_height = mode_size;B"  	if (modes_height >= fbar_height)%  	    modes_height = fbar_height - 1;     *5DFG  	XFillRectangle (XtDisplay(Bnr.cpu_widget), XtWindow (Bnr.cpu_widget),y  	    BannerGC, s_start,  4  		Bnr.cpu_height - Bnr.font_height - modes_height,   		    Bnr.font_width, )  		    modes_height);o  n6  	XSetBackground (XtDisplay(Bnr.cpu_widget), BannerGC,  	    Bnr.foreground);6  	XSetForeground (XtDisplay(Bnr.cpu_widget), BannerGC,  	    Bnr.background);   G  	XFillRectangle (XtDisplay(Bnr.cpu_widget), XtWindow (Bnr.cpu_widget),* *5E* *5I J  	BannerDrawCpuHist (XtDisplay(Bnr.cpu_widget), XtWindow (Bnr.cpu_widget), *5E	  	    BannerGC, s_start, t *5Ds  		(Bnr.font_height * 2),   		Bnr.font_width,  6  		Bnr.cpu_height - 3*Bnr.font_height - modes_height); *5Eu *5Is4  		Bnr.cpu_height - Bnr.font_height - modes_height,   		    Bnr.font_width, t  		    modes_height,*  		    Bnr.cpu_height - 3*Bnr.font_height,  		    FillSolid, 
  		    1); *5Ef  t *5Dt  	6  	XSetForeground (XtDisplay(Bnr.cpu_widget), BannerGC,  	    Bnr.foreground);6  	XSetBackground (XtDisplay(Bnr.cpu_widget), BannerGC,  	    Bnr.background); *5E	  u  /* L   * Interrupt mode time time, for the time being the invers of our CPU time.   */  	cpu_ticks = 0;+  	if (total_interrupt - interrupt_mode > 0)M@  	    cpu_ticks = total_time/(total_interrupt - interrupt_mode);  	mode_size = 0;  	if (cpu_ticks > 0)(  	    mode_size = fbar_height/cpu_ticks;  e  	modes_height = mode_size; "  	if (modes_height >= fbar_height)%  	    modes_height = fbar_height - 1;   f *5D G  	XFillRectangle (XtDisplay(Bnr.cpu_widget), XtWindow (Bnr.cpu_widget),[  	    BannerGC, i_start, c4  		Bnr.cpu_height - Bnr.font_height - modes_height,   		    Bnr.font_width, 6  		    modes_height);    6  	XSetBackground (XtDisplay(Bnr.cpu_widget), BannerGC,  	    Bnr.foreground);6  	XSetForeground (XtDisplay(Bnr.cpu_widget), BannerGC,  	    Bnr.background);  rG  	XFillRectangle (XtDisplay(Bnr.cpu_widget), XtWindow (Bnr.cpu_widget),c *5Ee *5I J  	BannerDrawCpuHist (XtDisplay(Bnr.cpu_widget), XtWindow (Bnr.cpu_widget), *5Eu  	    BannerGC, i_start, t *5Dc  		(Bnr.font_height * 2),   		Bnr.font_width, _6  		Bnr.cpu_height - 3*Bnr.font_height - modes_height); *5E[ *5I04  		Bnr.cpu_height - Bnr.font_height - modes_height,   		    Bnr.font_width,    		    modes_height,*  		    Bnr.cpu_height - 3*Bnr.font_height,  		    FillSolid, 
  		    1); *5ES  G *5DI  	6  	XSetForeground (XtDisplay(Bnr.cpu_widget), BannerGC,  	    Bnr.foreground);6  	XSetBackground (XtDisplay(Bnr.cpu_widget), BannerGC,  	    Bnr.background); *5En  	     /*_L   * Executive mode time time, for the time being the invers of our CPU time.   */  	cpu_ticks = 0;!  	if (total_exec - exec_mode > 0)l6  	    cpu_ticks = total_time/(total_exec - exec_mode);  	mode_size = 0;  	if (cpu_ticks > 0)(  	    mode_size = fbar_height/cpu_ticks;  m  	modes_height = mode_size; "  	if (modes_height >= fbar_height)%  	    modes_height = fbar_height - 1;e  u *5DaG  	XFillRectangle (XtDisplay(Bnr.cpu_widget), XtWindow (Bnr.cpu_widget),	  	    BannerGC, e_start,  4  		Bnr.cpu_height - Bnr.font_height - modes_height,   		    Bnr.font_width,    		    modes_height);n  A6  	XSetBackground (XtDisplay(Bnr.cpu_widget), BannerGC,  	    Bnr.foreground);6  	XSetForeground (XtDisplay(Bnr.cpu_widget), BannerGC,  	    Bnr.background);  CG  	XFillRectangle (XtDisplay(Bnr.cpu_widget), XtWindow (Bnr.cpu_widget),  *5Et *5IuJ  	BannerDrawCpuHist (XtDisplay(Bnr.cpu_widget), XtWindow (Bnr.cpu_widget), *5Ea  	    BannerGC, e_start, $ *5DU  		(Bnr.font_height * 2),   		Bnr.font_width, t6  		Bnr.cpu_height - 3*Bnr.font_height - modes_height); *5Ep *5I[4  		Bnr.cpu_height - Bnr.font_height - modes_height,   		    Bnr.font_width, P  		    modes_height,*  		    Bnr.cpu_height - 3*Bnr.font_height,  		    FillSolid,T
  		    1); *5Eo  l *5D   	6  	XSetForeground (XtDisplay(Bnr.cpu_widget), BannerGC,  	    Bnr.foreground);6  	XSetBackground (XtDisplay(Bnr.cpu_widget), BannerGC,  	    Bnr.background); *5EC  D  /*]I   * kernel mode time time, for the time being the invers of our CPU time.c   */  	cpu_ticks = 0;%  	if (total_kernel - kernel_mode > 0)l:  	    cpu_ticks = total_time/(total_kernel - kernel_mode);  	mode_size = 0;  	if (cpu_ticks > 0)(  	    mode_size = fbar_height/cpu_ticks;  A  	modes_height = mode_size; "  	if (modes_height >= fbar_height)%  	    modes_height = fbar_height - 1;m  t *5DtG  	XFillRectangle (XtDisplay(Bnr.cpu_widget), XtWindow (Bnr.cpu_widget),r *5E> *5I	J  	BannerDrawCpuHist (XtDisplay(Bnr.cpu_widget), XtWindow (Bnr.cpu_widget), *5El  	    BannerGC, k_start, C4  		Bnr.cpu_height - Bnr.font_height - modes_height,   		    Bnr.font_width, t *5Dt  		    modes_height);	  M6  	XSetBackground (XtDisplay(Bnr.cpu_widget), BannerGC,  	    Bnr.foreground);6  	XSetForeground (XtDisplay(Bnr.cpu_widget), BannerGC,  	    Bnr.background);  uG  	XFillRectangle (XtDisplay(Bnr.cpu_widget), XtWindow (Bnr.cpu_widget),[  	    BannerGC, k_start, }  		(Bnr.font_height * 2),   		Bnr.font_width, t6  		Bnr.cpu_height - 3*Bnr.font_height - modes_height);     	6  	XSetForeground (XtDisplay(Bnr.cpu_widget), BannerGC,  	    Bnr.foreground);6  	XSetBackground (XtDisplay(Bnr.cpu_widget), BannerGC,  	    Bnr.background); *5E  *5I	  		    modes_height,  		    fbar_height,   		    FillSolid,+
  		    1);  x *5E      	}e  t  /*u=   * Now remember the current values, accumilated fro each CPUA   */      last_total = ftemp;  n&      interrupt_mode = total_interrupt;       kernel_mode = total_kernel;      exec_mode = total_exec;      user_mode = total_user;      super_mode = total_super;      null_mode = total_null;     /*e   * remember the tick size   */       if (quadtime[0] < min_tick)  	min_tick = quadtime[0];	  u'      if (min_tick < 100*Bnr.cpu_update)    	min_tick = 100*Bnr.cpu_update;  i$      ticks = quadtime[0] / min_tick;      if (ticks < 1)u  	ticks = 1;     /*f#   * Now remember the current valuesr   */  t  p!      last_time[0] = curr_time[0];e!      last_time[1] = curr_time[1];	     a  /*l;   * now move the window to the right by the number of ticks_   */ *8D=  t *8Eu      {      int width, x_pos;         if (ticks > Bnr.cpu_count)t  	ticks = Bnr.cpu_count;  l-      for (j=0;  j<BannerActiveCpuCount;  j++)	  	{f  	if (height[j] < 0 )l  	    height[j] = 1; *2Iu  	if (height[j] > bar_height)	  	    height[j] = bar_height;  *2E   (1  	memcpy(&cpu_hist[j][2], &cpu_hist[j][ticks+2], /2  	    (Bnr.cpu_count - ticks) * sizeof (XPoint) );  	x_pos = bar_x + ticks;  	width = bar_x1 - x_pos;eA  	XCopyArea (XtDisplay(Bnr.cpu_widget), XtWindow(Bnr.cpu_widget),)A  	    XtWindow(Bnr.cpu_widget), BannerGC, x_pos, seg_height * j, ;0  	    width, seg_height, bar_x, seg_height * j);  /*i1   * Now update the array with our new possitions.o   */  tB  	for (i=2 + Bnr.cpu_count - ticks;  i <= 2 + Bnr.cpu_count;  i++)3  	    cpu_hist[j][i].y = seg_height*j +  height[j];h  /*p   * now update the X positions.    */  o*  	for (i = 2;  i <= Bnr.cpu_count+1;  i++)  	    {l  	    int x_pos;  w  	    x_pos = bar_x + (i - 2);  	    cpu_hist[j][i].x = x_pos;a  	    }_  /*t5   * If we want just a single histogram then exit at 0,   */%  	if (!Bnr.Param_Bits.cpu_multi_hist)e  	    break;  	}5      } *8Dr  p *8E   /*s#   * O.K now we can paint our screenp   */ *8D    -      for (j=0;  j<BannerActiveCpuCount;  j++)u *8Eh *8In  /* 7   * Now repaint the area we had filled in the histogram    */-      for (j=0; j < BannerActiveCpuCount; j++)s *8Eh      { *8DB       int width, x_pos, f_height;  	-      x_pos = bar_x + (Bnr.cpu_count - ticks);       width = bar_x1 - x_pos;   J      XFillRectangle (XtDisplay(Bnr.cpu_widget), XtWindow (Bnr.cpu_widget),L  	BannerGC, x_pos, seg_height*j + height[j], width, bar_height - height[j]); *8E; *8IS  	cpu_hist[j][0].x = bar_x;p$  	cpu_hist[j][0].y = seg_height * j;  	cpu_hist[j][1].x = bar_x;(1  	cpu_hist[j][1].y = seg_height * j + bar_height;),  	cpu_hist[j][Bnr.cpu_count + 2].x = bar_x1;A  	cpu_hist[j][Bnr.cpu_count + 2].y = seg_height * j + bar_height;h,  	cpu_hist[j][Bnr.cpu_count + 3].x = bar_x1;4  	cpu_hist[j][Bnr.cpu_count + 3].y = seg_height * j; *8Eu  ; *8DS9      XSetBackground (XtDisplay(Bnr.cpu_widget), BannerGC,n  	Bnr.foreground);9      XSetForeground (XtDisplay(Bnr.cpu_widget), BannerGC,r  	Bnr.background); *8Es *8Iu6  	XSetBackground (XtDisplay(Bnr.cpu_widget), BannerGC,  	    Bnr.foreground);6  	XSetForeground (XtDisplay(Bnr.cpu_widget), BannerGC,  	    Bnr.background); *8E     *8D J      XFillRectangle (XtDisplay(Bnr.cpu_widget), XtWindow (Bnr.cpu_widget),3  	BannerGC, x_pos, seg_height*j, width, height[j]);a *8Eg *8I1D  	XFillPolygon (XtDisplay(Bnr.cpu_widget), XtWindow(Bnr.cpu_widget),C  	    BannerGC, &cpu_hist[j][0], p_size, Complex, CoordModeOrigin);  *8Eo  	 *8D 9      XSetForeground (XtDisplay(Bnr.cpu_widget), BannerGC,i  	Bnr.foreground);9      XSetBackground (XtDisplay(Bnr.cpu_widget), BannerGC,o  	Bnr.background); *8Eu *8It6  	XSetForeground (XtDisplay(Bnr.cpu_widget), BannerGC,  	    Bnr.foreground);6  	XSetBackground (XtDisplay(Bnr.cpu_widget), BannerGC,  	    Bnr.background);  p  s  	cpu_hist[j][0].x = bar_x; 1  	cpu_hist[j][0].y = seg_height * j + bar_height;_  	cpu_hist[j][1].x = bar_x;h1  	cpu_hist[j][1].y = seg_height * j + bar_height;h,  	cpu_hist[j][Bnr.cpu_count + 2].x = bar_x1;A  	cpu_hist[j][Bnr.cpu_count + 2].y = seg_height * j + bar_height;B,  	cpu_hist[j][Bnr.cpu_count + 3].x = bar_x1;A  	cpu_hist[j][Bnr.cpu_count + 3].y = seg_height * j + bar_height;;  5D  	XFillPolygon (XtDisplay(Bnr.cpu_widget), XtWindow(Bnr.cpu_widget),C  	    BannerGC, &cpu_hist[j][0], p_size, Complex, CoordModeOrigin);t *8En  G  /*	5   * If we want just a single histogram then exit at 0i   */%  	if (!Bnr.Param_Bits.cpu_multi_hist)t  	    break; *8Di      } *8Ef  o *8Iu      }      e *8E	  }