  #module BannerDraw "V1.0"     /*   **++   **  FACILITY:  ** &  **      The DECwindows Banner program  **   **  ABSTRACT:  ** O  **      This module contains all the draw functions used by the banner program 3  **  to draw generic objects to the banner windows.   ** 
  **  AUTHORS:   **   **      Jim Saunders   **   ** +  **  CREATION DATE:     27th September 1989   **   **  MODIFICATION HISTORY:  **--   **/  /*   **   **  INCLUDE FILES  **   **/    *9D   #include <stdio.h> ,  #include <decw$include/DECwDwtWidgetProg.h> *9E  *9I      #include "stdio.h"   #include "MrmAppl.h"        *9E   #include "Banner"        /*   **   **  MACRO DEFINITIONS  **   **/     /* J   * Definitions of other static items we use throughout the banner program   * to reduce our setup times.     */    *15I  extern	 Son$_Blk    Son;  *15E  extern	 Bnr$_Blk    Bnr;   extern	 Clk$_Blk    Clk;   extern	 Mon$_Blk    Mon;   extern	 GC	     BannerGC; *2I   extern	 XGCValues   GcValues; *2E !  extern	 XEvent	     BannerEvent; $  extern	 char	     *BannerDayList[];    *2I  *6I  *7D (  extern   char	     BannerVmsNodeName[];'  extern   char	     BannerVmsVersion[];     *7E  *6E   void BannerPaintGraphics ();  *2E  *11I  void BannerPaintTextLines (); *11E  int  BannerWriteDatabase ();   void BannerWriteText ();   void BannerDigitalClock ();  void BannerWriteDate ();   void BannerWriteDate();    /*   **++   **  FUNCTIONAL DESCRIPTION:  **  *2I Q  **      BannerPaintGraphics (Display *display, Window *window,  int DisplaySize,    **	    int Cblock, int Refresh)  **   **  FORMAL PARAMETERS:   ** N  **      This routine paints all the lines in a graphic window. If Refresh is -  **  set it paints the constant info as well.   **   **  IMPLICIT INPUTS:   ** 
  **      none   **   **  IMPLICIT OUTPUTS:  ** 
  **      none   **   **  COMPLETION CODES:  ** 
  **      none   **   **  SIDE EFFECTS:  ** 
  **      none   **   **--   **/M  void	BannerPaintGraphics(Display *display, Window *window, int DisplaySize,  +  	    Display$_Line *Cblock[], int Refresh)   {      int x, x1, y, y1, i; $      Display$_Line *Line, *NextLine;     /* L   * First if Refresh is set, the paint the static information in the window.   */ *7I       Line = &Cblock[0];  *7E     *7D       if (Refresh)  *7E  *7I '      if (Refresh || Line->TitleChanged)  *7E   	{   	int range, start, fieldlen;      	Line = &Cblock[0];     	y = 2; *10D1  	fieldlen = XTextWidth(Bnr.font_ptr, "100%", 4);  *10E *10IH  	fieldlen = XTextWidth(Bnr.font_ptr, Line->tval4, strlen(Line->tval4)); *10E *6D 8  	x = Bnr.font_width + Line->MaxNamePoints + fieldlen/2; *6E  *6I :  	x = Bnr.font_width/2 + Line->MaxNamePoints + fieldlen/2; *6E (  	range =  DisplaySize - x - fieldlen/2;     /*    * Write percentage marks   */    *6I  *7I   	if (Line->highltitle) 1  		XSetForeground (display, BannerGC, Bnr.hwmrk);     *7E ;  	BannerWriteText (display, window, x, y + Bnr.font_height,  *7D #  	    BannerVmsNodeName, 2, range);  *7E  *7I   	    Line->Title, 2, range);    5  	XSetForeground (display, BannerGC, Bnr.foreground);     *7E     *6E (  	start = x + (range/4)*0 - fieldlen/2;	?  	BannerWriteText (display, window, start, y + Bnr.font_height,  *10D  	    "0%", 2, fieldlen);  *10E *10I!  	    Line->tval1, 2, fieldlen);   *10E(  	start = x + (range/4)*1 - fieldlen/2;	?  	BannerWriteText (display, window, start, y + Bnr.font_height,  *10D  	    "25%", 2, fieldlen);   *10E *10I!  	    Line->tval2, 2, fieldlen);   *10E *6D (  	start = x + (range/4)*2 - fieldlen/2;	 *6E  *6I *  /*	start = x + (range/4)*2 - fieldlen/2;	 *6E ?  	BannerWriteText (display, window, start, y + Bnr.font_height,  *6D   	    "50%", 2, fieldlen);   *6E  *6I   	    "50%", 2, fieldlen); */  *6E (  	start = x + (range/4)*3 - fieldlen/2;	?  	BannerWriteText (display, window, start, y + Bnr.font_height,  *10D  	    "75%", 2, fieldlen);   *10E *10I!  	    Line->tval3, 2, fieldlen);   *10E(  	start = x + (range/4)*4 - fieldlen/2;	?  	BannerWriteText (display, window, start, y + Bnr.font_height,  *10D  	    "100%", 2, fieldlen);  *10E *10I!  	    Line->tval4, 2, fieldlen);   *10E        	y = Bnr.font_height + 2;  	x = Bnr.font_width/2;  *16D     /*    * Now write statics headers    */	   	while (1)  *16E *16I  	}          /*   * Now write statics headers  */	      while (1)  	{   	int Lastline = 0;      	if (Line->LastLine == 1 )   	    Lastline = 1;         /* 2  * If this line is active then we have to paint it  */   	if (Line->LineActive == 1) *16E  	    {  *16D  	    int Lastline = 0;      	    if (Line->LastLine == 1 )   		Lastline = 1;    *16E *16I  /* ?  * Write the static info, and move our possition in the window.   */ '  	    if (Refresh || Line->NameChanged)   		{  		if (Line->highlname) 5  		    XSetForeground (display, BannerGC, Bnr.hwmrk);  *16E    *16D  /* 3   * If this line is active then we have to paint it    */   	    if (Line->LineActive == 1)  		{  /* @   * Write the static info, and move our possition in the window.   */ *16E<  		BannerWriteText (display, window, x, y + Bnr.font_height,,  		    Line->Name, 1, Line->MaxNamePoints);     *16D  		y = y + Bnr.font_height;   /*    * Move to the next line    */ *16E *16I6  		XSetForeground (display, BannerGC, Bnr.foreground); *16E *3D 3  		Line = (int)Line + (int)sizeof( Display$_Line);	  *3E   		} *3I  *16D6  	    Line = (int)Line + (int)sizeof( Display$_Line);	 *16E *3E  *16D  /*    * Last line?   */  	    if (Lastline == 1 ) 	  		break;  *16E *16I     	    Line->NameChanged = 0;     	    y = y + Bnr.font_height;  /*   * Move to the next line    */   	    } 2  	Line = (int)Line + (int)sizeof( Display$_Line);	  /* 
  * Last line?   */   	if (Lastline == 1 )   	    break; *16E  /*  *16DI   * If this is a half line, skip the next as its static info will be the  O   * same as it sharing this line of the display, unless its the last then exit.    */5  	    if (Line->HalfLine == 1 && Line->LastLine == 1) 	  		break;   	    if (Line->HalfLine == 1)2  		Line = (int)Line + (int)sizeof( Display$_Line); *16E *16IH  * If this is a half line, skip the next as its static info will be the N  * same as it sharing this line of the display, unless its the last then exit.  */ 1  	if (Line->HalfLine == 1 && Line->LastLine == 1)   	    break;  	if (Line->HalfLine == 1)5  	    Line = (int)Line + (int)sizeof( Display$_Line);  *16E    *16D  	    }  *16E *16I  	}  *16E    *16D  	}  *16E  /*    * Now paint the statistics   */             Line = &Cblock[0];          y1 = Bnr.font_height + 2;.      x = Bnr.font_width + Line->MaxNamePoints;$      DisplaySize =  DisplaySize - x;         while (1)  	{   	int Lastline = 0;  *3I ;  	int width, hlwidth, height, clearwidth, newhwmrk, clearx;  *3E      	if (Line->LastLine == 1 )  *5I   	    {  *5E   	    Lastline = 1;  *5D    6  	NextLine = (int)Line + (int)sizeof( Display$_Line);	 *5E  *5I   	    NextLine = Line;	   	    }   	else:  	    NextLine = (int)Line + (int)sizeof( Display$_Line);	 *5E   /* 3   * If this line is active then we have to paint it    */  	if (Line->LineActive == 1 )   	    {  *3D ?  	    int width, hlwidth, height, clearwidth, newhwmrk, clearx;  *3E      /*    * Calculate graphic height   */   9  	    if (Line->HalfLine == 1 || NextLine->HalfLine == 1) $  		height = (Bnr.font_height - 2)/2;
  	    else   		height = Bnr.font_height - 2;  		 
  	    y = y1;   	    if (Line->HalfLine == 1)(  		y = y1 + (Bnr.font_height - 2)/2 + 1;  /*    * Calculte draw widths	   */	       	    if (Line->MaxVal > 0) 3  		width = (DisplaySize*Line->CurVal)/Line->MaxVal; 
  	    else
  		width = 0;    "  	    if (width > DisplaySize - 2)  		width = DisplaySize - 2;     *3D F  /*	    if (width != Line->LastVal || Line->LastVal == 0 || Refresh)*/ *3E  *3I  *5D B  	    if (width != Line->LastVal || Line->LastVal == 0 || Refresh) *5E  *5I ]  	    if (width != Line->LastVal || width != Line->LastVal1 || Line->LastVal == 0 || Refresh)  *5E  *3E   		{  /* 5   * Calculate the width, and clear width of the item.    */        		if (width > Line->Hwmrk)   		    newhwmrk = width;  		else   		    newhwmrk = Line->Hwmrk;     		if (width >= Line->LastVal)%  		    clearwidth = newhwmrk - width;   		else -  		    clearwidth = newhwmrk - Line->LastVal;      		if (Line->Hwmrk == 0) *5I   		    { *5E (  		    clearwidth = DisplaySize - width; *5D      		if (Line->LastVal > width)   		    clearx = Line->LastVal;  		else  *5E   		    clearx = width; *5I   		    }  		else !  		    if (Line->LastVal > width)   			clearx = Line->LastVal;   		    else   			clearx = width;  *5E   /*    * Now paint the new area   */6  		XSetForeground (display, BannerGC, Bnr.foreground);6  		XSetBackground (display, BannerGC, Bnr.background);   1  		hlwidth = (DisplaySize*Bnr.sys_highlight)/100;   		if (width > hlwidth)   		    {'  		    XFillRectangle (display, window,   			BannerGC, x,    			y + 2,   *3D   			x + hlwidth, *3E  *3I   			hlwidth, *3E   			height);5  		    XSetForeground (display, BannerGC, Bnr.hwmrk); '  		    XFillRectangle (display, window,   			BannerGC, x + hlwidth,    			y + 2,   *3D   			x + width, *3E  *3I  *4D 
  			width, *4E  *4I   			width - hlwidth, *4E  *3E   			height);:  		    XSetForeground (display, BannerGC, Bnr.foreground); *15I  		    if (Line->Sound != NULL) 4  			BannerSound (Line->Sound, Son.Volume, Son.Time); *15E  		    }  		else '  		    XFillRectangle (display, window,   			BannerGC, x,    			y + 2,   *3D   			x + width, *3E  *3I 
  			width, *3E   			height);  /* !   * Now paint last time in Hashes    */  		if (Line->LastVal > width) #  		    if (Line->LastVal > hlwidth)   			{   			int startw; :  			XSetFillStyle (display, BannerGC, FillOpaqueStippled);  			startw = width;   			if (width < hlwidth)	  			    { (  			    XFillRectangle (display, window,  				BannerGC, x + startw,    				y + 2,  *3D   				x + hlwidth,e *3E  *3I"  				hlwidth - startw, *3EL
  				height);   			    startw = hlwidth;p	  			    } 2  			XSetForeground (display, BannerGC, Bnr.hwmrk);$  			XFillRectangle (display, window,  			    BannerGC, x + startw,   			    y + 2, h *3Dn  			    x + Line->LastVal, *3E  *3I   			    Line->LastVal - startw,* *3E*  			    height);1  			XSetFillStyle (display, BannerGC, FillSolid);I7  			XSetForeground (display, BannerGC, Bnr.foreground);   			}   		    elsen  			{s:  			XSetFillStyle (display, BannerGC, FillOpaqueStippled);$  			XFillRectangle (display, window,  			    BannerGC, x + width,    			    y + 2, e *3D   			    x + Line->LastVal, *3EN *3IS  			    Line->LastVal - width, *3En  			    height);1  			XSetFillStyle (display, BannerGC, FillSolid);r  			}u  /*u"   * Clear any of the old area left   */6  		XSetBackground (display, BannerGC, Bnr.foreground);6  		XSetForeground (display, BannerGC, Bnr.background);  	  		if (clearwidth > 0)'  		    XFillRectangle (display, window,r  			BannerGC, x + clearx,   			    y + 2,   *3Da  			    x + clearwidth,  *3E  *3I   			    clearwidth,a *3Em  			    height);   6  		XSetForeground (display, BannerGC, Bnr.foreground);6  		XSetBackground (display, BannerGC, Bnr.background);  /*n.   * Put the hight water mark in if we need to.   */*  		if (newhwmrk != Line->Hwmrk || Refresh)  		    {  		    GcValues.line_width = 2;n=  		    XChangeGC (display, BannerGC, GCLineWidth, &GcValues);   		       		    if (newhwmrk > hlwidth)2  			XSetForeground (display, BannerGC, Bnr.hwmrk);  *#  		    XDrawLine (display, window,    			BannerGC,  *3DS  			x + newhwmrk + 2, y + 2,  (  			x + newhwmrk + 2, y + height + 2);		 *3Ef *3Ii  			x + newhwmrk + 1, y + 2, t(  			x + newhwmrk + 1, y + height + 2);		 *3E :  		    XSetForeground (display, BannerGC, Bnr.foreground);     		    }  * *3D*  		Line->Hwmrk = newhwmrk;  		Line->LastVal = width;S *3EF *3I:  		if (!Refresh)  		    {  		    Line->Hwmrk = newhwmrk; *5Ih&  		    Line->LastVal1 = Line->LastVal; *5Ep  		    Line->LastVal = width;   		    } *3ER  		}  /*{   * Move to the next line    */5  	    Line = (int)Line + (int)sizeof( Display$_Line);f  /*eB   * If this isnt a half line, then move down a line on the screen.   */  	    if (Line->HalfLine != 1)"  		y1 = y1 + Bnr.font_height;	      	    }i  	else5  	    Line = (int)Line + (int)sizeof( Display$_Line);a     	if (Lastline == 1 )=  	    break;  	}	  }    /*   **++l  **  FUNCTIONAL DESCRIPTION:  **" *2E  *11IN  **      BannerPaintText (Display *display, Window *window,  int DisplayWidth,@  **	    int DisplayHeight, DisplayText$Lines Lines, int Refresh)  **   **  FORMAL PARAMETERS:t  **hN  **      This routine paints all the lines in a graphic window. If Refresh is -  **  set it paints the constant info as well.   **   **  IMPLICIT INPUTS:e  **h
  **      nonee  **g  **  IMPLICIT OUTPUTS:  **.
  **      none7  **	  **  COMPLETION CODES:  **d
  **      nonef  **e  **  SIDE EFFECTS:  **r
  **      none   **)  **--   **/L  void	BannerPaintTextLines(Display *display, Window *window, int DispWidth, <  	    int DispHeight, TextDisplay$_Line *Lines, int Refresh)  {      int x, y, i;r  t  /*    * Now write linesr   */	B  	i = y = 0;  	x = Bnr.font_height/2;  	while (1)1  	    {   	    int Lastline = 0;l  n"  	    if (Lines[i].LastLine == 1 )  		Lastline = 1;  a  r  /*T5   * If this line has changed then we have to paint itD   */0  	    if (Lines[i].text_changed == 1 || Refresh)  		{  /*i   * Should it me hightlighted?   */  		if (Lines[i].highlight)5  		    XSetForeground (display, BannerGC, Bnr.hwmrk);   /* @   * Write the static info, and move our possition in the window.   */<  		BannerWriteText (display, window, x, y + Bnr.font_height,2  		    Lines[i].Text, 1, Lines[0].MaxNamePoints);   2  		if (Lines[i].highlight)5  		    XSetForeground (display, BannerGC, Bnr.hwmrk);7  , *13D#  		if (strlen (Lines[i].Text1) > 0)v)  		    BannerWriteText (display, window, r   			x + Lines[0].MaxNamePoints,   			y + Bnr.font_height,0  			Lines[i].Text1, 1, Lines[0].MaxTextPoints);  *13E *13I%  		BannerWriteText (display, window,  #  		    x + Lines[0].MaxNamePoints, .  		    y + Bnr.font_height,o3  		    Lines[i].Text1, 1, Lines[0].MaxTextPoints); e *13E   6  		XSetForeground (display, BannerGC, Bnr.foreground);6  		XSetBackground (display, BannerGC, Bnr.background); *12I  		} *12E    *12D  		y = y + Bnr.font_height;  *12E *12I  	    y = y + Bnr.font_height; *12E  /*v    * Need to mopve to a new line?   */ *12D&  		if (y+Bnr.font_height > DispHeight)  		    {
  		    y = 0; ?  		    x = x + Lines[0].MaxNamePoints + Lines[0].MaxTextPoints;   		    } *12E *12I)  	    if (y+Bnr.font_height > DispHeight)h  		{	  		y = 0; ;  		x = x + Lines[0].MaxNamePoints + Lines[0].MaxTextPoints;h *12E  		}  /*    * Last line?   */  	    if (Lastline == 1 ) 	  		break;1
  	    i++;  	}t  /*i3   * Now clear anything else remaining on the screenf   */  i *17IF      y = y + 2;	/* Stops us erasing the underscore in the last line */  t *17E)      if (x < DispWidth && y < DispHeight)a  	{n5  	XSetBackground (display, BannerGC, Bnr.foreground);e5  	XSetForeground (display, BannerGC, Bnr.background);t"  	XFillRectangle (display, window,  	    BannerGC, x, 	  		y,   		DispWidth - x,a  		DispHeight - y);d:  	x = x + Lines[0].MaxNamePoints + Lines[0].MaxTextPoints;  	y = 0;  	if (x < DispWidth)&  	    XFillRectangle (display, window,  		BannerGC, x, 
  		    y,   		    DispWidth - x,n  		    DispHeight);a5  	XSetBackground (display, BannerGC, Bnr.background);>5  	XSetForeground (display, BannerGC, Bnr.foreground);/  	}*  }    /*n  **++e  **  FUNCTIONAL DESCRIPTION:  **i *11EK  **	BannerWriteText (display, window, xpos, ypos, str, position, fieldsize)   **	H  **      This routine writes the text string in the desired coordinates 4  **	in the specified window, using the current font.  **   **  FORMAL PARAMETERS:s  ** %  **      display		    Current displayi  **	window		    Current window  **	xpos		    X position  **	ypos		    Y position  **	str		    The output string#  **	Position	    1 = left Justified*  **			    2 = center Justified  **			    3 = right Justifiedb  **   **  IMPLICIT INPUTS:   **l  **      The Bnr block  **s  **  IMPLICIT OUTPUTS:  **	
  **      nonei  **   **  COMPLETION CODES:  **	
  **      nonef  **e  **  SIDE EFFECTS:  **i
  **      none+  **)  **--   **/  void	F  BannerWriteText(display, window, xpos, ypos, str, position, fieldlen)  Display *display;  Window *window;
  int xpos;
  int ypos;  char *str;]  int position;  int fieldlen;  { *5D '      int i, len, clypos, height, width;t *5E  *5Is-      int i, len, clypos, height, width, forg;) *5E       int size;      char *str_size; *5Ih  d     /*t@   * Remember the forground colour we were intended to write with   */  5(      forg = BannerGC->values.foreground;    *5E   /*tJ   * Set our font, as the current writting font, and strip the input string2   * so there are no leading spaces screwing it up.   */  n *5Ie    *5Ea      while (*str == ' ')  	  	str++; e          size = name_size (str) - 1;  /* $   * Kill any trailing spaces as well   */(  	while (size > 0 && str[size-1] == ' ')  	    {e  	    str[size-1] = '\0'; 
  	    size--;l  	    }i  /*gI   * now if the string is longer than the field length, cut the high order	$   * off before we try to display it.   */   1      len = XTextWidth (Bnr.font_ptr, str, size); 1      while (fieldlen < len)=  	{   	if (size == 0)  	    break; *14D  	str++;	  	size--;e *14E *14I  	if (position == 1)  	    {a  	    str[size-1] = '\0';p
  	    size--;u  	    }e  	else  	    {   	    str++;
  	    size--;   	    }t *14E.  	len = XTextWidth (Bnr.font_ptr, str, size);   	}   /*	K   * now find the number of Pixels we need to display the string, under the  ;   * current font, and calculate the start X, Y coordinates.0   */  s+      clypos = ypos - Bnr.font_ptr->ascent; V      height = Bnr.font_height; L  -  /*VA   * now select on the justification we need to do for the string.t   */      switch (position)      {         case 1:	/* Left Justify */   	  	{n  /*rL   * Draw the string left justified, Draw the string, and then clear the area*   * in the field size, which is left over.   */  	    width = fieldlen - len; 3  	    XDrawImageString (display, window, BannerGC,    		    xpos, ypos, str, size);  	    xpos = xpos + len;    	    XSetBackground (display, s  		    BannerGC,  		    Bnr.foreground);a  	    XSetForeground (display,    		    BannerGC,  		    Bnr.background);i&  	    XFillRectangle (display, window,*  		BannerGC, xpos, clypos, width, height);  	    XSetBackground (display, n  		    BannerGC,  		    Bnr.background);s  	    XSetForeground (display,    		    BannerGC,  		    Bnr.foreground);a  	    break;  	}h!      case 2:	/* Center justify */i  )  	{   /*iL   * Draw the string center justified, clear the area infront of the string, 3   * draw the string, then clear the area behind it.    */$  	    width = (fieldlen - len) / 2;   	    XSetBackground (display,    		    BannerGC,  		    Bnr.foreground);l  	    XSetForeground (display, C  		    BannerGC,  		    Bnr.background); &  	    XFillRectangle (display, window,*  		BannerGC, xpos, clypos, width, height);  	    XSetBackground (display, o  		    BannerGC,  		    Bnr.background);1  	    XSetForeground (display, L  		    BannerGC, *5Dn  		    Bnr.foreground);. *5E; *5IE
  		    forg);e *5E   	    xpos = xpos + width;3  	    XDrawImageString (display, window, BannerGC,    		    xpos, ypos, str, size);  	    xpos = xpos + len;    	    XSetBackground (display, H  		    BannerGC,  		    Bnr.foreground);   	    XSetForeground (display, d  		    BannerGC,  		    Bnr.background);l&  	    XFillRectangle (display, window,*  		BannerGC, xpos, clypos, width, height);  	    XSetBackground (display, F  		    BannerGC,  		    Bnr.background);G  	    XSetForeground (display, 3  		    BannerGC,  		    Bnr.foreground);w  	    break;  	}L       case 3:	/* Right Justify */  w  	{p  /*	G   * draw the string right justified, clear the area infront, then draw a   * the string.n   */  	    width = fieldlen - len;   	    XSetBackground (display,    		    BannerGC,  		    Bnr.foreground);>  	    XSetForeground (display,    		    BannerGC,  		    Bnr.background);r&  	    XFillRectangle (display, window,*  		BannerGC, xpos, clypos, width, height);  	    XSetBackground (display, l  		    BannerGC,  		    Bnr.background);d  	    XSetForeground (display, w  		    BannerGC, *5DC  		    Bnr.foreground);  *5Ee *5I 
  		    forg);i *5Ea  	    xpos = xpos + width;3  	    XDrawImageString (display, window, BannerGC, S  		    xpos, ypos, str, size);  	    break;  	}u      }  }    n  /*t  **++a  **  FUNCTIONAL DESCRIPTION:  **d)  **	BannerDigitalClock (display, window )F  **oO  **      This routine handles the display of the digital clock. It obtains the lI  **	current time stamp, in ASCII, and displays it at the coordinates for    **	the digital clock.  **   **  FORMAL PARAMETERS:a  **h%  **      display		The current displayF  **	window		The current window  **e  **  IMPLICIT INPUTS:o  **d4  **      The Bnr block, with the display coordinates  **   **  IMPLICIT OUTPUTS:  ** 
  **      nonew  **   **  COMPLETION CODES:  **	
  **      noneG  **e  **  SIDE EFFECTS:  ** 
  **      nonep  **B  **--,  **/  void	$  BannerDigitalClock(display, window)  Display *display;  Window *window;  {  ,      long timedesc[2];;      char timebuffer[] = "                               ";S  	  /* >   * Set up the Descriptor and call the VMS SYS$ASCTIM service.   */      timedesc[0] = 24;      timedesc[1] = &timebuffer;+0      SYS$ASCTIM (&timedesc, &timedesc, NULL, 1);  /*s#   * now make it pretty for the user    */      timebuffer[8] = '\0';      if (timebuffer[0] == '0')  	timebuffer[0] = ' ';  /*!F   * now write the time, removing the seconds if no seconds are wanted.   */     "      if (! Bnr.Param_Bits.seconds)  	{=  	    timebuffer[5] = '\0';}(  	    BannerWriteText (display, window,   		    Bnr.clock_height,<  		    (Bnr.clock_height / 2) - ((Bnr.font_height * 2) / 3),C  		    timebuffer, 2, XTextWidth(Bnr.font_ptr, "88-MMM-8888", 11));i  	} 	      else $  	BannerWriteText (display, window,   		    Bnr.clock_height,<  		    (Bnr.clock_height / 2) - ((Bnr.font_height * 2) / 3),C  		    timebuffer, 2, XTextWidth(Bnr.font_ptr, "88-MMM-8888", 11));T  }       /*   **++*  **  FUNCTIONAL DESCRIPTION:  **s%  **	BannerWriteDate (display, window),  **	N  **      The routine obains the current day, and date, and writes this to the   **	desired window.*  **   **  FORMAL PARAMETERS:t  **n$  **      display	    Current display  **	window	    Current windown  **o  **  IMPLICIT INPUTS:I  **I5  **      Bnr block, with the positioning information.U  **:  **  IMPLICIT OUTPUTS:  ** 
  **      none   **:  **  COMPLETION CODES:  ** 
  **      noneT  ***  **  SIDE EFFECTS:  ** 
  **      nonev  **a  **--n  **/  void	!  BannerWriteDate(display, window)D  Display *display;  Window *window;  {      int daynumber;       float daydiv;      long timedesc[2];=      char timebuffer[]    = "                              ";h  ;  /*hO   * Call the system service to find out the current day, and conver that to the1   * day of this week.a   */  T&      LIB$DAY (&daynumber, NULL, NULL);4      daynumber = daynumber - ((daynumber / 7) * 7);   /*1>   * Set up the Descriptor and call the VMS SYS$ASCTIM service.   */      i      timedesc[0] = 24;      timedesc[1] = &timebuffer;n3      SYS$ASCTIM (&timedesc, &timedesc, NULL, NULL);   /*o(   * now write out the day, and the date.   */      a      timebuffer[11] = '\0';i'      BannerWriteText (display, window, a  	Bnr.clock_height,	J  	(Bnr.clock_height / 2) - ((Bnr.font_height * 2) / 3) + Bnr.font_height, L  	BannerDayList[daynumber], 2, XTextWidth(Bnr.font_ptr, "88-MMM-8888", 11));  p'      BannerWriteText (display, window, o  	Bnr.clock_height,o9  	(Bnr.clock_height / 2) - ((Bnr.font_height * 2) / 3) +    	    (2 * Bnr.font_height), t>  	timebuffer, 2, XTextWidth(Bnr.font_ptr, "88-MMM-8888", 11));  y      Bnr.ws_purged = 0;   }    .  /*,   *++e
   *  NAME:
   *	name_sizeE   *    *  FUNCTIONAL DESCRIPTION:   *C   *      [@tbs@]   *X   *  FORMAL PARAMETERS:a   *C    *      [@description_or_none@]   *    *  IMPLICIT INPUTS:f   *e   *      None.   *	   *  IMPLICIT OUTPUTS:   *    *      None.   *t!   *  RETURNS or COMPLETION CODES:    *     *      [@description_or_none@]   *    *  SIDE EFFECTS:   *    *      None.   *N   *--t   */  [  M  int name_size(char *in_string)1  {  int i = 0;n  o  /*i   * count the size   */  	while (*in_string++ != '\0')  		i++;i     	i++;  M  /*t   * remove any trailing spaces   */  ?  	in_string--;"  	while (*in_string == ' ' && i>0)  	    {	  	    *in_string = '\0';  	    in_string--;
  	    i--;  	    }/
  return i;  }  =  +  	