  #module BannerHanoi "V1.0"      /*   **++   **  FACILITY:  ** &  **      The DECwindows Banner program  **   **  ABSTRACT:  ** E  **      This module contains all the code, to run the CPU histogram.   ** 
  **  AUTHORS:   **   **      JIM SAUNDERS   **   ** &  **  CREATION DATE:     20th June 1988  **   **  MODIFICATION HISTORY:  **--   **/        /*   **   **  INCLUDE FILES  **   **/    *4D   #include <stdio.h> ,  #include <decw$include/DECwDwtWidgetProg.h> *4E  *4I      #include "stdio.h"   #include "MrmAppl.h"        *4E   #include "Banner"        /*   **   **  MACRO DEFINITIONS  **   **/     /* #   * now our runtime data structures    */     extern	 Bnr$_Blk    Bnr;   extern	 Clk$_Blk    Clk;   extern	 GC	     BannerGC;  extern	 XGCValues   GcValues;   !  extern void BannerSignalError();    &  static int last_number_of_disks = -1;  static int hanoi_init = 0;      static int next_cycle = 1;   static int disk_cycle = 0;   static int wait = 1;   static int wait_cycle = 2;      static int nil = -1;      static int next_move = 0;   +  static Hanoi$_MoveVec *move_vector = NULL;   static int number_of_disks;  static int zero = 0; 8  static int tower_attribute_block, disk_attribute_block;>  static int tower_line_width, disk_line_width, disk_thickness,;  	   tower_bottom, tower_top, tower_shift, tower_base_size;    <  static int tower_left[3], tower_middle[3], tower_right[3],   	   tower_height[3];    G  static int *disk_left = NULL, *disk_right = NULL, *disk_height = NULL;     /*   **++   **  FUNCTIONAL DESCRIPTION:  ** 2  **	MoveDisk (k, x_increment, y_increment, tower);  ** *  **      This routine moves the k'th disk.  **   **  FORMAL PARAMETERS:   ** (  **      K - selects which disk to erase.  **	X_INCREMENT - added to disk's x coordinate.  **	Y_INCREMENT - added to disk's y coordinateD  **	TOWER - selects which spindle to redraw (vertical movement only)  **   **  IMPLICIT INPUTS:   ** 
  **      none   **   **  IMPLICIT OUTPUTS:  ** 
  **      none   **   **  COMPLETION CODES:  ** 
  **      none   **   **  SIDE EFFECTS:  ** 
  **      none   **   **--   **/
  static void	 -  MoveDisk(k, x_increment, y_increment, tower) (  int x_increment, y_increment, k, tower;  {&      int i, height, width, x, y, step;J      int current_left_x, current_right_x, current_bottom_y, current_top_y,          current_y; 4      int delta_x, delta_y, one_delta_x, one_delta_y;K      int new_left_x, new_right_x, new_y, new_top_y, new_bottom_y, n_pixels;       int left, right, up, down;      /* J   * Compute number of pixelone-pixel steps in the move, and the increments,   * to the x and y coordinates in each step.   */   !      n_pixels = abs(y_increment); "      left = right = up = down = 0;      step = 1; *3D        if (Bnr.cube_height/12 > 1)  	step = Bnr.cube_height/12; *3E  *3I !      if (Bnr.hanoi_height/12 > 1)   	step = Bnr.hanoi_height/12;  *3E              if (n_pixels == 0)   	{   	n_pixels = abs (x_increment); %  	one_delta_x = x_increment/n_pixels;   	one_delta_y = 0;  	delta_x = one_delta_x * step;   	delta_y = 0;  	right = (one_delta_x == 1);   	left = (one_delta_x == -1);   	one_delta_y = 0;  	} 	      else   	{   	one_delta_x = 0;.  	one_delta_y = y_increment/abs (y_increment);  	delta_x = 0;  	delta_y = one_delta_y * step;   	up = (one_delta_y == 1);  	down = (one_delta_y == -1);   	}   /* F   * Compute the current top, bottom, left, and right coordinates for a)   * rectangle that exactly fits the disk.    */   1      current_left_x = disk_left[k] - x_increment; 3      current_right_x = disk_right[k] - x_increment; .      current_y = disk_height[k] + y_increment;0      current_top_y = current_y - disk_thickness;3      current_bottom_y = current_y + disk_thickness;          i = 1;       while (i <= n_pixels)  	{ /  	if ((i + abs (delta_y + delta_x)) > n_pixels)   	    {   	    delta_y = one_delta_y;  	    delta_x = one_delta_x;  	    } !  	i = i + abs(delta_y + delta_x);   	/*+  	 * First, compute the disk's new location   	 */    (  	new_left_x = current_left_x + delta_x;*  	new_right_x = current_right_x + delta_x;  	new_y = current_y - delta_y;&  	new_top_y = current_top_y - delta_y;,  	new_bottom_y = current_bottom_y - delta_y;  	/*&  	 * Draw the disk in its new location  	 */ (  	GcValues.line_width = disk_line_width;K  	XChangeGC (XtDisplay(Bnr.main_widget), BannerGC, GCLineWidth, &GcValues);  *3D D  	XDrawLine (XtDisplay(Bnr.cube_widget), XtWindow (Bnr.cube_widget), *3E  *3I F  	XDrawLine (XtDisplay(Bnr.hanoi_widget), XtWindow (Bnr.hanoi_widget), *3E 7  	    BannerGC, new_left_x, new_y, new_right_x, new_y);  *3D ,  	XSync (XtDisplay(Bnr.cube_widget), FALSE); *3E  *3I -  	XSync (XtDisplay(Bnr.hanoi_widget), FALSE);  *3E   	/*A  	 * Erase the row of pixels from the old location.  For vertical :  	 * motion, replace the missing tower pixel if necessary.  	 */    	  	if (up)   	    { 5  	    width = abs (current_right_x - current_left_x); 5  	    height = abs (current_bottom_y - new_bottom_y);   	    x = current_left_x;   	    y = new_bottom_y;  *3D 3  	    XSetBackground (XtDisplay (Bnr.cube_widget),   *3E  *3I 4  	    XSetBackground (XtDisplay (Bnr.hanoi_widget),  *3E   		    BannerGC,  		    Bnr.foreground);  *3D 3  	    XSetForeground (XtDisplay (Bnr.cube_widget),   *3E  *3I 4  	    XSetForeground (XtDisplay (Bnr.hanoi_widget),  *3E   		    BannerGC,  		    Bnr.background);  *3D M  	    XFillRectangle (XtDisplay(Bnr.cube_widget), XtWindow (Bnr.cube_widget),  *3E  *3I O  	    XFillRectangle (XtDisplay(Bnr.hanoi_widget), XtWindow (Bnr.hanoi_widget),  *3E "  		BannerGC, x, y, width, height); *3D 3  	    XSetBackground (XtDisplay (Bnr.cube_widget),   *3E  *3I 4  	    XSetBackground (XtDisplay (Bnr.hanoi_widget),  *3E   		    BannerGC,  		    Bnr.background);  *3D 3  	    XSetForeground (XtDisplay (Bnr.cube_widget),   *3E  *3I 4  	    XSetForeground (XtDisplay (Bnr.hanoi_widget),  *3E   		    BannerGC,  		    Bnr.foreground); -  	    GcValues.line_width = tower_line_width; O  	    XChangeGC (XtDisplay(Bnr.main_widget), BannerGC, GCLineWidth, &GcValues); $  	    if (new_bottom_y >= tower_top) *3D E  		XDrawLine (XtDisplay(Bnr.cube_widget), XtWindow (Bnr.cube_widget),  *3E  *3I G  		XDrawLine (XtDisplay(Bnr.hanoi_widget), XtWindow (Bnr.hanoi_widget),  *3E 1  		    BannerGC, tower_middle[tower], tower_top,  .  		    tower_middle[tower], current_bottom_y); *3D 0  	    XSync (XtDisplay(Bnr.cube_widget), FALSE); *3E  *3I 1  	    XSync (XtDisplay(Bnr.hanoi_widget), FALSE);  *3E   	    }   	else  	    if (down)   		{2  		width = abs (current_right_x - current_left_x);2  		height = abs (new_bottom_y - current_bottom_y);  		x = current_left_x;  		y = current_top_y;  *3D 0  		XSetBackground (XtDisplay (Bnr.cube_widget),  *3E  *3I 1  		XSetBackground (XtDisplay (Bnr.hanoi_widget),   *3E   		    BannerGC,  		    Bnr.foreground);  *3D 0  		XSetForeground (XtDisplay (Bnr.cube_widget),  *3E  *3I 1  		XSetForeground (XtDisplay (Bnr.hanoi_widget),   *3E   		    BannerGC,  		    Bnr.background);  *3D J  		XFillRectangle (XtDisplay(Bnr.cube_widget), XtWindow (Bnr.cube_widget), *3E  *3I L  		XFillRectangle (XtDisplay(Bnr.hanoi_widget), XtWindow (Bnr.hanoi_widget), *3E &  		    BannerGC, x, y, width, height); *3D 0  		XSetBackground (XtDisplay (Bnr.cube_widget),  *3E  *3I 1  		XSetBackground (XtDisplay (Bnr.hanoi_widget),   *3E   		    BannerGC,  		    Bnr.background);  *3D 0  		XSetForeground (XtDisplay (Bnr.cube_widget),  *3E  *3I 1  		XSetForeground (XtDisplay (Bnr.hanoi_widget),   *3E   		    BannerGC,  		    Bnr.foreground); *  		GcValues.line_width = tower_line_width;L  		XChangeGC (XtDisplay(Bnr.main_widget), BannerGC, GCLineWidth, &GcValues);"  		if (current_top_y >= tower_top) *3D I  		    XDrawLine (XtDisplay(Bnr.cube_widget), XtWindow (Bnr.cube_widget),  *3E  *3I K  		    XDrawLine (XtDisplay(Bnr.hanoi_widget), XtWindow (Bnr.hanoi_widget),  *3E .  			BannerGC, tower_middle[tower], tower_top, '  			tower_middle[tower], new_bottom_y);  *3D -  		XSync (XtDisplay(Bnr.cube_widget), FALSE);  *3E  *3I .  		XSync (XtDisplay(Bnr.hanoi_widget), FALSE); *3E   		}
  	    else  		if (left)  		    {3  		    width = abs (current_right_x - new_right_x); 3  		    height = abs (current_bottom_y - new_top_y);   		    x = new_right_x;   		    y = new_top_y;  *3D 4  		    XSetBackground (XtDisplay (Bnr.cube_widget),  *3E  *3I 5  		    XSetBackground (XtDisplay (Bnr.hanoi_widget),   *3E 
  			BannerGC,   			Bnr.foreground); *3D 4  		    XSetForeground (XtDisplay (Bnr.cube_widget),  *3E  *3I 5  		    XSetForeground (XtDisplay (Bnr.hanoi_widget),   *3E 
  			BannerGC,   			Bnr.background); *3D N  		    XFillRectangle (XtDisplay(Bnr.cube_widget), XtWindow (Bnr.cube_widget), *3E  *3I P  		    XFillRectangle (XtDisplay(Bnr.hanoi_widget), XtWindow (Bnr.hanoi_widget), *3E #  			BannerGC, x, y, width, height);  *3D 4  		    XSetBackground (XtDisplay (Bnr.cube_widget),  *3E  *3I 5  		    XSetBackground (XtDisplay (Bnr.hanoi_widget),   *3E 
  			BannerGC,   			Bnr.background); *3D 4  		    XSetForeground (XtDisplay (Bnr.cube_widget),  *3E  *3I 5  		    XSetForeground (XtDisplay (Bnr.hanoi_widget),   *3E 
  			BannerGC,   			Bnr.foreground); *3D 1  		    XSync (XtDisplay(Bnr.cube_widget), FALSE);  *3E  *3I 2  		    XSync (XtDisplay(Bnr.hanoi_widget), FALSE); *3E   		    }  		else   		    {3  		    width = abs (new_right_x - current_right_x); 3  		    height = abs (current_bottom_y - new_top_y);   		    x = current_left_x;  		    y = new_top_y;  *3D 4  		    XSetBackground (XtDisplay (Bnr.cube_widget),  *3E  *3I 5  		    XSetBackground (XtDisplay (Bnr.hanoi_widget),   *3E 
  			BannerGC,   			Bnr.foreground); *3D 4  		    XSetForeground (XtDisplay (Bnr.cube_widget),  *3E  *3I 5  		    XSetForeground (XtDisplay (Bnr.hanoi_widget),   *3E 
  			BannerGC,   			Bnr.background); *3D N  		    XFillRectangle (XtDisplay(Bnr.cube_widget), XtWindow (Bnr.cube_widget), *3E  *3I P  		    XFillRectangle (XtDisplay(Bnr.hanoi_widget), XtWindow (Bnr.hanoi_widget), *3E #  			BannerGC, x, y, width, height);  *3DD4  		    XSetBackground (XtDisplay (Bnr.cube_widget),  *3E  *3Ii5  		    XSetBackground (XtDisplay (Bnr.hanoi_widget), m *3E*
  			BannerGC,S  			Bnr.background); *3DD4  		    XSetForeground (XtDisplay (Bnr.cube_widget),  *3E* *3I*5  		    XSetForeground (XtDisplay (Bnr.hanoi_widget), * *3E*
  			BannerGC,S  			Bnr.foreground); *3Dn1  		    XSync (XtDisplay(Bnr.cube_widget), FALSE);d *3Eo *3I 2  		    XSync (XtDisplay(Bnr.hanoi_widget), FALSE); *3Eh  		    }  	/*-  	 * Finally, update the current coordinates.M  	 */F  	 current_left_x = new_left_x; !  	 current_right_x = new_right_x;   	 current_y = new_y;_  	 current_top_y = new_top_y; #  	 current_bottom_y = new_bottom_y;   	}r  GcValues.line_width = 0; J  XChangeGC (XtDisplay(Bnr.main_widget), BannerGC, GCLineWidth, &GcValues);  }    /*   **++o  **  FUNCTIONAL DESCRIPTION:  **c/  **	Move (n, from_tower, to_tower, using_tower)   **aF  **      This routine moves N disk from from_tower, to to_tower, using&  **  using_tower as tomporary storage.  **$  **  FORMAL PARAMETERS:U  ** 
  **      noneb  **_  **  IMPLICIT INPUTS:o  ** 
  **      noneo  **t  **  IMPLICIT OUTPUTS:  **_
  **      none   **o  **  COMPLETION CODES:  **t
  **      nones  **	  **  SIDE EFFECTS:  **p
  **      nonet  **b  **--e  **/
  static void	o+  Move(n, from_tower, to_tower, using_tower) *  int n, from_tower, to_tower, using_tower;  {'      int vertical_shift, lateral_shift;i         /* A       * First move (.N - 1) disks to the USING_TOWER temporarily.(       */      if (n > 1),0  	Move (n-1, from_tower, using_tower, to_tower);      .%      move_vector[next_move].move = 1; .      move_vector[next_move].from = from_tower;*      move_vector[next_move].to = to_tower;0      move_vector[next_move].using = using_tower;)      move_vector[next_move].num_disk = n;r      next_move++;)      /**D       * Finally move the (.N - 1) smaller disks from the USING_TOWER       * to the TO_TOWER.       */      if (n > 1):0  	Move (n-1, using_tower, to_tower, from_tower);  }    /*   **++   **  FUNCTIONAL DESCRIPTION:  ** 4  **	MakeMove (n, from_tower, to_tower, using_tower);  **eL  **      This routine activates the actual move of a tower to another tower.  **c  **  FORMAL PARAMETERS:g  ** 
  **      noney  **r  **  IMPLICIT INPUTS:r  **y
  **      nonel  **   **  IMPLICIT OUTPUTS:  **t
  **      nonen  **f  **  COMPLETION CODES:  **t
  **      nonem  **_  **  SIDE EFFECTS:  **r
  **      none   **   **--   **/
  static void	i/  MakeMove(n, from_tower, to_tower, using_tower)s*  int n, from_tower, to_tower, using_tower;  {'      int vertical_shift, lateral_shift;)         /* !       * Now move the bottom disk.        */   %      vertical_shift = disk_height[n];=1      disk_height[n] = tower_top - disk_thickness;i6      vertical_shift = vertical_shift - disk_height[n];:      tower_height[from_tower] = tower_height[from_tower] +  	(disk_thickness * 3);_1      MoveDisk (n, 0, vertical_shift, from_tower);e;      lateral_shift = tower_shift * (to_tower - from_tower);d1      disk_left[n] = lateral_shift + disk_left[n];n3      disk_right[n] = lateral_shift + disk_right[n]; )      MoveDisk (n, lateral_shift, 0, nil);c%      vertical_shift = disk_height[n];n6      tower_height[to_tower] = tower_height[to_tower] -  	(disk_thickness * 3);	.      disk_height[n] = tower_height[to_tower] +  	(disk_thickness * 2);s6      vertical_shift = vertical_shift - disk_height[n];/      MoveDisk (n, 0, vertical_shift, to_tower);e  }    /*c  **++r  **  FUNCTIONAL DESCRIPTION:  **t  **  BannerHanopiSetup ()e  **k;  **      this sets up all the preset information for hanoi.n  **   **  FORMAL PARAMETERS:u  **_
  **      nonee  **   **  IMPLICIT INPUTS:w  **(
  **      none   **   **  IMPLICIT OUTPUTS:  **t
  **      nones  **	  **  COMPLETION CODES:  **e
  **      nonee  **   **  SIDE EFFECTS:  ** 
  **      nonee  **   **--_  **/  void	  BannerHanoiSetup()   {      int disk_indentation, i;	      float width;t  f *3D *      number_of_disks = Bnr.cube_height/12; *3E_ *3I	+      number_of_disks = Bnr.hanoi_height/12;u *3E_      if (number_of_disks < 3 )  	number_of_disks = 3;  _      tower_line_width = 0;         /*o       * Width of tower basen       */ *3Dl      width = Bnr.cube_width; *3EB *3Ii      width = Bnr.hanoi_width;h *3EV/      tower_base_size = ((width/3.0) * 0.8) - 2;i  t *3DW;      disk_line_width = Bnr.cube_height/(number_of_disks*2);B *3En *3Id<      disk_line_width = Bnr.hanoi_height/(number_of_disks*2); *3Ex/      disk_line_width = (disk_line_width/2) * 2;D(      disk_thickness = disk_line_width/2;         /*XC       * Compute Y-coordinates of the tops and bottoms of the towerso       */    *3Dl&      tower_bottom = Bnr.cube_height - =  	(Bnr.cube_height - (3 * disk_thickness * number_of_disks + f *3E  *3I '      tower_bottom = Bnr.hanoi_height - ->  	(Bnr.hanoi_height - (3 * disk_thickness * number_of_disks +  *3E_           disk_thickness))/3;   	G      tower_top = tower_bottom - (3 * disk_thickness * number_of_disks +i  	    disk_thickness);         /*r        * Distance between towers.       */         width = tower_base_size;o3      tower_shift = tower_base_size + (0.2 * width);b  i      /* B       * Compute X-coordinates of the endpoints of the tower lines.       */  n *3D,P      tower_left[0] = (Bnr.cube_width - (2 * tower_shift + tower_base_size)) / 2; *3Ei *3I(Q      tower_left[0] = (Bnr.hanoi_width - (2 * tower_shift + tower_base_size)) / 2;X *3Eo1      tower_left[1] = tower_left[0] + tower_shift;d1      tower_left[2] = tower_left[1] + tower_shift; 6      tower_right[0] = tower_left[0] + tower_base_size;3      tower_right[1] = tower_right[0] + tower_shift;,3      tower_right[2] = tower_right[1] + tower_shift;d:      tower_middle[0] = (tower_left[0] + tower_right[0])/2;5      tower_middle[1] = tower_middle[0] + tower_shift;n5      tower_middle[2] = tower_middle[1] + tower_shift;i         /*i3       * Y-coordinates of the top disk of each towert       */  G!      tower_height[0] = tower_top;(G      tower_height[1] = tower_height[2] = tower_bottom - disk_thickness;)  t      /*nG       * Allocate storage for the vectors of disk coordinates.  The 0'thX+       * element of each vector is not used.n       */  m1      if (last_number_of_disks != number_of_disks)e  	{u  	int size, i;  3)  	last_number_of_disks = number_of_disks;,  L  	size = 2;	  	  	/*5  	 * size = sizeof (Hanoi$_MoveVec) * ((2^n - 1) + 1)   	 */	&  	for (i=1;  i<=number_of_disks;  i++)  	    size = size * 2;  	'  	size = size * sizeof(Hanoi$_MoveVec);_     	if (move_vector != NULL)  	    free(move_vector);  	move_vector = malloc(size);g  n  	if (move_vector == NULL)  	    { ^  	    printf ("Failed to allocate memory for the Hanoi\n %d disks needs %d bytes of memory\n",  	    	number_of_disks, size);  	    exit (0);(  	    }w  e  	if (disk_left != NULL)  	    free(disk_left);1  	disk_left = malloc (4 * (number_of_disks + 1));B  b  	if (disk_height != NULL)  	    free(disk_height);3  	disk_height = malloc (4 * (number_of_disks + 1));   X  	if (disk_right != NULL)r  	    free(disk_right);(2  	disk_right = malloc (4 * (number_of_disks + 1));     	tower_attribute_block = 21;n  	disk_attribute_block = 22;  	}3      /* 7       * Place the disks in their initial configuration:        *nG       * Compute indentation of one disk with respect to the next larger.7       * disk (which will be immediately underneath it).(       */  g@      disk_indentation = (tower_base_size / number_of_disks) / 2;  .      /*h;       * Compute the initial coordinates of the bottom disk.)       */  C0      disk_left[number_of_disks] = tower_left[0];2      disk_right[number_of_disks] = tower_right[0];H      disk_height[number_of_disks] = tower_bottom - (disk_thickness * 2);      n+      for (i=number_of_disks-1;  i>=1;  i--)   	{ 3  	disk_left[i] = disk_left[i+1] + disk_indentation;	5  	disk_right[i] = disk_right[i+1] - disk_indentation;t9  	disk_height[i] = disk_height[i + 1] - 3*disk_thickness;t  	}a  Bnr.ws_purged = 0;F  hanoi_init=1;
  next_move=0;   move_vector[next_move].move=0;d  disk_cycle = 0;  next_cycle = wait = 1;   }    /*   **++c  **  FUNCTIONAL DESCRIPTION:  **   **	BannerHanoiRefresh ()   **n7  **      This routine repaints the current hanoi image.u  **d  **  FORMAL PARAMETERS:   **B
  **      nones  **(  **  IMPLICIT INPUTS:3  **	
  **      none	  **.  **  IMPLICIT OUTPUTS:  **e
  **      noneD  **y  **  COMPLETION CODES:  **3
  **      noneF  **o  **  SIDE EFFECTS:  **_
  **      none   **	  **--C  **/  void	  BannerHanoiRefresh()   {      int i;X  s      if (! hanoi_init)  	BannerHanoiSetup ();   ,      GcValues.line_width = tower_line_width;N      XChangeGC (XtDisplay(Bnr.main_widget), BannerGC, GCLineWidth, &GcValues);  i      /*3<       * Draw the three tower bases, then the three spindles.       */    *3DBH      XDrawLine (XtDisplay (Bnr.cube_widget), XtWindow (Bnr.cube_widget), *3Er *3I;J      XDrawLine (XtDisplay (Bnr.hanoi_widget), XtWindow (Bnr.hanoi_widget), *3EX9  	BannerGC, tower_left[0], tower_bottom, tower_right[0], a  	tower_bottom); *3DrH      XDrawLine (XtDisplay (Bnr.cube_widget), XtWindow (Bnr.cube_widget), *3E	 *3IXJ      XDrawLine (XtDisplay (Bnr.hanoi_widget), XtWindow (Bnr.hanoi_widget), *3E	9  	BannerGC, tower_left[1], tower_bottom, tower_right[1], h  	tower_bottom); *3DtH      XDrawLine (XtDisplay (Bnr.cube_widget), XtWindow (Bnr.cube_widget), *3E  *3I J      XDrawLine (XtDisplay (Bnr.hanoi_widget), XtWindow (Bnr.hanoi_widget), *3E 9  	BannerGC, tower_left[2], tower_bottom, tower_right[2], 	  	tower_bottom);    *3D H      XDrawLine (XtDisplay (Bnr.cube_widget), XtWindow (Bnr.cube_widget), *3Eo *3IXJ      XDrawLine (XtDisplay (Bnr.hanoi_widget), XtWindow (Bnr.hanoi_widget), *3E <  	BannerGC, tower_middle[0], tower_bottom, tower_middle[0], 
  	tower_top);, *3D H      XDrawLine (XtDisplay (Bnr.cube_widget), XtWindow (Bnr.cube_widget), *3E_ *3ItJ      XDrawLine (XtDisplay (Bnr.hanoi_widget), XtWindow (Bnr.hanoi_widget), *3Es<  	BannerGC, tower_middle[1], tower_bottom, tower_middle[1], 
  	tower_top);a *3DiH      XDrawLine (XtDisplay (Bnr.cube_widget), XtWindow (Bnr.cube_widget), *3En *3IDJ      XDrawLine (XtDisplay (Bnr.hanoi_widget), XtWindow (Bnr.hanoi_widget), *3Eo<  	BannerGC, tower_middle[2], tower_bottom, tower_middle[2], 
  	tower_top);(  i      /*.       * Now draw the disks.        */  X+      GcValues.line_width = disk_line_width;3N      XChangeGC (XtDisplay(Bnr.main_widget), BannerGC, GCLineWidth, &GcValues);  e)      for (i=1;  i<=number_of_disks;  i++)x *3DwC  	XDrawLine (XtDisplay(Bnr.cube_widget), XtWindow(Bnr.cube_widget),	 *3Ee *3ItE  	XDrawLine (XtDisplay(Bnr.hanoi_widget), XtWindow(Bnr.hanoi_widget),t *3Ea.  	    BannerGC, disk_left[i], disk_height[i], %  	    disk_right[i], disk_height[i]);T  A      GcValues.line_width = 0;(N      XChangeGC (XtDisplay(Bnr.main_widget), BannerGC, GCLineWidth, &GcValues);  o  }    /*   **++o  **  FUNCTIONAL DESCRIPTION:  **p  **  BannerHanoi ()   **F3  **      This is the main action routine for hanoi.I  **I  **  FORMAL PARAMETERS:   **o
  **      noneP  **   **  IMPLICIT INPUTS:   ** 
  **      noneM  **O  **  IMPLICIT OUTPUTS:  **s
  **      noneD  **E  **  COMPLETION CODES:  ***
  **      none/  **a  **  SIDE EFFECTS:  **_
  **      none,  **g  **--   **/  void	  BannerHanoi()  {  _      if (! hanoi_init)  	{_  	BannerHanoiSetup ();  	BannerHanoiRefresh();s  	}e  N!      if (wait && wait_cycle != 0)o  	{y  	wait_cycle --;	  	return;,  	}o	      elseo  	{e  	wait_cycle = 3;t  	wait = 0;.  	}   v      if (next_cycle)  	{1  	disk_cycle++;t  	next_cycle = 0;=  	next_move = 0;)  	if (disk_cycle == 1 || disk_cycle == 4)   	    {t  	    disk_cycle = 1;s&  	    Move (number_of_disks, 0, 1, 2);  	    }=  	else  	    if (disk_cycle == 2)#  		Move (number_of_disks, 1, 2, 0);l
  	    else  		if (disk_cycle == 3) '  		    Move (number_of_disks, 2, 0, 1);>   	move_vector[next_move].move=0;  	next_move=0;  	}    &  if (move_vector[next_move].move != 0)      {/      MakeMove (move_vector[next_move].num_disk,g  	move_vector[next_move].from,  	move_vector[next_move].to,   	move_vector[next_move].using);      next_move++;A      }  else       next_cycle=wait=1;   P  }