  #module BannerMonitor "V1.0"      /*   **++   **  FACILITY:  ** &  **      The DECwindows Banner program  **   **  ABSTRACT:  ** E  **      This module contains all the code, to run the CPU histogram.   ** 
  **  AUTHORS:   **   **      JIM SAUNDERS   **   ** &  **  CREATION DATE:     20th June 1988  **   **  MODIFICATION HISTORY:  **--   **/        /*   **   **  INCLUDE FILES  **   **/    *5D   #include <stdio.h>   #include <dvidef.h>,  #include <decw$include/DECwDwtWidgetProg.h> *5E  *5I      #include "stdio.h"   #include "dvidef.h"  #include "MrmAppl.h"        *5E   #include "Banner"        /*   **   **  MACRO DEFINITIONS  **   **/    *3I   int BannerDeviceCount();     *3E   #define SS$_NORMAL 1       typedef struct _vms_item_list {  	short	 buffer_length;   	short	 item_code;   	void	*buffer;   	int	*returned_buffer_length;  	} VMS_ItemList;      /* #   * now our runtime data structures    */     extern	 Bnr$_Blk    Bnr;   extern	 Clk$_Blk    Clk;   extern   Mon$_Blk    Mon;  extern	 GC	     BannerGC;  extern	 XGCValues   GcValues;   A  globalref int MON_V_NI_MNTVERIP, MON_V_NI_BUSY, MON_V_NI_SYS_MV;    J  static int OLD_MON_V_NI_MNTVERIP, OLD_MON_V_NI_BUSY, OLD_MON_V_NI_SYS_MV;   >  globalref int PMS$GL_PREADIO, PMS$GL_PWRITIO, PMS$GL_FAULTS, #  	   SCH$GL_MFYCNT, SCH$GL_FREECNT;    !  extern void BannerSignalError();    (  static int device_iocnt[3] = {0, 0, 0};'  static int device_rate[3] = {0, 0, 0}; )  static int device_lnblnk[3] = {0, 0, 0};    6  #define lnb_size (12 + 64)	/* Header + 64 bytes names#  				 *      ---------------------- #  				 * (0)  !   forward link     ! #  				 *      ---------------------- #  				 * (1)  !   Device unit count! #  				 *      ---------------------- #  				 * (2)  !   64-byte name     ! #  				 *      !                    ! #  				 *      !                    ! #  				 *      !                    ! #  				 *      ----------------------   				 */   %  static int lnb_pool[lnb_size * 100];    %  static char dua2_string[] = "DUA2:"; (  static int dua2[2] = {5, &dua2_string};%  static char dua1_string[] = "DUA1:"; (  static int dua1[2] = {5, &dua1_string};%  static char dua0_string[] = "DUA0:"; (  static int dua0[2] = {5, &dua0_string};        static int tw;   static int w5w;  static int w8w;  static int smp_size;   static int old_smp_size = 0;   static int remoteio_size;   0  static int Mon_update_count, Mon_update_number;  static int Mon_init = 0;     /*   **++   **  FUNCTIONAL DESCRIPTION:  **  *7D   **	Device_logicals   ** F  **      This routine expands a logical device name, into all its sub   **	components.   **   **  FORMAL PARAMETERS:   **    **      [@description_or_none@]  **   **  IMPLICIT INPUTS:   **    **      [@description_or_none@]  **   **  IMPLICIT OUTPUTS:  **    **      [@description_or_none@]  ** +  **  {@function_value_or_completion_codes@}   **    **      [@description_or_none@]  **   **  SIDE EFFECTS:  **    **      [@description_or_none@]  **   **--   **/  static void  device_logicals()  {  int i, j, pos; )  char buffer[256], device[256], count[4];   char *curpos,*seperator; &  int (*lnb)[], (*prev_lnb)[],next_lnb;  /* C   * got through each one of the disks and see what should be active #   * and parse the disk description.    */	  lnb = 0;   next_lnb = &lnb_pool;     i = 0;   while (i <= 2)       {      /* $       * Are we doing Dua0 this time?       */)      memset( buffer, 0, sizeof(buffer) );          if (i == 0 &&  	Mon.dua0 != 0)  	{ 6  	memcpy(&buffer, Bnr.disk_0, name_size(Bnr.disk_0) );  	}       /* $       * Are we doing Dua1 this time?       */      if (i == 1 &&  	Mon.dua1 != 0)  	{ 6  	memcpy(&buffer, Bnr.disk_1, name_size(Bnr.disk_1) );  	}       /* $       * Are we doing Dua2 this time?       */      if (i == 2 &&  	Mon.dua2 != 0)  	{ 6  	memcpy(&buffer, Bnr.disk_2, name_size(Bnr.disk_2) );  	}       /* <       * Know search the string, if we find a '%d' then this ;       * is a list of one or more disk of the form 'XQA%d:n'        */      j = 0;       if (buffer[0] != 0)  	curpos = &buffer; 	      else   	curpos = NULL;         seperator = NULL;         device_lnblnk[i] = 0;    "      prev_lnb = &device_lnblnk[i];      while (curpos != NULL)   	{   	char device[100];   	int count;  	char subbuffer[256];  /*    * look for a seperator ","   */%  	seperator = loc_sep( curpos, "," );   /*    * now save this device   */  	strcpy(subbuffer, curpos);  	strcpy(device, curpos);   	count = 0;  	curpos = seperator;    (  	seperator = loc_sep (subbuffer, "%d");  	if (seperator != NULL)  	    {   /* !   * this is a counted device type    */!  	    strcpy (device, subbuffer); '  	    sprintf(device, "%s%%d", device);   /*    * is the ':' there ?   */*  	    if (loc_sep(seperator, ":") != NULL)  		seperator++; .  	    count = strtol( seperator, NULL, NULL );  	    }	     /* @   * O.K we have a string, so start there and build a new LNB for   * this user.	   */	       	lnb = next_lnb;   	(*prev_lnb)[0] = lnb; !  	next_lnb = next_lnb + lnb_size;   	(*lnb)[0] = 0;  	(*lnb)[1] = count;/  	memcpy(&(*lnb)[2],device,name_size(device) );   	prev_lnb = lnb;   	}     	      i++;       }  }    /*   **++   **  FUNCTIONAL DESCRIPTION:  **  *7E   **	BannerMonSetup ()   ** M  **      This is the setup routine for the Banner monitor, it initialises all ;  **	the data structurtes for the monitor section of Banner.   **   **  FORMAL PARAMETERS:   ** 
  **      none   **   **  IMPLICIT INPUTS:   ** 
  **      none   **   **  IMPLICIT OUTPUTS:  ** 
  **      none   **   **  COMPLETION CODES:  ** 
  **      none   **   **  SIDE EFFECTS:  ** 
  **      none   **   **--   **/  void	  BannerMonSetup()   {  int nmsize;  /*    * setup standard text widths   */6      tw = XTextWidth(Bnr.font_ptr, "Free Pages ", 11);0      w5w = XTextWidth(Bnr.font_ptr, "88888", 5);3      w8w = XTextWidth(Bnr.font_ptr, "88888888", 8); >      remoteio_size = XTextWidth(Bnr.font_ptr, "RemoteIO ", 9);     /*    * set up disk names    */         if (Bnr.disk_0 != NULL)  	{ '  	dua0[0] = name_size (Bnr.disk_0) - 1;   	dua0[1] = Bnr.disk_0; 5  	nmsize = XTextWidth(Bnr.font_ptr, Bnr.disk_0_name,  #  		name_size(Bnr.disk_0_name) - 1);   	if (nmsize > tw) tw = nmsize;   	} 	      else   	{   	Bnr.disk_0 = dua0_string;    	Bnr.disk_0_name = dua0_string;  	}          if (Bnr.disk_1 != NULL)  	{ (  	dua1[0] = name_size (Bnr.disk_1) - 1;   	dua1[1] = Bnr.disk_1; 5  	nmsize = XTextWidth(Bnr.font_ptr, Bnr.disk_1_name,  #  		name_size(Bnr.disk_1_name) - 1);   	if (nmsize > tw) tw = nmsize;   	} 	      else   	{    	Bnr.disk_1_name = dua1_string;  	Bnr.disk_1 = dua1_string;   	}          if (Bnr.disk_2 != NULL)  	{ '  	dua2[0] = name_size (Bnr.disk_2) - 1;   	dua2[1] = Bnr.disk_2; 5  	nmsize = XTextWidth(Bnr.font_ptr, Bnr.disk_2_name,  #  		name_size(Bnr.disk_2_name) - 1);   	if (nmsize > tw) tw = nmsize;   	} 	      else   	{    	Bnr.disk_2_name = dua2_string;  	Bnr.disk_2 = dua2_string;   	}             Mon_update_count = 1;!      if (Bnr.monitor_update == 0) %  	Mon_update_number = Bnr.cpu_update; 	      else )  	Mon_update_number = Bnr.monitor_update;          device_logicals ();         Mon_init = 1;  }    /*   **++   **  FUNCTIONAL DESCRIPTION:  **   **	BannerMonRefresh ()   ** I  **      This routine rewrites all the static information display by the    **	Monitor section of Banner.  **   **  FORMAL PARAMETERS:   **   **   **  IMPLICIT INPUTS:   **   **   **  IMPLICIT OUTPUTS:  ** 
  **      none   **   **  COMPLETION CODES:  ** 
  **      none   **   **  SIDE EFFECTS:  ** 
  **      none   **   **--   **/  void	  BannerMonRefresh()   {&      int lx_pos, rx_pos, x_pos, y_pos;(      char string[] = "                ";         if (!Mon_init)   	BannerMonSetup ();         x_pos = Bnr.font_height/2;       y_pos = Bnr.font_height;    %      rx_pos = tw + Bnr.font_height/2; /      lx_pos = rx_pos + w5w + Bnr.font_height/2;          if (Mon.dua2)  	{ H  	BannerWriteText (XtDisplay(Bnr.mon_widget), XtWindow (Bnr.mon_widget),(  	    x_pos, y_pos, Bnr.disk_2_name, 1, 
  	    tw);  	if (device_iocnt[2] != 0)   	    { .  	    sprintf (string, "%d", device_rate[2]);   	    if (device_rate[2] != 0)I  		BannerWriteText (XtDisplay(Bnr.mon_widget), XtWindow (Bnr.mon_widget), !  		    rx_pos, y_pos, string, 3,    		    w5w);/  	    sprintf (string, "%d", device_iocnt[2]);  L  	    BannerWriteText (XtDisplay(Bnr.mon_widget), XtWindow (Bnr.mon_widget),  		lx_pos, y_pos, string, 3,    		w8w);  	    }   	else  	    { L  	    BannerWriteText (XtDisplay(Bnr.mon_widget), XtWindow (Bnr.mon_widget),  		rx_pos, y_pos, "*****", 3,   		w5w);L  	    BannerWriteText (XtDisplay(Bnr.mon_widget), XtWindow (Bnr.mon_widget),!  		lx_pos, y_pos, "********", 3,    		w8w);  	    } "  	y_pos = y_pos + Bnr.font_height;  	}          if (Mon.dua1)  	{ H  	BannerWriteText (XtDisplay(Bnr.mon_widget), XtWindow (Bnr.mon_widget),(  	    x_pos, y_pos, Bnr.disk_1_name, 1, 
  	    tw);  	if (device_iocnt[1] != 0)   	    { .  	    sprintf (string, "%d", device_rate[1]);   	    if (device_rate[1] != 0)I  		BannerWriteText (XtDisplay(Bnr.mon_widget), XtWindow (Bnr.mon_widget), !  		    rx_pos, y_pos, string, 3,    		    w5w);/  	    sprintf (string, "%d", device_iocnt[1]);  L  	    BannerWriteText (XtDisplay(Bnr.mon_widget), XtWindow (Bnr.mon_widget),  		lx_pos, y_pos, string, 3,    		    w8w);  	    }   	else  	    { L  	    BannerWriteText (XtDisplay(Bnr.mon_widget), XtWindow (Bnr.mon_widget),  		rx_pos, y_pos, "*****", 3,   		w5w);L  	    BannerWriteText (XtDisplay(Bnr.mon_widget), XtWindow (Bnr.mon_widget),!  		lx_pos, y_pos, "********", 3,    		w8w);  	    } "  	y_pos = y_pos + Bnr.font_height;  	}       if (Mon.dua0)  	{ H  	BannerWriteText (XtDisplay(Bnr.mon_widget), XtWindow (Bnr.mon_widget),(  	    x_pos, y_pos, Bnr.disk_0_name, 1, 
  	    tw);  	if (device_iocnt[0] != 0)   	    { .  	    sprintf (string, "%d", device_rate[0]);   	    if (device_rate[0] != 0)I  		BannerWriteText (XtDisplay(Bnr.mon_widget), XtWindow (Bnr.mon_widget),d!  		    rx_pos, y_pos, string, 3, R  		    w5w);/  	    sprintf (string, "%d", device_iocnt[0]); tL  	    BannerWriteText (XtDisplay(Bnr.mon_widget), XtWindow (Bnr.mon_widget),  		lx_pos, y_pos, string, 3, 0  		w8w);  	    }   	else  	    { L  	    BannerWriteText (XtDisplay(Bnr.mon_widget), XtWindow (Bnr.mon_widget),  		rx_pos, y_pos, "*****", 3,   		w5w);L  	    BannerWriteText (XtDisplay(Bnr.mon_widget), XtWindow (Bnr.mon_widget),!  		lx_pos, y_pos, "********", 3, "  		w8w);  	    }l"  	y_pos = y_pos + Bnr.font_height;  	}          if (Mon.ni_io)C  	{FH  	BannerWriteText (XtDisplay(Bnr.mon_widget), XtWindow (Bnr.mon_widget),#  	    x_pos, y_pos, "RemoteIO", 1, c
  	    tw);  	if (Mon.ni_io_value != 0)h  	    {r.  	    sprintf (string, "%d", Mon.ni_io_rate);   	    if (Mon.ni_io_rate != 0)I  		BannerWriteText (XtDisplay(Bnr.mon_widget), XtWindow (Bnr.mon_widget),r!  		    rx_pos, y_pos, string, 3,    		    w5w);/  	    sprintf (string, "%d", Mon.ni_io_value);  L  	    BannerWriteText (XtDisplay(Bnr.mon_widget), XtWindow (Bnr.mon_widget),  		lx_pos, y_pos, string, 3, s  		w8w);  	    }_  	else  	    {ML  	    BannerWriteText (XtDisplay(Bnr.mon_widget), XtWindow (Bnr.mon_widget),  		rx_pos, y_pos, "*****", 3,   		w5w);L  	    BannerWriteText (XtDisplay(Bnr.mon_widget), XtWindow (Bnr.mon_widget),!  		lx_pos, y_pos, "********", 3, i  		w8w);  	    }]"  	y_pos = y_pos + Bnr.font_height;  	}[  =      if (Mon.pio)#  	{eH  	BannerWriteText (XtDisplay(Bnr.mon_widget), XtWindow (Bnr.mon_widget),#  	    x_pos, y_pos, "Paging IO", 1,l
  	    tw);  	if (Mon.pageio != 0)  	    {-/  	    sprintf (string, "%d", Mon.pageio_rate);    	    if (Mon.pageio_rate != 0)	I  		BannerWriteText (XtDisplay(Bnr.mon_widget), XtWindow (Bnr.mon_widget),	!  		    rx_pos, y_pos, string, 3, 	  		    w5w);*  	    sprintf (string, "%d", Mon.pageio); L  	    BannerWriteText (XtDisplay(Bnr.mon_widget), XtWindow (Bnr.mon_widget),  		lx_pos, y_pos, string, 3,  		w8w);  	    }u  	else  	    {_L  	    BannerWriteText (XtDisplay(Bnr.mon_widget), XtWindow (Bnr.mon_widget),  		rx_pos, y_pos, "*****", 3,   		w5w);L  	    BannerWriteText (XtDisplay(Bnr.mon_widget), XtWindow (Bnr.mon_widget),!  		lx_pos, y_pos, "********", 3, ;  		w8w);  	    }i"  	y_pos = y_pos + Bnr.font_height;  	}a         if (Mon.sysflt)  	{aH  	BannerWriteText (XtDisplay(Bnr.mon_widget), XtWindow (Bnr.mon_widget),%  	    x_pos, y_pos, "Sys Faults", 1, I
  	    tw);  	if (Mon.sysfault != 0)  	    { 1  	    sprintf (string, "%d", Mon.sysfault_rate); ,!  	    if (Mon.sysfault_rate != 0) I  		BannerWriteText (XtDisplay(Bnr.mon_widget), XtWindow (Bnr.mon_widget),*   		    rx_pos, y_pos, string, 3,  		    w5w);,  	    sprintf (string, "%d", Mon.sysfault); L  	    BannerWriteText (XtDisplay(Bnr.mon_widget), XtWindow (Bnr.mon_widget),  		lx_pos, y_pos, string, 3,  		w8w);  	    }_  	else  	    { L  	    BannerWriteText (XtDisplay(Bnr.mon_widget), XtWindow (Bnr.mon_widget),  		rx_pos, y_pos, "*****", 3,   		w5w);L  	    BannerWriteText (XtDisplay(Bnr.mon_widget), XtWindow (Bnr.mon_widget),!  		lx_pos, y_pos, "********", 3, n  		w8w);  	    } "  	y_pos = y_pos + Bnr.font_height;  	}   t      if (Mon.pf)  	{ H  	BannerWriteText (XtDisplay(Bnr.mon_widget), XtWindow (Bnr.mon_widget),!  	    x_pos, y_pos, "Faults", 1,  
  	    tw);  	if (Mon.fault != 0)g  	    {s.  	    sprintf (string, "%d", Mon.fault_rate);   	    if (Mon.fault_rate != 0)I  		BannerWriteText (XtDisplay(Bnr.mon_widget), XtWindow (Bnr.mon_widget),i   		    rx_pos, y_pos, string, 3,  		    w5w);)  	    sprintf (string, "%d", Mon.fault); &L  	    BannerWriteText (XtDisplay(Bnr.mon_widget), XtWindow (Bnr.mon_widget),  		lx_pos, y_pos, string, 3,  		w8w);  	    }s  	else  	    { L  	    BannerWriteText (XtDisplay(Bnr.mon_widget), XtWindow (Bnr.mon_widget),  		rx_pos, y_pos, "*****", 3,   		w5w);L  	    BannerWriteText (XtDisplay(Bnr.mon_widget), XtWindow (Bnr.mon_widget),!  		lx_pos, y_pos, "********", 3, d  		w8w);  	    } "  	y_pos = y_pos + Bnr.font_height;  	}p  =      if (Mon.mp)  	{ H  	BannerWriteText (XtDisplay(Bnr.mon_widget), XtWindow (Bnr.mon_widget),#  	    x_pos, y_pos, "Modified", 1, k
  	    tw);  	if (Mon.mfycnt != 0)  	    {h/  	    sprintf (string, "%d", Mon.mfycnt_rate); 2  	    if (Mon.mfycnt_rate != 0)tI  		BannerWriteText (XtDisplay(Bnr.mon_widget), XtWindow (Bnr.mon_widget),i   		    rx_pos, y_pos, string, 3,  		    w5w);*  	    sprintf (string, "%d", Mon.mfycnt); L  	    BannerWriteText (XtDisplay(Bnr.mon_widget), XtWindow (Bnr.mon_widget),  		lx_pos, y_pos, string, 3,    		w8w);  	    }   	else  	    {/L  	    BannerWriteText (XtDisplay(Bnr.mon_widget), XtWindow (Bnr.mon_widget),  		rx_pos, y_pos, "*****", 3,   		w5w);L  	    BannerWriteText (XtDisplay(Bnr.mon_widget), XtWindow (Bnr.mon_widget),!  		lx_pos, y_pos, "********", 3, 	  		w8w);  	    } "  	y_pos = y_pos + Bnr.font_height;  	}d  n      if (Mon.fp)  	{eH  	BannerWriteText (XtDisplay(Bnr.mon_widget), XtWindow (Bnr.mon_widget),%  	    x_pos, y_pos, "Free Pages", 1, ;
  	    tw);  	if (Mon.freecnt != 0)n  	    {i0  	    sprintf (string, "%d", Mon.freecnt_rate);    	    if (Mon.freecnt_rate != 0)I  		BannerWriteText (XtDisplay(Bnr.mon_widget), XtWindow (Bnr.mon_widget),(!  		    rx_pos, y_pos, string, 3, p  		    w5w);+  	    sprintf (string, "%d", Mon.freecnt); hL  	    BannerWriteText (XtDisplay(Bnr.mon_widget), XtWindow (Bnr.mon_widget),  		lx_pos, y_pos, string, 3,  		w8w);  	    }I  	else  	    { L  	    BannerWriteText (XtDisplay(Bnr.mon_widget), XtWindow (Bnr.mon_widget),  		rx_pos, y_pos, "*****", 3,   		w5w);L  	    BannerWriteText (XtDisplay(Bnr.mon_widget), XtWindow (Bnr.mon_widget),!  		lx_pos, y_pos, "********", 3,    		w8w);  	    }n"  	y_pos = y_pos + Bnr.font_height;  	}d  }    /*t  **++e  **  FUNCTIONAL DESCRIPTION:  **t *7D.  **	loc_sep (string, seperator)=  **t-  **      This locates a sub string in string.t  **i  **  FORMAL PARAMETERS:p  **R   **      [@description_or_none@]  **s  **  IMPLICIT INPUTS:   **B   **      [@description_or_none@]  **a  **  IMPLICIT OUTPUTS:  **	   **      [@description_or_none@]  **t+  **  {@function_value_or_completion_codes@}m  **e   **      [@description_or_none@]  **>  **  SIDE EFFECTS:  **    **      [@description_or_none@]  **t  **--   **/  static int	  loc_sep(str, sep)  char *str, *sep;s  {
  int size, i;   u       size = name_size (sep) - 1;      u)      while (strncmp(str, sep, size) != 0)(  	{o  	str++;  	if (*(str + size) == '\0')  	    return 0;   	}       for (i=0;  i<size;  i++)e  	{	  	*str = '\0';  	str++;  	}k      return str;  }    /*i  **++d  **  FUNCTIONAL DESCRIPTION:  **r *7E_ *3DN  **	device_count (indx)a *3Ez *3Ir *6D_"  **	BannerDeviceCount (indx, flag) *6Ei *6IX *7Di)  **	BannerDeviceCount (indx, flag, error)m *7Ee *6Ed *3E_ *7D   ** L  **      This rouitne accumilates the IO counts for one of our device lists.  **2  **  FORMAL PARAMETERS:d  **t   **      [@description_or_none@]  **o  **  IMPLICIT INPUTS:m  **r   **      [@description_or_none@]  **n  **  IMPLICIT OUTPUTS:  **	   **      [@description_or_none@]  ** +  **  {@function_value_or_completion_codes@}i  **    **      [@description_or_none@]  **A  **  SIDE EFFECTS:  **	   **      [@description_or_none@]  **i  **--n  **/ *7Ea *3De  static int	  device_count(indx)  *3E	 *3Io *6Dt"  int BannerDeviceCount(indx, type) *6EE *6I  *7D )  int BannerDeviceCount(indx, type, error)* *7EP *6E  *3ET *7D*
  int indx; *7E  *6I  *7D 
  int type;  int *error; *7E  *6En *7D*  {+      int iocnt, total_iocnt, (*lnb)[], len;  *7E- *6D*      VMS_ItemList itmlst[2] = { -  	4, DVI$_OPCNT, &iocnt, &len, 0, 0 , 0, 0};    a *6Ei *6I= *7D       int errorcnt;      VMS_ItemList itmlst[3] = {S  	4, DVI$_OPCNT, &iocnt, &len, n"  	4, DVI$_ERRCNT, &errorcnt, &len,  	0, 0 , 0, 0};   _         if (error != NULL) 
  	*error = 0;  *7Es *6Ew *2Ir *7D_  /*t#   * Do we want IOCNT or Freeblocks?	   */ *7ET *3DX'      if (Bnr.Param_Bits.freeiocnt == 1)o *3Eg *3I  *7D       if (type == 1)k *7Em *3E  *7D #  	itmlst[0].item_code = DVI$_OPCNT; 	      else	 *7Ep *3D (  	itmlst[0].item_code = DVI$_FREEBLOCKS; *3Ei *3It *7D!  	if (type == 2)*  	    itmlst[0].item_code = DVI$_MAXBLOCK;  	else,  	    itmlst[0].item_code = DVI$_FREEBLOCKS; *7E  *3Ew *7D	    *7Et *2Er *7D"      total_iocnt = 0;       lnb = device_lnblnk[indx];y  /*m*   * know go through all the devices listed   */  p      while (lnb != NULL)  	{   	int device[2];     	if ((*lnb)[1] > 0 )   	    {y  	    int i;#  	    for (i=0;  i<(*lnb)[1];  i++)_  		{  		char buffer [50];  		int status;  r"  		sprintf(buffer, &(*lnb)[2], i);&  		device[0] = name_size (buffer) - 1;  		device[1] = &buffer; <  		status = SYS$GETDVIW (NULL, NULL, &device, &itmlst, NULL,  		    NULL, NULL, NULL);   		if (status == 1)X *7El *6Ir *7Dw  		    { *7Ew *6E. *7Di)  		    total_iocnt = total_iocnt + iocnt;, *7E  *6I  *7D   		    if (error != NULL)   			*error = *error + errorcnt;,  		    }  		else1  		    if (error != NULL)[  			*error = *error + 1; *7Et *6Ea *7D.  		}  	    }W  	else  	    {d  	    int status;o  y-  	    device[0] = name_size (&(*lnb)[2]) - 1;   	    device[1] = &(*lnb)[2];;?  	    status = SYS$GETDVIW (NULL, NULL, &device, &itmlst, NULL,n  		NULL, NULL, NULL);o  	    if (status == 1) *7E  *6I; *7D   		{ *7Ee *6E  *7D %  		total_iocnt = total_iocnt + iocnt;n *7Ee *6It *7Dw  		if (error != NULL)r"  		    *error = *error + errorcnt;  		}
  	    else  		if (error != NULL)n  		    *error = *error + 1;i *7E, *6El *7D,  	    }*  	lnb = (*lnb)[0];  	}   return total_iocnt;  }    /*t  **++;  **  FUNCTIONAL DESCRIPTION:  **	 *7Er  **	device_display  **mP  **      Counts the number of IO's for one particular device specification list.  **   **  FORMAL PARAMETERS:0  **0  **      idx	0:2
  **	lx_pos	  **	x_pos,	  **	y_pose  **   **  IMPLICIT INPUTS:[  **    **      [@description_or_none@]  **o  **  IMPLICIT OUTPUTS:  **w   **      [@description_or_none@]  ** +  **  {@function_value_or_completion_codes@}d  **v   **      [@description_or_none@]  **   **  SIDE EFFECTS:  **)   **      [@description_or_none@]  **,  **--   **/  void	*  device_display(idx, lx_pos, x_pos, y_pos)  int idx, lx_pos, x_pos, y_pos;n  {       int iocnt, rate, temp, len;(      char string[] = "                ";    *3Dn       iocnt = device_count (idx); *3E  *3Id *6Dn?      iocnt = BannerDeviceCount (idx, Bnr.Param_Bits.freeiocnt);  *6E  *6IoE      iocnt = BannerDeviceCount (idx, Bnr.Param_Bits.freeiocnt, NULL);a *6Er *3Ex&      rate = iocnt - device_iocnt[idx];"      if (rate != device_rate[idx])  	{m  	device_rate[idx] = rate;   	sprintf (string, "%d", rate);   	if (rate == 0)2  	    BannerWriteText (XtDisplay(Bnr.mon_widget),   		XtWindow(Bnr.mon_widget),  		x_pos, y_pos, "     ", 3, X  		w5w);  	else 	    2  	    BannerWriteText (XtDisplay(Bnr.mon_widget),   		XtWindow(Bnr.mon_widget),  		x_pos, y_pos, string, 3,   		w5w);  	}X$      if (iocnt != device_iocnt[idx])  	{_  	device_iocnt[idx] = iocnt;   	sprintf (string, "%d", iocnt);.  	BannerWriteText (XtDisplay(Bnr.mon_widget),   	    XtWindow(Bnr.mon_widget),o   	    lx_pos, y_pos, string, 3,   	    w8w);w  	}   }    /*r  **++   **  FUNCTIONAL DESCRIPTION:  **w  **	BannerMon ()  **l9  **      This routine runs the Monitor display of banner.   **o  **  FORMAL PARAMETERS:[  ** 
  **      noneo  **	  **  IMPLICIT INPUTS:X  **l
  **      nonee  **t  **  IMPLICIT OUTPUTS:  ** 
  **      none   **n  **  COMPLETION CODES:  **(
  **      none)  **   **  SIDE EFFECTS:  **n
  **      noneg  **a  **--   **/  void	  BannerMon()  {1      int rate, temp, x_pos, y_pos, lx_pos, iocnt;W(      char string[] = "                ";  s      if (!Mon_init)   	BannerMonRefresh ();  n      Mon_update_count --;       if (Mon_update_count > 0)	  	return;)  	*      Mon_update_count = Mon_update_number;  i   $      x_pos = tw + Bnr.font_height/2;.      lx_pos = x_pos + w5w + Bnr.font_height/2;      y_pos = Bnr.font_height;,  	      iocnt = 0;*  /*,   * First Dua2:	   */      if (Mon.dua2)  	{B+  	device_display (2, lx_pos, x_pos, y_pos);	"  	y_pos = y_pos + Bnr.font_height;  	};  /*    * Next Dua1:   */      if (Mon.dua1)  	{ +  	device_display (1, lx_pos, x_pos, y_pos);T"  	y_pos = y_pos + Bnr.font_height;  	}(  /*o
   * Next Dua0    */      if (Mon.dua0)  	{,+  	device_display (0, lx_pos, x_pos, y_pos); "  	y_pos = y_pos + Bnr.font_height;  	}s  /*_   * Next Remote IO   */      if (Mon.ni_io)	  	{e  	iocnt = REMOTE_IO_COUNT ();i!  	rate = iocnt - Mon.ni_io_value;   	if (rate != Mon.ni_io_rate),  	    {w  	    Mon.ni_io_rate = rate;$  	    sprintf (string, "%d", rate);   	    if (rate == 0)/  		BannerWriteText (XtDisplay(Bnr.mon_widget), ,   		    XtWindow(Bnr.mon_widget),!  		    x_pos, y_pos, "     ", 3, r  		    w5w);  	    else 	    /  		BannerWriteText (XtDisplay(Bnr.mon_widget), s   		    XtWindow(Bnr.mon_widget),   		    x_pos, y_pos, string, 3,   		    w5w);  /*n/   * force any flag bits to be repainted as welln   */  	    OLD_MON_V_NI_SYS_MV = -1;   	    }h  	if (iocnt != Mon.ni_io_value))  	    {	  	    Mon.ni_io_value = iocnt;$  	    sprintf (string, "%d", iocnt);2  	    BannerWriteText (XtDisplay(Bnr.mon_widget),   		XtWindow(Bnr.mon_widget),  		lx_pos, y_pos, string, 3, M  		w8w);  	    }	,  	if (OLD_MON_V_NI_SYS_MV != MON_V_NI_SYS_MV0  	||  OLD_MON_V_NI_MNTVERIP != MON_V_NI_MNTVERIP)  	||  OLD_MON_V_NI_BUSY != MON_V_NI_BUSY)   	    {w  	    char foo[10] = "";  	    int size;;   "  	    if ( MON_V_NI_SYS_MV != 0 ||  		 MON_V_NI_MNTVERIP != 0 ||_  		 MON_V_NI_BUSY != 0)s$  		 sprintf (foo, "%s%s", foo, "(");  		   	    if (MON_V_NI_SYS_MV != 0)D#  		sprintf (foo, "%s%s", foo, "S");.!  	    if (MON_V_NI_MNTVERIP != 0)*#  		sprintf (foo, "%s%s", foo, "M");T  	    if (MON_V_NI_BUSY != 0) #  		sprintf (foo, "%s%s", foo, "P");,  p"  	    if ( MON_V_NI_SYS_MV != 0 ||  		 MON_V_NI_MNTVERIP != 0 ||t  		 MON_V_NI_BUSY != 0)i$  		 sprintf (foo, "%s%s", foo, ")");  sC  	    smp_size = XTextWidth(Bnr.font_ptr, foo, name_size(foo) - 1);       e  	    size = smp_size;  	    if (old_smp_size > size)  		size=old_smp_size;"  ,2  	    BannerWriteText (XtDisplay(Bnr.mon_widget),   		XtWindow(Bnr.mon_widget),5  		remoteio_size + Bnr.font_height/2, y_pos, foo, 1,  	  		size);p     	    old_smp_size = smp_size;,  	    OLD_MON_V_NI_SYS_MV = MON_V_NI_SYS_MV;0  	    OLD_MON_V_NI_MNTVERIP = MON_V_NI_MNTVERIP;(  	    OLD_MON_V_NI_BUSY = MON_V_NI_BUSY;  	    } "  	y_pos = y_pos + Bnr.font_height;  	}   /*n   * piox   */  l      if (Mon.pio)   	{d)  	temp = PMS$GL_PREADIO + PMS$GL_PWRITIO;*  	rate = temp - Mon.pageio;n  	if (rate != Mon.pageio_rate)  	    {t  	    Mon.pageio_rate = rate;_$  	    sprintf (string, "%d", rate);   	    if (rate == 0)/  		BannerWriteText (XtDisplay(Bnr.mon_widget), f   		    XtWindow(Bnr.mon_widget),!  		    x_pos, y_pos, "     ", 3, .  		    w5w);  	    else 	    /  		BannerWriteText (XtDisplay(Bnr.mon_widget), n   		    XtWindow(Bnr.mon_widget),   		    x_pos, y_pos, string, 3,   		    w5w);  	    }_  	if (temp != Mon.pageio)e  	    {p  	    Mon.pageio = temp;#  	    sprintf (string, "%d", temp);,2  	    BannerWriteText (XtDisplay(Bnr.mon_widget),   		XtWindow(Bnr.mon_widget),  		lx_pos, y_pos, string, 3, y  		w8w);  	    }t"  	y_pos = y_pos + Bnr.font_height;  	}s  /*i
   * sys pf   */      if (Mon.sysflt)  	{ "  	temp = BANNER_KERNEL_SYSFLTS ();  	rate = temp - Mon.sysfault;_   	if (rate != Mon.sysfault_rate)  	    {	  	    Mon.sysfault_rate = rate;D$  	    sprintf (string, "%d", rate);   	    if (rate == 0)/  		BannerWriteText (XtDisplay(Bnr.mon_widget), 	   		    XtWindow(Bnr.mon_widget),!  		    x_pos, y_pos, "     ", 3, N  		    w5w);  	    else 	    /  		BannerWriteText (XtDisplay(Bnr.mon_widget),     		    XtWindow(Bnr.mon_widget),   		    x_pos, y_pos, string, 3,   		    w5w);  	    }s  	if (temp != Mon.sysfault)   	    {   	    Mon.sysfault = temp;#  	    sprintf (string, "%d", temp);I2  	    BannerWriteText (XtDisplay(Bnr.mon_widget),   		XtWindow(Bnr.mon_widget),  		lx_pos, y_pos, string, 3, *  		w8w);  	    }n"  	y_pos = y_pos + Bnr.font_height;  	}   /*    * pf   */      if (Mon.pf)  	{*#  	rate = PMS$GL_FAULTS - Mon.fault;r  	if (rate != Mon.fault_rate)   	    {,  	    Mon.fault_rate = rate;$  	    sprintf (string, "%d", rate);   	    if (rate == 0)/  		BannerWriteText (XtDisplay(Bnr.mon_widget), )   		    XtWindow(Bnr.mon_widget),!  		    x_pos, y_pos, "     ", 3, r  		    w5w);  	    else 	    /  		BannerWriteText (XtDisplay(Bnr.mon_widget),     		    XtWindow(Bnr.mon_widget),   		    x_pos, y_pos, string, 3,   		    w5w);  	    }e!  	if (PMS$GL_FAULTS != Mon.fault)i  	    {n   	    Mon.fault = PMS$GL_FAULTS;,  	    sprintf (string, "%d", PMS$GL_FAULTS);2  	    BannerWriteText (XtDisplay(Bnr.mon_widget),   		XtWindow(Bnr.mon_widget),  		lx_pos, y_pos, string, 3, d  		w8w);  	    }]"  	y_pos = y_pos + Bnr.font_height;  	}   /*[   *mpp   */      if (Mon.mp)  	{P$  	rate = SCH$GL_MFYCNT - Mon.mfycnt;  	if (rate != Mon.mfycnt_rate)  	    {a  	    Mon.mfycnt_rate = rate; $  	    sprintf (string, "%d", rate);   	    if (rate == 0)/  		BannerWriteText (XtDisplay(Bnr.mon_widget), *   		    XtWindow(Bnr.mon_widget),!  		    x_pos, y_pos, "     ", 3, o  		    w5w);  	    else 	    /  		BannerWriteText (XtDisplay(Bnr.mon_widget), u   		    XtWindow(Bnr.mon_widget),   		    x_pos, y_pos, string, 3,   		    w5w);  	    }i"  	if (SCH$GL_MFYCNT != Mon.mfycnt)  	    {c!  	    Mon.mfycnt = SCH$GL_MFYCNT;7,  	    sprintf (string, "%d", SCH$GL_MFYCNT);2  	    BannerWriteText (XtDisplay(Bnr.mon_widget),   		XtWindow(Bnr.mon_widget),  		lx_pos, y_pos, string, 3, 3  		w8w);  	    }P"  	y_pos = y_pos + Bnr.font_height;  	}e  /*n   * fp   */      if (Mon.fp)  	{ &  	rate = SCH$GL_FREECNT - Mon.freecnt;  	if (rate != Mon.freecnt_rate)   	    {t  	    Mon.freecnt_rate = rate;$  	    sprintf (string, "%d", rate);   	    if (rate == 0)/  		BannerWriteText (XtDisplay(Bnr.mon_widget),     		    XtWindow(Bnr.mon_widget),!  		    x_pos, y_pos, "     ", 3, t  		    w5w);  	    else 	    /  		BannerWriteText (XtDisplay(Bnr.mon_widget), t   		    XtWindow(Bnr.mon_widget),   		    x_pos, y_pos, string, 3,   		    w5w);  	    } $  	if (SCH$GL_FREECNT != Mon.freecnt)  	    {c#  	    Mon.freecnt = SCH$GL_FREECNT;d-  	    sprintf (string, "%d", SCH$GL_FREECNT); 2  	    BannerWriteText (XtDisplay(Bnr.mon_widget),   		XtWindow(Bnr.mon_widget),  		lx_pos, y_pos, string, 3, n  		w8w);  	    }0"  	y_pos = y_pos + Bnr.font_height;  	}f  }