 *5D   #module BannerPE "V1.0" *5E  *5I   #module BannerPE "V2.1" *5E      /*   **++   **  FACILITY:  ** &  **      The DECwindows Banner program  **   **  ABSTRACT:  ** D  **      This module contains all the code, to run the Lavc monitor.  ** 
  **  AUTHORS:   **   **      JIM SAUNDERS   **   ** &  **  CREATION DATE:     20th June 1988  **   **  MODIFICATION HISTORY: *5D   **--  *5E  *5I   ** D  **      V02-1   LPL0001        Lee Leahy                14 Oct 1991H  **              Changed the display to show LAN adapter utilization andL  **              errors, and display virtual circuit utilization and errors.9  **              The PE counters are no longer displayed.   ** (  **              LAN Adapter UtilizationK  **                  Error count - The number of transmit errors using this K  **                      LAN adapter.  Highlighted if error rate exceeds a  *  **                      threashold value.I  **                  Adapter name - LAN adapter name.  Highlighted if the B  **                      LAN adapter is unavailable for NISCA use.H  **                  % of LAN - NISCA protocol utilization (transmit andE  **                      receive) of this LAN adapter as a percentage 6  **                      of the maximum LAN bandwidth.J  **                  Adapter utilization graph - Transmit utilization as aM  **                      percentage of the total NISCA traffic for this node. M  **                      Receive utilization (highlighted) as a percentage of L  **                      the total NISCA traffic for this node.  CombinationJ  **                      for all adapters will be less than 100% since theG  **                      local loopback adapter (BUS) is not displayed.   ** ,  **              Virtual Circuit UtilizationO  **                  Retransmit error count - Number of messages retransmitted  N  **                      to this remote node.  This error count is highlightedN  **                      if the combined (retransmit + re-receive) error rate 4  **                      exceeds a threashold value.O  **                  Re-receive error count - Number of messages received again P  **                      from this remote node.  This error count is highlightedN  **                      if the combined (retransmit + re-receive) error rate 4  **                      exceeds a threashold value.D  **                  SCS node name - Node name of the remote system.H  **                  % of LAN - NISCA protocol utilization (transmit andI  **                      receive) of this virtual circuit as a percentage H  **                      of the maximum LAN bandwidth available to this D  **                      node (total bandwidth of all LAN adapters).N  **                  Virtual circuit traffic graph - Transmit utilization as aM  **                      percentage of the total NISCA traffic for this node. M  **                      Receive utilization (highlighted) as a percentage of L  **                      the total NISCA traffic for this node.  CombinationO  **                      for all nodes will be less than 100% since total NISCA C  **                      traffic includes channel control messages.   ** 7  **      V02-0   TEC200         T Coughlan		23-Aug-1991 F  **              Update the PE counters to match the current driver.  D  **              (Modifications to file obtained from: BANNER003.A.)  **  *5E   **/        /*   **   **  INCLUDE FILES  **   **/    *4D   #include <stdio.h>   #include <syidef.h>,  #include <decw$include/DECwDwtWidgetProg.h> *4E  *4I  *5D      #include "stdio.h"   #include "syidef.h"  #include "MrmAppl.h"        *5E  *5I   #include <stdio.h>   #include <syidef.h>,  #include <decw$include/DECwDwtWidgetProg.h> *5E  *4E   #include "Banner" *5D     *5E  *5I   #include "BANNER_PE"   #include "PEM_DEF"   #include "LANUDEF"  *5E      /*   **   **  MACRO DEFINITIONS  **   **/     #define SS$_NORMAL 1       typedef struct _vms_item_list {  	short	 buffer_length;   	short	 item_code;   	void	*buffer;   	int	*returned_buffer_length;  	} VMS_ItemList;      /* #   * now our runtime data structures    */     extern	 Bnr$_Blk    Bnr;   extern   pem$_Blk    pem;  extern   pes$_Blk    pes;  extern	 GC	     BannerGC;  extern	 XGCValues   GcValues;   !  globalref   pes$_Blk    new_pes;     *5I >  globaldef struct PE_BUS	    BUS_ARRAY [ PE_BUS$C_BUS_COUNT ];:  globaldef struct PE_VC	    VC_ARRAY [ PE_VC$C_VC_COUNT ]; *5E    !  extern void BannerSignalError();      static int tw;  *5I   static int w2w; *5E   static int w5w;  static int w8w; *5I   static int bus_error_width;  static int bus_name_width;   static int bus_percent_width;H  static int bus_graph_0_width, bus_graph_100_width, bus_graph_min_width;  static int vc_rexmt_width;   static int vc_rercv_width;   static int vc_name_width;  static int vc_percent_width; E  static int vc_graph_0_width, vc_graph_100_width, vc_graph_min_width;   static int tx_width, rx_width;      static int vc_error_rate = 0; *5E    .  static int pe_update_count, pe_update_number;  static int pe_init = 0;    /*   **++   **  FUNCTIONAL DESCRIPTION:  **   **	BannerPESetup ()  ** M  **      This is the setup routine for the Banner monitor, it initialises all ;  **	the data structurtes for the monitor section of Banner.   **   **  FORMAL PARAMETERS:   ** 
  **      none   **   **  IMPLICIT INPUTS:   ** 
  **      none   **   **  IMPLICIT OUTPUTS:  ** 
  **      none   **   **  COMPLETION CODES:  ** 
  **      none   **   **  SIDE EFFECTS:  ** 
  **      none   **   **--   **/  void	  BannerPESetup()  {  int nmsize;  /*    * setup standard text widths   */ *5D 6      tw = XTextWidth(Bnr.font_ptr, "Node Count ", 11); *5E  *5I >      tw = XTextWidth(Bnr.font_ptr, "NewPathNoticeDlvrd ", 19);-      w2w = XTextWidth(Bnr.font_ptr, "88", 2);  *5E 0      w5w = XTextWidth(Bnr.font_ptr, "88888", 5);3      w8w = XTextWidth(Bnr.font_ptr, "88888888", 8);     *5I @      bus_error_width = XTextWidth ( Bnr.font_ptr, "888888", 6 );&      vc_rexmt_width = bus_error_width;&      vc_rercv_width = bus_error_width;=      bus_name_width = XTextWidth ( Bnr.font_ptr, "Name", 4 ); @      vc_name_width = XTextWidth ( Bnr.font_ptr, "SCS Node", 8 );D      bus_percent_width = XTextWidth ( Bnr.font_ptr, "% of LAN", 8 );*      vc_percent_width = bus_percent_width;=      bus_graph_0_width = XTextWidth ( Bnr.font_ptr, "0", 1 ); *      vc_graph_0_width = bus_graph_0_width;A      bus_graph_100_width = XTextWidth ( Bnr.font_ptr, "100", 3 ); .      vc_graph_100_width = bus_graph_100_width;5      tx_width = XTextWidth ( Bnr.font_ptr, "Tx", 2 ); 5      rx_width = XTextWidth ( Bnr.font_ptr, "Rx", 2 ); _      bus_graph_min_width = bus_graph_0_width + tx_width + w2w + rx_width + bus_graph_100_width; .      vc_graph_min_width = bus_graph_min_width; *5E          pe_update_count = 1;       if (Bnr.pe_update == 0)$  	pe_update_number = Bnr.cpu_update;	      else #  	pe_update_number = Bnr.pe_update;          pe_init = 1;   }    /*   **++   **  FUNCTIONAL DESCRIPTION:  **   **	BannerPERefresh ()  ** I  **      This routine rewrites all the static information display by the    **	Monitor section of Banner.  **   **  FORMAL PARAMETERS:   **   **   **  IMPLICIT INPUTS:   **   **   **  IMPLICIT OUTPUTS:  ** 
  **      none   **   **  COMPLETION CODES:  ** 
  **      none   **   **  SIDE EFFECTS:  ** 
  **      none   **   **--   **/  void	  BannerPERefresh()  {&      int lx_pos, rx_pos, x_pos, y_pos;(      char string[] = "                ";         if (!pe_init)  	BannerPESetup ();     *5I   /*     *5E       x_pos = Bnr.font_height/2;       y_pos = Bnr.font_height;    %      rx_pos = tw + Bnr.font_height/2; /      lx_pos = rx_pos + w5w + Bnr.font_height/2;      	{ F  	BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget), *5D !  	    x_pos, y_pos, "PE Xmt", 1,  
  	    tw);  	if (pem.xmt != 0)   	    { ,  	    sprintf (string, "%d", pem.xmt_rate);   	    if (pem.xmt_rate != 0)G  		BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget), !  		    rx_pos, y_pos, string, 3,    		    w5w);'  	    sprintf (string, "%d", pem.xmt);  J  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, string, 3,    		    w8w);  	    }   	else  	    { J  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		rx_pos, y_pos, " ", 3,   		w5w);J  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, "0", 3,   		w8w);  	    } "  	y_pos = y_pos + Bnr.font_height;  	}      	{ F  	BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),!  	    x_pos, y_pos, "PE Rcv", 1,  
  	    tw);  	if (pem.rcv != 0)   	    { ,  	    sprintf (string, "%d", pem.rcv_rate);   	    if (pem.rcv_rate != 0)G  		BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget), !  		    rx_pos, y_pos, string, 3,    		    w5w);'  	    sprintf (string, "%d", pem.rcv);  J  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, string, 3,    		    w8w);  	    }   	else  	    { J  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		rx_pos, y_pos, " ", 3,   		w5w);J  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, "0", 3,   		w8w);  	    } "  	y_pos = y_pos + Bnr.font_height;  	}      	{ F  	BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),!  	    x_pos, y_pos, "Kbytes", 1,  
  	    tw);  	if (pem.kbyte != 0)   	    { .  	    sprintf (string, "%d", pem.kbyte_rate);   	    if (pem.kbyte_rate != 0)G  		BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget), !  		    rx_pos, y_pos, string, 3,    		    w5w);)  	    sprintf (string, "%d", pem.kbyte);  J  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, string, 3,    		w8w);  	    }   	else  	    { J  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		rx_pos, y_pos, "", 3,    		w5w);J  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, "0", 3,   		w8w);  	    }:"  	y_pos = y_pos + Bnr.font_height;  	}      	{ F  	BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),!  	    x_pos, y_pos, "Retries", 1,E
  	    tw);  	if (pem.retry != 0)D  	    { .  	    sprintf (string, "%d", pem.retry_rate);   	    if (pem.retry_rate != 0)G  		BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),h!  		    rx_pos, y_pos, string, 3,    		    w5w);)  	    sprintf (string, "%d", pem.retry); iJ  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, string, 3,  		w8w);  	    }*  	else  	    { J  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		rx_pos, y_pos, " ", 3,   		w5w);J  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, "0", 3,   		w8w);  	    }g"  	y_pos = y_pos + Bnr.font_height;  	}   N  	{tF  	BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),#  	    x_pos, y_pos, "PipeFull", 1, *
  	    tw);  	if (pem.pipefull != 0)  	    {p1  	    sprintf (string, "%d", pem.pipefull_rate); h!  	    if (pem.pipefull_rate != 0) G  		BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),    		    rx_pos, y_pos, string, 3,  		    w5w);,  	    sprintf (string, "%d", pem.pipefull); J  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, string, 3,  		w8w);  	    }m  	else  	    { J  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		rx_pos, y_pos, " ", 3,   		w5w);J  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, "0", 3,   		w8w);  	    } "  	y_pos = y_pos + Bnr.font_height;  	}      	{ F  	BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),#  	    x_pos, y_pos, "Timeouts", 1, e
  	    tw);  	if (pem.timeout != 0)*  	    { 1  	    sprintf (string, "%d", pem.timeout_rate );  !  	    if (pem.timeout_rate  != 0) G  		BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),m   		    rx_pos, y_pos, string, 3,  		    w5w);+  	    sprintf (string, "%d", pem.timeout); mJ  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, string, 3, S  		w8w);  	    }a  	else  	    {sJ  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		rx_pos, y_pos, " ", 3,   		w5w);J  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, "0", 3,   		w8w);  	    } "  	y_pos = y_pos + Bnr.font_height;  	}o  l  	{ F  	BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),%  	    x_pos, y_pos, "Misc Event", 1,  
  	    tw);  	if (pem.miscerr != 0)a  	    {t0  	    sprintf (string, "%d", pem.miscerr_rate);    	    if (pem.miscerr_rate != 0)G  		BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),C!  		    rx_pos, y_pos, string, 3,    		    w5w);+  	    sprintf (string, "%d", pem.miscerr); *J  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, string, 3,  		w8w);  	    }1  	else  	    { J  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		rx_pos, y_pos, " ", 3,   		w5w);J  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, "0", 3,   		w8w);  	    }l"  	y_pos = y_pos + Bnr.font_height;  	}E  w  	{eF  	BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),%  	    x_pos, y_pos, "Node Count", 1,  
  	    tw);+  	sprintf (string, "%d", pem.badchk_rate); l *5Ed *5In$  	    x_pos, y_pos, "PathCount", 1, 
  	    tw);  	if (pem.vc_cnt != 0)  	    {#/  	    sprintf (string, "%d", pem.vc_cnt_rate); l  	    if (pem.vc_cnt_rate != 0)*G  		BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),t!  		    rx_pos, y_pos, string, 3, h  		    w5w);*  	    sprintf (string, "%d", pem.vc_cnt); J  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, string, 3, /  		    w8w);  	    }   	else  	    { J  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		rx_pos, y_pos, " ", 3,   		w5w);J  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, "0", 3,   		w8w);  	    }c"  	y_pos = y_pos + Bnr.font_height;  	};  5  	{ F  	BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),(  	    x_pos, y_pos, "NewPathFormed", 1, 
  	    tw);  	if (pem.ret_id_attempts != 0);  	    { 8  	    sprintf (string, "%d", pem.ret_id_attempts_rate); (  	    if (pem.ret_id_attempts_rate != 0)G  		BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),r!  		    rx_pos, y_pos, string, 3, i  		    w5w);3  	    sprintf (string, "%d", pem.ret_id_attempts);  J  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, string, 3,    		    w8w);  	    }n  	else  	    {,J  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		rx_pos, y_pos, " ", 3,   		w5w);J  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, "0", 3,   		w8w);  	    }t"  	y_pos = y_pos + Bnr.font_height;  	}   R  	{AF  	BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),-  	    x_pos, y_pos, "NewPathNoticeDlvrd", 1,  
  	    tw);  	if (pem.ret_ids_sent != 0)  	    { 5  	    sprintf (string, "%d", pem.ret_ids_sent_rate);  %  	    if (pem.ret_ids_sent_rate != 0)BG  		BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget), !  		    rx_pos, y_pos, string, 3, f  		    w5w);0  	    sprintf (string, "%d", pem.ret_ids_sent); J  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, string, 3, X  		    w8w);  	    }   	else  	    { J  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		rx_pos, y_pos, " ", 3,   		w5w);J  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, "0", 3,   		w8w);  	    }h"  	y_pos = y_pos + Bnr.font_height;  	}a  w  	{=F  	BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),%  	    x_pos, y_pos, "KbytesSent", 1,  
  	    tw);  	if (pem.xmt_bytes != 0)_  	    { 2  	    sprintf (string, "%d", pem.xmt_bytes_rate); "  	    if (pem.xmt_bytes_rate != 0)G  		BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),1!  		    rx_pos, y_pos, string, 3,    		    w5w);-  	    sprintf (string, "%d", pem.xmt_bytes); _J  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, string, 3, a  		    w8w);  	    }   	else  	    {bJ  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		rx_pos, y_pos, " ", 3,   		w5w);J  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, "0", 3,   		w8w);  	    }_"  	y_pos = y_pos + Bnr.font_height;  	}N  O  	{EF  	BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),#  	    x_pos, y_pos, "PktsSent", 1, p
  	    tw);  	if (pem.xmt_msg != 0)B  	    {*0  	    sprintf (string, "%d", pem.xmt_msg_rate);    	    if (pem.xmt_msg_rate != 0)G  		BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget), !  		    rx_pos, y_pos, string, 3, F  		    w5w);+  	    sprintf (string, "%d", pem.xmt_msg); BJ  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, string, 3,    		    w8w);  	    }a  	else  	    { J  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		rx_pos, y_pos, " ", 3,   		w5w);J  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, "0", 3,   		w8w);  	    }t"  	y_pos = y_pos + Bnr.font_height;  	}   o  	{pF  	BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),+  	    x_pos + w2w, y_pos, "DGpktsSent", 1, f
  	    tw);  	if (pem.xmt_unseq != 0)t  	    {a2  	    sprintf (string, "%d", pem.xmt_unseq_rate); "  	    if (pem.xmt_unseq_rate != 0)G  		BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),X!  		    rx_pos, y_pos, string, 3, B  		    w5w);-  	    sprintf (string, "%d", pem.xmt_unseq);  J  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, string, 3, r  		    w8w);  	    }   	else  	    {aJ  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		rx_pos, y_pos, " ", 3,   		w5w);J  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, "0", 3,   		w8w);  	    },"  	y_pos = y_pos + Bnr.font_height;  	}   w  	{	F  	BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),+  	    x_pos + w2w, y_pos, "VCpktsSent", 1, i
  	    tw);  	if (pem.xmt_seq != 0)i  	    {.0  	    sprintf (string, "%d", pem.xmt_seq_rate);    	    if (pem.xmt_seq_rate != 0)G  		BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),W!  		    rx_pos, y_pos, string, 3, y  		    w5w);+  	    sprintf (string, "%d", pem.xmt_seq);  J  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, string, 3, 	  		    w8w);  	    }t  	else  	    {BJ  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		rx_pos, y_pos, " ", 3,   		w5w);J  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, "0", 3,   		w8w);  	    }y"  	y_pos = y_pos + Bnr.font_height;  	}=     	{ F  	BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),-  	    x_pos + w2w, y_pos, "LoneACKsSent", 1, .
  	    tw);  	if (pem.xmt_ack != 0)   	    {r0  	    sprintf (string, "%d", pem.xmt_ack_rate);    	    if (pem.xmt_ack_rate != 0)G  		BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),t!  		    rx_pos, y_pos, string, 3,    		    w5w);+  	    sprintf (string, "%d", pem.xmt_ack);  J  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, string, 3, t  		    w8w);  	    }_  	else  	    { J  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		rx_pos, y_pos, " ", 3,   		w5w);J  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, "0", 3,   		w8w);  	    } "  	y_pos = y_pos + Bnr.font_height;  	}p  t  	{rF  	BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),,  	    x_pos + w2w, y_pos, "Retransmits", 1, 
  	    tw);  	if (pem.xmt_rexmt != 0)   	    {,2  	    sprintf (string, "%d", pem.xmt_rexmt_rate); "  	    if (pem.xmt_rexmt_rate != 0)G  		BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),g!  		    rx_pos, y_pos, string, 3, 	  		    w5w);-  	    sprintf (string, "%d", pem.xmt_rexmt); nJ  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, string, 3, ,  		    w8w);  	    }t  	else  	    {pJ  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		rx_pos, y_pos, " ", 3,   		w5w);J  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, "0", 3,   		w8w);  	    } "  	y_pos = y_pos + Bnr.font_height;  	}p  l  	{eF  	BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),,  	    x_pos, y_pos, "KbytesRcvd,VCopen", 1, 
  	    tw);  	if (pem.rcv_bytes != 0)w  	    { 2  	    sprintf (string, "%d", pem.rcv_bytes_rate); "  	    if (pem.rcv_bytes_rate != 0)G  		BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget), !  		    rx_pos, y_pos, string, 3, r  		    w5w);-  	    sprintf (string, "%d", pem.rcv_bytes); ,J  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, string, 3, i  		    w8w);  	    }s  	else  	    {wJ  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		rx_pos, y_pos, " ", 3,   		w5w);J  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, "0", 3,   		w8w);  	    } "  	y_pos = y_pos + Bnr.font_height;  	}   f  	{.F  	BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),*  	    x_pos, y_pos, "PktsRcvd,VCopen", 1, 
  	    tw);  	if (pem.rcv_msg != 0)i  	    {n0  	    sprintf (string, "%d", pem.rcv_msg_rate);    	    if (pem.rcv_msg_rate != 0)G  		BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),l!  		    rx_pos, y_pos, string, 3,    		    w5w);+  	    sprintf (string, "%d", pem.rcv_msg); _J  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, string, 3,    		    w8w);  	    }3  	else  	    { J  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		rx_pos, y_pos, " ", 3,   		w5w);J  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, "0", 3,   		w8w);  	    }n"  	y_pos = y_pos + Bnr.font_height;  	}e  i  	{_F  	BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),%  	    x_pos, y_pos, "DGpktsRcvd", 1, i
  	    tw);  	if (pem.rcv_unseq != 0)s  	    {d2  	    sprintf (string, "%d", pem.rcv_unseq_rate); "  	    if (pem.rcv_unseq_rate != 0)G  		BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget), !  		    rx_pos, y_pos, string, 3, B  		    w5w);-  	    sprintf (string, "%d", pem.rcv_unseq);  J  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, string, 3, p  		    w8w);  	    }   	else  	    { J  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		rx_pos, y_pos, " ", 3,   		w5w);J  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, "0", 3,   		w8w);  	    },"  	y_pos = y_pos + Bnr.font_height;  	}f  e  	{cF  	BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),,  	    x_pos, y_pos, "VCpktsRcvdInOrder", 1, 
  	    tw);  	if (pem.rcv_seq != 0)d  	    {e0  	    sprintf (string, "%d", pem.rcv_seq_rate);    	    if (pem.rcv_seq_rate != 0)G  		BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),W!  		    rx_pos, y_pos, string, 3, y  		    w5w);+  	    sprintf (string, "%d", pem.rcv_seq);  J  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, string, 3, 	  		    w8w);  	    }t  	else  	    {BJ  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		rx_pos, y_pos, " ", 3,   		w5w);J  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, "0", 3,   		w8w);  	    }w"  	y_pos = y_pos + Bnr.font_height;  	}e  d  	{mF  	BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),*  	    x_pos, y_pos, "VCpktsRcvdEarly", 1, 
  	    tw);  	if (pem.rcv_cache != 0).  	    {)2  	    sprintf (string, "%d", pem.rcv_cache_rate); "  	    if (pem.rcv_cache_rate != 0)G  		BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),s!  		    rx_pos, y_pos, string, 3, p  		    w5w);-  	    sprintf (string, "%d", pem.rcv_cache);  J  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, string, 3, o  		    w8w);  	    }w  	else  	    {rJ  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		rx_pos, y_pos, " ", 3,   		w5w);J  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, "0", 3,   		w8w);  	    }	"  	y_pos = y_pos + Bnr.font_height;  	},     	{ F  	BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),)  	    x_pos, y_pos, "DuplicatesRcvd", 1, .
  	    tw);  	if (pem.rcv_rercv != 0)e  	    {i2  	    sprintf (string, "%d", pem.rcv_rercv_rate); "  	    if (pem.rcv_rercv_rate != 0)G  		BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),r!  		    rx_pos, y_pos, string, 3, ,  		    w5w);-  	    sprintf (string, "%d", pem.rcv_rercv); 	J  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, string, 3, i  		    w8w);  	    }s  	else  	    {wJ  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		rx_pos, y_pos, " ", 3,   		w5w);J  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, "0", 3,   		w8w);  	    }r"  	y_pos = y_pos + Bnr.font_height;  	}S  "  	{ F  	BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),'  	    x_pos, y_pos, "LoneACKsRcvd", 1, (
  	    tw);  	if (pem.rcv_ack != 0)i  	    {t0  	    sprintf (string, "%d", pem.rcv_ack_rate);    	    if (pem.rcv_ack_rate != 0)G  		BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),a!  		    rx_pos, y_pos, string, 3, g  		    w5w);+  	    sprintf (string, "%d", pem.rcv_ack); ,J  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, string, 3, r  		    w8w);  	    },  	else  	    { J  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		rx_pos, y_pos, " ", 3,   		w5w);J  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, "0", 3,   		w8w);  	    }o"  	y_pos = y_pos + Bnr.font_height;  	}P  S  	{ F  	BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),(  	    x_pos, y_pos, "VCbuf>ChanBuf", 1, 
  	    tw);  	if (pem.topology_change != 0)t  	    {n8  	    sprintf (string, "%d", pem.topology_change_rate); (  	    if (pem.topology_change_rate != 0)G  		BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),r!  		    rx_pos, y_pos, string, 3, t  		    w5w);3  	    sprintf (string, "%d", pem.topology_change);  J  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, string, 3, ,  		    w8w);  	    }a  	else  	    {DJ  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		rx_pos, y_pos, " ", 3,   		w5w);J  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, "0", 3,   		w8w);  	    }2"  	y_pos = y_pos + Bnr.font_height;  	}   f  	{.F  	BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),*  	    x_pos, y_pos, "NoNpageDynForTx", 1, 
  	    tw);  	if (pem.npagedyn_low != 0)  	    {d5  	    sprintf (string, "%d", pem.npagedyn_low_rate); B%  	    if (pem.npagedyn_low_rate != 0)"G  		BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),X!  		    rx_pos, y_pos, string, 3, ,  		    w5w);0  	    sprintf (string, "%d", pem.npagedyn_low); J  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, string, 3, w  		    w8w);  	    }T  	else  	    {rJ  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		rx_pos, y_pos, " ", 3,   		w5w);J  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, "0", 3,   		w8w);  	    } "  	y_pos = y_pos + Bnr.font_height;  	}.  _  	{=F  	BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),&  	    x_pos, y_pos, "NoChanForTX", 1, 
  	    tw);  	if (pem.xmt_noxch != 0)d  	    {e2  	    sprintf (string, "%d", pem.xmt_noxch_rate); "  	    if (pem.xmt_noxch_rate != 0)G  		BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),n!  		    rx_pos, y_pos, string, 3, p  		    w5w);-  	    sprintf (string, "%d", pem.xmt_noxch); 	J  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, string, 3, w  		    w8w);  	    }x  	else  	    {pJ  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		rx_pos, y_pos, " ", 3,   		w5w);J  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, "0", 3,   		w8w);  	    }L"  	y_pos = y_pos + Bnr.font_height;  	}.  _  	{=F  	BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),-  	    x_pos, y_pos, "TXstall,FullWindow", 1, (
  	    tw);  	if (pem.tr_pipe_quota != 0)w  	    { 6  	    sprintf (string, "%d", pem.tr_pipe_quota_rate); &  	    if (pem.tr_pipe_quota_rate != 0)G  		BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),,!  		    rx_pos, y_pos, string, 3, 	  		    w5w);1  	    sprintf (string, "%d", pem.tr_pipe_quota); DJ  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, string, 3, x  		    w8w);  	    }g  	else  	    {rJ  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		rx_pos, y_pos, " ", 3,   		w5w);J  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, "0", 3,   		w8w);  	    } "  	y_pos = y_pos + Bnr.font_height;  	},  	  	{pF  	BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),)  	    x_pos, y_pos, "ShortTRpktRcvd", 1, e
  	    tw);  	if (pem.rcv_tr_short != 0)  	    {,5  	    sprintf (string, "%d", pem.rcv_tr_short_rate); n%  	    if (pem.rcv_tr_short_rate != 0)rG  		BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),,!  		    rx_pos, y_pos, string, 3,    		    w5w);0  	    sprintf (string, "%d", pem.rcv_tr_short); J  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, string, 3, l  		    w8w);  	    }n  	else  	    {tJ  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		rx_pos, y_pos, " ", 3,   		w5w);J  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, "0", 3,   		w8w);  	    }f"  	y_pos = y_pos + Bnr.font_height;  	}p  t  	{rF  	BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),*  	    x_pos, y_pos, "IllegalACKsRcvd", 1, 
  	    tw);  	if (pem.rcv_ill_ack != 0),  	    {t4  	    sprintf (string, "%d", pem.rcv_ill_ack_rate); $  	    if (pem.rcv_ill_ack_rate != 0)G  		BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),s!  		    rx_pos, y_pos, string, 3,    		    w5w);/  	    sprintf (string, "%d", pem.rcv_ill_ack); iJ  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, string, 3, r  		    w8w);  	    }B  	else  	    {	J  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		rx_pos, y_pos, " ", 3,   		w5w);J  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, "0", 3,   		w8w);  	    }c"  	y_pos = y_pos + Bnr.font_height;  	}r  ,  	{,F  	BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),,  	    x_pos, y_pos, "DscrdVCpkt,VCclsd", 1, 
  	    tw);  	if (pem.rcv_ill_seq != 0)   	    { 4  	    sprintf (string, "%d", pem.rcv_ill_seq_rate); $  	    if (pem.rcv_ill_seq_rate != 0)G  		BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),	!  		    rx_pos, y_pos, string, 3,    		    w5w);/  	    sprintf (string, "%d", pem.rcv_ill_seq); BJ  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, string, 3, n  		    w8w);  	    }	  	else  	    {0J  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		rx_pos, y_pos, " ", 3,   		w5w);J  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, "0", 3,   		w8w);  	    } "  	y_pos = y_pos + Bnr.font_height;  	}u  q  	{)F  	BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),*  	    x_pos, y_pos, "RcvdBadTRchkSum", 1, 
  	    tw);  	if (pem.rcv_bad_cksum != 0)w  	    { 6  	    sprintf (string, "%d", pem.rcv_bad_cksum_rate); &  	    if (pem.rcv_bad_cksum_rate != 0)G  		BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget), !  		    rx_pos, y_pos, string, 3, r  		    w5w);1  	    sprintf (string, "%d", pem.rcv_bad_cksum); rJ  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, string, 3, ,  		    w8w);  	    },  	else  	    {	J  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		rx_pos, y_pos, " ", 3,   		w5w);J  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, "0", 3,   		w8w);  	    }t"  	y_pos = y_pos + Bnr.font_height;  	}   f  	{.F  	BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),*  	    x_pos, y_pos, "RetriesExceeded", 1, 
  	    tw);  	if (pem.xmt_seq_tmo != 0)   	    {"4  	    sprintf (string, "%d", pem.xmt_seq_tmo_rate); $  	    if (pem.xmt_seq_tmo_rate != 0)G  		BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget), !  		    rx_pos, y_pos, string, 3, l  		    w5w);/  	    sprintf (string, "%d", pem.xmt_seq_tmo);  J  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, string, 3, y  		    w8w);  	    };  	else  	    {oJ  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		rx_pos, y_pos, " ", 3,   		w5w);J  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, "0", 3,   		w8w);  	    }d"  	y_pos = y_pos + Bnr.font_height;  	}c  a  	{a *5E F  	BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget), *5D    	    lx_pos, y_pos, string, 3,   	    w8w);;*  	sprintf (string, "Bad %d", pem.badchk);   	if (pem.badchk != 0) *5EX *5Il'  	    x_pos, y_pos, "FreeQueEmpty", 1, t
  	    tw);  	if (pem.fq_empty != 0)  	    {;1  	    sprintf (string, "%d", pem.fq_empty_rate);  !  	    if (pem.fq_empty_rate != 0) G  		BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),T!  		    rx_pos, y_pos, string, 3, n  		    w5w);,  	    sprintf (string, "%d", pem.fq_empty); J  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		lx_pos, y_pos, string, 3, X  		    w8w);  	    },  	else  	    {pJ  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget),  		rx_pos, y_pos, " ", 3,   		w5w); *5EvJ  	    BannerWriteText (XtDisplay(Bnr.pe_widget), XtWindow (Bnr.pe_widget), *5De  		rx_pos, y_pos, string, 3,  		w5w); *5Er *5I,  		lx_pos, y_pos, "0", 3,   		w8w);  	    }t *5Er"  	y_pos = y_pos + Bnr.font_height;  	}r *5IT      */  y *5Ep  }    /*W  **++B  **  FUNCTIONAL DESCRIPTION:  **t  **	BannerPE ()   **;9  **      This routine runs the Monitor display of banner.l  **r  **  FORMAL PARAMETERS:r  **i
  **      noneo  **p  **  IMPLICIT INPUTS:   ** 
  **      none   **s  **  IMPLICIT OUTPUTS:  ** 
  **      none,  **l  **  COMPLETION CODES:  **w
  **      none	  **   **  SIDE EFFECTS:  **;
  **      none   **a  **--t  **/  void	  BannerPE()g  {+      int rate, newkb, x_pos, y_pos, lx_pos;s *5In$      int width, x, y, x1, y1, y_max;V      int bus_error_pos, bus_name_pos, bus_percent_pos, bus_graph_pos, bus_graph_width;_      int vc_rexmt_pos, vc_rercv_pos, vc_name_pos, vc_percent_pos, vc_graph_pos, vc_graph_width;       int vcs_displayed;i *5E,(      char string[] = "                ";      int status, iocnt, len; n *5It      long int bus_index;      long int vc_index;i      struct PE_BUS *bus;      struct PE_VC *vc;+      unsigned long int total_lan_bandwidth;r'      unsigned long int lan_utilization;o0      struct PE_VC *vc_display_array [ 100 + 1 ];      long int hash_index;x *5ED  l      if (!pe_init)  	BannerPERefresh ();,  	      pe_update_count --;      if (pe_update_count > 0)_	  	return;o  	(      pe_update_count = pe_update_number;  D *5Dy$      x_pos = tw + Bnr.font_height/2;.      lx_pos = x_pos + w5w + Bnr.font_height/2;      y_pos = Bnr.font_height;c  g  = *5E !      status = REMOTE_PE_COUNT ();d      if (status != 1)r  	{  *5D 8  	printf("\nNi access routine rreturned bad status!\n"); *5Ep *5In *7Dw7  	printf("\nNi access routine returned bad status!\n");  *7Eg *7It7  	printf("\nPE access routine returned bad status.\n");_/  	printf("PE Monitor was built for VMS 5.5\n");p0  	printf("No PE statistics can be displayed\n"); *7E  *5Eg   	Bnr.Param_Bits.pe_window = 0;		  	return;   	}	 *5Ia  r  /*T8   * For each BUS, update the statistics for the display.   */  ,      lan_utilization = 0; G      for ( bus_index = 0; bus_index < PE_BUS$C_BUS_COUNT; bus_index++ ),        {  y)          bus = & BUS_ARRAY [ bus_index ]; /          if ( bus -> PE_BUS$T_NAME [ 0 ] != 0 )n            {  s/  			/*  Highlight the BUS if it is offline.  */	   @              if (( bus -> PE_BUS$L_FLAGS & BUS$M_ONLINE ) == 0 )1                bus -> PE_BUS$L_HIGHLIGHT_BUS = 1;,              elsea1                bus -> PE_BUS$L_HIGHLIGHT_BUS = 0;B  e(  			/*  Compute the BUS utilization.  */  w1              if ( bus -> PE_BUS$L_XMT_LAST != 0 ),                {d                  bus -> PE_BUS$L_XMT_PERCENT = bus -> PE_BUS$L_XMT_BYTES - bus -> PE_BUS$L_XMT_LAST;F                  bus -> PE_BUS$L_XMT_LAST = bus -> PE_BUS$L_XMT_BYTES;d                  bus -> PE_BUS$L_RCV_PERCENT = bus -> PE_BUS$L_RCV_BYTES - bus -> PE_BUS$L_RCV_LAST;F                  bus -> PE_BUS$L_RCV_LAST = bus -> PE_BUS$L_RCV_BYTES;  p(  			/*  Compute the LAN utilization.  */  oA                  if (( bus -> PE_BUS$L_FLAGS & BUS$M_LDL ) == 0 )hq                    lan_utilization = lan_utilization + bus -> PE_BUS$L_XMT_PERCENT + bus -> PE_BUS$L_RCV_PERCENT;   C                }              else.                {F                  bus -> PE_BUS$L_XMT_LAST = bus -> PE_BUS$L_XMT_BYTES;1                  bus -> PE_BUS$L_XMT_PERCENT = 0;pF                  bus -> PE_BUS$L_RCV_LAST = bus -> PE_BUS$L_RCV_BYTES;1                  bus -> PE_BUS$L_RCV_PERCENT = 0;d                }   1              bus -> PE_BUS$L_LAN_UTILIZATION = 0;W  oK  			/*  Highlight the error count if the error rate exceeds 1 per hour.  */	  eS              bus -> PE_BUS$L_HIGHLIGHT_ERRORS = bus -> PE_BUS$L_HIGHLIGHT_ERRORS + ,v                ((( bus -> PE_BUS$L_XMT_ERRORS - bus  -> PE_BUS$L_XMT_ERRORS_LAST ) * 60. * 60. ) / pe_update_number );K              bus  -> PE_BUS$L_XMT_ERRORS_LAST = bus -> PE_BUS$L_XMT_ERRORS;;  	            }        }  T/  		/*  Compute the utilization of each BUS.  */i  t      total_lan_bandwidth = 0;l       if ( lan_utilization != 0 )I        for ( bus_index = 0; bus_index < PE_BUS$C_BUS_COUNT; bus_index++ )_
          {  )+            bus = & BUS_ARRAY [ bus_index ];	1            if ( bus -> PE_BUS$T_NAME [ 0 ] != 0 )w              {   E  			/*  LAN segment utilization associated with this LAN adapter.  */,  dp                bus -> PE_BUS$L_LAN_UTILIZATION = (( bus -> PE_BUS$L_XMT_PERCENT + bus -> PE_BUS$L_RCV_PERCENT ) 0                  * 8 * 100 ) / pe_update_number;<  	      if ( bus -> PE_BUS$L_LAN_TYPE == VCIB$K_DLL_CSMACD )                  {e                    bus -> PE_BUS$L_LAN_UTILIZATION = ( bus -> PE_BUS$L_LAN_UTILIZATION / 10000000. );BH                    total_lan_bandwidth = total_lan_bandwidth + 10000000;                  }                else C                  if ( bus -> PE_BUS$L_LAN_TYPE == VCIB$K_DLL_FDDI ),                    {h                      bus -> PE_BUS$L_LAN_UTILIZATION = ( bus -> PE_BUS$L_LAN_UTILIZATION / 100000000. );K                      total_lan_bandwidth = total_lan_bandwidth + 100000000;i                    }  w4  			/*  Node load supported by this transmitter.  */   f                bus -> PE_BUS$L_XMT_PERCENT = ( 100. * bus -> PE_BUS$L_XMT_PERCENT ) / lan_utilization;  l1  			/*  Node load supported by this receiver.  */_  ,f                bus -> PE_BUS$L_RCV_PERCENT = ( 100. * bus -> PE_BUS$L_RCV_PERCENT ) / lan_utilization;  g              }
          }     /*_,   * Clear the Virtual Circuit display array.   */  X6      for ( vc_index = 0; vc_index <= 100; vc_index++ ))        vc_display_array [ vc_index ] = 0;   _  /* "   * Update the error rate counter.   */  a      if ( --vc_error_rate < 0 )i:        vc_error_rate = ( 60 * 60 / pe_update_number ) - 1;  C  /*d7   * For each VC, update the statistics for the display.t   */  pG      for ( vc_index = PE_VC$C_VC_COUNT - 1; vc_index >= 0; vc_index-- )a        {&          vc = & VC_ARRAY [ vc_index ];1          if ( vc -> PE_VC$T_NODENAME [ 0 ] != 0 )p            {   -  			/*  Highlight the VC if it is closed.  */r  i;              if (( vc -> PE_VC$L_FLAGS & VC$M_OPEN ) == 0 )X                {0                  vc -> PE_VC$L_HIGHLIGHT_VC = 1;6                  if ( vc -> PE_VC$L_CLOSED_COUNT > 0 )O                    vc -> PE_VC$L_CLOSED_COUNT = vc -> PE_VC$L_CLOSED_COUNT - 1;	                }              elsel                {0                  vc -> PE_VC$L_HIGHLIGHT_VC = 0;   4  			/*  Display closed VCs for up to 10 minutes.  */   I                  vc -> PE_VC$L_CLOSED_COUNT = 60 * 10 / pe_update_number;p                }  o'  			/*  Compute the VC utilization.  */   ;/              if ( vc -> PE_VC$L_XMT_LAST != 0 )p                {^                  vc -> PE_VC$L_XMT_PERCENT = vc -> PE_VC$L_XMT_BYTES - vc -> PE_VC$L_XMT_LAST;B                  vc -> PE_VC$L_XMT_LAST = vc -> PE_VC$L_XMT_BYTES;^                  vc -> PE_VC$L_RCV_PERCENT = vc -> PE_VC$L_RCV_BYTES - vc -> PE_VC$L_RCV_LAST;B                  vc -> PE_VC$L_RCV_LAST = vc -> PE_VC$L_RCV_BYTES;  s(  			/*  Compute the LAN utilization.  */  eo                  vc -> PE_VC$L_LAN_UTILIZATION = (( vc -> PE_VC$L_XMT_PERCENT + vc -> PE_VC$L_RCV_PERCENT ) * 8 D                    * 100 / total_lan_bandwidth ) / pe_update_number;_                  vc -> PE_VC$L_XMT_PERCENT = 100 * vc -> PE_VC$L_XMT_PERCENT / lan_utilization;h_                  vc -> PE_VC$L_RCV_PERCENT = 100 * vc -> PE_VC$L_RCV_PERCENT / lan_utilization;   o#  			/*  Update the error rates.  */   wQ                  if (( vc_error_rate == 0 ) && ( vc -> PE_VC$L_REXMT_RATE != 0 ))bK                    vc -> PE_VC$L_REXMT_RATE = vc -> PE_VC$L_REXMT_RATE - 1;(Q                  if (( vc_error_rate == 0 ) && ( vc -> PE_VC$L_RERCV_RATE != 0 )) K                    vc -> PE_VC$L_RERCV_RATE = vc -> PE_VC$L_RERCV_RATE - 1;   n.  			/*  Compute the retransmit error rate.  */  r`                  vc -> PE_VC$L_REXMT_LAST = vc -> PE_VC$L_REXMT_MSGS - vc -> PE_VC$L_REXMT_LAST;5                  if ( vc -> PE_VC$L_PIPE_QUOTA == 0 )_b                    vc -> PE_VC$L_REXMT_RATE = vc -> PE_VC$L_REXMT_RATE + vc -> PE_VC$L_REXMT_LAST;                  else                     vc -> PE_VC$L_REXMT_RATE = vc -> PE_VC$L_REXMT_RATE + ( vc -> PE_VC$L_REXMT_LAST / vc -> PE_VC$L_PIPE_QUOTA );rE                  vc -> PE_VC$L_REXMT_LAST = vc -> PE_VC$L_REXMT_MSGS;e  d.  			/*  Compute the re-receive error rate.  */  	`                  vc -> PE_VC$L_RERCV_LAST = vc -> PE_VC$L_RERCV_MSGS - vc -> PE_VC$L_RERCV_LAST;5                  if ( vc -> PE_VC$L_PIPE_QUOTA == 0 )wb                    vc -> PE_VC$L_RERCV_RATE = vc -> PE_VC$L_RERCV_RATE + vc -> PE_VC$L_RERCV_LAST;                  else                     vc -> PE_VC$L_RERCV_RATE = vc -> PE_VC$L_RERCV_RATE + ( vc -> PE_VC$L_RERCV_LAST / vc -> PE_VC$L_PIPE_QUOTA );l7  		vc -> PE_VC$L_RERCV_LAST = vc -> PE_VC$L_RERCV_MSGS;g  ,&  			/*  Compute the VC hash index.  */  s?                  if (( vc -> PE_VC$L_FLAGS & VC$M_OPEN ) != 0 )gV                    hash_index = vc -> PE_VC$L_XMT_PERCENT + vc -> PE_VC$L_RCV_PERCENT;                  elseh?                    hash_index = vc -> PE_VC$L_CLOSED_COUNT / 6;g(                  if ( hash_index > 100 )$                    hash_index = 100;  ;W  			/*  Highlight the error rates if they exceed the error threshold of 2 per hour.  */_  ,3                  vc -> PE_VC$L_HIGHLIGHT_REXMT = 0;q3                  vc -> PE_VC$L_HIGHLIGHT_RERCV = 0;pR                  if (( vc -> PE_VC$L_REXMT_RATE + vc -> PE_VC$L_RERCV_RATE ) > 2 )                    {&                      hash_index = 100;9                      if ( vc -> PE_VC$L_REXMT_RATE != 0 )"9                        vc -> PE_VC$L_HIGHLIGHT_REXMT = 1;p9                      if ( vc -> PE_VC$L_RERCV_RATE != 0 )i9                        vc -> PE_VC$L_HIGHLIGHT_RERCV = 1;a                    }  B>  			/*  Place this virtual circuit into the display array.  */   Q                  vc -> PE_VC$A_VC_DISPLAY_LINK = vc_display_array [ hash_index ];_6                  vc_display_array [ hash_index ] = vc;  r                }              else	                {/                  vc -> PE_VC$L_XMT_PERCENT = 0;5B                  vc -> PE_VC$L_XMT_LAST = vc -> PE_VC$L_XMT_BYTES;/                  vc -> PE_VC$L_RCV_PERCENT = 0;iB                  vc -> PE_VC$L_RCV_LAST = vc -> PE_VC$L_RCV_BYTES;3                  vc -> PE_VC$L_LAN_UTILIZATION = 0; .                  vc -> PE_VC$L_REXMT_RATE = 0;E                  vc -> PE_VC$L_REXMT_LAST = vc -> PE_VC$L_REXMT_MSGS; %  		vc -> PE_VC$L_HIGHLIGHT_REXMT = 0;:.                  vc -> PE_VC$L_RERCV_RATE = 0;7  		vc -> PE_VC$L_RERCV_LAST = vc -> PE_VC$L_RERCV_MSGS; %  		vc -> PE_VC$L_HIGHLIGHT_RERCV = 0;1  1P  			    /*  This will display closed virtual circuits for up to two minutes.  */  rH                  vc -> PE_VC$L_CLOSED_COUNT = 60 * 2 / pe_update_number;                }            }        }  v  /*s'   * Display the BUS utilization header.    */   !      x_pos = Bnr.font_height / 2;n      x = x_pos;       y = Bnr.font_height;n  cN      XSetForeground ( XtDisplay ( Bnr.pe_widget ), BannerGC, Bnr.foreground );O      BannerWriteText ( XtDisplay ( Bnr.pe_widget ), XtWindow ( Bnr.pe_widget ),E:        x, y, "LAN Adapter Utilization", 2, Bnr.pe_width );         y = y + Bnr.font_height;	      bus_error_pos = x; O      BannerWriteText ( XtDisplay ( Bnr.pe_widget ), XtWindow ( Bnr.pe_widget ),_8        bus_error_pos, y, "Errors", 2, bus_error_width );   #      x = x + bus_error_width + w2w;o      bus_name_pos = x;O      BannerWriteText ( XtDisplay ( Bnr.pe_widget ), XtWindow ( Bnr.pe_widget ), 4        bus_name_pos, y, "Name", 1, bus_name_width );  a"      x = x + bus_name_width + w2w;      bus_percent_pos = x;rO      BannerWriteText ( XtDisplay ( Bnr.pe_widget ), XtWindow ( Bnr.pe_widget ),a>        bus_percent_pos, y, "% of LAN", 1, bus_percent_width );  b%      x = x + bus_percent_width + w2w;       bus_graph_pos = x;e      bus_graph_width = 0;aB      if (( bus_graph_pos + bus_graph_min_width ) <= Bnr.pe_width )        {,          bus_graph_width = Bnr.pe_width - x;S          BannerWriteText ( XtDisplay ( Bnr.pe_widget ), XtWindow ( Bnr.pe_widget ),U9            bus_graph_pos, y, "0", 1, bus_graph_0_width );Y#          x = x + bus_graph_0_width;>P          x1 = ( bus_graph_width - bus_graph_0_width - bus_graph_100_width ) / 2;S          BannerWriteText ( XtDisplay ( Bnr.pe_widget ), XtWindow ( Bnr.pe_widget ),             x, y, "Tx", 2, x1 );G          x = x + x1;M          XSetForeground ( XtDisplay ( Bnr.pe_widget ), BannerGC, Bnr.hwmrk ); S          BannerWriteText ( XtDisplay ( Bnr.pe_widget ), XtWindow ( Bnr.pe_widget ),             x, y, "Rx", 2, x1 ); R          XSetForeground ( XtDisplay ( Bnr.pe_widget ), BannerGC, Bnr.foreground );0          x = Bnr.pe_width - bus_graph_100_width;S          BannerWriteText ( XtDisplay ( Bnr.pe_widget ), XtWindow ( Bnr.pe_widget ),B1            x, y, "100", 1, bus_graph_100_width );         }  -  /*B    * Display the BUS utilization.   */         y = y + Bnr.font_height;lI      for ( bus_index = 0; bus_index < PE_BUS$C_DISPLAY_BUS; bus_index++ ))        {)          bus = & BUS_ARRAY [ bus_index ];ib          if (( bus -> PE_BUS$T_NAME [ 0 ] != 0 ) && (( bus -> PE_BUS$L_FLAGS & BUS$M_LDL ) == 0 ))            {   )  				/*  Display the BUS error count.  */S  XB              sprintf ( string, "%d", bus -> PE_BUS$L_XMT_ERRORS );9              if ( bus -> PE_BUS$L_HIGHLIGHT_ERRORS != 0 )LS                XSetForeground ( XtDisplay ( Bnr.pe_widget ), BannerGC, Bnr.hwmrk ); W              BannerWriteText ( XtDisplay ( Bnr.pe_widget ), XtWindow ( Bnr.pe_widget ),h>                bus_error_pos, y, string, 3, bus_error_width );9              if ( bus -> PE_BUS$L_HIGHLIGHT_ERRORS != 0 )>X                XSetForeground ( XtDisplay ( Bnr.pe_widget ), BannerGC, Bnr.foreground );  S"  				/*  Display the BUS name.  */  _6              if ( bus -> PE_BUS$L_HIGHLIGHT_BUS != 0 )S                XSetForeground ( XtDisplay ( Bnr.pe_widget ), BannerGC, Bnr.hwmrk );eW              BannerWriteText ( XtDisplay ( Bnr.pe_widget ), XtWindow ( Bnr.pe_widget ),lQ                bus_name_pos, y, &bus -> PE_BUS$T_NAME [ 1 ], 1, bus_name_width );e6              if ( bus -> PE_BUS$L_HIGHLIGHT_BUS != 0 )X                XSetForeground ( XtDisplay ( Bnr.pe_widget ), BannerGC, Bnr.foreground );   )  				/*  Display the LAN utilization.  */s  NG              sprintf ( string, "%d", bus -> PE_BUS$L_LAN_UTILIZATION );uW              BannerWriteText ( XtDisplay ( Bnr.pe_widget ), XtWindow ( Bnr.pe_widget ),/B                bus_percent_pos, y, string, 3, bus_percent_width );  _.  				/*  Display the transmit utilization.  */  s'              if ( bus_graph_width > 0 )E                {^                  x1 = bus_graph_pos + ( bus_graph_width * bus -> PE_BUS$L_XMT_PERCENT / 100 );)                  if ( x1 > Bnr.pe_width ) %                    x1 = Bnr.pe_width;_.                  y1 = y - Bnr.font_height + 3;1                  if (( x1 - bus_graph_pos ) > 0 )I                    XFillRectangle ( XtDisplay ( Bnr.pe_widget ), XtWindow ( Bnr.pe_widget ), BannerGC, bus_graph_pos, y1, x1, y );   -  				/*  Display the receive utilization.  */r                     x = x1;R                  x1 = x + ( bus_graph_width * bus -> PE_BUS$L_RCV_PERCENT / 100 );)                  if ( x1 > Bnr.pe_width )a%                    x1 = Bnr.pe_width; %                  if (( x1 - x ) > 0 )E                    {Y                      XSetForeground ( XtDisplay ( Bnr.pe_widget ), BannerGC, Bnr.hwmrk );ax                      XFillRectangle ( XtDisplay ( Bnr.pe_widget ), XtWindow ( Bnr.pe_widget ), BannerGC, x, y1, x1, y );                    }   (  				/*  Clear the rest of the line.  */                     x = x1;#                  x1 = Bnr.pe_width;e&                  if (( x1 - x ) >= 0 )                    {^                      XSetForeground ( XtDisplay ( Bnr.pe_widget ), BannerGC, Bnr.background );x                      XFillRectangle ( XtDisplay ( Bnr.pe_widget ), XtWindow ( Bnr.pe_widget ), BannerGC, x, y1, x1, y );                    }Z                  XSetForeground ( XtDisplay ( Bnr.pe_widget ), BannerGC, Bnr.foreground );                }  )  				/*  Set the next line.  */                  x = x_pos;L%              y = y + Bnr.font_height;-  E            }        }   =  			/*  Clear the line after the BUS utilization display.  */S  C      y1 = y - Bnr.font_height;N      XSetForeground ( XtDisplay ( Bnr.pe_widget ), BannerGC, Bnr.background );r      XFillRectangle ( XtDisplay ( Bnr.pe_widget ), XtWindow ( Bnr.pe_widget ), BannerGC, 0, y1, Bnr.pe_width, y );N      XSetForeground ( XtDisplay ( Bnr.pe_widget ), BannerGC, Bnr.foreground );  n  /* 3   * Display the Virtual Circuit utilization header.p   */         x = x_pos;       y = y + Bnr.font_height;EN      XSetForeground ( XtDisplay ( Bnr.pe_widget ), BannerGC, Bnr.foreground );O      BannerWriteText ( XtDisplay ( Bnr.pe_widget ), XtWindow ( Bnr.pe_widget ),R>        x, y, "Virtual Circuit Utilization", 2, Bnr.pe_width );         y = y + Bnr.font_height;       vc_rexmt_pos = x;O      BannerWriteText ( XtDisplay ( Bnr.pe_widget ), XtWindow ( Bnr.pe_widget ),L5        vc_rexmt_pos, y, "ReXmt", 2, vc_rexmt_width );   V"      x = x + vc_rexmt_width + w2w;      vc_rercv_pos = x;O      BannerWriteText ( XtDisplay ( Bnr.pe_widget ), XtWindow ( Bnr.pe_widget ),05        vc_rercv_pos, y, "ReRcv", 2, vc_rercv_width );    "      x = x + vc_rercv_width + w2w;      vc_name_pos = x;PO      BannerWriteText ( XtDisplay ( Bnr.pe_widget ), XtWindow ( Bnr.pe_widget ), 6        vc_name_pos, y, "SCS Node", 1, vc_name_width );  T!      x = x + vc_name_width + w2w;v      vc_percent_pos = x;O      BannerWriteText ( XtDisplay ( Bnr.pe_widget ), XtWindow ( Bnr.pe_widget ),v<        vc_percent_pos, y, "% of LAN", 1, vc_percent_width );  L$      x = x + vc_percent_width + w2w;      vc_graph_pos = x;      vc_graph_width = 0;@      if (( vc_graph_pos + vc_graph_min_width ) <= Bnr.pe_width )        {+          vc_graph_width = Bnr.pe_width - x; S          BannerWriteText ( XtDisplay ( Bnr.pe_widget ), XtWindow ( Bnr.pe_widget ),R7            vc_graph_pos, y, "0", 1, vc_graph_0_width );;"          x = x + vc_graph_0_width;M          x1 = ( vc_graph_width - vc_graph_0_width - vc_graph_100_width ) / 2;RS          BannerWriteText ( XtDisplay ( Bnr.pe_widget ), XtWindow ( Bnr.pe_widget ),             x, y, "Tx", 2, x1 );	          x = x + x1;M          XSetForeground ( XtDisplay ( Bnr.pe_widget ), BannerGC, Bnr.hwmrk );ES          BannerWriteText ( XtDisplay ( Bnr.pe_widget ), XtWindow ( Bnr.pe_widget ),E            x, y, "Rx", 2, x1 ); R          XSetForeground ( XtDisplay ( Bnr.pe_widget ), BannerGC, Bnr.foreground );/          x = Bnr.pe_width - vc_graph_100_width;_S          BannerWriteText ( XtDisplay ( Bnr.pe_widget ), XtWindow ( Bnr.pe_widget ),$0            x, y, "100", 1, vc_graph_100_width );        }  E  /*S,   * Display the Virtual Circuit utilization.   */         y = y + Bnr.font_height;C:      y_max = y + ( Bnr.font_height * PE_VC$C_DISPLAY_VC );      vcs_displayed = 0;C5      for ( vc_index = 100; vc_index > 0; vc_index-- )h        {2          if ( vcs_displayed < PE_VC$C_DISPLAY_VC )            {0              vc = vc_display_array [ vc_index ];              while ( vc != 0 )                {:                  if ( vcs_displayed < PE_VC$C_DISPLAY_VC )                    {7                      vcs_displayed = vcs_displayed + 1;    0  				/*  Display the retransmit error count.  */   H                      sprintf ( string, "%d", vc -> PE_VC$L_REXMT_MSGS );>                      if ( vc -> PE_VC$L_HIGHLIGHT_REXMT != 0 )[                        XSetForeground ( XtDisplay ( Bnr.pe_widget ), BannerGC, Bnr.hwmrk );T_                      BannerWriteText ( XtDisplay ( Bnr.pe_widget ), XtWindow ( Bnr.pe_widget ),vD                        vc_rexmt_pos, y, string, 3, vc_rexmt_width );>                      if ( vc -> PE_VC$L_HIGHLIGHT_REXMT != 0 )`                        XSetForeground ( XtDisplay ( Bnr.pe_widget ), BannerGC, Bnr.foreground );  i0  				/*  Display the re-receive error count.  */  }H                      sprintf ( string, "%d", vc -> PE_VC$L_RERCV_MSGS );>                      if ( vc -> PE_VC$L_HIGHLIGHT_RERCV != 0 )[                        XSetForeground ( XtDisplay ( Bnr.pe_widget ), BannerGC, Bnr.hwmrk );P_                      BannerWriteText ( XtDisplay ( Bnr.pe_widget ), XtWindow ( Bnr.pe_widget ), D                        vc_rercv_pos, y, string, 3, vc_rercv_width );>                      if ( vc -> PE_VC$L_HIGHLIGHT_RERCV != 0 )`                        XSetForeground ( XtDisplay ( Bnr.pe_widget ), BannerGC, Bnr.foreground );   '  				/*  Display the SCS node name.  */_  L;                      if ( vc -> PE_VC$L_HIGHLIGHT_VC != 0 )s[                        XSetForeground ( XtDisplay ( Bnr.pe_widget ), BannerGC, Bnr.hwmrk );N_                      BannerWriteText ( XtDisplay ( Bnr.pe_widget ), XtWindow ( Bnr.pe_widget ),hY                        vc_name_pos, y, &vc -> PE_VC$T_NODENAME [ 1 ], 1, vc_name_width ); ;                      if ( vc -> PE_VC$L_HIGHLIGHT_VC != 0 )a`                        XSetForeground ( XtDisplay ( Bnr.pe_widget ), BannerGC, Bnr.foreground );   )  				/*  Display the LAN utilization.  */"   M                      sprintf ( string, "%d", vc -> PE_VC$L_LAN_UTILIZATION ); _                      BannerWriteText ( XtDisplay ( Bnr.pe_widget ), XtWindow ( Bnr.pe_widget ),gH                        vc_percent_pos, y, string, 3, vc_percent_width );  =.  				/*  Display the transmit utilization.  */  ;.                      if ( vc_graph_width > 0 )                        {b                          x1 = vc_graph_pos + ( vc_graph_width * vc -> PE_VC$L_XMT_PERCENT / 100 );1                          if ( x1 > Bnr.pe_width )t-                            x1 = Bnr.pe_width;p6                          y1 = y - Bnr.font_height + 3;8                          if (( x1 - vc_graph_pos ) > 0 )                            XFillRectangle ( XtDisplay ( Bnr.pe_widget ), XtWindow ( Bnr.pe_widget ), BannerGC, vc_graph_pos, y1, x1, y );    -  				/*  Display the receive utilization.  */   B                           x = x1;W                          x1 = x + ( vc_graph_width * vc -> PE_VC$L_RCV_PERCENT / 100 );01                          if ( x1 > Bnr.pe_width ) -                            x1 = Bnr.pe_width;t-                          if (( x1 - x ) > 0 )W                            {a                              XSetForeground ( XtDisplay ( Bnr.pe_widget ), BannerGC, Bnr.hwmrk );                               XFillRectangle ( XtDisplay ( Bnr.pe_widget ), XtWindow ( Bnr.pe_widget ), BannerGC, x, y1, x1, y );                            }   (  				/*  Clear the rest of the line.  */  F                           x = x1;+                          x1 = Bnr.pe_width;x.                          if (( x1 - x ) >= 0 )                            {f                              XSetForeground ( XtDisplay ( Bnr.pe_widget ), BannerGC, Bnr.background );                              XFillRectangle ( XtDisplay ( Bnr.pe_widget ), XtWindow ( Bnr.pe_widget ), BannerGC, x, y1, x1, y );                            }b                          XSetForeground ( XtDisplay ( Bnr.pe_widget ), BannerGC, Bnr.foreground );                        }  S  				/*  Set the next line.  */                          x = x_pos;B-                      y = y + Bnr.font_height;(  r                    }  L+  			/*  Locate the next VC for display.  */U  _4                  vc = vc -> PE_VC$A_VC_DISPLAY_LINK;                   }            }        }  mF  			/*  Clear the rest of the virtual circuit utilization display.  */  w      if ( y < y_max )         {"          y1 = y - Bnr.font_height;R          XSetForeground ( XtDisplay ( Bnr.pe_widget ), BannerGC, Bnr.background );z          XFillRectangle ( XtDisplay ( Bnr.pe_widget ), XtWindow ( Bnr.pe_widget ), BannerGC, 0, y1, Bnr.pe_width, y_max );R          XSetForeground ( XtDisplay ( Bnr.pe_widget ), BannerGC, Bnr.foreground );        }  a *5En  /*w   * First Lock's   */ *5I)     /*    *      x_pos = tw + ( Bnr.font_height / 2 );4      lx_pos = x_pos + w5w + ( Bnr.font_height / 2 );!      y_pos = y + Bnr.font_height;      	{ %  	rate = new_pes.vc_cnt - pes.vc_cnt;u  	if (rate != pem.vc_cnt_rate)  	    {   	    pem.vc_cnt_rate = rate;p$  	    sprintf (string, "%d", rate);   	    if (rate == 0).  		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget),b!  		    x_pos, y_pos, "     ", 3,    		    w5w);  	    else 	    .  		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget),e   		    x_pos, y_pos, string, 3,   		    w5w);  	    }D#  	if (new_pes.vc_cnt != pem.vc_cnt)   	    { "  	    pem.vc_cnt = new_pes.vc_cnt;)  	    sprintf (string, "%d", pem.vc_cnt);_1  	    BannerWriteText (XtDisplay(Bnr.pe_widget), _  		XtWindow(Bnr.pe_widget),   		lx_pos, y_pos, string, 3,    		w8w);  	    }x"  	y_pos = y_pos + Bnr.font_height;  	}   	{n7  	rate = new_pes.ret_id_attempts - pes.ret_id_attempts;_'  	if (rate != pem.ret_id_attempts_rate)t  	    {t&  	    pem.ret_id_attempts_rate = rate;$  	    sprintf (string, "%d", rate);   	    if (rate == 0).  		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget), !  		    x_pos, y_pos, "     ", 3, t  		    w5w);  	    else 	    .  		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget),.   		    x_pos, y_pos, string, 3,   		    w5w);  	    } 5  	if (new_pes.ret_id_attempts != pem.ret_id_attempts)t  	    { 4  	    pem.ret_id_attempts = new_pes.ret_id_attempts;2  	    sprintf (string, "%d", pem.ret_id_attempts);1  	    BannerWriteText (XtDisplay(Bnr.pe_widget),    		XtWindow(Bnr.pe_widget),   		lx_pos, y_pos, string, 3, e  		w8w);  	    } "  	y_pos = y_pos + Bnr.font_height;  	}   	{.1  	rate = new_pes.ret_ids_sent - pes.ret_ids_sent; $  	if (rate != pem.ret_ids_sent_rate)  	    {F#  	    pem.ret_ids_sent_rate = rate; $  	    sprintf (string, "%d", rate);   	    if (rate == 0).  		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget),1!  		    x_pos, y_pos, "     ", 3,    		    w5w);  	    else 	    .  		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget),	   		    x_pos, y_pos, string, 3,   		    w5w);  	    }s/  	if (new_pes.ret_ids_sent != pem.ret_ids_sent)   	    {}.  	    pem.ret_ids_sent = new_pes.ret_ids_sent;/  	    sprintf (string, "%d", pem.ret_ids_sent); 1  	    BannerWriteText (XtDisplay(Bnr.pe_widget),    		XtWindow(Bnr.pe_widget),r  		lx_pos, y_pos, string, 3, n  		w8w);  	    }n"  	y_pos = y_pos + Bnr.font_height;  	},  	{e-  	rate = new_pes.xmt_bytes/4 - pem.xmt_bytes;o!  	if (rate != pem.xmt_bytes_rate)B  	    {B   	    pem.xmt_bytes_rate = rate;$  	    sprintf (string, "%d", rate);   	    if (rate == 0).  		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget), !  		    x_pos, y_pos, "     ", 3, g  		    w5w);  	    else 	    .  		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget),    		    x_pos, y_pos, string, 3,   		    w5w);  	    }++  	if (new_pes.xmt_bytes/4 != pem.xmt_bytes)   	    {W*  	    pem.xmt_bytes = new_pes.xmt_bytes/4;,  	    sprintf (string, "%d", pem.xmt_bytes);1  	    BannerWriteText (XtDisplay(Bnr.pe_widget), +  		XtWindow(Bnr.pe_widget),v  		lx_pos, y_pos, string, 3, i  		w8w);  	    }("  	y_pos = y_pos + Bnr.font_height;  	}t *5E   	{ '  	rate = new_pes.xmt_msg - pes.xmt_msg;d *5D   	if (rate != pem.xmt_rate)i  	    {;  	    pem.xmt_rate = rate;$  	    sprintf (string, "%d", rate);   	    if (rate == 0).  		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget), !  		    x_pos, y_pos, "     ", 3,    		    w5w);  	    else 	    .  		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget),v   		    x_pos, y_pos, string, 3,   		    w5w);  	    } !  	if (new_pes.xmt_msg != pem.xmt);  	    {_   	    pem.xmt = new_pes.xmt_msg;&  	    sprintf (string, "%d", pem.xmt);1  	    BannerWriteText (XtDisplay(Bnr.pe_widget),    		XtWindow(Bnr.pe_widget),h  		lx_pos, y_pos, string, 3, t  		w8w);  	    }p"  	y_pos = y_pos + Bnr.font_height;  	}   /*    * Next Locks in    */ *5Ec *5Ih  	if (rate != pem.xmt_msg_rate)_  	    {i  	    pem.xmt_msg_rate = rate;$  	    sprintf (string, "%d", rate);   	    if (rate == 0).  		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget), !  		    x_pos, y_pos, "     ", 3,    		    w5w);  	    else 	    .  		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget),W   		    x_pos, y_pos, string, 3,   		    w5w);  	    }_%  	if (new_pes.xmt_msg != pem.xmt_msg)1  	    { $  	    pem.xmt_msg = new_pes.xmt_msg;*  	    sprintf (string, "%d", pem.xmt_msg);1  	    BannerWriteText (XtDisplay(Bnr.pe_widget),    		XtWindow(Bnr.pe_widget),l  		lx_pos, y_pos, string, 3, (  		w8w);  	    } "  	y_pos = y_pos + Bnr.font_height;  	}i  	{;+  	rate = new_pes.xmt_unseq - pes.xmt_unseq; !  	if (rate != pem.xmt_unseq_rate)   	    {B   	    pem.xmt_unseq_rate = rate;$  	    sprintf (string, "%d", rate);   	    if (rate == 0).  		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget), !  		    x_pos, y_pos, "     ", 3, P  		    w5w);  	    else 	    .  		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget),    		    x_pos, y_pos, string, 3,   		    w5w);  	    }I)  	if (new_pes.xmt_unseq != pem.xmt_unseq)   	    { (  	    pem.xmt_unseq = new_pes.xmt_unseq;,  	    sprintf (string, "%d", pem.xmt_unseq);1  	    BannerWriteText (XtDisplay(Bnr.pe_widget), ,  		XtWindow(Bnr.pe_widget),   		lx_pos, y_pos, string, 3,    		w8w);  	    }E"  	y_pos = y_pos + Bnr.font_height;  	}r  	{n'  	rate = new_pes.xmt_seq - pes.xmt_seq;,  	if (rate != pem.xmt_seq_rate)   	    {W  	    pem.xmt_seq_rate = rate;$  	    sprintf (string, "%d", rate);   	    if (rate == 0).  		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget),E!  		    x_pos, y_pos, "     ", 3,    		    w5w);  	    else 	    .  		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget),t   		    x_pos, y_pos, string, 3,   		    w5w);  	    }s%  	if (new_pes.xmt_seq != pem.xmt_seq)R  	    {;$  	    pem.xmt_seq = new_pes.xmt_seq;*  	    sprintf (string, "%d", pem.xmt_seq);1  	    BannerWriteText (XtDisplay(Bnr.pe_widget), ,  		XtWindow(Bnr.pe_widget),   		lx_pos, y_pos, string, 3, t  		w8w);  	    }p"  	y_pos = y_pos + Bnr.font_height;  	}   	{ '  	rate = new_pes.xmt_ack - pes.xmt_ack;   	if (rate != pem.xmt_ack_rate)   	    {i  	    pem.xmt_ack_rate = rate;$  	    sprintf (string, "%d", rate);   	    if (rate == 0).  		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget), !  		    x_pos, y_pos, "     ", 3,    		    w5w);  	    else 	    .  		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget),n   		    x_pos, y_pos, string, 3,   		    w5w);  	    }t%  	if (new_pes.xmt_ack != pem.xmt_ack)w  	    {_$  	    pem.xmt_ack = new_pes.xmt_ack;*  	    sprintf (string, "%d", pem.xmt_ack);1  	    BannerWriteText (XtDisplay(Bnr.pe_widget), -  		XtWindow(Bnr.pe_widget),a  		lx_pos, y_pos, string, 3, r  		w8w);  	    } "  	y_pos = y_pos + Bnr.font_height;  	}n  	{ +  	rate = new_pes.xmt_rexmt - pes.xmt_rexmt;"!  	if (rate != pem.xmt_rexmt_rate)(  	    {"   	    pem.xmt_rexmt_rate = rate;$  	    sprintf (string, "%d", rate);   	    if (rate == 0).  		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget),,!  		    x_pos, y_pos, "     ", 3,    		    w5w);  	    else 	    .  		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget),    		    x_pos, y_pos, string, 3,   		    w5w);  	    }s)  	if (new_pes.xmt_rexmt != pem.xmt_rexmt)C  	    { (  	    pem.xmt_rexmt = new_pes.xmt_rexmt;,  	    sprintf (string, "%d", pem.xmt_rexmt);1  	    BannerWriteText (XtDisplay(Bnr.pe_widget), n  		XtWindow(Bnr.pe_widget),   		lx_pos, y_pos, string, 3, a  		w8w);  	    } "  	y_pos = y_pos + Bnr.font_height;  	}t  	{a-  	rate = new_pes.rcv_bytes/4 - pem.rcv_bytes;,!  	if (rate != pem.rcv_bytes_rate))  	    {	   	    pem.rcv_bytes_rate = rate;$  	    sprintf (string, "%d", rate);   	    if (rate == 0).  		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget), !  		    x_pos, y_pos, "     ", 3, r  		    w5w);  	    else 	    .  		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget),    		    x_pos, y_pos, string, 3,   		    w5w);  	    }e+  	if (new_pes.rcv_bytes/4 != pem.rcv_bytes)n  	    {r*  	    pem.rcv_bytes = new_pes.rcv_bytes/4;,  	    sprintf (string, "%d", pem.rcv_bytes);1  	    BannerWriteText (XtDisplay(Bnr.pe_widget),    		XtWindow(Bnr.pe_widget),   		lx_pos, y_pos, string, 3, t  		w8w);  	    } "  	y_pos = y_pos + Bnr.font_height;  	}  *5E   	{ '  	rate = new_pes.rcv_msg - pes.rcv_msg;  *5D   	if (rate != pem.rcv_rate)   	    {   	    pem.rcv_rate = rate;$  	    sprintf (string, "%d", rate);   	    if (rate == 0).  		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget),p!  		    x_pos, y_pos, "     ", 3, n  		    w5w);  	    else 	    .  		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget),    		    x_pos, y_pos, string, 3,   		    w5w);  	    } !  	if (new_pes.rcv_msg != pem.rcv)/  	    {e   	    pem.rcv = new_pes.rcv_msg;&  	    sprintf (string, "%d", pem.rcv);1  	    BannerWriteText (XtDisplay(Bnr.pe_widget),    		XtWindow(Bnr.pe_widget),x  		lx_pos, y_pos, string, 3,    		w8w);  	    }c"  	y_pos = y_pos + Bnr.font_height;  	}   /*    * Next Locks out   */  	{ 8  	newkb = (new_pes.xmt_bytes/4) + (new_pes.rcv_bytes/4);  	rate = newkb - pem.kbyte;   	if (rate != pem.kbyte_rate)y  	    {n  	    pem.kbyte_rate = rate;$  	    sprintf (string, "%d", rate);   	    if (rate == 0).  		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget),e!  		    x_pos, y_pos, "     ", 3, w  		    w5w);  	    else 	    .  		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget),    		    x_pos, y_pos, string, 3,   		    w5w);  	    }   	if (newkb != pem.kbyte)h  	    {   	    pem.kbyte = newkb;(  	    sprintf (string, "%d", pem.kbyte);1  	    BannerWriteText (XtDisplay(Bnr.pe_widget), s  		XtWindow(Bnr.pe_widget),(  		lx_pos, y_pos, string, 3,    		w8w);  	    }t"  	y_pos = y_pos + Bnr.font_height;  	}d  /*t   * Locks enq wait   */ *5EB *5IW  	if (rate != pem.rcv_msg_rate))  	    {   	    pem.rcv_msg_rate = rate;$  	    sprintf (string, "%d", rate);   	    if (rate == 0).  		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget),)!  		    x_pos, y_pos, "     ", 3,    		    w5w);  	    else 	    .  		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget),    		    x_pos, y_pos, string, 3,   		    w5w);  	    }T%  	if (new_pes.rcv_msg != pem.rcv_msg)W  	    {.$  	    pem.rcv_msg = new_pes.rcv_msg;*  	    sprintf (string, "%d", pem.rcv_msg);1  	    BannerWriteText (XtDisplay(Bnr.pe_widget), t  		XtWindow(Bnr.pe_widget),e  		lx_pos, y_pos, string, 3, d  		w8w);  	    }	"  	y_pos = y_pos + Bnr.font_height;  	}r  	{ +  	rate = new_pes.rcv_unseq - pes.rcv_unseq;f!  	if (rate != pem.rcv_unseq_rate)t  	    {n   	    pem.rcv_unseq_rate = rate;$  	    sprintf (string, "%d", rate);   	    if (rate == 0).  		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget),W!  		    x_pos, y_pos, "     ", 3, s  		    w5w);  	    else 	    .  		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget),	   		    x_pos, y_pos, string, 3,   		    w5w);  	    } )  	if (new_pes.rcv_unseq != pem.rcv_unseq);  	    {a(  	    pem.rcv_unseq = new_pes.rcv_unseq;,  	    sprintf (string, "%d", pem.rcv_unseq);1  	    BannerWriteText (XtDisplay(Bnr.pe_widget), o  		XtWindow(Bnr.pe_widget),	  		lx_pos, y_pos, string, 3, n  		w8w);  	    }t"  	y_pos = y_pos + Bnr.font_height;  	}   	{ '  	rate = new_pes.rcv_seq - pes.rcv_seq;   	if (rate != pem.rcv_seq_rate))  	    {   	    pem.rcv_seq_rate = rate;$  	    sprintf (string, "%d", rate);   	    if (rate == 0).  		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget),e!  		    x_pos, y_pos, "     ", 3, )  		    w5w);  	    else 	    .  		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget),_   		    x_pos, y_pos, string, 3,   		    w5w);  	    }d%  	if (new_pes.rcv_seq != pem.rcv_seq)p  	    {r$  	    pem.rcv_seq = new_pes.rcv_seq;*  	    sprintf (string, "%d", pem.rcv_seq);1  	    BannerWriteText (XtDisplay(Bnr.pe_widget), t  		XtWindow(Bnr.pe_widget),n  		lx_pos, y_pos, string, 3, i  		w8w);  	    }	"  	y_pos = y_pos + Bnr.font_height;  	}s  	{	+  	rate = new_pes.rcv_cache - pes.rcv_cache;	!  	if (rate != pem.rcv_cache_rate)   	    {    	    pem.rcv_cache_rate = rate;$  	    sprintf (string, "%d", rate);   	    if (rate == 0).  		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget),;!  		    x_pos, y_pos, "     ", 3, e  		    w5w);  	    else 	    .  		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget),    		    x_pos, y_pos, string, 3,   		    w5w);  	    }	)  	if (new_pes.rcv_cache != pem.rcv_cache)y  	    {	(  	    pem.rcv_cache = new_pes.rcv_cache;,  	    sprintf (string, "%d", pem.rcv_cache);1  	    BannerWriteText (XtDisplay(Bnr.pe_widget), p  		XtWindow(Bnr.pe_widget),	  		lx_pos, y_pos, string, 3, o  		w8w);  	    }5"  	y_pos = y_pos + Bnr.font_height;  	}x *5Eg  	{5+  	rate = new_pes.rcv_rercv - pes.rcv_rercv;	 *5De2  	rate = rate + new_pes.xmt_rexmt - pes.xmt_rexmt;  	if (rate != pem.retry_rate)B  	    {e  	    pem.retry_rate = rate;$  	    sprintf (string, "%d", rate);   	    if (rate == 0).  		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget),e!  		    x_pos, y_pos, "     ", 3, w  		    w5w);  	    else 	    .  		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget),    		    x_pos, y_pos, string, 3,   		    w5w);  	    }"/  	rate = new_pes.rcv_rercv + new_pes.xmt_rexmt;B  	if (rate != pem.retry)  	    {e  	    pem.retry = rate;p(  	    sprintf (string, "%d", pem.retry);1  	    BannerWriteText (XtDisplay(Bnr.pe_widget), t  		XtWindow(Bnr.pe_widget),   		lx_pos, y_pos, string, 3, _  		w8w);  	    }e"  	y_pos = y_pos + Bnr.font_height;  	}r  /*"   * Directory rate   */ *5E  *5I	!  	if (rate != pem.rcv_rercv_rate)w  	    {    	    pem.rcv_rercv_rate = rate;$  	    sprintf (string, "%d", rate);   	    if (rate == 0).  		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget),d!  		    x_pos, y_pos, "     ", 3, ,  		    w5w);  	    else 	    .  		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget),s   		    x_pos, y_pos, string, 3,   		    w5w);  	    }n)  	if (new_pes.rcv_rercv != pem.rcv_rercv)	  	    {((  	    pem.rcv_rercv = new_pes.rcv_rercv;,  	    sprintf (string, "%d", pem.rcv_rercv);1  	    BannerWriteText (XtDisplay(Bnr.pe_widget), u  		XtWindow(Bnr.pe_widget),(  		lx_pos, y_pos, string, 3, 	  		w8w);  	    }m"  	y_pos = y_pos + Bnr.font_height;  	}n  	{d'  	rate = new_pes.rcv_ack - pes.rcv_ack;e  	if (rate != pem.rcv_ack_rate)e  	    {   	    pem.rcv_ack_rate = rate;$  	    sprintf (string, "%d", rate);   	    if (rate == 0).  		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget),e!  		    x_pos, y_pos, "     ", 3, 3  		    w5w);  	    else 	    .  		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget),m   		    x_pos, y_pos, string, 3,   		    w5w);  	    }	%  	if (new_pes.rcv_ack != pem.rcv_ack)i  	    { $  	    pem.rcv_ack = new_pes.rcv_ack;*  	    sprintf (string, "%d", pem.rcv_ack);1  	    BannerWriteText (XtDisplay(Bnr.pe_widget), a  		XtWindow(Bnr.pe_widget),t  		lx_pos, y_pos, string, 3, e  		w8w);  	    } "  	y_pos = y_pos + Bnr.font_height;  	}i  	{s7  	rate = new_pes.topology_change - pes.topology_change;e'  	if (rate != pem.topology_change_rate)X  	    {n&  	    pem.topology_change_rate = rate;$  	    sprintf (string, "%d", rate);   	    if (rate == 0).  		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget),_!  		    x_pos, y_pos, "     ", 3,    		    w5w);  	    else 	    .  		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget),n   		    x_pos, y_pos, string, 3,   		    w5w);  	    }B5  	if (new_pes.topology_change != pem.topology_change)o  	    { 4  	    pem.topology_change = new_pes.topology_change;2  	    sprintf (string, "%d", pem.topology_change);1  	    BannerWriteText (XtDisplay(Bnr.pe_widget),    		XtWindow(Bnr.pe_widget),a  		lx_pos, y_pos, string, 3, n  		w8w);  	    }	"  	y_pos = y_pos + Bnr.font_height;  	}t  	{a1  	rate = new_pes.npagedyn_low - pes.npagedyn_low; $  	if (rate != pem.npagedyn_low_rate)  	    {w#  	    pem.npagedyn_low_rate = rate;e$  	    sprintf (string, "%d", rate);   	    if (rate == 0).  		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget),_!  		    x_pos, y_pos, "     ", 3,    		    w5w);  	    else 	    .  		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget),r   		    x_pos, y_pos, string, 3,   		    w5w);  	    }y/  	if (new_pes.npagedyn_low != pem.npagedyn_low)   	    {n.  	    pem.npagedyn_low = new_pes.npagedyn_low;/  	    sprintf (string, "%d", pem.npagedyn_low);e1  	    BannerWriteText (XtDisplay(Bnr.pe_widget), t  		XtWindow(Bnr.pe_widget),d  		lx_pos, y_pos, string, 3, )  		w8w);  	    }t"  	y_pos = y_pos + Bnr.font_height;  	}n  	{n+  	rate = new_pes.xmt_noxch - pes.xmt_noxch; !  	if (rate != pem.xmt_noxch_rate)   	    {e   	    pem.xmt_noxch_rate = rate;$  	    sprintf (string, "%d", rate);   	    if (rate == 0).  		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget), !  		    x_pos, y_pos, "     ", 3, _  		    w5w);  	    else 	    .  		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget),    		    x_pos, y_pos, string, 3,   		    w5w);  	    },)  	if (new_pes.xmt_noxch != pem.xmt_noxch)n  	    {i(  	    pem.xmt_noxch = new_pes.xmt_noxch;,  	    sprintf (string, "%d", pem.xmt_noxch);1  	    BannerWriteText (XtDisplay(Bnr.pe_widget), r  		XtWindow(Bnr.pe_widget),"  		lx_pos, y_pos, string, 3,    		w8w);  	    }e"  	y_pos = y_pos + Bnr.font_height;  	}W *5E(  	{e3  	rate = new_pes.tr_pipe_quota - pes.tr_pipe_quota;  *5D;   	if (rate != pem.pipefull_rate)  	    {i  	    pem.pipefull_rate = rate;W$  	    sprintf (string, "%d", rate);   	    if (rate == 0).  		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget), !  		    x_pos, y_pos, "     ", 3, /  		    w5w);  	    else 	    .  		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget),(   		    x_pos, y_pos, string, 3,   		    w5w);  	    };,  	if (new_pes.tr_pipe_quota != pem.pipefull)  	    {5+  	    pem.pipefull = new_pes.tr_pipe_quota;m+  	    sprintf (string, "%d", pem.pipefull); 1  	    BannerWriteText (XtDisplay(Bnr.pe_widget), r  		XtWindow(Bnr.pe_widget),(  		lx_pos, y_pos, string, 3, (  		w8w);  	    }d"  	y_pos = y_pos + Bnr.font_height;  	}   /*    *Locks search    */  	{   	int temp; G  	temp = new_pes.hs_tmo + new_pes.xmt_seq_tmo + new_pes.rcv_listen_tmo;X  	rate = temp - pem.timeout;  	if (rate != pem.timeout_rate)   	    {   	    pem.timeout_rate = rate;$  	    sprintf (string, "%d", rate);   	    if (rate == 0).  		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget),g!  		    x_pos, y_pos, "     ", 3, x  		    w5w);  	    else 	    .  		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget),c   		    x_pos, y_pos, string, 3,   		    w5w);  	    }w  	if (temp != pem.timeout)  	    {p  	    pem.timeout = temp;e*  	    sprintf (string, "%d", pem.timeout);1  	    BannerWriteText (XtDisplay(Bnr.pe_widget), 	  		XtWindow(Bnr.pe_widget),W  		lx_pos, y_pos, string, 3, e  		w8w);  	    }o"  	y_pos = y_pos + Bnr.font_height;  	}"  /*"   * Locks find rate    */  	{	  	int temp;e *5Ee *2I( *5Dp  /*n *5Ew *2E) *5D	I  	temp = new_pes.xmt_noxch + new_pes.xmt_rcv_norch + new_pes.rcv_tr_shortwH  	    + new_pes.rcv_cc_short + new_pes.rcv_ill_ack + new_pes.rcv_ill_seq:  	    + new_pes.rcv_cc_bad_eco + new_pes.rcv_cc_authorize 4  	    + new_pes.tr_dfq_empty + new_pes.tr_mfq_empty 4  	    + new_pes.cc_dfq_empty + new_pes.cc_mfq_empty; *5E  *2I  *5Do  */_  	temp = new_pes.rcv_tr_short/H  	    + new_pes.rcv_cc_short + new_pes.rcv_ill_ack + new_pes.rcv_ill_seq:  	    + new_pes.rcv_cc_bad_eco + new_pes.rcv_cc_authorize 4  	    + new_pes.tr_dfq_empty + new_pes.tr_mfq_empty 4  	    + new_pes.cc_dfq_empty + new_pes.cc_mfq_empty;  . *5Ed *2E) *5D   	rate = temp - pem.miscerr;  	if (rate != pem.miscerr_rate)   	    {W  	    pem.miscerr_rate = rate;$  	    sprintf (string, "%d", rate);   	    if (rate == 0).  		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget), !  		    x_pos, y_pos, "     ", 3, c  		    w5w);  	    else 	    .  		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget),o   		    x_pos, y_pos, string, 3,   		    w5w);  	    }w  	if (temp != pem.miscerr)  	    {o  	    pem.miscerr = temp;a*  	    sprintf (string, "%d", pem.miscerr);1  	    BannerWriteText (XtDisplay(Bnr.pe_widget), e  		XtWindow(Bnr.pe_widget),   		lx_pos, y_pos, string, 3,    		w8w);  	    } "  	y_pos = y_pos + Bnr.font_height;  	}w  /*)   * Locks msgs o   */ *5Ed *5IW%  	if (rate != pem.tr_pipe_quota_rate)	  	    {;$  	    pem.tr_pipe_quota_rate = rate;$  	    sprintf (string, "%d", rate);   	    if (rate == 0).  		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget),n!  		    x_pos, y_pos, "     ", 3, 	  		    w5w);  	    else 	    .  		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget),s   		    x_pos, y_pos, string, 3,   		    w5w);  	    }l1  	if (new_pes.tr_pipe_quota != pem.tr_pipe_quota)_  	    {o0  	    pem.tr_pipe_quota = new_pes.tr_pipe_quota;0  	    sprintf (string, "%d", pem.tr_pipe_quota);1  	    BannerWriteText (XtDisplay(Bnr.pe_widget),    		XtWindow(Bnr.pe_widget),r  		lx_pos, y_pos, string, 3, 	  		w8w);  	    }t"  	y_pos = y_pos + Bnr.font_height;  	}(  	{e1  	rate = new_pes.rcv_tr_short - pes.rcv_tr_short; $  	if (rate != pem.rcv_tr_short_rate)  	    {(#  	    pem.rcv_tr_short_rate = rate;W$  	    sprintf (string, "%d", rate);   	    if (rate == 0).  		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget),.!  		    x_pos, y_pos, "     ", 3, p  		    w5w);  	    else 	    .  		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget),)   		    x_pos, y_pos, string, 3,   		    w5w);  	    }	/  	if (new_pes.rcv_tr_short != pem.rcv_tr_short)a  	    {p.  	    pem.rcv_tr_short = new_pes.rcv_tr_short;/  	    sprintf (string, "%d", pem.rcv_tr_short);_1  	    BannerWriteText (XtDisplay(Bnr.pe_widget),    		XtWindow(Bnr.pe_widget),e  		lx_pos, y_pos, string, 3, d  		w8w);  	    }n"  	y_pos = y_pos + Bnr.font_height;  	},  	{ /  	rate = new_pes.rcv_ill_ack - pes.rcv_ill_ack;e#  	if (rate != pem.rcv_ill_ack_rate)   	    {X"  	    pem.rcv_ill_ack_rate = rate;$  	    sprintf (string, "%d", rate);   	    if (rate == 0).  		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget),;!  		    x_pos, y_pos, "     ", 3, r  		    w5w);  	    else 	    .  		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget),t   		    x_pos, y_pos, string, 3,   		    w5w);  	    }t-  	if (new_pes.rcv_ill_ack != pem.rcv_ill_ack)v  	    {p,  	    pem.rcv_ill_ack = new_pes.rcv_ill_ack;.  	    sprintf (string, "%d", pem.rcv_ill_ack);1  	    BannerWriteText (XtDisplay(Bnr.pe_widget),    		XtWindow(Bnr.pe_widget),r  		lx_pos, y_pos, string, 3, 	  		w8w);  	    }t"  	y_pos = y_pos + Bnr.font_height;  	}(  	{e/  	rate = new_pes.rcv_ill_seq - pes.rcv_ill_seq;	#  	if (rate != pem.rcv_ill_seq_rate)e  	    {t"  	    pem.rcv_ill_seq_rate = rate;$  	    sprintf (string, "%d", rate);   	    if (rate == 0).  		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget),(!  		    x_pos, y_pos, "     ", 3,    		    w5w);  	    else 	    .  		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget),    		    x_pos, y_pos, string, 3,   		    w5w);  	    },-  	if (new_pes.rcv_ill_seq != pem.rcv_ill_seq)o  	    {;,  	    pem.rcv_ill_seq = new_pes.rcv_ill_seq;.  	    sprintf (string, "%d", pem.rcv_ill_seq);1  	    BannerWriteText (XtDisplay(Bnr.pe_widget),    		XtWindow(Bnr.pe_widget),   		lx_pos, y_pos, string, 3, e  		w8w);  	    }e"  	y_pos = y_pos + Bnr.font_height;  	})  	{	3  	rate = new_pes.rcv_bad_cksum - pes.rcv_bad_cksum; %  	if (rate != pem.rcv_bad_cksum_rate)a  	    {w$  	    pem.rcv_bad_cksum_rate = rate;$  	    sprintf (string, "%d", rate);   	    if (rate == 0).  		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget),e!  		    x_pos, y_pos, "     ", 3, r  		    w5w);  	    else 	    .  		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget),l   		    x_pos, y_pos, string, 3,   		    w5w);  	    } 1  	if (new_pes.rcv_bad_cksum != pem.rcv_bad_cksum)p  	    {k0  	    pem.rcv_bad_cksum = new_pes.rcv_bad_cksum;0  	    sprintf (string, "%d", pem.rcv_bad_cksum);1  	    BannerWriteText (XtDisplay(Bnr.pe_widget), )  		XtWindow(Bnr.pe_widget),a  		lx_pos, y_pos, string, 3, n  		w8w);  	    }e"  	y_pos = y_pos + Bnr.font_height;  	}   	{w/  	rate = new_pes.xmt_seq_tmo - pes.xmt_seq_tmo;a#  	if (rate != pem.xmt_seq_tmo_rate)n  	    {e"  	    pem.xmt_seq_tmo_rate = rate;$  	    sprintf (string, "%d", rate);   	    if (rate == 0).  		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget),d!  		    x_pos, y_pos, "     ", 3, T  		    w5w);  	    else 	    .  		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget),    		    x_pos, y_pos, string, 3,   		    w5w);  	    }=-  	if (new_pes.xmt_seq_tmo != pem.xmt_seq_tmo)e  	    {a,  	    pem.xmt_seq_tmo = new_pes.xmt_seq_tmo;.  	    sprintf (string, "%d", pem.xmt_seq_tmo);1  	    BannerWriteText (XtDisplay(Bnr.pe_widget), 	  		XtWindow(Bnr.pe_widget),n  		lx_pos, y_pos, string, 3, (  		w8w);  	    }	"  	y_pos = y_pos + Bnr.font_height;  	}w *5E   	{  *5D	  	int node_count;e  	VMS_ItemList sys_item[2] = {9  	    4, SYI$_CLUSTER_NODES, &node_count, 0, 0, 0, 0, 0};r  ,  	=  	SYS$GETSYI (NULL, NULL, NULL, &sys_item, NULL, NULL, NULL);t  l+  	if (new_pes.rcv_bad_chksum != pem.badchk)a  	    {_*  	    pem.badchk = new_pes.rcv_bad_chksum;-  	    sprintf (string, "Bad %d", pem.badchk);T1  	    BannerWriteText (XtDisplay(Bnr.pe_widget), e  		XtWindow(Bnr.pe_widget),   		x_pos, y_pos, string, 3,   		w5w);  	    } $  	if (node_count != pem.badchk_rate) *5Ew *5In   	rate = (new_pes.tr_dfq_empty +   	        new_pes.tr_mfq_empty +   	        new_pes.cc_dfq_empty +!  	        new_pes.cc_mfq_empty) -r  	       (pes.tr_dfq_empty +  	        pes.tr_mfq_empty +  	        pes.cc_dfq_empty +  	        pes.cc_mfq_empty);   	if (rate != pem.fq_empty_rate) *5E   	    {w *5D	#  	    pem.badchk_rate = node_count;t*  	    sprintf (string, "%d", node_count);  *5Ew *5I)  	    pem.fq_empty_rate = rate;3$  	    sprintf (string, "%d", rate);   	    if (rate == 0).  		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget), !  		    x_pos, y_pos, "     ", 3, _  		    w5w);  	    else 	     *5El.  		BannerWriteText (XtDisplay(Bnr.pe_widget),   		    XtWindow(Bnr.pe_widget),) *5Dw!  		    lx_pos, y_pos, string, 3, n  		    w8w); *5En *5In   		    x_pos, y_pos, string, 3,   		    w5w);  	    }e  	if ((new_pes.tr_dfq_empty +   	    new_pes.tr_mfq_empty +  	    new_pes.cc_dfq_empty +,  	    new_pes.cc_mfq_empty) != pem.fq_empty)  	    {t+  	    pem.fq_empty = new_pes.tr_dfq_empty +(!  	    		   new_pes.tr_mfq_empty +o+  	                   new_pes.cc_dfq_empty + *  	                   new_pes.cc_mfq_empty;+  	    sprintf (string, "%d", pem.fq_empty); 1  	    BannerWriteText (XtDisplay(Bnr.pe_widget), ,  		XtWindow(Bnr.pe_widget),p  		lx_pos, y_pos, string, 3,    		w8w); *5E   	    }m"  	y_pos = y_pos + Bnr.font_height;  	}m *5Dn%  memcpy(&pes, &new_pes, sizeof(pes));y *5Ep *5Ig  ,+        memcpy(&pes, &new_pes, sizeof(pes));y  s   */    *5E   }