  #module BannerProcess "V1.0"      /*   **++   **  FACILITY:  ** %  **      The DECwindow Banner program   **   **  ABSTRACT:  ** D  **      This rouitne controls the display of the Top Cpu processes.  ** 
  **  AUTHORS:   **   **      Jim Saunders   **   ** $  **  CREATION DATE:     1st Aug 1988  **   **  MODIFICATION HISTORY:  **--   **/    *11D  #include <stdio.h> ,  #include <decw$include/DECwDwtWidgetProg.h> *11E *11I     #include "stdio.h"   #include "MrmAppl.h"     *11E  #include "Banner" *11D  #include <jpidef.h>  #include <syidef.h>  #include <ssdef.h>  *11E *11I     #include "jpidef.h"  #include "syidef.h"  #include "ssdef.h"     *11E      ?  #define SCH$C_COLPG  1                /* COLLIDED PAGE WAIT */ R  #define SCH$C_MWAIT  2                /* MUTEX AND MISCELLANEOUS RESOURCE WAIT */I  #define SCH$C_CEF  3                  /* COMMON EVENT FLAG WAIT STATE */ <  #define SCH$C_PFW  4                  /* PAGE FAULT WAIT */B  #define SCH$C_LEF  5                  /* LOCAL EVENT FLAG WAIT */U  #define SCH$C_LEFO  6                 /* LOCAL EVENT FLAG WAIT OUT OF BALANCE SET */ ;  #define SCH$C_HIB  7                  /* HIBERNATE WAIT */ N  #define SCH$C_HIBO  8                 /* HIBERNATE WAIT OUT OF BALANCE SET */6  #define SCH$C_SUSP  9                 /* SUSPENDED */M  #define SCH$C_SUSPO  10               /* SUSPENDED OUT OF THE BALANCE SET */ :  #define SCH$C_FPG  11                 /* FREEPAGE WAIT */J  #define SCH$C_COM  12                 /* COMPUTE, IN BALANCE SET STATE */O  #define SCH$C_COMO  13                /* COMPUTE, OUT OF BALANCE SET STATE */  B  #define SCH$C_CUR  14                 /* CURRENT PROCESS STATE */        /*   **   **  MACRO DEFINITIONS  **   **/            typedef struct _vms_item_list {  	short	 buffer_length;   	short	 item_code;   	void	*buffer;   	int	*returned_buffer_length;  	} VMS_ItemList;         typedef struct {       char *name;      char *user;      int  resident;       int  pid;      int  mode;       int  seen;  *5D       int  name_changed;  *5E  *5I       short int  name_changed;       short int  highlighted; *5E       float  display_size;       int  percent;      float  bufcnt;       float  diff_bufcnt;      float  old_bufcnt;       float  diocnt;       float  diff_diocnt;      float  old_diocnt;       float  cputim;       float  diff_cputim;      float  old_cputim;       float  pageflts;       float  diff_pageflts;      float  old_pageflts;       } Bnr$Process;      static void PaintDisplay ();   static void GetNewInfo ();   /* #   * now our runtime data structures    */    *12I  extern	 Son$_Blk    Son;  *12E  extern	 Bnr$_Blk    Bnr;   extern	 Clk$_Blk    Clk;   extern	 GC	     BannerGC;  extern	 XGCValues   GcValues; *13I *14D,  extern   char	     *BannerVmsDisplayName[]; *14E *14I*  extern   char	     *BannerVmsDisplayName; *14E *13E(  extern   char	     BannerVmsNodeName[];'  extern   char	     BannerVmsVersion[];    Q  static int lef, hib, com, pfw, mwait, lefo, hibo, como, cef, colpg, fpg, others; O  static int old_lef, old_hib, old_com, old_pfw, old_mwait, old_lefo, old_hibo,  7  	   old_como, old_others, old_cef, old_colpg, old_fpg;  *5I K  static int old_lef1, old_hib1, old_com1, old_pfw1, old_mwait1, old_lefo1,  G  	   old_hibo1, old_como1, old_others1, old_cef1, old_colpg1, old_fpg1;  *5E    J  static int total_states_width, states_col_1, states_name_2, states_col_2,  	states_num_width;    F  static int old_net, old_batch, old_interactive, old_oswap, old_total;    *5I   static int mwait_x, mwait_y;  *5E   static int percent;  static int name_width;   static int pid_width;  static int user_width;   static int our_pid = 0;  static int null_pid = 0;   static int num_oswap = 0;  static int num_process = 0;   static int num_interactive = 0;  static int num_batch = 0;  static int num_sub = 0;  static int num_net = 0;  static int num_total = 0;   static int process_display = 0;"  static int (*processes)[] = NULL;&  static int (*top_processes)[] = NULL;)  static int (*oldtop_processes)[] = NULL;   static Bnr$Process *process;      static int process_init = 0;   static int process_update; !  static int process_update_count;      static float total_cpu;  static int display_size;      static char name[20];  static char user[20];F  static int  pid, pageflts, diocnt, bufcnt, cputim, mode, sts, state; (  static VMS_ItemList modeitemlist[7] = {      4,  JPI$_PID, &pid, 0,       4,  JPI$_MODE, &mode, 0,       4,  JPI$_STATE, &state, 0,       4,  JPI$_STS, &sts, 0,       20, JPI$_PRCNAM, &name, 0, !      20, JPI$_USERNAME, &user, 0,       0,  0, 0, 0};$  static VMS_ItemList itemlist[5] = {%      4,  JPI$_PAGEFLTS, &pageflts, 0,        4,	JPI$_DIOCNT, &diocnt, 0,!      4,  JPI$_BIOCNT, &bufcnt, 0,        4,	JPI$_CPUTIM, &cputim, 0,      0,  0, 0, 0};        typedef struct _cpudata {  char fill_1[632];  int cpu$l_kernel;  int cpu$l_executive;   int cpu$l_super;   int cpu$l_user;  int cpu$l_interrupt;   int cpu$l_compatibility;   int cpu$l_spinlock;  int cpu$l_nullcpu;   } cpu$data;   !  static int BannerActiveCpuCount; %  static int BannerLastActiveCpuCount;        H  globalref cpu$data *SMP$GL_CPU_DATA[];	    /* CPU data pointer array */<  globalref int SMP$GL_ACTIVE_CPUS;	    /* Active cpu mask */       /*   **++   **  FUNCTIONAL DESCRIPTION:  **   **	BannerProcessSetup ()   ** M  **      This routine does all the one only setup for the Processes display,  J  **	it is called at initilialisation time, and once every time the display  **	changes size.   **   **  FORMAL PARAMETERS:   ** 
  **      none   **   **  IMPLICIT INPUTS:   ** 
  **      none   **   **  IMPLICIT OUTPUTS:  ** 
  **      none   **   **  COMPLETION CODES:  ** 
  **      none   **   **  SIDE EFFECTS:  ** 
  **      none   **   **--   **/  void	  BannerProcessSetup()   {  int status, i, old_size;   /* 1   * First get our PID, so we can reconise ourself    */   P      if ( (status = SYS$GETJPIW (NULL, NULL, NULL, &itemlist, NULL, NULL, NULL))  	 != 1)E  	BannerSignalError ("Failed to get the time for SYS$GETJPI service",   	    status);         our_pid = pid;       6      percent = XTextWidth (Bnr.font_ptr, " 999%", 5); ;      pid_width = XTextWidth (Bnr.font_ptr, "9999XXXX", 8);     '      if (Bnr.Param_Bits.process_states)   	{ 8  	states_num_width = XTextWidth (Bnr.font_ptr, "99", 2);9  	states_col_1 = XTextWidth (Bnr.font_ptr, "MWAIT  ", 7); 3  	states_name_2 = states_col_1 + states_num_width +   	    Bnr.font_width; J  	states_col_2 = states_name_2 + XTextWidth (Bnr.font_ptr, "Others  ", 8);I  	total_states_width =  states_col_2 + states_num_width + Bnr.font_width;   	} 	      else   	total_states_width = 0;   /*     * now register the top process   */          old_size = process_display;@      process_display = (Bnr.process_height/Bnr.font_height) - 2;         if (process_display <= 0)  	process_display = 1;  	          if (old_size == 0)   	{ ;  	top_processes = XtMalloc (sizeof(int) * process_display); >  	oldtop_processes = XtMalloc (sizeof(int) * process_display);  	} 	      else   	{   	XtFree (top_processes); >  	top_processes = XtMalloc (sizeof(int) * process_display);     	XtFree (oldtop_processes);A  	oldtop_processes = XtMalloc (sizeof(int) * process_display);      	}    &      for (i=0; i<process_display; i++)!  	(*top_processes)[i] = NULL;          /* 0   * clear all fields in the current pocess count   */      user_width = 0;      name_width = 0;"      for (i=0; i<num_process; i++)  	{   	process = (*processes)[i];  	process->pid = -1;  	}   /* 4   * Now make an initial call to get all the process.   */      GetNewInfo ();     *12D      old_total = 0;  *12E *12I      old_interactive = 0;  *12E         process_update = 1;!      if (Bnr.process_update == 0) (  	process_update_count = Bnr.cpu_update;	      else ,  	process_update_count = Bnr.process_update;         process_init = 1;  }    /*   **++   **  FUNCTIONAL DESCRIPTION:  **   **	BannerProcessRefresh ()   ** L  **      This routine refreshes all the static information about the currentJ  **	processes display. It is called each time the screen needs repainting.  **   **  FORMAL PARAMETERS:   ** 
  **      none   **   **  IMPLICIT INPUTS:   ** 
  **      none   **   **  IMPLICIT OUTPUTS:  ** 
  **      none   **   **  COMPLETION CODES:  ** 
  **      none   **   **  SIDE EFFECTS:  ** 
  **      none   **   **--   **/  void	  BannerProcessRefresh()   {  int x, y, i, name_width;         /*    * check we are initialised   */      if (!process_init)   	BannerProcessSetup ();  /*  *10D$   * First display our node name etc.   */O  	BannerWriteText (XtDisplay(Bnr.process_widget), XtWindow(Bnr.process_widget), 0  	    0, Bnr.font_height, BannerVmsNodeName, 2,   	    Bnr.process_width);      /*  *10E4   * clear memory so we will repaint all the display.   */&      for (i=0; i<process_display; i++)  	(*oldtop_processes)[i] = 0;      /*    *Paint the process_states    */'      if (Bnr.Param_Bits.process_states)   	{ H          old_lef = old_hib = old_com = old_pfw = old_mwait = old_lefo = >  	    old_hibo = old_como = old_others = old_cef = old_colpg =  	    old_fpg = -1;      	y = 3*Bnr.font_height + 2;-  	x = Bnr.process_width - total_states_width;    O  	BannerWriteText (XtDisplay(Bnr.process_widget), XtWindow(Bnr.process_widget),   	    x, y, "LEF", 1,   	    states_col_1);O  	BannerWriteText (XtDisplay(Bnr.process_widget), XtWindow(Bnr.process_widget), '  	    x + states_name_2, y, "LEFO", 1,  $  	    states_col_2 - states_name_2);  	y = y + Bnr.font_height;   O  	BannerWriteText (XtDisplay(Bnr.process_widget), XtWindow(Bnr.process_widget),   	    x, y, "HIB", 1,   	    states_col_1);O  	BannerWriteText (XtDisplay(Bnr.process_widget), XtWindow(Bnr.process_widget), '  	    x + states_name_2, y, "HIBO", 1,  $  	    states_col_2 - states_name_2);  	y = y + Bnr.font_height;   O  	BannerWriteText (XtDisplay(Bnr.process_widget), XtWindow(Bnr.process_widget),   	    x, y, "COM", 1,   	    states_col_1);O  	BannerWriteText (XtDisplay(Bnr.process_widget), XtWindow(Bnr.process_widget), '  	    x + states_name_2, y, "COMO", 1, o$  	    states_col_2 - states_name_2);  	y = y + Bnr.font_height;  *O  	BannerWriteText (XtDisplay(Bnr.process_widget), XtWindow(Bnr.process_widget),   	    x, y, "PFW", 1,   	    states_col_1);O  	BannerWriteText (XtDisplay(Bnr.process_widget), XtWindow(Bnr.process_widget), &  	    x + states_name_2, y, "CEF", 1, $  	    states_col_2 - states_name_2);  	y = y + Bnr.font_height;  .O  	BannerWriteText (XtDisplay(Bnr.process_widget), XtWindow(Bnr.process_widget),.  	    x, y, "COLPG", 1,   	    states_col_1);O  	BannerWriteText (XtDisplay(Bnr.process_widget), XtWindow(Bnr.process_widget), &  	    x + states_name_2, y, "FPG", 1, $  	    states_col_2 - states_name_2);  	y = y + Bnr.font_height;    *5I   	mwait_x = x;  	mwait_y = y;  S *5E*O  	BannerWriteText (XtDisplay(Bnr.process_widget), XtWindow(Bnr.process_widget),L  	    x, y, "MWAIT", 1,   	    states_col_1); *5I#  i *5EHO  	BannerWriteText (XtDisplay(Bnr.process_widget), XtWindow(Bnr.process_widget),i)  	    x + states_name_2, y, "Others", 1, T$  	    states_col_2 - states_name_2);  	y = y + Bnr.font_height;  	  	}   /*C    * paint the rest of the screen   */ *12D      old_total = 0;# *12E *12I      old_interactive = 0;  *12E         PaintDisplay ();*  }    /*S  **++G  **  FUNCTIONAL DESCRIPTION:  **I  **	PaintDisplay ()C  **2>  **      This routine paints the display for the TOP processes  **C  **  FORMAL PARAMETERS:   **T
  **      noneC  **   **  IMPLICIT INPUTS:H  **R
  **      none   **/  **  IMPLICIT OUTPUTS:  ** 
  **      none   **   **  COMPLETION CODES:  **/
  **      nonet  **f  **  SIDE EFFECTS:  ** 
  **      none_  **h  **--h  **/  static int hist;*
  static void		  PaintDisplay()l  {  int x, x1, y, i;t *2D >  char buffer[] = "                                         ";  *2Et *2IiR  char buffer[] = "                                                             ";  *2E  *8I  *10I  int uptime[2];   int curtime[2];  int uplen;   char upstr [15];   int updesc[2] = {13, upstr};   char nodebuf[50]; *10E  static title_highlighted = 0; *8E  *10I  VMS_ItemList sysitem[2] = {5      8, SYI$_BOOTTIME, &uptime, &uplen, 0, 0, 0, 0}; i  t     /*f3   * First display our node name, and system uptime.    */<  	SYS$GETSYI (NULL, NULL, NULL, &sysitem, NULL, NULL, NULL);#  	memset (upstr, 0, sizeof(upstr));P  	SYS$GETTIM (&curtime);,  	LIB$SUBX(&uptime, &curtime, &uptime, &2); &  	SYS$ASCTIM (0, &updesc, &uptime, 0);B  	sprintf (nodebuf, "%s  (Uptime =%s)", BannerVmsNodeName, upstr);    *13DO  	BannerWriteText (XtDisplay(Bnr.process_widget), XtWindow(Bnr.process_widget),s&  	    0, Bnr.font_height, nodebuf, 2,   	    Bnr.process_width);[ *13E *10E *13D  r *13E *13I#  	if (BannerVmsDisplayName == NULL)   	    { S  	    BannerWriteText (XtDisplay(Bnr.process_widget), XtWindow(Bnr.process_widget), #  		0, Bnr.font_height, nodebuf, 2, h  		Bnr.process_width);  	    }s  	else  	    {lS  	    BannerWriteText (XtDisplay(Bnr.process_widget), XtWindow(Bnr.process_widget),d0  		0, Bnr.font_height, BannerVmsDisplayName, 2,   		Bnr.process_width);  	    }o *13E  /*1   * First paint the dtotal lineo   */    *8Do  	if (old_net != num_net ||l *8Ep *8Il  	if (title_highlighted ||  	    old_net != num_net ||s *8E1  	    old_batch != num_batch ||	+  	    old_interactive != num_interactive ||o  	    old_oswap != num_oswap ||w9  	    BannerLastActiveCpuCount != BannerActiveCpuCount ||5  	    old_total != num_total)i  	    {e *8Ih *10I  	    char sep[5]; *10E   #  	    if (old_total != num_total || 4  		BannerLastActiveCpuCount != BannerActiveCpuCount)  		title_highlighted = 1;c
  	    else  		title_highlighted = 0;  *10D  		  *10E *10I   )  	    memset (buffer, 0, sizeof(buffer));u#  	    memset (sep, 0, sizeof(sep));;  s  	    if (num_net > 0)  		{#  		sprintf (buffer, "%s%sNet = %d",   		buffer, sep, num_net);				=  		strcpy(sep, ", ");l  		}  e  	    if (num_batch > 0)  		{#  		sprintf (buffer, "%s%sBat = %d",c  		buffer, sep, num_batch);				s  		strcpy(sep, ", ");   		}  p  	    if (num_interactive > 0)  		{#  		sprintf (buffer, "%s%sInt = %d", %  		buffer, sep, num_interactive);				e  		strcpy(sep, ", ");d  		}  s  	    if (num_oswap > 0)  		{%  		sprintf (buffer, "%s%sOSwap = %d",i  		buffer, sep, num_oswap);				,  		strcpy(sep, ", ");I  		}  m *10E *8E #  	    if (BannerActiveCpuCount > 1)4 *10DW  		sprintf (buffer, "Net = %d, Bat = %d, Int = %d, OSwap = %d, Cpu's = %d, Total = %d", 3  		num_net, num_batch, num_interactive, num_oswap, {$  		BannerActiveCpuCount, num_total);
  	    elseK  		sprintf (buffer, "Net = %d, Bat = %d, Int = %d, OSwap = %d, Total = %d",U>  		num_net, num_batch, num_interactive, num_oswap, num_total); *10E *10I  		{#  		sprintf (buffer, "%s%sCpu = %d",c*  		buffer, sep, BannerActiveCpuCount);				  		strcpy(sep, ", ");i  		}   (  	    sprintf (buffer, "%s%sTotal = %d","  	    buffer, sep, num_total);				  d *10E    *8Ii  	    if (title_highlighted)G  		XSetForeground (XtDisplay(Bnr.process_widget), BannerGC, Bnr.hwmrk);G  P *8EAS  	    BannerWriteText (XtDisplay(Bnr.process_widget), XtWindow(Bnr.process_widget),e$  		0, 2*Bnr.font_height, buffer, 2,   		Bnr.process_width); *8I*   O  	    XSetForeground (XtDisplay(Bnr.process_widget), BannerGC, Bnr.foreground);u  o *8E   	    old_net = num_net;  	    old_batch = num_batch;(  	    old_interactive = num_interactive;  	    old_oswap = num_oswap; *12I   	    if (old_total > num_total):  		BannerSound (&Son.LessProcesses, Son.Volume, Son.Time);   	    if (old_total < num_total)9  		BannerSound (&Son.NewProcesses, Son.Volume, Son.Time);n *12E  	    old_total = num_total;  	    }   n  /**;   * Now check out if the process States should be displayeda   */'      if (Bnr.Param_Bits.process_states),  	{e  	char buffer[4];l     	y = 3*Bnr.font_height + 2;<  	x = Bnr.process_width - total_states_width + states_col_1;  !  ) *5Da  	if (lef != old_lef)d *5Ee *5I (  	if (lef != old_lef || lef != old_lef1) *5E   	    {o *5Id  	    if (lef != old_lef)eG  		XSetForeground (XtDisplay(Bnr.process_widget), BannerGC, Bnr.hwmrk);   r *5E_"  	    sprintf (buffer, "%d", lef); *5IP  	    old_lef1 = old_lef;  *5E   	    old_lef = lef;S  	    BannerWriteText (XtDisplay(Bnr.process_widget), XtWindow(Bnr.process_widget),   		x, y, buffer, 3,   		states_num_width);a *5IuO  	    XSetForeground (XtDisplay(Bnr.process_widget), BannerGC, Bnr.foreground);B *5En  	    }t *5D   	if (old_lefo != lefo)d *5E  *5Is,  	if (old_lefo != lefo || old_lefo1 != lefo) *5E   	    {  *5Io  	    if (lefo != old_lefo) G  		XSetForeground (XtDisplay(Bnr.process_widget), BannerGC, Bnr.hwmrk);a *5E #  	    sprintf (buffer, "%d", lefo);g *5Ir  	    old_lefo1 = old_lefo;i *5Eo  	    old_lefo = lefo;S  	    BannerWriteText (XtDisplay(Bnr.process_widget), XtWindow(Bnr.process_widget),c5  	    x + states_col_2 - states_col_1, y, buffer, 3, =  	    states_num_width); *5IsO  	    XSetForeground (XtDisplay(Bnr.process_widget), BannerGC, Bnr.foreground);  *5El  	    }f  t  	y = y + Bnr.font_height;  r *5Dl  	if (old_hib != hib)t *5Eo *5Is(  	if (old_hib != hib || old_hib1 != hib) *5E   	    {  *5I   	    if (hib != old_hib)yG  		XSetForeground (XtDisplay(Bnr.process_widget), BannerGC, Bnr.hwmrk);s *5Eh"  	    sprintf (buffer, "%d", hib); *5Ii  	    old_hib = old_hib1;  *5E   	    old_hib = hib;S  	    BannerWriteText (XtDisplay(Bnr.process_widget), XtWindow(Bnr.process_widget),   		x, y, buffer, 3,   		states_num_width);s *5I O  	    XSetForeground (XtDisplay(Bnr.process_widget), BannerGC, Bnr.foreground);t *5Ei  	    }  *5D   	if (old_hibo != hibo)  *5E  *5I ,  	if (old_hibo != hibo || old_hibo1 != hibo) *5E=  	    {u *5I;  	    if (hibo != old_hibo)eG  		XSetForeground (XtDisplay(Bnr.process_widget), BannerGC, Bnr.hwmrk);* *5E #  	    sprintf (buffer, "%d", hibo);* *5In  	    old_hibo1 = old_hibo;* *5E   	    old_hibo = hibo;S  	    BannerWriteText (XtDisplay(Bnr.process_widget), XtWindow(Bnr.process_widget),h5  	    x + states_col_2 - states_col_1, y, buffer, 3, A  	    states_num_width); *5I O  	    XSetForeground (XtDisplay(Bnr.process_widget), BannerGC, Bnr.foreground);: *5E   	    }   n  	y = y + Bnr.font_height;  : *5D   	if (old_com != com)  *5ES *5IF(  	if (old_com != com || old_com1 != com) *5E/  	    {  *5Ie  	    if (com != old_com)tG  		XSetForeground (XtDisplay(Bnr.process_widget), BannerGC, Bnr.hwmrk);  *5Ei"  	    sprintf (buffer, "%d", com); *5I(  	    old_com1 = old_com;i *5E   	    old_com = com;S  	    BannerWriteText (XtDisplay(Bnr.process_widget), XtWindow(Bnr.process_widget),   		x, y, buffer, 3,   		states_num_width);2 *5I	O  	    XSetForeground (XtDisplay(Bnr.process_widget), BannerGC, Bnr.foreground);  *5Ei  	    }     *5Df  	if (old_como != como)y *5E) *5I*,  	if (old_como != como || old_como1 != como) *5Ep  	    {a *5I   	    if (como != old_como).G  		XSetForeground (XtDisplay(Bnr.process_widget), BannerGC, Bnr.hwmrk);o *5Ea#  	    sprintf (buffer, "%d", como);d *5I   	    old_como1 = old_como;c *5E=  	    old_como = como;S  	    BannerWriteText (XtDisplay(Bnr.process_widget), XtWindow(Bnr.process_widget), 5  	    x + states_col_2 - states_col_1, y, buffer, 3, d  	    states_num_width); *5I O  	    XSetForeground (XtDisplay(Bnr.process_widget), BannerGC, Bnr.foreground);w *5E)  	    }w  r  	y = y + Bnr.font_height;  t *5Dn  	if (old_pfw != pfw)  *5E  *5Is(  	if (old_pfw != pfw || old_pfw1 != pfw) *5Ei  	    {  *5In  	    if (pfw != old_pfw)pG  		XSetForeground (XtDisplay(Bnr.process_widget), BannerGC, Bnr.hwmrk);	 *5Et"  	    sprintf (buffer, "%d", pfw); *5Iy  	    old_pfw1 = old_pfw;d *5Er  	    old_pfw = pfw;S  	    BannerWriteText (XtDisplay(Bnr.process_widget), XtWindow(Bnr.process_widget),   		x, y, buffer, 3,   		states_num_width);D *5IyO  	    XSetForeground (XtDisplay(Bnr.process_widget), BannerGC, Bnr.foreground);  *5Et  	    }; *5Da  	if (old_cef != cef)y *5Ep *5Is(  	if (old_cef != cef || old_cef1 != cef) *5E   	    {s *5I_  	    if (cef != old_cef)tG  		XSetForeground (XtDisplay(Bnr.process_widget), BannerGC, Bnr.hwmrk);t *5E "  	    sprintf (buffer, "%d", cef); *5DB  	    old_others = cef;  *5Ey *5IW  	    old_cef1 = old_cef;;  	    old_cef = cef; *5ElS  	    BannerWriteText (XtDisplay(Bnr.process_widget), XtWindow(Bnr.process_widget),C5  	    x + states_col_2 - states_col_1, y, buffer, 3,    	    states_num_width); *5IrO  	    XSetForeground (XtDisplay(Bnr.process_widget), BannerGC, Bnr.foreground);, *5EC  	    }   	  	y = y + Bnr.font_height;  t *5D   	if (old_colpg != colpg)e *5Et *5Iw0  	if (old_colpg != colpg || old_colpg1 != colpg) *5EG  	    {	 *5It  	    if (colpg != old_colpg)	G  		XSetForeground (XtDisplay(Bnr.process_widget), BannerGC, Bnr.hwmrk);5 *5E	$  	    sprintf (buffer, "%d", colpg); *3De  	    old_pfw = colpg; *3Ee *3I  *5I   	    old_colpg1 = old_colpg;s *5E1  	    old_colpg = colpg; *3EtS  	    BannerWriteText (XtDisplay(Bnr.process_widget), XtWindow(Bnr.process_widget),s  		x, y, buffer, 3,   		states_num_width);2 *5IaO  	    XSetForeground (XtDisplay(Bnr.process_widget), BannerGC, Bnr.foreground);h *5Ee  	    }  *5D   	if (old_fpg != fpg)1 *5E1 *5I (  	if (old_fpg != fpg || old_fpg1 != fpg) *5Ei  	    {* *5I   	    if (fpg != old_fpg)TG  		XSetForeground (XtDisplay(Bnr.process_widget), BannerGC, Bnr.hwmrk);n *5En"  	    sprintf (buffer, "%d", fpg); *5DC  	    old_others = fpg;  *5ET *5I   	    old_fpg1 = old_fpg;I  	    old_fpg = fpg; *5E S  	    BannerWriteText (XtDisplay(Bnr.process_widget), XtWindow(Bnr.process_widget),E5  	    x + states_col_2 - states_col_1, y, buffer, 3,    	    states_num_width); *5I O  	    XSetForeground (XtDisplay(Bnr.process_widget), BannerGC, Bnr.foreground);t *5E   	    }u  r  	y = y + Bnr.font_height;     	if (old_mwait != mwait)2  	    {  *5Ir *12D    *12E  	    if (mwait > 0) *12I  		{ *12EG  		XSetForeground (XtDisplay(Bnr.process_widget), BannerGC, Bnr.hwmrk);t *12I2  		BannerSound (&Son.Mwait, Son.Volume, Son.Time);  		} *12E  uS  	    BannerWriteText (XtDisplay(Bnr.process_widget), XtWindow(Bnr.process_widget),{!  		mwait_x, mwait_y, "MWAIT", 1, u  		states_col_1);i  t *5E  *7I   	    if (mwait > 0)G  		XSetForeground (XtDisplay(Bnr.process_widget), BannerGC, Bnr.hwmrk);s  m *7EL$  	    sprintf (buffer, "%d", mwait);  	    old_mwait = mwait;S  	    BannerWriteText (XtDisplay(Bnr.process_widget), XtWindow(Bnr.process_widget),c  		x, y, buffer, 3,   		states_num_width);i *5IsO  	    XSetForeground (XtDisplay(Bnr.process_widget), BannerGC, Bnr.foreground);s *5Ee  	    }d *5Dr  	if (old_others != others)B *5En *5Ig4  	if (old_others != others || old_others1 != others) *5E1  	    {1 *5I1  	    if (others != old_others) G  		XSetForeground (XtDisplay(Bnr.process_widget), BannerGC, Bnr.hwmrk);t *5Ew%  	    sprintf (buffer, "%d", others);h *5I,  	    old_others1 = old_others;d *5E   	    old_others = others;S  	    BannerWriteText (XtDisplay(Bnr.process_widget), XtWindow(Bnr.process_widget), 5  	    x + states_col_2 - states_col_1, y, buffer, 3, r  	    states_num_width); *5IEO  	    XSetForeground (XtDisplay(Bnr.process_widget), BannerGC, Bnr.foreground);t *5E   	    }l  	}f  /*l<   * Now go through the top process count, and display it all   */  =      y = 2*Bnr.font_height + 2;t      x = Bnr.font_width/2;&      for (i=0; i<process_display; i++)  	{r   	process = (*top_processes)[i];  	if (process != NULL &&  	    process->diff_cputim > 0)h  	    {	  	    int width, clearwidth;  	    int hist_x;=  m8  	    if ((*top_processes)[i] != (*oldtop_processes)[i]  *5D)"  	       || process->name_changed) *5E  *5It:  	       || process->name_changed || process->highlighted) *5Eu  		{  		char buffer[50];  *6I   		int forg;  i  		forg = Bnr.foreground;( *6Ee  		) *5I{'  		if (i == 0 && !process->highlighted)	  		    { *6DuK  		    XSetForeground (XtDisplay(Bnr.process_widget), BannerGC, Bnr.hwmrk);{ *6Es *6If  		    forg = Bnr.hwmrk; *6Eb   		    process->highlighted = 1;  		    }  		else    		    process->highlighted = 0;    *5E	
  		x1 = x;  		buffer[0] = 0;	#  		if (Bnr.Param_Bits.process_pid)	t  		    {.  		    sprintf (buffer, "%08X", process->pid); *6IaF  		    XSetForeground (XtDisplay(Bnr.process_widget), BannerGC, forg); *6EaT  		    BannerWriteText (XtDisplay(Bnr.process_widget), XtWindow(Bnr.process_widget),(  			x1, y + Bnr.font_height, buffer, 1,   			pid_width);=,  		    x1 = x1 + pid_width + Bnr.font_width;  		    }$  		if (Bnr.Param_Bits.process_user)	  		    { *6ItF  		    XSetForeground (XtDisplay(Bnr.process_widget), BannerGC, forg); *6E,T  		    BannerWriteText (XtDisplay(Bnr.process_widget), XtWindow(Bnr.process_widget),/  			x1, y + Bnr.font_height, process->user, 1, f  			user_width);  		    x1 = x1 + user_width;  		    }$  		if (Bnr.Param_Bits.process_name)	  		    { *6ItF  		    XSetForeground (XtDisplay(Bnr.process_widget), BannerGC, forg); *6E T  		    BannerWriteText (XtDisplay(Bnr.process_widget), XtWindow(Bnr.process_widget),/  			x1, y + Bnr.font_height, process->name, 1, r  			name_width);  		    x1 = x1 + name_width;  		    }
  		hist = x1;	  		process->name_changed=0;, *5I L  		XSetForeground (XtDisplay(Bnr.process_widget), BannerGC, Bnr.foreground); *5Et  		}	e3  	    (*oldtop_processes)[i] = (*top_processes)[i];_  ;  	    x1 = hist;  u1  	    sprintf (buffer, "%d%%", process->percent);  *5D   _ *5E  *5I_        *5E   	    if (process->percent > 0) P  		BannerWriteText (XtDisplay(Bnr.process_widget), XtWindow(Bnr.process_widget),+  		    x1, y + Bnr.font_height, buffer, 3, ,  		    percent);  )+  	    x1 = x1 + percent + Bnr.font_width/2;    C  	    display_size = (Bnr.process_width - total_states_width) - x1;a   3  	    width = process->display_size * display_size;	  	    if (width > display_size).  		width = display_size;(  	    clearwidth = display_size - width;  _  	    if (width > 0) *5D(P  		XFillRectangle (XtDisplay(Bnr.process_widget), XtWindow (Bnr.process_widget),  		    BannerGC, x1, e  		    y + 3, 
  		    width,n  		    Bnr.font_height - 3);  	     *5E  *5Iw  		{  		int width1, hlwidth;   f2  		hlwidth = (display_size*Bnr.sys_highlight)/100;     		if (width > hlwidth)	  		    {T  		    XFillRectangle (XtDisplay(Bnr.process_widget), XtWindow (Bnr.process_widget),  			BannerGC, x1,   			y + 3,    			hlwidth,  			Bnr.font_height - 3);.K  		    XSetForeground (XtDisplay(Bnr.process_widget), BannerGC, Bnr.hwmrk);_T  		    XFillRectangle (XtDisplay(Bnr.process_widget), XtWindow (Bnr.process_widget),  			BannerGC, x1 + hlwidth,   			y + 3, X  			width - hlwidth,  			Bnr.font_height - 3);n  		    }  		else T  		    XFillRectangle (XtDisplay(Bnr.process_widget), XtWindow (Bnr.process_widget),  			BannerGC, x1,   			y + 3, n
  			width,  			Bnr.font_height - 3);e	  		}	    w *5Ep  e>  	    XSetBackground (XtDisplay(Bnr.process_widget), BannerGC,  		Bnr.foreground);m>  	    XSetForeground (XtDisplay(Bnr.process_widget), BannerGC,  		Bnr.background);r  o  )  	    if (clearwidth > 0) P  		XFillRectangle (XtDisplay(Bnr.process_widget), XtWindow (Bnr.process_widget),  		    BannerGC, x1 + width, 5  			y,    			clearwidth,f  			Bnr.font_height);X  F>  	    XSetForeground (XtDisplay(Bnr.process_widget), BannerGC,  		Bnr.foreground); >  	    XSetBackground (XtDisplay(Bnr.process_widget), BannerGC,  		Bnr.background);	     	    y = y + Bnr.font_height;  	    }d  	else  	    {r!  	    (*oldtop_processes)[i] = 0;,>  	    XSetBackground (XtDisplay(Bnr.process_widget), BannerGC,  		Bnr.foreground);t>  	    XSetForeground (XtDisplay(Bnr.process_widget), BannerGC,  		Bnr.background);    S  	    XFillRectangle (XtDisplay(Bnr.process_widget), XtWindow (Bnr.process_widget),!  		BannerGC, 0, 3  		    y + Bnr.font_height - Bnr.font_ptr->ascent, C.  		    Bnr.process_width - total_states_width,  		    Bnr.font_height);  i>  	    XSetForeground (XtDisplay(Bnr.process_widget), BannerGC,  		Bnr.foreground);p>  	    XSetBackground (XtDisplay(Bnr.process_widget), BannerGC,  		Bnr.background);,  	    y = y + Bnr.font_height;  	    };  	}   }    /*o  **++d  **  FUNCTIONAL DESCRIPTION:  **n  **	BannerProcess ()  **5M  **      This is the main work routine for the processes window, it is called J  **	once a second, and dispays all the info about the current top process.  **   **  FORMAL PARAMETERS:X  **r
  **      nonel  **r  **  IMPLICIT INPUTS:r  **n
  **      nonei  **   **  IMPLICIT OUTPUTS:  **;
  **      nonel  **1  **  COMPLETION CODES:  **_
  **      none   **n  **  SIDE EFFECTS:  **r
  **      none)  **i  **--r  **/  void	  BannerProcess()  {  int i, y, current_lowest;  int top_cnt = 0;o  /*u&   * first check we are all initialised   */  f      if (!process_init)   	BannerProcessRefresh();o         process_update --;(      if (process_update > 0)	  	return;5+      process_update = process_update_count;o     /*e"   * Now call the colection routine   */  a      total_cpu = 0;       GetNewInfo ();b  e  "  /*c   * Clear out the old data   */<      memset (top_processes, 0, sizeof(int)*process_display);  /*s*   * Now place it in its order of cpu usage   */      current_lowest = 0;$      for (i=0;  i<num_process;  i++)  	{   	Bnr$Process *topprocess;  	process = (*processes)[i];!  	if (process->pid != null_pid &&f  	    process->seen == 1 && ,  	    process->diff_cputim > current_lowest)'  	    for (y=0; y<process_display; y++)_  		{$  		topprocess = (*top_processes)[y];  		if (topprocess == NULL ||  		    process->diff_cputim >   		    topprocess->diff_cputim)C  		    {)  		    memcpy (&((*top_processes)[y+1]), w  			&((*top_processes)[y]),d-  			sizeof(int) * (process_display - 1 - y));r/  		    (*top_processes)[y] = (*processes)[i];		w(  		    topprocess = (*top_processes)[y];+  		    if (topprocess->diff_cputim > 0.0 &&o.  			(total_cpu/topprocess->diff_cputim) > 0.0)  			{f7  			topprocess->percent = (100.0*BannerActiveCpuCount)/y,  			    (total_cpu/topprocess->diff_cputim);"  			if (topprocess->percent > 100)   			    topprocess->percent=100;  			}   		    elser  			topprocess->percent=0;"  		    topprocess->display_size =   			topprocess->diff_cputim / ,  			    (total_cpu/BannerActiveCpuCount);			  /*dF   * Remeber the lowest CPU user we have in our display, to reduce the 
   * sort time)   */8  		    topprocess = (*top_processes)[process_display-1];  		    if (topprocess != NULL)  			{n-  			current_lowest = topprocess->diff_cputim;a  			}r
  		    break;B  		    }  		}		  n  	    }C  /*     * Now call the display routine   */           PaintDisplay ();         }    /*	  **++_  **  FUNCTIONAL DESCRIPTION:  **p  **  GetNewInfo ()  ** 0  **      This routine gets the new process info.  **s  **  FORMAL PARAMETERS:   **r
  **      none5  **	  **  IMPLICIT INPUTS:,  **,
  **      none   **   **  IMPLICIT OUTPUTS:  ** 
  **      none_  **1  **  COMPLETION CODES:  **l
  **      none;  **t  **  SIDE EFFECTS:  **X
  **      noneo  **w  **--   **/  B  static     int size;	!  static     int biggest_size = 0;i  )
  static void	 
  GetNewInfo()(  {      int i;c      int index = -1;
      int pos;)      int free_pos;      int number = 0;      int status;  /*fN   * Clear the seen count, so we can find processes that dont exist any longer.   */  	"      for (i=0; i<num_process; i++)  	{d  	process = (*processes)[i];  	if (process->seen == 0),  	    process->pid = -1;  /*t8   * tag all processes as non resident for the time being   */  	process->seen = 0;  	process->resident = 0;  	};      sQ      num_interactive = num_batch = num_sub = num_net = num_total = num_oswap = 0;   fH      lef = lefo = hib = hibo = com = como = pfw = others = mwait = cef =      colpg = fpg = 0;n  G      while (1)  	{      /* J   * Get the processes mode, if it is COMO, HIBO, LEFO, or Suspended, then :   * skip it. If this is the end of the list, then get out.   */;  	status = SYS$GETJPIW (NULL, &index, NULL, &modeitemlist, n  	    NULL, NULL, NULL);  u  	if (status == SS$_NOMOREPROC)i  	    break;     /*	=   * Null process will be the first we see, so remeber its pidr   */  	if (null_pid == 0)  	    null_pid = pid;,  	  s  /*_-   * remember the type of process this one was    */  	if (pid != null_pid)  	{o  	    switch (mode)C  	    {r  s-  	    case JPI$K_NETWORK : num_net ++; break;;  	,  	    case JPI$K_BATCH : num_batch++; break;  D8  	    case JPI$K_INTERACTIVE : num_interactive++; break;  	    },  	    num_total++;  /*u+   * Is it a resident procerss, or Oswapped?p   */  	    if (!(sts & 1))e  		num_oswap++;n  s  /*e   * Add up the states(   */  	    switch (state)  	    {	$  	    case SCH$C_COM : com++; break;&  	    case SCH$C_COMO : como++; break;$  	    case SCH$C_LEF : lef++; break;&  	    case SCH$C_LEFO : lefo++; break;$  	    case SCH$C_HIB : hib++; break;&  	    case SCH$C_HIBO : hibo++; break;$  	    case SCH$C_PFW : pfw++; break;(  	    case SCH$C_MWAIT : mwait++; break;$  	    case SCH$C_CEF : cef++; break;(  	    case SCH$C_COLPG : colpg++; break;$  	    case SCH$C_FPG : fpg++; break;  	    default: others++;break;  	    }E  	}   	  o  	  /*("   * find this process in our array   */  	number ++;  	pos = -1;   	free_pos = -1;  	for (i=0; i<num_process; i++)s  	    {n   	    process = (*processes)[i];  /*B   * Is this our process?   */  	    if (pid == process->pid)  		{  		pos = i;   		process->seen = 1; 	  		break;s  		}	;  /*f&   * Could we use this as a free place?   */  	    if (process->pid == -1)i  		free_pos = i;  	    }   	if (pos == -1)  	    {o  	    int newsize;  /*oJ  * this is a new process so check that its name isn't bigger than we have   * seen before.n  */hE  	    newsize = XTextWidth (Bnr.font_ptr, name, name_size(name) - 1);   	    if (newsize > name_width)o  		name_width = newsize;   E  	    newsize = XTextWidth (Bnr.font_ptr, user, name_size(user) - 1);r  	    if (newsize > user_width)d  		user_width = newsize;  /*6(  * Now find a slot to store this process  */   	    if (processes == NULL)  		{%  		processes = XtMalloc(sizeof(int)); =  		process = (*processes)[0] = XtMalloc(sizeof(Bnr$Process));m   		process->name = XtMalloc(30);   		process->user = XtMalloc(30);  		pos = num_process;   		num_process++;D  		}
  	    else  		{  		int new;   /* :  * look for a place that we haven't seen for quit a while.  */W  o  		pos = free_pos;  /*	6  * now use it if we found one, else, create a new slot  */   		if (pos == -1)d  		    {5  		    new = XtMalloc((num_process + 1)*sizeof(int));r8  		    memcpy (new, processes, num_process*sizeof(int));  		    XtFree(processes);o  		    processes=new;eJ  		    process = (*processes)[num_process]= XtMalloc(sizeof(Bnr$Process));$  		    process->name = XtMalloc(30);$  		    process->user = XtMalloc(30);  		    pos = num_process;}  		    num_process++;.  		    }  		else #  		    process = (*processes)[pos];D  		}  /* F  * dummy up the counts on this record, so all counts will seem to be 0  */.  	    process->old_bufcnt = 0;  	    process->old_diocnt = 0;  	    process->old_cputim = 0;   	    process->old_pageflts = 0;   	    process->name_changed = 0;2  	    memcpy(process->name,name,name_size(name) );2  	    memcpy(process->user,user,name_size(user) );  	    }r  d  	process = (*processes)[pos];4  	if (sts & 1)	    /* Is this a Resident process? */  	    process->resident = 1;  	process->seen = 1;  	process->pid = pid;5  	process->mode = mode;	  	process->diff_cputim = 0;   /*BM   * Check that the process name hasn't changed since the last time we looked.	   */ *8D+'  	if (strcmp(process->user, user) != 0)r *8E; *8I ;  	if (strncmp(process->user, user, name_size(user)-1) != 0)a *8Ee  	    {r  	    int newsize;  	    process->name_changed=1;2  	    memcpy(process->user,user,name_size(user) );E  	    newsize = XTextWidth (Bnr.font_ptr, user, name_size(user) - 1);h  	    if (newsize > user_width)   		user_width = newsize;  	    }t *8I   D *8Ey'  	if (strcmp(process->name, name) != 0)s  	    {,  	    int newsize;  	    process->name_changed=1;2  	    memcpy(process->name,name,name_size(name) );E  	    newsize = XTextWidth (Bnr.font_ptr, name, name_size(name) - 1);s  	    if (newsize > name_width)d  		name_width = newsize;  	    }i  	}t  l"      for (i=0; i<num_process; i++)  	{w  	process = (*processes)[i];5  	if ((process->seen == 1 && process->resident == 1) h"  	    || process->pid == null_pid)  	    {y  /*p2   * Now store all the information for this process   */#  	    if (process->pid != null_pid)t?  		status = SYS$GETJPIW (NULL, &process->pid, NULL, &itemlist,    		    NULL, NULL, NULL);,  	    process->bufcnt = bufcnt; :  	    process->diff_bufcnt = bufcnt - process->old_bufcnt;#  	    process->old_bufcnt = bufcnt;t  	    process->diocnt = diocnt;,:  	    process->diff_diocnt = diocnt - process->old_diocnt;#  	    process->old_diocnt = diocnt;(  /*rK   * The null process does not show any CPU time, even though the CPU(s) mayaK   * have spent some time in NULL mode. We will have to read the CPU data toa9   * get the time in NULL mode, and populate the Null modee *4It   *wJ   * We total NULL times, and Interupt time together, because Interupt timeM   * is a system overhead as well, and should not be blaimed on any particular_   * process. *4E    */#  	    if (process->pid != null_pid)(  		{  		process->cputim = cputim;  		if (process->old_cputim > 0)	;  		    process->diff_cputim = cputim - process->old_cputim;    		process->old_cputim = cputim;  		}
  	    else  		{  		float null_mode = 0;,  		int i,j;	  r	  		j = 0;)3  		BannerLastActiveCpuCount = BannerActiveCpuCount;t  		BannerActiveCpuCount = 0;,  		for (i=1;  i<=SMP$GL_ACTIVE_CPUS;  i=i*2)  		    {(  		    if ((i & SMP$GL_ACTIVE_CPUS) > 0)  			{G *4D >  			null_mode = null_mode + SMP$GL_CPU_DATA[j]->cpu$l_nullcpu; *4Eo *4Iw  			null_mode = null_mode + '  				SMP$GL_CPU_DATA[j]->cpu$l_nullcpu;e *8Dd  			null_mode = null_mode +  *8En *8I,  	.  			if (SMP$GL_CPU_DATA[j]->cpu$l_interrupt >=*  			    SMP$GL_CPU_DATA[j]->cpu$l_nullcpu)   			    null_mode = null_mode + *  				SMP$GL_CPU_DATA[j]->cpu$l_interrupt -'  				SMP$GL_CPU_DATA[j]->cpu$l_nullcpu;   			else   			    null_mode = null_mode +  *8Em)  				SMP$GL_CPU_DATA[j]->cpu$l_interrupt;i *4Ec *8I   * *8Ee  			BannerActiveCpuCount++;e  			}b  		    j++;n  		    }  .  		process->cputim = null_mode;    		if (process->old_cputim != 0)>  		    process->diff_cputim = null_mode - process->old_cputim;  		else;   		    process->diff_cputim = 0;#  		process->old_cputim = null_mode;*  		}#  	    process->pageflts = pageflts;)@  	    process->diff_pageflts = pageflts - process->old_pageflts;'  	    process->old_pageflts = pageflts;   /*s-   * Now work out which are the top cpu users.i   */%  	    if (process->diff_cputim > 0 &&o  		process->seen == 1)0  		total_cpu = total_cpu + process->diff_cputim;  	    }        t  	}r  }