  #module BannerQp "V1.0"     /*   **++   **  FACILITY:  ** &  **      The DECwindows Banner program  **   **  ABSTRACT:  ** K  **      This module contains all the code, to run the Batch Queue monitor.   ** 
  **  AUTHORS:   **   **      JIM SAUNDERS   **   ** %  **  CREATION DATE:     20th May 1990   **   **  MODIFICATION HISTORY:  **--   **/        /*   **   **  INCLUDE FILES  **   **/       *3I   #include "quidef.h";  *3E   #include "stdio.h"   #include "MrmAppl.h"         #include "Banner"    *3I  *4D   static void GetQueueInfo ();  *4E  *4I #  static void BannerGetQueueInfo ();  *4E  *3E      /*   **   **  MACRO DEFINITIONS  **   **/     #define SS$_NORMAL 1       typedef struct _vms_item_list {  	short	 buffer_length;   	short	 item_code;   	void	*buffer;   	int	*returned_buffer_length;  	} VMS_ItemList;      /* #   * now our runtime data structures    */     extern	 Bnr$_Blk    Bnr;   extern	 Clk$_Blk    Clk;   extern   Qp$_Blk    Qp;  extern	 GC	     BannerGC;  extern	 XGCValues   GcValues;   !  extern void BannerSignalError();    .  static int Qp_update_count, Qp_update_number;  static int Qp_init = 0; *3I     *4D   static char searchname[40];   static char searchusername[40]; *4E  *4I '  static char BannerQueueSearchName[40]; $  static int  BannerQueueSearchFlags;    *4E   static char queuename[40];  *4D   static int  queuenamesize;  *4E   static char nodename[40]; *4D   static int  nodenamesize; *4E  *4I   static char jobname[40];   static char username[40]; *4E  *7I   static int jobnumber; *7E   static int  status; *4D   static int  searchflags;  *4E  *4I 4  static int  jobsearchflags = QUI$M_SEARCH_ALL_JOBS; *4E   static int  queueflags; *4D    %  static VMS_ItemList queueinfo[8] = { ,      4,  QUI$_SEARCH_FLAGS, &searchflags, 0,*      31, QUI$_SEARCH_NAME, &searchname, 0,2      31, QUI$_SEARCH_USERNAME, &searchusername, 0, *4E  *4I (  static int  pendingcount, holdingcount;'  static int  intcount, intblocks, size;     *7D #  static VMS_ItemList jobinfo[8] = {  *7E  *7I #  static VMS_ItemList jobinfo[9] = {  *7E /      4,  QUI$_SEARCH_FLAGS, &jobsearchflags, 0, &      40, QUI$_USERNAME, &username, 0,  *7I +      4,  QUI$_ENTRY_NUMBER, &jobnumber, 0,   *7E %      40, QUI$_JOB_NAME, &jobname, 0,  &      4,  QUI$_JOB_STATUS, &status, 0,        4,	QUI$_JOB_SIZE, &size, 0,-      4,  QUI$_INTERVENING_JOBS, &intcount, 0, 0      4,  QUI$_INTERVENING_BLOCKS, &intblocks, 0,      0, 0, 0, 0};            %  static VMS_ItemList queueinfo[9] = { 5      20, QUI$_SEARCH_NAME, &BannerQueueSearchName, 0, 2      4,  QUI$_PENDING_JOB_COUNT, &pendingcount, 0,2      4,  QUI$_HOLDING_JOB_COUNT, &holdingcount, 0,7      4,  QUI$_SEARCH_FLAGS, &BannerQueueSearchFlags, 0,  *4E *      4,  QUI$_QUEUE_FLAGS, &queueflags, 0, *4D 5      31, QUI$_QUEUE_NAME, &queuename, &queuenamesize, 5      31, QUI$_SCSNODE_NAME, &nodename, &nodenamesize,  *4E  *4I (      31, QUI$_QUEUE_NAME, &queuename, 0,)      31, QUI$_SCSNODE_NAME, &nodename, 0,  *4E (      4,  QUI$_QUEUE_STATUS, &status, 0,       0, 0, 0, 0};                 *3E     /*   **++   **  FUNCTIONAL DESCRIPTION:  **   **	BannerQpSetup ()  ** M  **      This is the setup routine for the Banner monitor, it initialises all ;  **	the data structurtes for the monitor section of Banner.   **   **  FORMAL PARAMETERS:   ** 
  **      none   **   **  IMPLICIT INPUTS:   ** 
  **      none   **   **  IMPLICIT OUTPUTS:  ** 
  **      none   **   **  COMPLETION CODES:  ** 
  **      none   **   **  SIDE EFFECTS:  ** 
  **      none   **   **--   **/  void	  BannerQpSetup()  {            Qp_update_count = 1;       if (Bnr.qp_update == 0)$  	Qp_update_number = Bnr.cpu_update;	      else  *2D "  	Qp_update_number = Bnr.qpupdate; *2E  *2I #  	Qp_update_number = Bnr.qp_update;  *2E     *3I       Qp.Lines[0].LastLine = 1;    *7D "      Qp.Lines[0].MaxNameSize = 14; *7E  *7I "      Qp.Lines[0].MaxNameSize = 18; *7E !      Qp.Lines[0].MaxNamePoints =   *7D 1  	XTextWidth(Bnr.font_ptr, " XXXXXXXXXXXX ", 14);  *7E  *7I 5  	XTextWidth(Bnr.font_ptr, " XXXXXXXXXXXXXXXX ", 18);  *7E "      Qp.Lines[0].MaxTextSize = 20;"      Qp.Lines[0].MaxTextPoints =  :  	XTextWidth(Bnr.font_ptr, " XXXXXXXXXXXXXXXXXXXXXX", 20);    *6D   /*    * Setup search info    */ *6E  *4D -      strcpy (searchusername, Bnr.queue_user); &      strcpy (searchname, Bnr.qp_name);   "      if (Bnr.Param_Bits.all_users)=  	searchflags = QUI$M_SEARCH_PRINTER | QUI$M_SEARCH_ALL_JOBS; 
      else	%  	searchflags = QUI$M_SEARCH_PRINTER;          GetQueueInfo ();  *4E  *4I  *6D    A      BannerGetQueueInfo (&Qp, Bnr.qp_name, QUI$M_SEARCH_PRINTER);  *6E  *4E  *6D     *6E  *3E       Qp_init = 1;   }    /*   **++   **  FUNCTIONAL DESCRIPTION:  **   **	BannerQpRefresh ()  ** I  **      This routine rewrites all the static information display by the    **	Monitor section of Banner.  **   **  FORMAL PARAMETERS:   **   **   **  IMPLICIT INPUTS:   **   **   **  IMPLICIT OUTPUTS:  ** 
  **      none   **   **  COMPLETION CODES:  ** 
  **      none   **   **  SIDE EFFECTS:  ** 
  **      none   **   **--   **/  void	  BannerQpRefresh()  {         if (!Qp_init)  	BannerQpSetup ();     *3I  *6D N      BannerPaintTextLines (XtDisplay(Bnr.qp_widget), XtWindow(Bnr.qp_widget),   	Bnr.qp_width, Bnr.qp_height,    	&Qp.Lines[0], 1);     *6E  *6I       if (Qp.Valid)K  	BannerPaintTextLines (XtDisplay(Bnr.qp_widget), XtWindow(Bnr.qp_widget),  #  	    Bnr.qp_width, Bnr.qp_height,    	    &Qp.Lines[0], 1);  *6E  *3E   }    /*   **++   **  FUNCTIONAL DESCRIPTION:  **   **	BannerQp ()   ** 9  **      This routine runs the Monitor display of banner.   **   **  FORMAL PARAMETERS:   ** 
  **      none   **   **  IMPLICIT INPUTS:   ** 
  **      none   **   **  IMPLICIT OUTPUTS:  ** 
  **      none   **   **  COMPLETION CODES:  ** 
  **      none   **   **  SIDE EFFECTS:  ** 
  **      none   **   **--   **/  void	  BannerQp()   {         if (!Qp_init)  	BannerQpRefresh ();          Qp_update_count --;      if (Qp_update_count > 0) 	  	return;   	(      Qp_update_count = Qp_update_number; *3I     *4D       GetQueueInfo ();  *4E  *4I  *5D       BannerGetQueueInfo (&Qp); *5E  *5I  *6D A      BannerGetQueueInfo (&Qp, Bnr.qp_name, QUI$M_SEARCH_PRINTER);  *6E  *5E  *4E  *6D    N      BannerPaintTextLines (XtDisplay(Bnr.qp_widget), XtWindow(Bnr.qp_widget),   	Bnr.qp_width, Bnr.qp_height,    	&Qp.Lines[0], 0);     *6E  *6I       if (Qp.Valid)  	{ K  	BannerPaintTextLines (XtDisplay(Bnr.qp_widget), XtWindow(Bnr.qp_widget),  #  	    Bnr.qp_width, Bnr.qp_height,    	    &Qp.Lines[0], 0);   	Qp.Updated = 0;   	}  *6E   }    /*   **++   **  FUNCTIONAL DESCRIPTION:  **  *4D   **      GetQueueInfo () *4E  *4I   **      BannerGetQueueInfo () *4E   **   **  FORMAL PARAMETERS:   **    **      [@description_or_none@]  **   **  IMPLICIT INPUTS:   **    **      [@description_or_none@]  **   **  IMPLICIT OUTPUTS:  **    **      [@description_or_none@]  ** +  **  {@function_value_or_completion_codes@}   **    **      [@description_or_none@]  **   **  SIDE EFFECTS:  **    **      [@description_or_none@]  **   **--   **/ *4D   static void	GetQueueInfo()  *4E  *4I ?  void	BannerGetQueueInfo(Q$_Blk *Qblock, char *name, int flags)  *4E   { *4D   int i;  *4E  *4I "  char buf[50], buf1[50], buf2[50]; *6D   int i, oldhighlight;  *6E  *6I   int oldhighlight;	  int sts; 
  int iosb[2];   int queueidle = 0;  *6E     *6D &  strcpy (BannerQueueSearchName, name);   BannerQueueSearchFlags = flags; *6E  *6I *      strcpy (BannerQueueSearchName, name);$      BannerQueueSearchFlags = flags;)      Qblock->Updated = Qblock->Valid = 0;  *6E  *4E     *6D   /*    * search all the queues    */ *6E  *4D       return; *4E  *6D       i = 0;  *6E  *4D V      while (SYS$GETQUIW (0, QUI$_DISPLAY_QUEUE, 0, &queueinfo, 0, 0, 0) == SS$_NORMAL) *4E  *4I  *6D       while (1) *6E  *6I       if (Qblock->DoingQueue) *6E  *4E   	{  *4I  *6D 
  	int sts;
  	int savedi;   	int iosb[2]; *6E  *4E  *6D   	int queueidle = 0;  	int queuealive = 1;     *6E  *4D   	Qp.Lines[i].highlight = 0;  	Qp.Lines[i].LastLine = 1;   	Qp.Lines[i].text_changed = 1;    '  	strcpy (Qp.Lines[i].Text, queuename);  *4E  *4I  *6D H  	sts = SYS$GETQUIW (0, QUI$_DISPLAY_QUEUE, 0, &queueinfo, &iosb, 0, 0);   5  	if (!(sts & SS$_NORMAL) || !(iosb[0] & SS$_NORMAL))   	    break;   ,  	oldhighlight = Qblock->Lines[i].highlight;!  	Qblock->Lines[i].highlight = 0;    	Qblock->Lines[i].LastLine = 1;     	strcpy (buf, "");   	strcpy (buf1, "");  	strcpy (buf2, "");  	strcpy (buf, queuename); *6E  *4E  *6D   /*    * Add node name if we need to    */ *6E  *4D *  	if (!(queueflags & QUI$M_QUEUE_GENERIC))7  	    sprintf (Qp.Lines[i].Text1, " on %s ", nodename);  *4E  *4I  *6D ,  	if (!(queueflags & QUI$M_QUEUE_GENERIC) &&  	    strlen (nodename) != 0) %  		sprintf (buf1, "on %s", nodename);  *6E  *4E  *6D   /*    * check status   */   "  	if (status & QUI$M_QUEUE_CLOSED)  	    {  *6E  *4D E  	    sprintf (Qp.Lines[i].Text1, "%s (Closed) ", Qp.Lines[i].Text1);    	    Qp.Lines[i].highlight = 1; *4E  *4I  *6D 1  	    sprintf (buf1, "on %s (Closed)", nodename); %  	    Qblock->Lines[i].highlight = 1;  *6E  *4E  *6D   	    queuealive = 0; 
  	    }			   "  	if (status & QUI$M_QUEUE_PAUSED)  	    {  *6E  *4D E  	    sprintf (Qp.Lines[i].Text1, "%s (Paused) ", Qp.Lines[i].Text1);    	    Qp.Lines[i].highlight = 1; *4E  *4I  *6D 1  	    sprintf (buf1, "on %s (Paused)", nodename); %  	    Qblock->Lines[i].highlight = 1;  *6E  *4E  *6D   	    queuealive = 0; 
  	    }			   #  	if (status & QUI$M_QUEUE_PAUSING)   	    {  *6E  *4D F  	    sprintf (Qp.Lines[i].Text1, "%s (Pausing) ", Qp.Lines[i].Text1);   	    Qp.Lines[i].highlight = 1; *4E  *4I  *6D 2  	    sprintf (buf1, "on %s (Pausing)", nodename);%  	    Qblock->Lines[i].highlight = 1;  *6E  *4E  *6D   	    queuealive = 0;#
  	    }			   %  	if (status & QUI$M_QUEUE_RESETTING):  	    {* *6E  *4DDH  	    sprintf (Qp.Lines[i].Text1, "%s (resetting) ", Qp.Lines[i].Text1);   	    Qp.Lines[i].highlight = 1; *4Eh *4Ie *6Dt4  	    sprintf (buf1, "on %s (Resetting)", nodename);%  	    Qblock->Lines[i].highlight = 1;  *6EM *4E9 *6D*  	    queuealive = 0;I
  	    }			   $  	if (status & QUI$M_QUEUE_RESUMING)  	    {* *6E* *4D G  	    sprintf (Qp.Lines[i].Text1, "%s (Resuming) ", Qp.Lines[i].Text1);    	    Qp.Lines[i].highlight = 1; *4E" *4I  *6D 3  	    sprintf (buf1, "on %s (Resuming)", nodename);a%  	    Qblock->Lines[i].highlight = 1;  *6E  *4E/ *6D*  	    queuealive = 0;O
  	    }			   #  	if (status & QUI$M_QUEUE_STALLED)d  	    {  *6Ei *4DiF  	    sprintf (Qp.Lines[i].Text1, "%s (Stalled) ", Qp.Lines[i].Text1);   	    Qp.Lines[i].highlight = 1; *4E_ *4Ii *6D 2  	    sprintf (buf1, "on %s (Stalled)", nodename);%  	    Qblock->Lines[i].highlight = 1;r *6Ek *4E  *6Dk  	    queuealive = 0; 
  	    }			  G$  	if (status & QUI$M_QUEUE_STARTING)  	    {; *6E  *4DrG  	    sprintf (Qp.Lines[i].Text1, "%s (Starting) ", Qp.Lines[i].Text1);n   	    Qp.Lines[i].highlight = 1; *4E  *4I4 *6Ds3  	    sprintf (buf1, "on %s (Starting)", nodename);m%  	    Qblock->Lines[i].highlight = 1;Q *6Ee *4Ea *6D]  	    queuealive = 0;Q
  	    }			  ;#  	if (status & QUI$M_QUEUE_STOPPED)]  	    {  *6Ei *4D F  	    sprintf (Qp.Lines[i].Text1, "%s (Stopped) ", Qp.Lines[i].Text1);   	    Qp.Lines[i].highlight = 1; *4Ej *4Ie *6D 2  	    sprintf (buf1, "on %s (Stopped)", nodename);%  	    Qblock->Lines[i].highlight = 1;; *6E  *4Ea *6Dn  	    queuealive = 0; 
  	    }			  n$  	if (status & QUI$M_QUEUE_STOPPING)  	    {  *6Ea *4DnG  	    sprintf (Qp.Lines[i].Text1, "%s (Stopping) ", Qp.Lines[i].Text1);    	    Qp.Lines[i].highlight = 1; *4E  *4I, *6D_3  	    sprintf (buf1, "on %s (Stopping)", nodename);E%  	    Qblock->Lines[i].highlight = 1;  *6Ei *4E  *6Di  	    queuealive = 0; 
  	    }			  t'  	if (status & QUI$M_QUEUE_UNAVAILABLE)i  	    {m *6Ej *4DoJ  	    sprintf (Qp.Lines[i].Text1, "%s (UNAVAILABLE) ", Qp.Lines[i].Text1);   	    Qp.Lines[i].highlight = 1; *4E  *4I4 *6DI6  	    sprintf (buf1, "on %s (Unavaliable)", nodename);%  	    Qblock->Lines[i].highlight = 1;Q *6EO *4EE *6Db  	    queuealive = 0;I
  	    }			  s *6E, *4D    	if (status & QUI$M_QUEUE_IDLE)  	    queueidle = 1; *4EO *4Ii *6Dn3  	if (oldhighlight != Qblock->Lines[i].highlight || 3  	    strcmp (buf, Qblock->Lines[i].Text) != 0   ||i1  	    strcmp (buf1, Qblock->Lines[i].Text1) != 0)a%  		Qblock->Lines[i].text_changed = 1;_&  	strcpy (Qblock->Lines[i].Text, buf);(  	strcpy (Qblock->Lines[i].Text1, buf1);    *6E  *4E  *6D_  /*H   * Should we show this queue?   */ *6E  *4D4  	if (!queueidle), *4Eu *4Is *6D   	if (queuealive)_ *6E_ *6I   	if (Qblock->QueueAlive)  *6E  *4EQ  	    {D *4DE  	    Qp.Lines[i].LastLine = 1;  *4E  *4I  *6DQ  	    int savedi;e  	    int backup;,  I  	    backup = 1;d  	    savedi = i;   4$  	    Qblock->Lines[i].LastLine = 1; *6E  *4E  *6D   	    if (i != 0)  *6E  *4D !  		Qp.Lines[i].LastLine = 0;	    :  /* *   * Should we show any jobs on this queue?   */  t  /*u%   * Move to next line, for next queuei   */ *4E* *4I  *6Ds(  		Qblock->Lines[i-1].LastLine = 0;	        *6E  *4E  *6DA
  	    i++;  	    if (i > clu_max_lines) *6E  *6II  	    int sts;  	    int iosb[2];-  	    int intjobcount = 0, intblockcount = 0;n  	    int showjob;      /*E.       * Should we show any jobs on this queue?       */   H  	    sts = SYS$GETQUIW (0, QUI$_DISPLAY_JOB, 0, &jobinfo, &iosb, 0, 0);  _9  	    if (!(sts & SS$_NORMAL) || !(iosb[0] & SS$_NORMAL))t  		{  		Qblock->DoingQueue = 0;      /* +       * See if we found anything to display2       */ *8D_  b *8EB  		if (Qblock->BackupLine)  		    {/  		    Qblock->CurrentLine = Qblock->SavedLine;[7  		    Qblock->Lines[Qblock->CurrentLine].LastLine = 1;e$  		    if (Qblock->CurrentLine != 0);  			Qblock->Lines[Qblock->CurrentLine-1].LastLine = 0;	    X  		    } *6E 
  		return; *4Id *6Dr  /*_*   * Should we show any jobs on this queue?   */  	    while (1)e *6E; *6I   		}      /*x       * Is it one of ours?       */-  	    if (strncmp (username, Bnr.queue_user,   *8D "  			strlen(Bnr.queue_user)) != 0 ) *8E  *8Is#  			strlen(Bnr.queue_user)) != 0 &&) *9D   		strcmp (username, "*" != 0))e *9E  *9I   		strcmp (username, "*") != 0)	 *9Eh *8E   		{  		intjobcount++;Q  		intblockcount += size;   		}      /*hF       * Display this job, if it fits our user, and if its not on hold,%       * or holding jobs are requested 
       */		  	    showjob = 0;   -  	    if (strncmp (username, Bnr.queue_user, t *8D !  			strlen(Bnr.queue_user)) == 0)O *8EE *8IT#  			strlen(Bnr.queue_user)) == 0 ||*  		strcmp (username, "*") == 0)s *8Et  		showjob = 1;t     p)  	    if (status & QUI$M_JOB_EXECUTING ||."  		(Bnr.Param_Bits.jobs_on_hold &&  		Bnr.Param_Bits.all_users))   		showjob = 1;   P  	    if (showjob) *6E   		{ *6D   		int sts;M  		int iosb[2];**  		int intjobcount = 0, intblockcount = 0;  		int showjob;n   E  		sts = SYS$GETQUIW (0, QUI$_DISPLAY_JOB, 0, &jobinfo, &iosb, 0, 0);i  )6  		if (!(sts & SS$_NORMAL) || !(iosb[0] & SS$_NORMAL))
  		    break;s  y  /*q   * Is it one of ours?   */*  		if (strncmp (username, Bnr.queue_user, &  			    strlen(Bnr.queue_user)) != 0 )  		    {  		    intjobcount++;L  		    intblockcount += size;   		    }  /*_B   * Display this job, if it fits our user, and if its not on hold,!   * or holding jobs are requested*   */		  		showjob = 0;C      :*  		if (strncmp (username, Bnr.queue_user, %  			    strlen(Bnr.queue_user)) == 0)a  		    showjob = 1;R       E&  		if (status & QUI$M_JOB_EXECUTING ||&  		    (Bnr.Param_Bits.jobs_on_hold &&!  		    Bnr.Param_Bits.all_users))   		    showjob = 1;   *  		if (showjob)E  		    {  /* J   * If he/she didnt ask for all jobs, but did ask about intervening info, 2   * then if there are intervening jobs show a line   */  p(  		    if (!Bnr.Param_Bits.all_users &&   			!Bnr.Param_Bits.int_jobs && &  			!(status & QUI$M_JOB_EXECUTING) &&  			intjobcount > 0)  			{4  /*    * Create a line    */  			backup = 0; .  			oldhighlight = Qblock->Lines[i].highlight;#  			Qblock->Lines[i].highlight = 0;m"  			Qblock->Lines[i].LastLine = 1;     			strcpy (buf, "");n  			strcpy (buf1, "");  			strcpy (buf2, "");  o5  			sprintf (buf, "-    %d Int Job(s)", intjobcount);	  .&  			if (flags == QUI$M_SEARCH_PRINTER)3  			    sprintf (buf1, "%d blocks", intblockcount);n  			    5  			if (oldhighlight != Qblock->Lines[i].highlight ||.5  			    strcmp (buf, Qblock->Lines[i].Text) != 0   ||03  			    strcmp (buf1, Qblock->Lines[i].Text1) != 0) '  				Qblock->Lines[i].text_changed = 1;u(  			strcpy (Qblock->Lines[i].Text, buf);*  			strcpy (Qblock->Lines[i].Text1, buf1);   $  			intjobcount = intblockcount = 0;   "  			Qblock->Lines[i].LastLine = 1;  			if (i != 0)p-  			    Qblock->Lines[i-1].LastLine = 0;	    *  			i++;  			if (i > clu_max_lines)  			    return;t  			}u  /*c   * Now display this entry   */  		    backup = 0;1  		    oldhighlight = Qblock->Lines[i].highlight;s&  		    Qblock->Lines[i].highlight = 0;%  		    Qblock->Lines[i].LastLine = 1;  *6E  *6Ii      /*eN       * If he/she didnt ask for all jobs, but did ask about intervening info, 6       * then if there are intervening jobs show a line       */  g$  		if (!Bnr.Param_Bits.all_users && "  		    !Bnr.Param_Bits.int_jobs &&)  		    !(status & QUI$M_JOB_EXECUTING) &&e  		    intjobcount > 0)   		    {      /*l       * Create a line        */  		    Qblock->BackupLine = 0;C  		    oldhighlight = Qblock->Lines[Qblock->CurrentLine].highlight;c8  		    Qblock->Lines[Qblock->CurrentLine].highlight = 0;7  		    Qblock->Lines[Qblock->CurrentLine].LastLine = 1;  *6Ei  0  		    strcpy (buf, "");  		    strcpy (buf1, "");L  		    strcpy (buf2, "");   0 *6DS*  		    sprintf (buf, "-    %s", username);   		    strcpy (buf1, jobname);		  /*u
   * Add flags    */'  		    if (status & QUI$M_JOB_ABORTING)	*  			sprintf (buf1, "%s (Aborting)", buf1);(  		    if (status & QUI$M_JOB_EXECUTING)+  			sprintf (buf1, "%s (Executing)", buf1);n(  		    if (status & QUI$M_JOB_HOLDING ||%  			status & QUI$M_JOB_TIMED_RELEASE).)  			sprintf (buf1, "%s (Holding)", buf1); &  		    if (status & QUI$M_JOB_PENDING))  			sprintf (buf1, "%s (Pending)", buf1); &  		    if (status & QUI$M_JOB_REFUSED))  			sprintf (buf1, "%s (Refused)", buf1);c'  		    if (status & QUI$M_JOB_RETAINED)]*  			sprintf (buf1, "%s (Retained)", buf1);'  		    if (status & QUI$M_JOB_STARTING)y*  			sprintf (buf1, "%s (Starting)", buf1);(  		    if (status & QUI$M_JOB_SUSPENDED)+  			sprintf (buf1, "%s (Suspended)", buf1);   48  		    if (oldhighlight != Qblock->Lines[i].highlight ||1  			strcmp (buf, Qblock->Lines[i].Text) != 0   || /  			strcmp (buf1, Qblock->Lines[i].Text1) != 0)N*  			    Qblock->Lines[i].text_changed = 1;+  		    strcpy (Qblock->Lines[i].Text, buf);4-  		    strcpy (Qblock->Lines[i].Text1, buf1);f  t%  		    Qblock->Lines[i].LastLine = 1;6  		    if (i != 0))  			Qblock->Lines[i-1].LastLine = 0;	    L  		    i++;)  		    if (i > clu_max_lines)   			return;4     		    }  		}  /*b'   * See if we found anything to display    */  i  	    if (backup)1  		{  		i = savedi;!  		Qblock->Lines[i].LastLine = 1;   		if (i != 0),  		    Qblock->Lines[i-1].LastLine = 0;	      		} *6Et *6I.8  		    sprintf (buf, "-    %d Int Job(s)", intjobcount);  p)  		    if (flags == QUI$M_SEARCH_PRINTER) /  			sprintf (buf1, "%d blocks", intblockcount);   			J  		    if (oldhighlight != Qblock->Lines[Qblock->CurrentLine].highlight ||C  			strcmp (buf, Qblock->Lines[Qblock->CurrentLine].Text) != 0   || A  			strcmp (buf1, Qblock->Lines[Qblock->CurrentLine].Text1) != 0)[<  			    Qblock->Lines[Qblock->CurrentLine].text_changed = 1;=  		    strcpy (Qblock->Lines[Qblock->CurrentLine].Text, buf);o?  		    strcpy (Qblock->Lines[Qblock->CurrentLine].Text1, buf1);=  #'  		    intjobcount = intblockcount = 0;E  R7  		    Qblock->Lines[Qblock->CurrentLine].LastLine = 1;[$  		    if (Qblock->CurrentLine != 0);  			Qblock->Lines[Qblock->CurrentLine-1].LastLine = 0;	    t  		    Qblock->CurrentLine++;R/  		    if (Qblock->CurrentLine > clu_max_lines)g  			{=(  			Qblock->Updated = Qblock->Valid = 1;  			Qblock->CurrentLine = 0;  			Qblock->DoingQueue = 0;   			return;			  			}	  		    }      /*e       * Now display this entry       */  		Qblock->BackupLine = 0;?  		oldhighlight = Qblock->Lines[Qblock->CurrentLine].highlight;s4  		Qblock->Lines[Qblock->CurrentLine].highlight = 0;3  		Qblock->Lines[Qblock->CurrentLine].LastLine = 1;   	  		strcpy (buf, "");  		strcpy (buf1, "");   		strcpy (buf2, "");	    *7Dt&  		sprintf (buf, "-    %s", username); *7Ee *7IT2  		sprintf (buf, "- %d  %s", jobnumber, username); *7E   		strcpy (buf1, jobname);		      /*"       * Add flags        */#  		if (status & QUI$M_JOB_ABORTING)6-  		    sprintf (buf1, "%s (Aborting)", buf1);f$  		if (status & QUI$M_JOB_EXECUTING) *7D .  		    sprintf (buf1, "%s (Executing)", buf1); *7Ea *7I)  		    {)  		    if (flags == QUI$M_SEARCH_PRINTER) *  			sprintf (buf1, "%s (Printing)", buf1);  		    elset+  			sprintf (buf1, "%s (Executing)", buf1);g  		    } *7E6$  		if (status & QUI$M_JOB_HOLDING ||(  		    status & QUI$M_JOB_TIMED_RELEASE),  		    sprintf (buf1, "%s (Holding)", buf1);"  		if (status & QUI$M_JOB_PENDING),  		    sprintf (buf1, "%s (Pending)", buf1);"  		if (status & QUI$M_JOB_REFUSED),  		    sprintf (buf1, "%s (Refused)", buf1);#  		if (status & QUI$M_JOB_RETAINED)1-  		    sprintf (buf1, "%s (Retained)", buf1);	#  		if (status & QUI$M_JOB_STARTING)E-  		    sprintf (buf1, "%s (Starting)", buf1);t$  		if (status & QUI$M_JOB_SUSPENDED).  		    sprintf (buf1, "%s (Suspended)", buf1);   F  		if (oldhighlight != Qblock->Lines[Qblock->CurrentLine].highlight ||F  		    strcmp (buf, Qblock->Lines[Qblock->CurrentLine].Text) != 0   ||D  		    strcmp (buf1, Qblock->Lines[Qblock->CurrentLine].Text1) != 0)8  			Qblock->Lines[Qblock->CurrentLine].text_changed = 1;9  		strcpy (Qblock->Lines[Qblock->CurrentLine].Text, buf);i;  		strcpy (Qblock->Lines[Qblock->CurrentLine].Text1, buf1);%  U3  		Qblock->Lines[Qblock->CurrentLine].LastLine = 1;l   		if (Qblock->CurrentLine != 0)>  		    Qblock->Lines[Qblock->CurrentLine-1].LastLine = 0;	      		Qblock->CurrentLine++;u+  		if (Qblock->CurrentLine > clu_max_lines)g  		    {+  		    Qblock->Updated = Qblock->Valid = 1;,  		    Qblock->CurrentLine = 0;i  		    Qblock->DoingQueue = 0;  		    return;			a  		    }  L  		}
  	    return;= *6E  *4Ec  	    }k  	else *4Dx  	    if (i != 0)(!  		Qp.Lines[i].LastLine = 1;	      *4E  *4I  *6D 7  	    if (!queuealive && Bnr.Param_Bits.stopped_queues)	 *6Eq *6Id?  	    if (!Qblock->QueueAlive && Bnr.Param_Bits.stopped_queues)o *6Eu  		{ *6D !  		Qblock->Lines[i].LastLine = 1;p  		if (i != 0),  		    Qblock->Lines[i-1].LastLine = 0;	      		i++;n  		if (i > clu_max_lines)p  		    return;  /*=:   * This queue is dead, show how many jobs are held on it.   */ *6E  *6I       /*6>       * This queue is dead, show how many jobs are held on it.       */ *6E %  		if (holdingcount+pendingcount > 0)e  		    { *6Df  /*x   * Create a line*   */1  		    oldhighlight = Qblock->Lines[i].highlight; &  		    Qblock->Lines[i].highlight = 1;%  		    Qblock->Lines[i].LastLine = 1;  *6Et *6I	      /*o       * Create a lineb       */C  		    oldhighlight = Qblock->Lines[Qblock->CurrentLine].highlight; 8  		    Qblock->Lines[Qblock->CurrentLine].highlight = 1;7  		    Qblock->Lines[Qblock->CurrentLine].LastLine = 1;; *6E    B  		    sprintf (buf, "-    %d Job(s)", holdingcount+pendingcount);)  		    sprintf (buf1, "Holding/Pending");   w *6Dn8  		    if (oldhighlight != Qblock->Lines[i].highlight ||1  			strcmp (buf, Qblock->Lines[i].Text) != 0   ||t/  			strcmp (buf1, Qblock->Lines[i].Text1) != 0)Q*  			    Qblock->Lines[i].text_changed = 1;+  		    strcpy (Qblock->Lines[i].Text, buf);e-  		    strcpy (Qblock->Lines[i].Text1, buf1);	 *6E} *6I J  		    if (oldhighlight != Qblock->Lines[Qblock->CurrentLine].highlight ||C  			strcmp (buf, Qblock->Lines[Qblock->CurrentLine].Text) != 0   || A  			strcmp (buf1, Qblock->Lines[Qblock->CurrentLine].Text1) != 0) <  			    Qblock->Lines[Qblock->CurrentLine].text_changed = 1;=  		    strcpy (Qblock->Lines[Qblock->CurrentLine].Text, buf); ?  		    strcpy (Qblock->Lines[Qblock->CurrentLine].Text1, buf1);	 *6E	  t *6Du%  		    Qblock->Lines[i].LastLine = 1;}  		    if (i != 0))  			Qblock->Lines[i-1].LastLine = 0;	    i  		    i++;h  		    if (i > clu_max_lines)r  			return;   		    } *6E  *6Iw7  		    Qblock->Lines[Qblock->CurrentLine].LastLine = 1;,$  		    if (Qblock->CurrentLine != 0);  			Qblock->Lines[Qblock->CurrentLine-1].LastLine = 0;	    s  		    Qblock->CurrentLine++;8/  		    if (Qblock->CurrentLine > clu_max_lines)Q  			{B(  			Qblock->Updated = Qblock->Valid = 1;  			Qblock->CurrentLine = 0;  			Qblock->DoingQueue = 0;   			return;			  			}   		    }  		Qblock->DoingQueue = 0;
  		return; *6Et  		}
  	    else *6Do  		if (!queuealive)s *6Eb *6I   		if (!Qblock->QueueAlive)I *6EP	  		    {	  *6Dn  		    int savedi, found;i  !  s  		    savedi = i;  		    found = 0;L   %  		    Qblock->Lines[i].LastLine = 1;   		    if (i != 0))  			Qblock->Lines[i-1].LastLine = 0;	    	  		    i++;r  		    if (i > clu_max_lines)  *6E  *6Io  		    int sts;   		    int iosb[2];e.  		    int intjobcount = 0, intblockcount = 0;  s  r      /*dO       * Scan the queue for our name, and if we find our jobs, display it anywayC       */  iI  		    sts = SYS$GETQUIW (0, QUI$_DISPLAY_JOB, 0, &jobinfo, &iosb, 0, 0);0   :  		    if (!(sts & SS$_NORMAL) || !(iosb[0] & SS$_NORMAL))  			{   			Qblock->DoingQueue = 0;b  	    /*8  	     * Didnt find any, so dont bother displaying queue	  	     */i  			if (Qblock->BackupLine) 	  			    {h0  			    Qblock->CurrentLine = Qblock->SavedLine;8  			    Qblock->Lines[Qblock->CurrentLine].LastLine = 1;%  			    if (Qblock->CurrentLine != 0)_<  				Qblock->Lines[Qblock->CurrentLine-1].LastLine = 0;	    	  			    }M  B *6EU  			return;	 *6Db  /* K   * Scan the queue for our name, and if we find our jobs, display it anywayg   */  		    while (1) *6Eh *6I	  			}k      /*]       * Is it one of ours?       */.  		    if (strncmp (username, Bnr.queue_user,  *8Dy#  				strlen(Bnr.queue_user)) == 0 )  *8E	 *8Ii$  				strlen(Bnr.queue_user)) == 0 ||   			strcmp (username, "*") == 0) *8EA *6ER  			{  *6D   			int sts;  			int iosb[2];+  			int intjobcount = 0, intblockcount = 0;t   F  			sts = SYS$GETQUIW (0, QUI$_DISPLAY_JOB, 0, &jobinfo, &iosb, 0, 0);   7  			if (!(sts & SS$_NORMAL) || !(iosb[0] & SS$_NORMAL))   			    break;  -  /*s   * Is it one of ours?   */+  			if (strncmp (username, Bnr.queue_user, y'  				    strlen(Bnr.queue_user)) == 0 )	 *6Eb *6I   			Qblock->BackupLine = 0;	@  			oldhighlight = Qblock->Lines[Qblock->CurrentLine].highlight;5  			Qblock->Lines[Qblock->CurrentLine].highlight = 1;l4  			Qblock->Lines[Qblock->CurrentLine].LastLine = 1;  p  			strcpy (buf, "");	  			strcpy (buf1, "");  			strcpy (buf2, "");  e'  			sprintf (buf, "-    %s", username);.  			strcpy (buf1, jobname);		L  s)  			sprintf (buf1, "%s (Holding)", buf1);    G  			if (oldhighlight != Qblock->Lines[Qblock->CurrentLine].highlight || G  			    strcmp (buf, Qblock->Lines[Qblock->CurrentLine].Text) != 0   ||iE  			    strcmp (buf1, Qblock->Lines[Qblock->CurrentLine].Text1) != 0)	9  				Qblock->Lines[Qblock->CurrentLine].text_changed = 1;t:  			strcpy (Qblock->Lines[Qblock->CurrentLine].Text, buf);<  			strcpy (Qblock->Lines[Qblock->CurrentLine].Text1, buf1);  i4  			Qblock->Lines[Qblock->CurrentLine].LastLine = 1;!  			if (Qblock->CurrentLine != 0) ?  			    Qblock->Lines[Qblock->CurrentLine-1].LastLine = 0;	    6  			Qblock->CurrentLine++;,  			if (Qblock->CurrentLine > clu_max_lines) *6Ef	  			    {0 *6DS  			    found = 1;2  			    oldhighlight = Qblock->Lines[i].highlight;'  			    Qblock->Lines[i].highlight = 1; &  			    Qblock->Lines[i].LastLine = 1;  i  			    strcpy (buf, "");   			    strcpy (buf1, "");  			    strcpy (buf2, "");  t+  			    sprintf (buf, "-    %s", username); !  			    strcpy (buf1, jobname);			  t-  			    sprintf (buf1, "%s (Holding)", buf1);f  "9  			    if (oldhighlight != Qblock->Lines[i].highlight ||N2  				strcmp (buf, Qblock->Lines[i].Text) != 0   ||0  				strcmp (buf1, Qblock->Lines[i].Text1) != 0)+  				    Qblock->Lines[i].text_changed = 1;u,  			    strcpy (Qblock->Lines[i].Text, buf);.  			    strcpy (Qblock->Lines[i].Text1, buf1);  O&  			    Qblock->Lines[i].LastLine = 1;  			    if (i != 0) *  				Qblock->Lines[i-1].LastLine = 0;	      			    i++;  			    if (i > clu_max_lines)  				return;  i *6E= *6Ic,  			    Qblock->Updated = Qblock->Valid = 1;   			    Qblock->CurrentLine = 0;  			    Qblock->DoingQueue = 0;T  			    return;			 *6Eo	  			    }] *6D_  			}   /* 3   * Didnt find any, so dont bother displaying queues   */  		    if (!found)  			{f  			i = savedi;Q"  			Qblock->Lines[i].LastLine = 1;  			if (i != 0)	-  			    Qblock->Lines[i-1].LastLine = 0;	      *6E) *6I   i *6E>  			}x  		    } *4Ee *6I4   
  	return;	  	}   b  /*    * search all the queues    */K      sts = SYS$GETQUIW (0, QUI$_DISPLAY_QUEUE, 0, &queueinfo, &iosb, 0, 0);a  i8      if (!(sts & SS$_NORMAL) || !(iosb[0] & SS$_NORMAL))  	{0&  	Qblock->Updated = Qblock->Valid = 1;  	Qblock->CurrentLine = 0;  	Qblock->DoingQueue = 0;i	  	return;   	}_  R  PA      oldhighlight = Qblock->Lines[Qblock->CurrentLine].highlight;	6      Qblock->Lines[Qblock->CurrentLine].highlight = 0;5      Qblock->Lines[Qblock->CurrentLine].LastLine = 1;-  r      Qblock->QueueAlive = 1;  t      strcpy (buf, "");      strcpy (buf1, "");x      strcpy (buf2, "");k      strcpy (buf, queuename);x  /*n   * Add node name if we need toL   *//      if (!(queueflags & QUI$M_QUEUE_GENERIC) &&Q  	strlen (nodename) != 0)t(  	    sprintf (buf1, "on %s", nodename);  /*i   * check status   */   %      if (status & QUI$M_QUEUE_CLOSED)a  	{e-  	sprintf (buf1, "on %s (Closed)", nodename);	3  	Qblock->Lines[Qblock->CurrentLine].highlight = 1;   	Qblock->QueueAlive = 0;t  	}			  	%      if (status & QUI$M_QUEUE_PAUSED)l  	{g-  	sprintf (buf1, "on %s (Paused)", nodename); 3  	Qblock->Lines[Qblock->CurrentLine].highlight = 1;e  	Qblock->QueueAlive = 0;	  	}			   &      if (status & QUI$M_QUEUE_PAUSING)  	{ .  	sprintf (buf1, "on %s (Pausing)", nodename);3  	Qblock->Lines[Qblock->CurrentLine].highlight = 1;s  	Qblock->QueueAlive = 0;C  	}			  .(      if (status & QUI$M_QUEUE_RESETTING)  	{t0  	sprintf (buf1, "on %s (Resetting)", nodename);3  	Qblock->Lines[Qblock->CurrentLine].highlight = 1;t  	Qblock->QueueAlive = 0;"  	}			  ;'      if (status & QUI$M_QUEUE_RESUMING),  	{u/  	sprintf (buf1, "on %s (Resuming)", nodename);;3  	Qblock->Lines[Qblock->CurrentLine].highlight = 1;a  	Qblock->QueueAlive = 0;   	}			  n&      if (status & QUI$M_QUEUE_STALLED)  	{a.  	sprintf (buf1, "on %s (Stalled)", nodename);3  	Qblock->Lines[Qblock->CurrentLine].highlight = 1;{  	Qblock->QueueAlive = 0;_  	}			  T'      if (status & QUI$M_QUEUE_STARTING)   	{;/  	sprintf (buf1, "on %s (Starting)", nodename);)3  	Qblock->Lines[Qblock->CurrentLine].highlight = 1;_  	Qblock->QueueAlive = 0;   	}			  I&      if (status & QUI$M_QUEUE_STOPPED)  	{i.  	sprintf (buf1, "on %s (Stopped)", nodename);3  	Qblock->Lines[Qblock->CurrentLine].highlight = 1;   	Qblock->QueueAlive = 0;)  	}			  r'      if (status & QUI$M_QUEUE_STOPPING)   	{u/  	sprintf (buf1, "on %s (Stopping)", nodename);%3  	Qblock->Lines[Qblock->CurrentLine].highlight = 1;R  	Qblock->QueueAlive = 0;1  	}			  t*      if (status & QUI$M_QUEUE_UNAVAILABLE)  	{E2  	sprintf (buf1, "on %s (Unavaliable)", nodename);3  	Qblock->Lines[Qblock->CurrentLine].highlight = 1;e  	Qblock->QueueAlive = 0;   	}			  fH      if (oldhighlight != Qblock->Lines[Qblock->CurrentLine].highlight ||A  	strcmp (buf, Qblock->Lines[Qblock->CurrentLine].Text) != 0   ||[?  	strcmp (buf1, Qblock->Lines[Qblock->CurrentLine].Text1) != 0)Q:  	    Qblock->Lines[Qblock->CurrentLine].text_changed = 1;;      strcpy (Qblock->Lines[Qblock->CurrentLine].Text, buf);c=      strcpy (Qblock->Lines[Qblock->CurrentLine].Text1, buf1);)  	  /*Q   * Should we show this queue?   */  i      Qblock->DoingQueue = 1; *8De      Qblock->BackupLine = 1; *8Ec *8Ix  n      if (!Qblock->QueueAlive)U  	Qblock->BackupLine = 1;,  	 *8EQ-      Qblock->SavedLine = Qblock->CurrentLine;u   5      Qblock->Lines[Qblock->CurrentLine].LastLine = 1;u"      if (Qblock->CurrentLine != 0)9  	Qblock->Lines[Qblock->CurrentLine-1].LastLine = 0;	       4      Qblock->CurrentLine++;e-      if (Qblock->CurrentLine > clu_max_lines)q  	{d&  	Qblock->Updated = Qblock->Valid = 1;  	Qblock->CurrentLine = 0;  	Qblock->DoingQueue = 0;-  	return;			 *6E=  	}  *3E  *6I     *6E   }