  #module BannerTP "V1.0"     /*   **++   **  FACILITY:  ** &  **      The DECwindows Banner program  **   **  ABSTRACT:  ** H  **      This module contains all the code concerned with the TP monitor"  **  window in the banner program.  ** 
  **  AUTHORS:   **   **      Jim Saunders   **   **  *3D ,  **  CREATION DATE:     278th September 1989 *3E  *3I %  **  CREATION DATE:     20th May 1990  *3E   **   **  MODIFICATION HISTORY:  **--   **/        #include "stdio.h"   #include "MrmAppl.h"         #include "Banner"        /*   **   **  MACRO DEFINITIONS  **   **/        void BannerTPSetup ();   void BannerTPRefresh ();   void BannerTP (); *3D   static void CollectCpuData ();       extern void BANNERCMKRNLTRAP(); *3E  *3I     *3E   /* J   * Definitions of other static items we use throughout the banner program   * to reduce our setup times.     */     extern	 Bnr$_Blk    Bnr;  *3D   extern	 Tp$_Blk    Tp;  *3E  *3I   extern	 Tp$_Blk     Tp; *3E   extern   Mon$_Blk    Mon;  extern	 GC	     BannerGC;    *6I  *7D ,  extern   char	     *BannerVmsDisplayName[]; *7E  *7I *  extern   char	     *BannerVmsDisplayName; *7E  *6E (  extern   char	     BannerVmsNodeName[];'  extern   char	     BannerVmsVersion[];     *3D A  globalref int MON_V_NI_MNTVERIP, MON_V_NI_BUSY, MON_V_NI_SYS_MV;    J  static int OLD_MON_V_NI_MNTVERIP, OLD_MON_V_NI_BUSY, OLD_MON_V_NI_SYS_MV; *3E  *3I   typedef struct _ddtm_data { *4I   	char	fill [148]; *4E   	int	DDTM_STARTS;  	int	DDTM_PREPARES; *4D   	int	DDTM_ONE_PHASE;  *4E   	int	DDTM_COMMITS;   	int	DDTM_ABORTS;  	int	DDTM_ENDS; *4I   	int	DDTM_ONE_PHASE;  *4E   	int	DDTM_BRANCHS;   	int	DDTM_ADDS; *5I   	char	fill1 [16]; *5E   	int	DDTM_BUCKETS[6];  	} ddtm$data;    *5D 0  globalref ddtm$data  DDTM$AR_PERFORMANCE_CELLS; *5E  *5I 1  globalref ddtm$data  *DDTM$AR_PERFORMANCE_CELLS;  *5E  *3E       .  static int tp_update_count, tp_update_number;,  static int tp_hwmrk_count, tp_hwmrk_number;  static int tp_init = 0;    *3D   static float last_total = 0;   static float last_null = 0;     static float total_time = 0;   static float total_null = 0;      static int last_pfg_rate;  static int last_syf_rate;  static int last_pg_io;   static int last_rem_io;  static int last_disk1_io;  static int last_disk2_io;  static int last_disk3_io;     typedef struct _cpudata {  char fill_1[632];  int cpu$l_kernel;  int cpu$l_executive;   int cpu$l_super;   int cpu$l_user;  int cpu$l_interrupt;   int cpu$l_compatibility;   int cpu$l_spinlock;  int cpu$l_nullcpu;   } cpu$data;       H  globalref cpu$data *SMP$GL_CPU_DATA[];	    /* CPU data pointer array */<  globalref int SMP$GL_ACTIVE_CPUS;	    /* Active cpu mask */   >  globalref int PMS$GL_PREADIO, PMS$GL_PWRITIO, PMS$GL_FAULTS, A  	   SCH$GL_MFYCNT, SCH$GL_MFYLIM, SCH$GL_FREECNT, MMG$GL_MAXMEM;    6  globalref short int SGN$GW_PAGFILCT, SGN$GW_SWPFILES;$  globalref int (*MMG$GL_PAGSWPVC)[];     typedef struct _pgfiledata {   int	    bitmap_addr;   int	    scan_offset;   short int   size;  char	    type;   char	    pfc;  int	    wincntrlblk; 
  int	    bvn;   int	    bmap_size;   int	    alloc_size;  int	    res_size;  int	    bitmap;  } pagefile$data;    3  static int pgf_size, pgf_alloc_size, pgf_res_size; 3  static int swp_size, swp_alloc_size, swp_res_size;  *3E  *3I !  static int last_ddtm_starts = 0; #  static int last_ddtm_prepares = 0; $  static int last_ddtm_one_phase = 0; *4D #  static int  last_ddtm_commits = 0;  *4E  *4I "  static int last_ddtm_commits = 0; *4E !  static int last_ddtm_aborts = 0;   static int last_ddtm_ends = 0; "  static int last_ddtm_branchs = 0;  static int last_ddtm_adds = 0; 1  static int last_ddtm_buckets[6] = {0,0,0,0,0,0};  *3E        /*   **++   **  FUNCTIONAL DESCRIPTION:  **   **      BannerTPSetup ()   **   **  FORMAL PARAMETERS:   ** D  **      This is the setup routine for the Banner TP Window display.  **   **  IMPLICIT INPUTS:   **   **      The TP data block  **   **  IMPLICIT OUTPUTS:  ** 
  **      none   **   **  COMPLETION CODES:  ** 
  **      none   **   **  SIDE EFFECTS:  ** 
  **      none   **   **--   **/  void	BannerTPSetup()   {$      int maxnamesize, maxnamepoints;      int tw, twsize;      static char membuf[125];  *3I .      static char tval2[5], tval3[5], tval4[5]; *3E          tp_update_count = 1;          if (Bnr.hwmrk_update == 0)   	tp_hwmrk_number = 300;	      else %  	tp_hwmrk_number = Bnr.hwmrk_update; &      tp_hwmrk_count = tp_hwmrk_number;         if (Bnr.tp_update == 0)$  	tp_update_number = Bnr.cpu_update;	      else #  	tp_update_number = Bnr.tp_update;      /*     * Now setup the tp data block.   */    *3D       BannerMonSetup ();       CollectCpuData (0, 0);    .      last_disk1_io = BannerDeviceCount (0, 1);.      last_disk2_io = BannerDeviceCount (1, 1);.      last_disk3_io = BannerDeviceCount (2, 1);         OLD_MON_V_NI_SYS_MV = -1;       OLD_MON_V_NI_MNTVERIP = -1;      OLD_MON_V_NI_BUSY = -1; *3E  *3I  *5D ,      if (&DDTM$AR_PERFORMANCE_CELLS != NULL) *5E  *5I +      if (DDTM$AR_PERFORMANCE_CELLS != NULL)  *5E   	{  *5D ;  	last_ddtm_starts = DDTM$AR_PERFORMANCE_CELLS.DDTM_STARTS; ?  	last_ddtm_prepares = DDTM$AR_PERFORMANCE_CELLS.DDTM_PREPARES; A  	last_ddtm_one_phase = DDTM$AR_PERFORMANCE_CELLS.DDTM_ONE_PHASE;  *5E  *4I  *5D =  	last_ddtm_commits = DDTM$AR_PERFORMANCE_CELLS.DDTM_COMMITS;  *5E  *4E  *5D ;  	last_ddtm_aborts = DDTM$AR_PERFORMANCE_CELLS.DDTM_ABORTS; 7  	last_ddtm_ends = DDTM$AR_PERFORMANCE_CELLS.DDTM_ENDS; =  	last_ddtm_branchs = DDTM$AR_PERFORMANCE_CELLS.DDTM_BRANCHS; 7  	last_ddtm_adds = DDTM$AR_PERFORMANCE_CELLS.DDTM_ADDS;   	memcpy(&last_ddtm_buckets[0], A  	    &DDTM$AR_PERFORMANCE_CELLS.DDTM_BUCKETS[0],6*sizeof(int) );  *5E  *5I <  	last_ddtm_starts = DDTM$AR_PERFORMANCE_CELLS->DDTM_STARTS;@  	last_ddtm_prepares = DDTM$AR_PERFORMANCE_CELLS->DDTM_PREPARES;B  	last_ddtm_one_phase = DDTM$AR_PERFORMANCE_CELLS->DDTM_ONE_PHASE;>  	last_ddtm_commits = DDTM$AR_PERFORMANCE_CELLS->DDTM_COMMITS;<  	last_ddtm_aborts = DDTM$AR_PERFORMANCE_CELLS->DDTM_ABORTS;8  	last_ddtm_ends = DDTM$AR_PERFORMANCE_CELLS->DDTM_ENDS;>  	last_ddtm_branchs = DDTM$AR_PERFORMANCE_CELLS->DDTM_BRANCHS;8  	last_ddtm_adds = DDTM$AR_PERFORMANCE_CELLS->DDTM_ADDS;D  	last_ddtm_buckets[0] = DDTM$AR_PERFORMANCE_CELLS->DDTM_BUCKETS[0];D  	last_ddtm_buckets[1] = DDTM$AR_PERFORMANCE_CELLS->DDTM_BUCKETS[1];D  	last_ddtm_buckets[2] = DDTM$AR_PERFORMANCE_CELLS->DDTM_BUCKETS[2];D  	last_ddtm_buckets[3] = DDTM$AR_PERFORMANCE_CELLS->DDTM_BUCKETS[3];D  	last_ddtm_buckets[4] = DDTM$AR_PERFORMANCE_CELLS->DDTM_BUCKETS[4];D  	last_ddtm_buckets[5] = DDTM$AR_PERFORMANCE_CELLS->DDTM_BUCKETS[5]; *5E   	}  *3E    !      memset (&Tp, 0, sizeof(Tp));     *3D       maxnamesize = 13;C      maxnamepoints = XTextWidth(Bnr.font_ptr, "Pgf/Sysf Rate", 13);    (      if (Mon.dua0 && Bnr.disk_0 != NULL)  	{ &  	tw = name_size(Bnr.disk_0_name) - 1;5  	twsize = XTextWidth(Bnr.font_ptr, Bnr.disk_0_name,    		tw);   	if (twsize > maxnamepoints)   	    {   	    maxnamesize = tw;   	    maxnamepoints = twsize;   	    }   	}       (      if (Mon.dua1 && Bnr.disk_1 != NULL)  	{ &  	tw = name_size(Bnr.disk_1_name) - 1;5  	twsize = XTextWidth(Bnr.font_ptr, Bnr.disk_1_name,    		tw);   	if (twsize > maxnamepoints)   	    {   	    maxnamesize = tw;   	    maxnamepoints = twsize;   	    }   	}       (      if (Mon.dua2 && Bnr.disk_2 != NULL)  	{ &  	tw = name_size(Bnr.disk_2_name) - 1;5  	twsize = XTextWidth(Bnr.font_ptr, Bnr.disk_2_name,    		tw);   	if (twsize > maxnamepoints)  *3E  *3I       maxnamesize = 14; *4D D      maxnamepoints = XTextWidth(Bnr.font_ptr, "1Phase Commitx", 14); *4E  *4I D      maxnamepoints = XTextWidth(Bnr.font_ptr, "1Phase Commits", 14); *4E       '      if (Bnr.Param_Bits.total_com_rate)   	{ *  	Tp.total_com_rate.Name = "Total Commit";#  	Tp.total_com_rate.LineActive = 1; -  	Tp.total_com_rate.MaxVal = Bnr.tp_max_rate; .  	Tp.total_com_rate.MaxNameSize = maxnamesize;2  	Tp.total_com_rate.MaxNamePoints = maxnamepoints;  	}    '      if (Bnr.Param_Bits.onef_comp_rate)   	{ +  	Tp.onef_comp_rate.Name = "1Phase Commit"; #  	Tp.onef_comp_rate.LineActive = 1; -  	Tp.onef_comp_rate.MaxVal = Bnr.tp_max_rate; .  	Tp.onef_comp_rate.MaxNameSize = maxnamesize;2  	Tp.onef_comp_rate.MaxNamePoints = maxnamepoints;  	}    ?      if (Bnr.Param_Bits.start_rate || Bnr.Param_Bits.prep_rate)   	{   	int half = 0;    	if (Bnr.Param_Bits.start_rate)  	    {   	    half = 1; (  	    Tp.start_rate.Name = "Start Rate";#  	    Tp.start_rate.LineActive = 1; -  	    Tp.start_rate.MaxVal = Bnr.tp_max_rate; .  	    Tp.start_rate.MaxNameSize = maxnamesize;2  	    Tp.start_rate.MaxNamePoints = maxnamepoints;  	    }   	if (Bnr.Param_Bits.prep_rate)   	    {   	    if (half)   		{9  		Tp.start_rate.Name = Tp.prep_rate.Name = "Start/Prep";   		}
  	    else  		{#  		Tp.prep_rate.Name = "Prep Rate"; 	  		}	     ,  	    Tp.prep_rate.MaxVal = Bnr.tp_max_rate;"  	    Tp.prep_rate.LineActive = 1;#  	    Tp.prep_rate.HalfLine = half; -  	    Tp.prep_rate.MaxNameSize = maxnamesize; 1  	    Tp.prep_rate.MaxNamePoints = maxnamepoints;   	    }   	}       >      if (Bnr.Param_Bits.abort_rate || Bnr.Param_Bits.end_rate)  	{   	int half = 0;    	if (Bnr.Param_Bits.abort_rate)  	    {   	    half = 1; (  	    Tp.abort_rate.Name = "Abort Rate";#  	    Tp.abort_rate.LineActive = 1; -  	    Tp.abort_rate.MaxVal = Bnr.tp_max_rate; .  	    Tp.abort_rate.MaxNameSize = maxnamesize;2  	    Tp.abort_rate.MaxNamePoints = maxnamepoints;  	    }   	if (Bnr.Param_Bits.end_rate) *3E   	    {  *3D   	    maxnamesize = tw;   	    maxnamepoints = twsize;  *3E  *3I   	    if (half)   		{7  		Tp.abort_rate.Name = Tp.end_rate.Name = "Abort/End";   		}
  	    else  		{!  		Tp.end_rate.Name = "End Rate"; 	  		}	     +  	    Tp.end_rate.MaxVal = Bnr.tp_max_rate; !  	    Tp.end_rate.LineActive = 1; "  	    Tp.end_rate.HalfLine = half;,  	    Tp.end_rate.MaxNameSize = maxnamesize;0  	    Tp.end_rate.MaxNamePoints = maxnamepoints; *3EB  	    }V  	}        *3D+      if (Mon.dua0)  	{ "  	Tp.Disk1.Name = Bnr.disk_0_name;  	Tp.Disk1.LineActive = 1;-  	Tp.Disk1.MaxVal = BannerDeviceCount (0, 2);c  e&  	Tp.Disk1Rate.Name = Bnr.disk_0_name;*  	Tp.Disk1Rate.MaxVal = Bnr.sys_ioratemax;6  	Tp.Disk1Rate.LineActive = Tp.Disk1Rate.HalfLine = 1;)  	Tp.Disk1Rate.MaxNameSize = maxnamesize; -  	Tp.Disk1Rate.MaxNamePoints = maxnamepoints;3  	}*         if (Mon.dua1)  	{:"  	Tp.Disk2.Name = Bnr.disk_1_name;  	Tp.Disk2.LineActive = 1;-  	Tp.Disk2.MaxVal = BannerDeviceCount (1, 2); %  	Tp.Disk2.MaxNameSize = maxnamesize;/)  	Tp.Disk2.MaxNamePoints = maxnamepoints;a  r&  	Tp.Disk2Rate.Name = Bnr.disk_1_name;*  	Tp.Disk2Rate.MaxVal = Bnr.sys_ioratemax;6  	Tp.Disk2Rate.LineActive = Tp.Disk2Rate.HalfLine = 1;)  	Tp.Disk2Rate.MaxNameSize = maxnamesize;u-  	Tp.Disk2Rate.MaxNamePoints = maxnamepoints;   	}e         if (Mon.dua2)  	{r"  	Tp.Disk3.Name = Bnr.disk_2_name;  	Tp.Disk3.LineActive = 1;-  	Tp.Disk3.MaxVal = BannerDeviceCount (2, 2);$%  	Tp.Disk3.MaxNameSize = maxnamesize;;)  	Tp.Disk3.MaxNamePoints = maxnamepoints;e  s&  	Tp.Disk3Rate.Name = Bnr.disk_2_name;*  	Tp.Disk3Rate.MaxVal = Bnr.sys_ioratemax;6  	Tp.Disk3Rate.LineActive = Tp.Disk3Rate.HalfLine = 1;)  	Tp.Disk3Rate.MaxNameSize = maxnamesize;a-  	Tp.Disk3Rate.MaxNamePoints = maxnamepoints;V  	}Y  V      if (Mon.fp) *3E_ *3I_F      if (Bnr.Param_Bits.rem_start_rate || Bnr.Param_Bits.rem_end_rate) *3Er  	{d *3Da9  	sprintf(membuf, "Mem (%d Mb)", (MMG$GL_MAXMEM/2048)+1);	  	tw = name_size(membuf) - 1;	,  	twsize = XTextWidth(Bnr.font_ptr, membuf,   		tw);M  	if (twsize > maxnamepoints)  *3En *3IM  	int half = 0; $  	if (Bnr.Param_Bits.rem_start_rate) *3E5  	    {r *3D1  	    maxnamesize = tw;B  	    maxnamepoints = twsize;  *3E  *3Ia  	    half = 1;D0  	    Tp.rem_start_rate.Name = "Rem Start Rate";'  	    Tp.rem_start_rate.LineActive = 1;51  	    Tp.rem_start_rate.MaxVal = Bnr.tp_max_rate;p2  	    Tp.rem_start_rate.MaxNameSize = maxnamesize;6  	    Tp.rem_start_rate.MaxNamePoints = maxnamepoints; *3Et  	    }0 *3Ds  	Tp.FreeMem.Name = &membuf;  	Tp.FreeMem.LineActive = 1;$  	Tp.FreeMem.MaxVal = MMG$GL_MAXMEM;'  	Tp.FreeMem.MaxNameSize = maxnamesize; +  	Tp.FreeMem.MaxNamePoints = maxnamepoints;a   
  	if (Mon.mp); *3Ea *3In"  	if (Bnr.Param_Bits.rem_end_rate) *3Ei  	    {i *3D   	    Tp.ModMem.Name = &membuf;c  	    Tp.ModMem.LineActive = 1;   	    Tp.ModMem.HalfLine = 1;e'  	    Tp.ModMem.MaxVal = SCH$GL_MFYLIM;l*  	    Tp.ModMem.MaxNameSize = maxnamesize;.  	    Tp.ModMem.MaxNamePoints = maxnamepoints; *3Ec *3I   	    if (half)   		{C  		Tp.rem_start_rate.Name = Tp.rem_end_rate.Name = "Rem Start/Add";/  		}
  	    else  		{)  		Tp.rem_end_rate.Name = "Rem Add Rate"; 	  		}	    i/  	    Tp.rem_end_rate.MaxVal = Bnr.tp_max_rate; %  	    Tp.rem_end_rate.LineActive = 1;H&  	    Tp.rem_end_rate.HalfLine = half;0  	    Tp.rem_end_rate.MaxNameSize = maxnamesize;4  	    Tp.rem_end_rate.MaxNamePoints = maxnamepoints; *3Ep  	    }   	}i    *3Dt      Tp.FreeCpu.Name = "Cpu";t      Tp.FreeCpu.LineActive = 1; *      Tp.FreeCpu.MaxNameSize = maxnamesize;.      Tp.FreeCpu.MaxNamePoints = maxnamepoints;  a      if (Mon.pf) *3Es *3I;  i@      if (Bnr.Param_Bits.comp_rate1 || Bnr.Param_Bits.comp_rate2) *3E_  	{  *3De  	Tp.Pgf.Name = "Page file";  	Tp.Pgf.LineActive = 1;#  	Tp.Pgf.MaxNameSize = maxnamesize;d'  	Tp.Pgf.MaxNamePoints = maxnamepoints;r  r   	Tp.PgfRate.Name = "Page file";  	Tp.PgfRate.LineActive = 1;  	Tp.PgfRate.HalfLine = 1;   	last_pfg_rate = PMS$GL_FAULTS;+  	Tp.PgfRate.MaxVal = Bnr.sys_faultratemax;r'  	Tp.PgfRate.MaxNameSize = maxnamesize; +  	Tp.PgfRate.MaxNamePoints = maxnamepoints;   	}a  d      if (Mon.pio)a *3En *3It  	static char buf[20];  	int half = 0;    	if (Bnr.Param_Bits.comp_rate1)  	    {I  	    half = 1;    	    Tp.comp_rate1.Name = &buf;#  	    Tp.comp_rate1.LineActive = 1;T-  	    Tp.comp_rate1.MaxVal = Bnr.tp_max_rate;o.  	    Tp.comp_rate1.MaxNameSize = maxnamesize;2  	    Tp.comp_rate1.MaxNamePoints = maxnamepoints;H  	    sprintf (buf, "%d-%d Rate", Bnr.tp_rate1_start, Bnr.tp_rate1_end);  	    }    	if (Bnr.Param_Bits.comp_rate2)  	    {   	    if (half)/  		{2  		Tp.comp_rate1.Name = Tp.comp_rate2.Name = &buf;3  		sprintf (buf, "%d-%d/%d-%d", Bnr.tp_rate1_start,u?  		    Bnr.tp_rate1_end, Bnr.tp_rate2_start, Bnr.tp_rate2_end);3  		}
  	    else  		{  		Tp.comp_rate2.Name = &buf;mE  		sprintf (buf, "%d-%d Rate", Bnr.tp_rate2_start, Bnr.tp_rate2_end);e	  		}	    r-  	    Tp.comp_rate2.MaxVal = Bnr.tp_max_rate;e#  	    Tp.comp_rate2.LineActive = 1; $  	    Tp.comp_rate2.HalfLine = half;.  	    Tp.comp_rate2.MaxNameSize = maxnamesize;2  	    Tp.comp_rate2.MaxNamePoints = maxnamepoints;  	    }   	}B  e@      if (Bnr.Param_Bits.comp_rate3 || Bnr.Param_Bits.comp_rate4) *3EB  	{D *3DC  	Tp.PgIO.Name = "Pflt IO";_1  	last_pg_io = (PMS$GL_PREADIO + PMS$GL_PWRITIO);=%  	Tp.PgIO.MaxVal = Bnr.sys_ioratemax;D  	Tp.PgIO.LineActive = 1; $  	Tp.PgIO.MaxNameSize = maxnamesize;(  	Tp.PgIO.MaxNamePoints = maxnamepoints;  i  	if (Mon.ni_io) *3E_ *3I   	static char buf1[20];   	int half = 0;O   	if (Bnr.Param_Bits.comp_rate3)  	    {	  	    half = 1;=!  	    Tp.comp_rate3.Name = &buf1;R#  	    Tp.comp_rate3.LineActive = 1;P-  	    Tp.comp_rate3.MaxVal = Bnr.tp_max_rate;n.  	    Tp.comp_rate3.MaxNameSize = maxnamesize;2  	    Tp.comp_rate3.MaxNamePoints = maxnamepoints;I  	    sprintf (buf1, "%d-%d Rate", Bnr.tp_rate3_start, Bnr.tp_rate3_end);D  	    }R   	if (Bnr.Param_Bits.comp_rate4) *3Et  	    {D *3DR$  	    Tp.RemIO.Name = "Pflt/Rem IO";#  	    Tp.PgIO.Name = "Pflt/Rem IO";E'  	    last_rem_io = REMOTE_IO_COUNT ();T*  	    Tp.RemIO.MaxVal = Bnr.sys_ioratemax;  	    Tp.RemIO.LineActive = 1;  	    Tp.RemIO.HalfLine = 1;)  	    Tp.RemIO.MaxNameSize = maxnamesize; -  	    Tp.RemIO.MaxNamePoints = maxnamepoints;>  	    }T  	}	  t(      Tp.Disk1.MaxNameSize = maxnamesize;,      Tp.Disk1.MaxNamePoints = maxnamepoints;)      Tp.Disk1.Title = &BannerVmsNodeName;a      Tp.Disk1.TitleChanged = 1;A      Tp.RemIO.LastLine = 1;a *3Et *3Ir  	    if (half)O  		{3  		Tp.comp_rate3.Name = Tp.comp_rate4.Name = &buf1;O2  		sprintf (buf1, "%d-%d/%d+", Bnr.tp_rate3_start,-  		    Bnr.tp_rate3_end, Bnr.tp_rate4_start);t  		}
  	    else  		{  		Tp.comp_rate4.Name = &buf1;2  		sprintf (buf1, "%d+ Rate", Bnr.tp_rate4_start);	  		}	    	-  	    Tp.comp_rate4.MaxVal = Bnr.tp_max_rate;S#  	    Tp.comp_rate4.LineActive = 1;t$  	    Tp.comp_rate4.HalfLine = half;.  	    Tp.comp_rate4.MaxNameSize = maxnamesize;2  	    Tp.comp_rate4.MaxNamePoints = maxnamepoints;  	    }D  	}R  R1      Tp.total_com_rate.MaxNameSize = maxnamesize;t5      Tp.total_com_rate.MaxNamePoints = maxnamepoints;  *6D 2      Tp.total_com_rate.Title = &BannerVmsNodeName; *6E  *6Im&      if (BannerVmsDisplayName == NULL)/  	Tp.total_com_rate.Title = &BannerVmsNodeName; 	      elseM1  	Tp.total_com_rate.Title = BannerVmsDisplayName;i *6Er.      sprintf(tval2, "%d#", Bnr.tp_max_rate/4);@      sprintf(tval3, "%d#", Bnr.tp_max_rate - Bnr.tp_max_rate/4);,      sprintf(tval4, "%d#", Bnr.tp_max_rate);$      Tp.total_com_rate.tval1 = "0#";&      Tp.total_com_rate.tval2 = &tval2;&      Tp.total_com_rate.tval3 = &tval3;&      Tp.total_com_rate.tval4 = &tval4;(      Tp.total_com_rate.TitleChanged = 1;       Tp.comp_rate4.LastLine = 1; *3E          tp_init = 1;   w      return;  }    /*w  **++   **  FUNCTIONAL DESCRIPTION:  **n  **      BannerTPRefresh ()   **   **  FORMAL PARAMETERS:_  **eF  **      This is the refresh routine for the Banner TP Window display.  **f  **  IMPLICIT INPUTS:s  **3  **      The TP data block  **   **  IMPLICIT OUTPUTS:  **e
  **      nonet  **   **  COMPLETION CODES:  ** 
  **      nonea  **n  **  SIDE EFFECTS:  **p
  **      nonem  **   **--4  **/  void	BannerTPRefresh()B  {  a      if (!tp_init)  	BannerTPSetup ();a  = *3Da      CollectCpuData (0, 0);t  i *3EiM      BannerPaintGraphics (XtDisplay(Bnr.tp_widget), XtWindow(Bnr.tp_widget), a  	Bnr.tp_width, 
  	&Tp, 1);  t      return;  }    /*   **++p  **  FUNCTIONAL DESCRIPTION:  **m  **      BannerTP ()  **   **  FORMAL PARAMETERS:e  **PB  **	This is the main routine for the Banner TP window display, it H  **  gathers all the statistics, and then calls the display routine, to   **  display the lines needed.  **i  **  IMPLICIT INPUTS:	  **   **      The TP data block  **a  **  IMPLICIT OUTPUTS:  **e
  **      none   **=  **  COMPLETION CODES:  **a
  **      none   **	  **  SIDE EFFECTS:  **s
  **      none=  **r  **--;  **/  void	BannerTP()  { *3D=  int io; *3Es *3Ir  int i;l *3Er  /*a'   * If we have never inited then do it.    */      if (!tp_init)  	BannerTPRefresh ();   /*n1   * Now check if High water marks should be resete   */      tp_hwmrk_count--;      if (tp_hwmrk_count == 0)   	{e  	Display$_Line *Line;     /*}   * reset all high water marks   */#  	tp_hwmrk_count = tp_hwmrk_number;   p
  	Line = &Tp;   	while (1)   	    {   	    Line->Hwmrk = 0;4  	    Line = (int)Line + (int)sizeof(Display$_Line);  	    if (Line->LastLine == 1)	  		break;   	    }_  	}       /*n,   * Now check if we should sample this pass?   */          tp_update_count --;      if (tp_update_count > 0) 	  	return;f  	(      tp_update_count = tp_update_number;     /*  *3Df"   * Now collect all the statistics   */  e  /*	   * Collect the disk statistics  *3E  *3Ia#   * Now store all the changes stats  *3E    */ *3Dt  a"      if (Tp.Disk1.LineActive == 1)  	{r-  	Tp.Disk1.CurVal = BannerDeviceCount (0, 0);	6  	Tp.Disk1.CurVal = Tp.Disk1.MaxVal - Tp.Disk1.CurVal;   	io = BannerDeviceCount (0, 1);>  	Tp.Disk1Rate.CurVal = (io - last_disk1_io)/tp_update_number;  	last_disk1_io = io;r  	}    =  b"      if (Tp.Disk2.LineActive == 1)  	{.-  	Tp.Disk2.CurVal = BannerDeviceCount (1, 0); 6  	Tp.Disk2.CurVal = Tp.Disk2.MaxVal - Tp.Disk2.CurVal;   	io = BannerDeviceCount (1, 1);>  	Tp.Disk2Rate.CurVal = (io - last_disk2_io)/tp_update_number;  	last_disk2_io = io;a  	}    t   "      if (Tp.Disk3.LineActive == 1) *3E  *3I3 *5D ,      if (&DDTM$AR_PERFORMANCE_CELLS == NULL) *5E0 *5I;+      if (DDTM$AR_PERFORMANCE_CELLS == NULL)a *5Ea	  	return;o    *5D)`      Tp.onef_comp_rate.CurVal =  DDTM$AR_PERFORMANCE_CELLS.DDTM_ONE_PHASE - last_ddtm_one_phase;V      Tp.start_rate.CurVal = DDTM$AR_PERFORMANCE_CELLS.DDTM_STARTS - last_ddtm_starts ;X      Tp.prep_rate.CurVal = DDTM$AR_PERFORMANCE_CELLS.DDTM_PREPARES - last_ddtm_prepares;U      Tp.abort_rate.CurVal = DDTM$AR_PERFORMANCE_CELLS.DDTM_ABORTS - last_ddtm_aborts;nO      Tp.end_rate.CurVal = DDTM$AR_PERFORMANCE_CELLS.DDTM_ENDS - last_ddtm_ends;e[      Tp.rem_start_rate.CurVal = DDTM$AR_PERFORMANCE_CELLS.DDTM_BRANCHS - last_ddtm_branchs; S      Tp.rem_end_rate.CurVal = DDTM$AR_PERFORMANCE_CELLS.DDTM_ADDS - last_ddtm_adds;2 *5EM *5Iea      Tp.onef_comp_rate.CurVal =  DDTM$AR_PERFORMANCE_CELLS->DDTM_ONE_PHASE - last_ddtm_one_phase; :      Tp.total_com_rate.CurVal = Tp.onef_comp_rate.CurVal +>  	DDTM$AR_PERFORMANCE_CELLS->DDTM_COMMITS - last_ddtm_commits;C      Tp.start_rate.CurVal = DDTM$AR_PERFORMANCE_CELLS->DDTM_STARTS o  	- last_ddtm_starts ;D      Tp.prep_rate.CurVal = DDTM$AR_PERFORMANCE_CELLS->DDTM_PREPARES   	- last_ddtm_prepares;vC      Tp.abort_rate.CurVal = DDTM$AR_PERFORMANCE_CELLS->DDTM_ABORTS i  	- last_ddtm_aborts;x?      Tp.end_rate.CurVal = DDTM$AR_PERFORMANCE_CELLS->DDTM_ENDS 3  	- last_ddtm_ends;mH      Tp.rem_start_rate.CurVal = DDTM$AR_PERFORMANCE_CELLS->DDTM_BRANCHS   	- last_ddtm_branchs;C      Tp.rem_end_rate.CurVal = DDTM$AR_PERFORMANCE_CELLS->DDTM_ADDS w  	- last_ddtm_adds;. *5Ep         Tp.comp_rate1.CurVal = 0;      Tp.comp_rate2.CurVal = 0;      Tp.comp_rate3.CurVal = 0;      Tp.comp_rate4.CurVal = 0; *5Ir  3 *5E	      for (i=0;  i<=5;  i++)  *3Em  	{t *3Dw-  	Tp.Disk3.CurVal = BannerDeviceCount (2, 0);r6  	Tp.Disk3.CurVal = Tp.Disk3.MaxVal - Tp.Disk3.CurVal;   	io = BannerDeviceCount (2, 1);>  	Tp.Disk3Rate.CurVal = (io - last_disk3_io)/tp_update_number;  	last_disk3_io = io;m  	}    	  /*p*   * Do the CPU active since the last time.   * Null time -> MaxVal    * Used time -> CurValu   *	   */  m=      CollectCpuData (&Tp.FreeCpu.CurVal, &Tp.FreeCpu.MaxVal);e  m?      Tp.FreeCpu.CurVal = Tp.FreeCpu.MaxVal - Tp.FreeCpu.CurVal;e  n  /*    * Now the memory stats   */  f<      Tp.FreeMem.CurVal = Tp.FreeMem.MaxVal - SCH$GL_FREECNT;&      Tp.ModMem.CurVal = SCH$GL_MFYCNT;  /*e:   * Now colect the page fault rate stats, NOTE: Per second   */  = *3EG *2DL       sys$cmkrnl (  	&PageFileAllocation, z  	0);  *2EM *3D.  N      if (Bnr.sysrespgfile)*  	Tp.Pgf.CurVal = pgf_size - pgf_res_size;	      elsee,  	Tp.Pgf.CurVal = pgf_size - pgf_alloc_size;         Tp.Pgf.MaxVal = pgf_size;  n      io = PMS$GL_FAULTS;?      Tp.PgfRate.CurVal = (io - last_pfg_rate)/tp_update_number;       last_pfg_rate = io;  c  e  /*H$   * Now do Page, and Remote IO rates   */   ,      io = (PMS$GL_PREADIO + PMS$GL_PWRITIO);9      Tp.PgIO.CurVal = (io - last_pg_io)/tp_update_number;	      last_pg_io = io;          io = REMOTE_IO_COUNT (); ;      Tp.RemIO.CurVal = (io - last_rem_io)/tp_update_number;a      last_rem_io = io;  .  /*m7   * See if we have anything outstanding in the Ni stats;   */,  	if (OLD_MON_V_NI_SYS_MV != MON_V_NI_SYS_MV0  	||  OLD_MON_V_NI_MNTVERIP != MON_V_NI_MNTVERIP)  	||  OLD_MON_V_NI_BUSY != MON_V_NI_BUSY)   	    {M   	    static char foo[125] = "";  M"  	    if ( MON_V_NI_SYS_MV != 0 ||  		 MON_V_NI_MNTVERIP != 0 ||;  		 MON_V_NI_BUSY != 0)   		 {	5  		 sprintf (foo, "%s - %s", BannerVmsNodeName, "(");T  		 if (MON_V_NI_SYS_MV != 0)y'  		    sprintf (foo, "%s%s", foo, "S");e  		 if (MON_V_NI_MNTVERIP != 0)x'  		    sprintf (foo, "%s%s", foo, "M");   		 if (MON_V_NI_BUSY != 0) '  		    sprintf (foo, "%s%s", foo, "P"); $  		 sprintf (foo, "%s%s", foo, ")");  		   		 Tp.Disk1.Title = &foo;  		 Tp.Disk1.TitleChanged = 1;  		 Tp.Disk1.highltitle = 1;  		 }p
  	    else  		{'  		Tp.Disk1.Title = &BannerVmsNodeName;.  		Tp.Disk1.TitleChanged = 1;   		Tp.Disk1.highltitle = 0;    		}m      ;,  	    OLD_MON_V_NI_SYS_MV = MON_V_NI_SYS_MV;0  	    OLD_MON_V_NI_MNTVERIP = MON_V_NI_MNTVERIP;(  	    OLD_MON_V_NI_BUSY = MON_V_NI_BUSY;  	    }  *3E  *3I.7  	if (Bnr.tp_rate1_start <= i && Bnr.tp_rate1_end > i)	(  	    Tp.comp_rate1.CurVal +=  *5Dt/  		DDTM$AR_PERFORMANCE_CELLS.DDTM_BUCKETS[i] - B *5E_ *5I_0  		DDTM$AR_PERFORMANCE_CELLS->DDTM_BUCKETS[i] -  *5E   		    last_ddtm_buckets[i];  a7  	if (Bnr.tp_rate2_start <= i && Bnr.tp_rate2_end > i)	   	    Tp.comp_rate2.CurVal +=  *5Da/  		DDTM$AR_PERFORMANCE_CELLS.DDTM_BUCKETS[i] - 	 *5Ep *5I_0  		DDTM$AR_PERFORMANCE_CELLS->DDTM_BUCKETS[i] -  *5E   		    last_ddtm_buckets[i];  e7  	if (Bnr.tp_rate3_start <= i && Bnr.tp_rate3_end > i)	   	    Tp.comp_rate3.CurVal +=  *5D./  		DDTM$AR_PERFORMANCE_CELLS.DDTM_BUCKETS[i] - I *5Ee *5If0  		DDTM$AR_PERFORMANCE_CELLS->DDTM_BUCKETS[i] -  *5EI  		    last_ddtm_buckets[i];  i  	if (Bnr.tp_rate4_start <= i)	=  	    Tp.comp_rate4.CurVal +=  *5Ds/  		DDTM$AR_PERFORMANCE_CELLS.DDTM_BUCKETS[i] - i *5Ef *5I.0  		DDTM$AR_PERFORMANCE_CELLS->DDTM_BUCKETS[i] -  *5Ef  		    last_ddtm_buckets[i];  	}a *5D    :      Tp.total_com_rate.CurVal = Tp.onef_comp_rate.CurVal +=  	DDTM$AR_PERFORMANCE_CELLS.DDTM_COMMITS - last_ddtm_commits;l *5Er  	  _ *5Dn>      last_ddtm_starts = DDTM$AR_PERFORMANCE_CELLS.DDTM_STARTS;B      last_ddtm_prepares = DDTM$AR_PERFORMANCE_CELLS.DDTM_PREPARES;D      last_ddtm_one_phase = DDTM$AR_PERFORMANCE_CELLS.DDTM_ONE_PHASE;@      last_ddtm_commits = DDTM$AR_PERFORMANCE_CELLS.DDTM_COMMITS;>      last_ddtm_aborts = DDTM$AR_PERFORMANCE_CELLS.DDTM_ABORTS;:      last_ddtm_ends = DDTM$AR_PERFORMANCE_CELLS.DDTM_ENDS;@      last_ddtm_branchs = DDTM$AR_PERFORMANCE_CELLS.DDTM_BRANCHS;:      last_ddtm_adds = DDTM$AR_PERFORMANCE_CELLS.DDTM_ADDS;"      memcpy(&last_ddtm_buckets[0],=  	&DDTM$AR_PERFORMANCE_CELLS.DDTM_BUCKETS[0],6*sizeof(int) );z *5E  *5I.?      last_ddtm_starts = DDTM$AR_PERFORMANCE_CELLS->DDTM_STARTS;eC      last_ddtm_prepares = DDTM$AR_PERFORMANCE_CELLS->DDTM_PREPARES;iE      last_ddtm_one_phase = DDTM$AR_PERFORMANCE_CELLS->DDTM_ONE_PHASE;pA      last_ddtm_commits = DDTM$AR_PERFORMANCE_CELLS->DDTM_COMMITS;a?      last_ddtm_aborts = DDTM$AR_PERFORMANCE_CELLS->DDTM_ABORTS; ;      last_ddtm_ends = DDTM$AR_PERFORMANCE_CELLS->DDTM_ENDS;(A      last_ddtm_branchs = DDTM$AR_PERFORMANCE_CELLS->DDTM_BRANCHS;a;      last_ddtm_adds = DDTM$AR_PERFORMANCE_CELLS->DDTM_ADDS;eG      last_ddtm_buckets[0] = DDTM$AR_PERFORMANCE_CELLS->DDTM_BUCKETS[0];SG      last_ddtm_buckets[1] = DDTM$AR_PERFORMANCE_CELLS->DDTM_BUCKETS[1];	G      last_ddtm_buckets[2] = DDTM$AR_PERFORMANCE_CELLS->DDTM_BUCKETS[2]; G      last_ddtm_buckets[3] = DDTM$AR_PERFORMANCE_CELLS->DDTM_BUCKETS[3];oG      last_ddtm_buckets[4] = DDTM$AR_PERFORMANCE_CELLS->DDTM_BUCKETS[4];NG      last_ddtm_buckets[5] = DDTM$AR_PERFORMANCE_CELLS->DDTM_BUCKETS[5];M *5Ep  t *3Em  /*.#   * Now get all the display printed    */  n *3Ia(      Tp.total_com_rate.TitleChanged = 0;  t *3E M      BannerPaintGraphics (XtDisplay(Bnr.tp_widget), XtWindow(Bnr.tp_widget), _  	Bnr.tp_width, 
  	&Tp, 0);  e      return;  } *3D.    /*_  **++a  **  FUNCTIONAL DESCRIPTION:  **e$  **      CollectCpuData (Null, Used)  **aM  **  This routine collects CPU data, returns the Null time, and the Used timeL  **  of all CPU's   **t  **  FORMAL PARAMETERS:t  **   **      See Above  **   **  IMPLICIT INPUTS::  **n
  **      nonee  **f  **  IMPLICIT OUTPUTS:  **A
  **      nonee  **   **  COMPLETION CODES:  **i
  **      nonee  **W  **  SIDE EFFECTS:  ** 
  **      noneS  ***  **--   **/1  static void	CollectCpuData(int *Null, int *Used)e  {
  int i, j;  *  /**,   * calculate time in each mode for each CPU   */      total_time = 0;      total_null = 0;  *	      j=0; .      for (i=1;  i<=SMP$GL_ACTIVE_CPUS;  i=i*2)  	{ #  	if ((i & SMP$GL_ACTIVE_CPUS) > 0)C  	    {DA  	    total_time = total_time + SMP$GL_CPU_DATA[j]->cpu$l_kernel;wD  	    total_time = total_time + SMP$GL_CPU_DATA[j]->cpu$l_executive;?  	    total_time = total_time + SMP$GL_CPU_DATA[j]->cpu$l_user; @  	    total_time = total_time + SMP$GL_CPU_DATA[j]->cpu$l_super;H  	    total_time = total_time + SMP$GL_CPU_DATA[j]->cpu$l_compatibility;C  	    total_time = total_time + SMP$GL_CPU_DATA[j]->cpu$l_spinlock;*B  	    total_time = total_time + SMP$GL_CPU_DATA[j]->cpu$l_nullcpu;B  	    total_null = total_null + SMP$GL_CPU_DATA[j]->cpu$l_nullcpu;  /*nC   * Interrupt time should include NULL time, so subtract NULL time D-   * from Interrupt time, if that is the case.    */-  		if (SMP$GL_CPU_DATA[j]->cpu$l_interrupt >=r)  		    SMP$GL_CPU_DATA[j]->cpu$l_nullcpu)r!  		    total_time = total_time +  )  			SMP$GL_CPU_DATA[j]->cpu$l_interrupt - &  			SMP$GL_CPU_DATA[j]->cpu$l_nullcpu;  		else !  		    total_time = total_time + i(  			SMP$GL_CPU_DATA[j]->cpu$l_interrupt;  	    }n  	j++;  	}      e  /* &   * return the values if we want them.   */      if (Null != 0)	!  	*Null = total_null - last_null;       if (Used != 0) "  	*Used = total_time - last_total;  f      last_null = total_null;      last_total = total_time;          return;  } *3E 