
/*
**  jazz - a midi sequencer for Linux
**
**  Copyright (C) 1994-1996 Andreas Voss (andreas@avix.rhein-neckar.de)
**
**  Copyright (C) 1995-1996 Per Sigmond (Per.Sigmond@hia.no)
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef dialogs_h
#define dialogs_h

#ifndef eventwin_h
#include "eventwin.h"
#endif

// ***************************************************************************
// Menu-Funktionen
// ***************************************************************************

class tQuantizeDlg : public wxForm
{
  public:

    static Bool NoteStart;	// 1
    static Bool NoteLength;	// 0
    static long QntStep;	// 1/16

    tFilter *Filter;
    tSong   *Song;
    tEventWin *EventWin;

    long Quantize(long);

    tQuantizeDlg(tEventWin *w, tFilter *f);
    void EditForm(wxPanel *panel);
    tNamedChoice Steps;
    void OnOk();
    void OnHelp();
};

class tCleanupDlg : public wxForm
{
  public:

    static long lowLimit;	// 1/32

    tFilter *Filter;
    tSong   *Song;
    tEventWin *EventWin;

    tCleanupDlg(tEventWin *w, tFilter *f);
    void EditForm(wxPanel *panel);
    tNamedChoice Steps;
    void OnOk();
    void OnHelp();
};

class tSearchReplaceDlg : public wxForm
{
  public:

    static long frCtrl;
    static long toCtrl;
    tNamedChoice frList;
    tNamedChoice toList;

    tFilter *Filter;
    tSong   *Song;
    tEventWin *EventWin;

    tSearchReplaceDlg(tEventWin *w, tFilter *f);
    void EditForm(wxPanel *panel);
    void OnOk();
    void OnHelp();
};

class tShiftDlg : public wxForm
{
  public:
    static int  Steps;	// 0
    long Unit;

    tFilter   *Filter;
    tSong     *Song;
    tEventWin *EventWin;

    tShiftDlg(tEventWin *w, tFilter *f, long Unit);
    void EditForm(wxPanel *panel);
    void OnOk();
    void OnHelp();
};


// Transpose

class tTransposeDlg : public wxForm
{
  public:

    static int  Notes;	// 0
    static Bool FitIntoScale;
    static long Scale;

    tEventWin *EventWin;
    tFilter *Filter;
    tSong   *Song;

    tNamedChoice ScaleDlg;
    tTransposeDlg(tEventWin *w, tFilter *f);
    void EditForm(wxPanel *panel);
    void OnOk();
    void OnHelp();
};


// SetChannel

class tSetChannelDlg : public wxForm
{
  public:

    static int  NewChannel;	// 0

    tFilter *Filter;
    tSong   *Song;

    tSetChannelDlg(tFilter *f);
    void EditForm(wxPanel *panel);
    void OnOk();
    void OnHelp();
};



// Velocity

class tVelocityDlg : public wxForm
{
  public:

    static int FromValue, ToValue, Mode;
    static char *mode_str;

    tFilter *Filter;
    tSong   *Song;

    tVelocityDlg(tFilter *f);
    void EditForm(wxPanel *panel);
    void OnOk();
    void OnHelp();
};


// Length

class tLengthDlg : public wxForm
{
  public:

    static int FromValue, ToValue, Mode;
    static char *mode_str;

    tFilter   *Filter;
    tSong     *Song;
    tEventWin *EventWin;

    tLengthDlg(tEventWin *win, tFilter *f);
    void EditForm(wxPanel *panel);
    void OnOk();
    void OnHelp();
};





class tDeleteDlg : public wxForm
{
  tFilter *Filter;
  tEventWin *EventWin;

 public:
  static Bool LeaveSpace;	// 1

  tDeleteDlg(tEventWin *w, tFilter *f);
  void EditForm(wxPanel *panel);
  void OnOk();
  void OnHelp();
};


// ***************************************************************************
// Einzel-Events
// **************************************************************************

class tEvent;
class tEventWin;
class tEventArray;

void EventDialog(tEvent *, tEventWin *, tTrack *, long Clock, int Channel, int Pitch);

#endif

