#ifndef hbanalyz_h
#define hbanalyz_h

class tFilter;
class tTrack;
class HBContext;
class tKeyOn;
class HBChord;

class HBAnalyzer
{
  public:
    HBAnalyzer(HBContext **seq, int n_seq);
    ~HBAnalyzer();
    int Analyze(tFilter *f, int quarters_per_chord = 4);
    int Transpose(tFilter *f, int quarters_per_chord = 4);

    void Init(tFilter *f, int steps_per_bar);
    void Exit();
    int Steps() const { return steps; }
    long Step2Clock(int step);
    HBContext * GetContext(int step) const { return seq[step % max_seq]; }

  private:
    HBContext **seq;
    int      max_seq;

    long     start_clock, stop_clock;
    int      quarters_per_chord;
    int      steps;
    tFilter  *filter;
    tTrack   *track;

    void IterateEvents(void (HBAnalyzer::*Action)(tKeyOn *on, tTrack *t));
    void CountEvent(tKeyOn *on, tTrack *t);
    void TransposeEvent(tKeyOn *on, tTrack *t);
    void CreateChords();
    int NumCount(int i);
    int MaxCount(int i, const HBChord &done);
    void GenerateMapping();

    long **count;
    long **delta;
};

#endif

