
/*
**  jazz - a midi sequencer for Linux
**
**  Copyright (C) 1994-1996 Andreas Voss (andreas@avix.rhein-neckar.de)
**
**  Copyright (C) 1995-1996 Per Sigmond (Per.Sigmond@hia.no)
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef pianowin_h
#define pianowin_h

#ifndef eventwin_h
#include "eventwin.h"
#endif

#ifndef track_h
#include "track.h"
#endif

#ifndef song_h
#include "song.h"
#endif

#define MaxSnaps 500

class tCtrlEditBase;

class tPianoWin : public tEventWin
{
  friend class tGuitarWin;
  public:
    long xPiano, wPiano;

    int  nSnaps;
    long xSnaps[MaxSnaps];

    int  FromLines[MaxTracks];

    int  IsVisible(tEvent *e);
    int  IsVisible(tTrack *t);
    void VisibleDialog();
    Bool VisibleKeyOn;
    Bool VisiblePitch;
    Bool VisibleController;
    Bool VisibleProgram;
    Bool VisibleTempo;
    Bool VisibleDrumNames;
    Bool VisibleAllTracks;
    Bool VisibleHBChord;

    long MouseLine;

    wxFont *DrumFont;

    long SnapClocks();
    long SnapDenomiator;	// 16 fuer 16-tel 
    long SnapClock(long Clock, int up = 0);

    tPianoWin(wxFrame *frame, char *title, tSong *song, int x, int y, int width, int height);
    virtual ~tPianoWin();
    void CreateMenu();
    void Setup();
    void NewPosition(int TrackNr, long Clock);
    void ShowPitch(int pitch);
    int  Channel();	// Channel of actual track 0..15

    void OnMenuCommand(int Id);
    void OnPaint(long x, long y);
    void SnapSelStart(wxMouseEvent &e);
    void SnapSelStop(wxMouseEvent &e);
    void SnapDlg();

    int TrackNr;	// aktueller Track
    tTrack *Track;

    tEventArray PasteBuffer;
    void DrawEvents(tTrack *t, int Stat, wxBrush *Brush);
    void DrawEvent(tEvent *, wxBrush *Brush, int xor);
    void DrawPianoRoll();
    void GetVirtSize(long *w, long *h);

    int OnMouseEvent(wxMouseEvent &e);
    int OnKeyEvent(wxKeyEvent &e);
    void MouseEvents(wxMouseEvent &e);
    void MousePiano(wxMouseEvent &e);
    void MouseCutPaste(wxMouseEvent &e, Bool cut);

    // Utils
    int y2Pitch(long y);
    long Pitch2y(int Pitch);
    tEvent *FindEvent(tTrack *t, long Clock, int Pitch);
    void Copy(tTrack *t, tEvent *e, int Kill);
    void Paste(tTrack *t, long Clock, int Pitch);

    virtual void OnSize(int w, int h);
    tGuitarWin    *GetGuitarWin()	{ return GuitarWin; }
    
    void SetSnapDenom(long value);
    void SetVisibleAllTracks(Bool value);

  private:
    tCtrlEditBase *CtrlEdit;
    tGuitarWin    *GuitarWin;

    tMouseMapper MousePlay;
    tMouseMapper MouseEvnt;
};

#endif

