/*
**  jazz - a midi sequencer for Linux
**
**  Copyright (C) 1995-1996 Andreas Voss (andreas@avix.rhein-neckar.de)
**
**  Copyright (C) 1995-1996 Per Sigmond (Per.Sigmond@hia.no)
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef random_h
#define random_h

#ifndef wx_wxh
#include "wx.h"
#endif

#ifndef _FSTREAM_H
#include <fstream.h>
#endif

#ifndef dynarray_h
#include "dynarray.h"
#endif

#ifdef wx_msw

class tRandomGenerator
{
  public:
    double asDouble();
};
extern tRandomGenerator rnd;

#else

#ifndef VMS
#include <ACG.h>	// random generator from libg++
extern ACG rnd;
#else
class tRandomGenerator
{
  public:
    double asDouble();
};
extern tRandomGenerator rnd;

#endif /* VMS */
#endif


#undef min
#undef max


// array of probabilities

class tRndArray 
{
  friend class tArrayEdit;
  protected:
    tIntArray array;
    int n;	// number of elements in array
    int nul, min, max;

  public:
    int Null()				{ return nul; }
    void SetNull(int n)			{ nul = n; }
    tRndArray(int n, int min, int max);
    tRndArray & operator = (const tRndArray &);
    tRndArray(tRndArray const &);

    virtual ~tRndArray();
    int &operator[] (int i) 		{ return array[i]; }
    int  operator[] (int i) const 	{ return array[i]; }
    int Size() const 			{ return n; }
    int Min() const			{ return min; }
    int Max() const			{ return max; }
    void Resize(int nn) 		{ n = nn; }

    friend ostream & operator << (ostream &, tRndArray const &);
    friend istream & operator >> (istream &, tRndArray &);

    int Random();	// returns index 0..n-1 (arrayvalues -> empiric distribution)
    int Random(int i);  // return 0/1
    int Interval(int seed);
};


#define ARED_GAP	1
#define ARED_TICKS 	2
#define ARED_MINMAX	4

class tArrayEdit : public wxCanvas
{
protected:
  // paint position
  long x, y, w, h, ynul;
  void DrawBar(int i, int black);

  int dragging;		// Dragging-Event valid
  int index;		// ctrl down: drag this one

  tRndArray &array;
  int &n, &min, &max, &nul;	// shorthand for array.n, array.min, ...
  char *label;

  int    step;		// draw a tickmark every step values
  double fac;		// multiply tickmark with fac

  virtual void DrawTicks();
  virtual void DrawMinMax();
  virtual void DrawLabel();
  int  Index(wxMouseEvent &e);

  int  enabled;
  int  style_bits;
public:
  tArrayEdit(wxFrame *parent, tRndArray &array, long xx, long yy, long ww, long hh, int style_bits = (ARED_GAP | ARED_TICKS));
  virtual ~tArrayEdit();

  virtual void OnPaint();
  virtual void OnSize(int ww, int hh);
  virtual void OnEvent(wxMouseEvent &e);
  virtual int Dragging(wxMouseEvent &);
  virtual int ButtonDown(wxMouseEvent &);
  virtual int ButtonUp(wxMouseEvent &);

  virtual void SetLabel(char const *llabel);
  virtual void SetTicks(int s, double f);
  void Enable(int enable = 1);
};



class tRhyArrayEdit : public tArrayEdit
{
    int steps_per_count;
    int count_per_bar;
    int n_bars;
  protected:
    virtual void DrawTicks();
  public:
    tRhyArrayEdit(wxFrame *parent, tRndArray &array, long xx, long yy, long ww, long hh);
    void SetMeter(int steps_per_count, int count_per_bar, int n_bars);
};


#endif
