/*
**  jazz - a midi sequencer for Linux
**
**  Copyright (C) 1995-1996 Andreas Voss (andreas@avix.rhein-neckar.de)
**
**  Copyright (C) 1995-1996 Per Sigmond (Per.Sigmond@hia.no)
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef rhythm_h
#define rhythm_h

#ifndef rhythm_h
#include "rhythm.h"
#endif

#ifndef random_h
#include "random.h"
#endif

#ifndef wx_wxh
#include "wx.h"
#endif

#include <iostream.h>

class tSong;
class tTrack;
class tEventWin;


class tRhythm 
{
    friend class tRhythmWin;
    friend ostream & operator << (ostream &os, tRhythm const &a);
    friend istream & operator >> (istream &is, tRhythm &a);

    char * label;

  protected:

    tRndArray rhythm;
    tRndArray length;
    tRndArray veloc;

    int steps_per_count;
    int count_per_bar;
    int n_bars;
    int key;
    int parm;

  public:
    tRhythm(int key);
    tRhythm(const tRhythm &o);
    tRhythm & operator= (const tRhythm &o);
    virtual ~tRhythm(); 

    char const * GetLabel() { return label; }
    void SetLabel(char const *);

    void Generate(tTrack *track, long fr_clock, long to_clock, long ticks_per_bar);
};


class tRhythmWin : public wxFrame
{
    friend ostream & operator << (ostream &os, tRhythmWin const &a);
    friend istream & operator >> (istream &is, tRhythmWin &a);

    wxPanel    *panel;
    wxText     *label;
    wxSlider   *steps_per_count;
    wxSlider   *count_per_bar;
    wxSlider   *n_bars;
    wxListBox  *instrument_list;

    tArrayEdit    *length_edit;
    tArrayEdit    *veloc_edit;
    tRhyArrayEdit *rhythm_edit;

    enum       { MAX_INSTRUMENTS = 20 };
    tRhythm    *instruments[MAX_INSTRUMENTS];
    int        n_instruments;
    int        act_instrument;	// -1 if none

    // this one is edited and copied from/to instruments[i]
    tRhythm    edit;

    // ignore Updates while creating the window (motif)
    Bool in_create;

    // callbacks
    static void SliderChange(wxItem& item, wxCommandEvent& event);
    static void SelectInstr(wxListBox& list, wxCommandEvent& event);
    static void Add(wxButton &but, wxCommandEvent& event);
    static void Del(wxButton &but, wxCommandEvent& event);
    static void Generate(wxButton &but, wxCommandEvent& event);
    static void Help();

    void Instrument2Win(int i = -1);	// instrument[act_instrument] -> win
    void Win2Instrument(int i = -1);	// win -> instrument[act_instrument]
    void AddInstrumentDlg();
    void AddInstrument(tRhythm *r);
    void DelInstrument();

    tEventWin *event_win;
    tSong     *song;

  public:

    virtual void OnMenuCommand(int id);
    tRhythmWin(tEventWin *parent, tSong *song);
    virtual ~tRhythmWin();
    void OnPaint();
    void GenRhythm();
};


extern tRhythmWin *rhythm_win;

#endif

