/*
**  jazz - a midi sequencer for Linux
**
**  Copyright (C) 1995 Andreas Voss (andreas@avix.rhein-neckar.de)
**
**  Portions Copyright (C) 1995 Per Sigmond (Per.Sigmond@hia.no)
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include <stdio.h>
#include <fcntl.h>
#include <sys/soundcard.h>

int main()
{

  struct synth_info si;
  int i, nrsynths;

  int seqfd = open("/dev/sequencer2", O_RDWR | O_NDELAY);
  if (seqfd < 0)
  {
    perror("/dev/sequencer2");
    return 1;
  }  

  if (ioctl(seqfd, SNDCTL_SEQ_NRSYNTHS, &nrsynths) == -1) {
    fprintf(stderr, "there is no soundcard\n");
    return 1;
  }
  for (i = 0; i < nrsynths; i++) {
      puts("------------------------------");
      si.device = i;
      if (ioctl(seqfd, SNDCTL_SYNTH_INFO, &si) == -1) {
	  fprintf(stderr, "cannot get info on soundcard\n");
	  perror("/dev/sequencer2");
	  return 1;
      }
      printf("device : %d\n", i);
      printf("name   : %s\n", si.name);
      switch (si.synth_type) {

	case SYNTH_TYPE_FM: 
	  puts("type   : SYNTH_TYPE_FM");
	  break;
	case SYNTH_TYPE_SAMPLE:
	  puts("type   : SYNTH_TYPE_SAMPLE");
	  break;

	case SYNTH_TYPE_MIDI:
	  puts("type   : SYNTH_TYPE_MIDI");
	  break;
	default:
	  puts("type   : unknown");
	  break;
      }

      switch(si.synth_subtype) {

	case FM_TYPE_ADLIB:
	  puts("subtype: FM_TYPE_ADLIB");
	  break;
	case FM_TYPE_OPL3:
	  puts("subtype: FM_TYPE_OPL3");
	  break;
	case SAMPLE_TYPE_GUS:
	  puts("subtype: SAMPLE_TYPE_GUS");
	  break;
	default:
	  puts("subtype: unknown");
	  break;
      }
  }
  puts("------------------------------");
  return 0;
}

