
/*
**  jazz - a midi sequencer for Linux
**
**  Copyright (C) 1994-1996 Andreas Voss (andreas@avix.rhein-neckar.de)
**
**  Copyright (C) 1995-1996 Per Sigmond (Per.Sigmond@hia.no)
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef util_h
#define util_h

#ifndef wx_wxh
#include "wx.h"
#endif

#ifndef wxb_formh
#include "wx_form.h"
#endif

inline int iabs(int a)
{
  return a < 0 ? -a : a;
}

// ************************************************************************
// tNamedChoice
// ************************************************************************


class tNamedValue 
{
public:
  char *Name;
  int  Value;
};


class tNamedChoice : public wxObject
{
    char *Selection;
    char *Title;
    tNamedValue *Values;	// Values[last].Name == 0
    long *Result;

  public:

    tNamedChoice(char *title, tNamedValue *values, long *result);
    ~tNamedChoice();
    wxFormItem *mkFormItem(int w = 100, int h = 100);
    void GetValue();
    void SetValue();
};


// **************************************************************************
// tRect
// **************************************************************************



class tRect
{
public:
  float x, y, w, h;
  tRect(float x = 0, float y = 0, float w = 0, float h = 0);

  void SetNormal();		// width, height > 0
  void SetUnion(tRect &);
  int  IsInside(float x, float y);
};


// **************************************************************************
// tClockDlg
// **************************************************************************

class tSong;

class tClockDlg
{
  char *String;
  char *Title;
  tSong *Song;

  public:
    tClockDlg(tSong *s, char *title, long clk);
    ~tClockDlg();
    wxFormItem *mkFormItem();
    long GetClock();
};



class tKeyDlg
{
  char *String;
  char *Title;

  public:
    tKeyDlg(char *title, int Key);
    ~tKeyDlg();
    wxFormItem *mkFormItem();
    int GetKey();
};


void Key2Str(int key, char *str);
int Str2Key(char *str);

int GetArgOpt( char *opt );


int SelectControllerDlg();

#endif

