/*
 * This module handles SSL handshake protocol.
 */
#include "pthread_1c_np.h"
#include <stdio.h>
#include <stdlib.h>
#include <ssdef.h>

struct v2_client_hello {
    char type;		/* msg_client-hello = 1 */
    unsigned char version[2];    /* version 2, network data order */
    unsigned char cs_length[2];	/* cipher specs length, network data order */
    unsigned char session_id_length[2]; /* Network data order */
    unsigned char challenge_length[2];
    char var_data[20];		/* cipher-specs, session-id, challenge */
    
};
struct v2_server_hello {
    char type;	       		/* msg_server_hello = 4 */
    char session_id_hit;	/* Status of session ID */
    char certificate_type;
    unsigned char server_version[2];
    unsigned char cert_length[2];
    unsigned char cs_length[2];
    unsigned char cid_length[2]; /* connection ID length */
    char var_data[80];		/* certificate, cipher-specs, connection ID */
};

#include "ssl_server_v3.h"

#define REC_INT(a) ((a[0]<<8)|a[1])

#define MSG_V2_ERROR 0
#define MSG_V2_CLIENT_HELLO 1
#define MSG_V2_CLIENT_MASTER_KEY 2
#define MSG_V2_CLIENT_FINISHED 3
#define MSG_V2_SERVER_HELLO 4
#define MSG_V2_SERVER_VERIFY 5
#define MSG_V2_SERVER_FINISHED 6
#define MSG_V2_REQUEST_CERTIFICATE 7
#define MSG_V2_CLIENT_CERTIFICATE 8

#define SSL_CT_X509_CERTIFICATE 1
/*
 * Begin SSL negotiation, we assume record has been read into in_rec.
 */
int tssl_handshake ( ssl_context ctx )
{
    char sts_line[100];
    int cs_length, sid_length, challenge_length;
    struct ssl_rec *rec;
    struct v2_client_hello *hello_rec;
    strcut v2_server_hello server_hello;

    rec = &ctx->in_rec;
printf("Handshake ssl version: %d\n", ctx->ssl_version );
    if ( (ctx->cnx_state == 0) && (ctx->ssl_version == 2) ) {
	/*
	 * in_rec must be hello message.
	 */
	hello_rec = (struct v2_client_hello *) rec->data;
	if ( hello_rec->type != MSG_V2_CLIENT_HELLO ) {
	    (*ctx->error) ( SS$_PROTOCOL, "Unexpected message type" );
	    return SS$_PROTOCOL;
	}
	cs_length = REC_INT(hello_rec->cs_length);
	sid_length = REC_INT(hello_rec->session_id_length);
	challenge_length = REC_INT(hello_rec->challenge_length);

sprintf(sts_line, "v2 hdr lengths: cipher: %d session: %d challenge: %d\n",
	cs_length, sid_length, challenge_length );
(*ctx->error) ( 1, sts_line );
	/*
	 * Answer with server hello.
	 */
	server_hello.type = MSG_V2_SERVER_HELLO;
	server_hello.session_id_hit = 0;
	server_hello.certificate_type = SSL_CT_X509_CERTIFICATE;
	server_hello.server_version[0] = 0;
	server_hello.server_version[1] = 2;
	server_hello.cert_length[0] = 0;
	server_hello.cert_length[1] = 40;
	server_hello.cs_length[0] = 0;
	server_hello.cs_length[1] = 3
	server_hello.cid_length[0] = 0;
	server_hello.cid_length[1] = 16;
    }
    return 1;
}
