/*
 * routines for handling text subrecords and font information.
 */
#include <stdlib.h>
#include <stdio.h>
#include <ssdef.h>
#include <string.h>

#include "bookreader_recdef.h"
#include "bookfile_io.h"
#include "bookfile_text.h"

#ifdef TTTEMP
struct bktxt_font_def {
    int fontno;		/* font number */
    char *name;		/* asciz name of font */
};
typedef struct bktxt_font_def *bktxt_fntptr;
#endif

int bkt_read_font_map ( void* bkfctx, 		/* bki_open file context */
	bktxt_fntptr *fontdef, 		/* return array of structs  */
	int *count )				/* size of returned array */
{
    int status, page_length, length, i, j;
    bkrdr_recptr root, font, sub;
    bktxt_fntptr flist;
    char *pstr;
    /*
     * Read root record to get pointers and read the font page.
     */
    status = bkf_read_page ( bkfctx, 0, &page_length, &root, &length );
    if ( (status&1) == 0 ) return status;
    *count = root->first.fontcount;
    status = bkf_read_page ( bkfctx, root->first.font_page, &page_length,
	&font, &length );
    if ( (status&1) == 0 ) return status;
    if ( font->gen.type != BKREC_FONT ) return SS$_BUGCHECK;
    /*
     * Allocate array of structures.
     */
    flist = (bktxt_fntptr) malloc ( *count * sizeof(struct bktxt_font_def) );
    if ( !flist ) return SS$_INSFMEM;
    flist[0].fontno = 0; flist[0].name = "";
    for ( i = 1; i < *count; i++ ) flist[i] = flist[0];
    j = 0;
    for ( i=sizeof(font->font); i < font->gen.length; i += sub->gen.length ) {
	sub = (bkrdr_recptr) &font->reloff[i];

	if ( sub->gen.type == BKSBREC_FONT ) {
	    /*
	     * Copy data from fontdef to our array, make allocated
	     * buffer 2 the size and copy twice for parsing.
	     */
	    flist[j].fontno = sub->fontdef.fontno;
	    length = sub->gen.length - sizeof(sub->fontdef) +
		sizeof(sub->fontdef.name) + 1;
	    flist[j].name = malloc ( length * 2 );
	    strncpy ( flist[j].name, sub->fontdef.name, length );
	    flist[j].name[length-1] = '\0';
	    pstr = &flist[j].name[length];
	    strcpy ( pstr, flist[j].name );
	    /*
	     * Parse the separate fields from the string string.
	     */
	    for ( ; *pstr; pstr++ ) if (*pstr == '-') { *pstr++ = '\0'; break; }
	    flist[j].foundry = pstr;

	    for ( ; *pstr; pstr++ ) if (*pstr == '-') { *pstr++ = '\0'; break; }
	    flist[j].typeface = pstr;

	    for ( ; *pstr; pstr++ ) if (*pstr == '-') { *pstr++ = '\0'; break; }
	    flist[j].weight = pstr;

	    for ( ; *pstr; pstr++ ) if (*pstr == '-') { *pstr++ = '\0'; break; }
	    flist[j].style = pstr;

	    for ( ; *pstr; pstr++ ) if (*pstr == '-') { *pstr++ = '\0'; break; }
	    flist[j].width = pstr;

	    /* if ( *pstr == '-' ) pstr++; */
	    for ( ; *pstr; pstr++ ) if (*pstr == '-') { *pstr++ = '\0'; break; }
	    flist[j].id = pstr;

	    for ( ; *pstr; pstr++ ) if (*pstr == '-') { *pstr++ = '\0'; break; }
	    flist[j].pixel_size = (*pstr) == '*' ? -1 : atoi(pstr);

	    for ( ; *pstr; pstr++ ) if (*pstr == '-') { *pstr++ = '\0'; break; }
	    flist[j].point_size = (*pstr) == '*' ? -1 : atoi(pstr);

	    for ( ; *pstr; pstr++ ) if (*pstr == '-') { *pstr++ = '\0'; break; }
	    flist[j].res_x = (*pstr) == '*' ? -1 : atoi(pstr);

	    for ( ; *pstr; pstr++ ) if (*pstr == '-') { *pstr++ = '\0'; break; }
	    flist[j].res_y = (*pstr) == '*' ? -1 : atoi(pstr);

	    for ( ; *pstr; pstr++ ) if (*pstr == '-') { *pstr++ = '\0'; break; }
	    flist[j].spacing = pstr;

	    for ( ; *pstr; pstr++ ) if (*pstr == '-') { *pstr++ = '\0'; break; }
	    flist[j].average_width = (*pstr) == '*' ? -1 : atoi(pstr);

	    for ( ; *pstr; pstr++ ) if (*pstr == '-') { *pstr++ = '\0'; break; }
	    flist[j].encoding = pstr;

	    j++;
	    if ( j >= *count ) break;
	}
	if ( sub->gen.length <= 0 ) return SS$_BUGCHECK;
    }
    *fontdef = flist;
    return status;
}

/*
 *  Scan record by setting offset to 0 and calling repeatedly
 *  until offset greater or equal to reclen (length of record).
 */
int bkt_text3_scan ( int reclen, char *rec, 
	int *offset, char substring[256], int *stringlength, int *glue )
{
    int size, pos, i;

    pos = *offset;
    if ( pos >= reclen ) return 0;
    size = (unsigned) rec[pos++];
    *stringlength = size;
    for ( i = 0; i < size; i++ ) substring[i] = rec[pos++];
    substring[i] = '\0';
    *glue = (pos < reclen) ? (unsigned) rec[pos++] : 0;
    *offset = pos;
    return 1;
}
