 /*+  * Program:	VMS TCP/IP routines for Netlib.   *>  * Author:	Yehavi Bourvine, The Hebrew University of Jerusalem#  *		Internet: Yehavi@VMS.huji.ac.il   *  * Date:	2 August 1994   * Last Edited:	7 September 1994  *1  * Copyright 1994 by the University of Washington   *I  *  Permission to use, copy, modify, and distribute this software and its L  * documentation for any purpose and without fee is hereby granted, providedJ  * that the above copyright notice appears in all copies and that both theI  * above copyright notice and this permission notice appear in supporting J  * documentation, and that the name of the University of Washington not beN  * used in advertising or publicity pertaining to distribution of the softwareN  * without specific, written prior permission.	This software is made available  * "as is", and M  * THE UNIVERSITY OF WASHINGTON DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED, I  * WITH REGARD TO THIS SOFTWARE, INCLUDING WITHOUT LIMITATION ALL IMPLIED M  * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, AND IN I  * NO EVENT SHALL THE UNIVERSITY OF WASHINGTON BE LIABLE FOR ANY SPECIAL, M  * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM G  * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, TORT N  * (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, ARISING OUT OF OR IN CONNECTION0  * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.  *  */      #include <descrip.h> int netlib_server_setup()      /* TCP/IP manipulate parameters   * Accepts: function code   *	    function-dependent value +  * Returns: function-dependent return value   */   0 void *tcp_parameters (long function,void *value) { 
   return NIL;  }      /* TCP/IP server setup  * Accepts: nothing S  * Returns: TCP/IP stream structure for the stdio channels created by master server   */  TCPSTREAM *tcp_server_init() {    TCPSTREAM *stream = NIL;(   char hostname[MAILTMPLEN] = "UNKNOWN";   unsigned int sock = 0;  !   				/* hostname connected to */ M   struct dsc$descriptor HostDesc = { 0, DSC$K_DTYPE_T, DSC$K_CLASS_S, NULL };     , 				/* Find out remote hostname on socket */2 				/* .... Left for the moment - don't need it */  : 				/* Initialize the channels created by master server */,   status = netlib_server_setup(&sock, 0, 0);   if (!(status & 0x1))     { @       sprintf (tmp,"Unable to set up server, status=%d",status);       mm_log (tmp,ERROR);        return NIL;      }   5   stream = (TCPSTREAM *) fs_get (sizeof (TCPSTREAM)); ! 				/* copy official host name */ #   stream->host = cpystr (hostname);  				/* copy local host name */.   stream->localhost = cpystr (mylocalhost ()); 				/* init sockets */'   stream->tcpsi = stream->tcpso = sock; -   stream->ictr = 0;		/* init input counter */ &   return stream;		/* return success */ }      /* TCP/IP open  * Accepts: host name   *	    contact service name   *	    contact port number-  * Returns: TCP/IP stream if success else NIL   */   8 TCPSTREAM *tcp_open (char *host,char *service,long port) {    TCPSTREAM *stream = NIL;   unsigned long sock; 
   int status; 
   char *s;   char hostname[MAILTMPLEN];   char tmp[MAILTMPLEN];   				/* hostname to connect to */M   struct dsc$descriptor HostDesc = { 0, DSC$K_DTYPE_T, DSC$K_CLASS_S, NULL };  				/* assign a local socket */ /   if (!((status = net_assign (&sock)) & 0x1)) { >     sprintf (tmp,"Unable to assign to net, status=%d",status);     mm_log (tmp,ERROR);      return NIL;    } /   if (!((status = net_bind (&sock,1)) & 0x1)) { D     sprintf (tmp,"Unable to create local socket, status=%d",status);     mm_log (tmp,ERROR);      return NIL;    }  				/* open connection */ (   HostDesc.dsc$w_length = strlen (host);    HostDesc.dsc$a_pointer = host;A   if (!((status = tcp_connect (&sock, &HostDesc, port)) & 0x1)) { M     sprintf (tmp,"Can't connect to %.80s,%d: %s",host,port,strerror (errno));      mm_log (tmp,ERROR);      return NIL;    }  				/* create TCP/IP stream */5   stream = (TCPSTREAM *) fs_get (sizeof (TCPSTREAM)); ! 				/* copy official host name */ #   stream->host = cpystr (hostname);  				/* copy local host name */.   stream->localhost = cpystr (mylocalhost ()); 				/* init sockets */'   stream->tcpsi = stream->tcpso = sock; -   stream->ictr = 0;		/* init input counter */ &   return stream;		/* return success */ }    /* TCP/IP authenticated open  * Accepts: host name   *	    service name -  * Returns: TCP/IP stream if success else NIL   */   / TCPSTREAM *tcp_aopen (char *host,char *service)  { 
   return NIL;  }    /* TCP/IP receive line  * Accepts: TCP/IP stream .  * Returns: text line string or NIL if failure  */   % char *tcp_getline (TCPSTREAM *stream)  { 
   int n,m;   char *st,*ret,*stp;    char c = '\0';	   char d;  				/* make sure have data */ (   if (!tcp_getdata (stream)) return NIL;0   st = stream->iptr;		/* save start of string */"   n = 0;			/* init string count */5   while (stream->ictr--) {	/* look for end of line */ 6     d = *stream->iptr++;	/* slurp another character */)     if ((c == '\015') && (d == '\012')) { "       ret = (char *) fs_get (n--);>       memcpy (ret,st,n);	/* copy into a free storage string */4       ret[n] = '\0';		/* tie off string with null */       return ret;      } 1     n++;			/* count another character searched */ .     c = d;			/* remember previous character */   } ) 				/* copy partial string from buffer */ 2   memcpy ((ret = stp = (char *) fs_get (n)),st,n);$ 				/* get more data from the net */(   if (!tcp_getdata (stream)) return NIL;2 				/* special case of newline broken by buffer */3   if ((c == '\015') && (*stream->iptr == '\012')) { ,     stream->iptr++;		/* eat the line feed */     stream->ictr--; 6     ret[n - 1] = '\0';		/* tie off string with null */   } ' 				/* else recurse to get remainder */ '   else if (st = tcp_getline (stream)) { 6     ret = (char *) fs_get (n + 1 + (m = strlen (st)));.     memcpy (ret,stp,n);		/* copy first part */0     memcpy (ret + n,st,m);	/* and second part */4     fs_give ((void **) &stp);	/* flush first part */4     fs_give ((void **) &st);	/* flush second part */6     ret[n + m] = '\0';		/* tie off string with null */   } 
   return ret;  }    /* TCP/IP receive buffer  * Accepts: TCP/IP stream   *	    size in bytes  *	    buffer to read into'  * Returns: T if success, NIL otherwise   */   F long tcp_getbuffer (TCPSTREAM *stream,unsigned long size,char *buffer) {    unsigned long n;   char *bufptr = buffer;3   while (size > 0) {		/* until request satisfied */ *     if (!tcp_getdata (stream)) return NIL;A     n = min (size,stream->ictr);/* number of bytes to transfer */  				/* do the copy */ #     memcpy (bufptr,stream->iptr,n); &     bufptr += n;		/* update pointer */     stream->iptr +=n; .     size -= n;			/* update # of bytes to do */     stream->ictr -=n;    } )   bufptr[0] = '\0';		/* tie off string */    return T;  }      /* TCP/IP receive data  * Accepts: TCP/IP stream '  * Returns: T if success, NIL otherwise   */   $ long tcp_getdata (TCPSTREAM *stream) {    char tmp[MAILTMPLEN];    int i,status; K   /* Note: the doc says we need here dynamic descriptor, but we need static     * one... */F   struct dsc$descriptor BufDesc = {BUFLEN,DSC$K_DTYPE_T,DSC$K_CLASS_S, 				     stream->ibuf};    static short iosb[4]; $   if (stream->tcpsi < 0) return NIL;;   while (stream->ictr < 1) {	/* if nothing in the buffer */ L     if (!((status = tcp_receive(&(stream->tcpsi), &BufDesc, iosb)) & 0x1)) {H       sprintf (tmp,"Error reading from TcpIp/NETLIB, status=%d",status);       mm_log (tmp,ERROR);         return tcp_abort (stream);     } %     if (iosb[1] > BUFLEN) i = BUFLEN;      else i = iosb[1]; )     if (i < 1) return tcp_abort (stream); /     stream->ictr = i;		/* set new byte count */ 9     stream->iptr = stream->ibuf;/* point at TCP buffer */    }    return T;  }    /* TCP/IP send string as record   * Accepts: TCP/IP stream   *	    string pointer !  * Returns: T if success else NIL   */   / long tcp_soutr (TCPSTREAM *stream,char *string)  { B   return tcp_sout (stream,string,(unsigned long) strlen (string)); }      /* TCP/IP send string   * Accepts: TCP/IP stream   *	    string pointer   *	    byte count !  * Returns: T if success else NIL   */   A long tcp_sout (TCPSTREAM *stream,char *string,unsigned long size)  { 
   int status; B   struct dsc$descriptor_s BufDesc = {strlen(string),DSC$K_DTYPE_T," 				       DSC$K_CLASS_S,string }; 				/* 2 = Do not add \r\n */ H   return ((status = tcp_send (&(stream->tcpso),&BufDesc,2)) & 0x1) ? T :     tcp_abort (stream);  }    /* TCP/IP close   * Accepts: TCP/IP stream   */   " void tcp_close (TCPSTREAM *stream) { ,   tcp_abort (stream);		/* nuke the stream */ 				/* flush host names */$   fs_give ((void **) &stream->host);)   fs_give ((void **) &stream->localhost); 5   fs_give ((void **) &stream);	/* flush the stream */  }      /* TCP/IP abort stream  * Accepts: TCP/IP stream   * Returns: NIL always  */   " long tcp_abort (TCPSTREAM *stream) { 4   if (stream->tcpsi >= 0) {	/* no-op if no socket */ 				/* nuke the socket */ &     tcp_disconnect (&(stream->tcpsi));'     stream->tcpsi = stream->tcpso = -1;    } 
   return NIL;  }      /* TCP/IP get host name   * Accepts: TCP/IP stream %  * Returns: host name for this stream   */   " char *tcp_host (TCPSTREAM *stream) { .   return stream->host;		/* return host name */ }      /* TCP/IP get local host name   * Accepts: TCP/IP stream   * Returns: local host name   */   ' char *tcp_localhost (TCPSTREAM *stream)  { 8   return stream->localhost;	/* return local host name */ }    /* TCP/IP get server host name"  * Accepts: pointer to destination3  * Returns: string pointer if got results, else NIL   */     char *tcp_clienthost (char *dst) { .   return "UNKNOWN";		/* needs to be written */ }      /* Return my local host name  * Returns: my local host name  */    char *mylocalhost () { 
   int status;    char tmp[MAILTMPLEN]; 1   if (!myLocalHost) {		/* have local host yet? */ " 				/* receives local host name */O     struct dsc$descriptor LocalhostDesc = {0,DSC$K_DTYPE_T,DSC$K_CLASS_D,NULL}; @     if (!((status = net_get_hostname (&LocalhostDesc)) & 0x1)) {A       sprintf (tmp,"Can't get local hostname, status=%d",status);        mm_log (tmp,ERROR);        return "UNKNOWN";      } I     strncpy (tmp,LocalhostDesc.dsc$a_pointer,LocalhostDesc.dsc$w_length); +     tmp[LocalhostDesc.dsc$w_length] = '\0'; "     str$free1_dx (&LocalhostDesc);     myLocalHost = cpystr (tmp);    }    return myLocalHost;  }      /*D  | return the local hostname in Buffer whose size is Size. This is aB  | replacement to the Gethostname() which does not exist in Nelib.  */ ! get_local_host_name(buffer, size) 
 char	*buffer; 	 int	size;  { 
   int	status;   ;   struct dsc$descriptor LocalhostDesc = { 0, DSC$K_DTYPE_T, @ 	DSC$K_CLASS_D, NULL };	/* Used to receive the local hostname */  ,   status = net_get_hostname(&LocalhostDesc);   if((status & 0x1) == 0) {  	char	tmp[256]; = 	sprintf(tmp, "Can't get local hostname, status=%d", status);  	mm_log(tmp, ERROR); 	return NIL;   } K   strncpy(buffer, LocalhostDesc.dsc$a_pointer, LocalhostDesc.dsc$w_length); ,   buffer[LocalhostDesc.dsc$w_length] = '\0';   str$free1_dx(&LocalhostDesc);  }   