$! Make_PBMplusShr.com
$!
$! Make shareable image out of PBMPLUS libraries.  This command procedure
$! takes no arguments, but must be placed in the top-level PBMPLUS directory.
$!
$! It uses the following input library files:
$!
$!	[.PBM]LIBPBM.OLB,[.PGM]LIBPGM.OLB,[.PPM]LIBPPM.OLB,[.PNM]LIBPNM.OLB
$!
$!  Originally Written by: David Jones (JonesD@kcgl1.eng.Ohio-State.EDU)
$!
$!  Modified: 20-SEP-1994  Rick Dyson (dyson@IowaSP.Physics.UIowa.EDU)
$!                         Updated to NetPBM (1 Mar 94) and ALP support
$!
$!------------------------------------------------------------------------------
$!
$! Determine machine hardware type
$!
$ On Warning Then GoTo VAX
$ Machine = F$GetSYI ("ARCH_NAME")
$ If Machine .eqs. "ALP"   Then GoTo ALP
$ If Machine .eqs. "Alpha" Then GoTo ALP
$!----------------------------------------------------------------------
$! OpenVMS-VAX
$!----------------------------------------------------------------------
$VAX:
$!
$   On Warning Then Exit
$!
$! This procedure generates the following files if missing or out-of-date:
$!
$!	TRANSVEC.OBJ	Object file containing transfer vector for PBMplusShr.
$!	PBMplusShr.EXE	Shareable image file for PBM libraries.
$!	PBMplusShr.OPT	Linker options file for linking utility program against
$!			the PBMplusShr.EXE shareable image.
$   instruct = 0
$   proc = F$Environment ("PROCEDURE")
$   proc_cdt = F$CvTime (F$File (proc, "CDT"))
$!
$   If F$Search ("TRANSVEC.OBJ") .eqs. "" Then GoTo NEW_TRANSVEC
$   If F$CvTime (F$File ("TRANSVEC.OBJ", "CDT")) .gts. PROC_CDT Then GoTo TRANSVEC_DONE
$!
$NEW_TRANSVEC:
$!
$   instruct = 1
$   Write SYS$Output "Making new transvec.obj..."
$   Macro /NoList /Object = TRANSVEC.OBJ Sys$Input
;
; PMBPLUS_TRANSFER_VECTOR
; This routine defines a transfer vector for use in creating shareable image
;
; define macro to make transfer vector entry for a given routine.  Entry mask 
; is obtained from routine we are transfering to.  Jump to word past entry 
; since these are VAX procedures (written in FORTRAN).
;
	.MACRO TRANSFER_ENTRY routine
;
	.TRANSFER routine
	.MASK	  routine
	JMP	  routine + 2
;
	.ENDM TRANSFER_ENTRY
;
	.TITLE PBMPLUS_TRANSFER_VECTOR
	.IDENT /01/
	.PSECT PBMPLUS_XVEC PIC,USR,CON,REL,LCL,SHR,EXE,RD,NOWRT,NOVEC
;
;	Simply go through iap procedures and declare transfer vector
;	entry points for them.  New procedure must be added to the END
;	of this list.
;
TRANSFER_VECTOR:
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;Library LIBPBM
;
;Module ARGPROC
;	TRANSFER_ENTRY BACKGROUND_PROCESS 
;	TRANSFER_ENTRY GETOPT
;	TRANSFER_ENTRY SET_OUTFILE_BINARY
	TRANSFER_ENTRY GETREDIRECTION

;Module LIBPBM1
	TRANSFER_ENTRY PBM_INIT
	TRANSFER_ENTRY PM_ALLOCARRAY
	TRANSFER_ENTRY PM_ALLOCROW
	TRANSFER_ENTRY PM_BITSTOMAXVAL
	TRANSFER_ENTRY PM_CLOSE
	TRANSFER_ENTRY PM_ERROR                         
	TRANSFER_ENTRY PM_FREEARRAY                     
	TRANSFER_ENTRY PM_FREEROW
	TRANSFER_ENTRY PM_INIT                          
	TRANSFER_ENTRY PM_KEYMATCH                      
	TRANSFER_ENTRY PM_MAXVALTOBITS                  
	TRANSFER_ENTRY PM_MESSAGE
	TRANSFER_ENTRY PM_OPENR                         
	TRANSFER_ENTRY PM_OPENW                         
	TRANSFER_ENTRY PM_PERROR                        
	TRANSFER_ENTRY PM_READBIGLONG
	TRANSFER_ENTRY PM_READBIGSHORT                  
	TRANSFER_ENTRY PM_READLITTLELONG                
	TRANSFER_ENTRY PM_READLITTLESHORT               
	TRANSFER_ENTRY PM_USAGE
	TRANSFER_ENTRY PM_WRITEBIGLONG                  
	TRANSFER_ENTRY PM_WRITEBIGSHORT                 
	TRANSFER_ENTRY PM_WRITELITTLELONG               
	TRANSFER_ENTRY PM_WRITELITTLESHORT
	TRANSFER_ENTRY PM_READ_UNKNOWN_SIZE

;Module LIBPBM2
	TRANSFER_ENTRY PBM_READMAGICNUMBER              
	TRANSFER_ENTRY PBM_READPBM                      
	TRANSFER_ENTRY PBM_READPBMINIT                  
	TRANSFER_ENTRY PBM_READPBMINITREST
	TRANSFER_ENTRY PBM_READPBMROW

;Module LIBPBM3
	TRANSFER_ENTRY PBM_WRITEPBM                     
	TRANSFER_ENTRY PBM_WRITEPBMINIT                 
	TRANSFER_ENTRY PBM_WRITEPBMROW

;Module LIBPBM4
	TRANSFER_ENTRY PBM_GETC                         
	TRANSFER_ENTRY PBM_GETINT                       
	TRANSFER_ENTRY PBM_GETRAWBYTE

;Module LIBPBM5
	TRANSFER_ENTRY PBM_DEFAULTFONT                  
	TRANSFER_ENTRY PBM_DISSECTFONT                  
	TRANSFER_ENTRY PBM_DUMPFONT
	TRANSFER_ENTRY PBM_LOADFONT
	TRANSFER_ENTRY PBM_LOADBDFFONT
	TRANSFER_ENTRY MK_ARGVN

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;Library LIBPGM
;
;Module LIBPGM1
	TRANSFER_ENTRY PGM_INIT                         
	TRANSFER_ENTRY PGM_READPGM                      
	TRANSFER_ENTRY PGM_READPGMINIT                  
	TRANSFER_ENTRY PGM_READPGMINITREST
	TRANSFER_ENTRY PGM_READPGMROW

;Module LIBPGM2
	TRANSFER_ENTRY PGM_WRITEPGM                     
	TRANSFER_ENTRY PGM_WRITEPGMINIT                 
	TRANSFER_ENTRY PGM_WRITEPGMROW

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Library LIBPPM
;
;Module LIBPPM1
	TRANSFER_ENTRY PPM_INIT                         
	TRANSFER_ENTRY PPM_READPPM                      
	TRANSFER_ENTRY PPM_READPPMINIT                  
	TRANSFER_ENTRY PPM_READPPMINITREST
	TRANSFER_ENTRY PPM_READPPMROW

;Module LIBPPM2
	TRANSFER_ENTRY PPM_WRITEPPM                     
	TRANSFER_ENTRY PPM_WRITEPPMINIT                 
	TRANSFER_ENTRY PPM_WRITEPPMROW

;Module LIBPPM3
	TRANSFER_ENTRY PPM_ADDTOCOLORHASH               
	TRANSFER_ENTRY PPM_ADDTOCOLORHIST               
	TRANSFER_ENTRY PPM_ALLOCCOLORHASH               
	TRANSFER_ENTRY PPM_COLORHASHTOCOLORHIST
	TRANSFER_ENTRY PPM_COLORHISTTOCOLORHASH         
	TRANSFER_ENTRY PPM_COMPUTECOLORHASH             
	TRANSFER_ENTRY PPM_COMPUTECOLORHIST             
	TRANSFER_ENTRY PPM_FREECOLORHASH
	TRANSFER_ENTRY PPM_FREECOLORHIST                
	TRANSFER_ENTRY PPM_LOOKUPCOLOR

;Module LIBPPM4
	TRANSFER_ENTRY PPM_COLORNAME                    
	TRANSFER_ENTRY PPM_PARSECOLOR

;Module LIBPPM5
	TRANSFER_ENTRY PPMD_CIRCLE                      
	TRANSFER_ENTRY PPMD_FILL                        
	TRANSFER_ENTRY PPMD_FILLEDRECTANGLE             
	TRANSFER_ENTRY PPMD_FILL_DRAWPROC
	TRANSFER_ENTRY PPMD_FILL_INIT                   
	TRANSFER_ENTRY PPMD_LINE                        
	TRANSFER_ENTRY PPMD_POINT_DRAWPROC              
	TRANSFER_ENTRY PPMD_POLYSPLINE
	TRANSFER_ENTRY PPMD_SETLINECLIP                 
	TRANSFER_ENTRY PPMD_SETLINETYPE                 
	TRANSFER_ENTRY PPMD_SPLINE3

;Module BITIO
	TRANSFER_ENTRY PM_BITINIT
	TRANSFER_ENTRY PM_BITFINI
	TRANSFER_ENTRY PM_BITREAD
	TRANSFER_ENTRY PM_BITWRITE

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Library LIBPNM
;
;Module LIBPNM1
	TRANSFER_ENTRY PNM_INIT                         
	TRANSFER_ENTRY PNM_READPNM                      
	TRANSFER_ENTRY PNM_READPNMINIT                  
	TRANSFER_ENTRY PNM_READPNMROW

;Module LIBPNM2
	TRANSFER_ENTRY PNM_WRITEPNM                     
	TRANSFER_ENTRY PNM_WRITEPNMINIT                 
	TRANSFER_ENTRY PNM_WRITEPNMROW

;Module LIBPNM3
	TRANSFER_ENTRY PNM_BACKGROUNDXEL                
	TRANSFER_ENTRY PNM_BACKGROUNDXELROW             
	TRANSFER_ENTRY PNM_BLACKXEL                     
	TRANSFER_ENTRY PNM_INVERTXEL
	TRANSFER_ENTRY PNM_PROMOTEFORMAT                
	TRANSFER_ENTRY PNM_PROMOTEFORMATROW             
	TRANSFER_ENTRY PNM_WHITEXEL

;Module LIBPNM4
	TRANSFER_ENTRY MEM_CREATE                       
	TRANSFER_ENTRY MEM_FREE                         
	TRANSFER_ENTRY PR_DUMP                          
	TRANSFER_ENTRY PR_LOAD_COLORMAP
	TRANSFER_ENTRY PR_LOAD_HEADER                   
	TRANSFER_ENTRY PR_LOAD_IMAGE

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;	allocate extra space to allow for code modifications without changing 
;	the size of the shared image.
;
	.BLKB 2048-<.-TRANSFER_VECTOR>	; Reserve 4 pages.
;
	.END

$TRANSVEC_DONE:
$!
$!   Create new options file if needed.
$!
$   If F$Search ("PBMplusShr.OPT") .eqs. "" Then GoTo NEW_OPTFILE
$   If F$CvTime (F$File ("PBMplusShr.OPT", "CDT")) .gts. PROC_CDT Then GoTo OPTFILE_DONE
$!
$NEW_OPTFILE:
$!
$   instruct = 1
$   Write Sys$Output "Making new PBMplusShr.opt..."
$   Create PBMplusShr.OPT
! PBMplusShr.opt
!
! PBMplus Linker Options file for VAX/VMS
!
PBMplusShr /Share
Sys$Share:VAXCRTL /Share
PSECT_ATTR = ARGPROC_VERSION, GBL, NOSHR
PSECT_ATTR = OPTARG, GBL, NOSHR
PSECT_ATTR = OPTERR, GBL, NOSHR
PSECT_ATTR = OPTIND, GBL, NOSHR
PSECT_ATTR = OPTOPT, GBL, NOSHR
PSECT_ATTR = PGM_PBMMAXVAL, GBL, NOSHR
PSECT_ATTR = PPM_PBMMAXVAL, GBL, NOSHR
PSECT_ATTR = PNM_PBMMAXVAL, GBL, NOSHR
$!
$OPTFILE_DONE:
$!
$   If F$Search ("PBMplusShr.EXE") .eqs. "" Then GoTo NEW_SHAREABLE
$   EXE_CDT = F$CvTime (F$File_Attributes ("PBMplusShr.EXE", "CDT"))
$   If EXE_CDT .lts. PROC_CDT Then GoTo NEW_SHAREABLE
$   If F$CvTime (F$File ("[.PBM]LIBPBM.OLB","RDT")) .gts. EXE_CDT Then GoTo NEW_SHAREABLE
$   If F$CvTime (F$File ("[.PGM]LIBPGM.OLB","RDT")) .gts. EXE_CDT Then GoTo NEW_SHAREABLE
$   If F$CvTime (F$File ("[.PPM]LIBPPM.OLB","RDT")) .gts. EXE_CDT Then GoTo NEW_SHAREABLE
$   If F$CvTime (F$File ("[.PNM]LIBPNM.OLB","RDT")) .gts. EXE_CDT Then GoTo NEW_SHAREABLE
$   GoTo SHAREABLE_DONE
$!
$NEW_SHAREABLE:
$!
$   instruct = 1
$   Write Sys$Output "Making new PBMplusShr.exe..."
$   Link /NoTraceBack /Map = PBMplusShr.MAP -
         /Share = Sys$Disk:[]PBMplusShr.EXE -
         Sys$Input/Option
COLLECT = FIRST, PBMPLUS_XVEC
COLLECT = GLOBALS1, PGM_PBMMAXVAL, PNM_PBMMAXVAL, PPM_PBMMAXVAL
COLLECT = GLOBALS2, ARGPROC_VERSION, OPTARG, OPTERR, OPTIND, OPTOPT

TRANSVEC.OBJ
[.PBM]LIBPBM/Library
[.PGM]LIBPGM/Library
[.PPM]LIBPPM/Library
[.PNM]LIBPNM/Library
Sys$Share:VAXCRTL /Share

UNSUPPORTED = 1			! force demand zero pages
GSMATCH = LEQUAL,2,2		! Major ID = 2, minor ID = 2

PSECT_ATTR = ARGPROC_VERSION, NOSHR
PSECT_ATTR = OPTARG, NOSHR
PSECT_ATTR = OPTERR, NOSHR
PSECT_ATTR = OPTIND, NOSHR
PSECT_ATTR = OPTOPT, NOSHR
PSECT_ATTR = PGM_PBMMAXVAL, NOSHR
PSECT_ATTR = PPM_PBMMAXVAL, NOSHR
PSECT_ATTR = PNM_PBMMAXVAL, NOSHR
$!
$   GoTo Shareable_Done
$!
$!----------------------------------------------------------------------
$! OpenVMS-ALP
$!----------------------------------------------------------------------
$!
$ALP:
$!
$   On Warning Then Exit
$!
$! This procedure generates the following files if missing or out-of-date:
$!
$!	PBMplusShr.EXE	Shareable image file for PBM libraries.
$!	PBMplusShr.OPT	Linker options file for linking utility program against
$!			the PBMplusShr.EXE shareable image.
$!
$   instruct = 0
$   proc = F$Environment ("PROCEDURE")
$   proc_cdt = F$CvTime (F$File (proc, "CDT"))
$!
$!   Create new options file if needed.
$!
$   If F$Search ("PBMplusShr.OPT") .eqs. "" Then GoTo NEW_ALP_OPTFILE
$   If F$CvTime (F$File ("PBMplusShr.OPT", "CDT")) .gts. PROC_CDT Then GoTo ALP_OPTFILE_DONE
$!
$NEW_ALP_OPTFILE:
$!
$   instruct = 1
$   Write Sys$Output "Making new ALP PBMplusShr.opt..."
$   Create PBMplusShr.OPT
! PBMplusShr.opt
!
! PBMplus Linker Options file for ALP/VMS
!
PBMplusShr /Share
PSECT_ATTR = ARGPROC_VERSION, GBL, NOSHR
PSECT_ATTR = OPTARG, GBL, NOSHR
PSECT_ATTR = OPTERR, GBL, NOSHR
PSECT_ATTR = OPTIND, GBL, NOSHR
PSECT_ATTR = OPTOPT, GBL, NOSHR
PSECT_ATTR = PGM_PBMMAXVAL, GBL, NOSHR
PSECT_ATTR = PPM_PBMMAXVAL, GBL, NOSHR
PSECT_ATTR = PNM_PBMMAXVAL, GBL, NOSHR
$!
$ALP_OPTFILE_DONE:
$!
$   If F$Search ("PBMplusShr.EXE") .eqs. "" Then GoTo NEW_ALP_SHAREABLE
$   EXE_CDT = F$CvTime (F$File_Attributes ("PBMplusShr.EXE", "CDT"))
$   If EXE_CDT .lts. PROC_CDT Then GoTo NEW_ALP_SHAREABLE
$   If F$CvTime (F$File ("[.PBM]LIBPBM.OLB", "RDT")) .gts. EXE_CDT Then GoTo NEW_ALP_SHAREABLE
$   If F$CvTime (F$File ("[.PGM]LIBPGM.OLB", "RDT")) .gts. EXE_CDT Then GoTo NEW_ALP_SHAREABLE
$   If F$CvTime (F$File ("[.PPM]LIBPPM.OLB", "RDT")) .gts. EXE_CDT Then GoTo NEW_ALP_SHAREABLE
$   If F$CvTime (F$File ("[.PNM]LIBPNM.OLB", "RDT")) .gts. EXE_CDT Then GoTo NEW_ALP_SHAREABLE
$   GoTo SHAREABLE_DONE
$!
$NEW_ALP_SHAREABLE:
$!
$   instruct = 1
$   Write Sys$Output "Making new ALP PBMplusShr.exe..."
$   Link /Map = PBMplusShr.MAP /Full /Cross -
         /NoTraceback /NoUser -
         /Share = Sys$Disk:[]PBMplusShr.EXE -
         Sys$Input/Option
COLLECT = GLOBALS1, PGM_PBMMAXVAL, PNM_PBMMAXVAL, PPM_PBMMAXVAL
COLLECT = GLOBALS2, ARGPROC_VERSION, OPTARG, OPTERR, OPTIND, OPTOPT

GSMATCH = LEQUAL,2,2		! Major ID = 2, minor ID = 2

[.PBM]LibPBM.olb /Library
[.PGM]LibPGM.olb /Library
[.PPM]LibPPM.olb /Library
[.PNM]LibPNM.olb /Library

PSECT_ATTR = ARGPROC_VERSION, GBL, NOSHR
PSECT_ATTR = OPTARG, GBL, NOSHR
PSECT_ATTR = OPTERR, GBL, NOSHR
PSECT_ATTR = OPTIND, GBL, NOSHR
PSECT_ATTR = OPTOPT, GBL, NOSHR
PSECT_ATTR = PGM_PBMMAXVAL, GBL, NOSHR
PSECT_ATTR = PPM_PBMMAXVAL, GBL, NOSHR
PSECT_ATTR = PNM_PBMMAXVAL, GBL, NOSHR

SYMBOL_VECTOR = ( -
!BACKGROUND_PROCESS = Procedure, -
!GETOPT = Procedure, -
!SET_OUTFILE_BINARY = Procedure, -
GETREDIRECTION = Procedure, -
PBM_INIT = Procedure, -
PM_ALLOCARRAY = Procedure, -
PM_ALLOCROW = Procedure, -
PM_BITSTOMAXVAL = Procedure, -
PM_CLOSE = Procedure, -
PM_ERROR = Procedure, -
PM_FREEARRAY = Procedure, -
PM_FREEROW = Procedure, -
PM_INIT = Procedure, -
PM_KEYMATCH = Procedure, -
PM_MAXVALTOBITS = Procedure, -
PM_MESSAGE = Procedure, -
PM_OPENR = Procedure, -
PM_OPENW = Procedure, -
PM_PERROR = Procedure, -
PM_READBIGLONG = Procedure, -
PM_READBIGSHORT = Procedure, -
PM_READLITTLELONG = Procedure, -
PM_READLITTLESHORT = Procedure, -
PM_USAGE = Procedure, -
PM_WRITEBIGLONG = Procedure, -
PM_WRITEBIGSHORT = Procedure, -
PM_WRITELITTLELONG = Procedure, -
PM_WRITELITTLESHORT = Procedure, -
PM_READ_UNKNOWN_SIZE = Procedure, -
PBM_READMAGICNUMBER = Procedure, -
PBM_READPBM = Procedure, -
PBM_READPBMINIT = Procedure, -
PBM_READPBMINITREST = Procedure, -
PBM_READPBMROW = Procedure, -
PBM_WRITEPBM = Procedure, -
PBM_WRITEPBMINIT = Procedure, -
PBM_WRITEPBMROW = Procedure, -
PBM_GETC = Procedure, -
PBM_GETINT = Procedure, -
PBM_GETRAWBYTE = Procedure, -
PBM_DEFAULTFONT = Procedure, -
PBM_DISSECTFONT = Procedure, -
PBM_DUMPFONT = Procedure, -
PBM_LOADFONT = Procedure, -
PBM_LOADBDFFONT = Procedure, -
MK_ARGVN = Procedure, -
PGM_INIT = Procedure, -
PGM_READPGM = Procedure, -
PGM_READPGMINIT = Procedure, -
PGM_READPGMINITREST = Procedure, -
PGM_READPGMROW = Procedure, -
PGM_WRITEPGM = Procedure, -
PGM_WRITEPGMINIT = Procedure, -
PGM_WRITEPGMROW = Procedure, -
PPM_INIT = Procedure, -
PPM_READPPM = Procedure, -
PPM_READPPMINIT = Procedure, -
PPM_READPPMINITREST = Procedure, -
PPM_READPPMROW = Procedure, -
PPM_WRITEPPM = Procedure, -
PPM_WRITEPPMINIT = Procedure, -
PPM_WRITEPPMROW = Procedure, -
PPM_ADDTOCOLORHASH = Procedure, -
PPM_ADDTOCOLORHIST = Procedure, -
PPM_ALLOCCOLORHASH = Procedure, -
PPM_COLORHASHTOCOLORHIST = Procedure, -
PPM_COLORHISTTOCOLORHASH = Procedure, -
PPM_COMPUTECOLORHASH = Procedure, -
PPM_COMPUTECOLORHIST = Procedure, -
PPM_FREECOLORHASH = Procedure, -
PPM_FREECOLORHIST = Procedure, -
PPM_LOOKUPCOLOR = Procedure, -
PPM_COLORNAME = Procedure, -
PPM_PARSECOLOR = Procedure, -
PPMD_CIRCLE = Procedure, -
PPMD_FILL = Procedure, -
PPMD_FILLEDRECTANGLE = Procedure, -
PPMD_FILL_DRAWPROC = Procedure, -
PPMD_FILL_INIT = Procedure, -
PPMD_LINE = Procedure, -
PPMD_POINT_DRAWPROC = Procedure, -
PPMD_POLYSPLINE = Procedure, -
PPMD_SETLINECLIP = Procedure, -
PPMD_SETLINETYPE = Procedure, -
PPMD_SPLINE3 = Procedure, -
PM_BITINIT = Procedure, -
PM_BITFINI = Procedure, -
PM_BITREAD = Procedure, -
PM_BITWRITE = Procedure, -
PNM_INIT = Procedure, -
PNM_READPNM = Procedure, -
PNM_READPNMINIT = Procedure, -
PNM_READPNMROW = Procedure, -
PNM_WRITEPNM = Procedure, -
PNM_WRITEPNMINIT = Procedure, -
PNM_WRITEPNMROW = Procedure, -
PNM_BACKGROUNDXEL = Procedure, -
PNM_BACKGROUNDXELROW = Procedure, -
PNM_BLACKXEL = Procedure, -
PNM_INVERTXEL = Procedure, -
PNM_PROMOTEFORMAT = Procedure, -
PNM_PROMOTEFORMATROW = Procedure, -
PNM_WHITEXEL = Procedure, -
MEM_CREATE = Procedure, -
MEM_FREE = Procedure, -
PR_DUMP  = Procedure, -
PR_LOAD_COLORMAP = Procedure, -
PR_LOAD_HEADER = Procedure, -
PR_LOAD_IMAGE = Procedure -
)

$!
$SHAREABLE_DONE:
$!
$   Set Protection = (Owner:RWE, World:RE) PBMPlusShr.exe
$   If .not. instruct Then Write Sys$Output "All PBMplusShr files up to date."
$   If .not. instruct Then Exit $Status
$   Create Sys$Output

	Define the logical name PBMplusShr as "disk:[dir]PBMplusShr", where
	disk and [dir] are the disk and directory containing the
	shareable image PBMplusShr.EXE and linker options file PBMplusShr.OPT.

	You can then link an executable against the image with the command

	    LINK program.OBJ,PBMplusShr/Option

$ Exit $Status
