/****************************************************************/
/*								*/
/* const.h:	some constants and ext's for all		*/
/*								*/
/*		Design: Walter Benzing 1994			*/
/*		NO RIGHTS RESERVED				*/
/*								*/
/****************************************************************/

#ifndef _CONST_H
#define _CONST_H

/****************************************************************/
/*								*/
/* The next lines describe Data types that NEED a specific	*/
/* number of BITS, they are HARDWARE dependent and might be	*/
/* changed according to YOUR SYSTEM				*/
/*								*/
/****************************************************************/

#define myINT32 int			/* 32 Bit integer */
#define myINT16	short			/* 16 Bit integer */
#define myINT8	char			/* 8 bit integer */

#define PI 3.14159265358979323846
#define OK 0
#define WARN 1
#define ERROR 2
#define TRUE 1
#define FALSE 0
#define MAX_VIEWPORT_NUMBER 32		/* maximum number of viewports */
#define MAX_COL_NUMBER 256		/* maximum number of colors used,
					   if > 256, in Imakefile -DD16 or -DD32
					   must be used,also it must be smaller than
					   MAX_DECO_NUMBER in coor.h*/
#define MAX_NAME_LENGTH 256		/* number of charcters per name */
#define MAX_LINK_LENGTH 32		/* number of char's per link*/
#define NUM_PREF 15			/* number of preferences */
#define NUM_DATA 9			/* number of entries in data file */
#define CHAR2BITS 3			/* shift the sizeof values to get depth in bits */
#define CHARBITS 8			/* number of bits per character */
#define MAX_DIM_LENGTH 32		/* maximum character representation in char */
#define NOCHANGE 0
#define CHANGED 1
#define TRANS_CHANGED 2			/* color translation changed */
#define TRANS_AND_CHANGE (TRANS_CHANGED|CHANGED) 
#define DATA_CHANGED 4			/* data changed */
#define DATA_AND_CHANGE (DATA_CHANGED|CHANGED)
#define ALL_CHANGED (CHANGED | TRANS_CHANGED | DATA_CHANGED)
#define FILE_SEP '/'
#define ALLOC_POINTS 50
#define CUT_START 1
#define CUT_END 2
#define VALID_CUT 3
#define CUT_WINDOW 4
#define ALIGN_LEFT 1
#define ALIGN_CENTER_X 2
#define ALIGN_RIGHT 4
#define ALIGN_TOP 8
#define ALIGN_CENTER_Y 16
#define ALIGN_BOTTOM 32
#define POS_TOP_X 1
#define POS_TOP_Y 2

/************* Data Types **************************************/

#define MY_DOUBLE 0
#define MY_UCHAR 1

/************* Redraw Methods by Name **************************/

#define RED_GRID	"Grid"
#define RED_LINES	"Lines"
#define RED_HIDDEN	"Hidden"
#define RED_FILLED	"Filled"
#define RED_HFILLED	"HFilled"
#define RED_CUT		"Cut"
#define RED_COMP	"Complex"
#define RED_HCOMP	"HComplex"
#define RED_RGB		"RGB"

/***************************************************************/

#ifdef _MAIN

const int Short2Char = ((sizeof(short)-1) << CHAR2BITS);
const char TypeNames[2][8] = { "double", "uchar" };
const char RMethods[9][10] = {RED_GRID, RED_LINES, RED_HIDDEN, RED_FILLED,
	RED_HFILLED, RED_CUT, RED_COMP, RED_HCOMP, RED_RGB };
int CUChar = MY_UCHAR;
int CDouble = MY_DOUBLE;

#else

extern const int Short2Char;
extern const char TypeNames[2][8];
extern const char RMethods[9][10];
extern int CUChar;
extern int CDouble;

#endif /* _MAIN */

#endif /* _CONST_H */
