/****************************************************************/
/*								*/
/* coor.h:	definitions for coordination transformations	*/
/*								*/
/*		Design: Walter Benzing 1994			*/
/*								*/
/****************************************************************/

#ifndef _COOR_H
#define _COOR_H

/****************************************************************/
/*								*/
/* all coordinates are calculated in an integer space		*/
/* normalized between -CO_ONE and +CO_ONE			*/
/* to work, myCoor MUST at least have 32 Bit's			*/
/* CO_ONE is the One of this space and was derived by the	*/
/* following calculation:					*/
/*								*/
/* myCoor >= 32 bits						*/
/*	multiplication must fit into 32 bit			*/
/*	CO_ONE <= 16 bit					*/
/* 	sign:	CO_ONE <=15					*/
/*	One must be available for + and -			*/
/*	CO_ONE <= 14 bit					*/
/*	after adding an offset p.ex. moveX must fit as well	*/
/*	CO_ONE <= 13 bit					*/
/*								*/
/****************************************************************/

#define CO_ONE		8192		/* the normalized One */
#define CO_ONESHIFT	13		/* 1^CO_ONESHIFT = CO_ONE */
#define MAX_DECO_NUMBER CO_ONE		/* number of enteries in color deco */

/* make shure the type used for myCoor >= 32 bits */

typedef myINT32 myCoor;

/*
 * Coordinate transformations
 */
 
/* **** WARNING MAKRO's **** WARNING MAKRO's **** */

#define CO_Transform(xt,yt,zt,xd,yd,x,y,z,sinXY,cosXY,sinZ,cosZ,zoomX,zoomY,zoomZ,moveX,moveY,k)\
   {\
    xd = ((x)*zoomX)>>CO_ONESHIFT;\
    yd = ((y)*zoomY)>>CO_ONESHIFT;\
    xt = (((xd)* cosXY + yd*sinXY)>>CO_ONESHIFT);\
    yd = ((yd)* cosXY - xd*sinXY)>>CO_ONESHIFT;\
    xd = ((z)* zoomZ)>>CO_ONESHIFT;\
    yt = (((yd) * cosZ + xd * sinZ)>>CO_ONESHIFT);\
    zt = ((xd)* cosZ - yd * sinZ)>>CO_ONESHIFT;\
    if(k!=0)\
      {\
       xd = (k<<CO_ONESHIFT)/(zt+k);\
       xt = (xt*xd)>>CO_ONESHIFT;\
       yt = (yt*xd)>>CO_ONESHIFT;\
      }\
    xt += moveX;\
    yt += moveY;\
   }

#define CO_TransformXY(xt,yt,xd,yd,x,y,z,sinXY,cosXY,sinZ,cosZ,zoomX,zoomY,zoomZ,moveX,moveY,k)\
   {\
    xd = ((x)*zoomX)>>CO_ONESHIFT;\
    yd = ((y)*zoomY)>>CO_ONESHIFT;\
    xt = (((xd)* cosXY + yd*sinXY)>>CO_ONESHIFT);\
    yd = ((yd)* cosXY - xd*sinXY)>>CO_ONESHIFT;\
    xd = ((z)* zoomZ)>>CO_ONESHIFT;\
    yt = (((yd) * cosZ + xd * sinZ)>>CO_ONESHIFT);\
    if(k!=0)\
      {\
       xd = ((xd)* cosZ - yd * sinZ)>>CO_ONESHIFT;\
       yd = (k<<CO_ONESHIFT)/(k-xd);\
       xt = (xt*yd)>>CO_ONESHIFT;\
       yt = (yt*yd)>>CO_ONESHIFT;\
      }\
    xt += moveX;\
    yt += moveY;\
   }

#define CO_TransformHW(xt,yt,x,z,zoomX,zoomZ,moveX,moveY)\
   {\
    xt = ((x*zoomX)>>CO_ONESHIFT)+ moveX;\
    yt = ((z*zoomZ)>>CO_ONESHIFT)+ moveY;\
   }

#define CO_getStep(del,step)\
    if(del < 0)\
      {\
       step = -1;\
       del = -del;\
      }\
    else\
      step = 1;
#endif /* _COOR_H */
