/****************************************************************/
/*								*/
/* grfx.h:	hardware independent graphic stuff		*/
/*								*/
/*		Design: Walter Benzing 1994			*/
/*								*/
/****************************************************************/

#ifndef _GRFX_H
#define _GRFX_H

typedef struct
   {
    char Itself[MAX_LINK_LENGTH];
    char LinkName[MAX_LINK_LENGTH];
    char Link2File[MAX_NAME_LENGTH];
    int link1;
    int link2;
   } XDLink;

typedef struct
   {
    int links;
    XDLink hLinks[MAX_VIEWPORT_NUMBER];
   } XDLinks;

typedef struct
   {
    char pref[MAX_NAME_LENGTH];	/* preference file */
    int export;			/* use all colors for export */
    Boolean transCol;		/* translate colors due to different depth */
    int wwidth;			/* default window width */
    int wheight;		/* default window height */
    int pwidth;			/* default picture width */
    int pheight;		/* default picture height */
    double zoom;		/* default zoom fact */
    double dAngle;		/* default rotation step */
    myCoor delta;		/* step for moves */
    Boolean tNext;		/* start next timer ? */
    unsigned long tInterval;	/* interval for timer */
    Boolean DrawGrid;			/* Draw Grid ? */
    Boolean DrawAxisText;		/* text on Axis ? */
    Boolean interCol;		/* interpolate colors ? */
    int ticsX;			/* tics in X Direction */
    int ticsY;
    int ticsZ;
    Boolean GerNot;		/* German notation for values */
    double Repl;		/* replace value */
    int jpgQuality;		/* jpeg quality */
    myPixel fore;		/* default foreground */
    myPixel textFore;		/* default text foreground */
    myPixel axisFore;		/* default axis foreground */
    myPixel back;		/* default background */
    myPixel axisBackX;		/* X background */    
    myPixel axisBackY;		/* Y background */    
    myPixel axisBackZ;		/* Z background */    
    int wantedColors;		/* Total number of colors wanted */
    myPixel colS;			/* Start color for deco */
    myPixel colE;			/* End color for deco */
    int gNum;			/* number of lines in the grid */
    int gStep;			/* Step for redraw lines */
    int rowNum;			/* Number of rows with colors */
    int colors[MAX_COL_NUMBER];	/* Colors per row */
    unsigned short beginR[MAX_COL_NUMBER];	/* red of start color */ 
    unsigned short beginG[MAX_COL_NUMBER];	/* green of start color */ 
    unsigned short beginB[MAX_COL_NUMBER];	/* blue of start color */
    unsigned short endR[MAX_COL_NUMBER];		/* red of end color */ 
    unsigned short endG[MAX_COL_NUMBER];		/* green of end color */ 
    unsigned short endB[MAX_COL_NUMBER];		/* blue of end color */
    Pixel colTrans[MAX_COL_NUMBER];	/* internally xdim assumes colors */
    					/* to start at begin[0] and end at */
    					/* end[RowNum] -> Color Translation */
    Boolean single;		/* Select a single color or a row */
    int selected;			/* selected row or color */
    int colorEdit;		/* color cells used for color edit */
    Boolean EditStartColor;	/* is it start or end color */
   } XDColorInfo;

typedef struct
   {
    int port;				/* port number */
    Boolean Grid;			/* Grid ? */
    Boolean DrawGrid;			/* Draw Grid ? */
    Boolean DrawAxisText;		/* text on Axis ? */
    Boolean edit;			/* edit data?*/
    int ticsX;				/* tics in X Direction */
    int ticsY;
    int ticsZ;
    double baseX;			/* base for x-Grid */
    double baseY;
    double baseZ;
    char dfile[MAX_NAME_LENGTH];	/* deco file name */
    char fileName[MAX_NAME_LENGTH];	/* data file name */
    int changed;			/* force recalculation of picture ? */
    myPixel deco[MAX_DECO_NUMBER];	/* color deco */
    myPixel trans[MAX_DECO_NUMBER];	/* deco translated to real pixels */
    int wwidth;			/* window width */
    int wheight;		/* window height */
    int pwidth;			/* picture width */
    int pheight;		/* picture height */
    int sZoom;			/* start zoom */
    int eZoom;			/* end zoom */
    double zoom;		/* zoom fact */
    myCoor zoomZ;		/* zoom z direction */
    myCoor zoomX;		/* zoom x direction */
    myCoor zoomY;		/* zoom y direction */
    myCoor k;			/* Perspective */
    myCoor kmin;
    double dAngle;		/* rotation step */
    double rotZ;		/* rotation angle z */
    myCoor sinZ;		/* sin z rotation */
    myCoor cosZ;		/* cos z rotation */
    double rotXY;		/* rotation angle XY */
    myCoor sinXY;		/* sin XY */
    myCoor cosXY;		/* cos XY */
    myCoor delta;		/* delta for move */
    myCoor moveX;		/* move in x direction */
    myCoor moveY;		/* move in y direction */
    myPixel fore;		/* foreground */
    myPixel textFore;		/* Text foreground */
    myPixel axisFore;		/* axis foreground */
    myPixel back;		/* background */
    myPixel axisBackX;		/* X background */    
    myPixel axisBackY;		/* Y background */    
    myPixel axisBackZ;		/* Z background */    
    int gNum;			/* number of lines in the grid */
    int gStep;			/* Step for redraw lines */
    int cut;			/* create a cut */
    double x1;			/* Start and Endpoint for the cut */
    double y1;
    double z1;
    double x2;
    double y2;
    double z2;
    myPixel colS;		/* Start color for deco */
    myPixel colE;		/* End color for deco */
    char DimX[MAX_DIM_LENGTH];	/* dimension x direction */
    char DimY[MAX_DIM_LENGTH];	/* dimension y direction */
    char DimZ[MAX_DIM_LENGTH];	/* dimension z direction */
    int links;			/* number of links */
    int actLink;		/* link used as card */
    char LinkName[MAX_VIEWPORT_NUMBER][MAX_LINK_LENGTH]; /* link description */
    char LinkItself[MAX_VIEWPORT_NUMBER][MAX_LINK_LENGTH]; /* link description */
    int Link1[MAX_VIEWPORT_NUMBER];	/* link viewport */
    int Link2[MAX_VIEWPORT_NUMBER];	/* link viewport */
    int Width;			/* act width */
    int Height;			/* act height */
    double Min;			/* act minimum value */
    double Max;			/* act maximum value */
    double OffX;		/* Offset X direction */
    double OffY;		/* Offset Y */
    double FactX;		/* factor from integer to double x*/
    double FactY;		/* factor from integer to double y*/
    double FactZ;		/* factor from integer to double z*/
    myCoor dMin;		/* minimum data value that's available */
    myCoor HMin[CO_ONE];	/* min for hidden line */
    myCoor HMax[CO_ONE];	/* max for hidden line */
    int dataType;		/* data type, 0=double, 1=unsigned char */
    double *actData;		/* used data */
    unsigned char *charData;	/* used data of type unsigned char */
    myCoor *Data;		/* act data in integer representation */
    myPixel *pict;		/* pointer to the picture */
   } ViewportInfo;

typedef struct
   {
    Boolean draw;		/* draw at point */
    myPixel drawColor;		/* color to draw */
    int x0;			/* old position */
    Boolean DefaultMov;		/* store as default ?*/
    Boolean DefaultWin;
    Boolean DefaultGrid;
    enum XDFilter filter;		/* filter type */
    myPixel colS;		/* start color for reset */
    myPixel colE;		/* start color for reset */
    myPixel dcolS;
    myPixel dcolE;
    myPixel back;		/* background for window */
    myPixel fore;		/* foreground for windows */
    myPixel textCol;		/* text color */
    myPixel axisFore;		/* axis color */
    myPixel axisBX;		/* Axis Background X */
    myPixel axisBY;
    myPixel axisBZ;
    double *edit;		/* pointer to value to edit */
    int edPort;			/* port number of edit field */
   } AllViewports;

#endif /* _grfx_h */
