/****************************************************************/
/*								*/
/* help.h:	Help Texts for XDim				*/
/*								*/
/*		Design: Walter Benzing 1994			*/
/*								*/
/****************************************************************/

#ifndef _DHELP_H
#define _DHELP_H

static char mainHelpText[] = "About\n\n\
	XDim is mainly a tool to view/process functions z=f(x,y)\n\
	Additionally it gives some standard picture processing functionality\n\
	Typical applications are NDE (Non Destructive Evaluation) and\n\
	an introduction into picture processing (p. ex. education)\n\n\
	XDim is freeware, meaning that you can use it or any part of it free\n\
	of charge.\n\n\
	XDim was designed by Walter Benzing 1994-95\n\n\
		(benzing@iegi01.etec.uni-karlsruhe.de)\n\n\
Disclaimer\n\n\
	XDim is not guaranteed to be of any use at all. Quite in contrary\n\
	the use of this program and/or any included file may lead to\n\
	corrupted data and/or disks.\n\
	By using this program you accept the risks and agree not make the\n\
	author liable for any damage done to your hardware, software, data etc.\n\
	(including life, universe and everything).\n\
	In countries where this exclusion of liability is not allowed\n\
	the use of XDim is forbidden by the author.\n\n\n\
1.0	The XDim Main Window (Tool Box)\n\n\
	The Main Window is the window, that pops up, when XDim is started.\n\
	It consists of several ICONS, a FILE and a SETUP Menu.\n\n\n\
1.1	Contents\n\n\
	1.2	The Mouse\n\
	1.3	Getting Started\n\
	1.4	The Icons\n\n\n\
1.2	The Mouse\n\n\
	XDim was designed to work with a THREE BUTTON MOUSE (or similar device).\n\
	If you only have two buttons available, you may have to change the\n\
	action of the buttons in xdmotif.c routine WD_DrawInput.\n\n\
	Button 1 (Left):	start Action\n\
	Button 2 (Middle):	force Normal Redraw (s. Main Window =>Setup)\n\
	Button 3 (Right):	test Value (same as Button 1, but\n\
				WITHOUT starting an Action, used to\n\
				find coordinates etc.)\n\n\
	If not stated otherwise, pointing or clicking in the following\n\
	means to use the Button 1.\n\n\n\
1.3	Getting Started\n\n\
	The Main Window of XDim is only a kind of Tool Box which allows\n\
	you to manipulate the data in the ACTIVE VIEWPORT. XDim works with\n\
	several viewports at the same time. To CREATE a viewport click\n\
	at the create viewport Icon (right/bottom, should look like cards\n\
	with a grid drawn on top of each other). To make a viewport\n\
	ACTIVE click inside the viewport window area. To LOAD DATA use\n\
	the File menu of a viewport.\n\n\n\
1.4	The Icons\n\n\
	The Icons in the Main Window are split into two groups:\n\
	Icons that work only on the active viewport, positioned below the\n\
	Menu Bar.\n\
	Functional Icons that are centerd in the bottom half of the window.\n\n\
	The Functional Icons:\n\n\
	Pop up Preference Window (should look like some kind of rainbow).\n\
	Create Viewport (should look like cards with a grid drawn on top\n\
		of each other). A Viewport in XDim is used to hold, display\n\
		and manipulate data. Depending on how the program is compiled\n\
		typically 32 viewports can be used at the same time.\n\n\
	The Active Viewport Icons:\n\n\
	These Icons are used to manipulate the way the data in the active\n\
	viewport is displayed. They ONLY start an action in the active\n\
	viewport, if the viewport has DATA loaded.\n\n\
	Typical actions of these Icons are:\n\n\
	Rotate Left/Right, Up/Down\n\
	Move Left/Right, Up/Down\n\
	Zoom XY +/-\n\
	Zomm Z +/-\n\n\n\
		The XDim Main Menus\n\n\
1.5	Contents\n\
\n\
	1.6	The File Menu\n\
	1.7	The Setup Menu\n\
\n\n\
1.6	The File Menu\n\
\n\
	Preferences:	load a preference file, shortcut for poping up the\n\
		preference window and using File/Load.\n\
\n\
	Quit:	Quit XDim (you might have guessed this)\n\
\n\
\n\
1.6	The Setup Menu\n\
\n\
	Use Links (Toggle Button):	XDim uses Links to link the data sets\n\
		of different viewports (p.ex. real and imaginary part of a\n\
		complex data set). If this is set to on, loading of a data\n\
		set will pop up all linked sets as well. Saving works on all\n\
		linked viewports.\n\
\n\
	Preferences:	Pop up the Preference window.\n\
\n\
	Fast Redraw / Normal Redraw:	XDim allows you to define TWO different\n\
		REDRAW routines. The name normal/fast redraw may be a bit\n\
		misleading, because if they are both set to the same redraw\n\
		type, the time taken will be the same. The idea behind this\n\
		is to use a fast (but typically less detailed/complex) routine\n\
		until everything is set up according to your needs and then\n\
		force a normal redraw (Middle Mouse Button). An other use of\n\
		this is to reduce the net load. Due to (very) limited image\n\
		processing capabilities of X11, the image is created on the\n\
		the client and then sent to the display server. Some simple\n\
		routines like GRID and LINES use the X11 draw line routine\n\
		reducing the net traffic remarkably.\n\
\n\
	Grid:	(Fast Redraw only) The area of the data, MAX and MIN value are\n\
		displayed (server draw line=> CAN`T BE EXPORTED as GIF/JPEG).\n\
\n\
	Lines:	3D Display of data set, points are connected by lines\n\
		(server draw line => CAN`T BE EXPORTED as GIF/JPEG).\n\
\n\
	Hidden:	Fast and simple hidden line algorithm. Most systems should be\n\
		able to use it as the fast redraw routine (but remember net\n\
		traffic).\n\
\n\
	Filled:	Data determines color (s. color decoding) and position of a\n\
		pixel.\n\
\n\
	Hidden&Filled:	Hidden and Filled combined in one picture.\n\
\n\
	Complex Filled:	The real part (s. viewport => setup/Links) determines\n\
		the position, the imaginary part (link name must be imag) the\n\
		color (Normal Redraw only).\n\
\n\
	Complex Hidden&Filled:	Complex Filled + Hidden Line of real part.\n\
\n\n";

static char viewportHelpText[] ="2.0	Viewports\n\
\n\
	XDim uses viewports to load, display and manipulate data. Most of\n\
	the commands work on the active viewport. A viewport is made active\n\
	by clicking on the window area (including title and menu bar).\n\
\n\
\n\
2.1	Contents\n\n\
	2.2	Layout\n\
	2.3	File Menu\n\
	2.4	Setup Menu\n\
	2.5	Data Menu\n\
\n\n\n\
2.2	Layout\n\n\
	A viewport consists of 4 areas:\n\
\n\
	A title, showing the name of the file if data is loaded.\n\
	A menu bar with File, Setup and Data.\n\
	A text area, used to send messages and in some cases errors.\n\
	A drawing area, probably with scrollbars.\n\
\n\n\n\
2.3	File Menu\n\
\n\
	Load:	Load data file\n\
	Save:	Save data file\n\
	Save as:	Save data with new name\n\
	Import:	XDim allows the import of DATA in different formats.\n\
\n\
	ASCII:	Most table calculation programs can save data in an\n\
		ASCII format, recognized separators are <tab>, < >\n\
		<;> and (s. german notation) <,> .\n\
	German Notation:	In germany the fractional part is separated\n\
		by <,> => 1,5 (german) <==> 1.5 (english). If this is set to\n\
		on <,> shouldn`t be used as a field separator (ASCII import\n\
		only).\n\
	Replace Value:	the program will read in the first line of ASCII\n\
		Data and then count the number of meaningfull values. If\n\
		some other line has fewer fields, the values are replaced\n\
		by this value.\n\
	GIF:	XDim allows you to import standard GIF pictures. But due to\n\
		the way data is processed you shouldn`t try it with a 1024x\n\
		1024 picture unless you have a very fast system. (Remember\n\
		a 200x200 picture needs 80 000 triangles to be drawn in 3D).\n\
	JPEG:	Same with JPEG format.\n\
\n\
	A comment about importing GIF`s/JPEG`s :\n\
	This program was designed to display functions z=f(x,y) not for\n\
	viewing pictures of your girl/boy-friend. While mathematical functions\n\
	are typically steady (especially if measured), pictures jump from one\n\
	color to another. The color interpolation used to draw triangles\n\
	will probably wash out all the colors leaving something like a\n\
	black and white. To turn off color interpolation use\n\
	Preference Window /Preferences/Misc/Color Decoding.\n\
\n\
	Export:	At the moment XDim does not support printing. The reason for\n\
		this is, that X11 supplies no hardware independent printer\n\
		model (X11 isn`t very good at doing anything hardware\n\
		independent). But pictures can be exported to other programs\n\
		that are able to print.\n\
	GIF:	Export the IMAGE as a GIF. GIF is a very good format to\n\
		export computer created images, because they compress very well.\n\
		Most programs working with pictures can import GIF`s.\n\
	JPEG:	Export the IMAGE as a JPEG. JPEG is a format designed for\n\
		natural pictures. Computer created images tend to loose\n\
		quality, due to the way the images are processed.\n\
	JPEG Quality:	JPEG is a lossy algorithm, you can set the image\n\
		quality in percent.\n\
	ASCII:	Export the DATA in ASCII format.\n\
	German Notation:	1.5 (english) <-> 1,5 (german) (s. import)\n\
\n\
	Close:	Close the viewport.\n\
\n\n\n\
2.4	Setup Menu\n\
\n\
	Preferences:	Just like called from the preference window. These\n\
		options work on the calling viewport only. Misc options are\n\
		not available, also the colors must be the same for all\n\
		viewports. Options set here CAN`T be SAVED.\n\
	Deco:	Pop up color decoding window. XDim uses a color decoding\n\
		vector to transform height (z) into color. The decoding\n\
		vector can be set individually for each viewport.\n\
	Cut:	Create a crossection through a data set. You have to supply\n\
		start and end point. Warning: XDim uses a link to find\n\
		the data set. If Use Links is set, a save will try to save\n\
		the cut window as well, which is impossible.\n\
	Perspective:	XDim is not very good at displaying data with\n\
		perspective, due to the simple (but fast) drawing algorithms\n\
		errors may happen. A value of 0 turns perspective off.\n\
	Aspect Ratio:	Normally the zoom factor for x and y is set to the\n\
		same value, change this by setting the aspect ratio (y/x)\n\
		here.\n\
	Links:	XDim uses Links to link data sets in different viewports.\n\
		Linked data sets can be loaded and saved at the same time.\n\
		Also some functions require linked data sets p.ex. complex\n\
		functions need a real and a imaginary part (described as real\n\
		and imag). Another example would be to load the red, green and\n\
		blue part of an image into separate viewports and link them.\n\
		Recognized by XDim are:\n\
			real <-> imag\n\
			abs <-> phi\n\
			CutWin <->CutData\n\
\n\
	Create Link:	Type in textual description of the viewport the link\n\
		is started and of the viewport the link should end. Click on\n\
		the large button named Link to Window. Now click to the\n\
		area of the viewport the link should end. Push OK Button.\n\
	Show Links:	Show available Links.\n\
	Delete Link:	Delete selected Link.\n\
\n\n\n\
2.5	The Data Menu\n\
\n\
	Redraw:	Force Normal Redraw (<=> Middle Mouse Button)\n\
	Edit (Toggle Button):	XDim has a limited data editor built in. If this\n\
		Button is set to on, every time you click at the area of the\n\
		function a window will pop up allowing you to change the value\n\
		at the specified coordinates. Pressing the right button will\n\
		only show the position and value, helping to find a specific\n\
		position/value.\n\
	Range (X/Y/Z):	Edit the range of the X/Y/Z variable (Used on the axis).\n\
	Start Value (X/Y):	Start value on X/Y axis.\n\
	End Value (X/Y):	End value on X/Y axis. Remember for n points\n\
		the distance between two points is (end-start)/(n-1).\n\
	Maximum/Minimum (Z):	Determines the way the data is DISPLAYED. If\n\
		a value is higher than Maximum or lower than Minimum it will\n\
		be cut off. These values also determine the size of the axis.\n\
		Default is the Maximum/Minimum value of the function.\n\
	Base Value:	Base for values at Axis Tics.\n\
	Dimension:	Dimension of values.\n\
\n\
\n\
	Size:	Change the number of points in X/Y direction. Two interpolation\n\
		algorithms are available.\n\
	New Width/Height:	Width/Height of new data set.\n\
	Linear:	Linear interpolation between points.\n\
	Spline:	Spline interpolation.\n\
\n\
	Hint:	If you only want to add/remove some values along the edges use\n\
		the following:\n\
		1. create a new data field of the desired size with\n\
			Data/Field/New\n\
		2. use Data/Field/Add (in the new viewport) to add these two\n\
		data sets and a data position window will pop up. (Only if the\n\
		two viewports differ in size)\n\
		3. position the first viewport in the second. Values lying\n\
		outside will be cut off.\n\
\n\
	Transform:	Functions working only on the current data set.\n\
	Mirror X:	x reversed\n\
	Mirror Y:	y reversed\n\
	Neg:		-f(x,y)\n\
	Abs,Quad,Sqrt,1/x\n\
	Log,Log10,Exp:	perform the corresponding mathematical function.\n\
	Offset:		Add a constant value.\n\
	Scale:		Multiply by a constant value.\n\
\n\
	Field:		Process Fields\n\
	New:		Create a new data set (allocated all 0.0)\n\
	Add:		Add a data set TO the current data set.\n\
	Sub:		Subtract a data set FROM the current data set.\n\
	Mul:		Multiply the current data set by a data set\n\
	Div:		Divide the current data set THROUGH a data set\n\
\n\
	All these functions have the following in common:\n\
	- Only data sets can be processed that are loaded into a viewport.\n\
	- The second viewport is selected by clicking at it``s window area.\n\
	- If the two data sets differ in size, a position window will pop up.\n\
	- To change the position of the second data set relativ to the\n\
	  calling data set fill in x/y AND press <return>\n\
\n\
	complex:	Process complex fields. A complex field consists of\n\
			data loaded into TWO viewports and linked together as\n\
			real + imag.\n\
	Real/Imag:	Create real and imaginary part from abs + phi .\n\
	Abs/Phi:	Create absolute and angle from real + imag .\n\
	Add, Sub\n\
	Mul, Div:	See processing of fields.\n\
	FFT:		Fast Fourier Transform. Zero frequcies are centered !\n\
	Inverse FFT:	Inverse FFT (you didn`t guess this, did you ??). Works\n\
			only if data is centered.\n\
\n\
	Filter:		Create some standard filter functions. The functions\n\
			are only created, to use them you have to multiply the\n\
			filter with the data set.\n\
	Lowpass:	Lowpass filters (cut off high frequencies).\n\
	Ideal:		x^2 +y^2 <= r^2 => f(x,y)=1\n\
	Butterworth:	Butterworth filter, you have to supply a radius and\n\
			the order. Low order gives round edges, High order\n\
			sharp edges.\n\
	Gauss:		e^-(x^2+y^2)\n\
\n\
	Highpass:	Highpass filters (cut off low frequencies).\n\
	Ideal, Butterworth,\n\
	Gauss:		s. Highpass only 1<->0 reversed.\n\
\n\
	Other:		Filter that don`t fit to Low-/Highpass.\n\
	Median:		The median filter is of type lowpass, but nonlinear !\n\
			Median filtering means to pick a neighbourhood of\n\
			the processed pixel, order the values and asign the\n\
			median value to the pixel. This differs from the\n\
			standard lowpass filter as edges won`t be washed\n\
			out, only spikes will be removed.\n\
	Matrix:		The matrix filter is the most versatile filter type.\n\
			Depending on how the matrix is set, it works like\n\
			a Low- or Highpass. Matrix filtering is done by\n\
			picking a neighbourhood of a pixel and asigning as the\n\
			new value the sum of the values in the neighbourhood\n\
			multiplied by the corresponding matrix values. P.ex.\n\
			all set to 1 and divide by 9 in a 3x3 neighbourhood\n\
			gives the mean value. Another example is:\n\
			-1 -1 -1\n\
			-1  8 -1 which is used in edge detection.\n\
			-1 -1 -1\n\
	Hint:	Histogramm equalisation, which is also a kind of filter, is\n\
		done by reordering the color decoding vector\n\
		(s. Color Decoding).\n\n";

static char preferenceHelpText[] =
"3.0	The Preference Window\n\
\n\
	The preference window is used to load/modify/save preferences. These\n\
	preferences are used as a template for the viewport preferences. Most\n\
	preferences are also available in viewport Setup/Preferences, only the\n\
	color palette is the same for all viewports and Misc preferences are not\n\
	accessible from the viewport (but the changes done in the viewport\n\
	window can`t be saved). The preference window consists of a menu bar\n\
	and a drawing area showing the available colors.\n\
\n\
\n\
3.1	The File Menu\n\
\n\
	Load, Save, Save as..	Load/Save/Save with new name a preference file\n\
		(preference files can be loaded from the main window File/Load\n\
		 as well).\n\
	Close		Close preference window\n\
\n\n\n\
3.2	The Edit Menu\n\
\n\
	The Edit Menu allows to edit the color palette.\n\
\n\
	New Color:	Allows to allocate a new ROW of colors. To simplify\n\
			the usage of colors, XDim allocates rows of colors\n\
			beginning at the RGB of a start color and ending at\n\
			the RGB of an end color with LINEAR interpolation.\n\
			XDim can allocate up to MAX_COL_NUMBER (in const.h)\n\
			colors independent from the capabilities of your\n\
			system and the number of free color cell entries.\n\
			Therefore the COLORS SHOWN MAY DIFFER FROM THE COLORS\n\
			INTERNALLY USED.\n\
	Start/End Color:	Set start/end RGB. To change the RGB value\n\
			click at the colored button and a RGB window will\n\
			pop up.\n\
	Number of colors:	Number of colors allocated in the row.\n\
\n\
\n\
	Change Color:	Change RGB of allocated colors. A color select window\n\
			will pop up allowing to select a row by clicking at\n\
			the drawing area.\n\
	Start/End Color:	Set start/end RGB. Number of colors is NOT\n\
			editable.\n\
\n\
	Delete Color:	Delete a row of colors.\n\
\n\n\
3.3	The Preference Menu\n\
\n\
	The preferences changed here are used as a template for the viewport\n\
	preferences. Only changes done here can be saved.\n\
\n\
	Window:\n\
	Window Width/Height:	Size of the window on your screen\n\
	Picture Width/Height:	Size of the image internally used.\n\
	Background Color:	Select window background color.\n\
\n\
	Grid:		Grid prefences define the behaviour of lines drawn\n\
			in the line modi AND of the axis.\n\
	Draw Axis:	Toggle Button, draw axis when a normal redraw is\n\
			requested.\n\
	Draw Axis Text:	Toggle Button, draw dimension/base value on axis.\n\
	Grid Step:	Use every nth point in line redraw modi, for large\n\
			data sets it is usefull to redraw p.ex. every 2.\n\
			point only.\n\
	Grid Color:	Color used in line redraw modi.\n\
	Number of TICS on axis:\n\
	X/Y/Z	:	markers on X/Y/Z axis\n\
	Axis Color\n\
	Axis Background Color:	In filled redraw modi a background color for\n\
			the axis is available.\n\
\n\
	Movement:	Change the bahaviour of the buttons in the main window.\n\
	Time Interval (ms):	While pressing the buttons in the main window\n\
			a timer is used to set the next redraw request.\n\
			Only usefull if set to a value bigger than the time taken\n\
			for a redraw request.\n\
	Zoom Factor:	Zoom in with this factor.\n\
	Rotation Angle:	Rotate by this angle (in Rad).\n\
	Movement X,Y:	Used as Delta X,Y\n\
\n\
	Misc:		Only available from the preference window.\n\
	Font Name:	Name of the to use on axis.\n\
	Font Color\n\
	Interpolate Colors:	Toggle Button, if set to on XDim will use\n\
			the entries in the decoding vector to interpolate\n\
			between colors. Should be set to off if imported\n\
			pictures like GIF`s or JPEG`s are used.\n\
	Start/End Color:	Default start/end color for color decoding.\n\
\n\n";

static char decodingHelpText[] = "4.0	The Color Decoding Window\n\
\n\
	XDim uses a color decoding vector to covert height to color. While\n\
	the color palette is the same for all viewports, the color decoding\n\
	vector can be set individually for each viewport. Remember that for\n\
	typical applications, there are (much) more decoding entries than\n\
	pixels on the output media (s. coor.h MAX_DECO_NUMBER) p.ex 8192,\n\
	so some decoding entries will be skipped.\n\
\n\
\n\
4.1	Layout\n\
\n\
	The color decoding window consists of 4 parts:\n\
	The menu bar, a message line, a zoomed color decoding vector and the\n\
	full decoding vector.\n\n\
4.2	The Edit Menu\n\
\n\
	Zoom +/- :	Zoom in/out in the zoomed window.\n\
	Draw :		Fill an area with a color. First select the color in\n\
			the color select window. To fill an area with this\n\
			color press mouse button 1 and move the mouse either\n\
			in the zoomed or the normal decoding area. After the\n\
			button is released the selected area should be filled.\n\
			Pressing mouse button 3 will show the position.\n\
	Iso :		Produce lines at constant height differences. ( Entries\n\
			per line means entries into the decoding vector for\n\
			every iso line, should normally be >> 1).\n\
	Reset:		Reset decoding vector, the decoding vector is built\n\
			linear between start and end color.\n\
	Histogram:	Histogram equalization. The decoding vector ist built\n\
			nonlinear to equalize the probabilities of data values.\n\
			To say it simple, in the range where a lot of values\n\
			are located, a lot of colors are allocated. Used as a\n\
			kind of filter in picture processing (s. viewport\n\
			Data/Filter).\n\n\n";

static char errorHelpText[] = "5.0	Errors & Messages\n\n\
	Errors:	 	Displayed in a separate popup window\n\
	Messages:	Displayed in a frame at the top of a viewport\n\n\
	Errors:\n\n\
	Couldn`t allocate xx bytes of memory\n\n\
	Status:	Severe Error\n\
	To Do:	Something went terribly wrong, try to free memory by closing\n\
		viewports etc. If this happens very often talk to your\n\
		system manager and/or the person who compiled XDim.\n\n\
	No viewport available\n\n\
	Status:	Error\n\
	To Do:	A viewport was killed while XDim was processing data. Create\n\
		a new viewport and start procssing again.\n\n\
	To do spline interpolation n must be > 2\n\n\
	Status:	User Error\n\
	To Do:	Spline interpolation needs at least two points. Use Linear\n\
		interpolation to create at least one other point and use\n\
		spline again.\n\n\
	Couldn`t open name for read access\n\n\
	Status:	Error\n\
	To Do:	XDim was not allowed to read the specified file. Typical\n\
		reasons are no read access to directory/file or syntax error\n\
		in the name.\n\n\
	Couldn`t open name for write access\n\n\
	Status:	Error\n\
	To Do:	XDim was not allowed to write to the specified file. Typical\n\
		reasons are no write access to directory/file, disk full\n\
		or syntax error in the name.\n\n\
	No XDim data file\n\n\
	Status:	User Error\n\
	To Do:	XDim couldn`t recognize the file as a XDim data file.\n\
		Either the file is no data file or it is corrupt.\n\n\
	No XDim preference file\n\n\
	Status:	User Error\n\
	To Do:	XDim couldn`t recognize the file as a XDim preference file.\n\
		Either the file is no preference file or it is corrupt.\n\n\
	No XDim decoding file\n\n\
	Errors & Messages\n\n\
	Status:	User Error\n\
	To Do:	XDim couldn`t recognize the file as a XDim decoding file.\n\
		Either the file is no decoding file or it is corrupt.\n\n\
	Syntax error near:\n\n\
	Status: Error\n\
	To Do:	A syntax error in a XDim preference, deco or data file was\n\
		found. Use an editor to locate the error.\n\n\
	Unexpected EOF !!\n\n\
	Status:	Error\n\
	To Do:	The data or decoding file ended unexpected. An example would\n\
		be to set the width: 10 and height: 20 but only 100 data\n\
		values are found in the file.\n\n\
	No data field available to save\n\n\
	Status: User Error\n\
	To Do:	XDim was ordered to save in a viewport where no data field is\n\
		available.\n\n\
	Sorry couldn`t import this format !!\n\n\
	Status:	Error\n\
	To Do:	During ASCII import the first line that doesn`t start with a #\n\
		is supposed to contain data values separated by < >, <,>, <;>\n\
		<tab> or <:>.\n\n\
	No picture available to export\n\n\
	Status:	Severe error\n\
	To Do:	As an image is ALWAYS asigned to a viewport, this should\n\
		only happen if something went terribly wrong (p.ex. not\n\
		enough memory).\n\n\
	Could not locate a link described as name !\n\n\
	Status:	User Error\n\
	To Do :	Some functions need special links to work correctly. Allocate\n\
		a link called name to a viewport before execution.\n\n\
	Errors & Messages Part 3\n\n\
	Select second operand with valid data field first\n\n\
	Status: User Error\n\
	To Do:	Data Add,Subtract, Muiltiply and Divide need two viewports\n\
		with a valid data field. The second viewport is selected\n\
		by click at it`s window area.\n\n\
	Couldn`t locate the default font\n\n\
	Status: Severe Error\n\
	To Do:	Normally XDim uses the motif default font, somehow this font\n\
		couldn`t be found. Try Preferences Setup/misc/Font Name.\n\n\
	Couldn`t load the given font (try xlsfonts)\n\n\
	Status:	User Error\n\
	To Do:	The font given was not found on your system. Try xlsfonts to\n\
		get a list of available fonts.\n\n\
	The number of colors must be 0< n < num\n\n\
	Status:	Error\n\
	To Do:	The available number of colors on your system is decided at\n\
		compile time. Use less colors than num.\n\n\
	To calculate a HISTOGRAM, a data field must be loaded\n\n\
	Status:	User Error\n\
	To Do:	A histogram is calculated by counting the data values in a\n\
		certain range. Load a data field to calculate a histogram.\n\n\
	Couldn`t allocate a correct XImage structure\n\n\
	Status: Severe Error\n\
	To Do:	An XImage structure to store the output couldn`t be allocated.\n\
		Possible reasons are a lack of memory etc., check Width and\n\
		Height setting.\n\n\
	Failed to allocate Edit Matrix\n\n\
	Status: Severe Error\n\
	To Do:	The Edit Matrix for the matrix filter couldn`t be allocated.\n\
		Probably there is not enough memory etc., check width, height.\n\n\
	There are also a lot of syntax/user error messages in input windows, or\n\
	for loading which are (hopefully) self explanatory. To check errors in\n\
	files use a standard text editor, the format is a simple ASCII.\n\n\
	Mail severe Errors/Bugs to:\n\n\
	benzing@iegi03.etec.uni-karlsruhe.de\n\n\n";

#endif /* _DHELP_H */
