/****************************************************************/
/*								*/
/* hwx11.h:	hardware depending stuff			*/
/*		X11 version					*/
/*								*/
/*		Design: Walter Benzing 1994			*/
/*								*/
/****************************************************************/

#ifndef _HWX11_H
#define _HWX11_H

/* defines */
#define HW_COLORFREE 0
#define HW_COLORCLAIMED 1
#define HW_COLORUSED 2

typedef struct
   {
    Display *dpy;		/* Display */
    Visual *vis;		/* Visual */
    XImage *XIm;		/* Image to put to the screen */
    int bits_per_pixel;		/* bits per image data */
    int screen;			/* screen number */
    int screenWidth;		/* screen width */
    int screenHeight;		/* screen height */
    Colormap cmap;		/* color map */
    GC gc;			/* graphic context */
    GC textGC;			/* GC for text output */
    GC binGC;			/* GC for bin output */
    GC clearBinGC;		/* GC for clearing bin output */
    Boolean defaultFont;	/* is it the default font ? */
    XFontStruct *font;		/* information about the loaded font */
    /*int numColors;		/* maximum number of colors */
    int availableColors;	/* Total number of allocated colors */
    Boolean ReadWrite;		/* ReadWrite color cells */
    unsigned char colStat[MAX_COL_NUMBER];	/* Color allocated ? */
    unsigned char red[MAX_COL_NUMBER];		/* Allocated red */
    unsigned char green[MAX_COL_NUMBER];	/* Allocated green */
    unsigned char blue[MAX_COL_NUMBER];		/* Allocated blue */
   } XDHardwareInfo;

/* these definitions are hardware dependent */
/* adjust them if you need, they adjust the depth */
/* myPixel to the depth of the visual */

#ifdef D32
typedef unsigned myINT32 myPixel;
#else
#ifdef D16
typedef unsigned myINT16 myPixel;
#else
typedef unsigned myINT8 myPixel;
#endif /* D16 */
#endif /* D32 */

#endif /* _HWX11_H */
