/****************************************************************/
/*								*/
/* macros.h:	the name says it all				*/
/*								*/
/*		Design: Walter Benzing 1994			*/
/*		NO RIGHTS RESERVED				*/
/*								*/
/****************************************************************/

#ifndef _macros_h
#define _macros_h

/*
 * Calculates the next index in the color translation table 
 */

#define MNextColIndex(index, maxWanted, maxAvailable)\
  ((maxAvailable) > (maxWanted) ? (True) :\
                (((Index)*(maxAvailable))/(maxWanted)))

#define Mmin(a,b) ((a) > (b) ? (b) : (a))
#define Mmin3(a,b,c) ((a) > (b) ? Mmin((b),(c)) : Mmin((a),(c)))
#define Mmax(a,b) ((a) > (b) ? (a) : (b))
#define Mmax3(a,b,c) ((a) > (b) ? Mmax((a),(c)) : Mmax((b),(c)))
#define Mminmax(a,min,max) ((a) < (min) ? (min) : ((a) > (max) ? (max) : (a)))

#ifdef PICUP
#define Mupdown(y,height) (y)
#else
#define Mupdown(y,height) (height-(y))
#endif /* PICUP */


#endif /* _macros_h */
