/****************************************************************/
/*								*/
/* xdim.c:	main program for xdim				*/
/*		mainly the user interface			*/
/*								*/
/*		ALL the motif calls are in xdmotif.c		*/
/*		ONLY Xt stuff here !				*/
/*								*/
/*		Design: Walter Benzing 1994			*/
/*		NO RIGHTS RESERVED				*/
/*								*/
/****************************************************************/

#define _MAIN		/* main modul */

/*my includes */
#include "xdim.h"

/*
 * Exit from XDim
 */
void XD_GoodBye(void)
  {
   exit(0);
  }
/*
 * Quit button callback function
 */

void XD_Quit(Widget w, XtPointer client_data, XtPointer call_data)
  { 
   XD_GoodBye(); 
  }

XDimInfo XDim;

int main(int argc, char **argv)
   {
    Widget topLevel;

    /*
     * check variables
     */
    if((sizeof(myINT8)<<CHAR2BITS) != 8 ||
       (sizeof(myINT16)<<CHAR2BITS) != 16 ||
       (sizeof(myINT32)<<CHAR2BITS) != 32)
       {
        printf("Something is wrong with the integer settings in const.h\n");
        printf("Make sure you do either a\n\n\
		make depend\n\n\
			OR\n\n\
		make clean\n\nBEFORE recompiling\n");
	exit(-1);
       }

    /*
     * Register the default language procedure
     *
     * XtSetLanguageProc(NULL, (XtLanguageProc)NULL, NULL);
     *
     * some systems seem to have trouble with this, as it does
     * nothing I know of, I've removed it
     */

    /*
     * Initialize Application Context
     */
    topLevel = XtVaAppInitialize(
            &(XDim.myWidgets.XDimContext),	/* Application context */
            "XDim",                 /* Application class */
            NULL, 0,                /* command line option list */
            &argc, argv,            /* command line args */
            NULL,                   /* for missing app-defaults file */
            NULL);                  /* terminate varargs list */
    XDim.myWidgets.topLevel = topLevel;
    /*
     * Init Graphics
     */ 
    XDim.hwInfo.dpy = XtDisplay(topLevel);
    GR_InitGraphics(&XDim);
    /*
     * Create Position Select
     */
    WD_CreatePos(topLevel, &XDim);
    /*
     * Create Cut Window
     */
    WD_CreateCut(topLevel, &XDim);
    /*
     * Create Math
     */
    WD_CreateMath(topLevel, &XDim);
    /*
     * Create Mainwindow Widgets and Initialization of some Widgets
     */
    WD_CreateMain(topLevel, &XDim);
    /*
     * Create Help Windows
     */
    WD_CreateHelp(topLevel, &XDim);
    /*
     * Init Text output (font's)
     */
    WD_InitFont(&XDim);
    /*
     * Create Color Window Widgets
    */
    WD_CreateColors(topLevel, &XDim);
    /*
     * Create Import Export
     */
    WD_CreateImEx(topLevel, &XDim);
    /*
     * Create Deco Window Widgets
     */
    WD_CreateEditDeco(topLevel, &XDim);
    /*
     * Create Link Window
     */
    WD_CreateLink(topLevel, &XDim);
    /*
     *  Create windows for widgets and map them.
     */
    strcpy(XDim.mess,"Welcome to XDim !!!!");
    WD_XDimMessage(&XDim);
    XtRealizeWidget(topLevel);
    /*
     *  Loop for events, from now on we will communicate
     *  only by callbacks !!!!
     */

    XtAppMainLoop(XDim.myWidgets.XDimContext);
 return(1);
}
