/****************************************************************/
/*								*/
/* xdim.h:	main include file for xdim			*/
/*		includes a lot of other files			*/
/*								*/
/*		Design: Walter Benzing 1994			*/
/*		NO RIGHTS RESERVED				*/
/*								*/
/****************************************************************/

#ifndef _XDIM_H
#define _XDIM_H


/* standard includes */
#include <stdio.h>

/* X11-includes */
#include <X11/Xlib.h>

/*includes for the X11 toolkit*/
#include <X11/Intrinsic.h>  /* Intrinsics Definitions */

enum XDFilter {IdealL, IdealH, ButwL, ButwH, GaussL, GaussH};

typedef void (*XDimRetFunc)(int, void *, void *);


/* my includes */

#include "const.h"
#include "hwx11.h"
#include "macros.h"
#include "xdwidget.h"
#include "coor.h"
#include "grfx.h"

/* structures */

typedef char myString[MAX_NAME_LENGTH];

typedef char *funcCast;			/* trick out ANSI compiler */

typedef struct XDI *XDIP;

typedef struct XDI
   {
    char mess[MAX_NAME_LENGTH];
    char error[MAX_NAME_LENGTH];
    int port;				/* viewport in usage */
    void (*ClearFast)(Window, ViewportInfo* , XDIP);
    void (*FastRedraw)(Window , ViewportInfo* , ViewportInfo*, XDIP);
    void (*ClearNormal)(Window, ViewportInfo* , XDIP);
    void (*NormalRedraw)(Window , ViewportInfo* , ViewportInfo*, XDIP);
    XDimWidgets myWidgets;		/* Widgets for xdim */
    XDColorInfo colors;			/* colors */
    XDHardwareInfo hwInfo;		/* hardware information */
    AllViewports aView;			/* information for all viewports */
    ViewportInfo Views[MAX_VIEWPORT_NUMBER];	/* viewport information */
    Boolean RecSave;		/* Recursive save ? */
    int RecPort;		/* Viewport called for recursive save */
    int ActRectPort;		/* last port recursively checked */
    Boolean useLinks;		/* use links for load,save,add... */
    Boolean link2Window;	/* link to next window pointed to */
    Boolean createLast;		/* create a zero card */
    XDLink hLink;
    Boolean math;		/* math operation */
    int oper1;			/* port of oper1 */
    int oper2;			/* port of oper2 */
   } XDimInfo;

#include "ext.h"

#endif /* _XDIM_H */
