/****************************************************************/
/*								*/
/* xdmotif.c:	stuff that depends on the			*/
/*		motif widget set				*/
/*								*/
/*		Design: Walter Benzing 1994			*/
/*		NO RIGHTS RESERVED				*/
/*								*/
/****************************************************************/

/*
 * undefine the symbol DEC if you don't want to use the DXM library
 * but normally the Imake should take care of this
 * #undef DEC
 */


/* standard includes */
#include <stdio.h>
#include <limits.h>
#include <math.h>

/*includes for the X11 toolkit*/
#include <X11/Intrinsic.h>  /* Intrinsics Definitions */
#include <X11/Shell.h>      /* Top Level Shell Widget */

/*includes for motif*/
#include <Xm/Xm.h>  /* Standard Motif definitions */
#include <Xm/RowColumn.h> /*Motif RowColumn Widget */
#include <Xm/Label.h>	/*Label Widget*/
#include <Xm/PushB.h>    /* Motif PushButton Widget */
#include <Xm/CascadeB.h> /* Motif Cascade Button */
#include <Xm/Form.h>     /* Form Widget */
#include <Xm/Frame.h>    /* Frame Widget */
#include <Xm/DrawingA.h> /* Drawing area */
#include <Xm/TextF.h>	/* Text Field */
#include <Xm/Text.h>	/* Text window */
#include <Xm/FileSB.h>  /* File seletion box */
#include <Xm/SeparatoG.h> /* separators */
#include <Xm/MessageB.h> /* message box */
#include <Xm/ScrollBar.h> /* scroll bar */
#include <Xm/ScrolledW.h> /* scrolled window */
#include <Xm/DialogS.h>	  /*Dialog Shell */
#include <Xm/Scale.h>	  /* slides */
#include <Xm/ToggleBG.h>  /* toggle button gadget */

/* DEC specific includes */

#ifdef DEC

#include <DXm/DECspecific.h>
#include <DXm/DXmColor.h>	/* color mixing widget */

#endif /* DEC */

/*my includes */
#include "xdim.h"
#include "bit.bmp"

/* help text */
#include "help.h"


/*
 * Send a message to the main window
 */

void WD_XDimMessage(XDimInfo *XDim)
   {
    XmString Mess;

    Mess = XmStringCreateSimple(XDim->mess);
    XtVaSetValues((XDim->myWidgets).MainMessage,
	XmNlabelString, Mess,
	NULL);
    XmStringFree(Mess);
   }


/*
 * Send a message to a viewport
 */

void WD_ViewportMessage(ViewportInfo *view, XDimInfo *XDim)
   {
    XmString Mess;

    Mess = XmStringCreateSimple(XDim->mess);
    XtVaSetValues(((XDim->myWidgets).Views)[view->port].ViewStat,
	XmNlabelString, Mess,
	NULL);
    XmStringFree(Mess);
   }

/*
 * Create an error pop up box
 */

void WD_XDimError(XDimInfo *XDim, Widget w)
   {
    XmString Err;
    XDimWidgets *XDW;
    
    XDW = &(XDim->myWidgets);
    XDW->ErrorReason = w;
    if(w)
       XtSetSensitive(w, False);
    Err = XmStringCreateSimple(XDim->error);
    XtVaSetValues(XDW->ErrorBox,
	XmNmessageString, Err,
	NULL);
    XmStringFree(Err);   
    XtManageChild(XDW->ErrorBox);
   }

/*
 * return to normal after an error
 */

void WD_XDimErrorOk(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimWidgets *XDW;
    
    XDW = &(((XDimInfo*)client_data)->myWidgets);
    if(XDW->ErrorReason)
       XtSetSensitive(XDW->ErrorReason, True);
    XtUnmanageChild(XDW->ErrorBox);
   }

/*
 * Set flags
 */

void WD_SetFlag(Widget w, XtPointer client_data, XtPointer call_data)
   {
    *((Boolean *)client_data) = ((XmToggleButtonCallbackStruct *)call_data)->set;
   }


/*
 * Set edit flag
 */

void WD_SetEdit(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    
    XDim = (XDimInfo *) client_data;
    if(XDim->port >= 0)
     ((XDim->Views)[XDim->port]).edit =
	((XmToggleButtonCallbackStruct *)call_data)->set;
   }

/*
 * Zoom in/out on zoomed deco window
 */

void WD_DecoZoom(double zoom, XDimInfo *XDim)
   {
    ViewportInfo *XDV;
    XDimDeco *XDD;
    int del,mi;
    
    XDV = &((XDim->Views)[XDim->port]);
    XDD = &((XDim->myWidgets).DecoEdit);
    XDim->aView.draw = False;
    del = zoom*(XDV->eZoom-XDV->sZoom);
    if(del < MAX_DECO_NUMBER >> 5)
      del = MAX_DECO_NUMBER >> 5;
    if(del > MAX_DECO_NUMBER)
      del = MAX_DECO_NUMBER;
    mi = (XDV->eZoom+XDV->sZoom) >> 1;
    XDV->sZoom = mi - (del >> 1);
    if(XDV->sZoom < 0)
      XDV->sZoom = 0;
    XDV->eZoom = XDV->sZoom + del;
    if(XDV->eZoom > MAX_DECO_NUMBER)
      {
       XDV->eZoom = MAX_DECO_NUMBER;
       XDV->sZoom = XDV->eZoom-del;
      }
    del = XDV->eZoom -XDV->sZoom;
    XtVaSetValues(XDD->SZoom,
     XmNsliderSize, del,
     XmNpageIncrement, del>>1,
     XmNincrement, del>>4,
     XmNvalue, XDV->sZoom,
     NULL);
    XT_RedrawZoomedDeco(XDD->DZoom, XDim, NULL);
   }
/*
 * zoom out zoomed deco window
 */

void WD_DecoZoomOut(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    
    XDim = (XDimInfo *) client_data;
    if(XDim->port >= 0)
      WD_DecoZoom(((XDim->Views)[XDim->port]).zoom, XDim);
   }

/*
 * zoom in zoomed deco window
 */

void WD_DecoZoomIn(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    
    XDim = (XDimInfo *) client_data;
    if(XDim->port >= 0)
      WD_DecoZoom(1.0/((XDim->Views)[XDim->port]).zoom, XDim);
   }

/*
 * scroll zoomed window of deco edit
 */

void WD_ScrollZoomedDeco(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    ViewportInfo *XDV;
    int del;
    
    XDim = (XDimInfo *) client_data;
    if(XDim->port >=0)
      {
       XDV = &((XDim->Views)[XDim->port]);
       del = XDV->sZoom;
       XDV->sZoom = ((XmScrollBarCallbackStruct *)call_data)->value;
       XDV->eZoom += (XDV->sZoom-del);
       if(XDV->eZoom > MAX_DECO_NUMBER)
         XDV->eZoom = MAX_DECO_NUMBER;
       XT_RedrawZoomedDeco((XDim->myWidgets).DecoEdit.DZoom, client_data, NULL);
      }
   }

/*
 * reset decoding vector
 */

void WD_ManageResetDeco(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    ViewportInfo *VWI;
    XDimDeco *XDD;
    Pixel *trans;

    XDim = (XDimInfo *) client_data;
    if(XDim->port >= 0)
      {
       VWI = &((XDim->Views)[XDim->port]);
       XDD = &((XDim->myWidgets).DecoEdit);       
       trans = (XDim->colors).colTrans;
       XDim->aView.colS = VWI->colS;
       XDim->aView.colE = VWI->colE;
       XDim->aView.draw = False;
       XtVaSetValues(XDD->areaC1Col,
    		XtNbackground, trans[VWI->colS],
    		NULL);
       XtVaSetValues(XDD->areaC2Col,
    		XtNbackground, trans[VWI->colE],
    		NULL);
       if(XtIsManaged(XDD->areaShell))
         XtUnmanageChild(XDD->areaShell);
       XtManageChild(XDD->areaShell);
      }
   }

/*
 * do iso lines
 */

void WD_ManageIsoDeco(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    XDimDeco *XDD;
    XDColorInfo *XDC;

    XDim = (XDimInfo *) client_data;
    if(XDim->port >= 0)
      {
       XDD = &((XDim->myWidgets).DecoEdit);       
       XDC = &(XDim->colors);
       XDim->aView.draw = False;
       XDim->aView.drawColor = ((XDim->Views)[XDim->port]).fore;
       XtVaSetValues(XDD->isoCol,
    		XtNbackground, (XDC->colTrans)[XDim->aView.drawColor],
    		NULL);
       if(XtIsManaged(XDD->isoShell))
         XtUnmanageChild(XDD->isoShell);
       XtManageChild(XDD->isoShell);
      }
   }

/*
 * callback for ok in iso lines
 */

void WD_okIsoDeco(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    XDColorInfo *XDC;
    XDimDeco *XDD;
    ViewportInfo *VWI;
    char *val;
    double start, end, delta;
    int i, j, ind, num, st, line;
    myPixel col1,*deco;

    XDim = (XDimInfo*) client_data;
    if(XDim->port >=0)
      {
       VWI = &((XDim->Views)[XDim->port]);
       XDD = &((XDim->myWidgets).DecoEdit);
       XDC = &(XDim->colors);
       val = XmTextFieldGetString(XDD->isoSEdit);
       if(!sscanf(val,"%le",&start))
	 {
	  sprintf(XDim->error, "You have to supply the first line entry");
	  WD_XDimError(XDim, XDD->isoShell);
	  return;
	 }
       XtFree(val);
       if(start < 0.0 || start >100.0)
	 {
	  sprintf(XDim->error, "first line must be between 0%% and 100%%");
	  WD_XDimError(XDim, XDD->isoShell);
	  return;
	 } 
       val = XmTextFieldGetString(XDD->isoEEdit);
       if(!sscanf(val,"%le",&end))
	 {
	  sprintf(XDim->error, "You have to supply the last line entry");
	  WD_XDimError(XDim, XDD->isoShell);
	  return;
	 }
       XtFree(val);
       if(end < start || end >100.0)
	 {
	  sprintf(XDim->error, "last line must be between %f%% and 100%%",start);
	  WD_XDimError(XDim, XDD->isoShell);
	  return;
	 } 
       val = XmTextFieldGetString(XDD->isoNEdit);
       if(!sscanf(val,"%d",&num))
	 {
	  sprintf(XDim->error, "You have to supply the number of lines");
	  WD_XDimError(XDim, XDD->isoShell);
	  return;
	 }
       XtFree(val);
       if(num < 1 || num >1000)
	 {
	  sprintf(XDim->error, "Number of lines must be between 0 and 1000");
	  WD_XDimError(XDim, XDD->isoShell);
	  return;
	 } 
       val = XmTextFieldGetString(XDD->isoDEdit);
       if(!sscanf(val,"%d",&line))
	 {
	  sprintf(XDim->error, "You have to supply the number entries per line");
	  WD_XDimError(XDim, XDD->isoShell);
	  return;
	 }
       XtFree(val);
       if(line < 1 || line >1000)
	 {
	  sprintf(XDim->error, "Number of entries per line must be between 0 and 1000");
	  WD_XDimError(XDim, XDD->isoShell);
	  return;
	 } 
       col1 = XDim->aView.drawColor;
       deco = VWI->deco;
       if(num>1)
         delta = MAX_DECO_NUMBER*(end-start)/((num-1)*100.0);
       else
         delta = 0.0;
       st = (start*MAX_DECO_NUMBER/100.0)-(line>>1);
       for(i=0; i<num; i++)
          {
           ind = ((double)i*delta)+st;
           for(j=ind+line-1;j>=ind; j--)
              {
               if(j >=0 && j < MAX_DECO_NUMBER)
                 deco[j] = col1;
              }
          }
       VWI->changed |= TRANS_AND_CHANGE;
       XtUnmanageChild(XDD->isoShell);
       XT_RedrawZoomedDeco(XDD->DZoom, XDim, NULL);
       XT_RedrawDecoVector(XDD->DArea, XDim, NULL);
       XT_Redraw((((XDim->myWidgets).Views)[XDim->port]).DArea,
	     (XtPointer)(VWI), NULL);
      }
   }

/*
 * set iso line color
 */

void WD_okSelectIsoDeco(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    XDColorInfo *XDC;

    XDim = (XDimInfo *) client_data;
    XDC = &(XDim->colors);
    XDim->aView.drawColor = XDC->selected;
    XtVaSetValues((XDim->myWidgets).DecoEdit.isoCol,
    		XtNbackground, (XDC->colTrans)[XDC->selected],
    		NULL);
    XtPopdown((XDim->myWidgets).ColorSelect.ColorShell);
   }

/*
 * select colors for iso lines
 */
 
void WD_SelectIsoDeco(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    XDimColorSelect *XDS;
    XDColorInfo *XDC;
    XmString Mess;

    XDim = (XDimInfo*) client_data;
    XDC = &(XDim->colors);
    XDS = &((XDim->myWidgets).ColorSelect);
    if(XDS->activeCallback)
       XtRemoveCallback(XDS->ok, XmNactivateCallback,
	  XDS->activeCallback, XDS->client_data);
    XtAddCallback(XDS->ok, XmNactivateCallback,
	WD_okSelectIsoDeco, XDim);
    XDS->activeCallback = WD_okSelectIsoDeco;
    Mess = XmStringCreateSimple("Select color for iso lines");
    XtVaSetValues(XDS->ColorMessage,
	XmNlabelString, Mess,
	NULL);
    XmStringFree(Mess);
    XDS->client_data = XDim;
    XDC->single = True;
    XDC->selected = XDim->aView.drawColor;
    XtPopup(XDS->ColorShell, XtGrabNone);
   }

/*
 * Redraw reset deco after palette changed
 */

void WD_ReInitDeco(XDimInfo *XDim)
   {
    XDimDeco *XDD;
    XDColorInfo *XDC;

    XDD = &((XDim->myWidgets).DecoEdit);       
    XDC = &(XDim->colors);
    XDim->aView.colE = XDC->colE;
    XDim->aView.colS = XDC->colS;
    XDim->aView.draw = False;
    if(XtIsManaged(XDD->areaShell))
       WD_ManageResetDeco(NULL, XDim, NULL);    
    if(XtIsManaged(XDD->isoShell))
       WD_ManageIsoDeco(NULL, XDim, NULL);    
   }

/*
 * set background of widget
 */
 
void WD_SetBackground(Widget back, XDColorInfo *XDC)
  {
   XtVaSetValues(back,
	XmNbackground, (XDC->colTrans)[XDC->back],
	NULL);
  }

/*
 * reset decoding vector
 */

void WD_okResetDeco(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    ViewportInfo *VWI;
    XDimDeco *XDD;

    XDim = (XDimInfo *) client_data;
    if(XDim->port >= 0)
      {
       VWI = &((XDim->Views)[XDim->port]);
       XDD = &((XDim->myWidgets).DecoEdit);       
       if(XDim->aView.colS <= XDim->aView.colE)
         {
	  VWI->colS = XDim->aView.colS;
	  VWI->colE = XDim->aView.colE;
	 }
       else
         {
	  VWI->colS = XDim->aView.colE;
	  VWI->colE = XDim->aView.colS;
	 }
       VWI->changed |= TRANS_AND_CHANGE;
       XtUnmanageChild(XDD->areaShell);
       GR_InitDeco(VWI->deco, VWI->colS, VWI->colE);
       XT_RedrawZoomedDeco(XDD->DZoom, XDim, NULL);
       XT_RedrawDecoVector(XDD->DArea, XDim, NULL);
       XT_Redraw((((XDim->myWidgets).Views)[XDim->port]).DArea,
	     (XtPointer)(VWI), NULL);
      }
   }

/*
 * set start deco
 */

void WD_okSelectStartDeco(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    XDColorInfo *XDC;

    XDim = (XDimInfo *) client_data;
    XDC = &(XDim->colors);
    XDim->aView.colS = XDC->selected;
    XtVaSetValues((XDim->myWidgets).DecoEdit.areaC1Col,
    		XtNbackground, (XDC->colTrans)[XDC->selected],
    		NULL);
    XtPopdown((XDim->myWidgets).ColorSelect.ColorShell);
   }

/*
 * set end deco
 */

void WD_okSelectEndDeco(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    XDColorInfo *XDC;

    XDim = (XDimInfo *) client_data;
    XDC = &(XDim->colors);
    XDim->aView.colE = XDC->selected;
    XtVaSetValues((XDim->myWidgets).DecoEdit.areaC2Col,
    		XtNbackground, (XDC->colTrans)[XDC->selected],
    		NULL);
    XtPopdown((XDim->myWidgets).ColorSelect.ColorShell);
   }

/*
 * select colors for reset
 */
 
void WD_Select2ResetDeco(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    XDimColorSelect *XDS;
    XDColorInfo *XDC;
    XmString Mess;

    XDim = (XDimInfo*) client_data;
    XDC = &(XDim->colors);
    XDS = &((XDim->myWidgets).ColorSelect);
    if(XDS->activeCallback)
       XtRemoveCallback(XDS->ok, XmNactivateCallback,
	  XDS->activeCallback, XDS->client_data);
    if(w == (XDim->myWidgets).DecoEdit.areaC1Col)
      {
       Mess = XmStringCreateSimple("Select start color");
       XtAddCallback(XDS->ok, XmNactivateCallback,
                      WD_okSelectStartDeco, XDim);
       XDS->activeCallback = WD_okSelectStartDeco;
      }
    else
      {
       Mess = XmStringCreateSimple("Select end color");
       XtAddCallback(XDS->ok, XmNactivateCallback,
                      WD_okSelectEndDeco, XDim);
       XDS->activeCallback = WD_okSelectEndDeco;
      }
    XtVaSetValues(XDS->ColorMessage,
	XmNlabelString, Mess,
	NULL);
    XmStringFree(Mess);
    XDS->client_data = XDim;
    XDC->single = True;
    XDC->selected = 0;
    XtPopup(XDS->ColorShell, XtGrabNone);
   }

/*
 * activate drawing deco mode
 */

void WD_okDrawDeco(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XmString Mess;
    XDimInfo *XDim;
 
    XDim = (XDimInfo *) client_data;
    XtPopdown((XDim->myWidgets).ColorSelect.ColorShell);
    Mess = XmStringCreateSimple("Use button1 to draw");
    XtVaSetValues((XDim->myWidgets).DecoEdit.Label,
	XmNlabelString, Mess,
	NULL);
    XmStringFree(Mess);
    XDim->aView.draw = True;
    XDim->aView.drawColor =  (XDim->colors).selected;
   }

/*
 * Callback for draw deco
 */
 
void WD_Select2DrawDeco(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    XDimColorSelect *XDS;
    XDColorInfo *XDC;
    XmString Mess;

    XDim = (XDimInfo*) client_data;
    XDC = &(XDim->colors);
    XDS = &((XDim->myWidgets).ColorSelect);
    Mess = XmStringCreateSimple("Select color to draw with");
    XtVaSetValues(XDS->ColorMessage,
	XmNlabelString, Mess,
	NULL);
    XmStringFree(Mess);
    if(XDS->activeCallback)
       XtRemoveCallback(XDS->ok, XmNactivateCallback,
	  XDS->activeCallback, XDS->client_data);
    XtAddCallback(XDS->ok, XmNactivateCallback,
                   WD_okDrawDeco, XDim);
    XDS->activeCallback = WD_okDrawDeco;
    XDS->client_data = XDim;
    XDC->single = True;
    XDC->selected = 0;
    XtPopup(XDS->ColorShell, XtGrabNone);
   }

/*
 * calculate position in decoding vector
 */

void WD_ShowDecoPosition(Widget w, Widget l, int x0, int y0, int sX, int eX,
		int type, XDimInfo *XDim)
   {
    Window win;
    XmString Mess;
    ViewportInfo *VWI;
    Dimension width, height;
    int i,x;
    myPixel col1, *dec;
    double pos;
    static char buf[32];
 
    win =XtWindow(w);
    if(win )
      {
       XtVaGetValues(w,
    		XtNwidth, &width,
    		XtNheight, &height,
		NULL);
       if(x0 >=0 && x0 <= width && y0 >=0 && y0 <= height)
         {
	  if(width > 1)
            x= sX+(x0*(eX-sX-1))/(width-1);   
	  else
            x = sX;
	  pos = 100.0*(double)x/(MAX_DECO_NUMBER-1);
	  sprintf(buf,"pos: %5.2f%%",pos);
	  Mess = XmStringCreateSimple(buf);
	  XtVaSetValues(l,
	   XmNlabelString, Mess,
	   NULL);
	  XmStringFree(Mess);
	  if(XDim->aView.draw)
	    {
	     if(type == ButtonPress)
		XDim->aView.x0 = x;
	     else
	       {
	        VWI = &((XDim->Views)[XDim->port]);
	        col1 = XDim->aView.drawColor;
	        dec = VWI->deco + XDim->aView.x0;
	        VWI->changed |= TRANS_AND_CHANGE;
	        for(i=XDim->aView.x0; i<= x; i++)
		   *dec++ = col1;
		XT_RedrawZoomedDeco((XDim->myWidgets).DecoEdit.DZoom,
		 XDim, NULL);
		XT_RedrawDecoVector((XDim->myWidgets).DecoEdit.DArea,
		 XDim, NULL);
		XT_Redraw((((XDim->myWidgets).Views)[XDim->port]).DArea,
		      (XtPointer)(VWI), NULL);
	       }
	    }
	 }
       else
         XDim->aView.draw = False;   
      }
   }

/*
 * calculate position
 */

void WD_PositionDeco(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    ViewportInfo *XDV;
    XDimDeco *XDD;
    XmDrawingAreaCallbackStruct *cs;
    XButtonEvent *e;

    XDim = (XDimInfo*) client_data;
    cs = (XmDrawingAreaCallbackStruct *) call_data;
    e = (XButtonEvent *)(cs->event);
    if(XDim->port >= 0 && (e->type == ButtonPress || e->type == ButtonRelease))
      {
       XDV = &((XDim->Views)[XDim->port]);
       XDD = &((XDim->myWidgets).DecoEdit);
       if(w == XDD->DZoom)
          WD_ShowDecoPosition(XDD->DZoom, XDD->Label,
             e->x, e->y, XDV->sZoom, XDV->eZoom, e->type, XDim);
       else
          WD_ShowDecoPosition(XDD->DArea, XDD->Label,
             e->x, e->y, 0, MAX_DECO_NUMBER, e->type, XDim);
      }
   }

/*
 * Initiate a Deco save as
 */

void WD_okDecoSaveAs(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    XDimWidgets *XDW;
    ViewportInfo *VWI;
    XmString FName;
    XmStringContext context;
    XmStringDirection dir;
    XmStringCharSet set;
    Boolean sep;
    char *Text;

    XDim = (XDimInfo *) client_data;
    if(XDim->port >=0)
      {
       XDW =  &(XDim->myWidgets);
       VWI = &((XDim->Views)[XDim->port]);
       XtVaGetValues(XDW->FileSelect,
	   XmNdirSpec, &FName,
	   NULL);
       if(XmStringInitContext(&context, FName))
	 {
	  if(XmStringGetNextSegment(context, &Text, &set, &dir, &sep))
            {
             strncpy(VWI->dfile, Text, MAX_NAME_LENGTH);
             if(!FI_SaveDeco(XDim))
        	XtUnmanageChild(XDW->FileSelect);       
	     else
		WD_XDimError(XDim, XDW->FileSelect);
            }
	  XmStringFreeContext(context);
	  XmStringFree(FName);
	 }
      }    
   }

/*
 * Pop up file select box for Pref save as
 */

void WD_PopDecoSaveAs(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    XDimWidgets *XDW;
    XmString Pref,Mess;

    XDim = (XDimInfo *) client_data;
    XDW =  &(XDim->myWidgets);
    Mess = XmStringCreateSimple("Save Decoding Vector as:");
    Pref = XmStringCreateSimple("*.dec");
    XtVaSetValues(XDW->FileSelect,
	XmNpattern, Pref,
	XmNselectionLabelString, Mess,
	NULL);
    XmStringFree(Mess);
    XmStringFree(Pref);
    if(XDW->activeFSCallback)
       XtRemoveCallback(XDW->FileSelect, XmNokCallback,
	  XDW->activeFSCallback, XDW->FSclient_data);
    XtAddCallback(XDW->FileSelect, XmNokCallback,
                   WD_okDecoSaveAs, XDim);
    XDW->activeFSCallback = WD_okDecoSaveAs;
    XDW->FSclient_data = XDim;
    XtManageChild(XDW->FileSelect);       
   }

/*
 * save deco
 */

void WD_SaveDeco(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    ViewportInfo *VWI;

    XDim = (XDimInfo *) client_data;
    if(XDim->port >=0)
      {
       VWI =  &((XDim->Views)[XDim->port]);
       if(*(VWI->dfile) == '\0')
	  WD_PopDecoSaveAs(w, client_data, call_data);
       else
	 {
	  if(FI_SaveDeco(XDim))
	     WD_XDimError(XDim, NULL);
	  }
      }
   }

/*
 * Initiate a load deco
 */

void WD_okLoadDeco(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    XDimWidgets *XDW;
    ViewportInfo *VWI;
    XDimDeco *XDD;
    XmString FName;
    XmStringContext context;
    XmStringDirection dir;
    XmStringCharSet set;
    Boolean sep;
    char *Text;

    XDim = (XDimInfo *) client_data;
    if(XDim->port >=0)
      {
       XDW =  &(XDim->myWidgets);
       VWI = &((XDim->Views)[XDim->port]);
       XDD = &((XDim->myWidgets).DecoEdit);       
       XtVaGetValues(XDW->FileSelect,
	   XmNdirSpec, &FName,
	   NULL);
       if(XmStringInitContext(&context, FName))
	 {
	  if(XmStringGetNextSegment(context, &Text, &set, &dir, &sep))
            {
             strncpy(VWI->dfile, Text, MAX_NAME_LENGTH);
             if(!FI_LoadDeco(XDim))
               {
        	XtUnmanageChild(XDW->FileSelect);
		XT_RedrawZoomedDeco(XDD->DZoom, XDim, NULL);
		XT_RedrawDecoVector(XDD->DArea, XDim, NULL);
               }
	     else
		WD_XDimError(XDim, XDW->FileSelect);
            }
	  XmStringFreeContext(context);
	  XmStringFree(FName);
	 }
      } 
   }

/*
 * Pop up file select box for load deco
 */

void WD_PopLoadDeco(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    XDimWidgets *XDW;
    XmString Pref,Mess;

    XDim = (XDimInfo *) client_data;
    XDW =  &(XDim->myWidgets);
    Mess = XmStringCreateSimple("Load Decoding Vector:");
    Pref = XmStringCreateSimple("*.dec");
    XtVaSetValues(XDW->FileSelect,
	XmNpattern, Pref,
	XmNselectionLabelString, Mess,
	NULL);
    XmStringFree(Mess);
    XmStringFree(Pref);
    if(XDW->activeFSCallback)
       XtRemoveCallback(XDW->FileSelect, XmNokCallback,
	  XDW->activeFSCallback, XDW->FSclient_data);
    XtAddCallback(XDW->FileSelect, XmNokCallback,
                   WD_okLoadDeco, XDim);
    XDW->activeFSCallback = WD_okLoadDeco;
    XDW->FSclient_data = XDim;
    XtManageChild(XDW->FileSelect);       
   }

/*
 * create menu bar for deco edit
 */

void WD_CreateDecoMenuBar(Widget parent, XDimDecoMenuBar *XDDM)
   {

    /*
     * Create Menu Bar
     */
    XDDM->Bar = XmCreateMenuBar( parent, "menuBar", NULL, 0);
    /*
     * Create File Menu
     */
    XDDM->FileButton = XtVaCreateManagedWidget(
	"fileMenu",
	xmCascadeButtonWidgetClass,
	XDDM->Bar,
	NULL);
    XDDM->FileMenu = XmCreatePulldownMenu(
	XDDM->Bar,
	"fileMenu",
	NULL,
	0);
    /*
     * Create Edit Menu
     */
    XDDM->EditButton = XtVaCreateManagedWidget(
	"editMenu",
	xmCascadeButtonWidgetClass,
	XDDM->Bar,
	NULL);
    XDDM->EditMenu = XmCreatePulldownMenu(
	XDDM->Bar,
	"editMenu",
	NULL,
	0);
    /*
     * Create Help
     */

    XDDM->HelpButton = XtVaCreateManagedWidget(
	"Help",
	xmCascadeButtonWidgetClass,
	XDDM->Bar,
	NULL);
    /*
     * Create File Menu Items
     */
    XDDM->load = XtVaCreateManagedWidget(
	"Load",
	xmPushButtonWidgetClass,
	XDDM->FileMenu,
	NULL); 
    XDDM->save = XtVaCreateManagedWidget(
	"Save",
	xmPushButtonWidgetClass,
	XDDM->FileMenu,
	NULL); 
    XDDM->saveAs = XtVaCreateManagedWidget(
	"SaveAs",
	xmPushButtonWidgetClass,
	XDDM->FileMenu,
	NULL); 
    XDDM->sep1 = XtVaCreateManagedWidget(
	"separator",
	xmSeparatorGadgetClass,
	XDDM->FileMenu,
	NULL); 
    XDDM->close = XtVaCreateManagedWidget(
	"Close",
	xmPushButtonWidgetClass,
	XDDM->FileMenu,
	NULL); 

    /*
     * Create Edit Menu Items
     */
    XDDM->zoomIn = XtVaCreateManagedWidget(
	"Zoom+",
	xmPushButtonWidgetClass,
	XDDM->EditMenu,
	NULL); 
    XDDM->zoomOut = XtVaCreateManagedWidget(
	"Zoom-",
	xmPushButtonWidgetClass,
	XDDM->EditMenu,
	NULL); 
    XDDM->sep2 = XtVaCreateManagedWidget(
	"separator",
	xmSeparatorGadgetClass,
	XDDM->EditMenu,
	NULL); 
    XDDM->draw = XtVaCreateManagedWidget(
	"Draw",
	xmPushButtonWidgetClass,
	XDDM->EditMenu,
	NULL); 
    XDDM->iso = XtVaCreateManagedWidget(
	"Iso",
	xmPushButtonWidgetClass,
	XDDM->EditMenu,
	NULL); 
    XDDM->reset = XtVaCreateManagedWidget(
	"Reset",
	xmPushButtonWidgetClass,
	XDDM->EditMenu,
	NULL); 
    XDDM->histo = XtVaCreateManagedWidget(
	"Histogram",
	xmPushButtonWidgetClass,
	XDDM->EditMenu,
	NULL); 
    XtVaSetValues(XDDM->Bar,
	XmNleftAttachment, XmATTACH_FORM,
	XmNrightAttachment, XmATTACH_FORM,
	XmNmenuHelpWidget, XDDM->HelpButton,
	NULL);
    XtManageChild(XDDM->Bar);
    /*
     * Specify the menus
     */
    XtVaSetValues(XDDM->FileButton, XmNsubMenuId, XDDM->FileMenu, NULL);
    XtVaSetValues(XDDM->EditButton, XmNsubMenuId, XDDM->EditMenu, NULL);
   }

/*
 * create edit window for decoding vector
 */

void WD_CreateEditDeco(Widget parent, XDimInfo *XDim)
   {
    XDimWidgets *XDW;
    XDimDeco *XDD;
    XmString Mess;
    Dimension width, height;

    XDW = &(XDim->myWidgets);
    XDD = &(XDW->DecoEdit);
    XDD->Shell = XtVaCreatePopupShell(
        "DecoEdit",
        topLevelShellWidgetClass,
        parent,
        XmNdeleteResponse, XmUNMAP,
        NULL);
    XDD->Form = XtVaCreateManagedWidget(
	"DecoForm",              /* arbitrary widget name */
	xmFormWidgetClass,     /* widget class  */
	XDD->Shell,     /* parent widget*/
	NULL);               /* terminate varargs list */
    
    WD_CreateDecoMenuBar(XDD->Form, &(XDD->Menu));

    XDD->LFrame= XtVaCreateManagedWidget(
	"lFrame",
	xmFrameWidgetClass,
	XDD->Form,
	XmNshadowType, XmSHADOW_ETCHED_OUT,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, (XDD->Menu).Bar,     /* relativ to the Menu Bar */
	XmNleftAttachment, XmATTACH_FORM,	/* fix it to the window */
	XmNleftOffset, 5,
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 5,
	XmNtopOffset, 5,
	NULL);    
    XDD->Label= XtVaCreateManagedWidget(
	"sLabel",
	xmLabelWidgetClass,
	XDD->LFrame,
	XmNalignment, XmALIGNMENT_BEGINNING,
	NULL);
    XDD->ZLabel= XtVaCreateManagedWidget(
	"Zoomed",
	xmLabelWidgetClass,
	XDD->Form,
	XmNalignment, XmALIGNMENT_BEGINNING,
	XmNtopAttachment, XmATTACH_WIDGET, /* position the label*/
	XmNtopWidget, XDD->LFrame,     /* relativ to the Menu Bar */
	XmNtopOffset, 5,
	XmNleftAttachment, XmATTACH_POSITION,	/* fix it to the window */
	XmNleftPosition, 5,
	NULL);
    XDD->Frame= XtVaCreateManagedWidget(
	"zFrame",
	xmFrameWidgetClass,
	XDD->Form,
	XmNshadowType, XmSHADOW_ETCHED_OUT,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDD->ZLabel,		/* relativ to the Label */
	XmNleftAttachment, XmATTACH_FORM,	/* fix it to the window */
	XmNleftOffset, 16,
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 16,
	XmNtopOffset, 5,
	NULL);    
    XDD->FZoom = XtVaCreateManagedWidget(
	"ZoomForm",              /* arbitrary widget name */
	xmFormWidgetClass,     /* widget class  */
	XDD->Frame,     /* parent widget*/
	NULL);               /* terminate varargs list */
    XDD->DZoom = XtVaCreateManagedWidget(
	"zArea",
	xmDrawingAreaWidgetClass,
	XDD->FZoom,
	XmNheight, 100,
        XmNtopAttachment, XmATTACH_FORM,
	XmNleftAttachment, XmATTACH_FORM,	/* fix it to the window */
	XmNrightAttachment, XmATTACH_FORM,
	NULL);	
    XDD->sep1 = XtVaCreateManagedWidget(
	"separator",
	xmSeparatorGadgetClass,
	XDD->FZoom,
	XmNtopAttachment, XmATTACH_WIDGET, /* position the area*/
	XmNtopWidget, XDD->DZoom,     /* relativ to the label */
	XmNleftAttachment, XmATTACH_FORM,	/* fix it to the window */
	XmNrightAttachment, XmATTACH_FORM,
	NULL); 
    XDD->SZoom = XtVaCreateManagedWidget(
	"sArea",
	xmScrollBarWidgetClass,
	XDD->FZoom,
	XmNorientation, XmHORIZONTAL,
	XmNminimum, 0,
	XmNmaximum, MAX_DECO_NUMBER,
	XmNtopAttachment, XmATTACH_WIDGET, /* position the area*/
	XmNtopWidget, XDD->sep1,     /* relativ to zoom */
	XmNleftAttachment, XmATTACH_FORM,	/* fix it to the window */
	XmNrightAttachment, XmATTACH_FORM,
	NULL);	
    XDD->DLabel= XtVaCreateManagedWidget(
	"DecodingVector",
	xmLabelWidgetClass,
	XDD->Form,
	XmNalignment, XmALIGNMENT_BEGINNING,
	XmNtopAttachment, XmATTACH_WIDGET, /* position the label*/
	XmNtopWidget, XDD->Frame,     /* relativ to the Menu Bar */
	XmNtopOffset, 25,
	XmNleftAttachment, XmATTACH_POSITION,	/* fix it to the window */
	XmNleftPosition, 5,
	NULL);
    XDD->DFrame = XtVaCreateManagedWidget(
	"frame",
	xmFrameWidgetClass,
	XDD->Form,
	XmNshadowType, XmSHADOW_IN,
	XmNtopAttachment, XmATTACH_WIDGET, /* position the area*/
	XmNtopWidget, XDD->DLabel,     /* relativ to the label */
	XmNtopOffset, 5,
	XmNleftAttachment, XmATTACH_FORM,	/* fix it to the window */
	XmNleftOffset, 5,
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 5,
	XmNbottomAttachment, XmATTACH_FORM,
	XmNbottomOffset, 5,
	NULL); 
    XDD->DArea = XtVaCreateManagedWidget(
	"vectorArea",
	xmDrawingAreaWidgetClass,
	XDD->DFrame,
	XmNheight, 50,
	XmNwidth, 500,
	NULL);	
    /* Create Dialog Shell's for iso and deco area */
    XDD->isoShell = XmCreateFormDialog(XDD->Shell, "isoShell", NULL, 0);
    XDD->isoForm= XtVaCreateManagedWidget(
	"isoForm",
	xmFormWidgetClass,
	XDD->isoShell,
	XmNshadowType, XmSHADOW_ETCHED_IN,
	XmNtopAttachment, XmATTACH_FORM,	/* position the label*/
	XmNtopOffset, 8,
	XmNleftAttachment, XmATTACH_FORM,	/* fix it to the window */
	XmNleftOffset, 8,
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 8,
	NULL);    
    XDD->isoSEdit = XtVaCreateManagedWidget(
	"sEdit",              /* widget name */
	xmTextFieldWidgetClass,     /* widget class from PushB.h */
	XDD->isoForm,                  /* parent widget*/
	XmNcolumns, 4,
	XmNmaxLength, 4,
	XmNvalue, "0",
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 16,
        XmNtopAttachment, XmATTACH_POSITION,
        XmNtopPosition, 3,
	NULL);
    Mess = XmStringCreateSimple("First line at (in %):");
    XDD->isoSLabel = XtVaCreateManagedWidget(
	"startLabel",              /* arbitrary widget name */
	xmLabelWidgetClass,     /* widget class  */
	XDD->isoForm,	     /* parent widget*/
	XmNlabelString, Mess,
        XmNleftAttachment, XmATTACH_POSITION,
        XmNleftPosition, 5,
	XmNrightAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNrightWidget, XDD->isoSEdit,
	XmNrightOffset, 16,
        XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
        XmNbottomWidget, XDD->isoSEdit,
        XmNbottomOffset, 2,
	NULL);               /* terminate varargs list */
    XmStringFree(Mess);
    XDD->isoEEdit = XtVaCreateManagedWidget(
	"eEdit",              /* widget name */
	xmTextFieldWidgetClass,     /* widget class from PushB.h */
	XDD->isoForm,                  /* parent widget*/
	XmNcolumns, 4,
	XmNmaxLength, 4,
	XmNvalue, "100",
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 16,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDD->isoSEdit,
	XmNtopOffset,8,
	NULL);
    Mess = XmStringCreateSimple("Last line at (in %):");
    XDD->isoELabel = XtVaCreateManagedWidget(
	"eLabel",              /* arbitrary widget name */
	xmLabelWidgetClass,     /* widget class  */
	XDD->isoForm,	     /* parent widget*/
	XmNlabelString, Mess,
        XmNleftAttachment, XmATTACH_POSITION,
        XmNleftPosition, 5,
	XmNrightAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNrightWidget, XDD->isoEEdit,
	XmNrightOffset, 16,
        XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
        XmNbottomWidget, XDD->isoEEdit,
        XmNbottomOffset, 2,
	NULL);               /* terminate varargs list */
    XmStringFree(Mess);
    XDD->isoNEdit = XtVaCreateManagedWidget(
	"nEdit",              /* widget name */
	xmTextFieldWidgetClass,     /* widget class from PushB.h */
	XDD->isoForm,                  /* parent widget*/
	XmNcolumns, 4,
	XmNmaxLength, 4,
	XmNvalue, "10",
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 16,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDD->isoEEdit,
	XmNtopOffset,8,
	NULL);
    Mess = XmStringCreateSimple("Number of iso lines:");
    XDD->isoNLabel = XtVaCreateManagedWidget(
	"nLabel",              /* arbitrary widget name */
	xmLabelWidgetClass,     /* widget class  */
	XDD->isoForm,	     /* parent widget*/
	XmNlabelString, Mess,
        XmNleftAttachment, XmATTACH_POSITION,
        XmNleftPosition, 5,
	XmNrightAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNrightWidget, XDD->isoNEdit,
	XmNrightOffset, 16,
        XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
        XmNbottomWidget, XDD->isoNEdit,
        XmNbottomOffset, 2,
	NULL);               /* terminate varargs list */
    XmStringFree(Mess);
    XDD->isoDEdit = XtVaCreateManagedWidget(
	"dEdit",              /* widget name */
	xmTextFieldWidgetClass,     /* widget class from PushB.h */
	XDD->isoForm,                  /* parent widget*/
	XmNcolumns, 4,
	XmNmaxLength, 4,
	XmNvalue, "32",
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 16,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDD->isoNEdit,
	XmNtopOffset,8,
	NULL);
    Mess = XmStringCreateSimple("Entries per line:");
    XDD->isoDLabel = XtVaCreateManagedWidget(
	"dLabel",              /* arbitrary widget name */
	xmLabelWidgetClass,     /* widget class  */
	XDD->isoForm,	     /* parent widget*/
	XmNlabelString, Mess,
        XmNleftAttachment, XmATTACH_POSITION,
        XmNleftPosition, 5,
	XmNrightAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNrightWidget, XDD->isoDEdit,
	XmNrightOffset, 16,
        XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
        XmNbottomWidget, XDD->isoDEdit,
        XmNbottomOffset, 2,
	NULL);               /* terminate varargs list */
    XmStringFree(Mess);
    XDD->isoCol = XtVaCreateManagedWidget(
	"Col",              /* widget name */
	xmPushButtonWidgetClass,     /* widget class from PushB.h */
	XDD->isoForm,                  /* parent widget*/
	XmNwidth, 32,
	XmNheight, 32,
        XmNlabelType, XmPIXMAP,
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 16,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDD->isoDEdit,
	XmNtopOffset,8,
        XmNbottomAttachment, XmATTACH_POSITION,
        XmNbottomPosition, 98,
	NULL);
    Mess = XmStringCreateSimple("Line color:");
    XDD->isoCLabel = XtVaCreateManagedWidget(
	"dLabel",              /* arbitrary widget name */
	xmLabelWidgetClass,     /* widget class  */
	XDD->isoForm,	     /* parent widget*/
	XmNlabelString, Mess,
        XmNleftAttachment, XmATTACH_POSITION,
        XmNleftPosition, 5,
	XmNrightAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNrightWidget, XDD->isoCol,
	XmNrightOffset, 16,
        XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
        XmNbottomWidget, XDD->isoCol,
        XmNbottomOffset, 2,
	NULL);               /* terminate varargs list */
    XmStringFree(Mess);
    XDD->isoCancel = XtVaCreateManagedWidget(
	"CANCEL",              /* widget name */
	xmPushButtonWidgetClass,     /* widget class from PushB.h */
	XDD->isoShell,                  /* parent widget*/
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 32,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDD->isoForm,
	XmNtopOffset, 16,
	XmNbottomAttachment, XmATTACH_FORM,
	XmNbottomOffset, 16,
	NULL);
    XtVaGetValues(XDD->isoCancel,
    	XtNwidth, &width,
    	XtNheight, &height,
    	NULL);
    XDD->isoOk = XtVaCreateManagedWidget(
	"OK",              /* widget name */
	xmPushButtonWidgetClass,     /* widget class from PushB.h */
	XDD->isoShell,                  /* parent widget*/
	XmNwidth, width,
	XmNheight, height,
	XmNleftAttachment, XmATTACH_FORM,
	XmNleftOffset, 32,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDD->isoForm,		/* relativ to LabelC2 */
	XmNtopOffset, 16,
	XmNbottomAttachment, XmATTACH_FORM,
	XmNbottomOffset, 16,
	NULL);
    
    XDD->areaShell = XmCreateFormDialog(XDD->Shell, "areaShell", NULL, 0);
    XDD->areaForm= XtVaCreateManagedWidget(
	"areaForm",
	xmFormWidgetClass,
	XDD->areaShell,
	XmNshadowType, XmSHADOW_ETCHED_IN,
	XmNtopAttachment, XmATTACH_FORM,	/* position the label*/
	XmNtopOffset, 8,
	XmNleftAttachment, XmATTACH_FORM,	/* fix it to the window */
	XmNleftOffset, 8,
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 8,
	NULL);    
    XDD->areaC1Col = XtVaCreateManagedWidget(
	"Col1",              /* widget name */
	xmPushButtonWidgetClass,     /* widget class from PushB.h */
	XDD->areaForm,                  /* parent widget*/
	XmNwidth, 32,
	XmNheight, 32,
        XmNlabelType, XmPIXMAP,
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 16,
        XmNtopAttachment, XmATTACH_POSITION,
        XmNtopPosition, 6,
	NULL);
    XDD->areaC1Label = XtVaCreateManagedWidget(
	"LabelC1",              /* arbitrary widget name */
	xmLabelWidgetClass,     /* widget class  */
	XDD->areaForm,	     /* parent widget*/
        XmNleftAttachment, XmATTACH_POSITION,
        XmNleftPosition, 5,
	XmNrightAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNrightWidget, XDD->areaC1Col,
	XmNrightOffset, 16,
        XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
        XmNbottomWidget, XDD->areaC1Col,
        XmNbottomOffset, 2,
	NULL);               /* terminate varargs list */
    XDD->areaC2Col = XtVaCreateManagedWidget(
	"Col2",              /* widget name */
	xmPushButtonWidgetClass,     /* widget class from PushB.h */
	XDD->areaForm,                  /* parent widget*/
	XmNwidth, 32,
	XmNheight, 32,
        XmNlabelType, XmPIXMAP,
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 16,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDD->areaC1Col,
	XmNtopOffset,5,
        XmNbottomAttachment, XmATTACH_POSITION,
        XmNbottomPosition, 94,
	NULL);
    XDD->areaC2Label = XtVaCreateManagedWidget(
	"LabelC2",              /* arbitrary widget name */
	xmLabelWidgetClass,     /* widget class  */
	XDD->areaForm,	     /* parent widget*/
        XmNleftAttachment, XmATTACH_POSITION,
        XmNleftPosition, 5,
	XmNrightAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNrightWidget, XDD->areaC2Col,
	XmNrightOffset, 16,
        XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
        XmNbottomWidget, XDD->areaC2Col,
        XmNbottomOffset, 2,
	NULL);               /* terminate varargs list */
    XDD->areaCancel = XtVaCreateManagedWidget(
	"CANCEL",              /* widget name */
	xmPushButtonWidgetClass,     /* widget class from PushB.h */
	XDD->areaShell,                  /* parent widget*/
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 32,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDD->areaForm,
	XmNtopOffset, 16,
	XmNbottomAttachment, XmATTACH_FORM,
	XmNbottomOffset, 16,
	NULL);
    XtVaGetValues(XDD->areaCancel,
    	XtNwidth, &width,
    	XtNheight, &height,
    	NULL);

    XDD->areaOk = XtVaCreateManagedWidget(
	"OK",              /* widget name */
	xmPushButtonWidgetClass,     /* widget class from PushB.h */
	XDD->areaShell,                  /* parent widget*/
	XmNwidth, width,
	XmNheight, height,
	XmNleftAttachment, XmATTACH_FORM,
	XmNleftOffset, 32,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDD->areaForm,		/* relativ to LabelC2 */
	XmNtopOffset, 16,
	XmNbottomAttachment, XmATTACH_FORM,
	XmNbottomOffset, 16,
	NULL);

    /* Add callbacks */
    XtAddCallback((XDD->Menu).close, XmNactivateCallback,
                   XT_Popdown, XDD->Shell);
    XtAddCallback((XDD->Menu).zoomIn, XmNactivateCallback,
                   WD_DecoZoomIn, XDim);
    XtAddCallback((XDD->Menu).zoomOut, XmNactivateCallback,
                   WD_DecoZoomOut, XDim);
    XtAddCallback((XDD->Menu).draw, XmNactivateCallback,
                  WD_Select2DrawDeco , XDim);
    XtAddCallback(XDD->areaC1Col, XmNactivateCallback,
                  WD_Select2ResetDeco , XDim);
    XtAddCallback(XDD->areaC2Col, XmNactivateCallback,
                  WD_Select2ResetDeco , XDim);
    XtAddCallback((XDD->Menu).reset, XmNactivateCallback,
                  WD_ManageResetDeco , XDim);
    XtAddCallback((XDD->Menu).histo, XmNactivateCallback,
                  XT_Histogramm , XDim);
    XtAddCallback(XDD->areaOk, XmNactivateCallback,
                  WD_okResetDeco , XDim);
    XtAddCallback((XDD->Menu).iso, XmNactivateCallback,
                  WD_ManageIsoDeco, XDim);
    XtAddCallback(XDD->isoCol, XmNactivateCallback,
                  WD_SelectIsoDeco , XDim);
    XtAddCallback(XDD->isoOk, XmNactivateCallback,
                  WD_okIsoDeco, XDim);
    XtAddCallback(XDD->DArea, XmNexposeCallback,
		  XT_RedrawDecoVector, XDim);
    XtAddCallback(XDD->DZoom, XmNexposeCallback,
		  XT_RedrawZoomedDeco, XDim);
    XtAddCallback(XDD->DArea, XmNinputCallback,
		  WD_PositionDeco, XDim);
    XtAddCallback(XDD->DZoom, XmNinputCallback,
		  WD_PositionDeco, XDim);
    XtAddCallback(XDD->SZoom, XmNvalueChangedCallback,
		  WD_ScrollZoomedDeco, XDim);
    XtAddCallback((XDD->Menu).load, XmNactivateCallback,
                  WD_PopLoadDeco, XDim);
    XtAddCallback((XDD->Menu).saveAs, XmNactivateCallback,
                  WD_PopDecoSaveAs, XDim);
    XtAddCallback((XDD->Menu).save, XmNactivateCallback,
                  WD_SaveDeco, XDim);
/* Help */
    XtAddCallback((XDD->Menu).HelpButton,
	XmNactivateCallback, XT_Popitup, (XDW->Help).decoShell);
   }

/*
 * callback for edit deco
 */

void WD_PopDeco(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    XDimDeco *XDD;
    ViewportInfo *XDV;
    int del;
    XmString Mess;

    XDim = (XDimInfo*) client_data;
    XDD = &((XDim->myWidgets).DecoEdit);
    if(XDim->port >=0)
      {
       XDim->aView.draw = False;
       XDV = &((XDim->Views)[XDim->port]);
       del = XDV->eZoom - XDV->sZoom;
       if(del < MAX_DECO_NUMBER >> 5)
         {
	  del = MAX_DECO_NUMBER >> 5;
	  XDV->eZoom = XDV->sZoom + del;
	  if(XDV->eZoom > MAX_DECO_NUMBER)
	    {
	     XDV->eZoom = MAX_DECO_NUMBER;
	     XDV->sZoom = MAX_DECO_NUMBER - del;
	    }
	  }
       Mess = XmStringCreateSimple("Edit decoding vector");
       XtVaSetValues(XDD->Label,
	XmNlabelString, Mess,
	NULL);
       XmStringFree(Mess);
       XtVaSetValues(XDD->SZoom,
    	XmNsliderSize, del,
    	XmNpageIncrement, del>>1,
    	XmNincrement, del>>4,
    	XmNvalue, XDV->sZoom,
    	NULL);
       XtPopup(XDD->Shell, XtGrabNone);
      }
   }


/*
 * get Perspective value
 */
 
void WD_okPersp(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    ViewportInfo *view;
    XDimPreferences *XDP;
    char *val;
    int persp;

    XDim = (XDimInfo*) client_data;
    if(XDim->port >=0)
      {
       view = &((XDim->Views)[XDim->port]);
       XDP = &((XDim->myWidgets).Prefs);       
       val = XmTextFieldGetString(XDP->inpField);
       if(!sscanf(val,"%d",&persp))
	  persp = 0;
       XtFree(val);
       if(persp < 0 || persp > 100 )
         {
	  strcpy(XDim->error,
	  "Perspective must be between 0% (off) and 100%");
	  WD_XDimError(XDim, NULL);
	  return;
         }
       if(persp == 0)
         view->k = 0;
       else
         view->k = (view->kmin*100)/persp;
       if(view->k > (CO_ONE << 1))
         view->k = 0;
       view->changed |= CHANGED;
       XT_Redraw((((XDim->myWidgets).Views)[XDim->port]).DArea,
	     (XtPointer)(view), NULL);
      }
   }

/*
 * Pop up Input Field for Perspective
 */

void WD_PopPersp(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    XDimWidgets *XDW;
    XDimPreferences *XDP;
    ViewportInfo *view;
    XmString Mess;
    int persp;
    char val[32];

    XDim = (XDimInfo *) client_data;
    if(XDim->port >=0)
      {
       view = &((XDim->Views)[XDim->port]);
       XDW =  &(XDim->myWidgets);
       XDP =  &(XDW->Prefs);
       Mess = XmStringCreateSimple("Perspective (in %):");
       XtVaSetValues(XDP->inpLabel,
	   XmNlabelString, Mess,
	   NULL);
       XmStringFree(Mess);
       if(view->k)
	 persp = (view->kmin*100)/view->k;
       else
	 persp = 0;
       sprintf(val, "%d", persp);
       XtVaSetValues(XDP->inpField,
	   XmNvalue, val,
	   XmNcolumns, 3,
	   XmNmaxLength, 3,
	   NULL);
       if(XDW->activeInpCallback)
	  XtRemoveCallback(XDP->inpOk, XmNactivateCallback,
	     XDW->activeInpCallback, XDW->Inpclient_data);
       XtAddCallback(XDP->inpOk, XmNactivateCallback,
                      WD_okPersp, XDim);
       XDW->activeInpCallback = WD_okPersp;
       XDW->Inpclient_data = XDim;
       if(XtIsManaged(XDP->inpShell))
	 XtUnmanageChild(XDP->inpShell);
       XtManageChild(XDP->inpShell);
      }
   }

/*
 * get aspect ratio y:x
 */
 
void WD_okAspect(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    ViewportInfo *view;
    XDimPreferences *XDP;
    char *val;
    double aspect;

    XDim = (XDimInfo*) client_data;
    if(XDim->port >=0)
      {
       view = &((XDim->Views)[XDim->port]);
       XDP = &((XDim->myWidgets).Prefs);       
       val = XmTextFieldGetString(XDP->inpField);
       if(!sscanf(val,"%le",&aspect))
	  aspect = 1.0;
       XtFree(val);
       if(aspect < 0.01 || aspect > 100.0 )
         {
	  strcpy(XDim->error,
	  "Aspect must be >= 0.01 and <= 100");
	  WD_XDimError(XDim, NULL);
	  return;
         }
       view->zoomY = view->zoomX * aspect;
       if(view->zoomY > CO_ONE)
         {
          view->zoomY = CO_ONE;
          view->zoomX = CO_ONE/aspect;
         }
       view->kmin = Mmax3(view->zoomX, view->zoomY, view->zoomZ) << 1;
       if(view->k && view->k < view->kmin)
	 view->k = view->kmin;
       view->changed |= CHANGED;
       XT_Redraw((((XDim->myWidgets).Views)[XDim->port]).DArea,
	     (XtPointer)(view), NULL);
      }
   }
/*
 * Pop up Input Field for aspect y:x
 */

void WD_PopAspect(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    XDimWidgets *XDW;
    XDimPreferences *XDP;
    ViewportInfo *view;
    XmString Mess;
    double aspect;
    char val[32];

    XDim = (XDimInfo *) client_data;
    if(XDim->port >=0)
      {
       view = &((XDim->Views)[XDim->port]);
       XDW =  &(XDim->myWidgets);
       XDP =  &(XDW->Prefs);
       Mess = XmStringCreateSimple("Aspect Ratio y/x :");
       XtVaSetValues(XDP->inpLabel,
	   XmNlabelString, Mess,
	   NULL);
       XmStringFree(Mess);
       aspect = ((double)view->zoomY)/view->zoomX;
       sprintf(val, "%f", aspect);
       XtVaSetValues(XDP->inpField,
	   XmNvalue, val,
	   XmNcolumns, 8,
	   XmNmaxLength, 13,
	   NULL);
       if(XDW->activeInpCallback)
	  XtRemoveCallback(XDP->inpOk, XmNactivateCallback,
	     XDW->activeInpCallback, XDW->Inpclient_data);
       XtAddCallback(XDP->inpOk, XmNactivateCallback,
                      WD_okAspect, XDim);
       XDW->activeInpCallback = WD_okAspect;
       XDW->Inpclient_data = XDim;
       if(XtIsManaged(XDP->inpShell))
	 XtUnmanageChild(XDP->inpShell);
       XtManageChild(XDP->inpShell);
      }
   }


/*
 * get Input
 */
 
void WD_okInput(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    XDimPreferences *XDP;
    char *val;
    static char value[MAX_NAME_LENGTH];

    XDim = (XDimInfo*) client_data;
    XDP = &((XDim->myWidgets).Prefs);       
    val = XmTextFieldGetString(XDP->inpField);
    strcpy(value, val);
    (XDP->RetVal)(1, (void*)value, (void*)XDim);
    XtFree(val);
   }

/*
 * Pop up Input Field for general use
 */

void WD_PopInput(char *title, char *val, int cols, int maxL,
	XDimRetFunc RetFunc, XDimInfo *XDim)
   {
    XDimWidgets *XDW;
    XDimPreferences *XDP;
    XmString Mess;

    XDW =  &(XDim->myWidgets);
    XDP =  &(XDW->Prefs);
    Mess = XmStringCreateSimple(title);
    XtVaSetValues(XDP->inpLabel,
	XmNlabelString, Mess,
	NULL);
    XmStringFree(Mess);
    XtVaSetValues(XDP->inpField,
	XmNvalue, val,
	XmNcolumns, cols,
	XmNmaxLength, maxL,
	NULL);
    if(XDW->activeInpCallback)
       XtRemoveCallback(XDP->inpOk, XmNactivateCallback,
	  XDW->activeInpCallback, XDW->Inpclient_data);
    XtAddCallback(XDP->inpOk, XmNactivateCallback,
                   WD_okInput, XDim);
    XDW->activeInpCallback = WD_okInput;
    XDW->Inpclient_data = XDim;
    XDP->RetVal = RetFunc;
    if(XtIsManaged(XDP->inpShell))
      XtUnmanageChild(XDP->inpShell);
    XtManageChild(XDP->inpShell);
   }


/*
 * cast data
 */
 
void WD_okCastData(Widget w, XtPointer client_data, XtPointer call_data)
   {
    ViewportInfo *view;
    XDimInfo *XDim;
    XDimPreferences *XDP;

    XDim = (XDimInfo*) client_data;
    if(XDim->port >=0)
      {
       XDP = &((XDim->myWidgets).Prefs);       
       view = &((XDim->Views)[XDP->castPort]);
       switch (XDP->castType)
	  {
           case MY_UCHAR:
           if(CO_Cast2UChar(view, XDim))
             WD_XDimError(XDim, NULL);
           break;
           default:
           if(CO_Cast2Double(view, XDim))
             WD_XDimError(XDim, NULL);
	   break;
	  }
      }
   }

/*
 * Pop up Type cast Window
 */

void WD_PopTypeCast(int dataType, int port, XDimInfo *XDim)
   {
    XDimWidgets *XDW;
    XDimPreferences *XDP;
    XmString Mess;
    static char Out[128];

    XDW =  &(XDim->myWidgets);
    XDP =  &(XDW->Prefs);
    if(dataType <= 0)
      {
       dataType = -dataType;
       sprintf(Out, "Cast to %s ?" ,TypeNames[dataType]);
      }
    else
sprintf(Out, "This Data Type is not appropriate for the operation, cast to %s ?"
	,TypeNames[dataType]);
    Mess = XmStringCreateSimple(Out);
    XDP->castType = dataType;
    XDP->castPort = port;
    XtVaSetValues(XDP->castLabel,
	XmNlabelString, Mess,
	NULL);
    XmStringFree(Mess);
    if(XtIsManaged(XDP->castShell))
      XtUnmanageChild(XDP->castShell);
    XtManageChild(XDP->castShell);
   }

/*
 * Cast Data to Type
 */

void WD_CastData(Widget w, XtPointer client_data, XtPointer call_data)
   {
    int typ;
    extern XDimInfo XDim;    
    
    typ = -(*((int*)client_data));
    WD_PopTypeCast(typ, XDim.port, &XDim);
   }

/*
 * get Input 2
 */
 
void WD_okInput2(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    XDimPreferences *XDP;
    char *val;
    static myString value[2];

    XDim = (XDimInfo*) client_data;
    XDP = &((XDim->myWidgets).Prefs);       
    val = XmTextFieldGetString(XDP->inp2Field1);
    strcpy(value[0], val);
    XtFree(val);
    val = XmTextFieldGetString(XDP->inp2Field2);
    strcpy(value[1], val);
    (XDP->Ret2Val)(2, (void*)value, (void*)XDim);
    XtFree(val);
   }

/*
 * Pop up Input 2 Field for general use
 */

void WD_PopInput2(char *title1, char *val1, int cols1, int maxL1, char *title2,
	char *val2, int cols2, int maxL2, XDimRetFunc RetFunc, XDimInfo *XDim)
   {
    XDimWidgets *XDW;
    XDimPreferences *XDP;
    XmString Mess;

    XDW =  &(XDim->myWidgets);
    XDP =  &(XDW->Prefs);
    Mess = XmStringCreateSimple(title1);
    XtVaSetValues(XDP->inp2Label1,
	XmNlabelString, Mess,
	NULL);
    XmStringFree(Mess);
    XtVaSetValues(XDP->inp2Field1,
	XmNvalue, val1,
	XmNcolumns, cols1,
	XmNmaxLength, maxL1,
	NULL);
    Mess = XmStringCreateSimple(title2);
    XtVaSetValues(XDP->inp2Label2,
	XmNlabelString, Mess,
	NULL);
    XmStringFree(Mess);
    XtVaSetValues(XDP->inp2Field2,
	XmNvalue, val2,
	XmNcolumns, cols2,
	XmNmaxLength, maxL2,
	NULL);
    XDP->Ret2Val = RetFunc;
    if(XtIsManaged(XDP->inp2Shell))
      XtUnmanageChild(XDP->inp2Shell);
    XtManageChild(XDP->inp2Shell);
   }

/*
 * Do data resize
 */

void WD_okResize(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    XDimPreferences *XDP;
    ViewportInfo *view;
    Boolean inter;
    String val;
    int width, height;
    

    XDim = (XDimInfo *) client_data;
    XDP =  &((XDim->myWidgets).Prefs);
    XtVaGetValues(XDP->siInter,
	XmNset, &inter,
	NULL);
    if(XDim->port >=0)
      {
       view = &((XDim->Views)[XDim->port]);
       if(view->actData != NULL)
         {
	  width = view->Width;
	  val = XmTextFieldGetString(XDP->siWidthEdit);
	  sscanf(val, "%d", &width);
	  XtFree(val);
	  height = view->Height;
	  val = XmTextFieldGetString(XDP->siHeightEdit);
	  sscanf(val, "%d", &height);
	  XtFree(val);
	  if(inter)
	    MA_Interpolate(width, height, view, XDim);
	  else
	    MA_Spline(width, height, view, XDim);
         }
      }
   }


/*
 * Pop up resize field
 */

void WD_PopResize(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    XDimPreferences *XDP;
    ViewportInfo *view;
    char val[32];

    XDim = (XDimInfo*) client_data;
    if(XDim->port >=0)
      {
       view = &((XDim->Views)[XDim->port]);
       if(view->dataType)
         WD_PopTypeCast(MY_DOUBLE, XDim->port, XDim);
       if(view->actData != NULL)
         {
	  XDP =  &((XDim->myWidgets).Prefs);
	  sprintf(val, "%d", view->Width);
	  XtVaSetValues(XDP->siWidthEdit,
	      XmNvalue, val,
	      NULL);
	  sprintf(val, "%d", view->Height);
	  XtVaSetValues(XDP->siHeightEdit,
	      XmNvalue, val,
	      NULL);
	  if(XtIsManaged(XDP->sizeShell))
	    XtUnmanageChild(XDP->sizeShell);
	  XtManageChild(XDP->sizeShell);
	 }
      }
   }


/*
 * get range
 */

void WD_okRange(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    XDimWidgets *XDW;
    XDimPreferences *XDP;
    ViewportInfo *view;
    double val1, val2, base;
    String val;
    char *dimen;

    XDim = (XDimInfo*) client_data;
    if(XDim->port >=0)
      {
       view = &((XDim->Views)[XDim->port]);
       if(view->actData != NULL || view->charData != NULL)
         {
	  XDW =  &(XDim->myWidgets);
	  XDP =  &(XDW->Prefs);
	  val1 = 0.0;
	  val = XmTextFieldGetString(XDP->rgStartEdit);
	  sscanf(val, "%le", &val1);
	  XtFree(val);
	  val2 = 1.0;
	  val = XmTextFieldGetString(XDP->rgEndEdit);
	  sscanf(val, "%le", &val2);
	  XtFree(val);
	  base = 1.0;
	  val = XmTextFieldGetString(XDP->rgBaseEdit);
	  sscanf(val, "%le", &base);
	  XtFree(val);
	  dimen = XmTextFieldGetString(XDP->rgDimEdit);
	  view->changed |= DATA_AND_CHANGE;
       	  if(XDP->range == 3)
	    {
	     view->Min = val1;
	     view->Max = val2;
	     strncpy(view->DimZ, dimen, MAX_DIM_LENGTH);
	     view->baseZ = base;
	    }
	  else
	    {
	     if(XDP->range == 2)
	       {
	        view->OffY = val1;
	        if(view->Height >1)
	          view->FactY = (val2-val1)/(view->Height-1);
	        else
	          view->FactY = 1.0;
		strncpy(view->DimY, dimen, MAX_DIM_LENGTH);
		view->baseY = base;
	       }
	     else
	       {
	        view->OffX = val1;
	        if(view->Width >1)
	          view->FactX = (val2-val1)/(view->Width-1);
	        else
	          view->FactX = 1.0;
		strncpy(view->DimX, dimen, MAX_DIM_LENGTH);
		view->baseX = base;
	       }
	    }
	  XtFree(dimen);
	  XT_Redraw(((XDW->Views)[XDim->port]).DArea,
	     (XtPointer)(view), NULL);
	 }
      }
   }

/*
 * Pop up range
 */

void WD_PopRange(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    XDimWidgets *XDW;
    XDimPreferences *XDP;
    XDimViewMenus *XDVM;
    ViewportInfo *view;
    XmString Mess1, Mess2;
    int size;
    double val1, val2, base;
    char val[32], *dimen;

    XDim = (XDimInfo*) client_data;
    if(XDim->port >=0)
      {
       view = &((XDim->Views)[XDim->port]);
       if(view->actData != NULL || view->charData != NULL)
         {
	  XDW =  &(XDim->myWidgets);
	  XDP =  &(XDW->Prefs);
	  XDVM = &(XDW->ViewMenus);
	  if(w == XDVM->rgZ)
	    {
	     Mess1 = XmStringCreateSimple("Minimum :");
	     Mess2 = XmStringCreateSimple("Maximum :");
	     size = view->Width*view->Height;
	     switch (view->dataType)
              {
               case MY_UCHAR:
	       CO_MinMaxChar(&val2, &val1, size, view->charData);
               break;
               default:
	       CO_MinMax(&val2, &val1, size, view->actData);
	       break;
	      }
	     dimen = view->DimZ;
	     base = view->baseZ;
	     XDP->range = 3;
	    }
	  else
	    {
	     Mess1 = XmStringCreateSimple("Start Value:");
	     Mess2 = XmStringCreateSimple("End Value :");
	     if(w== XDVM->rgY)
	       {
	        val1 = view->OffY;
	        val2 = val1+ (view->Height-1)*view->FactY;
	        dimen = view->DimY;
	        base = view->baseY;
	        XDP->range = 2;
	       }
	     else
	       {
	        val1 = view->OffX;
	        val2 = val1+ (view->Width-1)*view->FactX;
	        dimen = view->DimX;
	        base = view->baseX;
	        XDP->range = 1;
	       }
	    }
	  XtVaSetValues(XDP->rgStartLabel,
	      XmNlabelString, Mess1,
	      NULL);
	  XmStringFree(Mess1);
	  sprintf(val, "%e", val1);
	  XtVaSetValues(XDP->rgStartEdit,
	      XmNvalue, val,
	      NULL);
	  XtVaSetValues(XDP->rgEndLabel,
	      XmNlabelString, Mess2,
	      NULL);
	  XmStringFree(Mess2);
	  sprintf(val, "%e", val2);
	  XtVaSetValues(XDP->rgEndEdit,
	      XmNvalue, val,
	      NULL);
	  sprintf(val, "%e", base);
	  XtVaSetValues(XDP->rgBaseEdit,
	      XmNvalue, val,
	      NULL);
	  XtVaSetValues(XDP->rgDimEdit,
	      XmNvalue, dimen,
	      NULL);
	  if(XtIsManaged(XDP->rangeShell))
	    XtUnmanageChild(XDP->rangeShell);
	  XtManageChild(XDP->rangeShell);
	 }
      }
   }


/*
 * set position
 */
 
void WD_okPosition(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    XDimPosSelect *XDP;
    String val;
    static int xy[2];

    XDim = (XDimInfo*) client_data;
    XDP =  &((XDim->myWidgets).Pos);
    if(XDim->port >=0)
      {
       xy[0] = 0;
       val = XmTextFieldGetString(XDP->XEdit);
       sscanf(val, "%d", &(xy[0]));
       XtFree(val);
       xy[1] = 0;
       val = XmTextFieldGetString(XDP->YEdit);
       sscanf(val, "%d", &(xy[1]));
       XtFree(val);
       (XDP->RetFunc)(2, (void*)xy, (void*)XDim);
      }
   }

/*
 * Redraw Position
 */
 
void WD_RedrawPosition(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    ViewportInfo *view1, *view2;
    XDimPosSelect *XDP;
    XDColorInfo *XDC;
    XDHardwareInfo *HWI;
    Window win;
    String val;
    int x0, y0, x1, y1, x2, y2, width1, height1, width2, height2, maxW, maxP;
    XPoint xy[5];
    Dimension width, height;
    

    XDim = (XDimInfo*) client_data;
    XDP =  &((XDim->myWidgets).Pos);
    win =XtWindow(XDP->DArea);
    if(XDim->port >=0 && win)
      {
       HWI = &(XDim->hwInfo);
       view1 = &((XDim->Views)[XDim->oper1]);
       view2 = &((XDim->Views)[XDim->oper2]);
       XDC = &(XDim->colors);
       x0 = 0;
       val = XmTextFieldGetString(XDP->XEdit);
       sscanf(val, "%d", &x0);
       XtFree(val);
       y0 = 0;
       val = XmTextFieldGetString(XDP->YEdit);
       sscanf(val, "%d", &y0);
       XtFree(val);
       XtVaGetValues(XDP->DArea,
	   XmNwidth, &width,
	   XmNheight, &height,
	   NULL);       
       if(width < height)
         maxP = ((int) width)>>1;
       else
         maxP = ((int) height)>>1;
       if(view1->Width < view1->Height)
          maxW = view1->Height;
       else
          maxW = view1->Width;
       if(view2->Width < view2->Height && view2->Height > maxW)
          maxW = view2->Height;
       else if(view2->Width > maxW)
          maxW = view2->Width;
       width1 = (view1->Width * maxP)/maxW;
       height1 = (view1->Height *maxP)/maxW;
       x1 = ((int)width-width1)>>1;
       y1 = ((int)height-height1)>>1;
       width2 = (view2->Width * maxP)/maxW;
       height2 = (view2->Height *maxP)/maxW;
       x2 = x1+(x0 * maxP)/maxW;
       y2 = y1+(y0 *maxP)/maxW;
       xy[0].x = (short)x1;
       xy[0].y = (short)Mupdown(y1, height);
       xy[1].x = (short)x1;
       xy[1].y = (short)Mupdown((y1+height1), height);
       xy[2].x = (short)(x1+width1);
       xy[2].y = (short)Mupdown((y1+height1), height);
       xy[3].x = (short)(x1+width1);
       xy[3].y = (short)Mupdown(y1, height);
       xy[4].x = (short)x1;
       xy[4].y = (short)Mupdown(y1, height);
       HW_ClearWindow(win, view1, XDim);
       HW_SetFore( ((XDim->colors).colTrans)[XDC->colS], HWI);   
       HW_DrawLines(win, xy, 5, HWI);
       HW_SetFore( ((XDim->colors).colTrans)[XDC->colE], HWI);   
       xy[0].x = (short)x2;
       xy[0].y = (short)Mupdown(y2, height);
       xy[1].x = (short)x2;
       xy[1].y = (short)Mupdown((y2+height2), height);
       xy[2].x = (short)(x2+width2);
       xy[2].y = (short)Mupdown((y2+height2), height);
       xy[3].x = (short)(x2+width2);
       xy[3].y = (short)Mupdown(y2, height);
       xy[4].x = (short)x2;
       xy[4].y = (short)Mupdown(y2, height);
       HW_DrawLines(win, xy, 5, HWI);
      }
   }

/*
 * position port1 in port2
 */

void WD_PopPosition(XDimRetFunc RetFunc, XDimInfo *XDim)
   {
    XDimViewport *XDV;
    ViewportInfo *view1, *view2;
    XDimWidgets *XDW;
    XDimPosSelect *XDP;
    XDColorInfo *XDC;
    String title;
    XmString Mess;
    char label[MAX_NAME_LENGTH];

    if((XDim->Views)[XDim->oper1].pict==NULL ||
       (XDim->oper2 >= 0 && (XDim->Views)[XDim->oper2].pict==NULL))
      return;
    view1 = &((XDim->Views)[XDim->oper1]);
    view2 = &((XDim->Views)[XDim->oper2]);
    XDW = &(XDim->myWidgets);
    XDP =  &(XDW->Pos);
    XDC = &(XDim->colors);
    XDP->RetFunc = RetFunc;
    XDV = &((XDW->Views)[XDim->oper2]);
    XtVaGetValues(XDV->Shell,
	XmNtitle, &title,
	NULL);       
    XtVaSetValues(XDP->VEdit1,
	XmNvalue, title,
	NULL);
    sprintf(label, "Width x Height: %d x %d", view2->Width, view2->Height);
    Mess = XmStringCreateSimple(label);
    XtVaSetValues(XDP->WHLabel1,
	XmNlabelString, Mess,
	NULL);
    XmStringFree(Mess);
    XDV = &((XDW->Views)[XDim->oper1]);
    XtVaGetValues(XDV->Shell,
	XmNtitle, &title,
	NULL);       
    XtVaSetValues(XDP->VEdit2,
	XmNvalue, title,
	NULL);
    sprintf(label, "Width x Height: %d x %d", view1->Width, view1->Height);
    Mess = XmStringCreateSimple(label);
    XtVaSetValues(XDP->WHLabel2,
	XmNlabelString, Mess,
	NULL);
    XmStringFree(Mess);
    XtVaSetValues(XDP->XEdit,
	XmNvalue, "0",
	NULL);
    XtVaSetValues(XDP->YEdit,
	XmNvalue, "0",
	NULL);
    XtVaSetValues(XDP->DArea,
	XmNbackground, (XDC->colTrans)[view1->back],
	NULL);
    if(XtIsManaged(XDP->Shell))
      XtUnmanageChild(XDP->Shell);
    XtManageChild(XDP->Shell);
   }

/*
 * do Math
 */
 
void WD_okMath(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    XDimMath *XDM;
    ViewportInfo *view1, *view2;

    XDim = (XDimInfo*) client_data;
    XDM =  &((XDim->myWidgets).Math);
    XDim->math = False;
    view2 = &((XDim->Views)[XDim->oper2]);
    if(view2->dataType)
       WD_PopTypeCast(MY_DOUBLE, XDim->oper2, XDim);
    else if(XDim->oper2 <0 || view2->actData == NULL || view2->pict == NULL)
      {
       sprintf(XDim->error,"Select second operand with valid data field first");
       WD_XDimError(XDim, XDM->Shell);
      }
    else if(XDim->port >=0)
      {
       view1 = &((XDim->Views)[XDim->oper1]);
       if(view1->Width != view2->Width || view1->Height != view2->Height)
         {
          WD_PopPosition(XDM->RetFunc, XDim);
         }
       else
         {
          (XDM->RetFunc)(0, NULL, (void*)XDim);
         }
      }
   }

/*
 * cancel math operation
 */

void WD_cancelMath(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;

    XDim = (XDimInfo*) client_data;
    XDim->math = False;
   }

/*
 * Redraw math card
 */

void WD_RedrawMath(XDimInfo *XDim)
   {
    XDimViewport *XDV;
    XDimWidgets *XDW;
    XDimMath *XDM;
    String title;

    if((XDim->Views)[XDim->oper1].pict==NULL ||
       (XDim->oper2 >= 0 && (XDim->Views)[XDim->oper2].pict==NULL))
      return;
    XDW = &(XDim->myWidgets);
    XDV = &((XDW->Views)[XDim->oper1]);
    XDM =  &(XDW->Math);
    XtVaGetValues(XDV->Shell,
	XmNtitle, &title,
	NULL);       
    XtVaSetValues(XDM->Oper1,
	XmNvalue, title,
	NULL);
    if(XDim->oper2 < 0)
      {
       XtVaSetValues(XDM->Oper2,
	   XmNvalue, "",
	   NULL);
      }
    else
      {
       XDV = &((XDW->Views)[XDim->oper2]);
       XtVaGetValues(XDV->Shell,
	   XmNtitle, &title,
	   NULL);       
       XtVaSetValues(XDM->Oper2,
	   XmNvalue, title,
	   NULL);
      }
   }

/*
 * Pop up math select
 */

void WD_PopMath(char *Apply, char *To, int port,
	XDimRetFunc RetFunc, XDimInfo *XDim)
   {
    XDimMath *XDM;
    XmString Mess;

    if(XDim->port >= 0)
      {
       if(((XDim->Views)[port]).dataType)
	  WD_PopTypeCast(MY_DOUBLE, port, XDim);
       if(((XDim->Views)[port]).actData != NULL)
	 {
	  XDM =  &((XDim->myWidgets).Math);
	  XDim->oper1 = port;
	  XDim->oper2 = -1;
	  XDim->math = True;
	  Mess = XmStringCreateSimple(Apply);
	  XtVaSetValues(XDM->Apply,
	      XmNlabelString, Mess,
	      NULL);
	  XmStringFree(Mess);
	  Mess = XmStringCreateSimple(To);
	  XtVaSetValues(XDM->To,
	      XmNlabelString, Mess,
	      NULL);
	  XmStringFree(Mess);
	  XDM->RetFunc = RetFunc;
	  WD_RedrawMath(XDim);
	  if(XtIsManaged(XDM->Shell))
	    XtUnmanageChild(XDM->Shell);
	  XtManageChild(XDM->Shell);
	 }
      }
   }


/*
 * Do a recursive load with links
 */

void WD_RecLoadData(XDLinks *hLinks, ViewportInfo *view, XDimInfo *XDim)
   {
    XDimWidgets *XDW;
    XDimViewport *XDV;
    ViewportInfo *view1;
    XDLinks hLink1;
    int i, j, from, to, Num;
    Boolean found;
    char *Itself, *LinkName, *Link2File, *cp;
    static char buf[MAX_NAME_LENGTH];

    /* Now look out for links */
    XDW =  &(XDim->myWidgets);
    from = XDim->port;
    for(i=0; i< hLinks->links; i++)
       {
	if(*((hLinks->hLinks)[i].Itself) != '\0' &&
	 *((hLinks->hLinks)[i].LinkName) != '\0' &&
	 *((hLinks->hLinks)[i].Link2File) != '\0')
	  {
	   Link2File = (hLinks->hLinks)[i].Link2File;
	   if(!strchr(Link2File, FILE_SEP))
	     {
	      strncpy(buf, view->fileName, MAX_NAME_LENGTH);
	      cp = FI_StripFilename(buf);
	      if(cp != buf)
	        cp++;
	      strncpy(cp, Link2File, MAX_NAME_LENGTH);
	      strncpy(Link2File, buf, MAX_NAME_LENGTH);
	     }
	   found = False;
	   for(j=0; j< MAX_VIEWPORT_NUMBER; j++)
	      {
	       view1 = &((XDim->Views)[j]);
	       if(view1->pict && !strncmp(view1->fileName,
			Link2File, MAX_NAME_LENGTH))
		 {
		  found = True;
		  break;
		 }
	      }
	   if(found)
	     {
	      to = j;
	      Itself = (hLinks->hLinks)[i].Itself;
	      LinkName = (hLinks->hLinks)[i].LinkName;
	      Num = view->links;
	      found = False;
	      for(j=0; j<Num; j++)
		 {
		  if(!strncmp((view->LinkItself)[Num], Itself,
		     MAX_LINK_LENGTH) &&
		     !strncmp((view->LinkName)[Num], LinkName ,
		     MAX_LINK_LENGTH))
		    {
		     found = True;
		     break;
		    }
		 }
	      if(!found)
		{
		 strncpy((view->LinkItself)[Num], Itself, MAX_LINK_LENGTH);
		 strncpy((view->LinkName)[Num], LinkName , MAX_LINK_LENGTH);
		 (view->Link1)[Num] = from;
		 (view->Link2)[Num] = to;
		 (view->links)++;
		}
	     }
	   else
	     {
              WD_CreateViewport(XDW->NewView, XDim, NULL);
              to = XDim->port;
              if(to!=from)
        	{
		 view1 = &((XDim->Views)[to]);
 		 strncpy(view1->fileName, Link2File, MAX_NAME_LENGTH);
        	 if(!FI_LoadData(&hLink1, XDim))
        	   {
		    Itself = (hLinks->hLinks)[i].Itself;
		    LinkName = (hLinks->hLinks)[i].LinkName;
		    Num = view->links;
		    found = False;
		    for(j=0; j<Num; j++)
		       {
			if(!strncmp((view->LinkItself)[Num], Itself,
			   MAX_LINK_LENGTH) &&
			   !strncmp((view->LinkName)[Num], LinkName ,
			   MAX_LINK_LENGTH))
			  {
		           found = True;
		           break;
			  }
		       }
		    if(!found)
		      {
		       strncpy((view->LinkItself)[Num], Itself, MAX_LINK_LENGTH);
		       strncpy((view->LinkName)[Num], LinkName , MAX_LINK_LENGTH);
		       (view->Link1)[Num] = from;
		       (view->Link2)[Num] = to;
		       (view->links)++;
		      }
		    Num = view1->links;
		    found = False;
		    for(j=0; j<Num; j++)
		       {
			if(!strncmp((view1->LinkItself)[Num], LinkName,
			   MAX_LINK_LENGTH) &&
			   !strncmp((view1->LinkName)[Num], Itself ,
			   MAX_LINK_LENGTH))
			  {
		           found = True;
		           break;
			  }
		       }
		    if(!found)
		      {
		       strncpy((view1->LinkItself)[Num], LinkName, MAX_LINK_LENGTH);
		       strncpy((view1->LinkName)[Num], Itself , MAX_LINK_LENGTH);
		       (view1->Link2)[Num] = from;
		       (view1->Link1)[Num] = to;
		       (view1->links)++;
		      }
		    XDV = &((XDW->Views)[to]);
        	    XtVaSetValues(XDV->Shell,
			    XmNtitle, view1->fileName,
			    NULL);
		    CO_CalculateBases(view1);
		    XT_Redraw(XDV->DArea, (XtPointer)(view1), NULL);
		    if(hLink1.links > 0)
		      {
		       WD_RecLoadData(&hLink1, view1, XDim);
		      }		  
		   }
		 else
		   WD_XDimError(XDim, NULL);
		}
	     }
	  }
	else
	  {
	   sprintf(XDim->error, "Link Number %d is corrupted",
		 i+1);
	   WD_XDimError(XDim, NULL);
	  }
       }
   }

/*
 * Initiate a load data
 */

void WD_okLoadData(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    XDimWidgets *XDW;
    ViewportInfo *view;
    XDimViewport *XDV;
    XmString FName;
    XmStringContext context;
    XmStringDirection dir;
    XmStringCharSet set;
    Boolean sep;
    char *Text;
    XDLinks hLinks;

    XDim = (XDimInfo *) client_data;
    XDW =  &(XDim->myWidgets);
    if(XDim->port >=0)
      {
       XtVaGetValues(XDW->DataSelect,
	   XmNdirSpec, &FName,
	   NULL);
       if(XmStringInitContext(&context, FName))
	 {
	  if(XmStringGetNextSegment(context, &Text, &set, &dir, &sep))
            {
             view = &((XDim->Views)[XDim->port]);
             XDV = &((XDW->Views)[XDim->port]);
             /* Remove all old links to this viewport */
             FI_RemoveWasteLinks(view->port, XDim);
             strncpy(view->fileName, Text, MAX_NAME_LENGTH);
             if(!FI_LoadData(&hLinks, XDim))
               {
                XtVaSetValues(XDV->Shell,
			XmNtitle, view->fileName,
			NULL);
		CO_CalculateBases(view);
		XT_Redraw(XDV->DArea, (XtPointer)(view), NULL);
		if(XDim->useLinks && hLinks.links > 0)
		  {
		   WD_RecLoadData(&hLinks, view, XDim);
		  }		  
        	XtUnmanageChild(XDW->DataSelect);
               }
	     else
		WD_XDimError(XDim, XDW->DataSelect);
            }
	  XmStringFreeContext(context);
	  XmStringFree(FName);
	 }
      }
    else
      {
       strcpy(XDim->error, "No viewport available");
       WD_XDimError(XDim, XDW->DataSelect);
      }
   }

/*
 * Pop up file select box for load data
 */

void WD_PopLoadData(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    XDimWidgets *XDW;
    XmString Pref,Mess;

    XDim = (XDimInfo *) client_data;
    XDW =  &(XDim->myWidgets);
    if(XDim->port >= 0)
      {
       Mess = XmStringCreateSimple("Load Data:");
       Pref = XmStringCreateSimple("*.xd");
       XtVaSetValues(XDW->DataSelect,
	   XmNpattern, Pref,
	   XmNselectionLabelString, Mess,
	   NULL);
       XmStringFree(Mess);
       XmStringFree(Pref);
       if(XDW->activeDTCallback)
	  XtRemoveCallback(XDW->DataSelect, XmNokCallback,
	     XDW->activeDTCallback, XDW->DTclient_data);
       XtAddCallback(XDW->DataSelect, XmNokCallback,
                      WD_okLoadData, XDim);
       XDW->activeDTCallback = WD_okLoadData;
       XDW->DTclient_data = XDim;
       XtManageChild(XDW->DataSelect);
      }
   }


/*
 * Initiate a Data save as
 */

void WD_okDataSaveAs(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    XDimWidgets *XDW;
    ViewportInfo *VWI;
    XmString FName;
    XmStringContext context;
    XmStringDirection dir;
    XmStringCharSet set;
    Boolean sep;
    char *Text;

    XDim = (XDimInfo *) client_data;
    if(XDim->port >=0)
      {
       XDW =  &(XDim->myWidgets);
       VWI = &((XDim->Views)[XDim->port]);
       XtVaGetValues(XDW->DataSelect,
	   XmNdirSpec, &FName,
	   NULL);
       if(XmStringInitContext(&context, FName))
	 {
	  if(XmStringGetNextSegment(context, &Text, &set, &dir, &sep))
            {
             strncpy(VWI->fileName, Text, MAX_NAME_LENGTH);
             XtVaSetValues(((XDW->Views)[XDim->port]).Shell,
		     XmNtitle, VWI->fileName,
		     NULL);
	     WD_SaveData(NULL, XDim, NULL);
            }
	  XmStringFreeContext(context);
	  XmStringFree(FName);
	  if(XDim->RecSave != True)
		XtUnmanageChild(XDW->DataSelect);
	 }
      }    
   }

/*
 * Pop up file select box for save data as
 */

void WD_PopDataSaveAs(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    XDimWidgets *XDW;
    XmString Pref,Mess;

    XDim = (XDimInfo *) client_data;
    XDW =  &(XDim->myWidgets);
    if(XDim->port >= 0)
      {
       Mess = XmStringCreateSimple("Save Data as:");
       Pref = XmStringCreateSimple("*.xd");
       XtVaSetValues(XDW->DataSelect,
	   XmNpattern, Pref,
	   XmNselectionLabelString, Mess,
	   NULL);
       XmStringFree(Mess);
       XmStringFree(Pref);
       if(XDW->activeDTCallback)
	  XtRemoveCallback(XDW->DataSelect, XmNokCallback,
	     XDW->activeDTCallback, XDW->DTclient_data);
       XtAddCallback(XDW->DataSelect, XmNokCallback,
                      WD_okDataSaveAs, XDim);
       XDW->activeDTCallback = WD_okDataSaveAs;
       XDW->DTclient_data = XDim;
       if(XtIsManaged(XDW->DataSelect))
         XtUnmanageChild(XDW->DataSelect);
       XtManageChild(XDW->DataSelect);
      }
   }

/*
 * recursively save with links
 */
 
void WD_RecSaveData(XDimInfo *XDim)
   {
    int i, to, from;
    ViewportInfo *Views, *view;
    XDimWidgets *XDW;
    String title;

    if(XDim->RecSave == False)
      {
       XDim->RecPort = XDim->port;
      }
    Views = XDim->Views;
    view =  &(Views[XDim->RecPort]);
    if(view->links > 0)
      {
       if(XDim->RecSave == False)
	 {
	  XDim->RecSave = True;
	  XDim->ActRectPort = 0;
	 }
       XDW = &(XDim->myWidgets);
       for(i=XDim->ActRectPort; i<view->links; i++)
	  {
	   XDim->ActRectPort = i;
	   to = (view->Link2)[i];
	   from = (view->Link1)[i];
	   if(to>=0 && Views[to].pict != NULL &&
	      from>=0 && Views[from].pict != NULL)
	     {
	      if(*(Views[from].fileName) == '\0')
		{
		 XtVaGetValues(((XDW->Views)[from]).Shell,
			 XmNtitle, &title,
			 NULL);
		 XtPopup((XDW->Views)[from].Shell, XtGrabNone);
		 XDim->port = from;
		 WD_PopDataSaveAs(NULL, XDim, NULL);
		 sprintf(XDim->error,
		 "Link from Viewport %s has no filename attached !", title);
		 WD_XDimError(XDim, NULL);
		 break;
		}
	      XDim->port = to;
	      if(*(Views[to].fileName) == '\0')
		{
		 XtVaGetValues(((XDW->Views)[to]).Shell,
			 XmNtitle, &title,
			 NULL);
		 XtPopup((XDW->Views)[to].Shell, XtGrabNone);
		 WD_PopDataSaveAs(NULL, XDim, NULL);
		 sprintf(XDim->error,
		 "Link to Viewport %s has no filename attached !", title);
		 WD_XDimError(XDim, NULL);
		 break;
		}
	      if(FI_SaveData(XDim))
		 WD_XDimError(XDim, NULL);
      	     }
	  }
	if(i<view->links)
	  return;
	else
	  {
	   XDim->port = XDim->RecPort;
	   XDim->RecSave = False;
	  }
       }
    if(FI_SaveData(XDim))
       WD_XDimError(XDim, NULL);
   }

/*
 * save data
 */

void WD_SaveData(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    ViewportInfo *view;

    XDim = (XDimInfo *) client_data;
    if(XDim->port >=0)
      {
       view =  &((XDim->Views)[XDim->port]);
       if(*(view->fileName) == '\0')
	  WD_PopDataSaveAs(w, client_data, call_data);
       else
	 {
	  if(XDim->useLinks)
	    {
	     WD_RecSaveData(XDim);
       	    }
	  else if(FI_SaveData(XDim))
	     WD_XDimError(XDim, NULL);
	 }
      }
   }

/*
 * collect input events for drawing area
 */

void WD_DrawInput(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XmDrawingAreaCallbackStruct *cs;
    XButtonEvent *e;
    Window win;
    ViewportInfo *view;
    extern XDimInfo XDim;
    int x,y;
    double xd, yd, zd;
    char edit[MAX_NAME_LENGTH], val[32];

    win =XtWindow(w);
    if(win)
      {
       cs = (XmDrawingAreaCallbackStruct *) call_data;
       if((cs->event)->type == ButtonPress)
	 {
	  e = (XButtonEvent *)(cs->event);
          if(e->button == Button2)
            {
	     XT_NormalRedraw(w, client_data, call_data);
            }
          else
            {
	     view = (ViewportInfo*) client_data;
	     if(view->actData || view->charData)
	       {
	        if(view->k)
	          sprintf(XDim.mess,
	          "Please turn the perspective off to use pointing");
		else if(CO_Point(e->x, e->y, &xd, &yd, &zd, view, &XDim))
		  {
	           sprintf(XDim.mess,
		     "x: %e %s (%4.2f)    y: %e %s (%4.2f)    z: %e %s",
		     (xd*view->FactX+view->OffX), view->DimX, xd,
		     (yd*view->FactY+view->OffY), view->DimY, yd, zd,
		     view->DimZ);
		   if(e->button == Button1)
		     {
		      if(view->edit)
			{
		         if(view->dataType)
		           WD_PopTypeCast(MY_DOUBLE, view->port, &XDim);
		         else
		           {
			    XDim.aView.edPort = view->port;
			    x = (int)(xd+0.5);
			    y = (int)(yd+0.5);
			    XDim.aView.edit = view->actData+(y*view->Width)+x;
			    sprintf(val, "%e", *(XDim.aView.edit));
			    sprintf(edit, "Edit value at x= %d , y= %d:", x, y);
			    WD_PopInput(edit, val, 8, 13, MA_okEditVal, &XDim);
			   }
			}
		      else if(view->cut == CUT_START || view->cut == CUT_END)
		        {
		         if(view->dataType)
		           WD_PopTypeCast(MY_DOUBLE, view->port, &XDim);
		         else
			   WD_RedrawCut(xd, yd, view, &XDim);
			}
		     }
		  }
		else
		   sprintf(XDim.mess,
			"You didn't point to the AREA of the function!");
	       }
	     else
	       strcpy( XDim.mess,
			"No data loaded for this Viewport");
             WD_ViewportMessage(view, &XDim);
            }
   	 }
      }
   }

/*
 * Create viewport menu bar
 */

void WD_CreateViewMenuBar(Widget parent, XDimViewMenuBar *XDVM, XDimInfo *XDim)
   {
    /*
     * Create Menu Bar
     */
    XDVM->Bar = XmCreateMenuBar( parent, "menuBar", NULL, 0);
    /*
     * Create File Menu
     */
    XDVM->FileButton = XtVaCreateManagedWidget(
	"fileMenu",
	xmCascadeButtonWidgetClass,
	XDVM->Bar,
	NULL);
    XDVM->FileMenu = XmCreatePulldownMenu(
	XDVM->Bar,
	"fileMenu",
	NULL,
	0);
    /*
     * Create Setup Menu
     */
    XDVM->SetupButton = XtVaCreateManagedWidget(
	"setupMenu",
	xmCascadeButtonWidgetClass,
	XDVM->Bar,
	NULL);
    XDVM->SetupMenu = XmCreatePulldownMenu(
	XDVM->Bar,
	"setupMenu",
	NULL,
	0);
    /*
     * Create Data Menu
     */
    XDVM->DataButton = XtVaCreateManagedWidget(
	"dataMenu",
	xmCascadeButtonWidgetClass,
	XDVM->Bar,
	NULL);


    /*
     * Create Help
     */

    XDVM->HelpButton = XtVaCreateManagedWidget(
	"Help",
	xmCascadeButtonWidgetClass,
	XDVM->Bar,
	NULL);
    /*
     * Create File Menu Items
     */
    XDVM->load = XtVaCreateManagedWidget(
	"Load",
	xmPushButtonWidgetClass,
	XDVM->FileMenu,
	NULL); 
    XDVM->save = XtVaCreateManagedWidget(
	"Save",
	xmPushButtonWidgetClass,
	XDVM->FileMenu,
	NULL); 
    XDVM->saveAs = XtVaCreateManagedWidget(
	"SaveAs",
	xmPushButtonWidgetClass,
	XDVM->FileMenu,
	NULL); 
    XDVM->import = XtVaCreateManagedWidget(
	"Import",
	xmPushButtonWidgetClass,
	XDVM->FileMenu,
	NULL); 
    XDVM->export = XtVaCreateManagedWidget(
	"Export",
	xmPushButtonWidgetClass,
	XDVM->FileMenu,
	NULL); 
    XDVM->sep1 = XtVaCreateManagedWidget(
	"separator",
	xmSeparatorGadgetClass,
	XDVM->FileMenu,
	NULL); 
    XDVM->close = XtVaCreateManagedWidget(
	"Close",
	xmPushButtonWidgetClass,
	XDVM->FileMenu,
	NULL); 

    /*
     * Create Setup Menu Items
     */
    XDVM->prefs = XtVaCreateManagedWidget(
	"Preferences",
	xmCascadeButtonWidgetClass,
	XDVM->SetupMenu,
	NULL); 
    XDVM->deco = XtVaCreateManagedWidget(
	"Deco",
	xmPushButtonWidgetClass,
	XDVM->SetupMenu,
	NULL); 
    XDVM->cut = XtVaCreateManagedWidget(
	"Cut",
	xmPushButtonWidgetClass,
	XDVM->SetupMenu,
	NULL); 
    XDVM->persp = XtVaCreateManagedWidget(
	"Perspective",
	xmCascadeButtonWidgetClass,
	XDVM->SetupMenu,
	NULL); 
    XDVM->aspect = XtVaCreateManagedWidget(
	"Aspect",
	xmCascadeButtonWidgetClass,
	XDVM->SetupMenu,
	NULL); 
    XDVM->LinkButton = XtVaCreateManagedWidget(
	"Links",
	xmCascadeButtonWidgetClass,
	XDVM->SetupMenu,
	NULL); 
    /*
     * Create link menu
     */
    XDVM->LinkMenu = XmCreatePulldownMenu(
	XDVM->SetupMenu,
	"linkMenu",
	NULL,
	0);
    /*
     * Create link menu items
     */
    XDVM->createLink = XtVaCreateManagedWidget(
	"createLink",
	xmPushButtonWidgetClass,
	XDVM->LinkMenu,
	NULL); 
    XDVM->showLinks = XtVaCreateManagedWidget(
	"showLinks",
	xmPushButtonWidgetClass,
	XDVM->LinkMenu,
	NULL); 
    XDVM->deleteLink = XtVaCreateManagedWidget(
	"deleteLink",
	xmPushButtonWidgetClass,
	XDVM->LinkMenu,
	NULL); 
    XtVaSetValues(XDVM->Bar,
	XmNleftAttachment, XmATTACH_FORM,
	XmNrightAttachment, XmATTACH_FORM,
	XmNmenuHelpWidget, XDVM->HelpButton,
	NULL);
    XtManageChild(XDVM->Bar);
    
    /*
     * Specify the menus
     */
    XtVaSetValues(XDVM->FileButton, XmNsubMenuId, XDVM->FileMenu, NULL);
    XtVaSetValues(XDVM->SetupButton, XmNsubMenuId, XDVM->SetupMenu, NULL);
    XtVaSetValues(XDVM->LinkButton, XmNsubMenuId, XDVM->LinkMenu, NULL);
    XtVaSetValues(XDVM->prefs, XmNsubMenuId,
	XDim->myWidgets.ViewMenus.PrefMenu, NULL);
    XtVaSetValues(XDVM->DataButton, XmNsubMenuId,
	XDim->myWidgets.ViewMenus.DataMenu, NULL);
   }

/*
 * create a viewport
 */

void WD_CreateViewport(Widget w, XtPointer client_data, XtPointer call_data)
{
    XDimInfo *XDim;
    XDimWidgets *XDW;
    XDimViewport *XDV;
    XDColorInfo *XDC;
    ViewportInfo *VWI;
    static char name[MAX_NAME_LENGTH];
    int nextport;

    XDim = (XDimInfo*) client_data;
    XDW = &(XDim->myWidgets);
    for(nextport = 0; nextport < MAX_VIEWPORT_NUMBER; nextport++)
       if(!((XDim->Views)[nextport]).pict) break;
    if(nextport >= MAX_VIEWPORT_NUMBER)
      {
       sprintf(XDim->error, "Sorry maximum number of viewports is %d",
 		MAX_VIEWPORT_NUMBER); 
       WD_XDimError(XDim, XDW->FileSelect);
      }
    else
      {
       XDV = &((XDW->Views)[nextport]);
       VWI = &((XDim->Views)[nextport]);
       XDC = &(XDim->colors);
       XDim->port = nextport;
       /* set default values */
       VWI->port = nextport;
       VWI->wwidth = XDC->wwidth;
       VWI->wheight = XDC->wheight;
       VWI->pwidth = XDC->pwidth;
       VWI->pheight = XDC->pheight;
       if(GR_ResizeViewport(VWI, XDim))
	  WD_XDimError(XDim, XDW->FileSelect);
       else
         {
          (VWI->dfile)[0] = '\0';
          (VWI->fileName)[0] = '\0';
          VWI->links = 0;
          VWI->actLink = 0;
	  VWI->zoom = XDC->zoom;
	  if(VWI->pheight > VWI->pwidth)
	     VWI->zoomX = 0.9*(VWI->pwidth);
	  else
	     VWI->zoomX = 0.9*(VWI->pheight);
          VWI->zoomY = VWI->zoomX;
	  VWI->zoomZ = VWI->zoomX;
	  VWI->dAngle = XDC->dAngle;
	  VWI->rotZ = 0.0;
	  VWI->sinZ = 0;
	  VWI->cosZ = CO_ONE;
	  VWI->rotXY = 2*PI-1.0e-8;
	  VWI->sinXY = 0;
	  VWI->cosXY = CO_ONE;
	  VWI->delta = XDC->delta;
	  VWI->moveX = (VWI->pwidth) >> 1;
	  VWI->moveY = (VWI->pheight) >> 1;
	  VWI->kmin = VWI->zoomX << 1;
	  VWI->k = 0;
	  VWI->fore = XDC->fore;
	  VWI->axisFore = XDC->axisFore;
	  VWI->back = XDC->back;
	  VWI->colS = XDC->colS;
	  VWI->colE = XDC->colE;
	  VWI->axisBackX = XDC->axisBackX;
	  VWI->axisBackY = XDC->axisBackY;
	  VWI->axisBackZ = XDC->axisBackZ;
	  VWI->sZoom = 0;
	  VWI->eZoom = MAX_DECO_NUMBER >> 2;
	  VWI->gNum = XDC->gNum;
	  VWI->gStep = XDC->gStep;
	  VWI->changed = ALL_CHANGED;
	  VWI->Grid = XDC->DrawGrid;
	  VWI->DrawGrid = False;
	  VWI->DrawAxisText = XDC->DrawAxisText;
	  VWI->edit = False;
	  VWI->cut = 0;
	  VWI->ticsX = XDC->ticsX;
	  VWI->ticsY = XDC->ticsY;
	  VWI->ticsZ = XDC->ticsZ;
          GR_InitDeco(VWI->deco, VWI->colS, VWI->colE);
	  sprintf(name, "View%d", nextport+1);
       /* create the widgets */
	  XDV->Shell = XtVaCreatePopupShell(
           name,
           topLevelShellWidgetClass,
           w,
           NULL);
	  XDV->Form = XtVaCreateManagedWidget(
	   "Form",			/* arbitrary widget name */
	   xmFormWidgetClass,	/* widget class  */
	   XDV->Shell,		/* parent widget*/
	   NULL);			/* terminate varargs list */
	  WD_CreateViewMenuBar(XDV->Form, &(XDV->Menu), XDim);
	  XDV->StatFrame= XtVaCreateManagedWidget(
	  "statFrame",
          xmFrameWidgetClass,
	   XDV->Form,
	   XmNshadowType, XmSHADOW_ETCHED_OUT,
	   XmNtopAttachment, XmATTACH_WIDGET, /* position the label*/
	   XmNtopWidget, (XDV->Menu).Bar, /* relativ to the Menu Bar */
	   XmNleftAttachment, XmATTACH_FORM,	/* fix it to the window */
	   XmNrightAttachment, XmATTACH_FORM,
	  NULL);    
	  XDV->ViewStat = XtVaCreateManagedWidget(
	   "status",              /* widget name */
	   xmLabelWidgetClass,     /* widget class from PushB.h */
	   XDV->StatFrame,                  /* parent widget*/
	   NULL);
	  XDV->SWindow = XtVaCreateManagedWidget(
	   "sWindow",
	   xmScrolledWindowWidgetClass,
	   XDV->Form,
	   XmNleftAttachment, XmATTACH_FORM,
	   XmNrightAttachment, XmATTACH_FORM,
	   XmNbottomAttachment, XmATTACH_FORM,
	   XmNtopAttachment, XmATTACH_WIDGET, /* position the area*/
	   XmNtopWidget, XDV->StatFrame, /* relativ to the Menu Bar */
	   XmNwidth, VWI->wwidth,
	   XmNheight, VWI->wheight,
	   XmNscrollingPolicy, XmAUTOMATIC,
	   NULL);	
	  XDV->DArea = XtVaCreateManagedWidget(
	   "dArea",			/* arbitrary widget name */
	   xmDrawingAreaWidgetClass,	/* widget class  */
	   XDV->SWindow,		/* parent widget*/
	   XmNwidth, VWI->pwidth,
	   XmNheight, VWI->pheight,
	   XmNbackground, (XDC->colTrans)[XDC->back],
	   NULL);			/* terminate varargs list */
        /* pop down deco */
          XtPopdown((XDim->myWidgets).DecoEdit.Shell);
	/* Add callbacks */
	  XtAddCallback(XDV->Shell, XmNdestroyCallback,
                   XT_DestroyViewport, (XtPointer)&(VWI->port));
	  XtAddCallback((XDV->Menu).close, XmNactivateCallback,
                   XT_DestroyViewport, (XtPointer)&(VWI->port));
          XtAddCallback((XDV->Menu).deco, XmNactivateCallback,
		   WD_PopDeco, XDim);
          XtAddCallback((XDV->Menu).cut, XmNactivateCallback,
		   WD_PopCut, XDim);
          XtAddCallback((XDV->Menu).persp, XmNactivateCallback,
		   WD_PopPersp, XDim);
          XtAddCallback((XDV->Menu).aspect, XmNactivateCallback,
		   WD_PopAspect, XDim);
          XtAddCallback((XDV->Menu).load, XmNactivateCallback,
		   WD_PopLoadData, XDim);
          XtAddCallback((XDV->Menu).import, XmNactivateCallback,
		   WD_ManageImport, XDim);
          XtAddCallback((XDV->Menu).save, XmNactivateCallback,
		   WD_SaveData, XDim);
          XtAddCallback((XDV->Menu).saveAs, XmNactivateCallback,
		   WD_PopDataSaveAs, XDim);
          XtAddCallback((XDV->Menu).export, XmNactivateCallback,
		   WD_ManageExport, XDim);
	  XtAddCallback(XDV->DArea, XmNexposeCallback,
			XT_Redraw, (XtPointer)VWI);
	  XtAddCallback(XDV->DArea, XmNinputCallback,
			WD_DrawInput, (XtPointer)VWI);
	  XtAddCallback((XDV->Menu).createLink, XmNactivateCallback,
			WD_PopCreateLink, XDim);
	  XtAddCallback((XDV->Menu).showLinks, XmNactivateCallback,
			WD_PopShowLink, XDim);
	  XtAddCallback((XDV->Menu).deleteLink, XmNactivateCallback,
			WD_PopDeleteLink, XDim);
	  XtAddCallback((XDV->Menu).HelpButton, XmNactivateCallback,
			XT_Popitup, (XDW->Help).viewShell);
	  XtPopup(XDV->Shell, XtGrabNone);
	/* Add event handler */
	  XtAddEventHandler(XDV->Shell, FocusChangeMask, False,
	  	XT_SetViewport, (XtPointer)&(VWI->port));
	 }
      }       
}

/*
 * set the fast redraw method
 */

void WD_SetFastRedraw(Widget w, XtPointer client_data, XtPointer call_data)
   {
    extern XDimInfo XDim;

    if(client_data)
      {
       XDim.FastRedraw = client_data;
       if(client_data == (funcCast)XT_RedrawGrid
		|| client_data == (funcCast)XT_RedrawLines)
         XDim.ClearFast = HW_ClearWindow;
       else
         XDim.ClearFast = HW_ClearPict;
      }
   }

/*
 * set the normal redraw method
 */

void WD_SetNormalRedraw(Widget w, XtPointer client_data, XtPointer call_data)
   {
    extern XDimInfo XDim;

    if(client_data)
      {
       XDim.NormalRedraw = client_data;
       if(client_data == (funcCast)XT_RedrawLines
		|| client_data == (funcCast)XT_RedrawCut2D)
         XDim.ClearNormal = HW_ClearWindow;
       else
         XDim.ClearNormal = HW_ClearPict;
      }
   }

/*
 * Create Main Menu Bar
 */

void WD_CreateMainMenuBar(Widget parent, XDimMainMenuBar *XDM)
   {
    extern void XD_Quit(Widget, XtPointer, XtPointer);

    /*
     * Create Menu Bar
     */
    XDM->Bar = XmCreateMenuBar( parent, "menuBar", NULL, 0);
    /*
     * Create File Menu
     */
    XDM->FileButton = XtVaCreateManagedWidget(
	"fileMenu",
	xmCascadeButtonWidgetClass,
	XDM->Bar,
	NULL);
    XDM->FileMenu = XmCreatePulldownMenu(
	XDM->Bar,
	"fileMenu",
	NULL,
	0);
    /*
     * Create setup menu
     */

    XDM->SetupButton = XtVaCreateManagedWidget(
	"setupMenu",
	xmCascadeButtonWidgetClass,
	XDM->Bar,
	NULL);
    XDM->SetupMenu = XmCreatePulldownMenu(
	XDM->Bar,
	"setupMenu",
	NULL,
	0);
    /*
     * Create Help
     */

    XDM->HelpButton = XtVaCreateManagedWidget(
	"Help",
	xmCascadeButtonWidgetClass,
	XDM->Bar,
	NULL);
    
    /*
     * Create File Menu Items
     */
    XDM->pref = XtVaCreateManagedWidget(
	"Preferences",
	xmPushButtonWidgetClass,
	XDM->FileMenu,
	NULL); 
    XDM->sep1 = XtVaCreateManagedWidget(
	"separator",
	xmSeparatorGadgetClass,
	XDM->FileMenu,
	NULL); 
    XDM->quit = XtVaCreateManagedWidget(
	"Quit",
	xmPushButtonWidgetClass,
	XDM->FileMenu,
	NULL); 
    /*
     * Create Setup Menu Items
     */
    XDM->useLinks = XtVaCreateManagedWidget(
	"useLinks",
	xmToggleButtonGadgetClass,
	XDM->SetupMenu,
	NULL); 
    XDM->colors = XtVaCreateManagedWidget(
	"Preferences",
	xmPushButtonWidgetClass,
	XDM->SetupMenu,
	NULL); 
    XDM->FastRedrawButton = XtVaCreateManagedWidget(
	"FastRedraw",
	xmCascadeButtonWidgetClass,
	XDM->SetupMenu,
	NULL); 
    XDM->FastMenu = XmCreatePulldownMenu(
	XDM->FastRedrawButton,
	"fastMenu",
	NULL,
	0);
    XDM->NormRedrawButton = XtVaCreateManagedWidget(
	"NormalRedraw",
	xmCascadeButtonWidgetClass,
	XDM->SetupMenu,
	NULL); 
    XDM->NormMenu = XmCreatePulldownMenu(
	XDM->NormRedrawButton,
	"normMenu",
	NULL,
	0);

/* normal redraw menu */

    XDM->NLines = XtVaCreateManagedWidget(
	"Lines",              /* widget name */
	xmToggleButtonGadgetClass,     /* widget class from PushB.h */
	XDM->NormMenu,                /* parent widget*/
	NULL);
    XDM->NHidden = XtVaCreateManagedWidget(
	"Hidden",              /* widget name */
	xmToggleButtonGadgetClass,     /* widget class from PushB.h */
	XDM->NormMenu,                /* parent widget*/
	NULL);
    XDM->NFilled = XtVaCreateManagedWidget(
	"Filled",              /* widget name */
	xmToggleButtonGadgetClass,     /* widget class from PushB.h */
	XDM->NormMenu,                /* parent widget*/
	NULL);
    XDM->NHFilled = XtVaCreateManagedWidget(
	"HFilled",              /* widget name */
	xmToggleButtonGadgetClass,     /* widget class from PushB.h */
	XDM->NormMenu,                /* parent widget*/
        XmNset, True,
	NULL);
    XDM->NComFilled = XtVaCreateManagedWidget(
	"ComFilled",              /* widget name */
	xmToggleButtonGadgetClass,     /* widget class from PushB.h */
	XDM->NormMenu,                /* parent widget*/
	NULL);
    XDM->NComHFilled = XtVaCreateManagedWidget(
	"ComHFilled",              /* widget name */
	xmToggleButtonGadgetClass,     /* widget class from PushB.h */
	XDM->NormMenu,                /* parent widget*/
	NULL);

/* fast redraw menu */

    XDM->FGrid = XtVaCreateManagedWidget(
	"Grid",              /* widget name */
	xmToggleButtonGadgetClass,     /* widget class from PushB.h */
	XDM->FastMenu,                /* parent widget*/
	NULL);
    XDM->FLines = XtVaCreateManagedWidget(
	"Lines",              /* widget name */
	xmToggleButtonGadgetClass,     /* widget class from PushB.h */
	XDM->FastMenu,                /* parent widget*/
	NULL);
    XDM->FHidden = XtVaCreateManagedWidget(
	"Hidden",              /* widget name */
	xmToggleButtonGadgetClass,     /* widget class from PushB.h */
	XDM->FastMenu,                /* parent widget*/
        XmNset, True,
	NULL);
    XDM->FFilled = XtVaCreateManagedWidget(
	"Filled",              /* widget name */
	xmToggleButtonGadgetClass,     /* widget class from PushB.h */
	XDM->FastMenu,                /* parent widget*/
	NULL);
    XDM->FHFilled = XtVaCreateManagedWidget(
	"HFilled",              /* widget name */
	xmToggleButtonGadgetClass,     /* widget class from PushB.h */
	XDM->FastMenu,                /* parent widget*/
	NULL);
    /*
     * Manage menu bar
     */

    XtVaSetValues(XDM->Bar,
	XmNleftAttachment, XmATTACH_FORM,
	XmNrightAttachment, XmATTACH_FORM,
	XmNmenuHelpWidget, XDM->HelpButton,
	NULL);
    XtManageChild(XDM->Bar);
    /*
     * Add callbacks
     */
    XtAddCallback(XDM->quit, XmNactivateCallback, XD_Quit, 0);
    /*
     * Specify the popup menu's
     */
    XtVaSetValues(XDM->FileButton,
	XmNsubMenuId, XDM->FileMenu,
	NULL);
    XtVaSetValues(XDM->SetupButton,
	XmNsubMenuId, XDM->SetupMenu,
	NULL);
    XtVaSetValues(XDM->FastRedrawButton,
	XmNsubMenuId, XDM->FastMenu,
	NULL);
    XtVaSetValues(XDM->NormRedrawButton,
	XmNsubMenuId, XDM->NormMenu,
	NULL);
    XtVaSetValues(XDM->NormMenu,
        XmNradioBehavior, True,
        XmNradioAlwaysOne, True,
	NULL);
    XtVaSetValues(XDM->FastMenu,
        XmNradioBehavior, True,
        XmNradioAlwaysOne, True,
	NULL);
   }


/*
 * Create menu's that are the same for all viewport's
 */

void WD_CreateViewSubMenus(Widget parent, XDimInfo *XDim )
   {
    XDimViewMenus *XDVM;

    XDVM = &(XDim->myWidgets.ViewMenus);
    /*
     * Create Preference Menu
     */

    XDVM->PrefMenu = XmCreatePulldownMenu(
	parent,
	"prefMenu",
	NULL,
	0);
    
    /*
     * Create Preference Menu Items
     */
    XDVM->Window = XtVaCreateManagedWidget(
	"Window",
	xmPushButtonWidgetClass,
	XDVM->PrefMenu,
	NULL); 
    XDVM->Grid = XtVaCreateManagedWidget(
	"Grid",
	xmPushButtonWidgetClass,
	XDVM->PrefMenu,
	NULL); 
    XDVM->Move = XtVaCreateManagedWidget(
	"Movement",
	xmPushButtonWidgetClass,
	XDVM->PrefMenu,
	NULL); 

    /*
     * Create Data Menu
     */

    XDVM->DataMenu = XmCreatePulldownMenu(
	parent,
	"DataMenu",
	NULL,
	0);
    
    /*
     * Create Data Menu Items
     */
    XDVM->redraw = XtVaCreateManagedWidget(
	"Redraw",
	xmPushButtonWidgetClass,
	XDVM->DataMenu,
	NULL); 
    XDVM->edit = XtVaCreateManagedWidget(
	"Edit",
	xmToggleButtonGadgetClass,
	XDVM->DataMenu,
	NULL); 
    XDVM->sep1 = XtVaCreateManagedWidget(
	"separator",
	xmSeparatorGadgetClass,
	XDVM->DataMenu,
	NULL); 
    XDVM->rangeButton = XtVaCreateManagedWidget(
	"Range",
	xmCascadeButtonWidgetClass,
	XDVM->DataMenu,
	NULL); 
    XDVM->size = XtVaCreateManagedWidget(
	"Size",
	xmPushButtonWidgetClass,
	XDVM->DataMenu,
	NULL); 
    XDVM->sep2 = XtVaCreateManagedWidget(
	"separator",
	xmSeparatorGadgetClass,
	XDVM->DataMenu,
	NULL); 
    XDVM->transButton = XtVaCreateManagedWidget(
	"Transform",
	xmCascadeButtonWidgetClass,
	XDVM->DataMenu,
	NULL); 
    XDVM->castButton = XtVaCreateManagedWidget(
	"Cast",
	xmCascadeButtonWidgetClass,
	XDVM->DataMenu,
	NULL); 
    XDVM->fieldButton = XtVaCreateManagedWidget(
	"Field",
	xmCascadeButtonWidgetClass,
	XDVM->DataMenu,
	NULL); 
    XDVM->complexButton = XtVaCreateManagedWidget(
	"Complex",
	xmCascadeButtonWidgetClass,
	XDVM->DataMenu,
	NULL); 
    XDVM->filterButton = XtVaCreateManagedWidget(
	"Filter",
	xmCascadeButtonWidgetClass,
	XDVM->DataMenu,
	NULL); 

    /*
     * Create Range Menu
     */

    XDVM->rangeMenu = XmCreatePulldownMenu(
	XDVM->DataMenu,
	"rangeMenu",
	NULL,
	0);
    
    /*
     * Create Range Menu Items
     */
    XDVM->rgX = XtVaCreateManagedWidget(
	"X",
	xmPushButtonWidgetClass,
	XDVM->rangeMenu,
	NULL); 
    XDVM->rgY = XtVaCreateManagedWidget(
	"Y",
	xmPushButtonWidgetClass,
	XDVM->rangeMenu,
	NULL); 
    XDVM->rgZ = XtVaCreateManagedWidget(
	"Z",
	xmPushButtonWidgetClass,
	XDVM->rangeMenu,
	NULL); 

    /*
     * Create Transform Menu
     */

    XDVM->transMenu = XmCreatePulldownMenu(
	XDVM->DataMenu,
	"TransMenu",
	NULL,
	0);
    
    /*
     * Create Transform Menu Items
     */
    XDVM->mirrorX = XtVaCreateManagedWidget(
	"MirrorX",
	xmPushButtonWidgetClass,
	XDVM->transMenu,
	NULL); 
    XDVM->mirrorY = XtVaCreateManagedWidget(
	"MirrorY",
	xmPushButtonWidgetClass,
	XDVM->transMenu,
	NULL); 
    XDVM->neg = XtVaCreateManagedWidget(
	"Neg",
	xmPushButtonWidgetClass,
	XDVM->transMenu,
	NULL); 
    XDVM->sep3 = XtVaCreateManagedWidget(
	"separator",
	xmSeparatorGadgetClass,
	XDVM->transMenu,
	NULL); 
    XDVM->abs = XtVaCreateManagedWidget(
	"Abs",
	xmPushButtonWidgetClass,
	XDVM->transMenu,
	NULL); 
    XDVM->quad = XtVaCreateManagedWidget(
	"Quad",
	xmPushButtonWidgetClass,
	XDVM->transMenu,
	NULL); 
    XDVM->squr = XtVaCreateManagedWidget(
	"Sqrt",
	xmPushButtonWidgetClass,
	XDVM->transMenu,
	NULL); 
    XDVM->x1 = XtVaCreateManagedWidget(
	"1/x",
	xmPushButtonWidgetClass,
	XDVM->transMenu,
	NULL); 
    XDVM->log = XtVaCreateManagedWidget(
	"Log",
	xmPushButtonWidgetClass,
	XDVM->transMenu,
	NULL); 
    XDVM->log10 = XtVaCreateManagedWidget(
	"Log10",
	xmPushButtonWidgetClass,
	XDVM->transMenu,
	NULL); 
    XDVM->exp = XtVaCreateManagedWidget(
	"Exp",
	xmPushButtonWidgetClass,
	XDVM->transMenu,
	NULL); 
    XDVM->offset = XtVaCreateManagedWidget(
	"Offset",
	xmPushButtonWidgetClass,
	XDVM->transMenu,
	NULL); 
    XDVM->scale = XtVaCreateManagedWidget(
	"Scale",
	xmPushButtonWidgetClass,
	XDVM->transMenu,
	NULL); 
    /*
     * Create Cast Menu
     */

    XDVM->castMenu = XmCreatePulldownMenu(
	XDVM->DataMenu,
	"CastMenu",
	NULL,
	0);
    
    /*
     * Create Cast Menu Items
     */
    XDVM->uchr = XtVaCreateManagedWidget(
	"UChar",
	xmPushButtonWidgetClass,
	XDVM->castMenu,
	NULL); 
    XDVM->dble = XtVaCreateManagedWidget(
	"Double",
	xmPushButtonWidgetClass,
	XDVM->castMenu,
	NULL); 
    /*
     * Create Field Menu
     */

    XDVM->fieldMenu = XmCreatePulldownMenu(
	XDVM->DataMenu,
	"fieldMenu",
	NULL,
	0);
    
    /*
     * Create Field Menu Items
     */
    XDVM->new = XtVaCreateManagedWidget(
	"New",
	xmPushButtonWidgetClass,
	XDVM->fieldMenu,
	NULL); 
    XDVM->add = XtVaCreateManagedWidget(
	"Add",
	xmPushButtonWidgetClass,
	XDVM->fieldMenu,
	NULL); 
    XDVM->sub = XtVaCreateManagedWidget(
	"Sub",
	xmPushButtonWidgetClass,
	XDVM->fieldMenu,
	NULL); 
    XDVM->mul = XtVaCreateManagedWidget(
	"Mul",
	xmPushButtonWidgetClass,
	XDVM->fieldMenu,
	NULL); 
    XDVM->div = XtVaCreateManagedWidget(
	"Div",
	xmPushButtonWidgetClass,
	XDVM->fieldMenu,
	NULL); 

    /*
     * Create Complex Menu
     */

    XDVM->complexMenu = XmCreatePulldownMenu(
	XDVM->DataMenu,
	"complexMenu",
	NULL,
	0);
    
    /*
     * Create Complex Menu Items
     */
    XDVM->cxy = XtVaCreateManagedWidget(
	"RealImag",
	xmPushButtonWidgetClass,
	XDVM->complexMenu,
	NULL); 
    XDVM->cphi = XtVaCreateManagedWidget(
	"AbsPhi",
	xmPushButtonWidgetClass,
	XDVM->complexMenu,
	NULL); 
    XDVM->cadd = XtVaCreateManagedWidget(
	"Add",
	xmPushButtonWidgetClass,
	XDVM->complexMenu,
	NULL); 
    XDVM->csub = XtVaCreateManagedWidget(
	"Sub",
	xmPushButtonWidgetClass,
	XDVM->complexMenu,
	NULL); 
    XDVM->cmul = XtVaCreateManagedWidget(
	"Mul",
	xmPushButtonWidgetClass,
	XDVM->complexMenu,
	NULL); 
    XDVM->cdiv = XtVaCreateManagedWidget(
	"Div",
	xmPushButtonWidgetClass,
	XDVM->complexMenu,
	NULL); 
    XDVM->fft = XtVaCreateManagedWidget(
	"FFT",
	xmPushButtonWidgetClass,
	XDVM->complexMenu,
	NULL); 
    XDVM->ifft = XtVaCreateManagedWidget(
	"InvFFT",
	xmPushButtonWidgetClass,
	XDVM->complexMenu,
	NULL); 
    /*
     * Create Filter Menu
     */

    XDVM->filterMenu = XmCreatePulldownMenu(
	XDVM->DataMenu,
	"filterMenu",
	NULL,
	0);
    
    /*
     * Create Filter Menu Items
     */

    XDVM->lpassButton = XtVaCreateManagedWidget(
	"Lowpass",
	xmCascadeButtonWidgetClass,
	XDVM->filterMenu,
	NULL); 
    XDVM->hipassButton = XtVaCreateManagedWidget(
	"Highpass",
	xmCascadeButtonWidgetClass,
	XDVM->filterMenu,
	NULL); 
    XDVM->oFButton = XtVaCreateManagedWidget(
	"Other",
	xmCascadeButtonWidgetClass,
	XDVM->filterMenu,
	NULL); 

    /*
     * Create lowpass Menu
     */

    XDVM->lowpassMenu = XmCreatePulldownMenu(
	XDVM->filterMenu,
	"lpassMenu",
	NULL,
	0);
    
    /*
     * Create Lowpass Menu Items
     */

    XDVM->idealL = XtVaCreateManagedWidget(
	"Ideal",
	xmPushButtonWidgetClass,
	XDVM->lowpassMenu,
	NULL); 
    XDVM->butWL = XtVaCreateManagedWidget(
	"Butterworth",
	xmPushButtonWidgetClass,
	XDVM->lowpassMenu,
	NULL); 
    XDVM->gaussL = XtVaCreateManagedWidget(
	"Gauss",
	xmPushButtonWidgetClass,
	XDVM->lowpassMenu,
	NULL); 

    /*
     * Create highpass Menu
     */

    XDVM->highpassMenu = XmCreatePulldownMenu(
	XDVM->filterMenu,
	"hipassMenu",
	NULL,
	0);
    
    /*
     * Create Highpass Menu Items
     */

    XDVM->idealH = XtVaCreateManagedWidget(
	"Ideal",
	xmPushButtonWidgetClass,
	XDVM->highpassMenu,
	NULL); 
    XDVM->butWH = XtVaCreateManagedWidget(
	"Butterworth",
	xmPushButtonWidgetClass,
	XDVM->highpassMenu,
	NULL); 
    XDVM->gaussH = XtVaCreateManagedWidget(
	"Gauss",
	xmPushButtonWidgetClass,
	XDVM->highpassMenu,
	NULL); 
    /*
     * Create other Filter Menu
     */

    XDVM->otherFMenu = XmCreatePulldownMenu(
	XDVM->filterMenu,
	"otherFMenu",
	NULL,
	0);
    
    /*
     * Create other Filter Menu Items
     */

    XDVM->median = XtVaCreateManagedWidget(
	"Median",
	xmPushButtonWidgetClass,
	XDVM->otherFMenu,
	NULL); 
    XDVM->matrix = XtVaCreateManagedWidget(
	"Matrix",
	xmPushButtonWidgetClass,
	XDVM->otherFMenu,
	NULL); 
   /*
    * Create Submenus
    */


    XtVaSetValues(XDVM->rangeButton, XmNsubMenuId, XDVM->rangeMenu, NULL);
    XtVaSetValues(XDVM->transButton, XmNsubMenuId, XDVM->transMenu, NULL);
    XtVaSetValues(XDVM->castButton, XmNsubMenuId, XDVM->castMenu, NULL);
    XtVaSetValues(XDVM->fieldButton, XmNsubMenuId, XDVM->fieldMenu, NULL);
    XtVaSetValues(XDVM->complexButton, XmNsubMenuId, XDVM->complexMenu, NULL);
    XtVaSetValues(XDVM->filterButton, XmNsubMenuId, XDVM->filterMenu, NULL);
    XtVaSetValues(XDVM->lpassButton, XmNsubMenuId, XDVM->lowpassMenu, NULL);
    XtVaSetValues(XDVM->hipassButton, XmNsubMenuId, XDVM->highpassMenu, NULL);
    XtVaSetValues(XDVM->oFButton, XmNsubMenuId, XDVM->otherFMenu, NULL);

    /*
     * Add callbacks
     */
    XtAddCallback(XDVM->Window, XmNactivateCallback,
	WD_ManageWinPref, XDim);
    XtAddCallback(XDVM->Grid, XmNactivateCallback,
	WD_ManageGridPref, XDim);
    XtAddCallback(XDVM->Move, XmNactivateCallback,
	WD_ManageMovPref, XDim);
    XtAddCallback(XDVM->redraw, XmNactivateCallback,
	XT_ForceActRedraw, XDim);
    XtAddCallback(XDVM->edit, XmNvalueChangedCallback,
	WD_SetEdit, XDim);
    XtAddCallback(XDVM->rgX, XmNactivateCallback,
	WD_PopRange, XDim);
    XtAddCallback(XDVM->rgY, XmNactivateCallback,
	WD_PopRange, XDim);
    XtAddCallback(XDVM->rgZ, XmNactivateCallback,
	WD_PopRange, XDim);
    XtAddCallback(XDVM->mirrorX, XmNactivateCallback,
	MA_MirrorX, XDim);
    XtAddCallback(XDVM->mirrorY, XmNactivateCallback,
	MA_MirrorY, XDim);
    XtAddCallback(XDVM->neg, XmNactivateCallback,
	MA_Neg, XDim);
    XtAddCallback(XDVM->abs, XmNactivateCallback,
	MA_Abs, XDim);
    XtAddCallback(XDVM->quad, XmNactivateCallback,
	MA_Quad, XDim);
    XtAddCallback(XDVM->squr, XmNactivateCallback,
	MA_Sqrt, XDim);
    XtAddCallback(XDVM->log, XmNactivateCallback,
	MA_Log, XDim);
    XtAddCallback(XDVM->log10, XmNactivateCallback,
	MA_Log10, XDim);
    XtAddCallback(XDVM->exp, XmNactivateCallback,
	MA_Exp, XDim);
    XtAddCallback(XDVM->x1, XmNactivateCallback,
	MA_1x, XDim);
    XtAddCallback(XDVM->uchr, XmNactivateCallback,
	WD_CastData, &CUChar);
    XtAddCallback(XDVM->dble, XmNactivateCallback,
	WD_CastData, &CDouble);
    XtAddCallback(XDVM->scale, XmNactivateCallback,
	MA_GetScale, XDim);
    XtAddCallback(XDVM->offset, XmNactivateCallback,
	MA_GetOffset, XDim);
    XtAddCallback(XDVM->new, XmNactivateCallback,
	MA_StartNew, XDim);
    XtAddCallback(XDVM->add, XmNactivateCallback,
	MA_StartAdd, XDim);
    XtAddCallback(XDVM->sub, XmNactivateCallback,
	MA_StartSub, XDim);
    XtAddCallback(XDVM->mul, XmNactivateCallback,
	MA_StartMul, XDim);
    XtAddCallback(XDVM->div, XmNactivateCallback,
	MA_StartDiv, XDim);
    XtAddCallback(XDVM->cphi, XmNactivateCallback,
	MA_AbsPhi, XDim);
    XtAddCallback(XDVM->cxy, XmNactivateCallback,
	MA_cxy, XDim);
    XtAddCallback(XDVM->cadd, XmNactivateCallback,
	MA_StartCAdd, XDim);
    XtAddCallback(XDVM->cdiv, XmNactivateCallback,
	MA_StartCDiv, XDim);
    XtAddCallback(XDVM->cmul, XmNactivateCallback,
	MA_StartCMul, XDim);
    XtAddCallback(XDVM->csub, XmNactivateCallback,
	MA_StartCSub, XDim);
    XtAddCallback(XDVM->fft, XmNactivateCallback,
	MA_StartFFT, XDim);
    XtAddCallback(XDVM->ifft, XmNactivateCallback,
	MA_StartFFT, XDim);
    XtAddCallback(XDVM->idealL, XmNactivateCallback,
	MA_StartHiLo, (XtPointer)IdealL);
    XtAddCallback(XDVM->idealH, XmNactivateCallback,
	MA_StartHiLo, (XtPointer)IdealH);
    XtAddCallback(XDVM->gaussL, XmNactivateCallback,
	MA_StartHiLo, (XtPointer)GaussL);
    XtAddCallback(XDVM->gaussH, XmNactivateCallback,
	MA_StartHiLo, (XtPointer)GaussH);
    XtAddCallback(XDVM->butWL, XmNactivateCallback,
	MA_StartHiLo, (XtPointer)ButwL);
    XtAddCallback(XDVM->butWH, XmNactivateCallback,
	MA_StartHiLo, (XtPointer)ButwH);
    XtAddCallback(XDVM->median, XmNactivateCallback,
	MA_StartOtherF, XDim);
    XtAddCallback(XDVM->matrix, XmNactivateCallback,
	MA_StartOtherF, XDim);
   }

/*
 * Init the font for output
 */

void WD_InitFont(XDimInfo *XDim)
   {
    XmFontContext context;
    XmFontList fonts;
    XmStringCharSet charset;
    XDHardwareInfo *HWI;

    HWI = &(XDim->hwInfo);
    HWI->defaultFont = True;
    XtVaGetValues(XDim->myWidgets.MainMessage,
		XmNfontList,&fonts,
		NULL);
    if(XmFontListInitFontContext(&context,fonts))
      {
       XmFontListGetNextFont(context, &charset, &(HWI->font));
       XSetFont(HWI->dpy, HWI->gc, HWI->font->fid);
       XSetFont(HWI->dpy, HWI->textGC, HWI->font->fid);
       XSetFont(HWI->dpy, HWI->binGC, HWI->font->fid);
       XmFontListFreeFontContext(context);
      }
    else
      {
       strcpy(XDim->error, "Couldn't locate the default font");
       WD_XDimError(XDim, NULL);
      }
   }

/*
 * Create Mainwindow Pushbuttons
 */

void WD_CreatePushButton(Widget parent, char *Name, 
		    Widget *NewButton, char *myBitmap, unsigned int width,
		    unsigned int height)
   {
    Pixel Color1, Color2;
    Pixmap mypixmap;
    
    *NewButton = XtVaCreateManagedWidget(
	Name,              /* widget name */
	xmPushButtonWidgetClass,     /* widget class from PushB.h */
	parent,                  /* parent widget*/
	NULL);
    XtVaGetValues(*NewButton,
    		XtNforeground, &Color1,
    		XtNbackground, &Color2,
    		NULL);
    mypixmap= XCreatePixmapFromBitmapData(XtDisplay(*NewButton), 
                RootWindowOfScreen(XtScreen(*NewButton)), myBitmap, width,
                height, Color1,
                Color2, DefaultDepthOfScreen(XtScreen(*NewButton)));
    XtVaSetValues(*NewButton,
            XmNlabelType, XmPIXMAP,
            XmNlabelPixmap, mypixmap,
            NULL);
   }

/*
 * Realize the Mainwindow
 */

void WD_CreateMainPushButtons(Widget parent, XDimMainPushButtons *XDP
		, Widget top)
   {

    XDP->PBFrame = XtVaCreateManagedWidget(
	"pbframe",
	xmFrameWidgetClass,
	parent,
	XmNshadowType, XmSHADOW_ETCHED_OUT,
	XmNtopAttachment, XmATTACH_WIDGET, /* position the label*/
	XmNtopWidget, top, 		/* relativ to top */
	NULL);    
    XDP->PBRowCol= XtVaCreateManagedWidget(
	"buttons",             /* widget name */
	xmRowColumnWidgetClass,  /* widget class */
	XDP->PBFrame,           /* parent widget*/
	XmNorientation, XmHORIZONTAL,
	XmNmarginWidth, 0,
	XmNmarginHeight, 0,
	XmNspacing, 0,
	XmNpacking, XmPACK_COLUMN,
	XmNnumColumns, 2,
	NULL);              /* argument list*/

    /* Manipulate Position upper*/
    WD_CreatePushButton(XDP->PBRowCol, "RotLeft", &(XDP->RotLeft),
		    (char *)rotzp_bits, rotzp_width, rotzp_height);
    WD_CreatePushButton(XDP->PBRowCol, "RotUp", &(XDP->RotUp),
		    (char *)rotxyp_bits, rotxyp_width, rotxyp_height);
    WD_CreatePushButton(XDP->PBRowCol, "MoveLeft", &(XDP->MoveLeft),
		    (char *)left_bits, left_width, left_height);
    WD_CreatePushButton(XDP->PBRowCol, "MoveUp", &(XDP->MoveUp),
		    (char *)up_bits, up_width, up_height);
    WD_CreatePushButton(XDP->PBRowCol, "ZoomXY+", &(XDP->ZoomXYP),
		    (char *)zoomxyp_bits, zoomxyp_width, zoomxyp_height);
    WD_CreatePushButton(XDP->PBRowCol, "ZoomZ+", &(XDP->ZoomZP),
		    (char *)zoomzp_bits, zoomzp_width, zoomzp_height);
    /* Manipulate Position lower*/
    WD_CreatePushButton(XDP->PBRowCol, "RotRight", &(XDP->RotRight),
		    (char *)rotzm_bits, rotzm_width, rotzm_height);
    WD_CreatePushButton(XDP->PBRowCol, "RotDown", &(XDP->RotDown),
		    (char *)rotxym_bits, rotxym_width, rotxym_height);
    WD_CreatePushButton(XDP->PBRowCol, "MoveRight", &(XDP->MoveRight),
		    (char *)right_bits, right_width, right_height);
    WD_CreatePushButton(XDP->PBRowCol, "MoveDown", &(XDP->MoveDown),
		    (char *)down_bits, down_width, down_height);
    WD_CreatePushButton(XDP->PBRowCol, "ZoomXY-", &(XDP->ZoomXYM),
		    (char *)zoomxym_bits, zoomxym_width, zoomxym_height);
    WD_CreatePushButton(XDP->PBRowCol, "ZoomZ-", &(XDP->ZoomZM),
		    (char *)zoomzm_bits, zoomzm_width, zoomzm_height);
   }

void WD_CreateMain(Widget parent, XDimInfo *XDim)
{
    XDimWidgets *XDW;

    XDW = &(XDim->myWidgets);
    /*
     * Init some Values
     */

    (XDW->EditMatrix).Values = NULL;
    (XDW->EditMatrix).Matrix = NULL;

    /*
     * Create Main Window
     */
    XDW->MainForm = XtVaCreateManagedWidget(
            "main",              /* arbitrary widget name */
            xmFormWidgetClass,     /* widget class  */
            parent,              /* parent widget*/
            NULL);               /* terminate varargs list */

    WD_CreateMainMenuBar(XDW->MainForm, &(XDW->MainMenu));
    WD_CreateViewSubMenus(XDW->MainMenu.Bar, XDim);
    XDW->MessageFrame= XtVaCreateManagedWidget(
	"messageFrame",
	xmFrameWidgetClass,
	XDW->MainForm,
	XmNshadowType, XmSHADOW_ETCHED_OUT,
	XmNtopAttachment, XmATTACH_WIDGET, /* position the label*/
	XmNtopWidget, (XDW->MainMenu).Bar, /* relativ to the Menu Bar */
	XmNleftAttachment, XmATTACH_FORM,	/* fix it to the window */
	XmNrightAttachment, XmATTACH_FORM,
	NULL);    
    XDW->MainMessage = XtVaCreateManagedWidget(
	"message",              /* widget name */
	xmLabelWidgetClass,     /* widget class from PushB.h */
	XDW->MessageFrame,                  /* parent widget*/
        XmNwidth, 100,		/* minimum width */
	NULL);
		
    WD_CreateMainPushButtons(XDW->MainForm, &(XDW->MainButtons)
		, XDW->MessageFrame);

    /* Show Colors */
    WD_CreatePushButton(XDW->MainForm, "ShowCol", &(XDW->ShowCol),
		    (char*)colors_bits, colors_width, colors_height);
    XtVaSetValues(XDW->ShowCol,
	XmNtopAttachment, XmATTACH_WIDGET, /* position the label*/
	XmNtopWidget, (XDW->MainButtons).PBFrame, 		/* relativ to top */
        XmNtopOffset, 10,
	XmNrightAttachment, XmATTACH_POSITION,	/* fix it to the window */
        XmNrightPosition, 50,
        XmNbottomAttachment, XmATTACH_POSITION,
        XmNbottomPosition, 90,
        NULL);
    /* New View */
    WD_CreatePushButton(XDW->MainForm, "NewView", &(XDW->NewView),
		    (char*)view_bits, view_width, view_height);
    XtVaSetValues(XDW->NewView,
	XmNtopAttachment, XmATTACH_WIDGET, /* position the label*/
	XmNtopWidget, (XDW->MainButtons).PBFrame, 		/* relativ to top */
        XmNtopOffset, 10,
	XmNleftAttachment, XmATTACH_POSITION,	/* fix it to the window */
        XmNleftPosition, 50,
        XmNbottomAttachment, XmATTACH_POSITION,
        XmNbottomPosition, 90,
        NULL);
    /* Set Use Links */
    XtVaSetValues((XDW->MainMenu).useLinks,
	  XmNset, XDim->useLinks, NULL);
    /* File selection */
    XDW->FileSelect = XmCreateFileSelectionDialog(parent, "fileSelect", NULL, 0);
    XDW->activeFSCallback = NULL;
    XDW->DataSelect = XmCreateFileSelectionDialog(parent, "dataSelect", NULL, 0);
    XDW->activeDTCallback = NULL;
    /* Input Field */
    XDW->activeInpCallback = NULL;
    /* Error box */
    XDW->ErrorBox = XmCreateErrorDialog(parent,"errorBox", NULL, 0);
    /* Error box callbacks */
    XtAddCallback(XDW->ErrorBox, XmNcancelCallback,
                   WD_XDimErrorOk, XDim);
    XtAddCallback(XDW->ErrorBox, XmNokCallback,
                   WD_XDimErrorOk, XDim);
    /* File selection callbacks */
    XtAddCallback(XDW->FileSelect, XmNcancelCallback,
                   XT_UnmanageIt, XDW->FileSelect);
    XtAddCallback(XDW->DataSelect, XmNcancelCallback,
                   XT_UnmanageIt, XDW->DataSelect);
    /* Main window button callbacks */
    XtAddCallback(XDW->NewView, XmNactivateCallback,
    		   WD_CreateViewport, XDim);
    XtAddCallback((XDW->MainButtons).RotLeft, XmNarmCallback,
    		   XT_StartRotLeft, XDim);
    XtAddCallback((XDW->MainButtons).RotLeft, XmNdisarmCallback,
    		   XT_StopTimer, XDim);
    XtAddCallback((XDW->MainButtons).RotRight, XmNarmCallback,
    		   XT_StartRotRight, XDim);
    XtAddCallback((XDW->MainButtons).RotRight, XmNdisarmCallback,
    		   XT_StopTimer, XDim);
    XtAddCallback((XDW->MainButtons).RotUp, XmNarmCallback,
    		   XT_StartRotUp, XDim);
    XtAddCallback((XDW->MainButtons).RotUp, XmNdisarmCallback,
    		   XT_StopTimer, XDim);
    XtAddCallback((XDW->MainButtons).RotDown, XmNarmCallback,
    		   XT_StartRotDown, XDim);
    XtAddCallback((XDW->MainButtons).RotDown, XmNdisarmCallback,
    		   XT_StopTimer, XDim);
    XtAddCallback((XDW->MainButtons).ZoomXYP, XmNarmCallback,
    		   XT_StartZoomXYPlus, XDim);
    XtAddCallback((XDW->MainButtons).ZoomXYP, XmNdisarmCallback,
    		   XT_StopTimer, XDim);
    XtAddCallback((XDW->MainButtons).ZoomXYM, XmNarmCallback,
    		   XT_StartZoomXYMinus, XDim);
    XtAddCallback((XDW->MainButtons).ZoomXYM, XmNdisarmCallback,
    		   XT_StopTimer, XDim);
    XtAddCallback((XDW->MainButtons).ZoomZP, XmNarmCallback,
    		   XT_StartZoomZPlus, XDim);
    XtAddCallback((XDW->MainButtons).ZoomZP, XmNdisarmCallback,
    		   XT_StopTimer, XDim);
    XtAddCallback((XDW->MainButtons).ZoomZM, XmNarmCallback,
    		   XT_StartZoomZMinus, XDim);
    XtAddCallback((XDW->MainButtons).ZoomZM, XmNdisarmCallback,
    		   XT_StopTimer, XDim);
    XtAddCallback((XDW->MainButtons).MoveLeft, XmNarmCallback,
    		   XT_StartMoveLeft, XDim);
    XtAddCallback((XDW->MainButtons).MoveLeft, XmNdisarmCallback,
    		   XT_StopTimer, XDim);
    XtAddCallback((XDW->MainButtons).MoveRight, XmNarmCallback,
    		   XT_StartMoveRight, XDim);
    XtAddCallback((XDW->MainButtons).MoveRight, XmNdisarmCallback,
    		   XT_StopTimer, XDim);
    XtAddCallback((XDW->MainButtons).MoveUp, XmNarmCallback,
    		   XT_StartMoveUp, XDim);
    XtAddCallback((XDW->MainButtons).MoveUp, XmNdisarmCallback,
    		   XT_StopTimer, XDim);
    XtAddCallback((XDW->MainButtons).MoveDown, XmNarmCallback,
    		   XT_StartMoveDown, XDim);
    XtAddCallback((XDW->MainButtons).MoveDown, XmNdisarmCallback,
    		   XT_StopTimer, XDim);
    XtAddCallback((XDW->MainMenu).FGrid, XmNarmCallback,
    		   WD_SetFastRedraw, (funcCast)XT_RedrawGrid);
    XtAddCallback((XDW->MainMenu).FLines, XmNarmCallback,
    		   WD_SetFastRedraw, (funcCast)XT_RedrawLines);
    XtAddCallback((XDW->MainMenu).FHidden, XmNarmCallback,
    		   WD_SetFastRedraw, (funcCast)XT_RedrawHidden);
    XtAddCallback((XDW->MainMenu).FFilled, XmNarmCallback,
    		   WD_SetFastRedraw, (funcCast)XT_RedrawFilled);
    XtAddCallback((XDW->MainMenu).FHFilled, XmNarmCallback,
    		   WD_SetFastRedraw, (funcCast)XT_RedrawHFilled);
    XtAddCallback((XDW->MainMenu).NLines, XmNarmCallback,
    		   WD_SetNormalRedraw, (funcCast)XT_RedrawLines);
    XtAddCallback((XDW->MainMenu).NHidden, XmNarmCallback,
    		   WD_SetNormalRedraw, (funcCast)XT_RedrawHidden);
    XtAddCallback((XDW->MainMenu).NFilled, XmNarmCallback,
    		   WD_SetNormalRedraw, (funcCast)XT_RedrawFilled);
    XtAddCallback((XDW->MainMenu).NHFilled, XmNarmCallback,
    		   WD_SetNormalRedraw, (funcCast)XT_RedrawHFilled);
    XtAddCallback((XDW->MainMenu).NComFilled, XmNarmCallback,
    		   WD_SetNormalRedraw, (funcCast)XT_RedrawComFilled);
    XtAddCallback((XDW->MainMenu).NComHFilled, XmNarmCallback,
    		   WD_SetNormalRedraw, (funcCast)XT_RedrawComHFilled);
    XtAddCallback((XDW->MainMenu).useLinks, XmNvalueChangedCallback,
    		   WD_SetFlag, &(XDim->useLinks));
}


/*
 * Callback for delete color
 */
 
void WD_Select2Delete(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    XDimColorSelect *XDS;
    XDColorInfo *XDC;
    XmString Mess;

    XDim = (XDimInfo*) client_data;
    XDC = &(XDim->colors);
    XDS = &((XDim->myWidgets).ColorSelect);
    Mess = XmStringCreateSimple("Select row to delete");
    XtVaSetValues(XDS->ColorMessage,
	XmNlabelString, Mess,
	NULL);
    XmStringFree(Mess);
    if(XDS->activeCallback)
       XtRemoveCallback(XDS->ok, XmNactivateCallback,
	  XDS->activeCallback, XDS->client_data);
    XtAddCallback(XDS->ok, XmNactivateCallback,
                   XT_DeleteColorRow, XDim);
    XDS->activeCallback = XT_DeleteColorRow;
    XDS->client_data = XDim;
    XDC->single = False;
    XDC->selected = 0;
    XtPopup(XDS->ColorShell, XtGrabNone);
   }

/*
 * Callback for select edit color
 */
 
void WD_Select2Edit(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    XDimColorSelect *XDS;
    XDColorInfo *XDC;
    XmString Mess;

    XDim = (XDimInfo*) client_data;
    XDC = &(XDim->colors);
    XDS = &((XDim->myWidgets).ColorSelect);
    Mess = XmStringCreateSimple("Select row to edit");
    XtVaSetValues(XDS->ColorMessage,
	XmNlabelString, Mess,
	NULL);
    XmStringFree(Mess);
    if(XDS->activeCallback)
       XtRemoveCallback(XDS->ok, XmNactivateCallback,
	  XDS->activeCallback, XDS->client_data);
    XtAddCallback(XDS->ok, XmNactivateCallback,
                   WD_PopEdit, XDim);
    XDS->activeCallback = WD_PopEdit;
    XDS->client_data = XDim;
    XDC->single = False;
    XDC->selected = 0;
    XtPopup(XDS->ColorShell, XtGrabNone);
   }

/*
 * callback for new color
 */

void WD_PopNewColor(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    XDColorInfo *XDC;
    XDHardwareInfo *HWI;
    XDimColorEdit *XDE;
    int num,colors;

    XDim = (XDimInfo*) client_data;
    XDE = &((XDim->myWidgets).ColorEdit);
    XDC = &(XDim->colors);
    HWI = &(XDim->hwInfo);
    if(XDC->wantedColors <= MAX_COL_NUMBER-2)
      {
       colors = XDC->wantedColors;
       XDC->colorEdit = colors;
       num = XDC->rowNum;
       HW_AllocateColor(colors, (XDC->endR)[num-1], (XDC->endG)[num-1],
		(XDC->endB)[num-1], XDim);	
       HW_AllocateColor(colors+1, USHRT_MAX, USHRT_MAX,USHRT_MAX, XDim);
       if((HWI->colStat)[colors] && (HWI->colStat)[colors+1])
         {
	  XtVaSetValues(XDE->Color1,
    		      XtNbackground, (XDC->colTrans)[colors],
    		      NULL);
	  XtVaSetValues(XDE->Color2,
    		      XtNbackground, (XDC->colTrans)[colors+1],
    		      NULL);
	  XtVaSetValues(XDE->Edit,
    		      XmNsensitive, True,
    		      NULL);
	  if(XDE->activeCallback)
	    {
	     XtRemoveCallback(XDE->ok, XmNactivateCallback,
		XDE->activeCallback, XDE->client_data);
	     XtRemoveCallback(XDE->Edit, XmNactivateCallback,
		XDE->activeCallback, XDE->client_data);
	    }
	  XtAddCallback(XDE->ok, XmNactivateCallback,
		   WD_okColorNew, XDim);
	  XtAddCallback(XDE->Edit, XmNactivateCallback,
		   WD_okColorNew, XDim);
	  XDE->activeCallback = WD_okColorNew;
	  XDE->client_data = XDim;
	  XtPopup(XDE->Shell, XtGrabNone);
	 }
      }
   }

/*
 * callback for edit color
 */

void WD_PopEdit(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    XDColorInfo *XDC;
    XDHardwareInfo *HWI;
    XDimColorEdit *XDE;
    char buf[8];
    int num,colors;

    XDim = (XDimInfo*) client_data;
    XDE = &((XDim->myWidgets).ColorEdit);
    XDC = &(XDim->colors);
    HWI = &(XDim->hwInfo);
    if(XDC->wantedColors <= MAX_COL_NUMBER-2)
      {
       XtPopdown((XDim->myWidgets).ColorSelect.ColorShell);
       colors = XDC->wantedColors;
       XDC->colorEdit = colors;
       num = XDC->selected;
       HW_AllocateColor(colors, (XDC->beginR)[num], (XDC->beginG)[num],
		(XDC->beginB)[num], XDim);	
       HW_AllocateColor(colors+1, (XDC->endR)[num], (XDC->endG)[num],
		(XDC->endB)[num], XDim);	
       if((HWI->colStat)[colors] && (HWI->colStat)[colors+1])
         {
	  XtVaSetValues(XDE->Color1,
    		      XtNbackground, (XDC->colTrans)[colors],
    		      NULL);
	  XtVaSetValues(XDE->Color2,
    		      XtNbackground, (XDC->colTrans)[colors+1],
    		      NULL);
	  sprintf(buf,"%d",(XDC->colors)[num]);
	  XtVaSetValues(XDE->Edit,
    		      XtNsensitive, False,
    		      XmNvalue, buf,
    		      NULL);
	  if(XDE->activeCallback)
	    {
	     XtRemoveCallback(XDE->ok, XmNactivateCallback,
		XDE->activeCallback, XDE->client_data);
	     XtRemoveCallback(XDE->Edit, XmNactivateCallback,
		XDE->activeCallback, XDE->client_data);
	    }
	  XtAddCallback(XDE->ok, XmNactivateCallback,
		   WD_okColorEdit, XDim);
	  XtAddCallback(XDE->Edit, XmNactivateCallback,
		   WD_okColorEdit, XDim);
	  XDE->activeCallback = WD_okColorEdit;
	  XDE->client_data = XDim;
	  XtPopup(XDE->Shell, XtGrabNone);
	 }
       else
	 {
	  sprintf(XDim->error, "Sorry, there is no allocatable color cell");
	  WD_XDimError(XDim, NULL);
	 }
      }
    else
      {
       sprintf(XDim->error, "Sorry to edit, there must be less than %d colors",
	MAX_COL_NUMBER-2);
       WD_XDimError(XDim, NULL);
      }
   }

/*
 * callback for apply in color mix
 */

void WD_ApplyNewColor(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    XDColorInfo *XDC;
    XDimColorEdit *XDE;
    int colors;
    int red, green , blue;
#ifdef DEC
    DXmColorMixCallbackStruct *cs;
#endif /* DEC */

    XDim = (XDimInfo*) client_data;
    XDE = &((XDim->myWidgets).ColorEdit);
    XDC = &(XDim->colors);
    if(XDC->EditStartColor)
      {
       colors = XDC->colorEdit;
       w = XDE->Color1;
      }
    else
      {
       colors = XDC->colorEdit+1;
       w = XDE->Color2;
      }
#ifdef DEC
    cs = (DXmColorMixCallbackStruct*) call_data;
    HW_AllocateColor(colors, cs->newred, cs->newgrn, cs->newblu, XDim);	
    if(cs->reason == XmCR_ACTIVATE)
      XtUnmanageChild(XDE->Mix);
#else
    XtVaGetValues(XDE->rSlide,
    	XtNvalue, &red,
    	NULL);
    XtVaGetValues(XDE->gSlide,
    	XtNvalue, &green,
    	NULL);
    XtVaGetValues(XDE->bSlide,
    	XtNvalue, &blue,
    	NULL);
    HW_AllocateColor(colors, (unsigned short)red, (unsigned short)green,
     (unsigned short)blue, XDim);
    XtUnmanageChild(XDE->rgbShell);	
#endif /* DEC */
    XtVaSetValues(w,
    	XtNbackground, (XDC->colTrans)[colors],
    	NULL);
   }

/*
 * callback for cancel in color edit
 */

void WD_CancelColorEdit(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    XDColorInfo *XDC;
    XDHardwareInfo *HWI;
    XDimColorEdit *XDE;

    XDim = (XDimInfo*) client_data;
    XDE = &((XDim->myWidgets).ColorEdit);
    XDC = &(XDim->colors);
    HWI = &(XDim->hwInfo);
    (HWI->colStat)[XDC->colorEdit] = HW_COLORCLAIMED;
    (HWI->colStat)[XDC->colorEdit+1] = HW_COLORCLAIMED;
#ifdef DEC
    if(XtIsManaged(XDE->Mix))
       XtUnmanageChild(XDE->Mix);
#else
    if(XtIsManaged(XDE->rgbShell))
       XtUnmanageChild(XDE->rgbShell);
#endif /* DEC */
    XtPopdown(XDE->Shell);
   }

/*
 * manage the color mix widget
 */

void WD_ManageColorMix(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    XDColorInfo *XDC;
    XDHardwareInfo *HWI;
    XDimColorEdit *XDE;
    unsigned short red, green, blue;
    int colors;

    XDim = (XDimInfo*) client_data;
    XDE = &((XDim->myWidgets).ColorEdit);
    XDC = &(XDim->colors);
    HWI = &(XDim->hwInfo);
    if(w== XDE->Color1)
      {
       XDC->EditStartColor = True;
       colors = XDC->colorEdit;
      }
    else
      {
       XDC->EditStartColor = False;
       colors = XDC->colorEdit + 1;
      }
    red = (HWI->red)[colors];
    red = red << Short2Char | red;
    green = (HWI->green)[colors];
    green = green << Short2Char | green;
    blue = (HWI->blue)[colors];
    blue = blue << Short2Char | blue;
#ifdef DEC
    XtVaSetValues(XDE->Mix,
	DXmNorigRedValue, red,
	DXmNorigGreenValue, green,
	DXmNorigBlueValue, blue,
	NULL);
    XtManageChild(XDE->Mix);
#else
    XtVaSetValues(XDE->rSlide,
	XmNvalue, red,
	NULL);
    XtVaSetValues(XDE->gSlide,
	XmNvalue, green,
	NULL);
    XtVaSetValues(XDE->bSlide,
	XmNvalue, blue,
	NULL);
    if(XtIsManaged(XDE->rgbShell))
       XtUnmanageChild(XDE->rgbShell);
    XtManageChild(XDE->rgbShell);
#endif /* DEC */
   }

/*
 * callback for ok in new color
 */

void WD_okColorNew(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    XDColorInfo *XDC;
    XDHardwareInfo *HWI;
    XDimColorEdit *XDE;
    char *val;
    unsigned short red, green, blue;
    int i,num,colors;

    XDim = (XDimInfo*) client_data;
    XDE = &((XDim->myWidgets).ColorEdit);
    XDC = &(XDim->colors);
    HWI = &(XDim->hwInfo);
#ifdef DEC
    if(XtIsManaged(XDE->Mix))
       XtUnmanageChild(XDE->Mix);
#else
    if(XtIsManaged(XDE->rgbShell))
       XtUnmanageChild(XDE->rgbShell);
#endif /* DEC */
    val = XmTextFieldGetString(XDE->Edit);
    if(sscanf(val,"%d",&num))
      {
       colors = XDC->colorEdit;
       (HWI->colStat)[colors] = HW_COLORCLAIMED;
       (HWI->colStat)[colors+1] = HW_COLORCLAIMED;
       if(num > 0 && num+XDC->wantedColors < MAX_COL_NUMBER)
         {
          XtPopdown(XDE->Shell);
          i = XDC->rowNum;
          (XDC->rowNum)++;
          if(XDC->colE == XDC->wantedColors -1)
            XDC->colE +=num;
          XDC->wantedColors += num;
	  red = (HWI->red)[colors];
	  red = red << Short2Char | red;
	  green = (HWI->green)[colors];
	  green = green << Short2Char | green;
	  blue = (HWI->blue)[colors];
	  blue = blue << Short2Char | blue;
          (XDC->colors)[i] = num;
          (XDC->beginR)[i] = red;
          (XDC->beginG)[i] = green;
          (XDC->beginB)[i] = blue;
          colors++;
	  red = (HWI->red)[colors];
	  red = red << Short2Char | red;
	  green = (HWI->green)[colors];
	  green = green << Short2Char | green;
	  blue = (HWI->blue)[colors];
	  blue = blue << Short2Char | blue;
          (XDC->endR)[i] = red;
          (XDC->endG)[i] = green;
          (XDC->endB)[i] = blue;
	  XT_NotifyPaletteChanged(XDim);
	 }
       else
	 {
	  sprintf(XDim->error, "The number of colors must be 0< n < %d",
	  (MAX_COL_NUMBER- XDC->wantedColors));
	  WD_XDimError(XDim, XDE->Shell);
	 }
      }
    else
      {
       sprintf(XDim->error, "You have to supply the number of colors");
       WD_XDimError(XDim, XDE->Shell);
      }
    XtFree(val);
   }

/*
 * callback for ok in color edit
 */

void WD_okColorEdit(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    XDColorInfo *XDC;
    XDHardwareInfo *HWI;
    XDimColorEdit *XDE;
    unsigned short red, green, blue;
    int i,num,colors,myColor;

    XDim = (XDimInfo*) client_data;
    XDE = &((XDim->myWidgets).ColorEdit);
    XDC = &(XDim->colors);
    HWI = &(XDim->hwInfo);
#ifdef DEC
    if(XtIsManaged(XDE->Mix))
       XtUnmanageChild(XDE->Mix);
#else
    if(XtIsManaged(XDE->rgbShell))
       XtUnmanageChild(XDE->rgbShell);
#endif /* DEC */
    colors = XDC->colorEdit;
    (HWI->colStat)[colors] = HW_COLORCLAIMED;
    (HWI->colStat)[colors+1] = HW_COLORCLAIMED;
    XtPopdown(XDE->Shell);
    num = XDC->selected;
    red = (HWI->red)[colors];
    red = red << Short2Char | red;
    green = (HWI->green)[colors];
    green = green << Short2Char | green;
    blue = (HWI->blue)[colors];
    blue = blue << Short2Char | blue;
    (XDC->beginR)[num] = red;
    (XDC->beginG)[num] = green;
    (XDC->beginB)[num] = blue;
    colors++;
    red = (HWI->red)[colors];
    red = red << Short2Char | red;
    green = (HWI->green)[colors];
    green = green << Short2Char | green;
    blue = (HWI->blue)[colors];
    blue = blue << Short2Char | blue;
    (XDC->endR)[num] = red;
    (XDC->endG)[num] = green;
    (XDC->endB)[num] = blue;
    myColor =0;
    for(i=0; i<XDC->selected;i++)
	myColor += (XDC->colors)[i];
    for(i=0; i<(XDC->colors)[num]; i++)
       (HWI->colStat)[myColor++] = HW_COLORCLAIMED;
    XT_NotifyPaletteChanged(XDim);
   }

/*
 * calculate color or row from position
 * of the mouse pointer
 */

void WD_GetColorOrRow(Widget w, XtPointer client_data, XtPointer call_data)
   {
    Dimension width, height;
    XmDrawingAreaCallbackStruct *cs;
    XButtonEvent *e;
    Window win;
    XDimInfo *XDim;
    XDColorInfo *XDC;
    int i, row, column, myColor;

    win =XtWindow(w);
    if(win)
      {
       XDim = (XDimInfo*) client_data;
       XDC = &(XDim->colors);
       cs = (XmDrawingAreaCallbackStruct *) call_data;
       if((cs->event)->type == ButtonPress)
	 {
	  e = (XButtonEvent *)(cs->event);
          if(e->button == Button1)
            {
	     XtVaGetValues(w,
    			 XtNwidth, &width,
    			 XtNheight, &height,
    			 NULL);
	     row= (e->y * XDC->rowNum)/height;
	     if(row >=0 && row < XDC->rowNum)
	       {
		if(XDC->single)
		  {
		   column= (e->x * (XDC->colors)[row])/width;
		   if(column >=0 && column < (XDC->colors)[row])
		     {
		      myColor = 0;
		      for(i=0; i< row; i++)
			 myColor += (XDC->colors)[i];
		      myColor += column;
		      XDC->selected = myColor;		   
	              XT_RedrawColorRow((XDim->myWidgets).ColorSelect.ColorSArea,
						client_data, call_data);
		     }
		  }
		else
		  {
	           XDC->selected = row;
	              XT_RedrawColorRow((XDim->myWidgets).ColorSelect.ColorSArea,
						client_data, call_data);
		  }
	       }
	    }
	 }
      }
   }

/*
 * set color
 */

void WD_okSelectColor(Widget w, XtPointer client_data, XtPointer call_data)
   {
    extern XDimInfo XDim;
    XDColorInfo *XDC;

    XDC = &(XDim.colors);
    *((myPixel*)client_data) = XDC->selected;
    XtVaSetValues(XDim.myWidgets.Button,
    		XtNbackground, (XDC->colTrans)[XDC->selected],
    		NULL);
    XtPopdown(XDim.myWidgets.ColorSelect.ColorShell);
   }

/*
 * do window preferences
 */

void WD_ManageWinPref(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    ViewportInfo *view;
    XDimPreferences *XDP;
    XDColorInfo *XDC;
    int wwidth, wheight, pwidth, pheight;
    myPixel back;
    char val[256];
    Widget men;

    XDim = (XDimInfo *) client_data;
    men = XDim->myWidgets.ColorPanel.ColorMenu.Window;
    if(XDim->port >= 0 || w==men)
      {
       XDP = &((XDim->myWidgets).Prefs);       
       XDC = &(XDim->colors);
       view = &((XDim->Views)[XDim->port]);
       if(w==men)
         {
          back = XDC->back;
          wwidth = XDC->wwidth;
          wheight = XDC->wheight;
          pwidth = XDC->pwidth;
          pheight = XDC->pheight;
          XDim->aView.DefaultWin = True;
         }
       else
         {
          back = view->back;
          wwidth = view->wwidth;
          wheight = view->wheight;
          pwidth = view->pwidth;
          pheight = view->pheight;
          XDim->aView.DefaultWin = False;
         }
       sprintf(val, "%d", wwidth);
       XtVaSetValues(XDP->winWidthEdit,
    		XtNvalue, val,
    		NULL);
       sprintf(val, "%d", wheight);
       XtVaSetValues(XDP->winHeightEdit,
    		XtNvalue, val,
    		NULL);
       sprintf(val, "%d", pwidth);
       XtVaSetValues(XDP->picWidthEdit,
    		XtNvalue, val,
    		NULL);
       sprintf(val, "%d", pheight);
       XtVaSetValues(XDP->picHeightEdit,
    		XtNvalue, val,
    		NULL);
       XDim->aView.back = back;
       XtVaSetValues(XDP->backCol,
    		XtNbackground, (XDC->colTrans)[back],
    		NULL);
       if(XtIsManaged(XDP->winShell))
         XtUnmanageChild(XDP->winShell);
       XtManageChild(XDP->winShell);
      }
   }


/*
 * select window background color
 */
 
void WD_SelectWinBack(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    XDimColorSelect *XDS;
    XDColorInfo *XDC;
    XmString Mess;

    XDim = (XDimInfo*) client_data;
    XDC = &(XDim->colors);
    XDS = &((XDim->myWidgets).ColorSelect);
    if(XDS->activeCallback)
       XtRemoveCallback(XDS->ok, XmNactivateCallback,
	  XDS->activeCallback, XDS->client_data);
    XtAddCallback(XDS->ok, XmNactivateCallback,
	WD_okSelectColor, &(XDim->aView.back));
    XDS->activeCallback = WD_okSelectColor;
    Mess = XmStringCreateSimple("Select window background color");
    XtVaSetValues(XDS->ColorMessage,
	XmNlabelString, Mess,
	NULL);
    XmStringFree(Mess);
    XDS->client_data = &(XDim->aView.back);
    XDC->single = True;
    XDC->selected = XDim->aView.back;
    (XDim->myWidgets).Button = w;
    XtPopdown(XDS->ColorShell);
    XtPopup(XDS->ColorShell, XtGrabNone);
   }

/*
 * do window changes
 */
 
void WD_okWinPref(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    XDColorInfo *XDC;
    ViewportInfo *view;
    XDimViewport *XDV;
    XDimPreferences *XDP;
    char *val;
    int wwidth, wheight, pwidth, pheight;

    XDim = (XDimInfo*) client_data;
    if(XDim->port >=0 || XDim->aView.DefaultWin)
      {
       view = &((XDim->Views)[XDim->port]);
       XDP = &((XDim->myWidgets).Prefs);       
       XDC = &(XDim->colors);
       val = XmTextFieldGetString(XDP->winWidthEdit);
       if(!sscanf(val,"%d",&wwidth))
	 {
          XtFree(val);
	  strcpy(XDim->error, "You have to supply the window width");
	  WD_XDimError(XDim, XDP->winShell);
	  return;
	 }
       XtFree(val);
       val = XmTextFieldGetString(XDP->winHeightEdit);
       if(!sscanf(val,"%d",&wheight))
	 {
          XtFree(val);
	  strcpy(XDim->error, "You have to supply the window height");
	  WD_XDimError(XDim, XDP->winShell);
	  return;
	 }
       XtFree(val);
       val = XmTextFieldGetString(XDP->picWidthEdit);
       if(!sscanf(val,"%d",&pwidth))
	 {
          XtFree(val);
	  strcpy(XDim->error, "You have to supply the picture width");
	  WD_XDimError(XDim, XDP->winShell);
	  return;
	 }
       XtFree(val);
       val = XmTextFieldGetString(XDP->picHeightEdit);
       if(!sscanf(val,"%d",&pheight))
	 {
          XtFree(val);
	  strcpy(XDim->error, "You have to supply the picture height");
	  WD_XDimError(XDim, XDP->winShell);
	  return;
	 }
       XtFree(val);
       if(wwidth < 10 || wheight < 10 || pwidth < 10 || pheight < 10)
         {
	  strcpy(XDim->error,
	  "The window and the picture width and height must be > 10");
	  WD_XDimError(XDim, XDP->winShell);
	  return;
         }
       if(XDim->aView.DefaultWin)
         {
          XDC->wwidth = wwidth;
          XDC->wheight = wheight;
          XDC->pwidth = pwidth;
          XDC->pheight = pheight;
          XDC->back = XDim->aView.back;
         }
       else
         {
          XDV = &(((XDim->myWidgets).Views)[XDim->port]);
          view->wwidth = wwidth;
          view->wheight = wheight;
          view->pwidth = pwidth;
          view->pheight = pheight;
          view->back = XDim->aView.back;
	  if(GR_ResizeViewport(view, XDim))
	     WD_XDimError(XDim, XDP->winShell);
          XtVaSetValues(XDV->SWindow,
	   XmNwidth, wwidth,
	   XmNheight, wheight,
	   NULL);	
          XtVaSetValues(XDV->DArea,
	   XmNbackground, (XDC->colTrans)[view->back],
	   XmNwidth, pwidth,
	   XmNheight, pheight,
	   NULL);
	  XT_Redraw(XDV->DArea, (XtPointer)(view), NULL);
         }
      }
   }

/*
 * do grid preferences
 */

void WD_ManageGridPref(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    ViewportInfo *view;
    XDimPreferences *XDP;
    XDColorInfo *XDC;
    Boolean drawAxis, drawAxisText;
    int gStep, ticsX, ticsY, ticsZ;
    myPixel fore, axisFore, axisBackX, axisBackY, axisBackZ;
    char val[256];
    Widget men;

    XDim = (XDimInfo *) client_data;
    men = XDim->myWidgets.ColorPanel.ColorMenu.Grid;
    if(XDim->port >= 0 || w==men)
      {
       XDP = &((XDim->myWidgets).Prefs);       
       XDC = &(XDim->colors);
       view = &((XDim->Views)[XDim->port]);
       if(w==men)
         {
          drawAxis = XDC->DrawGrid;
          drawAxisText = XDC->DrawAxisText;
          gStep = XDC->gStep;
          ticsX = XDC->ticsX;
          ticsY = XDC->ticsY;
          ticsZ = XDC->ticsZ;
          fore = XDC->fore;
          axisFore = XDC->axisFore;
          axisBackX = XDC->axisBackX;
          axisBackY = XDC->axisBackY;
          axisBackZ = XDC->axisBackZ;
          XDim->aView.DefaultGrid = True;
         }
       else
         {
          drawAxis = view->Grid;
          drawAxisText = view->DrawAxisText;
          gStep = view->gStep;
          ticsX = view->ticsX;
          ticsY = view->ticsY;
          ticsZ = view->ticsZ;
          fore = view->fore;
          axisFore = view->axisFore;
          axisBackX = view->axisBackX;
          axisBackY = view->axisBackY;
          axisBackZ = view->axisBackZ;
          XDim->aView.DefaultGrid = False;
         }
       XtVaSetValues(XDP->drawAxis,
    		XmNset, drawAxis,
    		NULL);
       XtVaSetValues(XDP->drawAxisText,
    		XmNset, drawAxisText,
    		NULL);
       sprintf(val, "%d", gStep);
       XtVaSetValues(XDP->gStepEdit,
    		XtNvalue, val,
    		NULL);
       sprintf(val, "%d", ticsX);
       XtVaSetValues(XDP->ticsXEdit,
    		XtNvalue, val,
    		NULL);
       sprintf(val, "%d", ticsY);
       XtVaSetValues(XDP->ticsYEdit,
    		XtNvalue, val,
    		NULL);
       sprintf(val, "%d", ticsZ);
       XtVaSetValues(XDP->ticsZEdit,
    		XtNvalue, val,
    		NULL);
       XDim->aView.fore = fore;
       XtVaSetValues(XDP->foreCol,
    		XtNbackground, (XDC->colTrans)[fore],
    		NULL);
       XDim->aView.axisFore = axisFore;
       XtVaSetValues(XDP->axisForeCol,
    		XtNbackground, (XDC->colTrans)[axisFore],
    		NULL);
       XDim->aView.axisBX = axisBackX;
       XtVaSetValues(XDP->axisBXCol,
    		XtNbackground, (XDC->colTrans)[axisBackX],
    		NULL);
       XDim->aView.axisBY = axisBackY;
       XtVaSetValues(XDP->axisBYCol,
    		XtNbackground, (XDC->colTrans)[axisBackY],
    		NULL);
       XDim->aView.axisBZ = axisBackZ;
       XtVaSetValues(XDP->axisBZCol,
    		XtNbackground, (XDC->colTrans)[axisBackZ],
    		NULL);
       if(XtIsManaged(XDP->gridShell))
         XtUnmanageChild(XDP->winShell);
       XtManageChild(XDP->gridShell);
      }
   }

/*
 * select grid color
 */
 
void WD_SelectGridCol(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    XDimColorSelect *XDS;
    XDColorInfo *XDC;
    XmString Mess;

    XDim = (XDimInfo*) client_data;
    XDC = &(XDim->colors);
    XDS = &((XDim->myWidgets).ColorSelect);
    if(XDS->activeCallback)
       XtRemoveCallback(XDS->ok, XmNactivateCallback,
	  XDS->activeCallback, XDS->client_data);
    XtAddCallback(XDS->ok, XmNactivateCallback,
	WD_okSelectColor, &(XDim->aView.fore));
    XDS->activeCallback = WD_okSelectColor;
    Mess = XmStringCreateSimple("Select grid color");
    XtVaSetValues(XDS->ColorMessage,
	XmNlabelString, Mess,
	NULL);
    XmStringFree(Mess);
    XDS->client_data = &(XDim->aView.fore);
    XDC->single = True;
    XDC->selected = XDim->aView.fore;
    (XDim->myWidgets).Button = w;
    XtPopdown(XDS->ColorShell);
    XtPopup(XDS->ColorShell, XtGrabNone);
   }

/*
 * select axis color
 */
 
void WD_SelectAxisCol(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    XDimColorSelect *XDS;
    XDColorInfo *XDC;
    XmString Mess;

    XDim = (XDimInfo*) client_data;
    XDC = &(XDim->colors);
    XDS = &((XDim->myWidgets).ColorSelect);
    if(XDS->activeCallback)
       XtRemoveCallback(XDS->ok, XmNactivateCallback,
	  XDS->activeCallback, XDS->client_data);
    XtAddCallback(XDS->ok, XmNactivateCallback,
	WD_okSelectColor, &(XDim->aView.axisFore));
    XDS->activeCallback = WD_okSelectColor;
    Mess = XmStringCreateSimple("Select axis color");
    XtVaSetValues(XDS->ColorMessage,
	XmNlabelString, Mess,
	NULL);
    XmStringFree(Mess);
    XDS->client_data = &(XDim->aView.axisFore);
    XDC->single = True;
    XDC->selected = XDim->aView.axisFore;
    (XDim->myWidgets).Button = w;
    XtPopdown(XDS->ColorShell);
    XtPopup(XDS->ColorShell, XtGrabNone);
   }

/*
 * select axis X background color
 */
 
void WD_SelectXBack(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    XDimColorSelect *XDS;
    XDColorInfo *XDC;
    XmString Mess;

    XDim = (XDimInfo*) client_data;
    XDC = &(XDim->colors);
    XDS = &((XDim->myWidgets).ColorSelect);
    if(XDS->activeCallback)
       XtRemoveCallback(XDS->ok, XmNactivateCallback,
	  XDS->activeCallback, XDS->client_data);
    XtAddCallback(XDS->ok, XmNactivateCallback,
	WD_okSelectColor, &(XDim->aView.axisBX));
    XDS->activeCallback = WD_okSelectColor;
    Mess = XmStringCreateSimple("Select X background color");
    XtVaSetValues(XDS->ColorMessage,
	XmNlabelString, Mess,
	NULL);
    XmStringFree(Mess);
    XDS->client_data = &(XDim->aView.axisBX);
    XDC->single = True;
    XDC->selected = XDim->aView.axisBX;
    (XDim->myWidgets).Button = w;
    XtPopdown(XDS->ColorShell);
    XtPopup(XDS->ColorShell, XtGrabNone);
   }

/*
 * select axis Y background color
 */
 
void WD_SelectYBack(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    XDimColorSelect *XDS;
    XDColorInfo *XDC;
    XmString Mess;

    XDim = (XDimInfo*) client_data;
    XDC = &(XDim->colors);
    XDS = &((XDim->myWidgets).ColorSelect);
    if(XDS->activeCallback)
       XtRemoveCallback(XDS->ok, XmNactivateCallback,
	  XDS->activeCallback, XDS->client_data);
    XtAddCallback(XDS->ok, XmNactivateCallback,
	WD_okSelectColor, &(XDim->aView.axisBY));
    XDS->activeCallback = WD_okSelectColor;
    Mess = XmStringCreateSimple("Select Y background color");
    XtVaSetValues(XDS->ColorMessage,
	XmNlabelString, Mess,
	NULL);
    XmStringFree(Mess);
    XDS->client_data = &(XDim->aView.axisBY);
    XDC->single = True;
    XDC->selected = XDim->aView.axisBY;
    (XDim->myWidgets).Button = w;
    XtPopdown(XDS->ColorShell);
    XtPopup(XDS->ColorShell, XtGrabNone);
   }

/*
 * select axis Z background color
 */
 
void WD_SelectZBack(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    XDimColorSelect *XDS;
    XDColorInfo *XDC;
    XmString Mess;

    XDim = (XDimInfo*) client_data;
    XDC = &(XDim->colors);
    XDS = &((XDim->myWidgets).ColorSelect);
    if(XDS->activeCallback)
       XtRemoveCallback(XDS->ok, XmNactivateCallback,
	  XDS->activeCallback, XDS->client_data);
    XtAddCallback(XDS->ok, XmNactivateCallback,
	WD_okSelectColor, &(XDim->aView.axisBZ));
    XDS->activeCallback = WD_okSelectColor;
    Mess = XmStringCreateSimple("Select Z background color");
    XtVaSetValues(XDS->ColorMessage,
	XmNlabelString, Mess,
	NULL);
    XmStringFree(Mess);
    XDS->client_data = &(XDim->aView.axisBZ);
    XDC->single = True;
    XDC->selected = XDim->aView.axisBZ;
    (XDim->myWidgets).Button = w;
    XtPopdown(XDS->ColorShell);
    XtPopup(XDS->ColorShell, XtGrabNone);
   }

/*
 * do grid changes
 */
 
void WD_okGridPref(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    XDColorInfo *XDC;
    ViewportInfo *view;
    XDimPreferences *XDP;
    char *val;
    Boolean drawAxis, drawAxisText;
    int gStep, ticsX, ticsY, ticsZ;

    XDim = (XDimInfo*) client_data;
    if(XDim->port >=0 || XDim->aView.DefaultGrid)
      {
       view = &((XDim->Views)[XDim->port]);
       XDP = &((XDim->myWidgets).Prefs);       
       XDC = &(XDim->colors);
       val = XmTextFieldGetString(XDP->gStepEdit);
       if(!sscanf(val,"%d",&gStep))
	 {
          XtFree(val);
	  strcpy(XDim->error, "You have to supply grid step");
	  WD_XDimError(XDim, XDP->gridShell);
	  return;
	 }
       XtFree(val);
       if(gStep < 1)
         {
	  strcpy(XDim->error,
	  "The grid step must be: step > 0");
	  WD_XDimError(XDim, XDP->gridShell);
	  return;
         }
       val = XmTextFieldGetString(XDP->ticsXEdit);
       if(!sscanf(val,"%d",&ticsX))
	 {
          XtFree(val);
	  strcpy(XDim->error, "You have to supply the number of tics");
	  WD_XDimError(XDim, XDP->gridShell);
	  return;
	 }
       val = XmTextFieldGetString(XDP->ticsYEdit);
       if(!sscanf(val,"%d",&ticsY))
	 {
          XtFree(val);
	  strcpy(XDim->error, "You have to supply the number of tics");
	  WD_XDimError(XDim, XDP->gridShell);
	  return;
	 }
       val = XmTextFieldGetString(XDP->ticsZEdit);
       if(!sscanf(val,"%d",&ticsZ))
	 {
          XtFree(val);
	  strcpy(XDim->error, "You have to supply the number of tics");
	  WD_XDimError(XDim, XDP->gridShell);
	  return;
	 }
       XtFree(val);
       if(ticsX < 0 || ticsY < 0 || ticsZ < 0)
         {
	  strcpy(XDim->error,
	  "The number of tics must be: N > 0");
	  WD_XDimError(XDim, XDP->gridShell);
	  return;
         }
       XtVaGetValues(XDP->drawAxis,
    	   XmNset, &drawAxis,
    	   NULL);
       XtVaGetValues(XDP->drawAxisText,
    	   XmNset, &drawAxisText,
    	   NULL);
       if(XDim->aView.DefaultGrid)
         {
          XDC->gStep = gStep;
          XDC->ticsX = ticsX;
          XDC->ticsY = ticsY;
          XDC->ticsZ = ticsZ;
	  XDC->fore = XDim->aView.fore;
	  XDC->axisFore = XDim->aView.axisFore;
	  XDC->axisBackX = XDim->aView.axisBX;
	  XDC->axisBackY = XDim->aView.axisBY;
	  XDC->axisBackZ = XDim->aView.axisBZ;
	  XDC->DrawGrid = drawAxis;
	  XDC->DrawAxisText = drawAxisText;
         }
       else
         {
          view->gStep = gStep;
          view->ticsX = ticsX;
          view->ticsY = ticsY;
          view->ticsZ = ticsZ;
	  view->fore = XDim->aView.fore;
	  view->axisFore = XDim->aView.axisFore;
	  view->axisBackX = XDim->aView.axisBX;
	  view->axisBackY = XDim->aView.axisBY;
	  view->axisBackZ = XDim->aView.axisBZ;
	  view->Grid = drawAxis;
	  view->DrawAxisText = drawAxisText;
         }
      }
   }


/*
 * do movement preferences
 */

void WD_ManageMovPref(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    ViewportInfo *view;
    XDimPreferences *XDP;
    XDColorInfo *XDC;
    myCoor delta;
    double zoom, dAngle;
    char val[256];
    Widget men;

    XDim = (XDimInfo *) client_data;
    men = XDim->myWidgets.ColorPanel.ColorMenu.Move;
    if(XDim->port >= 0 || w==men)
      {
       XDP = &((XDim->myWidgets).Prefs);       
       XDC = &(XDim->colors);
       view = &((XDim->Views)[XDim->port]);
       if(w==men)
         {
          delta = XDC->delta;
          zoom = XDC->zoom;
          dAngle = XDC->dAngle;
          XDim->aView.DefaultMov = True;
         }
       else
         {
          delta = view->delta;
          zoom = view->zoom;
          dAngle = view->dAngle;
          XDim->aView.DefaultMov = False;
         }
       sprintf(val, "%d", delta);
       XtVaSetValues(XDP->deltaEdit,
    		XtNvalue, val,
    		NULL);
       sprintf(val, "%d", (int)XDC->tInterval);
       XtVaSetValues(XDP->timeIntEdit,
    		XtNvalue, val,
    		NULL);
       sprintf(val, "%1.2f", zoom);
       XtVaSetValues(XDP->zoomEdit,
    		XtNvalue, val,
    		NULL);
       sprintf(val, "%f", dAngle);
       XtVaSetValues(XDP->delAngleEdit,
    		XtNvalue, val,
    		NULL);
       if(XtIsManaged(XDP->movShell))
         XtUnmanageChild(XDP->movShell);
       XtManageChild(XDP->movShell);
      }
   }

/*
 * do movement changes
 */
 
void WD_okMovPref(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    XDColorInfo *XDC;
    ViewportInfo *view;
    XDimPreferences *XDP;
    char *val;
    myCoor delta;
    double zoom, dAngle;
    unsigned long tInterval;

    XDim = (XDimInfo*) client_data;
    if(XDim->port >=0 || XDim->aView.DefaultMov)
      {
       view = &((XDim->Views)[XDim->port]);
       XDP = &((XDim->myWidgets).Prefs);       
       XDC = &(XDim->colors);
       val = XmTextFieldGetString(XDP->zoomEdit);
       if(!sscanf(val,"%le",&zoom))
	 {
          XtFree(val);
	  strcpy(XDim->error, "You have to supply a zoom factor");
	  WD_XDimError(XDim, XDP->movShell);
	  return;
	 }
       XtFree(val);
       if(zoom <1.0 || zoom > 5.0)
         {
	  strcpy(XDim->error,
	  "The zoom factor must be in the range: 1.0 < zoom < 5.0");
	  WD_XDimError(XDim, XDP->movShell);
	  return;
         }
       val = XmTextFieldGetString(XDP->delAngleEdit);
       if(!sscanf(val,"%le",&dAngle))
	 {
          XtFree(val);
	  strcpy(XDim->error, "You have to supply a rotation angle");
	  WD_XDimError(XDim, XDP->movShell);
	  return;
	 }
       XtFree(val);
       if(dAngle <=0.0 || dAngle > PI)
         {
	  strcpy(XDim->error,
	  "The rotation angle must be in the range: 0.0 < Angle < Pi");
	  WD_XDimError(XDim, XDP->movShell);
	  return;
         }
       val = XmTextFieldGetString(XDP->deltaEdit);
       if(!sscanf(val,"%d",&delta))
	 {
          XtFree(val);
	  strcpy(XDim->error, "You have to supply a value for X,Y movement");
	  WD_XDimError(XDim, XDP->movShell);
	  return;
	 }
       XtFree(val);
       if(delta <=0 || delta > (CO_ONE>>4))
         {
	  sprintf(XDim->error,
	  "The value for X,Y movement must be in the range: 0 < delta < %d",
	  CO_ONE>>4);
	  WD_XDimError(XDim, XDP->movShell);
	  return;
         }
       val = XmTextFieldGetString(XDP->timeIntEdit);
       if(!sscanf(val,"%d",(int*)&tInterval))
	 {
          XtFree(val);
	  strcpy(XDim->error, "You have to supply a time interval");
	  WD_XDimError(XDim, XDP->movShell);
	  return;
	 }
       XtFree(val);
       if(tInterval <=0)
         {
	  strcpy(XDim->error,
	  "The time interval must be > 0");
	  WD_XDimError(XDim, XDP->movShell);
	  return;
         }
       XDC->tInterval = tInterval;
       if(XDim->aView.DefaultMov)
         {
          XDC->zoom = zoom;
          XDC->dAngle = dAngle;
          XDC->delta = delta;
         }
       else
         {
          view->zoom = zoom;
          view->dAngle = dAngle;
          view->delta = delta;
         }
      }
   }




/*
 * do misc preferences
 */

void WD_ManageMiscPref(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    XDimPreferences *XDP;
    XDColorInfo *XDC;

    XDim = (XDimInfo *) client_data;
    XDP = &((XDim->myWidgets).Prefs);       
    XDC = &(XDim->colors);
    XDim->aView.textCol = XDC->textFore;
    XtVaSetValues(XDP->textCol,
    	     XtNbackground, (XDC->colTrans)[XDC->textFore],
    	     NULL);
    XDim->aView.dcolS = XDC->colS;
    XtVaSetValues(XDP->decoSCol,
    	     XtNbackground, (XDC->colTrans)[XDC->colS],
    	     NULL);
    XDim->aView.dcolE = XDC->colE;
    XtVaSetValues(XDP->decoECol,
    	     XtNbackground, (XDC->colTrans)[XDC->colE],
    	     NULL);
    if(XtIsManaged(XDP->textShell))
      XtUnmanageChild(XDP->textShell);
    XtManageChild(XDP->textShell);
   }

/*
 * do misc changes
 */
 
void WD_okMiscPref(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    XDColorInfo *XDC;
    XDimPreferences *XDP;
    char *val;
    XDHardwareInfo *HWI;
    XFontStruct *nextFont;

    XDim = (XDimInfo*) client_data;
    XDP = &((XDim->myWidgets).Prefs);       
    XDC = &(XDim->colors);
    val = XmTextFieldGetString(XDP->fontEdit);
    HWI = &(XDim->hwInfo);
    if(strlen(val) >0)
      {
       nextFont = XLoadQueryFont(HWI->dpy, val);
       if(nextFont == NULL)
         {
          XtFree(val);
	  strcpy(XDim->error, "Couldn't load the given font (try xlsfonts)");
	  WD_XDimError(XDim, XDP->textShell);
	  return;
         }
       if(HWI->defaultFont)
         HWI->defaultFont = False;
       else
         XFreeFont(HWI->dpy, HWI->font);
       HWI->font = nextFont;
       XSetFont(HWI->dpy, HWI->gc, HWI->font->fid);
       XSetFont(HWI->dpy, HWI->textGC, HWI->font->fid);
       XSetFont(HWI->dpy, HWI->binGC, HWI->font->fid);
      }
    XtFree(val);
    XtVaGetValues(XDP->useInterCol,
    	XmNset, &(XDC->interCol),
    	NULL);
    XDC->textFore = XDim->aView.textCol;
    XDC->colS = XDim->aView.dcolS;
    XDC->colE = XDim->aView.dcolE;
   }

/*
 * select text color
 */
 
void WD_SelectTextCol(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    XDimColorSelect *XDS;
    XDColorInfo *XDC;
    XmString Mess;

    XDim = (XDimInfo*) client_data;
    XDC = &(XDim->colors);
    XDS = &((XDim->myWidgets).ColorSelect);
    if(XDS->activeCallback)
       XtRemoveCallback(XDS->ok, XmNactivateCallback,
	  XDS->activeCallback, XDS->client_data);
    XtAddCallback(XDS->ok, XmNactivateCallback,
	WD_okSelectColor, &(XDim->aView.textCol));
    XDS->activeCallback = WD_okSelectColor;
    Mess = XmStringCreateSimple("Select text color");
    XtVaSetValues(XDS->ColorMessage,
	XmNlabelString, Mess,
	NULL);
    XmStringFree(Mess);
    XDS->client_data = &(XDim->aView.textCol);
    XDC->single = True;
    XDC->selected = XDim->aView.textCol;
    (XDim->myWidgets).Button = w;
    XtPopdown(XDS->ColorShell);
    XtPopup(XDS->ColorShell, XtGrabNone);
   }


/*
 * select start decoding color
 */
 
void WD_SelectDColS(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    XDimColorSelect *XDS;
    XDColorInfo *XDC;
    XmString Mess;

    XDim = (XDimInfo*) client_data;
    XDC = &(XDim->colors);
    XDS = &((XDim->myWidgets).ColorSelect);
    if(XDS->activeCallback)
       XtRemoveCallback(XDS->ok, XmNactivateCallback,
	  XDS->activeCallback, XDS->client_data);
    XtAddCallback(XDS->ok, XmNactivateCallback,
	WD_okSelectColor, &(XDim->aView.dcolS));
    XDS->activeCallback = WD_okSelectColor;
    Mess = XmStringCreateSimple("Select default start color");
    XtVaSetValues(XDS->ColorMessage,
	XmNlabelString, Mess,
	NULL);
    XmStringFree(Mess);
    XDS->client_data = &(XDim->aView.dcolS);
    XDC->single = True;
    XDC->selected = XDim->aView.dcolS;
    (XDim->myWidgets).Button = w;
    XtPopdown(XDS->ColorShell);
    XtPopup(XDS->ColorShell, XtGrabNone);
   }


/*
 * select end decoding color
 */
 
void WD_SelectDColE(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    XDimColorSelect *XDS;
    XDColorInfo *XDC;
    XmString Mess;

    XDim = (XDimInfo*) client_data;
    XDC = &(XDim->colors);
    XDS = &((XDim->myWidgets).ColorSelect);
    if(XDS->activeCallback)
       XtRemoveCallback(XDS->ok, XmNactivateCallback,
	  XDS->activeCallback, XDS->client_data);
    XtAddCallback(XDS->ok, XmNactivateCallback,
	WD_okSelectColor, &(XDim->aView.dcolE));
    XDS->activeCallback = WD_okSelectColor;
    Mess = XmStringCreateSimple("Select default end color");
    XtVaSetValues(XDS->ColorMessage,
	XmNlabelString, Mess,
	NULL);
    XmStringFree(Mess);
    XDS->client_data = &(XDim->aView.dcolE);
    XDC->single = True;
    XDC->selected = XDim->aView.dcolE;
    (XDim->myWidgets).Button = w;
    XtPopdown(XDS->ColorShell);
    XtPopup(XDS->ColorShell, XtGrabNone);
   }


/*
 * Enable/Disable ASCII Options
 */

void WD_AsciiOptions(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    XDimImportExport *XDIE;

    XDim = (XDimInfo*)client_data;
    XDIE = &(XDim->myWidgets.ImEx);
    if(((XmToggleButtonCallbackStruct *)call_data)->set)
      {
       XtVaSetValues(XDIE->fillEdit,
	   XmNsensitive, True,
	   NULL);
       XtVaSetValues(XDIE->fillLabel,
	   XmNsensitive, True,
	   NULL);
       XtVaSetValues(XDIE->german,
	   XmNsensitive, True,
	   NULL);
      }
    else
      {
       XtVaSetValues(XDIE->fillEdit,
	   XmNsensitive, False,
	   NULL);
       XtVaSetValues(XDIE->fillLabel,
	   XmNsensitive, False,
	   NULL);
       XtVaSetValues(XDIE->german,
	   XmNsensitive, False,
	   NULL);
      }
   }

/*
 * manage import filter
 */

void WD_ManageImport(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    XDColorInfo *XDC;
    char val[256];
    XDimImportExport *XDIE;

    XDim = (XDimInfo *) client_data;
    if(XDim->port >= 0)
      {
       XDIE = &(XDim->myWidgets.ImEx);
       XDC = &(XDim->colors);
       sprintf(val, "%e", XDC->Repl);
       XtVaSetValues(XDIE->fillEdit,
    		XtNvalue, val,
    		NULL);
       XtVaSetValues(XDIE->german,
    	   XmNset, XDC->GerNot,
    	   NULL);
     }
    if(XtIsManaged(XDIE->importShell))
      XtUnmanageChild(XDIE->importShell);
    XtManageChild(XDIE->importShell);
   }


/*
 * Initiate an Import Ascii
 */

void WD_okImportData(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    XDimWidgets *XDW;
    XDColorInfo *XDC;
    XDimImportExport *XDIE;
    ViewportInfo *view;
    XDimViewport *XDV;
    XmString FName;
    XmStringContext context;
    XmStringDirection dir;
    XmStringCharSet set;
    Boolean sep, ascii, gif, jpeg;
    char *Text;

    XDim = (XDimInfo *) client_data;
    XDW =  &(XDim->myWidgets);
    XDC = &(XDim->colors);
    XtVaGetValues(XDW->DataSelect,
	XmNdirSpec, &FName,
	NULL);
    XDIE = &(XDW->ImEx);
    XtVaGetValues(XDIE->ascii,
	XmNset, &ascii,
	NULL);
    XtVaGetValues(XDIE->gif,
	XmNset, &gif,
	NULL);
    XtVaGetValues(XDIE->jpeg,
	XmNset, &jpeg,
	NULL);
    if(XmStringInitContext(&context, FName))
      {
       if(XmStringGetNextSegment(context, &Text, &set, &dir, &sep))
         {
          if(XDim->port >= 0)
            {
             view = &((XDim->Views)[XDim->port]);
             XDV = &((XDW->Views)[XDim->port]);
             strncpy(view->fileName, Text, MAX_NAME_LENGTH);
             if(ascii && FI_ImportAsciiData(XDim))
               ascii = False;
	     else if(jpeg && JP_read_JPEG_file(XDim))
	       jpeg = False;
	     else if(gif && FI_ImportGifPic(XDim))
	       gif = False;
             *view->fileName = '\0';
             if(ascii || gif || jpeg)
               {
                XtVaSetValues(XDV->Shell,
			XmNtitle, Text,
			NULL);
		CO_CalculateBases(view);
                if(ascii)
		  XT_Redraw(XDV->DArea, (XtPointer)(view), NULL);
		else
		  {
		   MA_MirrorY(NULL, XDim, NULL);
		   XT_NotifyPaletteChanged(XDim);
		  }
        	XtUnmanageChild(XDW->DataSelect);
               }
	     else
		WD_XDimError(XDim, XDW->DataSelect);
            }
         }
       XmStringFreeContext(context);
       XmStringFree(FName);
      }
    
   }

/*
 * import the data
 */
 
void WD_okImport(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    XDColorInfo *XDC;
    XDimImportExport *XDIE;
    XDimWidgets *XDW;
    XmString Pref,Mess;
    char *val;
    double Repl;
    Boolean set;

    XDim = (XDimInfo*) client_data;
    if(XDim->port >= 0)
      {
       XDC = &(XDim->colors);
       XDW =  &(XDim->myWidgets);
       XDIE = &(XDW->ImEx);
       XtVaGetValues(XDIE->ascii,
    	   XmNset, &set,
    	   NULL);
       if(set)
         {
	  val = XmTextFieldGetString(XDIE->fillEdit);
	  if(!sscanf(val,"%le",&Repl))
	    {
             XtFree(val);
	     strcpy(XDim->error, "You have to supply a replace value");
	     WD_XDimError(XDim, XDIE->importShell);
	     return;
	    }
	  XtFree(val);
	  XDC->Repl = Repl;
	  XtVaGetValues(XDIE->german,
    	      XmNset, &(XDC->GerNot),
    	      NULL);
          Mess = XmStringCreateSimple("Import ASCII Data:");
	 }
       else
         {
	  XtVaGetValues(XDIE->gif,
    	      XmNset, &set,
    	      NULL);
    	  if(set)
    	    Mess = XmStringCreateSimple("Import GIF compressed Data:");
    	  else
    	    Mess = XmStringCreateSimple("Import JPEG compressed Data:");
         }
       Pref = XmStringCreateSimple("*.*");
       XtVaSetValues(XDW->DataSelect,
	   XmNpattern, Pref,
	   XmNselectionLabelString, Mess,
	   NULL);
       XmStringFree(Mess);
       XmStringFree(Pref);
       if(XDW->activeDTCallback)
	  XtRemoveCallback(XDW->DataSelect, XmNokCallback,
	     XDW->activeDTCallback, XDW->DTclient_data);
       XtAddCallback(XDW->DataSelect, XmNokCallback,
                      WD_okImportData, XDim);
       XDW->activeDTCallback = WD_okImportData;
       XDW->DTclient_data = XDim;
       XtManageChild(XDW->DataSelect);       
      }
   }

/*
 * Enable/Disable Export Options
 */

void WD_ExportOptions(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    XDimImportExport *XDIE;
    int set;

    XDim = (XDimInfo*)client_data;
    XDIE = &(XDim->myWidgets.ImEx);
    set = ((XmToggleButtonCallbackStruct *)call_data)->set;
    if(w == XDIE->exAscii)
      {
       if(set)
	 {
	  XtVaSetValues(XDIE->exAsciiText,
	      XmNsensitive, True,
	      NULL);
	  XtVaSetValues(XDIE->exGer,
	      XmNsensitive, True,
	      NULL);
	 }
       else
	 {
	  XtVaSetValues(XDIE->exAsciiText,
	      XmNsensitive, False,
	      NULL);
	  XtVaSetValues(XDIE->exGer,
	      XmNsensitive, False,
	      NULL);
	 }
      }
    else
      {
       if(set)
	 {
	  XtVaSetValues(XDIE->exJpegText,
	      XmNsensitive, True,
	      NULL);
	  XtVaSetValues(XDIE->exJpegField,
	      XmNsensitive, True,
	      NULL);
	 }
       else
	 {
	  XtVaSetValues(XDIE->exJpegText,
	      XmNsensitive, False,
	      NULL);
	  XtVaSetValues(XDIE->exJpegField,
	      XmNsensitive, False,
	      NULL);
	 }
      }
   }


/*
 * manage export filter
 */

void WD_ManageExport(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    XDColorInfo *XDC;
    char val[128];
    XDimImportExport *XDIE;

    XDim = (XDimInfo *) client_data;
    if(XDim->port >= 0)
      {
       XDIE = &(XDim->myWidgets.ImEx);
       XDC = &(XDim->colors);
       sprintf(val, "%d", XDC->jpgQuality);
       XtVaSetValues(XDIE->exJpegField,
    		XtNvalue, val,
    		NULL);
       XtVaSetValues(XDIE->exGer,
    	   XmNset, XDC->GerNot,
    	   NULL);
     }
    if(XtIsManaged(XDIE->exportShell))
      XtUnmanageChild(XDIE->exportShell);
    XtManageChild(XDIE->exportShell);
   }

/*
 * Initiate a Data export
 */

void WD_okExportData(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    XDimWidgets *XDW;
    ViewportInfo *VWI;
    XDimViewport *XDV;
    XDColorInfo *XDC;
    XDimImportExport *XDIE;
    XmString FName;
    XmStringContext context;
    XmStringDirection dir;
    XmStringCharSet set;
    int qual;
    Boolean sep, test;
    char *Text, *val;

    XDim = (XDimInfo *) client_data;
    if(XDim->port >=0)
      {
       XDW =  &(XDim->myWidgets);
       XDIE = &(XDW->ImEx);
       VWI = &((XDim->Views)[XDim->port]);
       XDV = &((XDW->Views)[XDim->port]);
       XDC = &(XDim->colors);
       XtVaGetValues(XDW->DataSelect,
	   XmNdirSpec, &FName,
	   NULL);
       if(XmStringInitContext(&context, FName))
	 {
	  if(XmStringGetNextSegment(context, &Text, &set, &dir, &sep))
            {
	     XtVaGetValues(XDIE->exAscii,
    		 XmNset, &test,
    		 NULL);
	     if(test)
		test= FI_AsciiExportData(Text, XDim);
	     else
               {
            /*
             * Show the user what to expect
             */         
		XT_NormalRedraw(XDV->DArea,(XtPointer) VWI, NULL);
		if(!VWI->changed)
		  {
	       /*
		* Do a draw with export set to make the
		* representation hardware independent
		*/               
		   XDC->export = True;
		   VWI->changed = TRANS_CHANGED|CHANGED;
		   XT_NormalRedraw(XDV->DArea,(XtPointer) VWI, NULL);
		   XDC->export = False;
		   XtVaGetValues(XDIE->exGif,
    		       XmNset, &test,
    		       NULL);
		   if(test)
		      test = FI_GifExportPic(Text, XDim);
		   else
		     {
		      val = XmTextFieldGetString(XDIE->exJpegField);
		      if(!sscanf(val,"%d",&qual))
			 qual = 75;
		      XtFree(val);
		      XDC->jpgQuality = qual;
		      test = JP_write_JPEG_file(Text, XDim);
		     }
		  }
		else
		  {
		   strcpy(XDim->error,
			"Sorry no picture export in this redraw mode allowed");
		   test = True;
		  }
               }
             if(test)
	       WD_XDimError(XDim, XDW->DataSelect);
            }
	  XmStringFreeContext(context);
	  XmStringFree(FName);
	  XtUnmanageChild(XDW->DataSelect);
	 }
      }    
   }

/*
 * Pop up file select box for export data
 */

void WD_PopExportData(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    XDimWidgets *XDW;
    XDColorInfo *XDC;
    XmString Pref,Mess;
    XDimImportExport *XDIE;
    Boolean set;

    XDim = (XDimInfo *) client_data;
    if(XDim->port >= 0)
      {
       XDW =  &(XDim->myWidgets);
       XDIE = &(XDW->ImEx);
       XDC = &(XDim->colors);
       XtVaGetValues(XDIE->exAscii,
    	   XmNset, &set,
    	   NULL);
       if(set)
         {
	  XtVaGetValues(XDIE->exGer,
    	      XmNset, &(XDC->GerNot),
    	      NULL);
          Mess = XmStringCreateSimple("Export ASCII Data:");
         }
       else
         {
	  XtVaGetValues(XDIE->exGif,
    	      XmNset, &set,
    	      NULL);
	  if(set)
             Mess = XmStringCreateSimple("Export GIF Picture:");
          else
             Mess = XmStringCreateSimple("Export JPEG Picture:");
         }
       Pref = XmStringCreateSimple("*.*");
       XtVaSetValues(XDW->DataSelect,
	   XmNpattern, Pref,
	   XmNselectionLabelString, Mess,
	   NULL);
       XmStringFree(Mess);
       XmStringFree(Pref);
       if(XDW->activeDTCallback)
	  XtRemoveCallback(XDW->DataSelect, XmNokCallback,
	     XDW->activeDTCallback, XDW->DTclient_data);
       XtAddCallback(XDW->DataSelect, XmNokCallback,
                      WD_okExportData, XDim);
       XDW->activeDTCallback = WD_okExportData;
       XDW->DTclient_data = XDim;
       XtManageChild(XDW->DataSelect);
      }
   }

/*
 * create preference widgets
 */
 
void WD_CreateImEx(Widget parent, XDimInfo *XDim)
   {
    XDimImportExport *XDIE;
    XDColorInfo *XDC;
    Dimension width, height;
    char val[10];

    XDIE = &(XDim->myWidgets.ImEx);
    XDC = &(XDim->colors);

    /* Create Dialog Shell for import */

    XDIE->importShell = XmCreateFormDialog(parent, "importShell", NULL, 0);
    XDIE->importForm= XtVaCreateManagedWidget(
	"frame",
	xmFormWidgetClass,
	XDIE->importShell,
	XmNshadowType, XmSHADOW_ETCHED_IN,
	XmNtopAttachment, XmATTACH_FORM,	/* position the label*/
	XmNtopOffset, 8,
	XmNleftAttachment, XmATTACH_FORM,	/* fix it to the window */
	XmNleftOffset, 8,
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 8,
	NULL);    
    XDIE->modeLabel = XtVaCreateManagedWidget(
	"importMode",              /* widget name */
	xmLabelWidgetClass,     /* widget class from PushB.h */
	XDIE->importForm,                  /* parent widget*/
	XmNleftAttachment, XmATTACH_POSITION,
	XmNleftPosition, 5,
        XmNtopAttachment, XmATTACH_POSITION,
        XmNtopPosition, 3,
	NULL);
    XDIE->RadioBox = XmCreateRadioBox(XDIE->importForm,"importBox", NULL, 0);
    XtManageChild(XDIE->RadioBox);
    XtVaSetValues(XDIE->RadioBox,
    	XmNleftAttachment, XmATTACH_POSITION,
	XmNleftPosition, 10,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDIE->modeLabel,
	XmNtopOffset,8,
	NULL);
    XDIE->ascii = XtVaCreateManagedWidget(
	"ASCII",
	xmToggleButtonGadgetClass,
	XDIE->RadioBox,
	XmNset, True,
	NULL); 
    XDIE->gif = XtVaCreateManagedWidget(
	"GIF",
	xmToggleButtonGadgetClass,
	XDIE->RadioBox,
	NULL); 
    XDIE->jpeg = XtVaCreateManagedWidget(
	"JPEG",
	xmToggleButtonGadgetClass,
	XDIE->RadioBox,
	NULL); 
    XDIE->imSep1 = XtVaCreateManagedWidget(
	"separator",
	xmSeparatorGadgetClass,
	XDIE->importForm,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDIE->RadioBox,
	XmNtopOffset,8,
	XmNleftAttachment, XmATTACH_FORM,
	XmNrightAttachment, XmATTACH_FORM,
	NULL); 
    XDIE->optionsLabel = XtVaCreateManagedWidget(
	"asciiOptions",              /* widget name */
	xmLabelWidgetClass,     /* widget class from PushB.h */
	XDIE->importForm,                  /* parent widget*/
	XmNleftAttachment, XmATTACH_POSITION,
	XmNleftPosition, 5,
        XmNtopAttachment, XmATTACH_WIDGET,
	XmNtopWidget, XDIE->imSep1,
        XmNtopOffset, 8,
	NULL);
    XDIE->fillEdit = XtVaCreateManagedWidget(
	"fillEdit",              /* widget name */
	xmTextFieldWidgetClass,     /* widget class from PushB.h */
	XDIE->importForm,                  /* parent widget*/
	XmNcolumns, 4,
	XmNmaxLength, 10,
	XmNleftAttachment, XmATTACH_POSITION,
	XmNleftPosition, 5,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDIE->optionsLabel,
	XmNtopOffset,8,
	NULL);
    XDIE->fillLabel = XtVaCreateManagedWidget(
	"fillValue",              /* arbitrary widget name */
	xmLabelWidgetClass,     /* widget class  */
	XDIE->importForm,	     /* parent widget*/
	XmNalignment, XmALIGNMENT_BEGINNING,
        XmNrightAttachment, XmATTACH_POSITION,
        XmNrightPosition, 95,
	XmNleftAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNleftWidget, XDIE->fillEdit,
	XmNleftOffset, 16,
        XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
        XmNbottomWidget, XDIE->fillEdit,
        XmNbottomOffset, 2,
	NULL);               /* terminate varargs list */
    XDIE->german = XtVaCreateManagedWidget(
	"germanNotation",
	xmToggleButtonGadgetClass,
	XDIE->importForm,
	XmNset, XDC->GerNot,
        XmNleftAttachment, XmATTACH_POSITION,
        XmNleftPosition, 5,
        XmNtopAttachment, XmATTACH_WIDGET,
        XmNtopWidget, XDIE->fillEdit,
	NULL); 
    XDIE->ImportCancel = XtVaCreateManagedWidget(
	"CANCEL",              /* widget name */
	xmPushButtonWidgetClass,     /* widget class from PushB.h */
	XDIE->importShell,                  /* parent widget*/
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 32,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDIE->importForm,
	XmNtopOffset, 16,
	XmNbottomAttachment, XmATTACH_FORM,
	XmNbottomOffset, 16,
	NULL);
    XtVaGetValues(XDIE->ImportCancel,
    	XtNwidth, &width,
    	XtNheight, &height,
    	NULL);
    XDIE->ImportOk = XtVaCreateManagedWidget(
	"OK",              /* widget name */
	xmPushButtonWidgetClass,     /* widget class from PushB.h */
	XDIE->importShell,                  /* parent widget*/
	XmNwidth, width,
	XmNheight, height,
	XmNleftAttachment, XmATTACH_FORM,
	XmNleftOffset, 32,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDIE->importForm,		/* relativ to LabelC2 */
	XmNtopOffset, 16,
	XmNbottomAttachment, XmATTACH_FORM,
	XmNbottomOffset, 16,
	NULL);


    /* Create Dialog Shell for export */

    XDIE->exportShell = XmCreateFormDialog(parent, "exportShell", NULL, 0);
    XDIE->exportForm= XtVaCreateManagedWidget(
	"frame",
	xmFormWidgetClass,
	XDIE->exportShell,
	XmNshadowType, XmSHADOW_ETCHED_IN,
	XmNtopAttachment, XmATTACH_FORM,	/* position the label*/
	XmNtopOffset, 8,
	XmNleftAttachment, XmATTACH_FORM,	/* fix it to the window */
	XmNleftOffset, 8,
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 8,
	NULL);    
    XDIE->exMode = XtVaCreateManagedWidget(
	"exportMode",              /* widget name */
	xmLabelWidgetClass,     /* widget class from PushB.h */
	XDIE->exportForm,                  /* parent widget*/
	XmNleftAttachment, XmATTACH_POSITION,
	XmNleftPosition, 5,
        XmNtopAttachment, XmATTACH_POSITION,
        XmNtopPosition, 3,
	NULL);
    XDIE->exBox = XmCreateRadioBox(XDIE->exportForm,"exportBox", NULL, 0);
    XtManageChild(XDIE->exBox);
    XtVaSetValues(XDIE->exBox,
    	XmNleftAttachment, XmATTACH_POSITION,
	XmNleftPosition, 10,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDIE->exMode,
	XmNtopOffset,8,
	NULL);
    XDIE->exGif = XtVaCreateManagedWidget(
	"GIF",
	xmToggleButtonGadgetClass,
	XDIE->exBox,
	XmNset, True,
	NULL); 
    XDIE->exJpeg = XtVaCreateManagedWidget(
	"JPEG",
	xmToggleButtonGadgetClass,
	XDIE->exBox,
	NULL); 
    XDIE->exAscii = XtVaCreateManagedWidget(
	"ASCII",
	xmToggleButtonGadgetClass,
	XDIE->exBox,
	NULL); 
    XDIE->exSep1 = XtVaCreateManagedWidget(
	"separator",
	xmSeparatorGadgetClass,
	XDIE->exportForm,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDIE->exBox,
	XmNtopOffset,8,
	XmNleftAttachment, XmATTACH_FORM,
	XmNrightAttachment, XmATTACH_FORM,
	NULL); 
    XDIE->exOptionsText = XtVaCreateManagedWidget(
	"exportOptions",              /* widget name */
	xmLabelWidgetClass,     /* widget class from PushB.h */
	XDIE->exportForm,                  /* parent widget*/
	XmNleftAttachment, XmATTACH_POSITION,
	XmNleftPosition, 5,
        XmNtopAttachment, XmATTACH_WIDGET,
	XmNtopWidget, XDIE->exSep1,
        XmNtopOffset, 8,
	NULL);
    XDIE->exGer = XtVaCreateManagedWidget(
	"germanNotation",
	xmToggleButtonGadgetClass,
	XDIE->exportForm,
	XmNsensitive, False,
	XmNset, XDC->GerNot,
        XmNrightAttachment, XmATTACH_FORM,
        XmNrightOffset, 8,
        XmNtopAttachment, XmATTACH_WIDGET,
        XmNtopWidget, XDIE->exOptionsText,
	XmNtopOffset, 4,
	NULL); 
    XDIE->exAsciiText = XtVaCreateManagedWidget(
	"asciiOption",              /* widget name */
	xmLabelWidgetClass,     /* widget class from PushB.h */
	XDIE->exportForm,                  /* parent widget*/
	XmNsensitive, False,
	XmNleftAttachment, XmATTACH_POSITION,
	XmNleftPosition, 5,
        XmNrightAttachment, XmATTACH_WIDGET,
        XmNrightWidget, XDIE->exGer,
        XmNrightOffset, 8,
        XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
        XmNbottomWidget, XDIE->exGer,
        XmNbottomOffset, 4,
	NULL);
    sprintf(val,"%d",XDC->jpgQuality);
    XDIE->exJpegField = XtVaCreateManagedWidget(
	"jpegQuality",              /* widget name */
	xmTextFieldWidgetClass,     /* widget class from PushB.h */
	XDIE->exportForm,                  /* parent widget*/
	XmNcolumns, 3,
	XmNmaxLength, 3,
	XmNsensitive, False,
	XmNvalue, val,
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 8,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDIE->exGer,
	XmNtopOffset,8,
	XmNbottomAttachment, XmATTACH_FORM,
	XmNbottomOffset, 8,
	NULL);
    XDIE->exJpegText = XtVaCreateManagedWidget(
	"jpegQuality",              /* arbitrary widget name */
	xmLabelWidgetClass,     /* widget class  */
	XDIE->exportForm,	     /* parent widget*/
	XmNalignment, XmALIGNMENT_BEGINNING,
	XmNsensitive, False,
        XmNleftAttachment, XmATTACH_POSITION,
        XmNleftPosition, 5,
	XmNrightAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNrightWidget, XDIE->exJpegField,
	XmNrightOffset, 16,
        XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
        XmNbottomWidget, XDIE->exJpegField,
        XmNbottomOffset, 2,
	NULL);               /* terminate varargs list */
    XDIE->ExportCancel = XtVaCreateManagedWidget(
	"CANCEL",              /* widget name */
	xmPushButtonWidgetClass,     /* widget class from PushB.h */
	XDIE->exportShell,                  /* parent widget*/
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 16,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDIE->exportForm,
	XmNtopOffset, 16,
	XmNbottomAttachment, XmATTACH_FORM,
	XmNbottomOffset, 16,
	NULL);
    XtVaGetValues(XDIE->ExportCancel,
    	XtNwidth, &width,
    	XtNheight, &height,
    	NULL);
    XDIE->ExportOk = XtVaCreateManagedWidget(
	"OK",              /* widget name */
	xmPushButtonWidgetClass,     /* widget class from PushB.h */
	XDIE->exportShell,                  /* parent widget*/
	XmNwidth, width,
	XmNheight, height,
	XmNleftAttachment, XmATTACH_FORM,
	XmNleftOffset, 16,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDIE->exportForm,		/* relativ to LabelC2 */
	XmNtopOffset, 16,
	XmNbottomAttachment, XmATTACH_FORM,
	XmNbottomOffset, 16,
	NULL);

/* Add Callbacks */

    XtAddCallback(XDIE->ascii, XmNvalueChangedCallback,
                  WD_AsciiOptions , XDim);
    XtAddCallback(XDIE->ImportOk, XmNactivateCallback,
                  WD_okImport, XDim);
    XtAddCallback(XDIE->exAscii, XmNvalueChangedCallback,
                  WD_ExportOptions , XDim);
    XtAddCallback(XDIE->exJpeg, XmNvalueChangedCallback,
                  WD_ExportOptions , XDim);
    XtAddCallback(XDIE->ExportOk, XmNactivateCallback,
                  WD_PopExportData, XDim);
    }

/*
 * create preference widgets
 */
 
void WD_CreatePrefs(Widget parent, XDimInfo *XDim)
   {
    XDimPreferences *XDP;
    XDColorInfo *XDC;
    Dimension width, height;

    XDP = &(XDim->myWidgets.Prefs);
    XDC = &(XDim->colors);

    /* Create Dialog Shell for window prefs */

    XDP->winShell = XmCreateFormDialog(parent, "winShell", NULL, 0);
    XDP->winForm= XtVaCreateManagedWidget(
	"frame",
	xmFormWidgetClass,
	XDP->winShell,
	XmNshadowType, XmSHADOW_ETCHED_IN,
	XmNtopAttachment, XmATTACH_FORM,	/* position the label*/
	XmNtopOffset, 8,
	XmNleftAttachment, XmATTACH_FORM,	/* fix it to the window */
	XmNleftOffset, 8,
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 8,
	NULL);    
    XDP->winWidthEdit = XtVaCreateManagedWidget(
	"winWidthEdit",              /* widget name */
	xmTextFieldWidgetClass,     /* widget class from PushB.h */
	XDP->winForm,                  /* parent widget*/
	XmNcolumns, 4,
	XmNmaxLength, 4,
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 16,
        XmNtopAttachment, XmATTACH_POSITION,
        XmNtopPosition, 3,
	NULL);
    XDP->winWidthText = XtVaCreateManagedWidget(
	"windowWidth",              /* arbitrary widget name */
	xmLabelWidgetClass,     /* widget class  */
	XDP->winForm,	     /* parent widget*/
	XmNalignment, XmALIGNMENT_BEGINNING,
        XmNleftAttachment, XmATTACH_POSITION,
        XmNleftPosition, 5,
	XmNrightAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNrightWidget, XDP->winWidthEdit,
	XmNrightOffset, 16,
        XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
        XmNbottomWidget, XDP->winWidthEdit,
        XmNbottomOffset, 2,
	NULL);               /* terminate varargs list */
    XDP->winHeightEdit = XtVaCreateManagedWidget(
	"winHeightEdit",              /* widget name */
	xmTextFieldWidgetClass,     /* widget class from PushB.h */
	XDP->winForm,                  /* parent widget*/
	XmNcolumns, 4,
	XmNmaxLength, 4,
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 16,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDP->winWidthEdit,
	XmNtopOffset,8,
	NULL);
    XDP->winHeightText = XtVaCreateManagedWidget(
	"windowHeight",              /* arbitrary widget name */
	xmLabelWidgetClass,     /* widget class  */
	XDP->winForm,	     /* parent widget*/
	XmNalignment, XmALIGNMENT_BEGINNING,
        XmNleftAttachment, XmATTACH_POSITION,
        XmNleftPosition, 5,
	XmNrightAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNrightWidget, XDP->winHeightEdit,
	XmNrightOffset, 16,
        XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
        XmNbottomWidget, XDP->winHeightEdit,
        XmNbottomOffset, 2,
	NULL);               /* terminate varargs list */
    XDP->winSep1 = XtVaCreateManagedWidget(
	"separator",
	xmSeparatorGadgetClass,
	XDP->winForm,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDP->winHeightEdit,
	XmNtopOffset,8,
	XmNleftAttachment, XmATTACH_FORM,
	XmNrightAttachment, XmATTACH_FORM,
	NULL); 
    XDP->picWidthEdit = XtVaCreateManagedWidget(
	"picWidthEdit",              /* widget name */
	xmTextFieldWidgetClass,     /* widget class from PushB.h */
	XDP->winForm,                  /* parent widget*/
	XmNcolumns, 4,
	XmNmaxLength, 4,
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 16,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDP->winSep1,
	XmNtopOffset,8,
	NULL);
    XDP->picWidthText = XtVaCreateManagedWidget(
	"pictureWidth",              /* arbitrary widget name */
	xmLabelWidgetClass,     /* widget class  */
	XDP->winForm,	     /* parent widget*/
	XmNalignment, XmALIGNMENT_BEGINNING,
        XmNleftAttachment, XmATTACH_POSITION,
        XmNleftPosition, 5,
	XmNrightAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNrightWidget, XDP->picWidthEdit,
	XmNrightOffset, 16,
        XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
        XmNbottomWidget, XDP->picWidthEdit,
        XmNbottomOffset, 2,
	NULL);               /* terminate varargs list */
    XDP->picHeightEdit = XtVaCreateManagedWidget(
	"picHeightEdit",              /* widget name */
	xmTextFieldWidgetClass,     /* widget class from PushB.h */
	XDP->winForm,                  /* parent widget*/
	XmNcolumns, 4,
	XmNmaxLength, 4,
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 16,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDP->picWidthEdit,
	XmNtopOffset,8,
	NULL);
    XDP->picHeightText = XtVaCreateManagedWidget(
	"pictureHeight",              /* arbitrary widget name */
	xmLabelWidgetClass,     /* widget class  */
	XDP->winForm,	     /* parent widget*/
	XmNalignment, XmALIGNMENT_BEGINNING,
        XmNleftAttachment, XmATTACH_POSITION,
        XmNleftPosition, 5,
	XmNrightAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNrightWidget, XDP->picHeightEdit,
	XmNrightOffset, 16,
        XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
        XmNbottomWidget, XDP->picHeightEdit,
        XmNbottomOffset, 2,
	NULL);               /* terminate varargs list */
    XDP->winSep2 = XtVaCreateManagedWidget(
	"separator",
	xmSeparatorGadgetClass,
	XDP->winForm,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDP->picHeightEdit,
	XmNtopOffset,8,
	XmNleftAttachment, XmATTACH_FORM,
	XmNrightAttachment, XmATTACH_FORM,
	NULL); 
    XDP->backCol = XtVaCreateManagedWidget(
	"background",              /* widget name */
	xmPushButtonWidgetClass,     /* widget class from PushB.h */
	XDP->winForm,                  /* parent widget*/
	XmNwidth, 32,
	XmNheight, 32,
        XmNlabelType, XmPIXMAP,
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 16,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDP->winSep2,
	XmNtopOffset,8,
        XmNbottomAttachment, XmATTACH_POSITION,
        XmNbottomPosition, 97,
	NULL);
    XDP->backText = XtVaCreateManagedWidget(
	"backColor",              /* arbitrary widget name */
	xmLabelWidgetClass,     /* widget class  */
	XDP->winForm,	     /* parent widget*/
	XmNalignment, XmALIGNMENT_BEGINNING,
        XmNleftAttachment, XmATTACH_POSITION,
        XmNleftPosition, 5,
	XmNrightAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNrightWidget, XDP->backCol,
	XmNrightOffset, 16,
        XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
        XmNbottomWidget, XDP->backCol,
        XmNbottomOffset, 2,
	NULL);               /* terminate varargs list */
    XDP->winCancel = XtVaCreateManagedWidget(
	"CANCEL",              /* widget name */
	xmPushButtonWidgetClass,     /* widget class from PushB.h */
	XDP->winShell,                  /* parent widget*/
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 32,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDP->winForm,
	XmNtopOffset, 16,
	XmNbottomAttachment, XmATTACH_FORM,
	XmNbottomOffset, 16,
	NULL);
    XtVaGetValues(XDP->winCancel,
    	XtNwidth, &width,
    	XtNheight, &height,
    	NULL);
    XDP->winOk = XtVaCreateManagedWidget(
	"OK",              /* widget name */
	xmPushButtonWidgetClass,     /* widget class from PushB.h */
	XDP->winShell,                  /* parent widget*/
	XmNwidth, width,
	XmNheight, height,
	XmNleftAttachment, XmATTACH_FORM,
	XmNleftOffset, 32,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDP->winForm,		/* relativ to LabelC2 */
	XmNtopOffset, 16,
	XmNbottomAttachment, XmATTACH_FORM,
	XmNbottomOffset, 16,
	NULL);

    /* Create Dialog Shell for movement prefs */

    XDP->movShell = XmCreateFormDialog(parent, "movShell", NULL, 0);
    XDP->movForm= XtVaCreateManagedWidget(
	"frame",
	xmFormWidgetClass,
	XDP->movShell,
	XmNshadowType, XmSHADOW_ETCHED_IN,
	XmNtopAttachment, XmATTACH_FORM,	/* position the label*/
	XmNtopOffset, 8,
	XmNleftAttachment, XmATTACH_FORM,	/* fix it to the window */
	XmNleftOffset, 8,
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 8,
	NULL);    
    XDP->timeIntEdit = XtVaCreateManagedWidget(
	"timeIntEdit",              /* widget name */
	xmTextFieldWidgetClass,     /* widget class from PushB.h */
	XDP->movForm,                  /* parent widget*/
	XmNcolumns, 4,
	XmNmaxLength, 4,
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 16,
        XmNtopAttachment, XmATTACH_POSITION,
        XmNtopPosition, 3,
	NULL);
    XDP->timeIntText = XtVaCreateManagedWidget(
	"timeInt",              /* arbitrary widget name */
	xmLabelWidgetClass,     /* widget class  */
	XDP->movForm,	     /* parent widget*/
	XmNalignment, XmALIGNMENT_BEGINNING,
        XmNleftAttachment, XmATTACH_POSITION,
        XmNleftPosition, 5,
	XmNrightAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNrightWidget, XDP->timeIntEdit,
	XmNrightOffset, 16,
        XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
        XmNbottomWidget, XDP->timeIntEdit,
        XmNbottomOffset, 2,
	NULL);               /* terminate varargs list */
    XDP->movSep1 = XtVaCreateManagedWidget(
	"separator",
	xmSeparatorGadgetClass,
	XDP->movForm,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDP->timeIntEdit,
	XmNtopOffset,8,
	XmNleftAttachment, XmATTACH_FORM,
	XmNrightAttachment, XmATTACH_FORM,
	NULL); 
    XDP->zoomEdit = XtVaCreateManagedWidget(
	"zoomEdit",              /* widget name */
	xmTextFieldWidgetClass,     /* widget class from PushB.h */
	XDP->movForm,                  /* parent widget*/
	XmNcolumns, 4,
	XmNmaxLength, 4,
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 16,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDP->movSep1,
	XmNtopOffset,8,
	NULL);
    XDP->zoomText = XtVaCreateManagedWidget(
	"zoomFactor",              /* arbitrary widget name */
	xmLabelWidgetClass,     /* widget class  */
	XDP->movForm,	     /* parent widget*/
	XmNalignment, XmALIGNMENT_BEGINNING,
        XmNleftAttachment, XmATTACH_POSITION,
        XmNleftPosition, 5,
	XmNrightAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNrightWidget, XDP->zoomEdit,
	XmNrightOffset, 16,
        XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
        XmNbottomWidget, XDP->zoomEdit,
        XmNbottomOffset, 2,
	NULL);               /* terminate varargs list */
    XDP->delAngleEdit = XtVaCreateManagedWidget(
	"angleEdit",              /* widget name */
	xmTextFieldWidgetClass,     /* widget class from PushB.h */
	XDP->movForm,                  /* parent widget*/
	XmNcolumns, 4,
	XmNmaxLength, 8,
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 16,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDP->zoomEdit,
	XmNtopOffset,8,
	NULL);
    XDP->delAngleText = XtVaCreateManagedWidget(
	"deltaAngle",              /* arbitrary widget name */
	xmLabelWidgetClass,     /* widget class  */
	XDP->movForm,	     /* parent widget*/
	XmNalignment, XmALIGNMENT_BEGINNING,
        XmNleftAttachment, XmATTACH_POSITION,
        XmNleftPosition, 5,
	XmNrightAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNrightWidget, XDP->delAngleEdit,
	XmNrightOffset, 16,
        XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
        XmNbottomWidget, XDP->delAngleEdit,
        XmNbottomOffset, 2,
	NULL);               /* terminate varargs list */
    XDP->deltaEdit = XtVaCreateManagedWidget(
	"deltaEdit",              /* widget name */
	xmTextFieldWidgetClass,     /* widget class from PushB.h */
	XDP->movForm,                  /* parent widget*/
	XmNcolumns, 4,
	XmNmaxLength, 4,
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 16,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDP->delAngleEdit,
	XmNtopOffset,8,
        XmNbottomAttachment, XmATTACH_POSITION,
        XmNbottomPosition, 97,
	NULL);
    XDP->deltaText = XtVaCreateManagedWidget(
	"deltaMoveXY",              /* arbitrary widget name */
	xmLabelWidgetClass,     /* widget class  */
	XDP->movForm,	     /* parent widget*/
	XmNalignment, XmALIGNMENT_BEGINNING,
        XmNleftAttachment, XmATTACH_POSITION,
        XmNleftPosition, 5,
	XmNrightAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNrightWidget, XDP->deltaEdit,
	XmNrightOffset, 16,
        XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
        XmNbottomWidget, XDP->deltaEdit,
        XmNbottomOffset, 2,
	NULL);               /* terminate varargs list */
    XDP->movCancel = XtVaCreateManagedWidget(
	"CANCEL",              /* widget name */
	xmPushButtonWidgetClass,     /* widget class from PushB.h */
	XDP->movShell,                  /* parent widget*/
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 32,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDP->movForm,
	XmNtopOffset, 16,
	XmNbottomAttachment, XmATTACH_FORM,
	XmNbottomOffset, 16,
	NULL);
    XtVaGetValues(XDP->movCancel,
    	XtNwidth, &width,
    	XtNheight, &height,
    	NULL);
    XDP->movOk = XtVaCreateManagedWidget(
	"OK",              /* widget name */
	xmPushButtonWidgetClass,     /* widget class from PushB.h */
	XDP->movShell,                  /* parent widget*/
	XmNwidth, width,
	XmNheight, height,
	XmNleftAttachment, XmATTACH_FORM,
	XmNleftOffset, 32,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDP->movForm,		/* relativ to LabelC2 */
	XmNtopOffset, 16,
	XmNbottomAttachment, XmATTACH_FORM,
	XmNbottomOffset, 16,
	NULL);

    /* Create Dialog Shell for grid prefs */

    XDP->gridShell = XmCreateFormDialog(parent, "gridShell", NULL, 0);
    XDP->gridForm= XtVaCreateManagedWidget(
	"frame",
	xmFormWidgetClass,
	XDP->gridShell,
	XmNshadowType, XmSHADOW_ETCHED_IN,
	XmNtopAttachment, XmATTACH_FORM,	/* position the label*/
	XmNtopOffset, 8,
	XmNleftAttachment, XmATTACH_FORM,	/* fix it to the window */
	XmNleftOffset, 8,
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 8,
	NULL);    
    XDP->drawAxis = XtVaCreateManagedWidget(
	"drawAxis",
	xmToggleButtonGadgetClass,
	XDP->gridForm,
        XmNleftAttachment, XmATTACH_POSITION,
        XmNleftPosition, 5,
        XmNtopAttachment, XmATTACH_POSITION,
        XmNtopPosition, 3,
	NULL); 
    XDP->drawAxisText = XtVaCreateManagedWidget(
	"drawAxisText",
	xmToggleButtonGadgetClass,
	XDP->gridForm,
        XmNleftAttachment, XmATTACH_POSITION,
        XmNleftPosition, 5,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDP->drawAxis,
	XmNtopOffset,8,
	NULL); 
    XDP->gridSep3 = XtVaCreateManagedWidget(
	"separator",
	xmSeparatorGadgetClass,
	XDP->gridForm,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDP->drawAxisText,
	XmNtopOffset,8,
	XmNleftAttachment, XmATTACH_FORM,
	XmNrightAttachment, XmATTACH_FORM,
	NULL); 
    XDP->gStepEdit = XtVaCreateManagedWidget(
	"gStepEdit",              /* widget name */
	xmTextFieldWidgetClass,     /* widget class from PushB.h */
	XDP->gridForm,                  /* parent widget*/
	XmNcolumns, 3,
	XmNmaxLength, 3,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDP->gridSep3,
	XmNtopOffset,8,
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 16,
	NULL);
    XDP->gStepText = XtVaCreateManagedWidget(
	"gridStep",              /* arbitrary widget name */
	xmLabelWidgetClass,     /* widget class  */
	XDP->gridForm,	     /* parent widget*/
	XmNalignment, XmALIGNMENT_BEGINNING,
        XmNleftAttachment, XmATTACH_POSITION,
        XmNleftPosition, 5,
	XmNrightAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNrightWidget, XDP->gStepEdit,
	XmNrightOffset, 16,
        XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
        XmNbottomWidget, XDP->gStepEdit,
        XmNbottomOffset, 2,
	NULL);               /* terminate varargs list */
    XDP->foreCol = XtVaCreateManagedWidget(
	"gridColEdit",              /* widget name */
	xmPushButtonWidgetClass,     /* widget class from PushB.h */
	XDP->gridForm,                  /* parent widget*/
	XmNwidth, 32,
	XmNheight, 32,
        XmNlabelType, XmPIXMAP,
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 16,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDP->gStepEdit,
	XmNtopOffset,8,
	NULL);
    XDP->foreText = XtVaCreateManagedWidget(
	"gridColor",              /* arbitrary widget name */
	xmLabelWidgetClass,     /* widget class  */
	XDP->gridForm,	     /* parent widget*/
	XmNalignment, XmALIGNMENT_BEGINNING,
        XmNleftAttachment, XmATTACH_POSITION,
        XmNleftPosition, 5,
	XmNrightAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNrightWidget, XDP->foreCol,
	XmNrightOffset, 16,
        XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
        XmNbottomWidget, XDP->foreCol,
        XmNbottomOffset, 2,
	NULL);               /* terminate varargs list */
    XDP->gridSep1 = XtVaCreateManagedWidget(
	"separator",
	xmSeparatorGadgetClass,
	XDP->gridForm,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDP->foreCol,
	XmNtopOffset,8,
	XmNleftAttachment, XmATTACH_FORM,
	XmNrightAttachment, XmATTACH_FORM,
	NULL); 
    XDP->ticsLabel = XtVaCreateManagedWidget(
	"ticNumber",              /* arbitrary widget name */
	xmLabelWidgetClass,     /* widget class  */
	XDP->gridForm,	     /* parent widget*/
        XmNleftAttachment, XmATTACH_POSITION,
        XmNleftPosition, 5,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDP->gridSep1,
	XmNtopOffset,8,
	NULL);               /* terminate varargs list */
    XDP->ticsZEdit = XtVaCreateManagedWidget(
	"ticsZEdit",              /* widget name */
	xmTextFieldWidgetClass,     /* widget class from PushB.h */
	XDP->gridForm,                  /* parent widget*/
	XmNcolumns, 3,
	XmNmaxLength, 3,
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 16,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDP->ticsLabel,
	XmNtopOffset,8,
	NULL);
    XDP->ticsZText = XtVaCreateManagedWidget(
	"ticsZ",              /* arbitrary widget name */
	xmLabelWidgetClass,     /* widget class  */
	XDP->gridForm,	     /* parent widget*/
	XmNalignment, XmALIGNMENT_END,
	XmNrightAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNrightWidget, XDP->ticsZEdit,
	XmNrightOffset, 8,
        XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
        XmNbottomWidget, XDP->ticsZEdit,
        XmNbottomOffset, 2,
	NULL);               /* terminate varargs list */
    XDP->ticsYEdit = XtVaCreateManagedWidget(
	"ticsYEdit",              /* widget name */
	xmTextFieldWidgetClass,     /* widget class from PushB.h */
	XDP->gridForm,                  /* parent widget*/
	XmNcolumns, 3,
	XmNmaxLength, 3,
	XmNrightAttachment, XmATTACH_WIDGET,
	XmNrightOffset, 16,
	XmNrightWidget, XDP->ticsZText,
        XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
        XmNbottomWidget, XDP->ticsZEdit,
	NULL);
    XDP->ticsYText = XtVaCreateManagedWidget(
	"ticsY",              /* arbitrary widget name */
	xmLabelWidgetClass,     /* widget class  */
	XDP->gridForm,	     /* parent widget*/
	XmNalignment, XmALIGNMENT_END,
	XmNrightAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNrightWidget, XDP->ticsYEdit,
	XmNrightOffset, 8,
        XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
        XmNbottomWidget, XDP->ticsZEdit,
        XmNbottomOffset, 2,
	NULL);               /* terminate varargs list */
    XDP->ticsXEdit = XtVaCreateManagedWidget(
	"ticsXEdit",              /* widget name */
	xmTextFieldWidgetClass,     /* widget class from PushB.h */
	XDP->gridForm,                  /* parent widget*/
	XmNcolumns, 3,
	XmNmaxLength, 3,
	XmNrightAttachment, XmATTACH_WIDGET,
	XmNrightOffset, 16,
	XmNrightWidget, XDP->ticsYText,
        XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
        XmNbottomWidget, XDP->ticsZEdit,
	NULL);
    XDP->ticsXText = XtVaCreateManagedWidget(
	"ticsX",              /* arbitrary widget name */
	xmLabelWidgetClass,     /* widget class  */
	XDP->gridForm,	     /* parent widget*/
	XmNalignment, XmALIGNMENT_END,
        XmNleftAttachment, XmATTACH_POSITION,
        XmNleftPosition, 5,
	XmNrightAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNrightWidget, XDP->ticsXEdit,
	XmNrightOffset, 8,
        XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
        XmNbottomWidget, XDP->ticsZEdit,
        XmNbottomOffset, 2,
	NULL);               /* terminate varargs list */
    XDP->gridSep2 = XtVaCreateManagedWidget(
	"separator",
	xmSeparatorGadgetClass,
	XDP->gridForm,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDP->ticsZEdit,
	XmNtopOffset,8,
	XmNleftAttachment, XmATTACH_FORM,
	XmNrightAttachment, XmATTACH_FORM,
	NULL); 
    XDP->axisForeCol = XtVaCreateManagedWidget(
	"axisColEdit",              /* widget name */
	xmPushButtonWidgetClass,     /* widget class from PushB.h */
	XDP->gridForm,                  /* parent widget*/
	XmNwidth, 32,
	XmNheight, 32,
        XmNlabelType, XmPIXMAP,
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 16,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDP->gridSep2,
	XmNtopOffset,8,
	NULL);
    XDP->axisForeText = XtVaCreateManagedWidget(
	"axisColor",              /* arbitrary widget name */
	xmLabelWidgetClass,     /* widget class  */
	XDP->gridForm,	     /* parent widget*/
	XmNalignment, XmALIGNMENT_BEGINNING,
        XmNleftAttachment, XmATTACH_POSITION,
        XmNleftPosition, 5,
	XmNrightAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNrightWidget, XDP->axisForeCol,
	XmNrightOffset, 16,
        XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
        XmNbottomWidget, XDP->axisForeCol,
        XmNbottomOffset, 2,
	NULL);               /* terminate varargs list */
    XDP->axisBackLabel = XtVaCreateManagedWidget(
	"axisBackground",              /* arbitrary widget name */
	xmLabelWidgetClass,     /* widget class  */
	XDP->gridForm,	     /* parent widget*/
        XmNleftAttachment, XmATTACH_POSITION,
        XmNleftPosition, 5,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDP->axisForeCol,
	XmNtopOffset,8,
	NULL);               /* terminate varargs list */
    XDP->axisBZCol = XtVaCreateManagedWidget(
	"axisBZCol",              /* widget name */
	xmPushButtonWidgetClass,     /* widget class from PushB.h */
	XDP->gridForm,                  /* parent widget*/
	XmNwidth, 32,
	XmNheight, 32,
        XmNlabelType, XmPIXMAP,
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 16,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDP->axisBackLabel,
	XmNtopOffset,8,
        XmNbottomAttachment, XmATTACH_POSITION,
        XmNbottomPosition, 97,
	NULL);
    XDP->axisBZText = XtVaCreateManagedWidget(
	"axisBZ",              /* arbitrary widget name */
	xmLabelWidgetClass,     /* widget class  */
	XDP->gridForm,	     /* parent widget*/
	XmNalignment, XmALIGNMENT_END,
	XmNrightAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNrightWidget, XDP->axisBZCol,
	XmNrightOffset, 8,
        XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
        XmNbottomWidget, XDP->axisBZCol,
        XmNbottomOffset, 2,
	NULL);               /* terminate varargs list */
    XDP->axisBYCol = XtVaCreateManagedWidget(
	"axisBYCol",              /* widget name */
	xmPushButtonWidgetClass,     /* widget class from PushB.h */
	XDP->gridForm,                  /* parent widget*/
	XmNwidth, 32,
	XmNheight, 32,
        XmNlabelType, XmPIXMAP,
	XmNrightAttachment, XmATTACH_WIDGET,
	XmNrightOffset, 16,
	XmNrightWidget, XDP->axisBZText,
        XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
        XmNbottomWidget, XDP->axisBZCol,
	NULL);
    XDP->axisBYText = XtVaCreateManagedWidget(
	"axisBY",              /* arbitrary widget name */
	xmLabelWidgetClass,     /* widget class  */
	XDP->gridForm,	     /* parent widget*/
	XmNalignment, XmALIGNMENT_END,
	XmNrightAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNrightWidget, XDP->axisBYCol,
	XmNrightOffset, 8,
        XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
        XmNbottomWidget, XDP->axisBZCol,
        XmNbottomOffset, 2,
	NULL);               /* terminate varargs list */
    XDP->axisBXCol = XtVaCreateManagedWidget(
	"axisBXCol",              /* widget name */
	xmPushButtonWidgetClass,     /* widget class from PushB.h */
	XDP->gridForm,                  /* parent widget*/
	XmNwidth, 32,
	XmNheight, 32,
        XmNlabelType, XmPIXMAP,
	XmNrightAttachment, XmATTACH_WIDGET,
	XmNrightOffset, 16,
	XmNrightWidget, XDP->axisBYText,
        XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
        XmNbottomWidget, XDP->axisBZCol,
	NULL);
    XDP->axisBXText = XtVaCreateManagedWidget(
	"axisBX",              /* arbitrary widget name */
	xmLabelWidgetClass,     /* widget class  */
	XDP->gridForm,	     /* parent widget*/
	XmNalignment, XmALIGNMENT_END,
        XmNleftAttachment, XmATTACH_POSITION,
        XmNleftPosition, 5,
	XmNrightAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNrightWidget, XDP->axisBXCol,
	XmNrightOffset, 8,
        XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
        XmNbottomWidget, XDP->axisBZCol,
        XmNbottomOffset, 2,
	NULL);               /* terminate varargs list */
    XDP->gridCancel = XtVaCreateManagedWidget(
	"CANCEL",              /* widget name */
	xmPushButtonWidgetClass,     /* widget class from PushB.h */
	XDP->gridShell,                  /* parent widget*/
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 32,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDP->gridForm,
	XmNtopOffset, 16,
	XmNbottomAttachment, XmATTACH_FORM,
	XmNbottomOffset, 16,
	NULL);
    XtVaGetValues(XDP->gridCancel,
    	XtNwidth, &width,
    	XtNheight, &height,
    	NULL);
    XDP->gridOk = XtVaCreateManagedWidget(
	"OK",              /* widget name */
	xmPushButtonWidgetClass,     /* widget class from PushB.h */
	XDP->gridShell,                  /* parent widget*/
	XmNwidth, width,
	XmNheight, height,
	XmNleftAttachment, XmATTACH_FORM,
	XmNleftOffset, 32,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDP->gridForm,		/* relativ to LabelC2 */
	XmNtopOffset, 16,
	XmNbottomAttachment, XmATTACH_FORM,
	XmNbottomOffset, 16,
	NULL);

/* Text preferences */

    XDP->textShell = XmCreateFormDialog(parent, "textShell", NULL, 0);
    XDP->textForm= XtVaCreateManagedWidget(
	"frame",
	xmFormWidgetClass,
	XDP->textShell,
	XmNshadowType, XmSHADOW_ETCHED_IN,
	XmNtopAttachment, XmATTACH_FORM,	/* position the label*/
	XmNtopOffset, 8,
	XmNleftAttachment, XmATTACH_FORM,	/* fix it to the window */
	XmNleftOffset, 8,
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 8,
	NULL);    
    XDP->fontEdit = XtVaCreateManagedWidget(
	"fontEdit",              /* widget name */
	xmTextFieldWidgetClass,     /* widget class from PushB.h */
	XDP->textForm,                  /* parent widget*/
	XmNcolumns, 20,
	XmNmaxLength, MAX_NAME_LENGTH,
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 16,
        XmNtopAttachment, XmATTACH_POSITION,
        XmNtopPosition, 3,
	NULL);
    XDP->fontText = XtVaCreateManagedWidget(
	"fontName",              /* arbitrary widget name */
	xmLabelWidgetClass,     /* widget class  */
	XDP->textForm,	     /* parent widget*/
	XmNalignment, XmALIGNMENT_BEGINNING,
        XmNleftAttachment, XmATTACH_POSITION,
        XmNleftPosition, 5,
	XmNrightAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNrightWidget, XDP->fontEdit,
	XmNrightOffset, 16,
        XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
        XmNbottomWidget, XDP->fontEdit,
        XmNbottomOffset, 2,
	NULL);               /* terminate varargs list */
    XDP->textCol = XtVaCreateManagedWidget(
	"textCol",              /* widget name */
	xmPushButtonWidgetClass,     /* widget class from PushB.h */
	XDP->textForm,                  /* parent widget*/
	XmNwidth, 32,
	XmNheight, 32,
        XmNlabelType, XmPIXMAP,
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 16,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDP->fontEdit,
	XmNtopOffset,8,
	NULL);
    XDP->textText = XtVaCreateManagedWidget(
	"textColor",              /* arbitrary widget name */
	xmLabelWidgetClass,     /* widget class  */
	XDP->textForm,	     /* parent widget*/
	XmNalignment, XmALIGNMENT_BEGINNING,
        XmNleftAttachment, XmATTACH_POSITION,
        XmNleftPosition, 5,
	XmNrightAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNrightWidget, XDP->textCol,
	XmNrightOffset, 16,
        XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
        XmNbottomWidget, XDP->textCol,
        XmNbottomOffset, 2,
	NULL);               /* terminate varargs list */
    XDP->textSep1 = XtVaCreateManagedWidget(
	"separator",
	xmSeparatorGadgetClass,
	XDP->textForm,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDP->textCol,
	XmNtopOffset,8,
	XmNleftAttachment, XmATTACH_FORM,
	XmNrightAttachment, XmATTACH_FORM,
	NULL); 
    XDP->decoLabel = XtVaCreateManagedWidget(
	"decoding",              /* arbitrary widget name */
	xmLabelWidgetClass,     /* widget class  */
	XDP->textForm,	     /* parent widget*/
        XmNleftAttachment, XmATTACH_POSITION,
        XmNleftPosition, 5,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDP->textSep1,
	XmNtopOffset,8,
	NULL);               /* terminate varargs list */
    XDP->useInterCol = XtVaCreateManagedWidget(
	"interpolateColors",
	xmToggleButtonGadgetClass,
	XDP->textForm,
	XmNset, XDC->interCol,
        XmNleftAttachment, XmATTACH_POSITION,
        XmNleftPosition, 5,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDP->decoLabel,
	XmNtopOffset, 8,
	NULL); 
    XDP->decoSCol = XtVaCreateManagedWidget(
	"decoSCol",              /* widget name */
	xmPushButtonWidgetClass,     /* widget class from PushB.h */
	XDP->textForm,                  /* parent widget*/
	XmNwidth, 32,
	XmNheight, 32,
        XmNlabelType, XmPIXMAP,
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 16,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDP->useInterCol,
	XmNtopOffset,8,
	NULL);
    XDP->decoStartText = XtVaCreateManagedWidget(
	"startColor",              /* arbitrary widget name */
	xmLabelWidgetClass,     /* widget class  */
	XDP->textForm,	     /* parent widget*/
	XmNalignment, XmALIGNMENT_BEGINNING,
        XmNleftAttachment, XmATTACH_POSITION,
        XmNleftPosition, 5,
	XmNrightAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNrightWidget, XDP->decoSCol,
	XmNrightOffset, 16,
        XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
        XmNbottomWidget, XDP->decoSCol,
        XmNbottomOffset, 2,
	NULL);               /* terminate varargs list */
    XDP->decoECol = XtVaCreateManagedWidget(
	"decoECol",              /* widget name */
	xmPushButtonWidgetClass,     /* widget class from PushB.h */
	XDP->textForm,                  /* parent widget*/
	XmNwidth, 32,
	XmNheight, 32,
        XmNlabelType, XmPIXMAP,
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 16,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDP->decoSCol,
	XmNtopOffset,8,
        XmNbottomAttachment, XmATTACH_POSITION,
        XmNbottomPosition, 97,
	NULL);
    XDP->decoStartText = XtVaCreateManagedWidget(
	"endColor",              /* arbitrary widget name */
	xmLabelWidgetClass,     /* widget class  */
	XDP->textForm,	     /* parent widget*/
	XmNalignment, XmALIGNMENT_BEGINNING,
        XmNleftAttachment, XmATTACH_POSITION,
        XmNleftPosition, 5,
	XmNrightAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNrightWidget, XDP->decoECol,
	XmNrightOffset, 16,
        XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
        XmNbottomWidget, XDP->decoECol,
        XmNbottomOffset, 2,
	NULL);               /* terminate varargs list */
    XDP->textCancel = XtVaCreateManagedWidget(
	"CANCEL",              /* widget name */
	xmPushButtonWidgetClass,     /* widget class from PushB.h */
	XDP->textShell,                  /* parent widget*/
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 32,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDP->textForm,
	XmNtopOffset, 16,
	XmNbottomAttachment, XmATTACH_FORM,
	XmNbottomOffset, 16,
	NULL);
    XtVaGetValues(XDP->textCancel,
    	XtNwidth, &width,
    	XtNheight, &height,
    	NULL);
    XDP->textOk = XtVaCreateManagedWidget(
	"OK",              /* widget name */
	xmPushButtonWidgetClass,     /* widget class from PushB.h */
	XDP->textShell,                  /* parent widget*/
	XmNwidth, width,
	XmNheight, height,
	XmNleftAttachment, XmATTACH_FORM,
	XmNleftOffset, 32,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDP->textForm,		/* relativ to LabelC2 */
	XmNtopOffset, 16,
	XmNbottomAttachment, XmATTACH_FORM,
	XmNbottomOffset, 16,
	NULL);

/* input Shell */

    XDP->inpShell = XmCreateFormDialog(parent, "inpShell", NULL, 0);
    XDP->inpForm= XtVaCreateManagedWidget(
	"frame",
	xmFormWidgetClass,
	XDP->inpShell,
	XmNshadowType, XmSHADOW_ETCHED_IN,
	XmNleftAttachment, XmATTACH_FORM,	/* fix it to the window */
	XmNleftOffset, 8,
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 8,
	XmNtopAttachment, XmATTACH_FORM,	/* position the label*/
	XmNtopOffset, 8,
	NULL);    
    XDP->inpField = XtVaCreateManagedWidget(
	"inpField",              /* widget name */
	xmTextFieldWidgetClass,     /* widget class from PushB.h */
	XDP->inpForm,                  /* parent widget*/
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 16,
        XmNtopAttachment, XmATTACH_POSITION,
        XmNtopPosition, 15,
        XmNbottomAttachment, XmATTACH_POSITION,
        XmNbottomPosition, 85,
	NULL);
    XDP->inpLabel = XtVaCreateManagedWidget(
	"inputLabel",              /* arbitrary widget name */
	xmLabelWidgetClass,     /* widget class  */
	XDP->inpForm,	     /* parent widget*/
	XmNalignment, XmALIGNMENT_BEGINNING,
        XmNleftAttachment, XmATTACH_POSITION,
        XmNleftPosition, 5,
	XmNrightAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNrightWidget, XDP->inpField,
	XmNrightOffset, 8,
        XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
        XmNbottomWidget, XDP->inpField,
        XmNbottomOffset, 2,
	NULL);               /* terminate varargs list */
    XDP->inpCancel = XtVaCreateManagedWidget(
	"CANCEL",              /* widget name */
	xmPushButtonWidgetClass,     /* widget class from PushB.h */
	XDP->inpShell,                  /* parent widget*/
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 32,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDP->inpForm,
	XmNtopOffset, 16,
	XmNbottomAttachment, XmATTACH_FORM,
	XmNbottomOffset, 16,
	NULL);
    XtVaGetValues(XDP->inpCancel,
    	XtNwidth, &width,
    	XtNheight, &height,
    	NULL);
    XDP->inpOk = XtVaCreateManagedWidget(
	"OK",              /* widget name */
	xmPushButtonWidgetClass,     /* widget class from PushB.h */
	XDP->inpShell,                  /* parent widget*/
	XmNwidth, width,
	XmNheight, height,
	XmNleftAttachment, XmATTACH_FORM,
	XmNleftOffset, 32,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDP->inpForm,		/* relativ to LabelC2 */
	XmNtopOffset, 16,
	XmNbottomAttachment, XmATTACH_FORM,
	XmNbottomOffset, 16,
	NULL);

/* input2 Shell */

    XDP->inp2Shell = XmCreateFormDialog(parent, "inpShell", NULL, 0);
    XDP->inp2Form= XtVaCreateManagedWidget(
	"frame",
	xmFormWidgetClass,
	XDP->inp2Shell,
	XmNshadowType, XmSHADOW_ETCHED_IN,
	XmNleftAttachment, XmATTACH_FORM,	/* fix it to the window */
	XmNleftOffset, 8,
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 8,
	XmNtopAttachment, XmATTACH_FORM,	/* position the label*/
	XmNtopOffset, 8,
	NULL);    
    XDP->inp2Field1 = XtVaCreateManagedWidget(
	"inpField",              /* widget name */
	xmTextFieldWidgetClass,     /* widget class from PushB.h */
	XDP->inp2Form,                  /* parent widget*/
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 24,
        XmNtopAttachment, XmATTACH_POSITION,
        XmNtopPosition, 15,
	NULL);
    XDP->inp2Label1 = XtVaCreateManagedWidget(
	"inputLabel",              /* arbitrary widget name */
	xmLabelWidgetClass,     /* widget class  */
	XDP->inp2Form,	     /* parent widget*/
	XmNalignment, XmALIGNMENT_BEGINNING,
	XmNleftAttachment, XmATTACH_FORM,
	XmNleftOffset, 24,
	XmNrightAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNrightWidget, XDP->inp2Field1,
	XmNrightOffset, 8,
        XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
        XmNbottomWidget, XDP->inp2Field1,
        XmNbottomOffset, 2,
	NULL);               /* terminate varargs list */
    XDP->inp2Field2 = XtVaCreateManagedWidget(
	"inpField",              /* widget name */
	xmTextFieldWidgetClass,     /* widget class from PushB.h */
	XDP->inp2Form,                  /* parent widget*/
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 24,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDP->inp2Field1,
	XmNtopOffset,8,
	XmNbottomAttachment, XmATTACH_POSITION,
	XmNbottomPosition, 85,
	NULL);
    XDP->inp2Label2 = XtVaCreateManagedWidget(
	"inputLabel",              /* arbitrary widget name */
	xmLabelWidgetClass,     /* widget class  */
	XDP->inp2Form,	     /* parent widget*/
	XmNalignment, XmALIGNMENT_BEGINNING,
	XmNleftAttachment, XmATTACH_FORM,
	XmNleftOffset, 24,
	XmNrightAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNrightWidget, XDP->inp2Field2,
	XmNrightOffset, 8,
        XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
        XmNbottomWidget, XDP->inp2Field2,
        XmNbottomOffset, 2,
	NULL);               /* terminate varargs list */
    XDP->inp2Cancel = XtVaCreateManagedWidget(
	"CANCEL",              /* widget name */
	xmPushButtonWidgetClass,     /* widget class from PushB.h */
	XDP->inp2Shell,                  /* parent widget*/
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 32,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDP->inp2Form,
	XmNtopOffset, 16,
	XmNbottomAttachment, XmATTACH_FORM,
	XmNbottomOffset, 16,
	NULL);
    XtVaGetValues(XDP->inp2Cancel,
    	XtNwidth, &width,
    	XtNheight, &height,
    	NULL);
    XDP->inp2Ok = XtVaCreateManagedWidget(
	"OK",              /* widget name */
	xmPushButtonWidgetClass,     /* widget class from PushB.h */
	XDP->inp2Shell,                  /* parent widget*/
	XmNwidth, width,
	XmNheight, height,
	XmNleftAttachment, XmATTACH_FORM,
	XmNleftOffset, 32,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDP->inp2Form,		/* relativ to LabelC2 */
	XmNtopOffset, 16,
	XmNbottomAttachment, XmATTACH_FORM,
	XmNbottomOffset, 16,
	NULL);

/* cast Shell */

    XDP->castShell = XmCreateFormDialog(parent, "castShell", NULL, 0);
    XDP->castForm= XtVaCreateManagedWidget(
	"frame",
	xmFormWidgetClass,
	XDP->castShell,
	XmNshadowType, XmSHADOW_ETCHED_IN,
	XmNleftAttachment, XmATTACH_FORM,	/* fix it to the window */
	XmNleftOffset, 8,
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 8,
	XmNtopAttachment, XmATTACH_FORM,	/* position the label*/
	XmNtopOffset, 8,
	NULL);    
    XDP->castLabel = XtVaCreateManagedWidget(
	"typeCastLabel",
	xmLabelWidgetClass,
	XDP->castForm,
	XmNalignment, XmALIGNMENT_BEGINNING,
        XmNleftAttachment, XmATTACH_POSITION,
        XmNleftPosition, 5,
	XmNrightAttachment, XmATTACH_POSITION,
        XmNrightPosition, 95,
	XmNtopAttachment, XmATTACH_FORM,
        XmNtopOffset, 5,
	XmNbottomAttachment, XmATTACH_FORM,
        XmNbottomOffset, 5,
	NULL);               /* terminate varargs list */
    XDP->castCancel = XtVaCreateManagedWidget(
	"CANCEL",              /* widget name */
	xmPushButtonWidgetClass,     /* widget class from PushB.h */
	XDP->castShell,                  /* parent widget*/
	XmNleftAttachment, XmATTACH_POSITION,
	XmNleftPosition, 60,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDP->castForm,
	XmNtopOffset, 16,
	XmNbottomAttachment, XmATTACH_FORM,
	XmNbottomOffset, 16,
	NULL);
    XtVaGetValues(XDP->inpCancel,
    	XtNwidth, &width,
    	XtNheight, &height,
    	NULL);
    XDP->castOk = XtVaCreateManagedWidget(
	"OK",              /* widget name */
	xmPushButtonWidgetClass,     /* widget class from PushB.h */
	XDP->castShell,                  /* parent widget*/
	XmNwidth, width,
	XmNheight, height,
	XmNrightAttachment, XmATTACH_POSITION,
	XmNrightPosition, 40,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDP->castForm,		/* relativ to LabelC2 */
	XmNtopOffset, 16,
	XmNbottomAttachment, XmATTACH_FORM,
	XmNbottomOffset, 16,
	NULL);
/* range Shell */

    XDP->rangeShell = XmCreateFormDialog(parent, "rangeShell", NULL, 0);
    XDP->rangeForm= XtVaCreateManagedWidget(
	"frame",
	xmFormWidgetClass,
	XDP->rangeShell,
	XmNshadowType, XmSHADOW_ETCHED_IN,
	XmNleftAttachment, XmATTACH_FORM,	/* fix it to the window */
	XmNleftOffset, 8,
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 8,
	XmNtopAttachment, XmATTACH_FORM,	/* position the label*/
	XmNtopOffset, 8,
	NULL);    
    XDP->rgStartEdit = XtVaCreateManagedWidget(
	"startField",              /* widget name */
	xmTextFieldWidgetClass,     /* widget class from PushB.h */
	XDP->rangeForm,                  /* parent widget*/
	XmNcolumns, 8,
	XmNmaxLength, 15,
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 16,
        XmNtopAttachment, XmATTACH_FORM,
        XmNtopOffset, 8,
	NULL);
    XDP->rgStartLabel = XtVaCreateManagedWidget(
	"startLabel",              /* arbitrary widget name */
	xmLabelWidgetClass,     /* widget class  */
	XDP->rangeForm,	     /* parent widget*/
	XmNalignment, XmALIGNMENT_BEGINNING,
        XmNleftAttachment, XmATTACH_POSITION,
        XmNleftPosition, 5,
	XmNrightAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNrightWidget, XDP->rgStartEdit,
	XmNrightOffset, 8,
        XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
        XmNbottomWidget, XDP->rgStartEdit,
        XmNbottomOffset, 2,
	NULL);               /* terminate varargs list */
    XDP->rgEndEdit = XtVaCreateManagedWidget(
	"endField",              /* widget name */
	xmTextFieldWidgetClass,     /* widget class from PushB.h */
	XDP->rangeForm,                  /* parent widget*/
	XmNcolumns, 8,
	XmNmaxLength, 15,
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 16,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDP->rgStartEdit,
	XmNtopOffset,8,
	NULL);
    XDP->rgEndLabel = XtVaCreateManagedWidget(
	"endLabel",              /* arbitrary widget name */
	xmLabelWidgetClass,     /* widget class  */
	XDP->rangeForm,	     /* parent widget*/
	XmNalignment, XmALIGNMENT_BEGINNING,
        XmNleftAttachment, XmATTACH_POSITION,
        XmNleftPosition, 5,
	XmNrightAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNrightWidget, XDP->rgEndEdit,
	XmNrightOffset, 8,
        XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
        XmNbottomWidget, XDP->rgEndEdit,
        XmNbottomOffset, 2,
	NULL);               /* terminate varargs list */
    XDP->rgBaseEdit = XtVaCreateManagedWidget(
	"baseField",              /* widget name */
	xmTextFieldWidgetClass,     /* widget class from PushB.h */
	XDP->rangeForm,                  /* parent widget*/
	XmNcolumns, 8,
	XmNmaxLength, 15,
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 16,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDP->rgEndEdit,
	XmNtopOffset,8,
	NULL);
    XDP->rgBaseLabel = XtVaCreateManagedWidget(
	"baseValue",              /* arbitrary widget name */
	xmLabelWidgetClass,     /* widget class  */
	XDP->rangeForm,	     /* parent widget*/
	XmNalignment, XmALIGNMENT_BEGINNING,
        XmNleftAttachment, XmATTACH_POSITION,
        XmNleftPosition, 5,
	XmNrightAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNrightWidget, XDP->rgBaseEdit,
	XmNrightOffset, 8,
        XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
        XmNbottomWidget, XDP->rgBaseEdit,
        XmNbottomOffset, 2,
	NULL);               /* terminate varargs list */
    XDP->rgDimEdit = XtVaCreateManagedWidget(
	"dimField",              /* widget name */
	xmTextFieldWidgetClass,     /* widget class from PushB.h */
	XDP->rangeForm,                  /* parent widget*/
	XmNcolumns, 13,
	XmNmaxLength, 32,
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 16,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDP->rgBaseEdit,
	XmNtopOffset,8,
        XmNbottomAttachment, XmATTACH_FORM,
        XmNbottomOffset, 8,
	NULL);
    XDP->rgDimLabel = XtVaCreateManagedWidget(
	"Dimension",              /* arbitrary widget name */
	xmLabelWidgetClass,     /* widget class  */
	XDP->rangeForm,	     /* parent widget*/
	XmNalignment, XmALIGNMENT_BEGINNING,
        XmNleftAttachment, XmATTACH_POSITION,
        XmNleftPosition, 5,
	XmNrightAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNrightWidget, XDP->rgDimEdit,
	XmNrightOffset, 8,
        XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
        XmNbottomWidget, XDP->rgDimEdit,
        XmNbottomOffset, 2,
	NULL);               /* terminate varargs list */
    XDP->rgCancel = XtVaCreateManagedWidget(
	"CANCEL",              /* widget name */
	xmPushButtonWidgetClass,     /* widget class from PushB.h */
	XDP->rangeShell,                  /* parent widget*/
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 32,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDP->rangeForm,
	XmNtopOffset, 16,
	XmNbottomAttachment, XmATTACH_FORM,
	XmNbottomOffset, 16,
	NULL);
    XtVaGetValues(XDP->rgCancel,
    	XtNwidth, &width,
    	XtNheight, &height,
    	NULL);
    XDP->rgOk = XtVaCreateManagedWidget(
	"OK",              /* widget name */
	xmPushButtonWidgetClass,     /* widget class from PushB.h */
	XDP->rangeShell,                  /* parent widget*/
	XmNwidth, width,
	XmNheight, height,
	XmNleftAttachment, XmATTACH_FORM,
	XmNleftOffset, 32,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDP->rangeForm,		/* relativ to LabelC2 */
	XmNtopOffset, 16,
	XmNbottomAttachment, XmATTACH_FORM,
	XmNbottomOffset, 16,
	NULL);

/* resize Shell */

    XDP->sizeShell = XmCreateFormDialog(parent, "sizeShell", NULL, 0);
    XDP->sizeForm= XtVaCreateManagedWidget(
	"frame",
	xmFormWidgetClass,
	XDP->sizeShell,
	XmNshadowType, XmSHADOW_ETCHED_IN,
	XmNleftAttachment, XmATTACH_FORM,	/* fix it to the window */
	XmNleftOffset, 8,
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 8,
	XmNtopAttachment, XmATTACH_FORM,	/* position the label*/
	XmNtopOffset, 8,
	NULL);    
    XDP->siWidthEdit = XtVaCreateManagedWidget(
	"inpField",              /* widget name */
	xmTextFieldWidgetClass,     /* widget class from PushB.h */
	XDP->sizeForm,                  /* parent widget*/
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 24,
	XmNtopAttachment, XmATTACH_FORM,
	XmNtopOffset, 8,
	XmNcolumns, 4,
	XmNmaxLength, 4,
	NULL);
    XDP->siWidthLabel = XtVaCreateManagedWidget(
	"newWidth",              /* arbitrary widget name */
	xmLabelWidgetClass,     /* widget class  */
	XDP->sizeForm,	     /* parent widget*/
	XmNalignment, XmALIGNMENT_BEGINNING,
	XmNleftAttachment, XmATTACH_FORM,
	XmNleftOffset, 24,
	XmNrightAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNrightWidget, XDP->siWidthEdit,
	XmNrightOffset, 8,
        XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
        XmNbottomWidget, XDP->siWidthEdit,
        XmNbottomOffset, 2,
	NULL);               /* terminate varargs list */
    XDP->siHeightEdit = XtVaCreateManagedWidget(
	"inpField",
	xmTextFieldWidgetClass,
	XDP->sizeForm,
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 24,
	XmNtopAttachment, XmATTACH_WIDGET,
	XmNtopWidget, XDP->siWidthEdit,
	XmNtopOffset,8,
	XmNcolumns, 4,
	XmNmaxLength, 4,
	NULL);
    XDP->siHeightLabel = XtVaCreateManagedWidget(
	"newHeight",
	xmLabelWidgetClass,
	XDP->sizeForm,
	XmNalignment, XmALIGNMENT_BEGINNING,
	XmNleftAttachment, XmATTACH_FORM,
	XmNleftOffset, 24,
	XmNrightAttachment, XmATTACH_WIDGET,
	XmNrightWidget, XDP->siHeightEdit,
	XmNrightOffset, 8,
        XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
        XmNbottomWidget, XDP->siHeightEdit,
        XmNbottomOffset, 2,
	NULL);               /* terminate varargs list */
    XDP->siModeLabel = XtVaCreateManagedWidget(
	"resizeMode",
	xmLabelWidgetClass,
	XDP->sizeForm,
	XmNalignment, XmALIGNMENT_BEGINNING,
	XmNleftAttachment, XmATTACH_FORM,
	XmNleftOffset, 32,
	XmNtopAttachment, XmATTACH_WIDGET,
	XmNtopWidget, XDP->siHeightEdit,
	XmNtopOffset,16,
	NULL);
    XDP->siInterRadio = XmCreateRadioBox(XDP->sizeForm,"resizeBox", NULL, 0);
    XtManageChild(XDP->siInterRadio);
    XtVaSetValues(XDP->siInterRadio,
    	XmNleftAttachment, XmATTACH_FORM,
	XmNleftOffset, 40,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDP->siModeLabel,
	XmNtopOffset,8,
	XmNbottomAttachment, XmATTACH_FORM,
	XmNbottomOffset, 8,
	NULL);
    XDP->siInter = XtVaCreateManagedWidget(
	"Linear",
	xmToggleButtonGadgetClass,
	XDP->siInterRadio,
	XmNset, True,
	NULL); 
    XDP->siSpline = XtVaCreateManagedWidget(
	"Spline",
	xmToggleButtonGadgetClass,
	XDP->siInterRadio,
	NULL); 

    XDP->siCancel = XtVaCreateManagedWidget(
	"CANCEL",              /* widget name */
	xmPushButtonWidgetClass,     /* widget class from PushB.h */
	XDP->sizeShell,                  /* parent widget*/
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 32,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDP->sizeForm,
	XmNtopOffset, 16,
	XmNbottomAttachment, XmATTACH_FORM,
	XmNbottomOffset, 16,
	NULL);
    XtVaGetValues(XDP->siCancel,
    	XtNwidth, &width,
    	XtNheight, &height,
    	NULL);
    XDP->siOk = XtVaCreateManagedWidget(
	"OK",              /* widget name */
	xmPushButtonWidgetClass,     /* widget class from PushB.h */
	XDP->sizeShell,                  /* parent widget*/
	XmNwidth, width,
	XmNheight, height,
	XmNleftAttachment, XmATTACH_FORM,
	XmNleftOffset, 32,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDP->sizeForm,		/* relativ to LabelC2 */
	XmNtopOffset, 16,
	XmNbottomAttachment, XmATTACH_FORM,
	XmNbottomOffset, 16,
	NULL);


/* Add Callbacks */

    XtAddCallback(XDP->backCol, XmNactivateCallback,
                  WD_SelectWinBack , XDim);
    XtAddCallback(XDP->textCol, XmNactivateCallback,
                  WD_SelectTextCol , XDim);
    XtAddCallback(XDP->decoSCol, XmNactivateCallback,
                  WD_SelectDColS , XDim);
    XtAddCallback(XDP->decoECol, XmNactivateCallback,
                  WD_SelectDColE , XDim);
    XtAddCallback(XDP->foreCol, XmNactivateCallback,
                  WD_SelectGridCol , XDim);
    XtAddCallback(XDP->axisForeCol, XmNactivateCallback,
                  WD_SelectAxisCol , XDim);
    XtAddCallback(XDP->axisBXCol, XmNactivateCallback,
                  WD_SelectXBack , XDim);
    XtAddCallback(XDP->axisBYCol, XmNactivateCallback,
                  WD_SelectYBack , XDim);
    XtAddCallback(XDP->axisBZCol, XmNactivateCallback,
                  WD_SelectZBack , XDim);
    XtAddCallback(XDP->inp2Ok, XmNactivateCallback,
                   WD_okInput2, XDim);
    XtAddCallback(XDP->rgOk, XmNactivateCallback,
                   WD_okRange, XDim);
    XtAddCallback((XDim->myWidgets).ViewMenus.size, XmNactivateCallback,
		WD_PopResize, XDim);
    XtAddCallback(XDP->siOk, XmNactivateCallback,
                   WD_okResize, XDim);
    XtAddCallback(XDP->castOk, XmNactivateCallback,
                   WD_okCastData, XDim);

   }

/*
 * create position select
 */
 
void WD_CreatePos(Widget parent, XDimInfo *XDim)
   {
    XDimPosSelect *XPS;
    Dimension width, height;

    XPS = &(XDim->myWidgets.Pos);

    /* Create Dialog Shell */

    XPS->Shell = XmCreateFormDialog(parent, "posShell", NULL, 0);
    XPS->Form= XtVaCreateManagedWidget(
	"frame",
	xmFormWidgetClass,
	XPS->Shell,
	XmNshadowType, XmSHADOW_ETCHED_IN,
	XmNtopAttachment, XmATTACH_FORM,	/* position the label*/
	XmNtopOffset, 8,
	XmNleftAttachment, XmATTACH_FORM,	/* fix it to the window */
	XmNleftOffset, 8,
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 8,
	NULL);    
    XPS->Frame = XtVaCreateManagedWidget(
	"frame",
	xmFrameWidgetClass,
	XPS->Form,
	XmNshadowType, XmSHADOW_IN,
	XmNtopAttachment, XmATTACH_FORM, /* position the area*/
	XmNtopOffset,8,
	XmNleftAttachment, XmATTACH_POSITION,	/* fix it to the window */
	XmNleftPosition, 5,
	XmNrightAttachment, XmATTACH_POSITION,
	XmNrightPosition, 95,
	NULL); 
    XPS->DArea = XtVaCreateManagedWidget(
	"Area",
	xmDrawingAreaWidgetClass,
	XPS->Frame,
	XmNwidth, 200,
	XmNheight, 200,
	NULL);	
    XPS->YEdit = XtVaCreateManagedWidget(
	"ypos",
	xmTextFieldWidgetClass,
	XPS->Form,
	XmNcolumns, 5,
	XmNmaxLength, 5,
	XmNrightAttachment, XmATTACH_POSITION,
	XmNrightPosition, 85,
	XmNtopAttachment, XmATTACH_WIDGET,
	XmNtopWidget, XPS->Frame,
	XmNtopOffset,8,
	NULL);
    XPS->YLabel = XtVaCreateManagedWidget(
	"Y",              /* arbitrary widget name */
	xmLabelWidgetClass,     /* widget class  */
	XPS->Form,	     /* parent widget*/
	XmNalignment, XmALIGNMENT_END,
	XmNrightAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNrightWidget, XPS->YEdit,
	XmNrightOffset, 8,
        XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
        XmNbottomWidget, XPS->YEdit,
        XmNbottomOffset, 2,
	NULL);
    XPS->XEdit = XtVaCreateManagedWidget(
	"xpos",
	xmTextFieldWidgetClass,
	XPS->Form,
	XmNcolumns, 5,
	XmNmaxLength, 5,
	XmNrightAttachment, XmATTACH_WIDGET,
	XmNrightWidget, XPS->YLabel,
	XmNrightOffset, 16,
	XmNtopAttachment, XmATTACH_WIDGET,
	XmNtopWidget, XPS->Frame,
	XmNtopOffset,8,
	NULL);
    XPS->XLabel = XtVaCreateManagedWidget(
	"X",
	xmLabelWidgetClass,
	XPS->Form,
	XmNalignment, XmALIGNMENT_END,
	XmNrightAttachment, XmATTACH_WIDGET,
	XmNrightWidget, XPS->XEdit,
	XmNrightOffset, 16,
        XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
        XmNbottomWidget, XPS->XEdit,
        XmNbottomOffset, 2,
	NULL);
    XPS->Sep1 = XtVaCreateManagedWidget(
	"separator",
	xmSeparatorGadgetClass,
	XPS->Form,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XPS->YEdit,
	XmNtopOffset,8,
	XmNleftAttachment, XmATTACH_FORM,
	XmNrightAttachment, XmATTACH_FORM,
	NULL); 
    XPS->PosLabel = XtVaCreateManagedWidget(
	"Position",              /* arbitrary widget name */
	xmLabelWidgetClass,     /* widget class  */
	XPS->Form,	     /* parent widget*/
	XmNalignment, XmALIGNMENT_BEGINNING,
        XmNleftAttachment, XmATTACH_POSITION,
        XmNleftPosition, 5,
        XmNtopAttachment, XmATTACH_WIDGET,
        XmNtopWidget, XPS->Sep1,
        XmNtopOffset, 8,
	NULL);               /* terminate varargs list */
    XPS->VEdit1 = XtVaCreateManagedWidget(
	"view1",              /* widget name */
	xmTextFieldWidgetClass,     /* widget class from PushB.h */
	XPS->Form,                  /* parent widget*/
	XmNcolumns, 32,
	XmNmaxLength, MAX_NAME_LENGTH,
	XmNeditable, False,
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 16,
	XmNleftAttachment, XmATTACH_FORM,
	XmNleftOffset, 16,
        XmNtopAttachment, XmATTACH_WIDGET,
        XmNtopWidget, XPS->PosLabel,
        XmNtopOffset, 8,
	NULL);
    XPS->WHLabel1 = XtVaCreateManagedWidget(
	"WidthxHeight",              /* arbitrary widget name */
	xmLabelWidgetClass,     /* widget class  */
	XPS->Form,	     /* parent widget*/
        XmNleftAttachment, XmATTACH_POSITION,
        XmNleftPosition, 5,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XPS->VEdit1,
	XmNtopOffset,4,
	NULL);               /* terminate varargs list */
    XPS->WhereLabel = XtVaCreateManagedWidget(
	"in",              /* arbitrary widget name */
	xmLabelWidgetClass,     /* widget class  */
	XPS->Form,	     /* parent widget*/
	XmNalignment, XmALIGNMENT_BEGINNING,
        XmNleftAttachment, XmATTACH_POSITION,
        XmNleftPosition, 5,
        XmNrightAttachment, XmATTACH_POSITION,
        XmNrightPosition, 95,
        XmNtopAttachment, XmATTACH_WIDGET,
        XmNtopWidget, XPS->WHLabel1,
        XmNtopOffset, 8,
	NULL);               /* terminate varargs list */
    XPS->VEdit2 = XtVaCreateManagedWidget(
	"view2",              /* widget name */
	xmTextFieldWidgetClass,     /* widget class from PushB.h */
	XPS->Form,                  /* parent widget*/
	XmNcolumns, 32,
	XmNmaxLength, MAX_NAME_LENGTH,
	XmNeditable, False,
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 16,
	XmNleftAttachment, XmATTACH_FORM,
	XmNleftOffset, 16,
        XmNtopAttachment, XmATTACH_WIDGET,
        XmNtopWidget, XPS->WhereLabel,
        XmNtopOffset, 8,
	NULL);
    XPS->WHLabel2 = XtVaCreateManagedWidget(
	"WidthxHeight",              /* arbitrary widget name */
	xmLabelWidgetClass,     /* widget class  */
	XPS->Form,	     /* parent widget*/
        XmNleftAttachment, XmATTACH_POSITION,
        XmNleftPosition, 5,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XPS->VEdit2,
	XmNtopOffset,4,
	XmNbottomAttachment, XmATTACH_FORM,
	XmNbottomOffset, 8,
	NULL);               /* terminate varargs list */

    XPS->Cancel = XtVaCreateManagedWidget(
	"CANCEL",
	xmPushButtonWidgetClass,
	XPS->Shell,
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 32,
	XmNtopAttachment, XmATTACH_WIDGET,
	XmNtopWidget, XPS->Form,
	XmNtopOffset, 16,
	XmNbottomAttachment, XmATTACH_FORM,
	XmNbottomOffset, 16,
	NULL);
    XtVaGetValues(XPS->Cancel,
    	XtNwidth, &width,
    	XtNheight, &height,
    	NULL);
    XPS->Ok = XtVaCreateManagedWidget(
	"OK",
	xmPushButtonWidgetClass,
	XPS->Shell,
	XmNwidth, width,
	XmNheight, height,
	XmNleftAttachment, XmATTACH_FORM,
	XmNleftOffset, 32,
	XmNtopAttachment, XmATTACH_WIDGET,
	XmNtopWidget, XPS->Form,
	XmNtopOffset, 16,
	XmNbottomAttachment, XmATTACH_FORM,
	XmNbottomOffset, 16,
	NULL);

/* Add callbacks */

    XtAddCallback(XPS->DArea, XmNexposeCallback,
                  WD_RedrawPosition , XDim);
    XtAddCallback(XPS->XEdit, XmNactivateCallback,
                  WD_RedrawPosition , XDim);
    XtAddCallback(XPS->YEdit, XmNactivateCallback,
                  WD_RedrawPosition , XDim);
    XtAddCallback(XPS->Ok, XmNactivateCallback,
                  WD_okPosition , XDim);
   }

/*
 * Change Prefences (Buttons etc.)
 * after loading
 */

void WD_SetPrefWidgets(XDimInfo *XDim)
   {
    XDColorInfo *XDC;
    XDimPreferences *XDP;
    XDimMainMenuBar *XDM;
    Widget wd;

    XDC = &(XDim->colors);    
    XDP = &(XDim->myWidgets.Prefs);
    XDM = &(XDim->myWidgets.MainMenu);
    XtVaSetValues(XDP->useInterCol,
	XmNset, XDC->interCol,
	NULL);
    XtVaSetValues(XDM->FGrid,
	XmNset, False,
	NULL);
    XtVaSetValues(XDM->FLines,
	XmNset, False,
	NULL);
    XtVaSetValues(XDM->FHidden,
	XmNset, False,
	NULL);
    XtVaSetValues(XDM->FFilled,
	XmNset, False,
	NULL);
    XtVaSetValues(XDM->FHFilled,
	XmNset, False,
	NULL);
    XtVaSetValues(XDM->NLines,
	XmNset, False,
	NULL);
    XtVaSetValues(XDM->NHidden,
	XmNset, False,
	NULL);
    XtVaSetValues(XDM->NFilled,
	XmNset, False,
	NULL);
    XtVaSetValues(XDM->NHFilled,
	XmNset, False,
	NULL);
    XtVaSetValues(XDM->NComFilled,
	XmNset, False,
	NULL);
    XtVaSetValues(XDM->NComHFilled,
	XmNset, False,
	NULL);
    switch(XT_GetRedrawIndex((funcCast)(XDim->FastRedraw), XDim))
       {
        case 0:
         wd = XDM->FGrid;
         break;
        case 1:
         wd = XDM->FLines;
         break;
        case 2:
        default:
         wd = XDM->FHidden;
         break;
        case 3:
         wd = XDM->FFilled;
         break;
        case 4:
         wd = XDM->FHFilled;
         break;
       }
    XtVaSetValues(wd,
	XmNset, True,
	NULL);
    switch(XT_GetRedrawIndex((funcCast)(XDim->NormalRedraw), XDim))
       {
        case 1:
         wd = XDM->NLines;
         break;
        case 2:
        default:
         wd = XDM->NHidden;
         break;
        case 3:
         wd = XDM->NFilled;
         break;
        case 4:
         wd = XDM->NHFilled;
         break;
        case 6:
         wd = XDM->NComFilled;
         break;
        case 7:
         wd = XDM->NComHFilled;
         break;
       }
    XtVaSetValues(wd,
	XmNset, True,
	NULL);
   }

/*
 * create math select
 */
 
void WD_CreateMath(Widget parent, XDimInfo *XDim)
   {
    XDimMath *XDM;
    Dimension width, height;

    XDM = &(XDim->myWidgets.Math);

    /* Create Dialog Shell */

    XDM->Shell = XmCreateFormDialog(parent, "mathShell", NULL, 0);
    XDM->Form= XtVaCreateManagedWidget(
	"frame",
	xmFormWidgetClass,
	XDM->Shell,
	XmNshadowType, XmSHADOW_ETCHED_IN,
	XmNtopAttachment, XmATTACH_FORM,	/* position the label*/
	XmNtopOffset, 8,
	XmNleftAttachment, XmATTACH_FORM,	/* fix it to the window */
	XmNleftOffset, 8,
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 8,
	NULL);    
    XDM->Text = XtVaCreateManagedWidget(
	"Point",              /* arbitrary widget name */
	xmLabelWidgetClass,     /* widget class  */
	XDM->Form,	     /* parent widget*/
        XmNleftAttachment, XmATTACH_POSITION,
        XmNleftPosition, 5,
        XmNrightAttachment, XmATTACH_POSITION,
        XmNrightPosition, 95,
        XmNtopAttachment, XmATTACH_POSITION,
        XmNtopPosition, 5,
	NULL);               /* terminate varargs list */
    XDM->Sep1 = XtVaCreateManagedWidget(
	"separator",
	xmSeparatorGadgetClass,
	XDM->Form,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDM->Text,
	XmNtopOffset,8,
	XmNleftAttachment, XmATTACH_FORM,
	XmNrightAttachment, XmATTACH_FORM,
	NULL); 
    XDM->Apply = XtVaCreateManagedWidget(
	"operator",              /* arbitrary widget name */
	xmLabelWidgetClass,     /* widget class  */
	XDM->Form,	     /* parent widget*/
	XmNalignment, XmALIGNMENT_BEGINNING,
        XmNleftAttachment, XmATTACH_FORM,
        XmNleftOffset, 8,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDM->Sep1,
	XmNtopOffset,8,
	NULL);               /* terminate varargs list */
    XDM->Oper1 = XtVaCreateManagedWidget(
	"oper1",              /* widget name */
	xmTextFieldWidgetClass,     /* widget class from PushB.h */
	XDM->Form,                  /* parent widget*/
	XmNcolumns, 32,
	XmNmaxLength, MAX_NAME_LENGTH,
	XmNeditable, False,
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 16,
	XmNleftAttachment, XmATTACH_FORM,
	XmNleftOffset, 16,
        XmNtopAttachment, XmATTACH_WIDGET,
        XmNtopWidget, XDM->Apply,
        XmNtopOffset, 8,
	NULL);
    XDM->To = XtVaCreateManagedWidget(
	"WidthxHeight",              /* arbitrary widget name */
	xmLabelWidgetClass,     /* widget class  */
	XDM->Form,	     /* parent widget*/
        XmNleftAttachment, XmATTACH_FORM,
        XmNleftOffset, 8,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDM->Oper1,
	XmNtopOffset,4,
	NULL);               /* terminate varargs list */
    XDM->Oper2 = XtVaCreateManagedWidget(
	"view2",              /* widget name */
	xmTextFieldWidgetClass,     /* widget class from PushB.h */
	XDM->Form,                  /* parent widget*/
	XmNcolumns, 32,
	XmNmaxLength, MAX_NAME_LENGTH,
	XmNeditable, False,
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 16,
	XmNleftAttachment, XmATTACH_FORM,
	XmNleftOffset, 16,
        XmNtopAttachment, XmATTACH_WIDGET,
        XmNtopWidget, XDM->To,
        XmNtopOffset, 8,
	XmNbottomAttachment, XmATTACH_FORM,
	XmNbottomOffset, 8,
	NULL);

    XDM->Cancel = XtVaCreateManagedWidget(
	"CANCEL",
	xmPushButtonWidgetClass,
	XDM->Shell,
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 32,
	XmNtopAttachment, XmATTACH_WIDGET,
	XmNtopWidget, XDM->Form,
	XmNtopOffset, 16,
	XmNbottomAttachment, XmATTACH_FORM,
	XmNbottomOffset, 16,
	NULL);
    XtVaGetValues(XDM->Cancel,
    	XtNwidth, &width,
    	XtNheight, &height,
    	NULL);
    XDM->Ok = XtVaCreateManagedWidget(
	"OK",
	xmPushButtonWidgetClass,
	XDM->Shell,
	XmNwidth, width,
	XmNheight, height,
	XmNleftAttachment, XmATTACH_FORM,
	XmNleftOffset, 32,
	XmNtopAttachment, XmATTACH_WIDGET,
	XmNtopWidget, XDM->Form,
	XmNtopOffset, 16,
	XmNbottomAttachment, XmATTACH_FORM,
	XmNbottomOffset, 16,
	NULL);

/* Add callbacks */

    XtAddCallback(XDM->Ok, XmNactivateCallback,
                  WD_okMath , XDim);
    XtAddCallback(XDM->Cancel, XmNactivateCallback,
                  WD_cancelMath , XDim);
   }

void WD_CreateColorMenuBar(Widget parent, XDimColorMenuBar *XDCM)
   {

    /*
     * Create Menu Bar
     */
    XDCM->Bar = XmCreateMenuBar( parent, "menuBar", NULL, 0);
    /*
     * Create File Menu
     */
    XDCM->FileButton = XtVaCreateManagedWidget(
	"fileMenu",
	xmCascadeButtonWidgetClass,
	XDCM->Bar,
	NULL);
    XDCM->FileMenu = XmCreatePulldownMenu(
	XDCM->Bar,
	"fileMenu",
	NULL,
	0);
    /*
     * Create Edit Menu
     */
    XDCM->EditButton = XtVaCreateManagedWidget(
	"editMenu",
	xmCascadeButtonWidgetClass,
	XDCM->Bar,
	NULL);
    XDCM->EditMenu = XmCreatePulldownMenu(
	XDCM->Bar,
	"editMenu",
	NULL,
	0);
    /*
     * Create Prferences Menu
     */
    XDCM->PrefButton = XtVaCreateManagedWidget(
	"Preferences",
	xmCascadeButtonWidgetClass,
	XDCM->Bar,
	NULL);
    XDCM->PrefMenu = XmCreatePulldownMenu(
	XDCM->Bar,
	"prefMenu",
	NULL,
	0);
    /*
     * Create Help Button
     */
    XDCM->HelpButton = XtVaCreateManagedWidget(
	"Help",
	xmCascadeButtonWidgetClass,
	XDCM->Bar,
	NULL);
    /*
     * Create File Menu Items
     */
    XDCM->prefs = XtVaCreateManagedWidget(
	"Load",
	xmPushButtonWidgetClass,
	XDCM->FileMenu,
	NULL); 
    XDCM->save = XtVaCreateManagedWidget(
	"Save",
	xmPushButtonWidgetClass,
	XDCM->FileMenu,
	NULL); 
    XDCM->saveAs = XtVaCreateManagedWidget(
	"SaveAs",
	xmPushButtonWidgetClass,
	XDCM->FileMenu,
	NULL); 
    XDCM->sep1 = XtVaCreateManagedWidget(
	"separator",
	xmSeparatorGadgetClass,
	XDCM->FileMenu,
	NULL); 
    XDCM->close = XtVaCreateManagedWidget(
	"Close",
	xmPushButtonWidgetClass,
	XDCM->FileMenu,
	NULL); 

    /*
     * Create Edit Menu Items
     */
    XDCM->new = XtVaCreateManagedWidget(
	"New",
	xmPushButtonWidgetClass,
	XDCM->EditMenu,
	NULL); 
    XDCM->edit = XtVaCreateManagedWidget(
	"Edit",
	xmPushButtonWidgetClass,
	XDCM->EditMenu,
	NULL); 
    XDCM->delete = XtVaCreateManagedWidget(
	"Delete",
	xmPushButtonWidgetClass,
	XDCM->EditMenu,
	NULL); 
    /*
     * Create Preference Menu Items
     */
    XDCM->Window = XtVaCreateManagedWidget(
	"Window",
	xmPushButtonWidgetClass,
	XDCM->PrefMenu,
	NULL); 
    XDCM->Grid = XtVaCreateManagedWidget(
	"Grid",
	xmPushButtonWidgetClass,
	XDCM->PrefMenu,
	NULL); 
    XDCM->Move = XtVaCreateManagedWidget(
	"Movement",
	xmPushButtonWidgetClass,
	XDCM->PrefMenu,
	NULL); 
    XDCM->Misc = XtVaCreateManagedWidget(
	"Misc",
	xmPushButtonWidgetClass,
	XDCM->PrefMenu,
	NULL); 
    XtVaSetValues(XDCM->Bar,
	XmNleftAttachment, XmATTACH_FORM,
	XmNrightAttachment, XmATTACH_FORM,
	XmNmenuHelpWidget, XDCM->HelpButton,
	NULL);
    XtManageChild(XDCM->Bar);
    /*
     * Specify the menus
     */
    XtVaSetValues(XDCM->FileButton, XmNsubMenuId, XDCM->FileMenu, NULL);
    XtVaSetValues(XDCM->EditButton, XmNsubMenuId, XDCM->EditMenu, NULL);
    XtVaSetValues(XDCM->PrefButton, XmNsubMenuId, XDCM->PrefMenu, NULL);
   }

void WD_CreateColorPanel(Widget parent, XDimInfo *XDim)
   {
    XDimWidgets *XDW;
    XDimColorControl *XDC;

    XDW = &(XDim->myWidgets);
    XDC = &(XDW->ColorPanel);
    XDC->ColorShell = XtVaCreatePopupShell(
        "Colors",
        topLevelShellWidgetClass,
        parent,
        XmNdeleteResponse, XmUNMAP,
        NULL);
    XDC->ColorForm = XtVaCreateManagedWidget(
	"ColorForm",              /* arbitrary widget name */
	xmFormWidgetClass,     /* widget class  */
	XDC->ColorShell,     /* parent widget*/
	NULL);               /* terminate varargs list */
    
    WD_CreateColorMenuBar(XDC->ColorForm, &(XDC->ColorMenu));

    XDC->Frame = XtVaCreateManagedWidget(
	"frame",
	xmFrameWidgetClass,
	XDC->ColorForm,
	XmNshadowType, XmSHADOW_IN,
	XmNtopAttachment, XmATTACH_WIDGET, /* position the area*/
	XmNtopWidget, (XDC->ColorMenu).Bar, /* relativ to the Menu Bar */
	XmNtopOffset, 5,
	XmNleftAttachment, XmATTACH_FORM,	/* fix it to the window */
	XmNleftOffset, 5,
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 5,
	XmNbottomAttachment, XmATTACH_FORM,
	XmNbottomOffset, 5,
	NULL); 
    XDC->ColorArea = XtVaCreateManagedWidget(
	"ColorArea",
	xmDrawingAreaWidgetClass,
	XDC->Frame,
	XmNwidth, 300,
	XmNheight, 300,
	NULL);	
   }

void WD_CreateColorSelect(Widget parent, XDimInfo *XDim)
   {
    XDimWidgets *XDW;
    XDimColorSelect *XDS;
    XmString Mess;
    Dimension width, height;

    XDW = &(XDim->myWidgets);
    XDS = &(XDW->ColorSelect);
    XDS->ColorShell = XtVaCreatePopupShell(
        "ColorSelect",
        topLevelShellWidgetClass,
        parent,
        XmNdeleteResponse, XmUNMAP,
        NULL);
    XDS->ColorForm = XtVaCreateManagedWidget(
	"ColorForm",              /* arbitrary widget name */
	xmFormWidgetClass,     /* widget class  */
	XDS->ColorShell,     /* parent widget*/
	NULL);               /* terminate varargs list */
    XDS->MessageFrame= XtVaCreateManagedWidget(
	"messageFrame",
	xmFrameWidgetClass,
	XDS->ColorForm,
	XmNshadowType, XmSHADOW_ETCHED_OUT,
	XmNtopAttachment, XmATTACH_FORM, /* position the label*/
	XmNleftAttachment, XmATTACH_FORM,	/* fix it to the window */
	XmNrightAttachment, XmATTACH_FORM,
	NULL);
    Mess = XmStringCreateSimple("Select a Color !!!");
    XDS->ColorMessage = XtVaCreateManagedWidget(
	"message",              /* widget name */
	xmLabelWidgetClass,     /* widget class from PushB.h */
	XDS->MessageFrame,                  /* parent widget*/
	XmNlabelString, Mess,
	NULL);
    XmStringFree(Mess);
    XDS->CLabel= XtVaCreateManagedWidget(
	"AvailableColors",
	xmLabelWidgetClass,
	XDS->ColorForm,
	XmNalignment, XmALIGNMENT_BEGINNING,
	XmNtopAttachment, XmATTACH_WIDGET, /* position the label*/
	XmNtopWidget, XDS->MessageFrame,     /* relativ to the Menu Bar */
	XmNtopOffset, 5,
	XmNleftAttachment, XmATTACH_POSITION,	/* fix it to the window */
	XmNleftPosition, 5,
	NULL);
    XDS->Frame = XtVaCreateManagedWidget(
	"frame",
	xmFrameWidgetClass,
	XDS->ColorForm,
	XmNshadowType, XmSHADOW_IN,
	XmNtopAttachment, XmATTACH_WIDGET, /* position the area*/
	XmNtopWidget, XDS->CLabel, /* relativ to the Message Window */
	XmNtopOffset, 5,
	XmNleftAttachment, XmATTACH_FORM,	/* fix it to the window */
	XmNleftOffset, 5,
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 5,
	NULL); 
    XDS->ColorArea = XtVaCreateManagedWidget(
	"ColorArea",
	xmDrawingAreaWidgetClass,
	XDS->Frame,
	XmNwidth, 200,
	XmNheight, 200,
	NULL);	
    XDS->SLabel= XtVaCreateManagedWidget(
	"SelectedColors",
	xmLabelWidgetClass,
	XDS->ColorForm,
	XmNalignment, XmALIGNMENT_BEGINNING,
	XmNtopAttachment, XmATTACH_WIDGET, /* position the label*/
	XmNtopWidget, XDS->Frame,     /* relativ to the Menu Bar */
	XmNtopOffset, 16,
	XmNleftAttachment, XmATTACH_POSITION,	/* fix it to the window */
	XmNleftPosition, 5,
	NULL);
    XDS->SFrame= XtVaCreateManagedWidget(
	"sFrame",
	xmFrameWidgetClass,
	XDS->ColorForm,
	XmNshadowType, XmSHADOW_ETCHED_OUT,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDS->SLabel,		/* relativ to the Message Window */
	XmNleftAttachment, XmATTACH_FORM,	/* fix it to the window */
	XmNleftOffset, 16,
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 16,
	XmNtopOffset, 5,
	NULL);    
    XDS->ColorSArea = XtVaCreateManagedWidget(
	"selectArea",
	xmDrawingAreaWidgetClass,
	XDS->SFrame,
	XmNheight, 32,
	NULL);	
    XDS->cancel = XtVaCreateManagedWidget(
	"CANCEL",              /* widget name */
	xmPushButtonWidgetClass,     /* widget class from PushB.h */
	XDS->ColorForm,                  /* parent widget*/
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 32,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDS->SFrame,	/* relativ to the Select Window */
	XmNtopOffset, 16,
	XmNbottomAttachment, XmATTACH_FORM,
	XmNbottomOffset, 16,
	NULL);
    XtVaGetValues(XDS->cancel,
    	XtNwidth, &width,
    	XtNheight, &height,
    	NULL);
    XDS->ok = XtVaCreateManagedWidget(
	"OK",              /* widget name */
	xmPushButtonWidgetClass,     /* widget class from PushB.h */
	XDS->ColorForm,                  /* parent widget*/
	XmNwidth, width,
	XmNheight, height,
	XmNleftAttachment, XmATTACH_FORM,
	XmNleftOffset, 32,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDS->SFrame,	/* relativ to the Select Window */
	XmNtopOffset, 16,
	XmNbottomAttachment, XmATTACH_FORM,
	XmNbottomOffset, 16,
	NULL);
    XDS->activeCallback = NULL;
    XDS->client_data = NULL;
   }

void WD_CreateColorEdit(Widget parent, XDimInfo *XDim)
   {
    XDimWidgets *XDW;
    XDimColorEdit *XDE;
    XmString Mess;
    Dimension width, height;
    Arg arg;

    XDW = &(XDim->myWidgets);
    XDE = &(XDW->ColorEdit);
    XDE->Shell = XtVaCreatePopupShell(
        "ColorEdit",
        topLevelShellWidgetClass,
        parent,
        XmNdeleteResponse, XmUNMAP,
        NULL);
    XDE->Form = XtVaCreateManagedWidget(
	"ColorForm",              /* arbitrary widget name */
	xmFormWidgetClass,     /* widget class  */
	XDE->Shell,	     /* parent widget*/
	NULL);               /* terminate varargs list */
    XDE->Color1 = XtVaCreateManagedWidget(
	"Color1",              /* widget name */
	xmPushButtonWidgetClass,     /* widget class from PushB.h */
	XDE->Form,                  /* parent widget*/
	XmNwidth, 32,
	XmNheight, 32,
        XmNlabelType, XmPIXMAP,
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 16,
	XmNtopAttachment, XmATTACH_POSITION,	/* position the label*/
	XmNtopPosition,5,
	NULL);
    Mess = XmStringCreateSimple("Start Color:");
    XDE->LabelC1 = XtVaCreateManagedWidget(
	"LabelC1",              /* arbitrary widget name */
	xmLabelWidgetClass,     /* widget class  */
	XDE->Form,	     /* parent widget*/
	XmNlabelString, Mess,
        XmNleftAttachment, XmATTACH_POSITION,
        XmNleftPosition, 5,
	XmNrightAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNrightWidget, XDE->Color1,
	XmNrightOffset, 16,
        XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
        XmNbottomWidget, XDE->Color1,
        XmNbottomOffset, 2,
	NULL);               /* terminate varargs list */
    XmStringFree(Mess);
    XDE->Color2 = XtVaCreateManagedWidget(
	"Color2",              /* widget name */
	xmPushButtonWidgetClass,     /* widget class from PushB.h */
	XDE->Form,                  /* parent widget*/
	XmNwidth, 32,
	XmNheight, 32,
        XmNlabelType, XmPIXMAP,
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 16,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDE->Color1,
	XmNtopOffset,8,
	NULL);
    Mess = XmStringCreateSimple("End Color:");
    XDE->LabelC2 = XtVaCreateManagedWidget(
	"LabelC2",              /* arbitrary widget name */
	xmLabelWidgetClass,     /* widget class  */
	XDE->Form,	     /* parent widget*/
	XmNlabelString, Mess,
        XmNleftAttachment, XmATTACH_POSITION,
        XmNleftPosition, 5,
	XmNrightAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNrightWidget, XDE->Color2,
	XmNrightOffset, 16,
        XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
        XmNbottomWidget, XDE->Color2,
        XmNbottomOffset, 2,
	NULL);               /* terminate varargs list */
    XmStringFree(Mess);
    XDE->Edit = XtVaCreateManagedWidget(
	"Edit",              /* widget name */
	xmTextFieldWidgetClass,     /* widget class from PushB.h */
	XDE->Form,                  /* parent widget*/
	XmNcolumns, 3,
	XmNmaxLength, 3,
        XmNlabelType, XmPIXMAP,
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 16,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDE->Color2,
	XmNtopOffset,8,
	NULL);
    Mess = XmStringCreateSimple("Number of colors:");
    XDE->LabelEdit = XtVaCreateManagedWidget(
	"LabelEdit",              /* arbitrary widget name */
	xmLabelWidgetClass,     /* widget class  */
	XDE->Form,	     /* parent widget*/
	XmNlabelString, Mess,
        XmNleftAttachment, XmATTACH_POSITION,
        XmNleftPosition, 5,
	XmNrightAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNrightWidget, XDE->Edit,
	XmNrightOffset, 16,
        XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
        XmNbottomWidget, XDE->Edit,
        XmNbottomOffset, 2,
	NULL);               /* terminate varargs list */
    XmStringFree(Mess);
    
    XDE->cancel = XtVaCreateManagedWidget(
	"CANCEL",              /* widget name */
	xmPushButtonWidgetClass,     /* widget class from PushB.h */
	XDE->Form,                  /* parent widget*/
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 32,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDE->Edit,	/* relativ to the Select Window */
	XmNtopOffset, 16,
	XmNbottomAttachment, XmATTACH_FORM,
	XmNbottomOffset, 16,
	NULL);
    XtVaGetValues(XDE->cancel,
    	XtNwidth, &width,
    	XtNheight, &height,
    	NULL);

    XDE->ok = XtVaCreateManagedWidget(
	"OK",              /* widget name */
	xmPushButtonWidgetClass,     /* widget class from PushB.h */
	XDE->Form,                  /* parent widget*/
	XmNwidth, width,
	XmNheight, height,
	XmNleftAttachment, XmATTACH_FORM,
	XmNleftOffset, 32,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDE->Edit,		/* relativ to LabelC2 */
	XmNtopOffset, 16,
	XmNbottomAttachment, XmATTACH_FORM,
	XmNbottomOffset, 16,
	NULL);
    XDE->activeCallback = NULL;
    XDE->client_data = NULL;

/* rgb Shell */

    XDE->rgbShell = XmCreateFormDialog(parent, "rgbShell", NULL, 0);
    XDE->rgbForm= XtVaCreateManagedWidget(
	"frame",
	xmFormWidgetClass,
	XDE->rgbShell,
	XmNshadowType, XmSHADOW_ETCHED_IN,
	XmNleftAttachment, XmATTACH_FORM,	/* fix it to the window */
	XmNleftOffset, 8,
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 8,
	XmNtopAttachment, XmATTACH_FORM,	/* position the label*/
	XmNtopOffset, 8,
	NULL);    
    XDE->rgbLabel = XtVaCreateManagedWidget(
	"editRGB",              /* arbitrary widget name */
	xmLabelWidgetClass,     /* widget class  */
	XDE->rgbForm,	     /* parent widget*/
	XmNalignment, XmALIGNMENT_BEGINNING,
        XmNleftAttachment, XmATTACH_POSITION,
        XmNleftPosition, 5,
        XmNtopAttachment, XmATTACH_POSITION,
        XmNtopPosition, 5,
	NULL);               /* terminate varargs list */
    Mess = XmStringCreateSimple("Red");
    XDE->rSlide = XtVaCreateManagedWidget(
	"R",              /* arbitrary widget name */
	xmScaleWidgetClass,     /* widget class  */
	XDE->rgbForm,	     /* parent widget*/
	XmNminimum, 0,
	XmNmaximum, USHRT_MAX,
	XmNshowValue, True,
	XmNtitleString, Mess,
	XmNorientation, XmHORIZONTAL,
        XmNleftAttachment, XmATTACH_POSITION,
        XmNleftPosition, 10,
        XmNrightAttachment, XmATTACH_POSITION,
        XmNrightPosition, 90,
        XmNtopAttachment, XmATTACH_WIDGET,
        XmNtopWidget, XDE->rgbLabel,
        XmNtopOffset, 8,
	NULL);               /* terminate varargs list */
    XmStringFree(Mess);
    Mess = XmStringCreateSimple("Green");
    XDE->gSlide = XtVaCreateManagedWidget(
	"G",              /* arbitrary widget name */
	xmScaleWidgetClass,     /* widget class  */
	XDE->rgbForm,	     /* parent widget*/
	XmNminimum, 0,
	XmNmaximum, USHRT_MAX,
	XmNshowValue, True,
	XmNtitleString, Mess,
	XmNorientation, XmHORIZONTAL,
	XmNscaleWidth, 200,
        XmNleftAttachment, XmATTACH_POSITION,
        XmNleftPosition, 10,
        XmNrightAttachment, XmATTACH_POSITION,
        XmNrightPosition, 90,
        XmNtopAttachment, XmATTACH_WIDGET,
        XmNtopWidget, XDE->rSlide,
	NULL);               /* terminate varargs list */
    XmStringFree(Mess);
    Mess = XmStringCreateSimple("Blue");
    XDE->bSlide = XtVaCreateManagedWidget(
	"B",              /* arbitrary widget name */
	xmScaleWidgetClass,     /* widget class  */
	XDE->rgbForm,	     /* parent widget*/
	XmNminimum, 0,
	XmNmaximum, USHRT_MAX,
	XmNshowValue, True,
	XmNtitleString, Mess,
	XmNorientation, XmHORIZONTAL,
        XmNleftAttachment, XmATTACH_POSITION,
        XmNleftPosition, 10,
        XmNrightAttachment, XmATTACH_POSITION,
        XmNrightPosition, 90,
        XmNtopAttachment, XmATTACH_WIDGET,
        XmNtopWidget, XDE->gSlide,
        XmNbottomAttachment, XmATTACH_POSITION,
        XmNbottomPosition, 95,
	NULL);               /* terminate varargs list */
    XmStringFree(Mess);
    XDE->rgbCancel = XtVaCreateManagedWidget(
	"CANCEL",              /* widget name */
	xmPushButtonWidgetClass,     /* widget class from PushB.h */
	XDE->rgbShell,                  /* parent widget*/
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 32,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDE->rgbForm,
	XmNtopOffset, 16,
	XmNbottomAttachment, XmATTACH_FORM,
	XmNbottomOffset, 16,
	NULL);
    XtVaGetValues(XDE->rgbCancel,
    	XtNwidth, &width,
    	XtNheight, &height,
    	NULL);
    XDE->rgbOk = XtVaCreateManagedWidget(
	"OK",              /* widget name */
	xmPushButtonWidgetClass,     /* widget class from PushB.h */
	XDE->rgbShell,                  /* parent widget*/
	XmNwidth, width,
	XmNheight, height,
	XmNleftAttachment, XmATTACH_FORM,
	XmNleftOffset, 32,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDE->rgbForm,		/* relativ to LabelC2 */
	XmNtopOffset, 16,
	XmNbottomAttachment, XmATTACH_FORM,
	XmNbottomOffset, 16,
	NULL);
    /* Create the color mixing widgets */
#ifdef DEC
    XtSetArg(arg, DXmNcolorModel, DXmColorModelRGB);
    XDE->Mix = DXmCreateColorMixDialog(XDE->Shell, "StartColor", &arg, 1); 
#endif /* DEC */
   }

/*
 * Initiate a Pref save as
 */

void WD_okSaveAs(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    XDimWidgets *XDW;
    XDColorInfo *XDC;
    XmString FName;
    XmStringContext context;
    XmStringDirection dir;
    XmStringCharSet set;
    Boolean sep;
    char *Text;

    XDim = (XDimInfo *) client_data;
    XDW =  &(XDim->myWidgets);
    XDC = &(XDim->colors);
    XtVaGetValues(XDW->FileSelect,
	XmNdirSpec, &FName,
	NULL);
    if(XmStringInitContext(&context, FName))
      {
       if(XmStringGetNextSegment(context, &Text, &set, &dir, &sep))
         {
          strncpy(XDC->pref, Text, MAX_NAME_LENGTH);
          if(!FI_SavePref(XDim))
             XtUnmanageChild(XDW->FileSelect);       
	  else
	     WD_XDimError(XDim, XDW->FileSelect);
         }
       XmStringFreeContext(context);
       XmStringFree(FName);
      }
    
   }

/*
 * Pop up file select box for Pref save as
 */

void WD_PopSaveAs(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    XDimWidgets *XDW;
    XmString Pref,Mess;

    XDim = (XDimInfo *) client_data;
    XDW =  &(XDim->myWidgets);
    Mess = XmStringCreateSimple("Save Preference as:");
    Pref = XmStringCreateSimple("*.prf");
    XtVaSetValues(XDW->FileSelect,
	XmNpattern, Pref,
	XmNselectionLabelString, Mess,
	NULL);
    XmStringFree(Mess);
    XmStringFree(Pref);
    if(XDW->activeFSCallback)
       XtRemoveCallback(XDW->FileSelect, XmNokCallback,
	  XDW->activeFSCallback, XDW->FSclient_data);
    XtAddCallback(XDW->FileSelect, XmNokCallback,
                   WD_okSaveAs, XDim);
    XDW->activeFSCallback = WD_okSaveAs;
    XDW->FSclient_data = XDim;
    XtManageChild(XDW->FileSelect);       
   }

/*
 * save color preferences
 */

void WD_SaveColors(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    XDColorInfo *XDC;

    XDim = (XDimInfo *) client_data;
    XDC =  &(XDim->colors);
    if(*(XDC->pref) == '\0')
       WD_PopSaveAs(w, client_data, call_data);
    else
      {
       if(FI_SavePref(XDim))
	  WD_XDimError(XDim, NULL);
       }
   }

/*
 * Initiate a load preference
 */

void WD_okLoadPref(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    XDimWidgets *XDW;
    XDColorInfo *XDC;
    XmString FName;
    XmStringContext context;
    XmStringDirection dir;
    XmStringCharSet set;
    Boolean sep;
    char *Text;

    XDim = (XDimInfo *) client_data;
    XDW =  &(XDim->myWidgets);
    XDC = &(XDim->colors);
    XtVaGetValues(XDW->FileSelect,
	XmNdirSpec, &FName,
	NULL);
    if(XmStringInitContext(&context, FName))
      {
       if(XmStringGetNextSegment(context, &Text, &set, &dir, &sep))
         {
          strncpy(XDC->pref, Text, MAX_NAME_LENGTH);
          if(!FI_LoadPref(XDim))
             XtUnmanageChild(XDW->FileSelect);
	  else
	     WD_XDimError(XDim, XDW->FileSelect);
	  XT_NotifyPaletteChanged(XDim);
	  WD_SetPrefWidgets(XDim);
         }
       XmStringFreeContext(context);
       XmStringFree(FName);
      }
    
   }

/*
 * Pop up file select box for load
 */

void WD_PopLoadPref(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    XDimWidgets *XDW;
    XmString Pref,Mess;

    XDim = (XDimInfo *) client_data;
    XDW =  &(XDim->myWidgets);
    Mess = XmStringCreateSimple("Load Preference:");
    Pref = XmStringCreateSimple("*.prf");
    XtVaSetValues(XDW->FileSelect,
	XmNpattern, Pref,
	XmNselectionLabelString, Mess,
	NULL);
    XmStringFree(Mess);
    XmStringFree(Pref);
    if(XDW->activeFSCallback)
       XtRemoveCallback(XDW->FileSelect, XmNokCallback,
	  XDW->activeFSCallback, XDW->FSclient_data);
    XtAddCallback(XDW->FileSelect, XmNokCallback,
                   WD_okLoadPref, XDim);
    XDW->activeFSCallback = WD_okLoadPref;
    XDW->FSclient_data = XDim;
    XtManageChild(XDW->FileSelect);       
   }

/*
 * Init all color processing widgets
 */
 
void WD_CreateColors(Widget parent, XDimInfo *XDim)
   {
    XDimWidgets *XDW;
    XDimColorControl *XDC;
    XDimColorSelect *XDS;
    XDimColorEdit *XDE;
    XDimPreferences *XDP;

    XDW = &(XDim->myWidgets);
    XDC = &(XDW->ColorPanel);
    XDS = &(XDW->ColorSelect);
    XDE = &(XDW->ColorEdit);
    XDP = &(XDW->Prefs);
    WD_CreateColorPanel(parent, XDim);
    WD_CreateColorSelect(parent, XDim);
    WD_CreateColorEdit(parent, XDim);
    WD_CreatePrefs(parent, XDim);
    /*
     * Add callbacks that pop up/down color widgets
     * please note, callbacks for the ok-button change
     * so they are not set here !!!!
     */

    /* Color Panel */
    XtAddCallback(XDW->ShowCol, XmNactivateCallback,
		   XT_Popitup, XDC->ColorShell);
    XtAddCallback((XDW->MainMenu).colors, XmNactivateCallback,
		   XT_Popitup, XDC->ColorShell);
    XtAddCallback((XDC->ColorMenu).close, XmNactivateCallback,
                   XT_Popdown, XDC->ColorShell);
    XtAddCallback((XDC->ColorMenu).prefs, XmNactivateCallback,
                   WD_PopLoadPref, XDim);
    XtAddCallback((XDW->MainMenu).pref, XmNactivateCallback,
                   WD_PopLoadPref, XDim);
    XtAddCallback((XDC->ColorMenu).saveAs, XmNactivateCallback,
                   WD_PopSaveAs, XDim);
    XtAddCallback((XDC->ColorMenu).save, XmNactivateCallback,
                   WD_SaveColors, XDim);
    XtAddCallback(XDC->ColorArea, XmNexposeCallback,
		  XT_RedrawColors, XDim);
    XtAddCallback(XDC->ColorArea, XmNresizeCallback,
		  XT_RedrawColors, XDim);

    /* Color Select */
    XtAddCallback((XDC->ColorMenu).edit, XmNactivateCallback,
		   WD_Select2Edit, XDim);
    XtAddCallback((XDC->ColorMenu).delete, XmNactivateCallback,
		   WD_Select2Delete, XDim);
    XtAddCallback(XDS->cancel, XmNactivateCallback,
                   XT_Popdown, XDS->ColorShell);
    XtAddCallback(XDS->ColorArea, XmNexposeCallback,
		  XT_RedrawColors, XDim);
    XtAddCallback(XDS->ColorArea, XmNresizeCallback,
		  XT_RedrawColors, XDim);
    XtAddCallback(XDS->ColorArea, XmNinputCallback,
		  WD_GetColorOrRow, XDim);
    XtAddCallback(XDS->ColorSArea, XmNexposeCallback,
		  XT_RedrawColorRow, XDim);
    XtAddCallback(XDS->ColorSArea, XmNresizeCallback,
		  XT_RedrawColorRow, XDim);

    /* Color Edit */
    XtAddCallback((XDC->ColorMenu).new, XmNactivateCallback,
		   WD_PopNewColor, XDim);
    XtAddCallback(XDE->cancel, XmNactivateCallback,
                   WD_CancelColorEdit, XDim);
    XtAddCallback(XDE->Color1, XmNactivateCallback,
		   WD_ManageColorMix, XDim);
    XtAddCallback(XDE->Color2, XmNactivateCallback,
		   WD_ManageColorMix, XDim);
#ifdef DEC
    XtAddCallback(XDE->Mix, XmNcancelCallback,
		   XT_UnmanageIt, XDE->Mix);
    XtAddCallback(XDE->Mix, XmNapplyCallback,
		   WD_ApplyNewColor, XDim);
    XtAddCallback(XDE->Mix, XmNokCallback,
		   WD_ApplyNewColor, XDim);
#endif /* DEC */
    XtAddCallback(XDE->rgbOk, XmNactivateCallback,
		   WD_ApplyNewColor, XDim);

/* Preferences */

    XtAddCallback((XDC->ColorMenu).Window, XmNactivateCallback,
		   WD_ManageWinPref, XDim);
    XtAddCallback(XDP->winOk, XmNactivateCallback,
                  WD_okWinPref, XDim);
    XtAddCallback((XDC->ColorMenu).Move, XmNactivateCallback,
		   WD_ManageMovPref, XDim);
    XtAddCallback(XDP->movOk, XmNactivateCallback,
                  WD_okMovPref, XDim);
    XtAddCallback((XDC->ColorMenu).Grid, XmNactivateCallback,
		   WD_ManageGridPref, XDim);
    XtAddCallback(XDP->gridOk, XmNactivateCallback,
                  WD_okGridPref, XDim);
    XtAddCallback((XDC->ColorMenu).Misc, XmNactivateCallback,
		   WD_ManageMiscPref, XDim);
    XtAddCallback(XDP->textOk, XmNactivateCallback,
                  WD_okMiscPref, XDim);
/* Help */
    XtAddCallback((XDC->ColorMenu).HelpButton,
	XmNactivateCallback, XT_Popitup, (XDW->Help).prefShell);

   }

/*
 * Redraw link card
 */

void WD_RedrawLink(XDimLink *XDL, ViewportInfo *view, XDimInfo *XDim)
   {
    String title;
    ViewportInfo *Views;
    int Num,from,to;

    Views= XDim->Views;
    Num = view->actLink;
    if(Num == view->links)
      {
       from = XDim->hLink.link1;
       to = XDim->hLink.link2;
       if(to<0)
         XtVaSetValues(XDL->toFile,
	    XmNvalue, "",
	    NULL);
      }
    else
      {
       from = (view->Link1)[Num];
       to = (view->Link2)[Num];
       XtVaSetValues(XDL->fromEdit,
	   XmNvalue, (view->LinkItself)[Num],
	   NULL);
       XtVaSetValues(XDL->toEdit,
	   XmNvalue, (view->LinkName)[Num],
	   NULL);
      }
    if(from>=0 && Views[from].pict != NULL)
      {
       XtVaGetValues((((XDim->myWidgets).Views)[from]).Shell,
	       XmNtitle, &title,
	       NULL);
       XtVaSetValues(XDL->viewEdit,
	 XmNvalue, title,
	 NULL);
      }
    if(to>=0 && Views[to].pict != NULL)
      {
       XtVaGetValues((((XDim->myWidgets).Views)[to]).Shell,
	       XmNtitle, &title,
	       NULL);
       XtVaSetValues(XDL->toFile,
	 XmNvalue, title,
	 NULL);
      }
   }

/*
 * Step one Card up
 */

void WD_LinkStepUp(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    ViewportInfo *view;
    XDimWidgets *XDW;

    XDim = (XDimInfo *) client_data;
    XDW = &(XDim->myWidgets);
    view = &((XDim->Views)[XDim->port]);
    if(view->actLink >0)
      view->actLink--;
    WD_RedrawLink(&(XDW->Link), view, XDim);
   }

/*
 * Step to top Card
 */

void WD_TopLink(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    ViewportInfo *view;
    XDimWidgets *XDW;

    XDim = (XDimInfo *) client_data;
    XDW = &(XDim->myWidgets);
    view = &((XDim->Views)[XDim->port]);
    view->actLink = 0;
    WD_RedrawLink(&(XDW->Link), view, XDim);
   }

/*
 * Step one Card down
 */

void WD_LinkStepDown(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    ViewportInfo *view;
    XDimWidgets *XDW;

    XDim = (XDimInfo *) client_data;
    XDW = &(XDim->myWidgets);
    view = &((XDim->Views)[XDim->port]);
    if(XDim->createLast)
      {
       if(view->actLink < view->links)
	 view->actLink++;
      }
    else
      {
       if(view->actLink < view->links -1)
         view->actLink++;
      }
    WD_RedrawLink(&(XDW->Link), view, XDim);
   }

/*
 * Step to bottom Card
 */

void WD_BottomLink(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    ViewportInfo *view;
    XDimWidgets *XDW;

    XDim = (XDimInfo *) client_data;
    XDW = &(XDim->myWidgets);
    view = &((XDim->Views)[XDim->port]);
    if(XDim->createLast)
       view->actLink = view->links;
    else
       view->actLink = view->links -1;
    WD_RedrawLink(&(XDW->Link), view, XDim);
   }

/*
 * Create the link Window
 */
 
void WD_CreateLink(Widget parent, XDimInfo *XDim)
   {
    XDimLink *XDL;
    XmString Mess;
    Dimension width, height;
    
    XDL = &(XDim->myWidgets).Link;
    XDL->Shell = XmCreateFormDialog(parent, "linkShell", NULL, 0);
    XDL->Form= XtVaCreateManagedWidget(
	"Form",
	xmFormWidgetClass,
	XDL->Shell,
	XmNshadowType, XmSHADOW_ETCHED_IN,
	XmNtopAttachment, XmATTACH_FORM,	/* position the label*/
	XmNtopOffset, 8,
	XmNleftAttachment, XmATTACH_FORM,	/* fix it to the window */
	XmNleftOffset, 8,
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 8,
	NULL);    
    XDL->label = XtVaCreateManagedWidget(
	"linkLabel",              /* arbitrary widget name */
	xmLabelWidgetClass,     /* widget class  */
	XDL->Form,	     /* parent widget*/
        XmNleftAttachment, XmATTACH_POSITION,
        XmNleftPosition, 5,
        XmNrightAttachment, XmATTACH_POSITION,
        XmNrightPosition, 95,
        XmNtopAttachment, XmATTACH_POSITION,
        XmNtopPosition, 5,
	NULL);               /* terminate varargs list */
    XDL->fromEdit = XtVaCreateManagedWidget(
	"fromEdit",              /* widget name */
	xmTextFieldWidgetClass,     /* widget class from PushB.h */
	XDL->Form,                  /* parent widget*/
	XmNcolumns, 16,
	XmNmaxLength, MAX_LINK_LENGTH,
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 16,
        XmNtopAttachment, XmATTACH_WIDGET,
        XmNtopWidget, XDL->label,
        XmNtopOffset, 5,
	NULL);
    Mess = XmStringCreateSimple("Describe FROM (p.ex. real or Bx ...):");
    XDL->fromLabel = XtVaCreateManagedWidget(
	"fromLabel",              /* arbitrary widget name */
	xmLabelWidgetClass,     /* widget class  */
	XDL->Form,	     /* parent widget*/
	XmNalignment, XmALIGNMENT_BEGINNING,
	XmNlabelString, Mess,
        XmNleftAttachment, XmATTACH_POSITION,
        XmNleftPosition, 5,
	XmNrightAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNrightWidget, XDL->fromEdit,
	XmNrightOffset, 16,
        XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
        XmNbottomWidget, XDL->fromEdit,
        XmNbottomOffset, 2,
	NULL);               /* terminate varargs list */
    XmStringFree(Mess);
    XDL->viewEdit = XtVaCreateManagedWidget(
	"linkView",              /* widget name */
	xmTextFieldWidgetClass,     /* widget class from PushB.h */
	XDL->Form,                  /* parent widget*/
	XmNcolumns, 32,
	XmNeditable, False,
	XmNmaxLength, MAX_NAME_LENGTH,
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 16,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDL->fromEdit,
	XmNtopOffset,8,
	NULL);
    Mess = XmStringCreateSimple("FROM File/Window");
    XDL->viewLabel = XtVaCreateManagedWidget(
	"viewLabel",              /* arbitrary widget name */
	xmLabelWidgetClass,     /* widget class  */
	XDL->Form,	     /* parent widget*/
	XmNalignment, XmALIGNMENT_BEGINNING,
	XmNlabelString, Mess,
        XmNleftAttachment, XmATTACH_POSITION,
        XmNleftPosition, 5,
	XmNrightAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNrightWidget, XDL->viewEdit,
	XmNrightOffset, 16,
        XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
        XmNbottomWidget, XDL->viewEdit,
        XmNbottomOffset, 2,
	NULL);               /* terminate varargs list */
    XmStringFree(Mess);
    XDL->toEdit = XtVaCreateManagedWidget(
	"toEdit",              /* widget name */
	xmTextFieldWidgetClass,     /* widget class from PushB.h */
	XDL->Form,                  /* parent widget*/
	XmNcolumns, 16,
	XmNmaxLength, MAX_LINK_LENGTH,
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 16,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDL->viewEdit,
	XmNtopOffset,8,
	NULL);
    Mess = XmStringCreateSimple("Describe TO (p.ex. imag or By ...):");
    XDL->toLabel = XtVaCreateManagedWidget(
	"toLabel",              /* arbitrary widget name */
	xmLabelWidgetClass,     /* widget class  */
	XDL->Form,	     /* parent widget*/
	XmNalignment, XmALIGNMENT_BEGINNING,
	XmNlabelString, Mess,
        XmNleftAttachment, XmATTACH_POSITION,
        XmNleftPosition, 5,
	XmNrightAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNrightWidget, XDL->toEdit,
	XmNrightOffset, 16,
        XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
        XmNbottomWidget, XDL->toEdit,
        XmNbottomOffset, 2,
	NULL);               /* terminate varargs list */
    XmStringFree(Mess);
    XDL->toFile = XtVaCreateManagedWidget(
	"toFile",              /* widget name */
	xmTextFieldWidgetClass,     /* widget class from PushB.h */
	XDL->Form,                  /* parent widget*/
	XmNcolumns, 32,
	XmNeditable, False,
	XmNmaxLength, MAX_NAME_LENGTH,
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 16,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDL->toEdit,
	XmNtopOffset,8,
	NULL);
    Mess = XmStringCreateSimple("Link TO File/Window");
    XDL->fileLabel = XtVaCreateManagedWidget(
	"fileLabel",              /* arbitrary widget name */
	xmLabelWidgetClass,     /* widget class  */
	XDL->Form,	     /* parent widget*/
	XmNalignment, XmALIGNMENT_BEGINNING,
	XmNlabelString, Mess,
        XmNleftAttachment, XmATTACH_POSITION,
        XmNleftPosition, 5,
	XmNrightAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNrightWidget, XDL->toFile,
	XmNrightOffset, 16,
        XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
        XmNbottomWidget, XDL->toFile,
        XmNbottomOffset, 2,
	NULL);               /* terminate varargs list */
    XmStringFree(Mess);
    WD_CreatePushButton(XDL->Form, "TopLink", &(XDL->Top),
		    (char*)ltop_bits, ltop_width, ltop_height);
    XtVaSetValues(XDL->Top,
	XmNleftAttachment, XmATTACH_FORM,
	XmNleftOffset, 32,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDL->toFile,		/* relativ to LabelC2 */
	XmNtopOffset, 16,
	XmNbottomAttachment, XmATTACH_POSITION,
	XmNbottomPosition, 95,
    	NULL);
    WD_CreatePushButton(XDL->Form, "UpLink", &(XDL->Up),
		    (char*)lup_bits, lup_width, lup_height);
    XtVaSetValues(XDL->Up,
	XmNleftAttachment, XmATTACH_WIDGET,
	XmNleftWidget, XDL->Top,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDL->toFile,		/* relativ to LabelC2 */
	XmNtopOffset, 16,
    	NULL);
    WD_CreatePushButton(XDL->Form, "BottomLink", &(XDL->Bottom),
		    (char*)lbottom_bits, lbottom_width, lbottom_height);
    XtVaSetValues(XDL->Bottom,
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 32,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDL->toFile,		/* relativ to LabelC2 */
	XmNtopOffset, 16,
    	NULL);
    WD_CreatePushButton(XDL->Form, "DownLink", &(XDL->Down),
		    (char*)ldown_bits, ldown_width, ldown_height);
    XtVaSetValues(XDL->Down,
	XmNrightAttachment, XmATTACH_WIDGET,
	XmNrightWidget, XDL->Bottom,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDL->toFile,		/* relativ to LabelC2 */
	XmNtopOffset, 16,
    	NULL);
    XDL->toButton = XtVaCreateManagedWidget(
	"linkToWindow",              /* widget name */
	xmPushButtonWidgetClass,     /* widget class from PushB.h */
	XDL->Form,                  /* parent widget*/
	XmNleftAttachment, XmATTACH_WIDGET,
	XmNleftWidget, XDL->Up,
	XmNrightAttachment, XmATTACH_WIDGET,
	XmNrightWidget, XDL->Down,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDL->toFile,
	XmNtopOffset, 16,
	XmNbottomAttachment, XmATTACH_POSITION,
	XmNbottomPosition, 95,
	NULL);
    XDL->Cancel = XtVaCreateManagedWidget(
	"CANCEL",              /* widget name */
	xmPushButtonWidgetClass,     /* widget class from PushB.h */
	XDL->Shell,                  /* parent widget*/
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 32,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDL->Form,
	XmNtopOffset, 16,
	XmNbottomAttachment, XmATTACH_FORM,
	XmNbottomOffset, 16,
	NULL);
    XtVaGetValues(XDL->Cancel,
    	XtNwidth, &width,
    	XtNheight, &height,
    	NULL);
    XDL->Ok = XtVaCreateManagedWidget(
	"OK",              /* widget name */
	xmPushButtonWidgetClass,     /* widget class from PushB.h */
	XDL->Shell,                  /* parent widget*/
	XmNwidth, width,
	XmNheight, height,
	XmNleftAttachment, XmATTACH_FORM,
	XmNleftOffset, 32,
	XmNtopAttachment, XmATTACH_WIDGET,	/* position the label*/
	XmNtopWidget, XDL->Form,		/* relativ to LabelC2 */
	XmNtopOffset, 16,
	XmNbottomAttachment, XmATTACH_FORM,
	XmNbottomOffset, 16,
	NULL);
    XDL->activeCallback = NULL;    
    XtAddCallback(XDL->Top, XmNactivateCallback,
                   WD_TopLink, XDim);
    XtAddCallback(XDL->Up, XmNactivateCallback,
                   WD_LinkStepUp, XDim);
    XtAddCallback(XDL->Bottom, XmNactivateCallback,
                   WD_BottomLink, XDim);
    XtAddCallback(XDL->Down, XmNactivateCallback,
                   WD_LinkStepDown, XDim);
    XtAddCallback(XDL->toButton, XmNactivateCallback,
                   WD_LinkView, XDim);
   }

/*
 * Pop up link card
 */

void WD_PopCreateLink(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    XDimLink *XDL;
    ViewportInfo *view;
    XmString Mess;

    XDim = (XDimInfo *) client_data;
    XDL =  &(XDim->myWidgets).Link;
    view = &((XDim->Views)[XDim->port]);
    XDim->createLast = True;
    if(view->links >= MAX_VIEWPORT_NUMBER)
      {
       strcpy(XDim->error, "Sorry the MAXIMUM Number of Links is reached");
       WD_XDimError(XDim, XDL->Shell);
       return;
      }
    view->actLink = view->links;
    XDim->hLink.link1= XDim->port;
    XDim->hLink.link2 = -1;
    Mess = XmStringCreateSimple("LINK two Datasets:");
    XtVaSetValues(XDL->label,
	XmNlabelString, Mess,
	NULL);
    XmStringFree(Mess);
    Mess = XmStringCreateSimple("Link to Window");
    XtVaSetValues(XDL->toButton,
	XmNlabelString, Mess,
	XmNsensitive, True,
	NULL);
    XmStringFree(Mess);
    XtVaSetValues(XDL->fromEdit,
	XmNeditable, True,
	XmNvalue, "",
	NULL);
    XtVaSetValues(XDL->toEdit,
	XmNeditable, True,
	XmNvalue, "",
	NULL);
    XtVaSetValues(XDL->toFile,
	XmNvalue, "",
	NULL);
    if(XDL->activeCallback)
       XtRemoveCallback(XDL->Ok, XmNactivateCallback,
	  XDL->activeCallback, XDL->client_data);
    XtAddCallback(XDL->Ok, XmNactivateCallback,
                   WD_okCreateLink, XDim);
    XDL->activeCallback = WD_okCreateLink;
    XDL->client_data = XDim;
    WD_RedrawLink(XDL, view, XDim);
    XtManageChild(XDL->Shell);       
   }

/*
 * Pop up show link card
 */

void WD_PopShowLink(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    XDimLink *XDL;
    XmString Mess;
    ViewportInfo *view;

    XDim = (XDimInfo *) client_data;
    XDL =  &(XDim->myWidgets).Link;
    view = &((XDim->Views)[XDim->port]);
    if(view->links <= 0)
      {
       strcpy(XDim->error, "There are no links available for this viewport");
       WD_XDimError(XDim, XDL->Shell);
       return;
      }
    XDim->createLast = False;
    Mess = XmStringCreateSimple("Show LINK's:");
    XtVaSetValues(XDL->label,
	XmNlabelString, Mess,
	NULL);
    XmStringFree(Mess);
    Mess = XmStringCreateSimple("Link to Window");
    XtVaSetValues(XDL->toButton,
	XmNlabelString, Mess,
	XmNsensitive, False,
	NULL);
    XmStringFree(Mess);
    if(XDL->activeCallback)
       XtRemoveCallback(XDL->Ok, XmNactivateCallback,
	  XDL->activeCallback, XDL->client_data);
    XDL->activeCallback = NULL;
    XtVaSetValues(XDL->fromEdit,
	XmNeditable, False,
	NULL);
    XtVaSetValues(XDL->toEdit,
	XmNeditable, False,
	NULL);
    WD_RedrawLink(XDL, view, XDim);
    XtManageChild(XDL->Shell);       
   }

/*
 * Pop up delete link card
 */

void WD_PopDeleteLink(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    XDimLink *XDL;
    XmString Mess;
    ViewportInfo *view;

    XDim = (XDimInfo *) client_data;
    XDL =  &(XDim->myWidgets).Link;
    view = &((XDim->Views)[XDim->port]);
    if(view->links <= 0)
      {
       strcpy(XDim->error, "There are no links available for this viewport");
       WD_XDimError(XDim, XDL->Shell);
       return;
      }
    XDim->createLast = False;
    Mess = XmStringCreateSimple("Delete a LINK:");
    XtVaSetValues(XDL->label,
	XmNlabelString, Mess,
	NULL);
    XmStringFree(Mess);
    Mess = XmStringCreateSimple("Link to Window");
    XtVaSetValues(XDL->toButton,
	XmNlabelString, Mess,
	XmNsensitive, False,
	NULL);
    XmStringFree(Mess);
    if(XDL->activeCallback)
       XtRemoveCallback(XDL->Ok, XmNactivateCallback,
	  XDL->activeCallback, XDL->client_data);
    XtAddCallback(XDL->Ok, XmNactivateCallback,
                   WD_okDeleteLink, XDim);
    XDL->client_data = XDim;
    XDL->activeCallback = WD_okDeleteLink;
    XtVaSetValues(XDL->fromEdit,
	XmNeditable, False,
	NULL);
    XtVaSetValues(XDL->toEdit,
	XmNeditable, False,
	NULL);
    WD_RedrawLink(XDL, view, XDim);
    XtManageChild(XDL->Shell);       
   }

/*
 * Link a viewport
 */

void WD_LinkView(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    XDimLink *XDL;
    XmString Mess;

    XDim = (XDimInfo *) client_data;
    XDL =  &(XDim->myWidgets).Link;
    Mess = XmStringCreateSimple("Point to Window to create LINK");
    XtVaSetValues(XDL->toButton,
	XmNlabelString, Mess,
	XmNsensitive, False,
	NULL);
    XmStringFree(Mess);
    XDim->link2Window = True;
   }

/*
 * Now Create the LINK
 */

void WD_okCreateLink(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    XDimLink *XDL;
    ViewportInfo *view1, *view2;
    char *in, *out;
    int Num, from, to;

    XDim = (XDimInfo *) client_data;
    XDL =  &(XDim->myWidgets).Link;
    view1 = &((XDim->Views)[XDim->port]);
    Num = view1->actLink;
    if(Num == view1->links)
      {
       from = XDim->hLink.link1;
       to = XDim->hLink.link2;
      }
    else
      {
       from = (view1->Link1)[Num];
       to = (view1->Link2)[Num];
      }
    if(to<0)
      {
       sprintf(XDim->error, "No link TO viewport available (Use Link to ... Button)");
       WD_XDimError(XDim, XDL->Shell);
       return;
      }
    view1 = &((XDim->Views)[from]);
    view2 = &((XDim->Views)[to]);
    if(view1->links >= MAX_VIEWPORT_NUMBER ||
       view2->links >= MAX_VIEWPORT_NUMBER)
      {
       strcpy(XDim->error, "Sorry the MAXIMUM Number of Links is reached");
       WD_XDimError(XDim, XDL->Shell);
       return;
      }
    in = XmTextFieldGetString(XDL->fromEdit);
    if(*in=='\0')
      {
       XtFree(in);
       sprintf(XDim->error, "You have to supply a description for FROM");
       WD_XDimError(XDim, XDL->Shell);
       return;
      }
    out = XmTextFieldGetString(XDL->toEdit);
    if(*in=='\0')
      {
       XtFree(in);
       sprintf(XDim->error, "You have to supply a description for TO");
       WD_XDimError(XDim, XDL->Shell);
       return;
      }
    FI_AddLink(from, to, in, out, XDim);
    XtFree(in);
    XtFree(out);
   }


/*
 * Delete the LINK
 */

void WD_okDeleteLink(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    ViewportInfo *view;

    XDim = (XDimInfo *) client_data;
    view = &((XDim->Views)[XDim->port]);
    FI_DeleteLink(view->actLink, view, XDim);
   }

/*
 * set title name on viewport num
 */

void WD_SetTitle(int port, ViewportInfo *parent, String Start, String End,
	XDimInfo *XDim)
   {
    XDimViewport *XDV;
    char name[MAX_NAME_LENGTH];
    String title;
    
    if(port >= 0)
      {
       if(parent != NULL)
         {
          XDV = &((XDim->myWidgets).Views[parent->port]);
	  XtVaGetValues(XDV->Shell,
		  XmNtitle, &title,
		  NULL);
	  sprintf(name, "%s %s %s", Start, title, End);
         }
       else
         sprintf(name, "%s %s", Start, End);
       XDV = &((XDim->myWidgets).Views[port]);
       XtVaSetValues(XDV->Shell,
	       XmNtitle, name,
	       NULL);       
      }
   }

/*
 * Copy a viewport for data manipulation
 */
 
ViewportInfo *WD_CopyViewport(String start, String mid, String end,
	ViewportInfo *view1, ViewportInfo *view2, XDimInfo *XDim)
   {
    ViewportInfo *view3;
    XDimViewport *XDV;
    String title1, title2;
    char new[256];
    int port;

    XDV = &((XDim->myWidgets).Views[view1->port]);
    XtVaGetValues(XDV->Shell,
	    XmNtitle, &title1,
	    NULL);
    if(view2 != NULL)
      {
       XDV = &((XDim->myWidgets).Views[view2->port]);
       XtVaGetValues(XDV->Shell,
	       XmNtitle, &title2,
	       NULL);
       title1 = FI_StripFilename(title1);
       title2 = FI_StripFilename(title2);
      }       
/*
 *  create a new viewport
 */

    port = XDim->port;
    WD_CreateViewport((XDim->myWidgets).NewView, XDim, NULL);
    if(port != XDim->port)
      {
       if(CO_NewData(view1->Width, view1->Height, MY_DOUBLE, XDim))
	 {
	  WD_XDimError(XDim, NULL);
	  XT_DestroyViewport(XDV->Shell,&(XDim->port), NULL); 
	  return(NULL);
	 }
      }
    view3 = &((XDim->Views)[XDim->port]);
    XDV = &((XDim->myWidgets).Views[XDim->port]);

/* set new window title */

    if(view2 == NULL)
      sprintf(new, "%s %s %s", start, title1, end);
    else
      sprintf(new, "%s ...%s %s ...%s %s", start, title1, mid, title2, end);
    XtVaSetValues(XDV->Shell,
	    XmNtitle, new,
	    NULL);       
    strcpy(view3->DimX, view1->DimX);
    strcpy(view3->DimY, view1->DimY);
    strcpy(view3->DimZ, view1->DimZ);
    view3->FactX = view1->FactX;
    view3->FactY = view1->FactY;
    view3->OffX = view1->OffX;
    view3->OffY = view1->OffY;
    return(view3);
   }

/*
 * Readout Matrix Values
 */

void WD_okGetMatrix(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    XDimEditMatrix *XEM;
    Widget *wp;
    int i,j;
    String val;
    Boolean ReEdit;
    double *dp;

    XDim = (XDimInfo *) client_data;
    if(XDim->port >= 0)
      {
       XEM = &((XDim->myWidgets).EditMatrix);
       dp = XEM->Values;
       wp = XEM->Matrix + XEM->Width;
       ReEdit = False;
       val = XmTextFieldGetString(XEM->DivEdit);
       if(!sscanf(val,"%lf",&(XEM->div)) || XEM->div == 0.0)
	 {
	  ReEdit = True;
	  sprintf(XDim->error, "Correct division factor %s !!", val);
	 }
       XtFree(val);
       val = XmTextFieldGetString(XEM->BiasEdit);
       if(!sscanf(val,"%lf",&(XEM->bias)))
	 {
	  ReEdit = True;
	  sprintf(XDim->error, "Correct bias value %s !!", val);
	 }
       XtFree(val);
       if(ReEdit != True)
         {
	  for(i=0; i< XEM->Height; i++)
             {
              /* Ignore Label */
              wp++;
              for(j = 0; j< XEM->Width; j++)
        	 {
		  val = XmTextFieldGetString(*wp);
		  if(!sscanf(val,"%lf",dp))
	            {
	             ReEdit = True;
	             i = XEM->Height;
	             j = XEM->Width;
	             sprintf(XDim->error, "Syntax error near %s !!", val);
	            }
		  dp++;
		  wp++;
		  XtFree(val);
        	 }
              /* Ignore Label */
              wp++;
             }
         }
       if(ReEdit)
         {
          /* Give a chance to correct error */
	  XtManageChild(XEM->Shell);
	  WD_XDimError(XDim, XEM->Shell);
         }
       else
         {
          /* destroy widgets */
	  XtDestroyWidget(XEM->Shell);
	  free(XEM->Matrix);
	  XEM->Matrix = NULL;
	  (XEM->RetFunc)(0, NULL, (void*)XDim);
         }
      }
   }

/*
 * Create a matrix of Text Field Widgets for Editing
 * Width: Width of Matrix, sx: start value for numbering
 * Height: Height of Matrix, sy: start value
 */

int WD_CreateEditMatrix(String Init, String Div, String Bias, int Width,
	int Height, int sx, int sy, XDimInfo *XDim)
   {
    XDimEditMatrix *XEM;
    Dimension bw, bh;
    int ret, del, i, j, size;
    char ind[32];
    
    XEM = &((XDim->myWidgets).EditMatrix);
    ret = FALSE;
    free(XEM->Values);
    free(XEM->Matrix);
    XEM->Values = (double*)malloc(Width*Height*sizeof(double));
    size = (Width+2)*(Height+2)*sizeof(Widget);
    XEM->Matrix = (Widget*)malloc(size);
    if(XEM->Matrix!=NULL && XEM->Values!=NULL)
      {
       XEM->Shell = XmCreateFormDialog((XDim->myWidgets).topLevel,
		"matrixShell", NULL, 0);
       XEM->Cancel = XtVaCreateManagedWidget(
	   "CANCEL",
	   xmPushButtonWidgetClass,
	   XEM->Shell,
	   XmNrightAttachment, XmATTACH_FORM,
	   XmNrightOffset, 32,
	   XmNbottomAttachment, XmATTACH_FORM,
	   XmNbottomOffset, 16,
	   NULL);
       XtVaGetValues(XEM->Cancel,
    	   XtNwidth, &bw,
    	   XtNheight, &bh,
    	   NULL);
       XEM->Ok = XtVaCreateManagedWidget(
	   "OK",
	   xmPushButtonWidgetClass,
	   XEM->Shell,
	   XmNwidth, bw,
	   XmNheight, bh,
	   XmNleftAttachment, XmATTACH_FORM,
	   XmNleftOffset, 32,
	   XmNbottomAttachment, XmATTACH_FORM,
	   XmNbottomOffset, 16,
	   NULL);
       XEM->BiasEdit = XtVaCreateManagedWidget(
	   "BiasEdit",              /* widget name */
	   xmTextFieldWidgetClass,     /* widget class from PushB.h */
	   XEM->Shell,                  /* parent widget*/
	   XmNcolumns, 5,
	   XmNmaxLength, 14,
	   XmNvalue, Bias,
	   XmNrightAttachment, XmATTACH_FORM,
	   XmNrightOffset, 16,
	   XmNbottomAttachment, XmATTACH_WIDGET,
	   XmNbottomWidget, XEM->Cancel,
	   XmNbottomOffset, 8,
	   NULL);
       XEM->DivLabel = XtVaCreateManagedWidget(
	   "Divide",              /* arbitrary widget name */
	   xmLabelWidgetClass,     /* widget class  */
	   XEM->Shell,	     /* parent widget*/
	   XmNalignment, XmALIGNMENT_BEGINNING,
	   XmNleftAttachment, XmATTACH_POSITION,
	   XmNleftPosition, 5,
           XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
           XmNbottomWidget, XEM->BiasEdit,
           XmNbottomOffset, 2,
	   NULL);               /* terminate varargs list */
       XEM->DivEdit = XtVaCreateManagedWidget(
	   "DivEdit",              /* widget name */
	   xmTextFieldWidgetClass,     /* widget class from PushB.h */
	   XEM->Shell,                  /* parent widget*/
	   XmNcolumns, 5,
	   XmNmaxLength, 14,
	   XmNvalue, Div,
	   XmNleftAttachment, XmATTACH_WIDGET,	/* position the label*/
	   XmNleftWidget, XEM->DivLabel,
	   XmNleftOffset, 16,
	   XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
           XmNbottomWidget, XEM->BiasEdit,
	   NULL);
       XEM->BiasLabel = XtVaCreateManagedWidget(
	   "Bias",              /* arbitrary widget name */
	   xmLabelWidgetClass,     /* widget class  */
	   XEM->Shell,	     /* parent widget*/
	   XmNalignment, XmALIGNMENT_END,
	   XmNrightAttachment, XmATTACH_WIDGET,	/* position the label*/
	   XmNrightWidget, XEM->BiasEdit,
	   XmNrightOffset, 16,
	   XmNleftAttachment, XmATTACH_WIDGET,
	   XmNleftWidget, XEM->DivEdit,
	   XmNleftOffset, 32,
           XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
           XmNbottomWidget, XEM->BiasEdit,
           XmNbottomOffset, 2,
	   NULL);               /* terminate varargs list */
       XEM->ScrollW= XtVaCreateManagedWidget(
	   "EditWindow",
	   xmScrolledWindowWidgetClass,
	   XEM->Shell,
	   XmNheight, 200,
	   XmNtopAttachment, XmATTACH_FORM,
	   XmNtopOffset, 8,
	   XmNleftAttachment, XmATTACH_FORM,
	   XmNleftOffset, 8,
	   XmNrightAttachment, XmATTACH_FORM,
	   XmNrightOffset, 8,
	   XmNtopAttachment, XmATTACH_FORM,
	   XmNscrollingPolicy, XmAUTOMATIC,
	   XmNbottomAttachment, XmATTACH_WIDGET,
	   XmNbottomWidget, XEM->BiasEdit,
	   XmNbottomOffset, 8,
	   NULL);    
       XEM->Form= XtVaCreateManagedWidget(
	   "RowColumn",
	   xmRowColumnWidgetClass,
	   XEM->ScrollW,
	   XmNentryAlignment, XmALIGNMENT_CENTER,
	   XmNorientation, XmHORIZONTAL,
	   XmNpacking, XmPACK_COLUMN,
	   XmNnumColumns, (Height+2),
	   NULL);
	/* X-Label line */
       del =0;
       for(i= -1; i<=Width; i++)
          {
           if(i<0)
             strcpy(ind, "Y \\ X");
           else if(i>=Width)
             strcpy(ind, "X \\ Y");
           else
             sprintf(ind, "%d", sx+i);
	   (XEM->Matrix)[del++] = XtVaCreateManagedWidget(
	       ind,
	       xmLabelWidgetClass,
	       XEM->Form,
	       NULL);
          }
	/* Matrix */
       del = Width;
       for(i=0; i<Height; i++)
          {
           /* Y-Label*/
           sprintf(ind, "%d", sy+i);
	   (XEM->Matrix)[del++] = XtVaCreateManagedWidget(
	       ind,
	       xmLabelWidgetClass,
	       XEM->Form,
	       NULL);
	   for(j=0; j<Width; j++)
	      {
	       (XEM->Matrix)[del++] = XtVaCreateManagedWidget(
		   "MF",
		   xmTextFieldWidgetClass,
		   XEM->Form,
		   XmNvalue, Init,
		   XmNcolumns, 4,
		   XmNmaxLength, 14,
		   NULL);
	      }
	   (XEM->Matrix)[del++] = XtVaCreateManagedWidget(
	       ind,
	       xmLabelWidgetClass,
	       XEM->Form,
	       NULL);
          }
	/* X-Label line */
       for(i= -1; i<=Width; i++)
          {
           if(i<0)
             strcpy(ind, "Y \\ X");
           else if(i>=Width)
             strcpy(ind, "X \\ Y");
           else
             sprintf(ind, "%d", sx+i);
	   (XEM->Matrix)[del++] = XtVaCreateManagedWidget(
	       ind,
	       xmLabelWidgetClass,
	       XEM->Form,
	       NULL);
          }
       XEM->Width = Width;
       XEM->Height = Height;

       /* Add callbacks */
       XtAddCallback(XEM->Shell, XmNdestroyCallback,
                XT_DestroyMatrix, (XtPointer)XDim);
       XtAddCallback(XEM->Cancel, XmNactivateCallback,
                XT_DestroyMatrix, (XtPointer)XDim);
       XtAddCallback(XEM->Ok, XmNactivateCallback,
                WD_okGetMatrix, (XtPointer)XDim);

       ret = TRUE;
      }
    if(ret == FALSE)
      {
       free(XEM->Values);
       free(XEM->Matrix);
       XEM->Values = NULL;
       XEM->Matrix = NULL;
      }
    return(ret);
   }
/*
 * Redraw Cut Window
 */

void WD_RedrawCut(double x, double y, ViewportInfo *view, XDimInfo *XDim)
   {
    XDimCut *XCT;
    Widget wx, wy;
    XmString Mess;
    char val[32];

    if(XDim->port >=0)
      {
       XCT = &((XDim->myWidgets).Cut);
       if(view->cut == CUT_END)
         {
          /* update end point and switch to start point */
          wx = XCT->EditX2;
          wy = XCT->EditY2;
	  Mess = XmStringCreateSimple(
		"Point to Viewport to change START point");
	  view->cut = CUT_START;
	 }
       else
         {
          /* update start point and switch to end point */
          wx = XCT->EditX1;
          wy = XCT->EditY1;
	  Mess = XmStringCreateSimple(
		"Point to Viewport to change END point");
	  view->cut = CUT_END;
	 }
       sprintf(val, "%4.2f", x);
       XtVaSetValues(wx,
	   XmNvalue, val,
	   NULL);
       sprintf(val, "%4.2f", y);
       XtVaSetValues(wy,
	   XmNvalue, val,
	   NULL);
       XtVaSetValues(XCT->Label,
	   XmNlabelString, Mess,
	   NULL);
       XmStringFree(Mess);
      }
   }

/*
 * Pop up cut window
 */

void WD_PopCut(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    ViewportInfo *view;
    XDimCut *XCT;

    XDim = (XDimInfo*) client_data;
    if(XDim->port >=0)
      {
       XCT = &((XDim->myWidgets).Cut);
       view = &((XDim->Views)[XDim->port]);
       if(view->actData)
         {
	  view->cut = CUT_END;
	  XtVaSetValues(XCT->EditX1,
	      XmNvalue, "0",
	      NULL);
	  XtVaSetValues(XCT->EditY1,
	      XmNvalue, "0",
	      NULL);
	  WD_RedrawCut((double)(view->Width-1), (double)(view->Height-1),
		view, XDim);
	  if(XtIsManaged(XCT->Shell))
	    XtUnmanageChild(XCT->Shell);
	  XtManageChild(XCT->Shell);
	 }
      }
   }


/*
 * set cut
 */
 
void WD_okCut(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;
    XDimCut *XDC;
    ViewportInfo *view1, *view2;
    double x1, y1, x2, y2;
    int width;
    char nam[MAX_NAME_LENGTH];
    String val;

    XDim = (XDimInfo*) client_data;
    XDC =  &((XDim->myWidgets).Cut);
    if(XDim->port >=0)
      {
       view1 = &((XDim->Views)[XDim->port]);
       if(view1->actData)
         {
	  val = XmTextFieldGetString(XDC->EditX1);
	  sscanf(val, "%le", &x1);
	  XtFree(val);
	  if(x1 < 0.0 || x1 > view1->Width-1)
	    {
	     sprintf(XDim->error, "X Values MUST be 0.0 <= x <= %d",
		view1->Width-1);
	     WD_XDimError(XDim, XDC->Shell);
	     return;
	    }
	  val = XmTextFieldGetString(XDC->EditY1);
	  sscanf(val, "%le", &y1);
	  XtFree(val);
	  if(y1 < 0.0 || y1 > view1->Height-1)
	    {
	     sprintf(XDim->error, "Y Values MUST be 0.0 <= y <= %d",
		view1->Height-1);
	     WD_XDimError(XDim, XDC->Shell);
	     return;
	    }
	  val = XmTextFieldGetString(XDC->EditX2);
	  sscanf(val, "%le", &x2);
	  XtFree(val);
	  if(x2 < 0.0 || x2 > view1->Width-1)
	    {
	     sprintf(XDim->error, "X Values MUST be 0.0 <= x <= %d",
		view1->Width-1);
	     WD_XDimError(XDim, XDC->Shell);
	     return;
	    }
	  val = XmTextFieldGetString(XDC->EditY2);
	  sscanf(val, "%le", &y2);
	  XtFree(val);
	  if(y2 < 0.0 || y2 > view1->Height-1)
	    {
	     sprintf(XDim->error, "Y Values MUST be 0.0 <= y <= %d",
		view1->Height-1);
	     WD_XDimError(XDim, XDC->Shell);
	     return;
	    }
	  sprintf(nam, " from (%4.2f,%4.2f) to (%4.2f,%4.2f)",
		x1, y1, x2, x2);
	  /* allocate a dummy data field */
	  width = view1->Width;
	  view1->Width = 0;
	  view2 = WD_CopyViewport("Cut ", "", nam, view1, NULL, XDim);
	  view1->Width = width;
	  if(view2)
            {
	     view1->cut = VALID_CUT;
	     view2->cut = CUT_WINDOW;
	     view2->x1 = x1;
	     view2->y1 = y1;
	     view2->z1 = CO_Inter(x1, y1, view1);
	     view2->x2 = x2;
	     view2->y2 = y2;
	     view2->z2 = CO_Inter(x2, y2, view1);
	     FI_AddLink(view1->port, view2->port, "CutData", "CutWin", XDim);
	    }
	 }
      }
   }

/*
 * create cut window
 */
 
void WD_CreateCut(Widget parent, XDimInfo *XDim)
   {
    XDimCut *XCT;
    Dimension width, height;

    XCT = &(XDim->myWidgets.Cut);

    /* Create Dialog Shell */

    XCT->Shell = XmCreateFormDialog(parent, "cutShell", NULL, 0);
    XCT->Form= XtVaCreateManagedWidget(
	"frame",
	xmFormWidgetClass,
	XCT->Shell,
	XmNshadowType, XmSHADOW_ETCHED_IN,
	XmNtopAttachment, XmATTACH_FORM,	/* position the label*/
	XmNtopOffset, 8,
	XmNleftAttachment, XmATTACH_FORM,	/* fix it to the window */
	XmNleftOffset, 8,
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 8,
	NULL);    
    XCT->Label = XtVaCreateManagedWidget(
	"Status",
	xmLabelWidgetClass,
	XCT->Form,
	XmNtopAttachment, XmATTACH_FORM, /* position the area*/
	XmNtopOffset,8,
	XmNleftAttachment, XmATTACH_POSITION,	/* fix it to the window */
	XmNleftPosition, 5,
	XmNrightAttachment, XmATTACH_POSITION,
	XmNrightPosition, 95,
	NULL);
    XCT->sep = XtVaCreateManagedWidget(
	"separator",
	xmSeparatorGadgetClass,
	XCT->Form,
	XmNtopAttachment, XmATTACH_WIDGET,
	XmNtopWidget, XCT->Label,
	XmNtopOffset, 8,
	XmNleftAttachment, XmATTACH_FORM,
	XmNrightAttachment, XmATTACH_FORM,
	NULL); 
    XCT->EditY1 = XtVaCreateManagedWidget(
	"ypos",
	xmTextFieldWidgetClass,
	XCT->Form,
	XmNcolumns, 6,
	XmNmaxLength, 10,
	XmNrightAttachment, XmATTACH_POSITION,
	XmNrightPosition, 95,
	XmNtopAttachment, XmATTACH_WIDGET,
	XmNtopWidget, XCT->sep,
	XmNtopOffset,8,
	NULL);
    XCT->LabelP1 = XtVaCreateManagedWidget(
	"X1",
	xmLabelWidgetClass,
	XCT->Form,
	XmNalignment, XmALIGNMENT_END,
	XmNleftAttachment, XmATTACH_POSITION,
	XmNleftPosition, 5,
        XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
        XmNbottomWidget, XCT->EditY1,
        XmNbottomOffset, 2,
	NULL);
    XCT->EditX1 = XtVaCreateManagedWidget(
	"xpos",
	xmTextFieldWidgetClass,
	XCT->Form,
	XmNcolumns, 6,
	XmNmaxLength, 10,
	XmNleftAttachment, XmATTACH_WIDGET,
	XmNleftWidget, XCT->LabelP1,
	XmNleftOffset, 8,
	XmNtopAttachment, XmATTACH_WIDGET,
	XmNtopWidget, XCT->sep,
	XmNtopOffset,8,
	NULL);
    XCT->LabelY1 = XtVaCreateManagedWidget(
	"Y1",
	xmLabelWidgetClass,
	XCT->Form,
	XmNalignment, XmALIGNMENT_END,
	XmNleftAttachment, XmATTACH_WIDGET,
	XmNleftWidget, XCT->EditX1,
	XmNleftOffset, 16,
	XmNrightAttachment, XmATTACH_WIDGET,
	XmNrightWidget, XCT->EditY1,
	XmNrightOffset, 8,
        XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
        XmNbottomWidget, XCT->EditY1,
        XmNbottomOffset, 2,
	NULL);
    XCT->EditY2 = XtVaCreateManagedWidget(
	"ypos",
	xmTextFieldWidgetClass,
	XCT->Form,
	XmNcolumns, 6,
	XmNmaxLength, 10,
	XmNrightAttachment, XmATTACH_POSITION,
	XmNrightPosition, 95,
	XmNtopAttachment, XmATTACH_WIDGET,
	XmNtopWidget, XCT->EditY1,
	XmNtopOffset,8,
	XmNbottomAttachment, XmATTACH_FORM,
	XmNbottomOffset, 8,
	NULL);
    XCT->LabelP2 = XtVaCreateManagedWidget(
	"X2",
	xmLabelWidgetClass,
	XCT->Form,
	XmNalignment, XmALIGNMENT_END,
	XmNleftAttachment, XmATTACH_POSITION,
	XmNleftPosition, 5,
        XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
        XmNbottomWidget, XCT->EditY2,
        XmNbottomOffset, 2,
	NULL);
    XCT->EditX2 = XtVaCreateManagedWidget(
	"xpos",
	xmTextFieldWidgetClass,
	XCT->Form,
	XmNcolumns, 6,
	XmNmaxLength, 10,
	XmNleftAttachment, XmATTACH_WIDGET,
	XmNleftWidget, XCT->LabelP2,
	XmNleftOffset, 8,
	XmNtopAttachment, XmATTACH_WIDGET,
	XmNtopWidget, XCT->EditY1,
	XmNtopOffset,8,
	NULL);
    XCT->LabelY2 = XtVaCreateManagedWidget(
	"Y2",
	xmLabelWidgetClass,
	XCT->Form,
	XmNalignment, XmALIGNMENT_END,
	XmNleftAttachment, XmATTACH_WIDGET,
	XmNleftWidget, XCT->EditX2,
	XmNleftOffset, 16,
	XmNrightAttachment, XmATTACH_WIDGET,
	XmNrightWidget, XCT->EditY2,
	XmNrightOffset, 8,
        XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
        XmNbottomWidget, XCT->EditY2,
        XmNbottomOffset, 2,
	NULL);

    XCT->Cancel = XtVaCreateManagedWidget(
	"CANCEL",
	xmPushButtonWidgetClass,
	XCT->Shell,
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 32,
	XmNtopAttachment, XmATTACH_WIDGET,
	XmNtopWidget, XCT->Form,
	XmNtopOffset, 16,
	XmNbottomAttachment, XmATTACH_FORM,
	XmNbottomOffset, 16,
	NULL);
    XtVaGetValues(XCT->Cancel,
    	XtNwidth, &width,
    	XtNheight, &height,
    	NULL);
    XCT->Ok = XtVaCreateManagedWidget(
	"OK",
	xmPushButtonWidgetClass,
	XCT->Shell,
	XmNwidth, width,
	XmNheight, height,
	XmNleftAttachment, XmATTACH_FORM,
	XmNleftOffset, 32,
	XmNtopAttachment, XmATTACH_WIDGET,
	XmNtopWidget, XCT->Form,
	XmNtopOffset, 16,
	XmNbottomAttachment, XmATTACH_FORM,
	XmNbottomOffset, 16,
	NULL);

/* Add callbacks */

    XtAddCallback(XCT->Ok, XmNactivateCallback,
                  WD_okCut , XDim);
   }

/*
 * store calling widget for help
 */
 
void WD_StoreCaller(Widget w, XtPointer client_data, XtPointer call_data)
   {
    extern XDimInfo XDim;
    XDimHelp *XDH;

    XDH = &(XDim.myWidgets.Help);
    XDH->Caller = (Widget)client_data;
   }

/*
 * close caller
 */
 
void WD_CloseHelp(Widget w, XtPointer client_data, XtPointer call_data)
   {
    XDimInfo *XDim;

    XDim = (XDimInfo*)client_data;
    XtPopdown((XDim->myWidgets).Help.Caller);
   }

 
/*
 * Create Help Window
 */

void WD_CreateHelp(Widget parent, XDimInfo *XDim)
   {
    XDimHelp *XDH;
    XDimWidgets *XDW;

    XDW = &(XDim->myWidgets);
    XDH = &(XDW->Help);

    /*
     * Create Topics Menu
     */
    XDH->topicsMenu = XmCreatePulldownMenu(
	parent,
	"topMenu",
	NULL,
	0);
    /*
     * Create File Menu Items
     */
    XDH->topMain = XtVaCreateManagedWidget(
	"Main",
	xmPushButtonWidgetClass,
	XDH->topicsMenu,
	NULL); 
    XDH->topView = XtVaCreateManagedWidget(
	"Viewports",
	xmPushButtonWidgetClass,
	XDH->topicsMenu,
	NULL); 
    XDH->topPref = XtVaCreateManagedWidget(
	"Preferences",
	xmPushButtonWidgetClass,
	XDH->topicsMenu,
	NULL); 
    XDH->topDeco = XtVaCreateManagedWidget(
	"Decoding",
	xmPushButtonWidgetClass,
	XDH->topicsMenu,
	NULL); 
    XDH->topErrors = XtVaCreateManagedWidget(
	"Errors",
	xmPushButtonWidgetClass,
	XDH->topicsMenu,
	NULL); 
    XDH->sep = XtVaCreateManagedWidget(
	"separator",
	xmSeparatorGadgetClass,
	XDH->topicsMenu,
	NULL); 
    XDH->close = XtVaCreateManagedWidget(
	"Close",
	xmPushButtonWidgetClass,
	XDH->topicsMenu,
	NULL); 

    /*
     * Create main help menu bar
     */

    XDH->mainShell = XtVaCreatePopupShell(
        "Help",
        topLevelShellWidgetClass,
        parent,
        XmNdeleteResponse, XmUNMAP,
        NULL);
    XDH->mainForm = XtVaCreateManagedWidget(
	"helpForm",
	xmFormWidgetClass,
	XDH->mainShell,
	NULL);
    XDH->mainBar = XmCreateMenuBar( XDH->mainForm, "menuBar", NULL, 0);
    XtManageChild(XDH->mainBar);
    XtVaSetValues(XDH->mainBar,
	XmNleftAttachment, XmATTACH_FORM,
	XmNrightAttachment, XmATTACH_FORM,
	NULL);
    XDH->mainScrollW= XtVaCreateManagedWidget(
	"HelpWindow",
	xmScrolledWindowWidgetClass,
	XDH->mainForm,
	XmNwidth, 400,
	XmNheight, 250,
	XmNcolumns, 80,
	XmNrows, 25,
	XmNtopAttachment, XmATTACH_WIDGET,
	XmNtopWidget, XDH->mainBar,
	XmNleftAttachment, XmATTACH_FORM,
	XmNrightAttachment, XmATTACH_FORM,
	XmNscrollingPolicy, XmAUTOMATIC,
	XmNbottomAttachment, XmATTACH_FORM,
	NULL);    
    XDH->mainText= XtVaCreateManagedWidget(
	"mainHelpText",
	xmTextWidgetClass,
	XDH->mainScrollW,
	XmNeditable, False,
	XmNeditMode, XmMULTI_LINE_EDIT,
	XmNvalue, mainHelpText,
	NULL);    
    /*
     * Create the Button
     */
    XDH->mainTopics = XtVaCreateManagedWidget(
	"helpMenu",
	xmCascadeButtonWidgetClass,
	XDH->mainBar,
	NULL);
    /*
     * Create viewport help menu bar
     */

    XDH->viewShell = XtVaCreatePopupShell(
        "Help",
        topLevelShellWidgetClass,
        parent,
        XmNdeleteResponse, XmUNMAP,
        NULL);
    XDH->viewForm = XtVaCreateManagedWidget(
	"helpForm",
	xmFormWidgetClass,
	XDH->viewShell,
	NULL);
    XDH->viewBar = XmCreateMenuBar( XDH->viewForm, "menuBar", NULL, 0);
    XtManageChild(XDH->viewBar);
    XtVaSetValues(XDH->viewBar,
	XmNleftAttachment, XmATTACH_FORM,
	XmNrightAttachment, XmATTACH_FORM,
	NULL);
    XDH->viewScrollW= XtVaCreateManagedWidget(
	"HelpWindow",
	xmScrolledWindowWidgetClass,
	XDH->viewForm,
	XmNwidth, 400,
	XmNheight, 250,
	XmNcolumns, 80,
	XmNrows, 25,
	XmNtopAttachment, XmATTACH_WIDGET,
	XmNtopWidget, XDH->viewBar,
	XmNleftAttachment, XmATTACH_FORM,
	XmNrightAttachment, XmATTACH_FORM,
	XmNscrollingPolicy, XmAUTOMATIC,
	XmNbottomAttachment, XmATTACH_FORM,
	NULL);    
    XDH->viewText= XtVaCreateManagedWidget(
	"viewHelpText",
	xmTextWidgetClass,
	XDH->viewScrollW,
	XmNeditable, False,
	XmNeditMode, XmMULTI_LINE_EDIT,
	XmNvalue, viewportHelpText,
	NULL);    
    /*
     * Create the Button
     */
    XDH->viewTopics = XtVaCreateManagedWidget(
	"helpMenu",
	xmCascadeButtonWidgetClass,
	XDH->viewBar,
	NULL);
    /*
     * Create preference help menu bar
     */

    XDH->prefShell = XtVaCreatePopupShell(
        "Help",
        topLevelShellWidgetClass,
        parent,
        XmNdeleteResponse, XmUNMAP,
        NULL);
    XDH->prefForm = XtVaCreateManagedWidget(
	"helpForm",
	xmFormWidgetClass,
	XDH->prefShell,
	NULL);
    XDH->prefBar = XmCreateMenuBar( XDH->prefForm, "menuBar", NULL, 0);
    XtManageChild(XDH->prefBar);
    XtVaSetValues(XDH->prefBar,
	XmNleftAttachment, XmATTACH_FORM,
	XmNrightAttachment, XmATTACH_FORM,
	NULL);
    XDH->prefScrollW= XtVaCreateManagedWidget(
	"HelpWindow",
	xmScrolledWindowWidgetClass,
	XDH->prefForm,
	XmNwidth, 400,
	XmNheight, 250,
	XmNcolumns, 80,
	XmNrows, 25,
	XmNtopAttachment, XmATTACH_WIDGET,
	XmNtopWidget, XDH->prefBar,
	XmNleftAttachment, XmATTACH_FORM,
	XmNrightAttachment, XmATTACH_FORM,
	XmNscrollingPolicy, XmAUTOMATIC,
	XmNbottomAttachment, XmATTACH_FORM,
	NULL);    
    XDH->prefText= XtVaCreateManagedWidget(
	"prefHelpText",
	xmTextWidgetClass,
	XDH->prefScrollW,
	XmNeditable, False,
	XmNeditMode, XmMULTI_LINE_EDIT,
	XmNvalue, preferenceHelpText,
	NULL);    
    /*
     * Create the Button
     */
    XDH->prefTopics = XtVaCreateManagedWidget(
	"helpMenu",
	xmCascadeButtonWidgetClass,
	XDH->prefBar,
	NULL);
    /*
     * Create decoding help menu bar
     */

    XDH->decoShell = XtVaCreatePopupShell(
        "Help",
        topLevelShellWidgetClass,
        parent,
        XmNdeleteResponse, XmUNMAP,
        NULL);
    XDH->decoForm = XtVaCreateManagedWidget(
	"helpForm",
	xmFormWidgetClass,
	XDH->decoShell,
	NULL);
    XDH->decoBar = XmCreateMenuBar( XDH->decoForm, "menuBar", NULL, 0);
    XtManageChild(XDH->decoBar);
    XtVaSetValues(XDH->decoBar,
	XmNleftAttachment, XmATTACH_FORM,
	XmNrightAttachment, XmATTACH_FORM,
	NULL);
    XDH->decoScrollW= XtVaCreateManagedWidget(
	"HelpWindow",
	xmScrolledWindowWidgetClass,
	XDH->decoForm,
	XmNwidth, 400,
	XmNheight, 250,
	XmNcolumns, 80,
	XmNrows, 25,
	XmNtopAttachment, XmATTACH_WIDGET,
	XmNtopWidget, XDH->decoBar,
	XmNleftAttachment, XmATTACH_FORM,
	XmNrightAttachment, XmATTACH_FORM,
	XmNscrollingPolicy, XmAUTOMATIC,
	XmNbottomAttachment, XmATTACH_FORM,
	NULL);    
    XDH->decoText= XtVaCreateManagedWidget(
	"decoHelpText",
	xmTextWidgetClass,
	XDH->decoScrollW,
	XmNeditable, False,
	XmNeditMode, XmMULTI_LINE_EDIT,
	XmNvalue, decodingHelpText,
	NULL);
    /*
     * Create the Button
     */
    XDH->decoTopics = XtVaCreateManagedWidget(
	"helpMenu",
	xmCascadeButtonWidgetClass,
	XDH->decoBar,
	NULL);

    /*
     * Create error help menu bar
     */

    XDH->errShell = XtVaCreatePopupShell(
        "Help",
        topLevelShellWidgetClass,
        parent,
        XmNdeleteResponse, XmUNMAP,
        NULL);
    XDH->errForm = XtVaCreateManagedWidget(
	"helpForm",
	xmFormWidgetClass,
	XDH->errShell,
	NULL);
    XDH->errBar = XmCreateMenuBar( XDH->errForm, "menuBar", NULL, 0);
    XtManageChild(XDH->errBar);
    XtVaSetValues(XDH->errBar,
	XmNleftAttachment, XmATTACH_FORM,
	XmNrightAttachment, XmATTACH_FORM,
	NULL);
    XDH->errScrollW= XtVaCreateManagedWidget(
	"HelpWindow",
	xmScrolledWindowWidgetClass,
	XDH->errForm,
	XmNwidth, 400,
	XmNheight, 250,
	XmNcolumns, 80,
	XmNrows, 25,
	XmNtopAttachment, XmATTACH_WIDGET,
	XmNtopWidget, XDH->errBar,
	XmNleftAttachment, XmATTACH_FORM,
	XmNrightAttachment, XmATTACH_FORM,
	XmNscrollingPolicy, XmAUTOMATIC,
	XmNbottomAttachment, XmATTACH_FORM,
	NULL);    
    XDH->errText= XtVaCreateManagedWidget(
	"errorHelpText",
	xmTextWidgetClass,
	XDH->errScrollW,
	XmNeditable, False,
	XmNeditMode, XmMULTI_LINE_EDIT,
	XmNvalue, errorHelpText,
	NULL);
    /*
     * Create the Button
     */
    XDH->errTopics = XtVaCreateManagedWidget(
	"helpMenu",
	xmCascadeButtonWidgetClass,
	XDH->errBar,
	NULL);


    /*
     * Specify the menus
     */
    XtVaSetValues(XDH->mainTopics, XmNsubMenuId, XDH->topicsMenu, NULL);
    XtVaSetValues(XDH->viewTopics, XmNsubMenuId, XDH->topicsMenu, NULL);
    XtVaSetValues(XDH->prefTopics, XmNsubMenuId, XDH->topicsMenu, NULL);
    XtVaSetValues(XDH->decoTopics, XmNsubMenuId, XDH->topicsMenu, NULL);
    XtVaSetValues(XDH->errTopics, XmNsubMenuId, XDH->topicsMenu, NULL);
    /*
     * Add callbacks
     */
    XtAddCallback(XDH->close,
	XmNactivateCallback, WD_CloseHelp, XDim);
    XtAddCallback(XDH->mainTopics,
	XmNcascadingCallback, WD_StoreCaller, XDH->mainShell);
    XtAddCallback(XDH->viewTopics,
	XmNcascadingCallback, WD_StoreCaller, XDH->viewShell);
    XtAddCallback(XDH->decoTopics,
	XmNcascadingCallback, WD_StoreCaller, XDH->decoShell);
    XtAddCallback(XDH->prefTopics,
	XmNcascadingCallback, WD_StoreCaller, XDH->prefShell);
    XtAddCallback(XDH->errTopics,
	XmNcascadingCallback, WD_StoreCaller, XDH->errShell);
    XtAddCallback((XDW->MainMenu).HelpButton,
	XmNactivateCallback, XT_Popitup, XDH->mainShell);
    XtAddCallback(XDH->topMain,
	XmNactivateCallback, XT_Popitup, XDH->mainShell);
    XtAddCallback(XDH->topView,
	XmNactivateCallback, XT_Popitup, XDH->viewShell);
    XtAddCallback(XDH->topPref,
	XmNactivateCallback, XT_Popitup, XDH->prefShell);
    XtAddCallback(XDH->topDeco,
	XmNactivateCallback, XT_Popitup, XDH->decoShell);
    XtAddCallback(XDH->topErrors,
	XmNactivateCallback, XT_Popitup, XDH->errShell);
    XtAddCallback(XDW->ErrorBox, XmNhelpCallback,
                   XT_Popitup, XDH->errShell);
   }
