/****************************************************************/
/*								*/
/* xdwidget.h :		Variable declarations depending		*/
/*			on the Widget Set			*/
/*			MOTIF-Version				*/
/*								*/
/*			Design: Walter Benzing 1994		*/
/*			NO RIGHTS RESERVED			*/
/*								*/
/****************************************************************/

#ifndef XDWIDGET_H

#define XDWIDGET_H

typedef struct			/* All Widgets of the XDim Main Menu Bar */
   {
    Widget Bar;			/* Mainwindow Menu Bar */
    Widget FileButton;		/* Button for File Menu */
    Widget FileMenu;
    Widget pref;		/* preferences */
    Widget sep1;
    Widget quit;		/* Menu items */
    Widget SetupButton;		/* setup menu */
    Widget SetupMenu;
    Widget prefs;		/* preferences */
    Widget colors;		/* setup colors */
    Widget FastRedrawButton;	/* fast redraw style */
    Widget NormRedrawButton;	/* normal redraw style */
    Widget useLinks;
    Widget FastMenu;		/* menu for fast redraw */
    Widget NormMenu;		/* menu for normal redraw */
    Widget NLines;		/* show lines */
    Widget NHidden;		/* hidden lines */
    Widget NFilled;		/* triangles filled with color */
    Widget NHFilled;		/* hidden and filled */
    Widget NComFilled;		/* complex filled */
    Widget NComHFilled;		/* complex filled */
    Widget FGrid;		/* show grid only */
    Widget FLines;		/* show lines */
    Widget FHidden;		/* hidden lines */
    Widget FFilled;		/* triangles filled with color */
    Widget FHFilled;		/* hidden and filled */
    Widget HelpButton;		/* Button for Help Menu */
   } XDimMainMenuBar;

typedef struct
   {
    Widget importShell;		/* import shell */
    Widget importForm;		/* frame */
    Widget modeLabel;		/* Label import mode */
    Widget RadioBox;		/* Box for toggle buttons */
    Widget ascii;		/* ascii import */
    Widget gif;			/* gif import */
    Widget jpeg;		/* jpeg import */
    Widget imSep1;
    Widget optionsLabel;	/* Label */
    Widget fillLabel;		/* label for replace value */
    Widget fillEdit;		/* value */
    Widget german;		/* german notation */
    Widget ImportOk;		/* Ok */
    Widget ImportCancel;	/* Cancel */
    Widget exportShell;		/* shell */
    Widget exportForm;		/* frame */
    Widget exMode;		/* Label import mode */
    Widget exBox;		/* Box for toggle buttons */
    Widget exAscii;		/* ascii export */
    Widget exGif;		/* gif export */
    Widget exJpeg;		/* jpeg export */
    Widget exSep1;
    Widget exOptionsText;
    Widget exJpegText;		/* Jpeg options text */
    Widget exJpegField;		/* Jpeg option */
    Widget exAsciiText;		/* Ascii export */
    Widget exGer;
    Widget ExportOk;		/* Ok */
    Widget ExportCancel;	/* Cancel */    
   }XDimImportExport;
   
typedef struct
   {
    Widget PrefMenu;		/* Menu for prereferences */
    Widget Window;		/* Window pref's */
    Widget Grid;		/* Grid pref's */
    Widget Move;		/* Movement pref's */
    Widget DataMenu;		/* Data menu */
    Widget redraw;		/* force normal redraw */
    Widget edit;		/* edit data */
    Widget sep1;
    Widget rangeButton;
    Widget rangeMenu;
    Widget size;
    Widget sep2;
    Widget transButton;
    Widget transMenu;
    Widget castButton;
    Widget castMenu;
    Widget fieldButton;
    Widget fieldMenu;
    Widget filterButton;
    Widget filterMenu;
    Widget complexButton;
    Widget complexMenu;
    Widget rgX;
    Widget rgY;
    Widget rgZ;
    Widget mirrorX;
    Widget mirrorY;
    Widget neg;
    Widget offset;
    Widget scale;
    Widget sep3;
    Widget new;
    Widget abs;
    Widget quad;
    Widget squr;
    Widget x1;
    Widget log;
    Widget log10;
    Widget exp;
    Widget uchr;
    Widget dble;
    Widget add;
    Widget sub;
    Widget mul;
    Widget div;
    Widget cadd;
    Widget csub;
    Widget cmul;
    Widget cdiv;
    Widget cxy;
    Widget cphi;
    Widget fft;
    Widget ifft;
    Widget lpassButton;
    Widget lowpassMenu;
    Widget idealL;
    Widget butWL;
    Widget gaussL;
    Widget oFButton;
    Widget otherFMenu;
    Widget median;
    Widget matrix;
    Widget hipassButton;
    Widget highpassMenu;
    Widget idealH;
    Widget butWH;
    Widget gaussH;
   } XDimViewMenus;
   
typedef struct			/* All Mainwindow Push Buttons */
   {
    Widget PBFrame;		/* Frame for the Pushbuttons*/
    Widget PBRowCol;		/* Window Manager for Mainwindow Push Buttons*/
    Widget RotLeft;		/* rotate left */
    Widget RotRight;		/* rotate left */
    Widget RotUp;		/* rotate up */
    Widget RotDown;		/* rotate down */
    Widget MoveLeft;		/* move left */
    Widget MoveRight;		/* move right */
    Widget MoveUp;		/* move up */
    Widget MoveDown;		/* move down */
    Widget ZoomXYP;		/* zoom xy plus */
    Widget ZoomXYM;		/* zoom xy minus */
    Widget ZoomZP;		/* zoom z plus */
    Widget ZoomZM;		/* zoom z minus */
    Widget sep1;		/* seperator */
    Widget sep2;		/* seperator */
   } XDimMainPushButtons;

typedef struct			/* All Widgets of the XDim Color Menu Bar */
   {
    Widget Bar;			/* Window Menu Bar */
    Widget FileButton;		/* Button for File Menu */
    Widget FileMenu;
    Widget close;		/* Menu items */
    Widget sep1;
    Widget prefs;
    Widget save;
    Widget saveAs;
    Widget EditButton;		/* Button for edit menu */
    Widget EditMenu;
    Widget new;
    Widget edit;
    Widget delete;
    Widget PrefButton;		/* Button for Preferences */
    Widget PrefMenu;
    Widget Window;
    Widget Grid;
    Widget Move;
    Widget Misc;
    Widget HelpButton;		/* Button for Help Menu */
   } XDimColorMenuBar;

typedef struct			/* widgets for preferences */
   {
    Widget winShell;		/* window prefs */
    Widget winForm;
    Widget winSep1;
    Widget winSep2;
    Widget winWidthText;
    Widget winWidthEdit;
    Widget winHeightText;
    Widget winHeightEdit;
    Widget picWidthText;
    Widget picWidthEdit;
    Widget picHeightText;
    Widget picHeightEdit;
    Widget backText;
    Widget backCol;
    Widget winCancel;
    Widget winOk;
    Widget movShell;		/* movement pref's */
    Widget movForm;
    Widget movSep1;
    Widget zoomText;
    Widget zoomEdit;
    Widget delAngleText;
    Widget delAngleEdit;
    Widget deltaText;
    Widget deltaEdit;
    Widget timeIntText;
    Widget timeIntEdit;
    Widget movOk;
    Widget movCancel;
    Widget textShell;		/* text pref's */
    Widget textForm;
    Widget textText;
    Widget textCol;
    Widget fontText;
    Widget fontEdit;
    Widget textSep1;
    Widget decoLabel;
    Widget useInterCol;
    Widget decoStartText;
    Widget decoSCol;
    Widget decoEndText;
    Widget decoECol;
    Widget textOk;
    Widget textCancel;
    Widget gridShell;		/* grid pref*s */
    Widget gridForm;
    Widget drawAxis;
    Widget drawAxisText;
    Widget gridSep3;
    Widget gStepText;
    Widget gStepEdit;
    Widget foreText;
    Widget foreCol;
    Widget gridSep1;
    Widget axisForeText;
    Widget axisForeCol;
    Widget axisBackLabel;
    Widget axisBXText;
    Widget axisBXCol;
    Widget axisBYText;
    Widget axisBYCol;
    Widget axisBZText;
    Widget axisBZCol;
    Widget gridSep2;
    Widget ticsLabel;
    Widget ticsXText;
    Widget ticsXEdit;
    Widget ticsYText;
    Widget ticsYEdit;
    Widget ticsZText;
    Widget ticsZEdit;
    Widget gridOk;
    Widget gridCancel;
    Widget inpShell;
    Widget inpForm;
    Widget inpLabel;
    Widget inpField;
    Widget inpOk;
    Widget inpCancel;
    Widget inp2Shell;
    Widget inp2Form;
    Widget inp2Label1;
    Widget inp2Field1;
    Widget inp2Label2;
    Widget inp2Field2;
    Widget inp2Ok;
    Widget inp2Cancel;
    int castType;
    int castPort;
    Widget castShell;
    Widget castForm;
    Widget castLabel;
    Widget castOk;
    Widget castCancel;
    int range;
    Widget rangeShell;
    Widget rangeForm;
    Widget rgStartLabel;
    Widget rgStartEdit;
    Widget rgEndLabel;
    Widget rgEndEdit;
    Widget rgBaseLabel;
    Widget rgBaseEdit;
    Widget rgDimLabel;
    Widget rgDimEdit;
    Widget rgOk;
    Widget rgCancel;
    Widget sizeShell;
    Widget sizeForm;
    Widget siWidthLabel;
    Widget siWidthEdit;
    Widget siHeightLabel;
    Widget siHeightEdit;
    Widget siModeLabel;
    Widget siInterRadio;
    Widget siInter;
    Widget siSpline;
    Widget siOk;
    Widget siCancel;
    XDimRetFunc RetVal;			/* Input Return function */
    XDimRetFunc Ret2Val;			/* Input Return function */
   } XDimPreferences;


typedef struct			/* Widgets concerning the color panel */
   {
    Widget ColorShell;		/* Shell for color popup */
    Widget ColorForm;		/* Form widget for colors */
    Widget Frame;		/* Frame for Color area */
    Widget ColorArea;		/* Drawing area for colors */
    XDimColorMenuBar ColorMenu;		/* Color menu */
   } XDimColorControl;
   
typedef struct			/* Widgets concerning the color select window */
   {
    Widget ColorShell;		/* Shell for color popup */
    Widget ColorMessage;	/* Label for messages */
    Widget MessageFrame;	/* Message frame */
    Widget ColorForm;		/* Form widget for colors */
    Widget CLabel;		/* Label color area */
    Widget Frame;		/* Frame for the colors */
    Widget ColorArea;		/* Drawing area for colors */
    Widget ok;			/* ok button */
    Widget cancel;		/* cancel button */
    Widget SLabel;		/* Label selected colors */
    Widget SFrame;		/* Frame to show the colors */
    Widget ColorSArea;		/* Drawing area for selected colors */
    XtCallbackProc activeCallback;	/* active callback procedure */
    XtPointer client_data;	/* client_data for call_back */
   } XDimColorSelect;


typedef struct			/* Widgets concerning the position window */
   {
    Widget Shell;		/* Shell for popup */
    Widget Form;		/* Form widget */
    Widget Frame;		/* Frame for the DArea */
    Widget DArea;		/* Drawing area */
    Widget Sep1;		/* separator */
    Widget XLabel;		/* Label X */
    Widget XEdit;		/* Pos. X */
    Widget YLabel;		/* Label X */
    Widget YEdit;		/* Pos. X */
    Widget PosLabel;
    Widget VEdit1;		/* View1 */
    Widget WHLabel1;
    Widget WHEdit1;
    Widget WhereLabel;
    Widget VEdit2;		/* View2 */
    Widget WHLabel2;
    Widget WHEdit2;
    Widget Ok;			/* ok button */
    Widget Cancel;		/* cancel button */
    XDimRetFunc RetFunc;	/* Return function */
   } XDimPosSelect;

typedef struct
   {
    Widget Shell;
    Widget Form;
    Widget Text;
    Widget Sep1;
    Widget Apply;
    Widget Oper1;
    Widget To;
    Widget Oper2;
    Widget Ok;			/* ok button */
    Widget Cancel;		/* cancel button */
    XDimRetFunc RetFunc;	/* Return function */
   } XDimMath;

typedef struct			/* Widgets conxerning the color edit window */
   {
    Widget Shell;		/* Shell for popup */
    Widget Form;		/* Form widget */
    Widget LabelC1;		/* Label for color 1 */
    Widget Color1;		/* Start Color Pushbutton */
    Widget LabelC2;		/* Label for color 2 */
    Widget Color2;		/* End Color Pushbutton */
    Widget LabelEdit;		/* Label for Text Field */
    Widget Edit;		/* Text field for input */
    Widget Mix;			/* Color mixing widget */
    Widget ok;			/* ok button */
    Widget cancel;		/* cancel button */    
    Widget rgbShell;		/* rgb input */
    Widget rgbForm;
    Widget rgbLabel;
    Widget rSlide;
    Widget gSlide;
    Widget bSlide;
    Widget rgbOk;
    Widget rgbCancel;
    XtCallbackProc activeCallback;	/* active callback procedure */
    XtPointer client_data;	/* client_data for call_back */
   } XDimColorEdit;

typedef struct			/* All Widgets of the XDim Main Menu Bar */
   {
    Widget Bar;			/* viewport window Menu Bar */
    Widget FileButton;		/* Button for File Menu */
    Widget FileMenu;
    Widget load;		/* menu file */
    Widget save;
    Widget saveAs;
    Widget import;
    Widget export;
    Widget sep1;
    Widget close;		/* Menu items */
    Widget SetupButton;		/* Button for Setup Menu */
    Widget SetupMenu;
    Widget persp;		/* perspective */
    Widget aspect;		/* Aspect ratio y:x */
    Widget grid;		/* setup grid */
    Widget deco;		/* edit color code */
    Widget prefs;		/* preferences */
    Widget cut;			/* Cut through data */
    Widget LinkButton;		/* cross to link menu*/
    Widget LinkMenu;		/* deal with links */
    Widget createLink;
    Widget showLinks;
    Widget deleteLink;
    Widget DataButton;		/* process data */
    Widget HelpButton;		/* Button for Help Menu */
   } XDimViewMenuBar;

typedef struct			/* widgets for the 3d viewports */
   {
    Widget Shell;		/* container for the other widgets */
    Widget Form;		/* form widget */
    Widget SWindow;		/* scrolled window */
    Widget DArea;		/* drawing area */
    Widget StatFrame;		/* Frame for status */
    Widget ViewStat;		/* Status Line */
    XDimViewMenuBar Menu;	/* menu bar */
   } XDimViewport;

typedef struct			/* All Widgets of the XDim Main Menu Bar */
   {
    Widget Bar;			/* viewport window Menu Bar */
    Widget FileButton;		/* Button for File Menu */
    Widget FileMenu;
    Widget load;		/* decoding vectors */
    Widget save;		/* decoding vectors */
    Widget saveAs;		/* decoding vectors */
    Widget sep1;
    Widget close;		/* Menu items */
    Widget EditButton;		/* Button for Setup Menu */
    Widget EditMenu;
    Widget zoomIn;		/* zoom in color code */
    Widget zoomOut;		/* zoom out color code */
    Widget sep2;
    Widget draw;		/* edit color code */
    Widget reset;		/* reset color code */
    Widget iso;			/* create iso lines */
    Widget histo;		/* histogramm equalisation */
    Widget HelpButton;		/* Button for Help Menu */
   } XDimDecoMenuBar;

typedef struct			/* widgets for editing the decoding vector */
   {
    Widget Shell;		/* container for the other widgets */
    Widget Form;		/* form widget */
    Widget Label;		/* output area */
    Widget LFrame;		/* Frame for output */
    Widget Frame;		/* Frame for zoomed */
    Widget ZLabel;		/* Label for zoomed */
    Widget DZoom;		/* drawing area */
    Widget FZoom;		/* form widget for zoom */
    Widget sep1;		/* separator */
    Widget SZoom;		/* scroll widget for zoom */
    Widget DLabel;		/* Label for deco area */
    Widget DFrame;		/* Frame for draw */
    Widget DArea;		/* drawing area */
    Widget isoShell;		/* shell widget */
    Widget isoForm;		/* form widget for iso window */
    Widget isoSLabel;		/* Label for start height */
    Widget isoSEdit;		/* Edit number */
    Widget isoELabel;		/* Label for end height */
    Widget isoEEdit;		/* Edit number */
    Widget isoNLabel;		/* Label for number of lines */
    Widget isoNEdit;		/* Edit number */
    Widget isoDLabel;		/* Label deco per line */
    Widget isoDEdit;		/* Edit number*/
    Widget isoCLabel;		/* color button */
    Widget isoCol;		/* color button */
    Widget isoOk;		/* ok button */
    Widget isoCancel;		/* cancel button */
    Widget areaShell;		/* shell container*/
    Widget areaForm;		/* form widget */
    Widget areaC1Label;		/* Label color 1 */
    Widget areaC1Col;		/* Button color 1 */
    Widget areaC2Label;		/* Label color 2 */
    Widget areaC2Col;		/* Button color 2 */    
    Widget areaOk;		/* ok button */
    Widget areaCancel;		/* cancel button */
    XDimDecoMenuBar Menu;	/* menu bar */
   } XDimDeco;

typedef struct
   {
    Widget Shell;		/* container for the other widgets */
    Widget ScrollW;		/* Scroll Window widget */
    Widget Frame;		/* frame for container */
    Widget Form;		/* container for matrix */
    int Width;			/* Width of Matrix */
    int Height;			/* Height of Matrix */
    Widget *Matrix;		/* matrix of widgets */
    double *Values;		/* matrix of values */
    Widget DivLabel;		/* Divide by */
    Widget DivEdit;		/* Factor*/
    double div;
    Widget BiasLabel;		/* Bias */
    Widget BiasEdit;		/* Bias Value */
    double bias;
    Widget Ok;			/* ok button */
    Widget Cancel;		/* Cancel Button */
    XDimRetFunc RetFunc;	/* Matrix Return function */
   } XDimEditMatrix;

typedef struct
   {
    Widget Shell;
    Widget Form;
    Widget sep;
    Widget Label;
    Widget LabelP1;		/* Label first point */
    Widget EditX1;		/* X,Y coor */
    Widget LabelY1;		/* Y-Label */
    Widget EditY1;
    Widget LabelP2;		/* Label first point */
    Widget EditX2;		/* X,Y coor */
    Widget LabelY2;		/* Y-Label */
    Widget EditY2;
    Widget Ok;
    Widget Cancel;
   } XDimCut;

typedef struct
   {
    Widget Shell;
    Widget Form;
    Widget label;
    Widget viewLabel;
    Widget viewEdit;
    Widget fromLabel;
    Widget fromEdit;
    Widget toLabel;
    Widget toEdit;
    Widget fileLabel;
    Widget toFile;
    Widget toButton;
    Widget Ok;
    Widget Cancel;
    Widget Top;
    Widget Up;
    Widget Down;
    Widget Bottom;
    XtCallbackProc activeCallback;	/* active callback procedure */
    XtPointer client_data;	/* client_data for call_back */
   } XDimLink;


typedef struct
   {
    Widget mainShell;
    Widget mainForm;
    Widget mainBar;
    Widget mainTopics;
    Widget mainScrollW;
    Widget mainText;
    Widget viewShell;
    Widget viewForm;
    Widget viewBar;
    Widget viewTopics;
    Widget viewScrollW;
    Widget viewText;
    Widget prefShell;
    Widget prefForm;
    Widget prefBar;
    Widget prefTopics;
    Widget prefScrollW;
    Widget prefText;
    Widget errShell;
    Widget errForm;
    Widget errBar;
    Widget errTopics;
    Widget errScrollW;
    Widget errText;
    Widget decoShell;
    Widget decoForm;
    Widget decoBar;
    Widget decoTopics;
    Widget decoScrollW;
    Widget decoText;
    Widget topicsMenu;
    Widget topMain;
    Widget topView;
    Widget topPref;
    Widget topDeco;
    Widget topErrors;
    Widget sep;
    Widget close;
    Widget Caller;
   }XDimHelp;

typedef struct			/* All Widgets of XDim */ 
   {				/* are stored here */
    XtAppContext XDimContext;	/* application context */
    Widget topLevel;		/* the top level widget */
    Widget ErrorBox;		/* Error window */
    Widget ErrorReason;		/* widget that caused the error */
    Widget MainForm;		/* Window Manager Widget for topLevel*/
    XDimMainMenuBar MainMenu;	/* Mainwindow Menu */   
    Widget MessageFrame;	/* Frame for Message Window */
    Widget MainMessage;		/* Messages from XDim */
    Widget FileSelect;		/* the file select box */
    XtCallbackProc activeFSCallback;	/* active callback procedure */
    XtPointer FSclient_data;	/* client_data for call_back */
    Widget DataSelect;		/* the data select box */
    XtCallbackProc activeDTCallback;	/* active callback procedure */
    XtPointer DTclient_data;	/* client_data for call_back */
    XtCallbackProc activeInpCallback;	/* active callback procedure */
    XtPointer Inpclient_data;	/* client_data for call_back */
    XDimMainPushButtons MainButtons;	/* Mainwindow Push Buttons*/
    Widget NewView;		/* Create a new Window */
    Widget ShowCol;		/* Show Colors for editing */
    Widget Button;		/* button to color */
    XDimColorControl ColorPanel;	/* Color definition window */
    XDimColorSelect ColorSelect;	/* Color select window */
    XDimColorEdit ColorEdit;		/* Color edit window */
    XDimLink Link;		/* Link window */
    XDimDeco DecoEdit;			/* Deco edit window */
    XDimPreferences Prefs;	/* preference windows */
    XDimPosSelect Pos;		/* position select */
    XDimMath Math;		/* math */
    XDimImportExport ImEx;	/* import export windows */
    XDimCut Cut;		/* Cut window */
    XDimHelp Help;		/* Help windows */
    XDimViewMenus ViewMenus;	/* Viewport menus independent of viewport */
    XDimViewport Views[MAX_VIEWPORT_NUMBER]; 	/* Viewports */
    XDimEditMatrix EditMatrix;	/* matrix for editing */
   } XDimWidgets;

#endif /*XDWIDGET_H*/
