 /*,  *	xtga - a simple targa file viewer for X11  *  *	Frederick G. Kleinsorge!  *	(kleinsorge@star.enet.dec.com)   *	  *	usage:   *  *		xtga filename [x11 options]   *=  *	This program is a simple hack of the XWIND module from the >  *	POVRAY module in machine/vax.  It provides 24-bit truecolor>  *	output if the depth is 24, and uses the logic from xwind if3  *	the depth is not 24.  It does not do monochrome.   *>  *	Note that this is quick and dirty, the following are little#  *	items that I should fix one day:   *1  *		- This code assumes that a depth of 24-planes 2  *		  means Truecolor.  It should check the visual  *		  type.   *2  *		- The code does not look at the RGB masks, and3  *		  assumes that RED is in the low byte, green is 3  *		  the next byte, and BLUE is the next byte.  It 3  *		  should get the RGB masks from the visual, and 3  *		  use them to build the shift counts and masks.   *5  *		- This code only uses the default visual, it does 8  *		  not look to see if there is a 24-plane non-default
  *		  visual.   *6  *		- The code makes a few assumptions about X11 image9  *		  padding and takes shortcuts.  It all seems to work.   *A  *	For OpenVMS, the code maps the image file as a private section @  *	so that it has immediate access to the entire file in memory.@  *	That makes it fairly quick, since the data is simply paged in
  *	as needed.   *C  *	For non-OpenVMS systems, I have included (and tested) file logic D  *	to read the data.  Of course, I've only compiled this on OpenVMS,7  *	so I have no real idea if it works on a Unix system.   *  *	To build on OpenVMS AXP:   *.  *		cc/stand=vaxc/prefix=all/define=(VMS) xtga  *		link xtga, sys$input/opt    *		name="xtga"   *		ident="X001"$  *		SYS$SHARE:DECW$Xlibshr/SHAREABLE%  *		SYS$SHARE:DECW$Xmlibshr/SHAREABLE '  *		SYS$SHARE:DECW$XtlibshrR5/SHAREABLE   *		^Z  *  *	Header from XWIND.C follows:   *  */   M /****************************************************************************  *                xwind.c * M *  This file contains the XWindows code for the display-as-you-trace feature.  * ' *  from Persistence of Vision Raytracer , *  Copyright 1993 Persistence of Vision TeamL *---------------------------------------------------------------------------I *  NOTICE: This source code file is provided so that users may experiment K *  with enhancements to POV-Ray and to port the software to platforms other J *  than those supported by the POV-Ray Team.  There are strict rules underG *  which you are permitted to use this file.  The rules are in the file D *  named POVLEGAL.DOC which should be distributed with this file. IfL *  POVLEGAL.DOC is not available or for more info please contact the POV-RayM *  Team Coordinator by leaving a message in CompuServe's Graphics Developer's D *  Forum.  The latest version of POV-Ray may be found there as well. * B * This program is based on the popular DKB raytracer version 2.12.3 * DKBTrace was originally written by David K. Buck. I * DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.  * N *****************************************************************************/  P /******************************************************************************/P /*                                                                            */P /* X Windows code for POV-Ray.                                                */P /* Written by Christopher J. Cason.                                           */P /* CIS 100032,1644                                                            */P /* Internet 100032.1644@compuserve.com                                        */P /*                                                                            */P /******************************************************************************/  P /******************************************************************************/P /*                                                                            */P /* Original IBM VGA "colour" output routines for MS/DOS by Aaron A. Collins.  */P /*                                                                            */P /* Converted for X Windows and arbitrary #of colours by Christopher J. Cason. */P /*                                                                            */P /* This will deliver approximate colorings using HSV values for the selection.*/P /* The palette map is divided into 4 parts - upper and lower half generated   */P /* with full and half "value" (intensity), respectively.  These halves are    */P /* further halved by full and half saturation values of each range (pastels). */P /* There are three constant colors, black, white, and grey.  They are used    */P /* when the saturation is low enough that the hue becomes undefined, and which*/P /* one is selected is based on a simple range map of "value".  Usage of the   */P /* palette is accomplished by converting the requested color RGB into an HSV  */P /* value.  If the saturation is too low (< .25) then black, white or grey is  */P /* selected.  If there is enough saturation to consider looking at the hue,   */P /* then the hue range of 1-63 is scaled into one of the 4 palette quadrants   */P /* based on its "value" and "saturation" characteristics.                     */P /*                                                                            */P /******************************************************************************/  
 #ifdef VMS #include <rms.h> #include <secdef.h>  #include <descrip.h> #include <ssdef.h> #include <ctype.h> #endif   #include <stdio.h> #include <unixio.h>  #include <math.h>  #include <x11/xlib.h>  #include <x11/xutil.h> #include <x11/stringdefs.h>  #include <x11/intrinsic.h> #include <x11/shell.h>   #define MIN_COLOURS     128  #define MAX_COLOURS     256   ! #define DEFAULT_FILE   "DATA.TGA"  #define FILENAME_MAX	256  / #define min(x,y)        ((x) < (y) ? (x) : (y)) / #define max(x,y)        ((x) > (y) ? (x) : (y))   P unsigned                gWidth ;                      /* +wxxx                */P unsigned                gHeight ;                     /* +hyyy                */P unsigned                gScreenNumber ;               /* screen number        */P unsigned                nColours ;                    /* colours available    */P unsigned                quarterPalette ;              /* 1/4 of nColours      */P unsigned                CooperationLevel = 5 ;        /* for message loop     */P unsigned                screenWidth ;                 /* of root screen       */P unsigned                screenHeight ;                /* ditto                */P unsigned long           gColours [MAX_COLOURS] ;      /* colour lookup        */> int			gDepth ;                      /* default screen depth */P GC                      gGc ;                         /* graphics context     */P Screen                  *gScreen ;                    /* the X screen         */P XImage                  *gXimage = NULL ;             /* to buffer the trace  */P Widget                  gParent ;                     /* parent widget        */P Widget                  gPopupwindow ;                /* trace displayed here */P Window                  gWindow ;                     /* child of gPopupWin.. */P Display                 *gDisplay ;                   /* X display connection */P Colormap                gColourmap ;                  /* the colourmap        */P XtAppContext            gAppcontext ;                 /* application context  */   typedef struct fileinfo {      int type;    int width;
   int height;      int start_addr;    int end_addr;    unsigned char *current_addr;  
 #ifdef VMS   struct FAB fab;  #else    FILE *image_file; 
   int eof; #endif     int filename_valid;    int file_mapped;   int file_open;'   unsigned char filename[FILENAME_MAX];   
   } FILEINFO;     7 XImage *CreateXImage (Display *display, Visual *visual, F                       unsigned depth, unsigned width, unsigned height) {    unsigned    format ;   unsigned    number_of_bytes ;    XImage      *ximage ;   ,   format = depth == 1 ? XYBitmap : ZPixmap ;  8   ximage = XCreateImage (display, visual, depth, format,K                          0, NULL, width, height, XBitmapPad (display), 0) ;   %   if (ximage == NULL) return (NULL) ;   =   number_of_bytes = ximage->bytes_per_line * ximage->height ; H   if ((ximage->data = malloc (number_of_bytes)) == NULL) return (NULL) ;   return (ximage) ;  }   O XImage *CreateXImageFromWidget (Widget widget, unsigned width, unsigned height)  {    unsigned    depth ;    XImage      *ximage ;    Visual      *visual ;    Display     *display ;  F   XtVaGetValues (widget, XtNdepth, &depth, XtNvisual, &visual, NULL) ;    display = XtDisplay (widget) ;A   ximage = CreateXImage (display, visual, depth, width, height) ;    return (ximage) ;  }   B XImage *MakeImage (Widget widget, unsigned width, unsigned height) {    unsigned              x ;    unsigned              y ; !   XImage                *ximage ;   H   if ((ximage = CreateXImageFromWidget (widget, width, height)) != NULL)   { !     for (x = 0 ; x < width ; x++) $       for (y = 0 ; y < height ; y++)0         XPutPixel (ximage, x, y, gColours [0]) ;   }      return (ximage) ;  }   ) void processExpose (XExposeEvent *expose)  { ;   if (gXimage == NULL || (void *) gWindow == NULL) return ; -   XPutImage (gDisplay, gWindow, gGc, gXimage, "              expose->x, expose->y,"              expose->x, expose->y,-              expose->width, expose->height) ;  }    void eventHandler (void) {    XEvent                event ; 1   static unsigned       cooperationCounter = 10 ;   =   if (CooperationLevel < 10 && --cooperationCounter) return ; .   cooperationCounter = 11 - CooperationLevel ;     if (CooperationLevel > 5)    { +     /* loop until all messages retrieved */ &     while (XtAppPending (gAppcontext))     { ,       XtAppNextEvent (gAppcontext, &event) ;  B       if (event.type == Expose && event.xexpose.window == gWindow)       { (         processExpose (&event.xexpose) ;         return ;       }         XtDispatchEvent (&event) ;     }    }    else   {      /* only process 1 event */#     if (XtAppPending (gAppcontext))      { ,       XtAppNextEvent (gAppcontext, &event) ;B       if (event.type == Expose && event.xexpose.window == gWindow)       { (         processExpose (&event.xexpose) ;         return ;       }         XtDispatchEvent (&event) ;     }    }  }     void destroyProc (Widget widget) {    XDestroyImage (gXimage) ;    XFreeGC (gDisplay, gGc) ;    gPopupwindow = NULL ;  }   m Widget CreatePopupWindow (Widget parent, char *name, unsigned width, unsigned height, void (*destroyProc) ())  {    int         n ;    unsigned    x = 0 ;    unsigned    y = 0 ;    Arg         args [8] ;   Widget      window ;  	   n = 0 ;    if (width < screenWidth)%     x = screenWidth / 2 - width / 2 ;    if (height < screenHeight)'     y = screenHeight / 2 - height / 2 ; .   XtSetArg (args [n], XtNwidth, width) ; n++ ;0   XtSetArg (args [n], XtNheight, height) ; n++ ;&   XtSetArg (args [n], XtNx, x) ; n++ ;&   XtSetArg (args [n], XtNy, y) ; n++ ;Q   window = XtCreatePopupShell (name, topLevelShellWidgetClass, parent, args, n) ; C   XtAddCallback (window, XtNdestroyCallback, destroyProc, window) ;    return (window) ;  }   N void set_palette (unsigned index, unsigned red, unsigned green, unsigned blue) {    XColor      colour ;  #   colour.pixel = gColours [index] ; +   colour.flags = DoRed | DoGreen | DoBlue ; $   colour.red = (65535 * red) / 256 ;&   colour.blue = (65535 * blue) / 256 ;(   colour.green = (65535 * green) / 256 ;/   XStoreColor (gDisplay, gColourmap, &colour) ;  }   W void hsv_to_rgb (double hue, double s, double v, unsigned *r, unsigned *g, unsigned *b)  {    double         i ;   double         f ;   double         p1 ;    double         p2 ;    double         p3 ;    double         xh ;    double         nr ;    double         ng ;    double         nb ;      if (hue == 360.0) hue = 0.0 ;   A   xh = hue / 60.0 ;               /* convert hue to be in 0..6 */ A   i = floor (xh) ;                /* i = greatest integer <= h */ A   f = xh - i ;                    /* f = fractional part of h  */    p1 = v * (1 - s) ;   p2 = v * (1 - (s * f)) ;    p3 = v * (1 - (s * (1 - f))) ;     switch ((int) i)   {      case 0 :          nr = v ;           ng = p3 ;          nb = p1 ;          break ;       case 1 :          nr = p2 ;          ng = v ;           nb = p1 ;          break ;       case 2 :          nr = p1 ;          ng = v ;           nb = p3 ;          break ;       case 3 :          nr = p1 ;          ng = p2 ;          nb = v ;           break ;       case 4 :          nr = p3 ;          ng = p1 ;          nb = v ;           break ;       case 5 :          nr = v ;           ng = p1 ;          nb = p2 ;          break ;  
     default :           nr = ng = nb = 0 ;    }     *r = (unsigned) (nr * 255.0) ;    *g = (unsigned) (ng * 255.0) ;    *b = (unsigned) (nb * 255.0) ; }   U void rgb_to_hsv (unsigned r, unsigned g, unsigned b, double *h, double *s, double *v)  {    double         m ;   double         r1 ;    double         g1 ;    double         b1 ;    double         nr ;    double         ng ;    double         nb ;    double         nh = 0.0 ;    double         ns = 0.0 ;    double         nv ;      nr = (double) r / 255.0 ;    ng = (double) g / 255.0 ;    nb = (double) b / 255.0 ;      nv = max (nr, max (ng, nb)) ;    m = min (nr, min (ng, nb)) ;  %   if (nv != 0.0) ns = (nv - m) / nv ;      if (ns == 0.0)   { (     /* hue undefined if no saturation */     *h = 0.0 ;     *s = 0.0 ;
     *v = nv ;      return ;   }   D   r1 = (nv - nr) / (nv - m) ;     /* distance of color from red   */D   g1 = (nv - ng) / (nv - m) ;     /* distance of color from green */D   b1 = (nv - nb) / (nv - m) ;     /* distance of color from blue  */     if (nv == nr)    {      if (m == ng)       nh = 5.0 + b1 ;      else       nh = 1.0 - g1 ;    }      if (nv == ng)    {      if (m == nb)       nh = 1.0 + r1 ;      else       nh = 3.0 - b1 ;    }      if (nv == nb)    {      if (m == nr)       nh = 3.0 + g1 ;      else       nh = 5.0 - r1 ;    }   E   *h = nh * 60.0 ;                /* return h converted to degrees */    *s = ns ;    *v = nv ;  }    void palette_init (void) {    unsigned    m ;    unsigned    r ;    unsigned    g ;    unsigned    b ;    double         hue ;   double         sat ;   double         val ;  E   for (nColours = MAX_COLOURS ; nColours >= MIN_COLOURS ; nColours--) T     if (XAllocColorCells (gDisplay, gColourmap, False, NULL, 0, gColours, nColours))
       break ;    if (nColours < MIN_COLOURS)    { G     printf ("failed to allocate colour cells needed for display\r\n") ;      exit (1) ;   }   !   quarterPalette = nColours / 4 ;   0   /* for the first quarter of the palette ... */(   for (m = 1 ; m < quarterPalette ; m++)   {      /* normalise to 360 */<     hue = 360.0 * ((double) (m)) / (double) quarterPalette ;,     hsv_to_rgb (hue, 0.5, 0.5, &r, &g, &b) ;     set_palette (m, r, g, b) ;  <     hue = 360.0 * ((double) (m)) / (double) quarterPalette ;,     hsv_to_rgb (hue, 1.0, 0.5, &r, &g, &b) ;/     set_palette (m + quarterPalette, r, g, b) ;   <     hue = 360.0 * ((double) (m)) / (double) quarterPalette ;,     hsv_to_rgb (hue, 0.5, 1.0, &r, &g, &b) ;3     set_palette (m + quarterPalette * 2, r, g, b) ;   <     hue = 360.0 * ((double) (m)) / (double) quarterPalette ;,     hsv_to_rgb (hue, 1.0, 1.0, &r, &g, &b) ;3     set_palette (m + quarterPalette * 3, r, g, b) ;    }   F   set_palette (0, 0, 0, 0) ;                        /* black        */F   set_palette (quarterPalette, 255, 255, 255) ;     /* white        */F   set_palette (quarterPalette * 2, 128, 128, 128) ; /* dark grey    */F   set_palette (quarterPalette * 3, 192, 192, 192) ; /* light grey   */ }   B void display_init (FILEINFO *fin, unsigned width, unsigned height) {    unsigned              n ;    unsigned              y = 0 ;    unsigned              x = 0 ;    unsigned long         white ;    unsigned long         black ; #   Arg                   args [20] ;f  "   gDisplay = XtDisplay (gParent) ;    gScreen = XtScreen (gParent) ;3   gScreenNumber = XScreenNumberOfScreen (gScreen) ; 2   gColourmap = DefaultColormapOfScreen (gScreen) ;+   gDepth = DefaultDepthOfScreen (gScreen) ;u8   screenWidth = DisplayWidth (gDisplay, gScreenNumber) ;:   screenHeight = DisplayHeight (gDisplay, gScreenNumber) ;  0   white = WhitePixel (gDisplay, gScreenNumber) ;0   black = BlackPixel (gDisplay, gScreenNumber) ;  	   n = 0 ;e$   x = screenWidth / 2 - gWidth / 2 ;&   y = screenHeight / 2 - gHeight / 2 ;&   XtSetArg (args [n], XtNx, x) ; n++ ;&   XtSetArg (args [n], XtNy, y) ; n++ ;"   XtSetValues (gParent, args, n) ;     gWidth = width ;   gHeight = height ;Y   gPopupwindow = CreatePopupWindow (gParent, fin->filename, width, height, destroyProc) ;	  "   XtRealizeWidget (gPopupwindow) ;   XtMapWidget (gPopupwindow) ;  k   gWindow = XCreateSimpleWindow (gDisplay, XtWindow (gPopupwindow), 0, 0, width, height, 0, white, black) ; 3   XSetWindowBackground (gDisplay, gWindow, black) ; "   XMapWindow (gDisplay, gWindow) ;.   XtPopup (gPopupwindow, XtGrabNonexclusive) ;     if (gDepth != 24)e     palette_init () ;r  1   gGc = XCreateGC (gDisplay, gWindow, 0L, NULL) ;e5   gXimage = MakeImage (gPopupwindow, width, height) ;e  2   XSelectInput (gDisplay, gWindow, ExposureMask) ; }e t void display_close ()* {    if (gPopupwindow)n$     XtDestroyWidget (gPopupwindow) ; }t e intl close_image_file(image)d   FILEINFO *image;   {y   int status = 0;p     if (image == 0) return FALSE;f  
 #ifdef VMS     if (image->file_mapped)l     {e1       status = sys$deltva(&image->start_addr, 0);=       if (!status & 1)	         {t7 	  printf("Error Unmapping section file %d\n", status);:         }      E       sys$close( &image->fab);     }A     image->file_open = 0;l   image->file_mapped = 0;    image->start_addr = 0;   image->end_addr   = 0;   image->current_addr = 0;   image->type = 0;   #else* #endif     return (TRUE); }    x #ifndef VMS  int  get_byte(image)    FILEINFO *image;     {a
     int data;f  !     if (image->eof) return FALSE;V     else       { '         data = getc(image->image_file);m 	if (data == EOF)- 	  { 	    image->eof = 1; 	    return FALSE; 	  } 	return (data & 0xFF);       }    }i #endif s int open_image_file(image)   FILEINFO *image;   {    int i;  
 #ifdef VMS  
   int status;oG   int addr_base[2], use_P0[2] = {0x200, 0x200};  /* Use a P0 address */t   unsigned char *pbuf;    /*p   *  Open input file.l   *h   */   image->fab = cc$rms_fab;#   image->fab.fab$l_fop = FAB$M_UFO;u#   image->fab.fab$b_fac = FAB$M_GET;O   image->fab.fab$b_rtv = 0xFF;-   image->fab.fab$l_fna = &image->filename[0];a5   image->fab.fab$b_fns = strlen(&image->filename[0]);o&   image->fab.fab$l_dna = DEFAULT_FILE;1   image->fab.fab$b_dns = sizeof DEFAULT_FILE - 1;o  "   status = sys$open( &image->fab);     if (status != RMS$_NORMAL)     {i       lib$signal( status);       return (FALSE);0     }e     image->file_open = 1;     /* L   *  Map the input file as a private section in P0 space, let VMS figure out   *  where.*   *    */?   status = sys$crmpsc( &use_P0,                     /* inadr */*@                        &addr_base,                  /* retadr */@                        0,                           /* acmode */?                        SEC$M_EXPREG | SEC$M_CRF,    /* flags */p@                        0,                           /* gsdnam */?                        0,                           /* ident */ @                        0,                           /* relpag */@                        image->fab.fab$l_stv,          /* chan */@                        0,                           /* pagcnt */=                        0,                           /* vbn */*>                        0xEEEE,                      /* prot */=                        0);                          /* pfc */      if (!(status & 1))     {        lib$signal( status);         close_image_file(image);         return (FALSE);      }      image->file_mapped = 1;   '   image->start_addr     = addr_base[0];n'   image->end_addr       = addr_base[1];l     pbuf = addr_base[0] + 2;    /* '   *  Get file type.  Byte 3 is the type    *    */   image->type = *pbuf++;     pbuf += 9;    /*o!   *  Get x and Y image resolutiono   *    */!   image->width  = *pbuf++ & 0xFF;e3   image->width |= ((*pbuf++ & 0xFF) << 8) & 0xFFFF;   "   image->height  = *pbuf++ & 0xFF;4   image->height |= ((*pbuf++ & 0xFF) << 8) & 0xFFFF;    /*    *  Last 2 bytes of headera   *o   */   pbuf += 2;    /* !   *  Point to first byte of image    *,   */   image->current_addr = pbuf;/   #else   7   image->image_file = fopen(&image->filename[0], "rb");,   image->eof = 0;e     if (!(image->image_file))l     { F       printf("Error opening file %s as input\n", &image->filename[0]);       return (FALSE);r     }t    /*V   *  Skip two bytesh   *u   */   get_byte(image);   get_byte(image);    /*s
   *  Get typee   *f   */    image->type = get_byte(image);    /*    *  Skip the next bytes   *u   */   for (i = 3; i < 12; i += 1)      {a       get_byte(image);     }o    /*v!   *  Get x and Y image resolutioni   *    */)   image->width  = get_byte(image) & 0xFF; ;   image->width |= ((get_byte(image) & 0xFF) << 8) & 0xFFFF;*  *   image->height  = get_byte(image) & 0xFF;<   image->height |= ((get_byte(image) & 0xFF) << 8) & 0xFFFF;    /*<   *  Skip two bytes<   *i   */   get_byte(image);   get_byte(image);   #endif     if (image->type != 2)e     {of       printf("%s is not a type 2 targa file, found %d at byte 3\n", &image->filename[0], image->type);       close_image_file(image);       return 0;>     }f  2   if ((image->width == 0) || (image->height == 0))     {f|       printf("%s has a bad image size.  Found width = %d, height = %d\n", &image->filename[0], image->width, image->height);       close_image_file(image);       return 0;      }      return (TRUE); }    int display_image(image)   FILEINFO *image;   {    int x, y; /   unsigned int pixel, red, green, blue, colour;n   double         h ;   double         s ;   double         v ;  $   if (gPopupwindow == NULL) return ;     if (gDepth == 24)      {c       unsigned int *pImage;n.       pImage = (unsigned int *) gXimage->data;  ,       for (y = 0; y < image->height; y += 1)	         {t/           for (x = 0; x < image->width; x += 1) 
             { 
 #ifdef VMS4               pixel  = *image->current_addr++ << 16;3               pixel |= *image->current_addr++ << 8; .               pixel |= *image->current_addr++; #elsel-               pixel  = get_byte(image) << 16; ,               pixel |= get_byte(image) << 8;'               pixel |= get_byte(image);  #endif                *pImage++ = pixel;
             } M           XPutImage (gDisplay, gWindow, gGc, gXimage, 0, y, 0, y, gWidth, 1);            eventHandler(); 	         }e     }    else     {*       unsigned char *pImage;  ,       for (y = 0; y < image->height; y += 1)	         { A           pImage = gXimage->data + (gXimage->bytes_per_line * y);   /           for (x = 0; x < image->width; x += 1) 
             { 
 #ifdef VMS-               blue  = *image->current_addr++; -               green = *image->current_addr++;s-               red   = *image->current_addr++;l #else;&               blue  = get_byte(image);&               green = get_byte(image);&               red   = get_byte(image); #endif9               rgb_to_hsv (red, green, blue, &h, &s, &v) ;                  if (s < 0.20)d                 {r+                   if (v < 0.25) colour = 0;V<                   else if (v > 0.8) colour = quarterPalette;2 		  else if (v > 0.5) colour = quarterPalette * 3;3                   else colour = quarterPalette * 2;N 		}A 	      elseI 		{O> 		  colour = (unsigned) ((double) quarterPalette * h / 360.0);  A 		  if (colour == 0) colour = 1; /* avoid black, white or grey */i9 		  if (colour > quarterPalette) colour = quarterPalette;y  X 		  if (v > 0.50) colour += quarterPalette * 2; /* colours 128-255 for high intensity */  M 		  if (s > 0.50)                    /* more than half saturated ?         */LM 		  colour += quarterPalette ;       /* colour range 64-128 or 192-255     */U   		} $ 	      *pImage++ = gColours[colour];
             }-M           XPutImage (gDisplay, gWindow, gGc, gXimage, 0, y, 0, y, gWidth, 1);L4           eventHandler(); /* Handle any exposures */	         }t     }t }d ," int main (int argc, char *argv []) {    unsigned              n;+   int                   count = 0, status ; #   Arg                   args [20] ;e   FILEINFO 		image;e  4   strncpy (image.filename, argv [1], FILENAME_MAX) ;  	   n = 0 ;e:   XtSetArg (args [n], XtNmappedWhenManaged, False) ; n++ ;9   XtSetArg (args [n], XtNallowShellResize, False) ; n++ ;g+   XtSetArg (args [n], XtNwidth, 10) ; n++ ;i,   XtSetArg (args [n], XtNheight, 10) ; n++ ;  a   gParent = XtAppInitialize (&gAppcontext, image.filename, NULL, 0, &argc, argv, NULL, args, n) ;(  )   if (!open_image_file(&image)) return 0;o  3   display_init (&image, image.width, image.height);i   display_image (&image);e     close_image_file(&image);;    /* '   *  Just spin handling exposure eventse   *o   */   while (1) eventHandler();f     return 0;L   }(