"  #module scan$dwci "VAX SCAN V1.2"     /*   **++ *  **		 1996, Digital Equipment Corporation  **   **	Ident T1.2-002  **   **  FACILITY:  **   **      VAX SCAN   **   **  ABSTRACT:  ** G  **      A component of the DecWindows Compiler Interface for VAX SCAN, <  **	scan$dwci specifies how the command line is to be built.  ** 
  **  AUTHORS:   **   **      Sharon Walker  **   ** #  **  CREATION DATE:     22-NOV-1988   **   **  MODIFICATION HISTORY:  ** 9  **  1.2-003 - Dennis Periquet, 15-JAN-1990: (155 SCAN D) *  **	      Change ident from T1.2-1 to V1.2  ** 7  **  1.2-002 - Sharon Walker, 06-NOV-1989: (146 SCAN D)   **	      Change ident  ** 6  **  1.2-001 - Sharon Walker, 20-JUN-1989 (137 SCAN D)G  **	      Add code for /ANALYSIS_DATA qualifier, and remove .LIS, .ANA, :  **	      and .DIA if the user does not specify a filename  **--   **/      #include <dwci$src:scan$dwci.h>     extern void dwci$dialog();   extern int DwciGetToggle();  extern int DwciGetNumeric();   extern int DwciGetString();  extern int DwciGetSelected();   #define max_command_length	1024     #define	    FALSE   0  #define	    TRUE    1   )  int	    value, toggle_flag, string_flag; +  char	    *tog, *string, *prefix, *postfix;   static char *cmd = 0;   !  static int build_dcl_command ();      G  /********************************************************************/    /* Utility routines						    */G  /********************************************************************/    "  void add_to_command( new_string )  char *new_string;  {#      cmd = strcat(cmd, new_string);   }   ;  void toggle_to_indep_qual(find_str, success_str, fail_str)   char *find_str;  char *success_str;   char *fail_str;  {D      /* evaluates the toggle find_str to produce a value in a	    */"      /* qualifier list						    */   F      if ( !DwciDisabled(find_str) && DwciGetToggle(find_str, &value) )      {  	if (value)"  	    add_to_command(success_str);  	else    	    add_to_command(fail_str);       }  }   :  void toggle_to_qual_list(find_str, success_str, fail_str)  char *find_str;  char *success_str;   char *fail_str;  {A      /* evaluates the toggle find_str to produce a command	    */       /* qualifier						    */    M      if ( ( !DwciDisabled(find_str)) && ( DwciGetToggle(find_str, &value) ) )       {  	add_to_command(prefix);   	prefix = ",";   	if (value)"  	    add_to_command(success_str);  	else  	    add_to_command(fail_str);       }  }   H  void togglestring_to_indep_qual(dwci_text_eval, find_str, success_str,   				fail_str, default_str)   int (*dwci_text_eval)();   char *find_str;  char *success_str;   char *fail_str;  char *default_str;   {E      /* evaluates the toggle_with_file_name or toggle_with_text or	*/ F      /* toggle_with_numeric find_str to produce a command qualifier	*/   !      if (!DwciDisabled(find_str))       {0  	toggle_flag = DwciGetToggle(find_str, &value);5  	string_flag = (*dwci_text_eval)(find_str, &string); #  	if ( toggle_flag || string_flag )   	{   	    if (value)  	    {   		add_to_command(success_str);    5  		/* If string is only blanks and spaces, DWCI will  (  		** signal an error before calling us.  		*/       		if ( strcmp(string, "") != 0 ,  		    && strcmp(string, default_str) != 0 )  		{  		    add_to_command("=");   		    add_to_command(string);  		}  	    }   	    else if (toggle_flag)   		add_to_command(fail_str);  	}       }  }     "  void build_listing_options_part()  {G      /****************************************************************/ #      /* Listing Options						    */ G      /****************************************************************/       /*								    */       /* .      /* list - Toggle with File Name				    */      /*								    */ A      togglestring_to_indep_qual(DwciGetString, "list", " /LIST",    			       " /NOLIST", ".LIS");    G      /*--------------------------------------------------------------*/ ;      /* Here starts the code for 'Show in listing'.		    */ G      /*--------------------------------------------------------------*/          /*								    */ $      /* show - Toggle Box					    */      /*								    */ <      if (!DwciDisabled("show") && DwciGetToggleBox("show") )      {  	prefix = "/SHOW=(";   	postfix = ")";2  	toggle_to_qual_list("show_include", " INCLUDE",   					      " NOINCLUDE");0  	toggle_to_qual_list("show_source", " SOURCE",   					     " NOSOURCE");8  	toggle_to_qual_list("show_statistics", " STATISTICS",   						 " NOSTATISTICS"); 7  	toggle_to_qual_list("show_data", " DATA", " NODATA");      	/*								*/A  	/* Close the /SHOW command options list if anything is in it	*/   	/*								*/  	if (strlen(prefix) < 2)   	    add_to_command(postfix);  	postfix = "";      	/*								    */:  	/* machine_code - Toggle within Toggle Box show			    */  	/*								    */H  	toggle_to_indep_qual("show_machine_code", " /MACHINE", " /NOMACHINE");      }  }       void build_tool_options_part()   {G      /****************************************************************/       /* Tools							    */G      /****************************************************************/          /*								    */ 6      /* analysis_data - Toggle with File Name			    */      /*								    */ @      togglestring_to_indep_qual(DwciGetString, "analysis_data", ;  			       " /ANALYSIS_DATA", " /NOANALYSIS_DATA", ".ANA");          /*								    */ 4      /* diagnostics - Toggle with File Name			    */      /*								    */ O      togglestring_to_indep_qual(DwciGetString, "diagnostics", " /DIAGNOSTICS",  %  					    " /NODIAGNOSTICS", ".DIA");   }     "  void build_codegen_options_part()  {G      /****************************************************************/ &      /* Object Code Options					    */G      /****************************************************************/          /*								    */ 0      /* object - Toggle with File Name				    */      /*								    */ E      togglestring_to_indep_qual(DwciGetString, "object", " /OBJECT",  !  			       " /NOOBJECT", ".OBJ");             /*								    */ %      /* debug - Toggle Box					    */       /*								    */ =      if (!DwciDisabled("debug") && DwciGetToggleBox("debug"))       {  	prefix = " /DEBUG=(";   	postfix = ")";7  	toggle_to_qual_list("debug_traceback", " TRACEBACK",    						 " NOTRACEBACK");A  	toggle_to_qual_list("debug_symbols", " SYMBOLS", " NOSYMBOLS");      	/*							    */ 3  	/* Close the /DEBUG command options list.		    */   	/*							    */   	add_to_command(postfix);  	postfix = "";       }         /*								    */ $      /* optimize - Toggle					    */      /*								    */ D      toggle_to_indep_qual("optimize", " /OPTIMIZE", " /NOOPTIMIZE");         /*								    */ $      /* warnings - Toggle					    */      /*								    */ D      toggle_to_indep_qual("warnings", " /WARNINGS", " /NOWARNINGS");         /*								    */ 3      /* 	error_limit - Toggle with numeric			    */       /*								    */ ?      togglestring_to_indep_qual(DwciGetNumeric, "error_limit",  3  			       " /ERROR_LIMIT", " /NOERROR_LIMIT", "");   }     .  static int build_dcl_command (char **command)  {         /*								    */ )      /* Allocate comand buffer					    */       /*								    */       if (cmd == 0)-          cmd = calloc(1, max_command_length); 	      else   	*cmd = 0;          /*								    */        /* Compile verb						    */      /*								    */       add_to_command("SCAN ");    "      build_listing_options_part();#      build_tool_options_part();     "      build_codegen_options_part();         /*								    */ @      /* Return command line and signal success if command	    */"      /* isn't too long						    */      /*								    */       *command = cmd;*      if (strlen(cmd) > max_command_length)
  	return (0); 	      else 
  	return (1);   };         main(argc, argv)   unsigned int argc; 
  char **argv;   {
      int rtn; @      dwci$dialog (argc, argv, &dwci_module, build_dcl_command );  }