/*
**++
**  FACILITY:
**	CACHE_LOGGER
**
**  ABSTRACT:
**      Shareable log file routines :
**      OPEN_LOG_FILE(), CLOSE_LOG_FILE(), WRITE_LOG_FILE( MESSAGE ).
**
**  AUTHOR:
**      Bill Teahan, University of Waikato, Hamilton, New Zealand
**
**  COPYRIGHT:
**      Copyright  1991
**
**  MODIFICATION HISTORY:
**	V6.1b9	17-Aug-1994     Mark Martinec   mark.martinec@ijs.si
**	  - code cleanup to make it compile under gcc 2.6.0 with full
**	    warnings reporting turned on - with no or very few harmless warnings
**	V6.1b9	17-Sep-1994     Mark Martinec   mark.martinec@ijs.si
**	  - code cleanup to preserve the read-only nature of string literals
**	    (strategically placed 'const' attribute to string parameters)
**/

#ifdef __GNUC__
#include <gnu_hacks.h>
#define variant_union	volatile union
#define variant_struct	volatile struct
#endif

#ifndef NAKED_INCLUDES
#define NAKED_INCLUDES 0
#endif

#if NAKED_INCLUDES

#include jpidef
#include prvdef
#include descrip
#include starlet

#else	/*!NAKED_INCLUDES*/

#include <jpidef.h>
#include <prvdef.h>
#include <descrip.h>
#include <starlet.h>
#endif

#include "logfab.h"
#include "lograb.h"

typedef struct {
    short itm_w_buflen;
    short itm_w_code;
    char *itm_t_bufadr;
    char *itm_t_retlen;
} ITEM_TYPE;

#ifdef __GNUC__

typedef struct FAB FAB_t;
typedef struct RAB RAB_t;
typedef char logbuf_t[2048];

FAB_t logfab         /* log file fab */
  __asm("_$$PsectAttributes_GLOBALSYMBOL$$" "logfab") = {0,};
RAB_t lograb         /* log file rab */
  __asm("_$$PsectAttributes_GLOBALSYMBOL$$" "lograb") = {0,};
logbuf_t logbuf      /* log message buffer */
  __asm("_$$PsectAttributes_GLOBALSYMBOL$$" "logbuf") = {0,};

#else

globaldef{"logrms"} noshare struct FAB logfab;          /* log file fab */
globaldef{"logrms"} noshare struct RAB lograb;          /* log file rab */
globaldef{"logrms"} noshare char logbuf[2048];          /* log message buffer */

#endif

/*
 *  Global LOGGER routines
 *
 */

static int log_file_open = 0;	/* Global flag to indicate if file is open */

int open_log_file(filename)
  const char *filename;
{
  char *fnamep;
  char fname[128];

  if (!log_file_open) {
    log_file_open = 0;

    fnamep = fname;
    while ( (*fnamep++ = *filename++) );
    fnamep--;
    logfab.fab$b_bid = FAB$C_BID;
    logfab.fab$b_bln = FAB$C_BLN;
    logfab.fab$b_rfm = FAB$C_VAR;
#ifdef __GNUC__
    logfab.fab$r_fac_overlay.fab$b_fac = FAB$M_PUT;
    logfab.fab$r_fop_overlay.fab$l_fop = FAB$M_CIF;
    logfab.fab$r_rat_overlay.fab$b_rat = FAB$M_CR;
    logfab.fab$r_org_overlay.fab$b_org = FAB$C_SEQ;
    logfab.fab$r_shr_overlay.fab$b_shr = FAB$M_SHRDEL | FAB$M_SHRGET | FAB$M_SHRPUT | FAB$M_SHRUPD;
#else
    logfab.fab$b_fac = FAB$M_PUT;
    logfab.fab$l_fop = FAB$M_CIF;
    logfab.fab$b_rat = FAB$M_CR;
    logfab.fab$b_org = FAB$C_SEQ;
    logfab.fab$b_shr = FAB$M_SHRDEL | FAB$M_SHRGET | FAB$M_SHRPUT | FAB$M_SHRUPD;
#endif
    logfab.fab$l_fna = fname;
    logfab.fab$b_fns = fnamep - fname;
    logfab.fab$w_deq = 256;
   
    sys$create(&logfab);
  }
  return(1);
}

int write_log_file(message)
  const char *message;
{
  char *log;
  char *time;
  char asctim[25];
  int asctim_len;
  $DESCRIPTOR( asctim_dsc, asctim );

  static int write_init = 0;

  if (!write_init) {
    write_init = 1;

    /* Set up RAB for log file */
    lograb.rab$b_bid = RAB$C_BID;
    lograb.rab$b_bln = RAB$C_BLN;
    lograb.rab$l_fab = &logfab;
#ifdef __GNUC__
    lograb.rab$r_rop_overlay.rab$l_rop = RAB$M_EOF;	/* Append to file */
#else
    lograb.rab$l_rop = RAB$M_EOF;	/* Append to file */
#endif
    lograb.rab$l_rbf = lograb.rab$l_ubf = (char *) &logbuf;
    lograb.rab$w_rsz = lograb.rab$w_usz = sizeof logbuf;
  
    if (!(sys$connect(&lograb) & 1)) {
      sys$close(&logfab);
      return(0);
    }
  }
  sys$asctim( &asctim_len, &asctim_dsc, 0, 0 );
  asctim[20] = '\0';
  log = logbuf;
  time = asctim;

  /* copy username, account name & message to record output buffer */
  while (*time)  *log++ = *time++;
  *log++ = ' ';
  while (*message)  *log++ = *message++;
  lograb.rab$w_rsz = log - logbuf;
  return( sys$put(&lograb));
}

int close_log_file(void)
{
  log_file_open = 0;
  return( sys$close(&logfab));
}
