/*
**++
**  FACILITY:
**      CACHEDEFINE.H
**
**  ABSTRACT:
**      Common CACHE constant definitions.
**
**  AUTHOR:
**      Bill Teahan, University of Waikato, Hamilton, New Zealand
**
**  COPYRIGHT:
**      Copyright  1991
**--
**/

#define CACHE_ID_LENGTH	60	/* Size of Id string */
#define CACHE_HASH_SIZE	16384	/* Number of hash slots */
#define CACHE_IDS_SIZE	8192	/* Number of Ids in CACHE */
#define CACHE_FILENAME "NEWS_ROOT:NEWS.CACHE"
#define CACHE_LOG_FILENAME "NEWS_MANAGER:NEWS_CACHE.LOG"
#define CACHE_LOGNAME "NEWS_CACHE"
#define CACHE_SECTION_NAME "NEWS_CACHE"
#define CACHE_LOCKNAME "NEWS_CACHE_LOCK"

static int cache_status;
#define cache_signal(s) (((cache_status = (s)) & 1) ? (1) : (lib$signal(cache_status),0) )

/*
 * cache map file: record structure
 */

typedef char CACHE_ID[CACHE_ID_LENGTH];   /* id */

typedef struct {
    unsigned short cache_fptr;	    /* forward pointer in list */
    unsigned short cache_bptr;	    /* backward pointer in list */
    unsigned short cache_hval;	    /* truncated hashed value */
				    /* also index into cache_hash_list array */
    unsigned int cache_hvalue;	    /* full hashed value */
    CACHE_ID cache_id;		    /* id, the string being cached */
    } CACHE_IDS;

/* member alignment is required to assure atomic volatile access */
#ifdef __DECC
#pragma member_alignment save
#pragma member_alignment
#endif
typedef volatile struct {
    unsigned int cache_cid;	    /* current position in id ring buffer */
    unsigned short cache_hash_list[CACHE_HASH_SIZE];	/* hash linked lists */
    CACHE_IDS cache_ids[CACHE_IDS_SIZE];		/* id ring buffer */
    /* index 0 is not used as index 0 means null pointer */
    unsigned int cache_found;    /* number of ids already in cache */
    unsigned int cache_lost;     /* number of ids not found in cache */
    int cache_zero_date[2];      /* date cache last zeroed */
    int cache_reset_date[2];     /* date counters last zeroed */
    int cache_lock_check;	 /* double check on locking */
    } CACHE;
#ifdef __DECC
#pragma member_alignment restore
#endif
