/*
**++
**  FACILITY:
**      NEWGRPFILE
**
**  ABSTRACT:
**      This is a standalone image which performs a record-by-record copy of
**	the news group indexed file while obeying all RMS interlocks.
**
**	The program attempts to gain exclusive access to the file by taking
**	out the relevant system lock, or failing that by opening up a stop
**	file. This is an attempt to gain exclusive access to the file for the
**	duration of the record copy operation. Even if exclusive access is
**	not obtained, the program will press on and do the copy after waiting
**	for a maximum of 20 minutes for everyone to shut down.
**
**  AUTHOR:
**      Geoff Huston
**
**  COPYRIGHT:
**      Copyright  1990
**
**  Modification History:
**	6.1b7	15-Jun-1993	Charles Bailey  bailey@genetics.upenn.edu
**	  - set record size in grprab to NEWS_GRPFIL_RSZ, not sizeof newsgrp,
**	    since newsgrp struct contains volatile data not needed in file
**      6.1b8   12-Oct-1993     Charles Lane    lane@duphy4.physics.drexel.edu
**        - clear NEWS_M_NEWSKIP flag while processing group entry
**	V6.1b9	17-Aug-1994     Mark Martinec   mark.martinec@ijs.si
**	  - code cleanup to make it compile under gcc 2.6.0 with full
**	    warnings reporting turned on - with no or very few harmless warnings
**	V6.1b9	17-Sep-1994     Mark Martinec   mark.martinec@ijs.si
**	  - code cleanup to preserve the read-only nature of string literals
**	    (strategically placed 'const' attribute to string parameters)
**--
*/

#ifdef vaxc
#module NEWGRPFILE "V6.1"
#endif

#define _NEWGRPFILE_C
#define _NNTPINCLUDE_H

#include "newsinclude.h"
#include "newsextern.h"

#if NOGLOBALREF
void newscmd() {}
#else
globaldef int newscmd;
#endif


int main(void)
{
  int status, incount = 0, outcount = 0;
  char prgfname[256];
  struct FAB grpfab, grpfab_1;
  struct RAB grprab, grprab_1;
  struct XABKEY xabkey_1, xabkey_2;
  struct XABPRO xabpro_1;
  GRP newsgrp;

  if (!((status = acquire_exclusive_lock(20*60)) & 1)) {
    printf("Unable to acquire Exclusive Access to the News System:\n%s\n",
	    strerror(EVMSERR, status));
    printf("Continuing . . .\n");
    }
  grpfab = cc$rms_fab;
  grpfab.fab$b_fac = FAB$M_GET ;
  grpfab.fab$l_fna = (char *) GRP_FILENAME;
  grpfab.fab$b_fns = strlen(grpfab.fab$l_fna);
  grpfab.fab$b_shr = FAB$M_SHRDEL | FAB$M_SHRGET | FAB$M_SHRPUT | FAB$M_SHRUPD;

  grprab = cc$rms_rab;
  grprab.rab$l_fab = &grpfab;
  grprab.rab$l_ubf = (char *) &newsgrp;
  grprab.rab$w_usz = NEWS_GRPFIL_RSZ;
  grprab.rab$l_rbf = (char *) &newsgrp;
  grprab.rab$w_rsz = NEWS_GRPFIL_RSZ;

  if (!((status = sys$open(&grpfab)) & 1)) exit(status);
  if (!((status = sys$connect(&grprab)) & 1)) exit(status);

  grpfab_1 = cc$rms_fab;
  grpfab_1.fab$l_alq = 7*grpfab.fab$l_alq/8;	/* use 87$ of original allocation */
  grpfab_1.fab$b_bks = 3;
  grpfab_1.fab$w_deq = grpfab.fab$l_alq/16;	/* and a 12% extension size */
  grpfab_1.fab$b_fac = FAB$M_PUT ;
  grpfab_1.fab$l_fna = (char *) "NEWS_ROOT:NEWS.GROUPS_WRK";
  grpfab_1.fab$b_fns = strlen(grpfab_1.fab$l_fna);
  grpfab_1.fab$l_fop = FAB$M_CIF | FAB$M_CTG;
  grpfab_1.fab$w_mrs = NEWS_GRPFIL_RSZ;
  grpfab_1.fab$b_org = FAB$C_IDX;
  grpfab_1.fab$b_rat = FAB$M_CR;
  grpfab_1.fab$b_rfm = FAB$C_FIX;
  grpfab_1.fab$b_shr = FAB$M_SHRDEL | FAB$M_SHRGET | FAB$M_SHRPUT | FAB$M_SHRUPD;
  grpfab_1.fab$l_xab = (char *) &xabkey_1;

  xabkey_1 = cc$rms_xabkey;
  xabkey_1.xab$b_dtp = XAB$C_STG;
  xabkey_1.xab$b_flg = 0;
  xabkey_1.xab$w_pos0 = (char *) &newsgrp.grp_name - (char *) &newsgrp;
  xabkey_1.xab$b_ref = 0;
  xabkey_1.xab$b_siz0 = SUBJLEN;
  xabkey_1.xab$l_nxt = (char *) &xabkey_2;

  xabkey_2 = cc$rms_xabkey;
  xabkey_2.xab$b_dtp = XAB$C_BN4;
  xabkey_2.xab$b_flg = 0;
  xabkey_2.xab$w_pos0 = (char *) &newsgrp.grp_num - (char *) &newsgrp;
  xabkey_2.xab$b_ref = 1;
  xabkey_2.xab$b_siz0 = 4;
  xabkey_2.xab$l_nxt = (char *) &xabpro_1;

  xabpro_1 = cc$rms_xabpro;
  xabpro_1.xab$w_pro = 0xEE00;

  grprab_1 = cc$rms_rab;
  grprab_1.rab$l_fab = &grpfab_1;
  grprab_1.rab$b_krf = 0;
  grprab_1.rab$b_ksz = SUBJLEN;
  grprab_1.rab$l_ubf = (char *) &newsgrp;
  grprab_1.rab$w_usz = NEWS_GRPFIL_RSZ;
  grprab_1.rab$l_rbf = (char *) &newsgrp;
  grprab_1.rab$w_rsz = NEWS_GRPFIL_RSZ;

  if (!((status = sys$create(&grpfab_1)) & 1)) {
    printf("Cannot create %s with %ld contiguous blocks - using best try\n",
      grpfab_1.fab$l_fna,grpfab_1.fab$l_alq);
    grpfab_1.fab$l_fop &= ~FAB$M_CTG;
    grpfab_1.fab$l_fop |= FAB$M_CBT;
    if (!((status = sys$create(&grpfab_1)) & 1)) exit(status);
    }
  if (!((status = sys$connect(&grprab_1)) & 1)) exit(status);

  grprab.rab$l_rop = RAB$M_WAT;
  grprab.rab$b_rac = RAB$C_SEQ;
  grprab.rab$b_krf = 0;
  grprab.rab$b_ksz = SUBJLEN;

  grprab_1.rab$l_rop = RAB$M_WAT;
  grprab_1.rab$b_rac = RAB$C_SEQ;
  grprab_1.rab$b_krf = 0;
  grprab_1.rab$b_ksz = SUBJLEN;

  if (!((status = sys$rewind(&grprab)) & 1)) exit(status);

  printf("\n");
  for (;;) {
    if ((status = sys$get(&grprab)) == RMS$_EOF) {
      printf("End of file reached, %d records read, %d records written\n",incount, outcount);
      _c$cks(sys$close(&grpfab));
      _c$cks(sys$close(&grpfab_1));
      printf("Renaming newly created NEWS_ROOT:NEWS.GROUPS_WRK to NEWS.GROUPS");
      rename("NEWS_ROOT:NEWS.GROUPS_WRK", GRP_FILENAME);
      strcpy(prgfname,GRP_FILENAME);
      strcat(prgfname,";-1");
      while (!delete(prgfname));
      exit(1);
      }
    else if (!(status & 1)) {
      printf("ERROR FROM RMS - code returned was %X\n", status);
      printf("Group file copy terminated before Input EOF\n");
      printf("      %d records read, %d records written to NEWS_ROOT:NEWS.GROUPS_WRK\n",incount, outcount);
      exit(status);
      }
    printf("\t%s (#%d)\n",newsgrp.grp_name,newsgrp.grp_num);
    newsgrp.grp_flags &= ~NEWS_M_NEWSKIP;
    ++incount;
    if ((status = sys$put(&grprab_1)) & 1) ++outcount;
    else printf("\n$PUT call error: %X\n",status);
    }
}
#if defined(__DECC)
/*
 * All these symbols show up as undefined on DECC (both on AXP and VAX)
 * when building nntp stuff.  They are never actually used, as far as I know,
 * so this kludge gets rid of the error messages.
 */
int 	all_loaded ;
int 	auto_cre_grp ;
int 	brdcst_col ;
int 	brdcst_line ;
int 	broadcast_trapping_requested ;
int 	closing_files ;
int 	cmd ;
int 	cmd_dsc ;
int 	cmd_len ;
int 	confirm_specified ;
int 	on_error ;
int 	curr_class ;
int 	curr_g ;
int 	curr_i ;
int 	cur_dir_type ;
int 	c_head ;
int 	devcol ;
int 	devrow ;
int 	display_stk ;
int 	display_unseen_items ;
int 	display_unseen_stack ;
int 	d_itm ;
int 	editor ;
int 	env ;
int 	envdisp ;
int 	err_oline ;
int 	err_oline_d ;
int 	extract_file ;
int 	fast_loading ;
int 	first_retr_call ;
int 	first_time_user ;
int 	forward_posting ;
int 	fp ;
int 	fpa ;
int 	fpa_open ;
int 	fpd ;
int 	fpd_open ;
int 	fp_open ;
int 	ga ;
int 	ga_malloc ;
int 	ga_size ;
int 	gmt_offset ;
int 	grpfab ;
int 	grprab ;
int 	grp_display_size ;
int 	grp_header_vd ;
int 	grp_paste ;
int 	grp_vd ;
int 	gv_size ;
int 	g_arrow ;
int 	include_all_groups ;
int 	initial_classname ;
int 	init_scanning ;
int 	itmfab ;
int 	itmptr ;
int 	itmrab ;
int 	itm_approved ;
int 	itm_fname ;
int 	itm_header_vd ;
int 	keytab ;
int 	kid ;
int 	line_editing ;
int 	mailfile_open ;
int 	mail_add_expiry ;
int 	mail_editor ;
int 	mail_file ;
int 	mail_flags ;
int 	mail_form ;
int 	mail_queue ;
int 	mail_self_flag ;
int 	mail_sig ;
int 	mem_reserve ;
int 	minfromlen ;
int 	mk_head ;
int 	m_head ;
int 	net_news ;
int 	newsgrp ;
int 	newsitm ;
int 	newsmgr_dir ;
int 	newsrc ;
int 	news_captive ;
int 	news_context ;
int 	news_lock_alarm ;
int 	news_node ;
int 	news_pathname ;
int 	news_readonly ;
int 	news_register ;
int 	news_timezone ;
int 	nntp_anu_news_server ;
int 	nntp_client ;
int 	nntp_node ;
int 	nntp_no_posting_allowed ;
int 	nntp_proto ;
int 	node_address ;
int 	no_more_news ;
int 	no_new_item ;
int 	n_class_name ;
int 	old_context ;
int 	organisation_name ;
int 	parse_level ;
int 	pid ;
int 	pid_created ;
int 	post_file ;
int 	print_constant ;
int 	print_file ;
int 	print_save_file ;
int 	problems_encountered ;
int 	profile_dirstr ;
int 	profile_display_lines ;
int 	profile_display_postmark ;
int 	profile_endofitm_cmd ;
int 	profile_filter ;
int 	profile_reply_to ;
int 	profile_scansize ;
int 	reorder_groups ;
int 	scangroups ;
int 	server_call ;
int 	session_is_interactive ;
int 	showdirs_val ;
int 	smg_active ;
int 	status ;
int 	str_target ;
int 	sysprv_off ;
int 	textptr ;
int 	tpuedit ;
int 	tpuview ;
int 	trailer_vd ;
int 	usr_inp ;
int 	usr_inp_dsc ;
int 	usr_inp_l ;
int 	usr_persname ;
int 	usr_username ;
int 	v59_file ;
int 	verbose ;
int 	viewer ;
int 	vms_major ;
int 	vms_minor ;
int 	vms_vers ;
int 	xref_enabled ;
int	try_to_quietly_handle_errors ;
int	usedotnewsrc ;
int	signalled_error_count ;
int	stat_make_space_called ;
int	stat_make_space_succeeded ;
int	stat_make_space_retry_success ;
#endif
